/* src/bazaar.p/bz-root-blocklist.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-blocklist.h"

G_BEGIN_DECLS



#define BZ_TYPE_ROOT_BLOCKLIST (bz_root_blocklist_get_type ())
G_DECLARE_FINAL_TYPE (BzRootBlocklist, bz_root_blocklist, BZ, ROOT_BLOCKLIST, GObject)

BzRootBlocklist *
bz_root_blocklist_new (void);

GListModel *
bz_root_blocklist_get_blocklists (BzRootBlocklist *self);

void
bz_root_blocklist_set_blocklists (BzRootBlocklist *self,
    GListModel *blocklists);

G_END_DECLS

/* End of src/bazaar.p/bz-root-blocklist.h */
