/* src/bazaar.p/bz-curated-section.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-curated-section.h"



struct _BzCuratedSection
{
  GObject parent_instance;

  gboolean expand_horizontally;
  gboolean expand_vertically;
  GListModel *classes;
  GListModel *light_classes;
  GListModel *dark_classes;
  BzCuratedCategoryInfo *category;
  BzCuratedMarkdownInfo *markdown;
  BzCuratedImageInfo *image;
};

G_DEFINE_FINAL_TYPE (BzCuratedSection, bz_curated_section, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_EXPAND_HORIZONTALLY,
  PROP_EXPAND_VERTICALLY,
  PROP_CLASSES,
  PROP_LIGHT_CLASSES,
  PROP_DARK_CLASSES,
  PROP_CATEGORY,
  PROP_MARKDOWN,
  PROP_IMAGE,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_curated_section_dispose (GObject *object)
{
  BzCuratedSection *self = BZ_CURATED_SECTION (object);

  g_clear_pointer (&self->classes, g_object_unref);
  g_clear_pointer (&self->light_classes, g_object_unref);
  g_clear_pointer (&self->dark_classes, g_object_unref);
  g_clear_pointer (&self->category, g_object_unref);
  g_clear_pointer (&self->markdown, g_object_unref);
  g_clear_pointer (&self->image, g_object_unref);

  G_OBJECT_CLASS (bz_curated_section_parent_class)->dispose (object);
}

static void
bz_curated_section_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzCuratedSection *self = BZ_CURATED_SECTION (object);

  switch (prop_id)
    {
    case PROP_EXPAND_HORIZONTALLY:
      g_value_set_boolean (value, bz_curated_section_get_expand_horizontally (self));
      break;
    case PROP_EXPAND_VERTICALLY:
      g_value_set_boolean (value, bz_curated_section_get_expand_vertically (self));
      break;
    case PROP_CLASSES:
      g_value_set_object (value, bz_curated_section_get_classes (self));
      break;
    case PROP_LIGHT_CLASSES:
      g_value_set_object (value, bz_curated_section_get_light_classes (self));
      break;
    case PROP_DARK_CLASSES:
      g_value_set_object (value, bz_curated_section_get_dark_classes (self));
      break;
    case PROP_CATEGORY:
      g_value_set_object (value, bz_curated_section_get_category (self));
      break;
    case PROP_MARKDOWN:
      g_value_set_object (value, bz_curated_section_get_markdown (self));
      break;
    case PROP_IMAGE:
      g_value_set_object (value, bz_curated_section_get_image (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_section_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzCuratedSection *self = BZ_CURATED_SECTION (object);

  switch (prop_id)
    {
    case PROP_EXPAND_HORIZONTALLY:
      bz_curated_section_set_expand_horizontally (self, g_value_get_boolean (value));
      break;
    case PROP_EXPAND_VERTICALLY:
      bz_curated_section_set_expand_vertically (self, g_value_get_boolean (value));
      break;
    case PROP_CLASSES:
      bz_curated_section_set_classes (self, g_value_get_object (value));
      break;
    case PROP_LIGHT_CLASSES:
      bz_curated_section_set_light_classes (self, g_value_get_object (value));
      break;
    case PROP_DARK_CLASSES:
      bz_curated_section_set_dark_classes (self, g_value_get_object (value));
      break;
    case PROP_CATEGORY:
      bz_curated_section_set_category (self, g_value_get_object (value));
      break;
    case PROP_MARKDOWN:
      bz_curated_section_set_markdown (self, g_value_get_object (value));
      break;
    case PROP_IMAGE:
      bz_curated_section_set_image (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_section_class_init (BzCuratedSectionClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_curated_section_set_property;
  object_class->get_property = bz_curated_section_get_property;
  object_class->dispose      = bz_curated_section_dispose;

  props[PROP_EXPAND_HORIZONTALLY] =
      g_param_spec_boolean (
          "expand-horizontally",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_EXPAND_VERTICALLY] =
      g_param_spec_boolean (
          "expand-vertically",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CLASSES] =
      g_param_spec_object (
          "classes",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_LIGHT_CLASSES] =
      g_param_spec_object (
          "light-classes",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DARK_CLASSES] =
      g_param_spec_object (
          "dark-classes",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CATEGORY] =
      g_param_spec_object (
          "category",
          NULL, NULL,
          BZ_TYPE_CURATED_CATEGORY_INFO,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_MARKDOWN] =
      g_param_spec_object (
          "markdown",
          NULL, NULL,
          BZ_TYPE_CURATED_MARKDOWN_INFO,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_IMAGE] =
      g_param_spec_object (
          "image",
          NULL, NULL,
          BZ_TYPE_CURATED_IMAGE_INFO,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_curated_section_init (BzCuratedSection *self)
{
}

BzCuratedSection *
bz_curated_section_new (void){
  return g_object_new (BZ_TYPE_CURATED_SECTION, NULL);
}

gboolean
bz_curated_section_get_expand_horizontally (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), FALSE);
  return self->expand_horizontally;
}

gboolean
bz_curated_section_get_expand_vertically (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), FALSE);
  return self->expand_vertically;
}

GListModel *
bz_curated_section_get_classes (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), NULL);
  return self->classes;
}

GListModel *
bz_curated_section_get_light_classes (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), NULL);
  return self->light_classes;
}

GListModel *
bz_curated_section_get_dark_classes (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), NULL);
  return self->dark_classes;
}

BzCuratedCategoryInfo *
bz_curated_section_get_category (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), NULL);
  return self->category;
}

BzCuratedMarkdownInfo *
bz_curated_section_get_markdown (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), NULL);
  return self->markdown;
}

BzCuratedImageInfo *
bz_curated_section_get_image (BzCuratedSection *self){
  g_return_val_if_fail (BZ_IS_CURATED_SECTION (self), NULL);
  return self->image;
}

void
bz_curated_section_set_expand_horizontally (BzCuratedSection *self,
    gboolean expand_horizontally){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (!!expand_horizontally == !!self->expand_horizontally)
    return;

  self->expand_horizontally = expand_horizontally;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_EXPAND_HORIZONTALLY]);
}

void
bz_curated_section_set_expand_vertically (BzCuratedSection *self,
    gboolean expand_vertically){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (!!expand_vertically == !!self->expand_vertically)
    return;

  self->expand_vertically = expand_vertically;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_EXPAND_VERTICALLY]);
}

void
bz_curated_section_set_classes (BzCuratedSection *self,
    GListModel *classes){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (classes == self->classes)
    return;

  g_clear_pointer (&self->classes, g_object_unref);
  if (classes != NULL)
    self->classes = g_object_ref (classes);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CLASSES]);
}

void
bz_curated_section_set_light_classes (BzCuratedSection *self,
    GListModel *light_classes){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (light_classes == self->light_classes)
    return;

  g_clear_pointer (&self->light_classes, g_object_unref);
  if (light_classes != NULL)
    self->light_classes = g_object_ref (light_classes);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_LIGHT_CLASSES]);
}

void
bz_curated_section_set_dark_classes (BzCuratedSection *self,
    GListModel *dark_classes){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (dark_classes == self->dark_classes)
    return;

  g_clear_pointer (&self->dark_classes, g_object_unref);
  if (dark_classes != NULL)
    self->dark_classes = g_object_ref (dark_classes);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DARK_CLASSES]);
}

void
bz_curated_section_set_category (BzCuratedSection *self,
    BzCuratedCategoryInfo *category){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (category == self->category)
    return;

  g_clear_pointer (&self->category, g_object_unref);
  if (category != NULL)
    self->category = g_object_ref (category);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CATEGORY]);
}

void
bz_curated_section_set_markdown (BzCuratedSection *self,
    BzCuratedMarkdownInfo *markdown){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (markdown == self->markdown)
    return;

  g_clear_pointer (&self->markdown, g_object_unref);
  if (markdown != NULL)
    self->markdown = g_object_ref (markdown);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_MARKDOWN]);
}

void
bz_curated_section_set_image (BzCuratedSection *self,
    BzCuratedImageInfo *image){
  g_return_if_fail (BZ_IS_CURATED_SECTION (self));

  if (image == self->image)
    return;

  g_clear_pointer (&self->image, g_object_unref);
  if (image != NULL)
    self->image = g_object_ref (image);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_IMAGE]);
}

/* End of src/bazaar.p/bz-curated-section.c */
