/* src/bazaar.p/bz-curated-markdown-info.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-curated-markdown-info.h"



struct _BzCuratedMarkdownInfo
{
  GObject parent_instance;

  char *string;
};

G_DEFINE_FINAL_TYPE (BzCuratedMarkdownInfo, bz_curated_markdown_info, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_STRING,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_curated_markdown_info_dispose (GObject *object)
{
  BzCuratedMarkdownInfo *self = BZ_CURATED_MARKDOWN_INFO (object);

  g_clear_pointer (&self->string, g_free);

  G_OBJECT_CLASS (bz_curated_markdown_info_parent_class)->dispose (object);
}

static void
bz_curated_markdown_info_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzCuratedMarkdownInfo *self = BZ_CURATED_MARKDOWN_INFO (object);

  switch (prop_id)
    {
    case PROP_STRING:
      g_value_set_string (value, bz_curated_markdown_info_get_string (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_markdown_info_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzCuratedMarkdownInfo *self = BZ_CURATED_MARKDOWN_INFO (object);

  switch (prop_id)
    {
    case PROP_STRING:
      bz_curated_markdown_info_set_string (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_markdown_info_class_init (BzCuratedMarkdownInfoClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_curated_markdown_info_set_property;
  object_class->get_property = bz_curated_markdown_info_get_property;
  object_class->dispose      = bz_curated_markdown_info_dispose;

  props[PROP_STRING] =
      g_param_spec_string (
          "string",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_curated_markdown_info_init (BzCuratedMarkdownInfo *self)
{
}

BzCuratedMarkdownInfo *
bz_curated_markdown_info_new (void){
  return g_object_new (BZ_TYPE_CURATED_MARKDOWN_INFO, NULL);
}

const char *
bz_curated_markdown_info_get_string (BzCuratedMarkdownInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_MARKDOWN_INFO (self), NULL);
  return self->string;
}

void
bz_curated_markdown_info_set_string (BzCuratedMarkdownInfo *self,
    const char *string){
  g_return_if_fail (BZ_IS_CURATED_MARKDOWN_INFO (self));

  if (string == self->string || (string != NULL && self->string != NULL && g_strcmp0(string, self->string) == 0))
    return;

  g_clear_pointer (&self->string, g_free);
  if (string != NULL)
    self->string = g_strdup (string);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_STRING]);
}

/* End of src/bazaar.p/bz-curated-markdown-info.c */
