// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "BackgroundProperty.h"
#include "BorderProperty.h"
#include "CornersProperty.h"
#include "IconProperty.h"
#include "LayoutProperty.h"
#include "OutlineProperty.h"
#include "ShadowProperty.h"
#include "TextProperty.h"

#include "PropertiesTypes.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class StylePropertyPrivate;

/*!
\class Union::Properties::StyleProperty
\inmodule core
\ingroup core-properties

\brief The root property group for all elements.

This class contains all the properties that are used to style an element.

*/
class UNION_EXPORT StyleProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    StyleProperty();
    /*!
     * Copy constructor.
     */
    StyleProperty(const StyleProperty &other);
    /*!
     * Move constructor.
     */
    StyleProperty(StyleProperty &&other);
    ~StyleProperty();

    /*!
     * Copy assignment operator.
     */
    StyleProperty &operator=(const StyleProperty &other);
    /*!
     * Move assignment operator.
     */
    StyleProperty &operator=(StyleProperty &&other);

    /*!
     * Returns layout if set or nullptr if not.
     */
    LayoutProperty *layout() const;

    /*!
     * Set the value of layout.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setLayout(std::unique_ptr<LayoutProperty> &&newValue);

    /*!
     * Returns text if set or nullptr if not.
     */
    TextProperty *text() const;

    /*!
     * Set the value of text.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setText(std::unique_ptr<TextProperty> &&newValue);

    /*!
     * Returns icon if set or nullptr if not.
     */
    IconProperty *icon() const;

    /*!
     * Set the value of icon.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setIcon(std::unique_ptr<IconProperty> &&newValue);

    /*!
     * Returns background if set or nullptr if not.
     */
    BackgroundProperty *background() const;

    /*!
     * Set the value of background.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBackground(std::unique_ptr<BackgroundProperty> &&newValue);

    /*!
     * Returns border if set or nullptr if not.
     */
    BorderProperty *border() const;

    /*!
     * Set the value of border.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBorder(std::unique_ptr<BorderProperty> &&newValue);

    /*!
     * Returns outline if set or nullptr if not.
     */
    OutlineProperty *outline() const;

    /*!
     * Set the value of outline.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setOutline(std::unique_ptr<OutlineProperty> &&newValue);

    /*!
     * Returns corners if set or nullptr if not.
     */
    CornersProperty *corners() const;

    /*!
     * Set the value of corners.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setCorners(std::unique_ptr<CornersProperty> &&newValue);

    /*!
     * Returns shadow if set or nullptr if not.
     */
    ShadowProperty *shadow() const;

    /*!
     * Set the value of shadow.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setShadow(std::unique_ptr<ShadowProperty> &&newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Returns a string representation of this property group.
     *
     * This is intended for debugging.
     *
     * \a indentation The amount of indentation to apply. Defaults to 0.
     * \a flags A set of flags that control conversion behavior.
     */
    QString toString(int indentation = 0, ToStringFlags flags = ToStringFlags{}) const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const StyleProperty *source, StyleProperty *destination);

    /*!
     * Create and return an empty StyleProperty instance.
     *
     * This will create an empty StyleProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static std::unique_ptr<StyleProperty> empty();

private:
    std::unique_ptr<StylePropertyPrivate> d;
};

/*!
 * \relates Union::Properties::StyleProperty
 * Equality comparison for StyleProperty.
 */
UNION_EXPORT bool operator==(const StyleProperty &left, const StyleProperty &right);
}
}

/*!
 * \relates Union::Properties::StyleProperty
 * QDebug support for StyleProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, Union::Properties::StyleProperty *type);