// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Defines all the command-line switches used by native theme

#ifndef UI_NATIVE_THEME_NATIVE_THEME_FEATURES_H_
#define UI_NATIVE_THEME_NATIVE_THEME_FEATURES_H_

#include "base/feature_list.h"
#include "ui/native_theme/native_theme_export.h"

namespace features {

NATIVE_THEME_EXPORT BASE_DECLARE_FEATURE(kOverlayScrollbar);
NATIVE_THEME_EXPORT BASE_DECLARE_FEATURE(kScrollbarAnimations);

#if BUILDFLAG(IS_CHROMEOS)
NATIVE_THEME_EXPORT BASE_DECLARE_FEATURE(kOverlayScrollbarsOSSetting);
NATIVE_THEME_EXPORT bool IsOverlayScrollbarOSSettingEnabled();
#endif

NATIVE_THEME_EXPORT BASE_DECLARE_FEATURE(kFluentScrollbar);
NATIVE_THEME_EXPORT BASE_DECLARE_FEATURE(kFluentOverlayScrollbar);
NATIVE_THEME_EXPORT BASE_DECLARE_FEATURE(
    kModifyScrollbarCssColorOnHoverOrPress);

}  // namespace features

namespace ui {

NATIVE_THEME_EXPORT bool IsFluentOverlayScrollbarEnabled();
NATIVE_THEME_EXPORT bool IsFluentScrollbarEnabled();

NATIVE_THEME_EXPORT bool IsOverlayScrollbarEnabledByFeatureFlag();
NATIVE_THEME_EXPORT bool IsModifyScrollbarCssColorOnHoverOrPressEnabled();

}  // namespace ui

#endif  // UI_NATIVE_THEME_NATIVE_THEME_FEATURES_H_
