// third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class FrameReplicationStateDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FrameReplicationStateDataView> {
  using Data = ::blink::mojom::internal::FrameReplicationState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class FrameReplicationStateDataView {
 public:
  FrameReplicationStateDataView() = default;

  FrameReplicationStateDataView(
      internal::FrameReplicationState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUniqueNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUniqueName(UserType* output) {
    
    auto* pointer = data_->unique_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPermissionsPolicyHeaderDataView(
      mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionsPolicyHeader(UserType* output) {
    
    auto* pointer = data_->permissions_policy_header.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadActiveSandboxFlags(UserType* output) const {
    auto data_value = data_->active_sandbox_flags;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }
  ::network::mojom::WebSandboxFlags active_sandbox_flags() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSandboxFlags>(data_->active_sandbox_flags));
  }
  inline void GetFramePolicyDataView(
      ::blink::mojom::FramePolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFramePolicy(UserType* output) {
    
    auto* pointer = data_->frame_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::FramePolicyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInsecureRequestPolicy(UserType* output) const {
    auto data_value = data_->insecure_request_policy;
    return mojo::internal::Deserialize<::blink::mojom::InsecureRequestPolicy>(
        data_value, output);
  }
  ::blink::mojom::InsecureRequestPolicy insecure_request_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InsecureRequestPolicy>(data_->insecure_request_policy));
  }
  inline void GetInsecureNavigationsSetDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInsecureNavigationsSet(UserType* output) {
    
    auto* pointer = data_->insecure_navigations_set.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  bool has_potentially_trustworthy_unique_origin() const {
    return data_->has_potentially_trustworthy_unique_origin;
  }
  bool has_active_user_gesture() const {
    return data_->has_active_user_gesture;
  }
  bool has_received_user_gesture_before_nav() const {
    return data_->has_received_user_gesture_before_nav;
  }
  bool is_ad_frame() const {
    return data_->is_ad_frame;
  }
 private:
  internal::FrameReplicationState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameReplicationStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameReplicationStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FrameReplicationState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in FrameReplicationState struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FrameReplicationState struct");
    decltype(Traits::unique_name(input)) in_unique_name = Traits::unique_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unique_name)::BaseType> unique_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_unique_name, unique_name_fragment);
    fragment->unique_name.Set(
        unique_name_fragment.is_null() ? nullptr : unique_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->unique_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null unique_name in FrameReplicationState struct");
    decltype(Traits::permissions_policy_header(input)) in_permissions_policy_header = Traits::permissions_policy_header(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permissions_policy_header)::BaseType>
        permissions_policy_header_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permissions_policy_header_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        in_permissions_policy_header, permissions_policy_header_fragment, &permissions_policy_header_validate_params);
    fragment->permissions_policy_header.Set(
        permissions_policy_header_fragment.is_null() ? nullptr : permissions_policy_header_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->permissions_policy_header.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permissions_policy_header in FrameReplicationState struct");
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
        Traits::active_sandbox_flags(input), &fragment->active_sandbox_flags);
    decltype(Traits::frame_policy(input)) in_frame_policy = Traits::frame_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_policy)::BaseType> frame_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
        in_frame_policy, frame_policy_fragment);
    fragment->frame_policy.Set(
        frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_policy in FrameReplicationState struct");
    mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
        Traits::insecure_request_policy(input), &fragment->insecure_request_policy);
    decltype(Traits::insecure_navigations_set(input)) in_insecure_navigations_set = Traits::insecure_navigations_set(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->insecure_navigations_set)::BaseType>
        insecure_navigations_set_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& insecure_navigations_set_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_insecure_navigations_set, insecure_navigations_set_fragment, &insecure_navigations_set_validate_params);
    fragment->insecure_navigations_set.Set(
        insecure_navigations_set_fragment.is_null() ? nullptr : insecure_navigations_set_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->insecure_navigations_set.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null insecure_navigations_set in FrameReplicationState struct");
    fragment->has_potentially_trustworthy_unique_origin = Traits::has_potentially_trustworthy_unique_origin(input);
    fragment->has_active_user_gesture = Traits::has_active_user_gesture(input);
    fragment->has_received_user_gesture_before_nav = Traits::has_received_user_gesture_before_nav(input);
    fragment->is_ad_frame = Traits::is_ad_frame(input);
  }

  static bool Deserialize(::blink::mojom::internal::FrameReplicationState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameReplicationStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FrameReplicationStateDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetUniqueNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->unique_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetPermissionsPolicyHeaderDataView(
    mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->permissions_policy_header.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void FrameReplicationStateDataView::GetFramePolicyDataView(
    ::blink::mojom::FramePolicyDataView* output) {
  auto pointer = data_->frame_policy.Get();
  *output = ::blink::mojom::FramePolicyDataView(pointer, message_);
}
inline void FrameReplicationStateDataView::GetInsecureNavigationsSetDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->insecure_navigations_set.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_SHARED_H_