// third_party/blink/public/mojom/cache_storage/cache_storage.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class CacheStorageCacheProxy;

template <typename ImplRefTraits>
class CacheStorageCacheStub;

class CacheStorageCacheRequestValidator;
class CacheStorageCacheResponseValidator;


class BLINK_COMMON_EXPORT CacheStorageCache
    : public CacheStorageCacheInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CacheStorageCacheInterfaceBase;
  using Proxy_ = CacheStorageCacheProxy;

  template <typename ImplRefTraits>
  using Stub_ = CacheStorageCacheStub<ImplRefTraits>;

  using RequestValidator_ = CacheStorageCacheRequestValidator;
  using ResponseValidator_ = CacheStorageCacheResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMatchMinVersion = 0,
    kMatchAllMinVersion = 0,
    kGetAllMatchedEntriesMinVersion = 0,
    kKeysMinVersion = 0,
    kBatchMinVersion = 0,
    kWriteSideDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Match_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MatchAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllMatchedEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Keys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Batch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteSideData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CacheStorageCache() = default;


  using MatchCallback = base::OnceCallback<void(MatchResultPtr)>;
  
  virtual void Match(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) = 0;


  using MatchAllCallback = base::OnceCallback<void(MatchAllResultPtr)>;
  
  virtual void MatchAll(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, MatchAllCallback callback) = 0;


  using GetAllMatchedEntriesCallback = base::OnceCallback<void(GetAllMatchedEntriesResultPtr)>;
  
  virtual void GetAllMatchedEntries(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, GetAllMatchedEntriesCallback callback) = 0;


  using KeysCallback = base::OnceCallback<void(CacheKeysResultPtr)>;
  
  virtual void Keys(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, KeysCallback callback) = 0;


  using BatchCallback = base::OnceCallback<void(CacheStorageVerboseErrorPtr)>;
  
  virtual void Batch(std::vector<BatchOperationPtr> batch_operations, int64_t trace_id, BatchCallback callback) = 0;


  using WriteSideDataCallback = base::OnceCallback<void(CacheStorageError)>;
  
  virtual void WriteSideData(const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, WriteSideDataCallback callback) = 0;
};

class CacheStorageProxy;

template <typename ImplRefTraits>
class CacheStorageStub;

class CacheStorageRequestValidator;
class CacheStorageResponseValidator;


class BLINK_COMMON_EXPORT CacheStorage
    : public CacheStorageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CacheStorageInterfaceBase;
  using Proxy_ = CacheStorageProxy;

  template <typename ImplRefTraits>
  using Stub_ = CacheStorageStub<ImplRefTraits>;

  using RequestValidator_ = CacheStorageRequestValidator;
  using ResponseValidator_ = CacheStorageResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasMinVersion = 0,
    kDeleteMinVersion = 0,
    kKeysMinVersion = 0,
    kMatchMinVersion = 0,
    kOpenMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Has_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Keys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Match_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Open_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CacheStorage() = default;


  using HasCallback = base::OnceCallback<void(CacheStorageError)>;
  
  virtual void Has(const ::std::u16string& cache_name, int64_t trace_id, HasCallback callback) = 0;


  using DeleteCallback = base::OnceCallback<void(CacheStorageError)>;
  
  virtual void Delete(const ::std::u16string& cache_name, int64_t trace_id, DeleteCallback callback) = 0;


  using KeysCallback = base::OnceCallback<void(const std::vector<::std::u16string>&)>;
  
  virtual void Keys(int64_t trace_id, KeysCallback callback) = 0;


  using MatchCallback = base::OnceCallback<void(MatchResultPtr)>;
  
  virtual void Match(::blink::mojom::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) = 0;


  using OpenCallback = base::OnceCallback<void(OpenResultPtr)>;
  
  virtual void Open(const ::std::u16string& cache_name, int64_t trace_id, OpenCallback callback) = 0;
};



class BLINK_COMMON_EXPORT CacheStorageCacheProxy
    : public CacheStorageCache {
 public:
  using InterfaceType = CacheStorageCache;

  explicit CacheStorageCacheProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Match(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) final;
  
  void MatchAll(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, MatchAllCallback callback) final;
  
  void GetAllMatchedEntries(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, GetAllMatchedEntriesCallback callback) final;
  
  void Keys(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, KeysCallback callback) final;
  
  void Batch(std::vector<BatchOperationPtr> batch_operations, int64_t trace_id, BatchCallback callback) final;
  
  void WriteSideData(const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, WriteSideDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT CacheStorageProxy
    : public CacheStorage {
 public:
  using InterfaceType = CacheStorage;

  explicit CacheStorageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Has(const ::std::u16string& cache_name, int64_t trace_id, HasCallback callback) final;
  
  void Delete(const ::std::u16string& cache_name, int64_t trace_id, DeleteCallback callback) final;
  
  void Keys(int64_t trace_id, KeysCallback callback) final;
  
  void Match(::blink::mojom::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) final;
  
  void Open(const ::std::u16string& cache_name, int64_t trace_id, OpenCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT CacheStorageCacheStubDispatch {
 public:
  static bool Accept(CacheStorageCache* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CacheStorageCache* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CacheStorageCache>>
class CacheStorageCacheStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CacheStorageCacheStub() = default;
  ~CacheStorageCacheStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageCacheStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageCacheStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT CacheStorageStubDispatch {
 public:
  static bool Accept(CacheStorage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CacheStorage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CacheStorage>>
class CacheStorageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CacheStorageStub() = default;
  ~CacheStorageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT CacheStorageCacheRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT CacheStorageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT CacheStorageCacheResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT CacheStorageResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT CacheStorageVerboseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CacheStorageVerboseError, T>::value>;
  using DataView = CacheStorageVerboseErrorDataView;
  using Data_ = internal::CacheStorageVerboseError_Data;

  template <typename... Args>
  static CacheStorageVerboseErrorPtr New(Args&&... args) {
    return CacheStorageVerboseErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CacheStorageVerboseErrorPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorageVerboseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorageVerboseError>::Convert(*this);
  }


  CacheStorageVerboseError();

  CacheStorageVerboseError(
      CacheStorageError value,
      const std::optional<std::string>& message);


  ~CacheStorageVerboseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CacheStorageVerboseErrorPtr>
  CacheStorageVerboseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CacheStorageVerboseError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorageVerboseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CacheStorageVerboseError_UnserializedMessageContext<
            UserType, CacheStorageVerboseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CacheStorageVerboseError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CacheStorageVerboseError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CacheStorageVerboseError_UnserializedMessageContext<
            UserType, CacheStorageVerboseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CacheStorageVerboseError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CacheStorageError value;
  
  std::optional<std::string> message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CacheQueryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CacheQueryOptions, T>::value>;
  using DataView = CacheQueryOptionsDataView;
  using Data_ = internal::CacheQueryOptions_Data;

  template <typename... Args>
  static CacheQueryOptionsPtr New(Args&&... args) {
    return CacheQueryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CacheQueryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CacheQueryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheQueryOptions>::Convert(*this);
  }


  CacheQueryOptions();

  CacheQueryOptions(
      bool ignore_search,
      bool ignore_method,
      bool ignore_vary);


  ~CacheQueryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CacheQueryOptionsPtr>
  CacheQueryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CacheQueryOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheQueryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CacheQueryOptions_UnserializedMessageContext<
            UserType, CacheQueryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CacheQueryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CacheQueryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CacheQueryOptions_UnserializedMessageContext<
            UserType, CacheQueryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CacheQueryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool ignore_search;
  
  bool ignore_method;
  
  bool ignore_vary;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT OpenResult {
 public:
  using DataView = OpenResultDataView;
  using Data_ = internal::OpenResult_Data;
  using Tag = Data_::OpenResult_Tag;

  template <typename... Args>
  static OpenResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |status|.
  static OpenResultPtr
  NewStatus(
      CacheStorageError value) {
    auto result = OpenResultPtr(std::in_place);
    result->set_status(std::move(value));
    return result;
  }
  // Construct an instance holding |cache|.
  static OpenResultPtr
  NewCache(
      ::mojo::PendingAssociatedRemote<CacheStorageCache> value) {
    auto result = OpenResultPtr(std::in_place);
    result->set_cache(std::move(value));
    return result;
  }

  template <typename U>
  static OpenResultPtr From(const U& u) {
    return mojo::TypeConverter<OpenResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenResult>::Convert(*this);
  }

  OpenResult();
  ~OpenResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  OpenResult(const OpenResult& other) = delete;
  OpenResult& operator=(const OpenResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = OpenResultPtr>
  OpenResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, OpenResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, OpenResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_status() const { return tag_ == Tag::kStatus; }

  
  CacheStorageError get_status() const {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }

  
  void set_status(
      CacheStorageError status);
  
  bool is_cache() const { return tag_ == Tag::kCache; }

  
  ::mojo::PendingAssociatedRemote<CacheStorageCache>& get_cache() const {
    CHECK(tag_ == Tag::kCache);
    return *(data_.cache);
  }

  
  void set_cache(
      ::mojo::PendingAssociatedRemote<CacheStorageCache> cache);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<OpenResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    CacheStorageError status;
    ::mojo::PendingAssociatedRemote<CacheStorageCache>* cache;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT MatchResult {
 public:
  using DataView = MatchResultDataView;
  using Data_ = internal::MatchResult_Data;
  using Tag = Data_::MatchResult_Tag;

  template <typename... Args>
  static MatchResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |status|.
  static MatchResultPtr
  NewStatus(
      CacheStorageError value) {
    auto result = MatchResultPtr(std::in_place);
    result->set_status(std::move(value));
    return result;
  }
  // Construct an instance holding |response|.
  static MatchResultPtr
  NewResponse(
      ::blink::mojom::FetchAPIResponsePtr value) {
    auto result = MatchResultPtr(std::in_place);
    result->set_response(std::move(value));
    return result;
  }
  // Construct an instance holding |eager_response|.
  static MatchResultPtr
  NewEagerResponse(
      EagerResponsePtr value) {
    auto result = MatchResultPtr(std::in_place);
    result->set_eager_response(std::move(value));
    return result;
  }

  template <typename U>
  static MatchResultPtr From(const U& u) {
    return mojo::TypeConverter<MatchResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MatchResult>::Convert(*this);
  }

  MatchResult();
  ~MatchResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MatchResult(const MatchResult& other) = delete;
  MatchResult& operator=(const MatchResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MatchResultPtr>
  MatchResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MatchResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MatchResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_status() const { return tag_ == Tag::kStatus; }

  
  CacheStorageError get_status() const {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }

  
  void set_status(
      CacheStorageError status);
  
  bool is_response() const { return tag_ == Tag::kResponse; }

  
  ::blink::mojom::FetchAPIResponsePtr& get_response() const {
    CHECK(tag_ == Tag::kResponse);
    return *(data_.response);
  }

  
  void set_response(
      ::blink::mojom::FetchAPIResponsePtr response);
  
  bool is_eager_response() const { return tag_ == Tag::kEagerResponse; }

  
  EagerResponsePtr& get_eager_response() const {
    CHECK(tag_ == Tag::kEagerResponse);
    return *(data_.eager_response);
  }

  
  void set_eager_response(
      EagerResponsePtr eager_response);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MatchResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MatchResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    CacheStorageError status;
    ::blink::mojom::FetchAPIResponsePtr* response;
    EagerResponsePtr* eager_response;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT MatchAllResult {
 public:
  using DataView = MatchAllResultDataView;
  using Data_ = internal::MatchAllResult_Data;
  using Tag = Data_::MatchAllResult_Tag;

  template <typename... Args>
  static MatchAllResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |status|.
  static MatchAllResultPtr
  NewStatus(
      CacheStorageError value) {
    auto result = MatchAllResultPtr(std::in_place);
    result->set_status(std::move(value));
    return result;
  }
  // Construct an instance holding |responses|.
  static MatchAllResultPtr
  NewResponses(
      std::vector<::blink::mojom::FetchAPIResponsePtr> value) {
    auto result = MatchAllResultPtr(std::in_place);
    result->set_responses(std::move(value));
    return result;
  }

  template <typename U>
  static MatchAllResultPtr From(const U& u) {
    return mojo::TypeConverter<MatchAllResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MatchAllResult>::Convert(*this);
  }

  MatchAllResult();
  ~MatchAllResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MatchAllResult(const MatchAllResult& other) = delete;
  MatchAllResult& operator=(const MatchAllResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MatchAllResultPtr>
  MatchAllResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MatchAllResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MatchAllResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_status() const { return tag_ == Tag::kStatus; }

  
  CacheStorageError get_status() const {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }

  
  void set_status(
      CacheStorageError status);
  
  bool is_responses() const { return tag_ == Tag::kResponses; }

  
  std::vector<::blink::mojom::FetchAPIResponsePtr>& get_responses() const {
    CHECK(tag_ == Tag::kResponses);
    return *(data_.responses);
  }

  
  void set_responses(
      std::vector<::blink::mojom::FetchAPIResponsePtr> responses);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MatchAllResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MatchAllResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    CacheStorageError status;
    std::vector<::blink::mojom::FetchAPIResponsePtr>* responses;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT GetAllMatchedEntriesResult {
 public:
  using DataView = GetAllMatchedEntriesResultDataView;
  using Data_ = internal::GetAllMatchedEntriesResult_Data;
  using Tag = Data_::GetAllMatchedEntriesResult_Tag;

  template <typename... Args>
  static GetAllMatchedEntriesResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |status|.
  static GetAllMatchedEntriesResultPtr
  NewStatus(
      CacheStorageError value) {
    auto result = GetAllMatchedEntriesResultPtr(std::in_place);
    result->set_status(std::move(value));
    return result;
  }
  // Construct an instance holding |entries|.
  static GetAllMatchedEntriesResultPtr
  NewEntries(
      std::vector<CacheEntryPtr> value) {
    auto result = GetAllMatchedEntriesResultPtr(std::in_place);
    result->set_entries(std::move(value));
    return result;
  }

  template <typename U>
  static GetAllMatchedEntriesResultPtr From(const U& u) {
    return mojo::TypeConverter<GetAllMatchedEntriesResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetAllMatchedEntriesResult>::Convert(*this);
  }

  GetAllMatchedEntriesResult();
  ~GetAllMatchedEntriesResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetAllMatchedEntriesResult(const GetAllMatchedEntriesResult& other) = delete;
  GetAllMatchedEntriesResult& operator=(const GetAllMatchedEntriesResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetAllMatchedEntriesResultPtr>
  GetAllMatchedEntriesResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetAllMatchedEntriesResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetAllMatchedEntriesResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_status() const { return tag_ == Tag::kStatus; }

  
  CacheStorageError get_status() const {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }

  
  void set_status(
      CacheStorageError status);
  
  bool is_entries() const { return tag_ == Tag::kEntries; }

  
  std::vector<CacheEntryPtr>& get_entries() const {
    CHECK(tag_ == Tag::kEntries);
    return *(data_.entries);
  }

  
  void set_entries(
      std::vector<CacheEntryPtr> entries);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetAllMatchedEntriesResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetAllMatchedEntriesResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    CacheStorageError status;
    std::vector<CacheEntryPtr>* entries;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT CacheKeysResult {
 public:
  using DataView = CacheKeysResultDataView;
  using Data_ = internal::CacheKeysResult_Data;
  using Tag = Data_::CacheKeysResult_Tag;

  template <typename... Args>
  static CacheKeysResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |status|.
  static CacheKeysResultPtr
  NewStatus(
      CacheStorageError value) {
    auto result = CacheKeysResultPtr(std::in_place);
    result->set_status(std::move(value));
    return result;
  }
  // Construct an instance holding |keys|.
  static CacheKeysResultPtr
  NewKeys(
      std::vector<::blink::mojom::FetchAPIRequestPtr> value) {
    auto result = CacheKeysResultPtr(std::in_place);
    result->set_keys(std::move(value));
    return result;
  }

  template <typename U>
  static CacheKeysResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheKeysResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheKeysResult>::Convert(*this);
  }

  CacheKeysResult();
  ~CacheKeysResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheKeysResult(const CacheKeysResult& other) = delete;
  CacheKeysResult& operator=(const CacheKeysResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheKeysResultPtr>
  CacheKeysResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheKeysResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheKeysResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_status() const { return tag_ == Tag::kStatus; }

  
  CacheStorageError get_status() const {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }

  
  void set_status(
      CacheStorageError status);
  
  bool is_keys() const { return tag_ == Tag::kKeys; }

  
  std::vector<::blink::mojom::FetchAPIRequestPtr>& get_keys() const {
    CHECK(tag_ == Tag::kKeys);
    return *(data_.keys);
  }

  
  void set_keys(
      std::vector<::blink::mojom::FetchAPIRequestPtr> keys);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheKeysResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheKeysResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    CacheStorageError status;
    std::vector<::blink::mojom::FetchAPIRequestPtr>* keys;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};







class BLINK_COMMON_EXPORT MultiCacheQueryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MultiCacheQueryOptions, T>::value>;
  using DataView = MultiCacheQueryOptionsDataView;
  using Data_ = internal::MultiCacheQueryOptions_Data;

  template <typename... Args>
  static MultiCacheQueryOptionsPtr New(Args&&... args) {
    return MultiCacheQueryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MultiCacheQueryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<MultiCacheQueryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MultiCacheQueryOptions>::Convert(*this);
  }


  MultiCacheQueryOptions();

  MultiCacheQueryOptions(
      CacheQueryOptionsPtr query_options,
      const std::optional<::std::u16string>& cache_name);

MultiCacheQueryOptions(const MultiCacheQueryOptions&) = delete;
MultiCacheQueryOptions& operator=(const MultiCacheQueryOptions&) = delete;

  ~MultiCacheQueryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MultiCacheQueryOptionsPtr>
  MultiCacheQueryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MultiCacheQueryOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MultiCacheQueryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MultiCacheQueryOptions_UnserializedMessageContext<
            UserType, MultiCacheQueryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MultiCacheQueryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MultiCacheQueryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MultiCacheQueryOptions_UnserializedMessageContext<
            UserType, MultiCacheQueryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MultiCacheQueryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CacheQueryOptionsPtr query_options;
  
  std::optional<::std::u16string> cache_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT BatchOperation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BatchOperation, T>::value>;
  using DataView = BatchOperationDataView;
  using Data_ = internal::BatchOperation_Data;

  template <typename... Args>
  static BatchOperationPtr New(Args&&... args) {
    return BatchOperationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BatchOperationPtr From(const U& u) {
    return mojo::TypeConverter<BatchOperationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BatchOperation>::Convert(*this);
  }


  BatchOperation();

  BatchOperation(
      OperationType operation_type,
      ::blink::mojom::FetchAPIRequestPtr request,
      ::blink::mojom::FetchAPIResponsePtr response,
      CacheQueryOptionsPtr match_options);

BatchOperation(const BatchOperation&) = delete;
BatchOperation& operator=(const BatchOperation&) = delete;

  ~BatchOperation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BatchOperationPtr>
  BatchOperationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BatchOperation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BatchOperation_UnserializedMessageContext<
            UserType, BatchOperation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BatchOperation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BatchOperation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BatchOperation_UnserializedMessageContext<
            UserType, BatchOperation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BatchOperation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  OperationType operation_type;
  
  ::blink::mojom::FetchAPIRequestPtr request;
  
  ::blink::mojom::FetchAPIResponsePtr response;
  
  CacheQueryOptionsPtr match_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT EagerResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EagerResponse, T>::value>;
  using DataView = EagerResponseDataView;
  using Data_ = internal::EagerResponse_Data;

  template <typename... Args>
  static EagerResponsePtr New(Args&&... args) {
    return EagerResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EagerResponsePtr From(const U& u) {
    return mojo::TypeConverter<EagerResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EagerResponse>::Convert(*this);
  }


  EagerResponse();

  EagerResponse(
      ::blink::mojom::FetchAPIResponsePtr response,
      ::mojo::ScopedDataPipeConsumerHandle pipe,
      ::mojo::PendingReceiver<::blink::mojom::BlobReaderClient> client_receiver);

EagerResponse(const EagerResponse&) = delete;
EagerResponse& operator=(const EagerResponse&) = delete;

  ~EagerResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EagerResponsePtr>
  EagerResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EagerResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EagerResponse_UnserializedMessageContext<
            UserType, EagerResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EagerResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EagerResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EagerResponse_UnserializedMessageContext<
            UserType, EagerResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EagerResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::FetchAPIResponsePtr response;
  
  ::mojo::ScopedDataPipeConsumerHandle pipe;
  
  ::mojo::PendingReceiver<::blink::mojom::BlobReaderClient> client_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CacheEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CacheEntry, T>::value>;
  using DataView = CacheEntryDataView;
  using Data_ = internal::CacheEntry_Data;

  template <typename... Args>
  static CacheEntryPtr New(Args&&... args) {
    return CacheEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CacheEntryPtr From(const U& u) {
    return mojo::TypeConverter<CacheEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheEntry>::Convert(*this);
  }


  CacheEntry();

  CacheEntry(
      ::blink::mojom::FetchAPIRequestPtr request,
      ::blink::mojom::FetchAPIResponsePtr response);

CacheEntry(const CacheEntry&) = delete;
CacheEntry& operator=(const CacheEntry&) = delete;

  ~CacheEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CacheEntryPtr>
  CacheEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CacheEntry_UnserializedMessageContext<
            UserType, CacheEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CacheEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CacheEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CacheEntry_UnserializedMessageContext<
            UserType, CacheEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CacheEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::FetchAPIRequestPtr request;
  
  ::blink::mojom::FetchAPIResponsePtr response;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
OpenResultPtr OpenResult::Clone() const {
  switch (tag_) {
    case Tag::kStatus:
      return NewStatus(
          mojo::Clone(data_.status));
    case Tag::kCache:
      return NewCache(
          mojo::Clone(*data_.cache));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, OpenResult>::value>::type*>
bool OpenResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kStatus:
      return mojo::Equals(data_.status, other.data_.status);
    case Tag::kCache:
      return mojo::Equals(*(data_.cache), *(other.data_.cache));
  }

  return false;
}
template <typename UnionPtrType>
MatchResultPtr MatchResult::Clone() const {
  switch (tag_) {
    case Tag::kStatus:
      return NewStatus(
          mojo::Clone(data_.status));
    case Tag::kResponse:
      return NewResponse(
          mojo::Clone(*data_.response));
    case Tag::kEagerResponse:
      return NewEagerResponse(
          mojo::Clone(*data_.eager_response));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MatchResult>::value>::type*>
bool MatchResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kStatus:
      return mojo::Equals(data_.status, other.data_.status);
    case Tag::kResponse:
      return mojo::Equals(*(data_.response), *(other.data_.response));
    case Tag::kEagerResponse:
      return mojo::Equals(*(data_.eager_response), *(other.data_.eager_response));
  }

  return false;
}
template <typename UnionPtrType>
MatchAllResultPtr MatchAllResult::Clone() const {
  switch (tag_) {
    case Tag::kStatus:
      return NewStatus(
          mojo::Clone(data_.status));
    case Tag::kResponses:
      return NewResponses(
          mojo::Clone(*data_.responses));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MatchAllResult>::value>::type*>
bool MatchAllResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kStatus:
      return mojo::Equals(data_.status, other.data_.status);
    case Tag::kResponses:
      return mojo::Equals(*(data_.responses), *(other.data_.responses));
  }

  return false;
}
template <typename UnionPtrType>
GetAllMatchedEntriesResultPtr GetAllMatchedEntriesResult::Clone() const {
  switch (tag_) {
    case Tag::kStatus:
      return NewStatus(
          mojo::Clone(data_.status));
    case Tag::kEntries:
      return NewEntries(
          mojo::Clone(*data_.entries));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetAllMatchedEntriesResult>::value>::type*>
bool GetAllMatchedEntriesResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kStatus:
      return mojo::Equals(data_.status, other.data_.status);
    case Tag::kEntries:
      return mojo::Equals(*(data_.entries), *(other.data_.entries));
  }

  return false;
}
template <typename UnionPtrType>
CacheKeysResultPtr CacheKeysResult::Clone() const {
  switch (tag_) {
    case Tag::kStatus:
      return NewStatus(
          mojo::Clone(data_.status));
    case Tag::kKeys:
      return NewKeys(
          mojo::Clone(*data_.keys));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheKeysResult>::value>::type*>
bool CacheKeysResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kStatus:
      return mojo::Equals(data_.status, other.data_.status);
    case Tag::kKeys:
      return mojo::Equals(*(data_.keys), *(other.data_.keys));
  }

  return false;
}
template <typename StructPtrType>
CacheStorageVerboseErrorPtr CacheStorageVerboseError::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(message)
  );
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>*>
bool CacheStorageVerboseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
CacheQueryOptionsPtr CacheQueryOptions::Clone() const {
  return New(
      mojo::Clone(ignore_search),
      mojo::Clone(ignore_method),
      mojo::Clone(ignore_vary)
  );
}

template <typename T, CacheQueryOptions::EnableIfSame<T>*>
bool CacheQueryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ignore_search, other_struct.ignore_search))
    return false;
  if (!mojo::Equals(this->ignore_method, other_struct.ignore_method))
    return false;
  if (!mojo::Equals(this->ignore_vary, other_struct.ignore_vary))
    return false;
  return true;
}

template <typename T, CacheQueryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ignore_search < rhs.ignore_search)
    return true;
  if (rhs.ignore_search < lhs.ignore_search)
    return false;
  if (lhs.ignore_method < rhs.ignore_method)
    return true;
  if (rhs.ignore_method < lhs.ignore_method)
    return false;
  if (lhs.ignore_vary < rhs.ignore_vary)
    return true;
  if (rhs.ignore_vary < lhs.ignore_vary)
    return false;
  return false;
}
template <typename StructPtrType>
MultiCacheQueryOptionsPtr MultiCacheQueryOptions::Clone() const {
  return New(
      mojo::Clone(query_options),
      mojo::Clone(cache_name)
  );
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>*>
bool MultiCacheQueryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query_options, other_struct.query_options))
    return false;
  if (!mojo::Equals(this->cache_name, other_struct.cache_name))
    return false;
  return true;
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query_options < rhs.query_options)
    return true;
  if (rhs.query_options < lhs.query_options)
    return false;
  if (lhs.cache_name < rhs.cache_name)
    return true;
  if (rhs.cache_name < lhs.cache_name)
    return false;
  return false;
}
template <typename StructPtrType>
BatchOperationPtr BatchOperation::Clone() const {
  return New(
      mojo::Clone(operation_type),
      mojo::Clone(request),
      mojo::Clone(response),
      mojo::Clone(match_options)
  );
}

template <typename T, BatchOperation::EnableIfSame<T>*>
bool BatchOperation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->operation_type, other_struct.operation_type))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  if (!mojo::Equals(this->match_options, other_struct.match_options))
    return false;
  return true;
}

template <typename T, BatchOperation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.operation_type < rhs.operation_type)
    return true;
  if (rhs.operation_type < lhs.operation_type)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  if (lhs.match_options < rhs.match_options)
    return true;
  if (rhs.match_options < lhs.match_options)
    return false;
  return false;
}
template <typename StructPtrType>
EagerResponsePtr EagerResponse::Clone() const {
  return New(
      mojo::Clone(response),
      mojo::Clone(pipe),
      mojo::Clone(client_receiver)
  );
}

template <typename T, EagerResponse::EnableIfSame<T>*>
bool EagerResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  if (!mojo::Equals(this->pipe, other_struct.pipe))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  return true;
}

template <typename T, EagerResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  if (lhs.pipe < rhs.pipe)
    return true;
  if (rhs.pipe < lhs.pipe)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  return false;
}
template <typename StructPtrType>
CacheEntryPtr CacheEntry::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(response)
  );
}

template <typename T, CacheEntry::EnableIfSame<T>*>
bool CacheEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  return true;
}

template <typename T, CacheEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CacheStorageVerboseError::DataView,
                                         ::blink::mojom::CacheStorageVerboseErrorPtr> {
  static bool IsNull(const ::blink::mojom::CacheStorageVerboseErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CacheStorageVerboseErrorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::CacheStorageVerboseError::value) value(
      const ::blink::mojom::CacheStorageVerboseErrorPtr& input) {
    return input->value;
  }

  static const decltype(::blink::mojom::CacheStorageVerboseError::message)& message(
      const ::blink::mojom::CacheStorageVerboseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::blink::mojom::CacheStorageVerboseError::DataView input, ::blink::mojom::CacheStorageVerboseErrorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CacheQueryOptions::DataView,
                                         ::blink::mojom::CacheQueryOptionsPtr> {
  static bool IsNull(const ::blink::mojom::CacheQueryOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CacheQueryOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::CacheQueryOptions::ignore_search) ignore_search(
      const ::blink::mojom::CacheQueryOptionsPtr& input) {
    return input->ignore_search;
  }

  static decltype(::blink::mojom::CacheQueryOptions::ignore_method) ignore_method(
      const ::blink::mojom::CacheQueryOptionsPtr& input) {
    return input->ignore_method;
  }

  static decltype(::blink::mojom::CacheQueryOptions::ignore_vary) ignore_vary(
      const ::blink::mojom::CacheQueryOptionsPtr& input) {
    return input->ignore_vary;
  }

  static bool Read(::blink::mojom::CacheQueryOptions::DataView input, ::blink::mojom::CacheQueryOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::MultiCacheQueryOptions::DataView,
                                         ::blink::mojom::MultiCacheQueryOptionsPtr> {
  static bool IsNull(const ::blink::mojom::MultiCacheQueryOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MultiCacheQueryOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::MultiCacheQueryOptions::query_options)& query_options(
      const ::blink::mojom::MultiCacheQueryOptionsPtr& input) {
    return input->query_options;
  }

  static const decltype(::blink::mojom::MultiCacheQueryOptions::cache_name)& cache_name(
      const ::blink::mojom::MultiCacheQueryOptionsPtr& input) {
    return input->cache_name;
  }

  static bool Read(::blink::mojom::MultiCacheQueryOptions::DataView input, ::blink::mojom::MultiCacheQueryOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::BatchOperation::DataView,
                                         ::blink::mojom::BatchOperationPtr> {
  static bool IsNull(const ::blink::mojom::BatchOperationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::BatchOperationPtr* output) { output->reset(); }

  static decltype(::blink::mojom::BatchOperation::operation_type) operation_type(
      const ::blink::mojom::BatchOperationPtr& input) {
    return input->operation_type;
  }

  static  decltype(::blink::mojom::BatchOperation::request)& request(
       ::blink::mojom::BatchOperationPtr& input) {
    return input->request;
  }

  static  decltype(::blink::mojom::BatchOperation::response)& response(
       ::blink::mojom::BatchOperationPtr& input) {
    return input->response;
  }

  static const decltype(::blink::mojom::BatchOperation::match_options)& match_options(
      const ::blink::mojom::BatchOperationPtr& input) {
    return input->match_options;
  }

  static bool Read(::blink::mojom::BatchOperation::DataView input, ::blink::mojom::BatchOperationPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::EagerResponse::DataView,
                                         ::blink::mojom::EagerResponsePtr> {
  static bool IsNull(const ::blink::mojom::EagerResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::EagerResponsePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::EagerResponse::response)& response(
       ::blink::mojom::EagerResponsePtr& input) {
    return input->response;
  }

  static  decltype(::blink::mojom::EagerResponse::pipe)& pipe(
       ::blink::mojom::EagerResponsePtr& input) {
    return input->pipe;
  }

  static  decltype(::blink::mojom::EagerResponse::client_receiver)& client_receiver(
       ::blink::mojom::EagerResponsePtr& input) {
    return input->client_receiver;
  }

  static bool Read(::blink::mojom::EagerResponse::DataView input, ::blink::mojom::EagerResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CacheEntry::DataView,
                                         ::blink::mojom::CacheEntryPtr> {
  static bool IsNull(const ::blink::mojom::CacheEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CacheEntryPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::CacheEntry::request)& request(
       ::blink::mojom::CacheEntryPtr& input) {
    return input->request;
  }

  static  decltype(::blink::mojom::CacheEntry::response)& response(
       ::blink::mojom::CacheEntryPtr& input) {
    return input->response;
  }

  static bool Read(::blink::mojom::CacheEntry::DataView input, ::blink::mojom::CacheEntryPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::OpenResult::DataView,
                                        ::blink::mojom::OpenResultPtr> {
  static bool IsNull(const ::blink::mojom::OpenResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::OpenResultPtr* output) { output->reset(); }

  static ::blink::mojom::OpenResult::Tag GetTag(const ::blink::mojom::OpenResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::CacheStorageError status(const ::blink::mojom::OpenResultPtr& input) {
    return input->get_status();
  }

  static  ::mojo::PendingAssociatedRemote<::blink::mojom::CacheStorageCache>& cache( ::blink::mojom::OpenResultPtr& input) {
    return input->get_cache();
  }

  static bool Read(::blink::mojom::OpenResult::DataView input, ::blink::mojom::OpenResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::MatchResult::DataView,
                                        ::blink::mojom::MatchResultPtr> {
  static bool IsNull(const ::blink::mojom::MatchResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MatchResultPtr* output) { output->reset(); }

  static ::blink::mojom::MatchResult::Tag GetTag(const ::blink::mojom::MatchResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::CacheStorageError status(const ::blink::mojom::MatchResultPtr& input) {
    return input->get_status();
  }

  static  ::blink::mojom::FetchAPIResponsePtr& response( ::blink::mojom::MatchResultPtr& input) {
    return input->get_response();
  }

  static  ::blink::mojom::EagerResponsePtr& eager_response( ::blink::mojom::MatchResultPtr& input) {
    return input->get_eager_response();
  }

  static bool Read(::blink::mojom::MatchResult::DataView input, ::blink::mojom::MatchResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::MatchAllResult::DataView,
                                        ::blink::mojom::MatchAllResultPtr> {
  static bool IsNull(const ::blink::mojom::MatchAllResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MatchAllResultPtr* output) { output->reset(); }

  static ::blink::mojom::MatchAllResult::Tag GetTag(const ::blink::mojom::MatchAllResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::CacheStorageError status(const ::blink::mojom::MatchAllResultPtr& input) {
    return input->get_status();
  }

  static  std::vector<::blink::mojom::FetchAPIResponsePtr>& responses( ::blink::mojom::MatchAllResultPtr& input) {
    return input->get_responses();
  }

  static bool Read(::blink::mojom::MatchAllResult::DataView input, ::blink::mojom::MatchAllResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::GetAllMatchedEntriesResult::DataView,
                                        ::blink::mojom::GetAllMatchedEntriesResultPtr> {
  static bool IsNull(const ::blink::mojom::GetAllMatchedEntriesResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetAllMatchedEntriesResultPtr* output) { output->reset(); }

  static ::blink::mojom::GetAllMatchedEntriesResult::Tag GetTag(const ::blink::mojom::GetAllMatchedEntriesResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::CacheStorageError status(const ::blink::mojom::GetAllMatchedEntriesResultPtr& input) {
    return input->get_status();
  }

  static  std::vector<::blink::mojom::CacheEntryPtr>& entries( ::blink::mojom::GetAllMatchedEntriesResultPtr& input) {
    return input->get_entries();
  }

  static bool Read(::blink::mojom::GetAllMatchedEntriesResult::DataView input, ::blink::mojom::GetAllMatchedEntriesResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::CacheKeysResult::DataView,
                                        ::blink::mojom::CacheKeysResultPtr> {
  static bool IsNull(const ::blink::mojom::CacheKeysResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CacheKeysResultPtr* output) { output->reset(); }

  static ::blink::mojom::CacheKeysResult::Tag GetTag(const ::blink::mojom::CacheKeysResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::CacheStorageError status(const ::blink::mojom::CacheKeysResultPtr& input) {
    return input->get_status();
  }

  static  std::vector<::blink::mojom::FetchAPIRequestPtr>& keys( ::blink::mojom::CacheKeysResultPtr& input) {
    return input->get_keys();
  }

  static bool Read(::blink::mojom::CacheKeysResult::DataView input, ::blink::mojom::CacheKeysResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_H_