// services/viz/public/mojom/compositing/shared_quad_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared.h"







namespace viz::mojom {
class SharedQuadStateDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::SharedQuadStateDataView> {
  using Data = ::viz::mojom::internal::SharedQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class SharedQuadStateDataView {
 public:
  SharedQuadStateDataView() = default;

  SharedQuadStateDataView(
      internal::SharedQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQuadToTargetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuadToTargetTransform(UserType* output) {
    
    auto* pointer = data_->quad_to_target_transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetQuadLayerRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuadLayerRect(UserType* output) {
    
    auto* pointer = data_->quad_layer_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleQuadLayerRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleQuadLayerRect(UserType* output) {
    
    auto* pointer = data_->visible_quad_layer_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetMaskFilterInfoDataView(
      ::gfx::mojom::MaskFilterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaskFilterInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::MaskFilterInfoDataView, UserType>(),
    "Attempting to read the optional `mask_filter_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMaskFilterInfo` instead "
    "of `ReadMaskFilterInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mask_filter_info.Get();
    return mojo::internal::Deserialize<::gfx::mojom::MaskFilterInfoDataView>(
        pointer, output, message_);
  }
  inline void GetClipRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `clip_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClipRect` instead "
    "of `ReadClipRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->clip_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool are_contents_opaque() const {
    return data_->are_contents_opaque;
  }
  float opacity() const {
    return data_->opacity;
  }
  uint32_t blend_mode() const {
    return data_->blend_mode;
  }
  int32_t sorting_context_id() const {
    return data_->sorting_context_id;
  }
  uint32_t layer_id() const {
    return data_->layer_id;
  }
  bool is_fast_rounded_corner() const {
    return data_->is_fast_rounded_corner;
  }
  inline void GetOffsetTagDataView(
      ::viz::mojom::OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsetTag(UserType* output) {
    
    auto* pointer = data_->offset_tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SharedQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SharedQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SharedQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::quad_to_target_transform(input)) in_quad_to_target_transform = Traits::quad_to_target_transform(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->quad_to_target_transform)::BaseType> quad_to_target_transform_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_quad_to_target_transform, quad_to_target_transform_fragment);
    fragment->quad_to_target_transform.Set(
        quad_to_target_transform_fragment.is_null() ? nullptr : quad_to_target_transform_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->quad_to_target_transform.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quad_to_target_transform in SharedQuadState struct");
    decltype(Traits::quad_layer_rect(input)) in_quad_layer_rect = Traits::quad_layer_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->quad_layer_rect)::BaseType> quad_layer_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_quad_layer_rect, quad_layer_rect_fragment);
    fragment->quad_layer_rect.Set(
        quad_layer_rect_fragment.is_null() ? nullptr : quad_layer_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->quad_layer_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quad_layer_rect in SharedQuadState struct");
    decltype(Traits::visible_quad_layer_rect(input)) in_visible_quad_layer_rect = Traits::visible_quad_layer_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_quad_layer_rect)::BaseType> visible_quad_layer_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_visible_quad_layer_rect, visible_quad_layer_rect_fragment);
    fragment->visible_quad_layer_rect.Set(
        visible_quad_layer_rect_fragment.is_null() ? nullptr : visible_quad_layer_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visible_quad_layer_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_quad_layer_rect in SharedQuadState struct");
    decltype(Traits::mask_filter_info(input)) in_mask_filter_info = Traits::mask_filter_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mask_filter_info)::BaseType> mask_filter_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::MaskFilterInfoDataView>(
        in_mask_filter_info, mask_filter_info_fragment);
    fragment->mask_filter_info.Set(
        mask_filter_info_fragment.is_null() ? nullptr : mask_filter_info_fragment.data());
    decltype(Traits::clip_rect(input)) in_clip_rect = Traits::clip_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clip_rect)::BaseType> clip_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_clip_rect, clip_rect_fragment);
    fragment->clip_rect.Set(
        clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());
    fragment->are_contents_opaque = Traits::are_contents_opaque(input);
    fragment->opacity = Traits::opacity(input);
    fragment->blend_mode = Traits::blend_mode(input);
    fragment->sorting_context_id = Traits::sorting_context_id(input);
    fragment->layer_id = Traits::layer_id(input);
    fragment->is_fast_rounded_corner = Traits::is_fast_rounded_corner(input);
    decltype(Traits::offset_tag(input)) in_offset_tag = Traits::offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset_tag)::BaseType> offset_tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
        in_offset_tag, offset_tag_fragment);
    fragment->offset_tag.Set(
        offset_tag_fragment.is_null() ? nullptr : offset_tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->offset_tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset_tag in SharedQuadState struct");
  }

  static bool Deserialize(::viz::mojom::internal::SharedQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SharedQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SharedQuadStateDataView::GetQuadToTargetTransformDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->quad_to_target_transform.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void SharedQuadStateDataView::GetQuadLayerRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->quad_layer_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void SharedQuadStateDataView::GetVisibleQuadLayerRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_quad_layer_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void SharedQuadStateDataView::GetMaskFilterInfoDataView(
    ::gfx::mojom::MaskFilterInfoDataView* output) {
  auto pointer = data_->mask_filter_info.Get();
  *output = ::gfx::mojom::MaskFilterInfoDataView(pointer, message_);
}
inline void SharedQuadStateDataView::GetClipRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->clip_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void SharedQuadStateDataView::GetOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_SHARED_H_