// components/web_package/mojom/web_bundle_parser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/web_package/mojom/web_bundle_parser.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-params-data.h"
namespace web_package {
namespace mojom {

NOINLINE static const char* BundleParseErrorTypeToStringHelper(BundleParseErrorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BundleParseErrorType::kParserInternalError:
      return "kParserInternalError";
    case BundleParseErrorType::kFormatError:
      return "kFormatError";
    case BundleParseErrorType::kVersionError:
      return "kVersionError";
    default:
      return nullptr;
  }
}

std::string BundleParseErrorTypeToString(BundleParseErrorType value) {
  const char *str = BundleParseErrorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BundleParseErrorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BundleParseErrorType value) {
  return os << BundleParseErrorTypeToString(value);
}

NOINLINE static const char* BundleFormatVersionToStringHelper(BundleFormatVersion value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BundleFormatVersion::kB1:
      return "kB1";
    case BundleFormatVersion::kB2:
      return "kB2";
    default:
      return nullptr;
  }
}

std::string BundleFormatVersionToString(BundleFormatVersion value) {
  const char *str = BundleFormatVersionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BundleFormatVersion value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BundleFormatVersion value) {
  return os << BundleFormatVersionToString(value);
}

namespace internal {
// static
bool SignatureInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SignatureInfo_Data* object = static_cast<const SignatureInfo_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SignatureInfo_Tag::kUnknown: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_unknown, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_unknown, validation_context))
        return false;
      return true;
    }
    case SignatureInfo_Tag::kEd25519: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_ed25519, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_ed25519, validation_context))
        return false;
      return true;
    }
    case SignatureInfo_Tag::kEcdsaP256Sha256: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_ecdsa_p256_sha256, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_ecdsa_p256_sha256, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SignatureInfo");
      return false;
    }
  }
}


// static
bool BundleIntegrityBlockParseError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleIntegrityBlockParseError_Data* object =
      static_cast<const BundleIntegrityBlockParseError_Data*>(data);


  if (!::web_package::mojom::internal::BundleParseErrorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

BundleIntegrityBlockParseError_Data::BundleIntegrityBlockParseError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleMetadataParseError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleMetadataParseError_Data* object =
      static_cast<const BundleMetadataParseError_Data*>(data);


  if (!::web_package::mojom::internal::BundleParseErrorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

BundleMetadataParseError_Data::BundleMetadataParseError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleResponseParseError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleResponseParseError_Data* object =
      static_cast<const BundleResponseParseError_Data*>(data);


  if (!::web_package::mojom::internal::BundleParseErrorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

BundleResponseParseError_Data::BundleResponseParseError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleIntegrityBlockAttributes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleIntegrityBlockAttributes_Data* object =
      static_cast<const BundleIntegrityBlockAttributes_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& web_bundle_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->web_bundle_id, validation_context,
                                         &web_bundle_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cbor, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cbor_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cbor, validation_context,
                                         &cbor_validate_params)) {
    return false;
  }

  return true;
}

BundleIntegrityBlockAttributes_Data::BundleIntegrityBlockAttributes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleIntegrityBlock_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleIntegrityBlock_Data* object =
      static_cast<const BundleIntegrityBlock_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature_stack, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_stack_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature_stack, validation_context,
                                         &signature_stack_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributes, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attributes, validation_context))
    return false;

  return true;
}

BundleIntegrityBlock_Data::BundleIntegrityBlock_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Ed25519PublicKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Ed25519PublicKey_Data* object =
      static_cast<const Ed25519PublicKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<32, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

Ed25519PublicKey_Data::Ed25519PublicKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Ed25519Signature_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Ed25519Signature_Data* object =
      static_cast<const Ed25519Signature_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<64, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

Ed25519Signature_Data::Ed25519Signature_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignatureInfoEd25519_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignatureInfoEd25519_Data* object =
      static_cast<const SignatureInfoEd25519_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->public_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->signature, validation_context))
    return false;

  return true;
}

SignatureInfoEd25519_Data::SignatureInfoEd25519_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EcdsaP256PublicKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EcdsaP256PublicKey_Data* object =
      static_cast<const EcdsaP256PublicKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<33, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

EcdsaP256PublicKey_Data::EcdsaP256PublicKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EcdsaP256SHA256Signature_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EcdsaP256SHA256Signature_Data* object =
      static_cast<const EcdsaP256SHA256Signature_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

EcdsaP256SHA256Signature_Data::EcdsaP256SHA256Signature_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignatureInfoEcdsaP256SHA256_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignatureInfoEcdsaP256SHA256_Data* object =
      static_cast<const SignatureInfoEcdsaP256SHA256_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->public_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->signature, validation_context))
    return false;

  return true;
}

SignatureInfoEcdsaP256SHA256_Data::SignatureInfoEcdsaP256SHA256_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignatureInfoUnknown_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignatureInfoUnknown_Data* object =
      static_cast<const SignatureInfoUnknown_Data*>(data);

  return true;
}

SignatureInfoUnknown_Data::SignatureInfoUnknown_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleIntegrityBlockSignatureStackEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleIntegrityBlockSignatureStackEntry_Data* object =
      static_cast<const BundleIntegrityBlockSignatureStackEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributes_cbor, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attributes_cbor_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attributes_cbor, validation_context,
                                         &attributes_cbor_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->signature_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->signature_info, validation_context))
    return false;

  return true;
}

BundleIntegrityBlockSignatureStackEntry_Data::BundleIntegrityBlockSignatureStackEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleMetadata_Data* object =
      static_cast<const BundleMetadata_Data*>(data);


  if (!::web_package::mojom::internal::BundleFormatVersion_Data
        ::Validate(object->version, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->primary_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  return true;
}

BundleMetadata_Data::BundleMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleResponseLocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleResponseLocation_Data* object =
      static_cast<const BundleResponseLocation_Data*>(data);

  return true;
}

BundleResponseLocation_Data::BundleResponseLocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleResponse_Data* object =
      static_cast<const BundleResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_headers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& response_headers_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->response_headers, validation_context,
                                         &response_headers_validate_params)) {
    return false;
  }

  return true;
}

BundleResponse_Data::BundleResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParserFactory_GetParserForDataSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParserFactory_GetParserForDataSource_Params_Data* object =
      static_cast<const WebBundleParserFactory_GetParserForDataSource_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->base_url, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_source, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_source,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebBundleParserFactory_GetParserForDataSource_Params_Data::WebBundleParserFactory_GetParserForDataSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParserFactory_BindFileDataSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParserFactory_BindFileDataSource_Params_Data* object =
      static_cast<const WebBundleParserFactory_BindFileDataSource_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_source,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

WebBundleParserFactory_BindFileDataSource_Params_Data::WebBundleParserFactory_BindFileDataSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_ParseIntegrityBlock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_ParseIntegrityBlock_Params_Data* object =
      static_cast<const WebBundleParser_ParseIntegrityBlock_Params_Data*>(data);

  return true;
}

WebBundleParser_ParseIntegrityBlock_Params_Data::WebBundleParser_ParseIntegrityBlock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_ParseIntegrityBlock_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_ParseIntegrityBlock_ResponseParams_Data* object =
      static_cast<const WebBundleParser_ParseIntegrityBlock_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->Result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

WebBundleParser_ParseIntegrityBlock_ResponseParams_Data::WebBundleParser_ParseIntegrityBlock_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_ParseMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_ParseMetadata_Params_Data* object =
      static_cast<const WebBundleParser_ParseMetadata_Params_Data*>(data);

  return true;
}

WebBundleParser_ParseMetadata_Params_Data::WebBundleParser_ParseMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_ParseMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_ParseMetadata_ResponseParams_Data* object =
      static_cast<const WebBundleParser_ParseMetadata_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->Result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

WebBundleParser_ParseMetadata_ResponseParams_Data::WebBundleParser_ParseMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_ParseResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_ParseResponse_Params_Data* object =
      static_cast<const WebBundleParser_ParseResponse_Params_Data*>(data);

  return true;
}

WebBundleParser_ParseResponse_Params_Data::WebBundleParser_ParseResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_ParseResponse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_ParseResponse_ResponseParams_Data* object =
      static_cast<const WebBundleParser_ParseResponse_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->Result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

WebBundleParser_ParseResponse_ResponseParams_Data::WebBundleParser_ParseResponse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_Close_Params_Data* object =
      static_cast<const WebBundleParser_Close_Params_Data*>(data);

  return true;
}

WebBundleParser_Close_Params_Data::WebBundleParser_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleParser_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBundleParser_Close_ResponseParams_Data* object =
      static_cast<const WebBundleParser_Close_ResponseParams_Data*>(data);

  return true;
}

WebBundleParser_Close_ResponseParams_Data::WebBundleParser_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_Read_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_Read_Params_Data* object =
      static_cast<const BundleDataSource_Read_Params_Data*>(data);

  return true;
}

BundleDataSource_Read_Params_Data::BundleDataSource_Read_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_Read_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_Read_ResponseParams_Data* object =
      static_cast<const BundleDataSource_Read_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buffer, validation_context,
                                         &buffer_validate_params)) {
    return false;
  }

  return true;
}

BundleDataSource_Read_ResponseParams_Data::BundleDataSource_Read_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_Length_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_Length_Params_Data* object =
      static_cast<const BundleDataSource_Length_Params_Data*>(data);

  return true;
}

BundleDataSource_Length_Params_Data::BundleDataSource_Length_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_Length_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_Length_ResponseParams_Data* object =
      static_cast<const BundleDataSource_Length_ResponseParams_Data*>(data);

  return true;
}

BundleDataSource_Length_ResponseParams_Data::BundleDataSource_Length_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_IsRandomAccessContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_IsRandomAccessContext_Params_Data* object =
      static_cast<const BundleDataSource_IsRandomAccessContext_Params_Data*>(data);

  return true;
}

BundleDataSource_IsRandomAccessContext_Params_Data::BundleDataSource_IsRandomAccessContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_IsRandomAccessContext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_IsRandomAccessContext_ResponseParams_Data* object =
      static_cast<const BundleDataSource_IsRandomAccessContext_ResponseParams_Data*>(data);

  return true;
}

BundleDataSource_IsRandomAccessContext_ResponseParams_Data::BundleDataSource_IsRandomAccessContext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_Close_Params_Data* object =
      static_cast<const BundleDataSource_Close_Params_Data*>(data);

  return true;
}

BundleDataSource_Close_Params_Data::BundleDataSource_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BundleDataSource_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BundleDataSource_Close_ResponseParams_Data* object =
      static_cast<const BundleDataSource_Close_ResponseParams_Data*>(data);

  return true;
}

BundleDataSource_Close_ResponseParams_Data::BundleDataSource_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace web_package

namespace perfetto {

// static
void TraceFormatTraits<::web_package::mojom::BundleParseErrorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::web_package::mojom::BundleParseErrorType value) {
  return std::move(context).WriteString(::web_package::mojom::BundleParseErrorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::web_package::mojom::BundleFormatVersion>::WriteIntoTrace(
   perfetto::TracedValue context, ::web_package::mojom::BundleFormatVersion value) {
  return std::move(context).WriteString(::web_package::mojom::BundleFormatVersionToString(value));
}

} // namespace perfetto