// cc/mojom/render_frame_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_H_
#define CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/render_frame_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/selection.mojom-shared.h"
#include "services/viz/public/mojom/compositing/vertical_scroll_direction.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace cc::mojom {
class DelegatedInkBrowserMetadataDataView;

class RenderFrameMetadataDataView;



}  // cc::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cc::mojom::DelegatedInkBrowserMetadataDataView> {
  using Data = ::cc::mojom::internal::DelegatedInkBrowserMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cc::mojom::RenderFrameMetadataDataView> {
  using Data = ::cc::mojom::internal::RenderFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cc::mojom {
// Interface base classes. They are used for type safety check.
class RenderFrameMetadataObserverInterfaceBase {};

using RenderFrameMetadataObserverPtrDataView =
    mojo::InterfacePtrDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverRequestDataView =
    mojo::InterfaceRequestDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderFrameMetadataObserverInterfaceBase>;
class RenderFrameMetadataObserverClientInterfaceBase {};

using RenderFrameMetadataObserverClientPtrDataView =
    mojo::InterfacePtrDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientRequestDataView =
    mojo::InterfaceRequestDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderFrameMetadataObserverClientInterfaceBase>;


class DelegatedInkBrowserMetadataDataView {
 public:
  DelegatedInkBrowserMetadataDataView() = default;

  DelegatedInkBrowserMetadataDataView(
      internal::DelegatedInkBrowserMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool delegated_ink_is_hovering() const {
    return data_->delegated_ink_is_hovering;
  }
 private:
  internal::DelegatedInkBrowserMetadata_Data* data_ = nullptr;
};


class RenderFrameMetadataDataView {
 public:
  RenderFrameMetadataDataView() = default;

  RenderFrameMetadataDataView(
      internal::RenderFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootBackgroundColor(UserType* output) {
    
    auto* pointer = data_->root_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetRootScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootScrollOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `root_scroll_offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRootScrollOffset` instead "
    "of `ReadRootScrollOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->root_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  bool is_scroll_offset_at_top() const {
    return data_->is_scroll_offset_at_top;
  }
  inline void GetSelectionDataView(
      ::viz::mojom::SelectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::viz::mojom::SelectionDataView>(
        pointer, output, message_);
  }
  bool is_mobile_optimized() const {
    return data_->is_mobile_optimized;
  }
  inline void GetDelegatedInkMetadataDataView(
      DelegatedInkBrowserMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDelegatedInkMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::DelegatedInkBrowserMetadataDataView, UserType>(),
    "Attempting to read the optional `delegated_ink_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDelegatedInkMetadata` instead "
    "of `ReadDelegatedInkMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->delegated_ink_metadata.Get();
    return mojo::internal::Deserialize<::cc::mojom::DelegatedInkBrowserMetadataDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetViewportSizeInPixelsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportSizeInPixels(UserType* output) {
    
    auto* pointer = data_->viewport_size_in_pixels.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float external_page_scale_factor() const {
    return data_->external_page_scale_factor;
  }
  float top_controls_height() const {
    return data_->top_controls_height;
  }
  float top_controls_shown_ratio() const {
    return data_->top_controls_shown_ratio;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNewVerticalScrollDirection(UserType* output) const {
    auto data_value = data_->new_vertical_scroll_direction;
    return mojo::internal::Deserialize<::viz::mojom::VerticalScrollDirection>(
        data_value, output);
  }
  ::viz::mojom::VerticalScrollDirection new_vertical_scroll_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::VerticalScrollDirection>(data_->new_vertical_scroll_direction));
  }
  int64_t primary_main_frame_item_sequence_number() const {
    return data_->primary_main_frame_item_sequence_number;
  }
  float bottom_controls_height() const {
    return data_->bottom_controls_height;
  }
  float bottom_controls_shown_ratio() const {
    return data_->bottom_controls_shown_ratio;
  }
  float top_controls_min_height_offset() const {
    return data_->top_controls_min_height_offset;
  }
  float bottom_controls_min_height_offset() const {
    return data_->bottom_controls_min_height_offset;
  }
  float min_page_scale_factor() const {
    return data_->min_page_scale_factor;
  }
  float max_page_scale_factor() const {
    return data_->max_page_scale_factor;
  }
  bool root_overflow_y_hidden() const {
    return data_->root_overflow_y_hidden;
  }
  inline void GetScrollableViewportSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollableViewportSize(UserType* output) {
    
    auto* pointer = data_->scrollable_viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  inline void GetRootLayerSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootLayerSize(UserType* output) {
    
    auto* pointer = data_->root_layer_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  bool has_transparent_background() const {
    return data_->has_transparent_background;
  }
 private:
  internal::RenderFrameMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cc::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::DelegatedInkBrowserMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::DelegatedInkBrowserMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::DelegatedInkBrowserMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->delegated_ink_is_hovering = Traits::delegated_ink_is_hovering(input);
  }

  static bool Deserialize(::cc::mojom::internal::DelegatedInkBrowserMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::DelegatedInkBrowserMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::RenderFrameMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::RenderFrameMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::RenderFrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::root_background_color(input)) in_root_background_color = Traits::root_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_background_color)::BaseType> root_background_color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
        in_root_background_color, root_background_color_fragment);
    fragment->root_background_color.Set(
        root_background_color_fragment.is_null() ? nullptr : root_background_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->root_background_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_background_color in RenderFrameMetadata struct");
    decltype(Traits::root_scroll_offset(input)) in_root_scroll_offset = Traits::root_scroll_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_scroll_offset)::BaseType> root_scroll_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_root_scroll_offset, root_scroll_offset_fragment);
    fragment->root_scroll_offset.Set(
        root_scroll_offset_fragment.is_null() ? nullptr : root_scroll_offset_fragment.data());
    fragment->is_scroll_offset_at_top = Traits::is_scroll_offset_at_top(input);
    decltype(Traits::selection(input)) in_selection = Traits::selection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection)::BaseType> selection_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::SelectionDataView>(
        in_selection, selection_fragment);
    fragment->selection.Set(
        selection_fragment.is_null() ? nullptr : selection_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->selection.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection in RenderFrameMetadata struct");
    fragment->is_mobile_optimized = Traits::is_mobile_optimized(input);
    decltype(Traits::delegated_ink_metadata(input)) in_delegated_ink_metadata = Traits::delegated_ink_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->delegated_ink_metadata)::BaseType> delegated_ink_metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::DelegatedInkBrowserMetadataDataView>(
        in_delegated_ink_metadata, delegated_ink_metadata_fragment);
    fragment->delegated_ink_metadata.Set(
        delegated_ink_metadata_fragment.is_null() ? nullptr : delegated_ink_metadata_fragment.data());
    fragment->device_scale_factor = Traits::device_scale_factor(input);
    decltype(Traits::viewport_size_in_pixels(input)) in_viewport_size_in_pixels = Traits::viewport_size_in_pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_size_in_pixels)::BaseType> viewport_size_in_pixels_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_viewport_size_in_pixels, viewport_size_in_pixels_fragment);
    fragment->viewport_size_in_pixels.Set(
        viewport_size_in_pixels_fragment.is_null() ? nullptr : viewport_size_in_pixels_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->viewport_size_in_pixels.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_size_in_pixels in RenderFrameMetadata struct");
    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
        in_local_surface_id, local_surface_id_fragment);
    fragment->local_surface_id.Set(
        local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
    fragment->page_scale_factor = Traits::page_scale_factor(input);
    fragment->external_page_scale_factor = Traits::external_page_scale_factor(input);
    fragment->top_controls_height = Traits::top_controls_height(input);
    fragment->top_controls_shown_ratio = Traits::top_controls_shown_ratio(input);
    mojo::internal::Serialize<::viz::mojom::VerticalScrollDirection>(
        Traits::new_vertical_scroll_direction(input), &fragment->new_vertical_scroll_direction);
    fragment->primary_main_frame_item_sequence_number = Traits::primary_main_frame_item_sequence_number(input);
    fragment->bottom_controls_height = Traits::bottom_controls_height(input);
    fragment->bottom_controls_shown_ratio = Traits::bottom_controls_shown_ratio(input);
    fragment->top_controls_min_height_offset = Traits::top_controls_min_height_offset(input);
    fragment->bottom_controls_min_height_offset = Traits::bottom_controls_min_height_offset(input);
    fragment->min_page_scale_factor = Traits::min_page_scale_factor(input);
    fragment->max_page_scale_factor = Traits::max_page_scale_factor(input);
    fragment->root_overflow_y_hidden = Traits::root_overflow_y_hidden(input);
    decltype(Traits::scrollable_viewport_size(input)) in_scrollable_viewport_size = Traits::scrollable_viewport_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scrollable_viewport_size)::BaseType> scrollable_viewport_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_scrollable_viewport_size, scrollable_viewport_size_fragment);
    fragment->scrollable_viewport_size.Set(
        scrollable_viewport_size_fragment.is_null() ? nullptr : scrollable_viewport_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scrollable_viewport_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollable_viewport_size in RenderFrameMetadata struct");
    decltype(Traits::root_layer_size(input)) in_root_layer_size = Traits::root_layer_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_layer_size)::BaseType> root_layer_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_root_layer_size, root_layer_size_fragment);
    fragment->root_layer_size.Set(
        root_layer_size_fragment.is_null() ? nullptr : root_layer_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->root_layer_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_layer_size in RenderFrameMetadata struct");
    fragment->has_transparent_background = Traits::has_transparent_background(input);
  }

  static bool Deserialize(::cc::mojom::internal::RenderFrameMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::RenderFrameMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc::mojom {



inline void RenderFrameMetadataDataView::GetRootBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->root_background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetRootScrollOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->root_scroll_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetSelectionDataView(
    ::viz::mojom::SelectionDataView* output) {
  auto pointer = data_->selection.Get();
  *output = ::viz::mojom::SelectionDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetDelegatedInkMetadataDataView(
    DelegatedInkBrowserMetadataDataView* output) {
  auto pointer = data_->delegated_ink_metadata.Get();
  *output = DelegatedInkBrowserMetadataDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetViewportSizeInPixelsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->viewport_size_in_pixels.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetScrollableViewportSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->scrollable_viewport_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void RenderFrameMetadataDataView::GetRootLayerSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->root_layer_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}



}  // cc::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_SHARED_H_