
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kmodifierkeyinfo_wrapper.h"

// Wrappers providing overrides
#include "ksystemclipboard_wrapper.h"

// Argument includes
#include <QList>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KModifierKeyInfo_Type = nullptr;
static PyTypeObject *Sbk_KModifierKeyInfo_TypeF(void)
{
    return _Sbk_KModifierKeyInfo_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KModifierKeyInfoWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KModifierKeyInfoWrapper::KModifierKeyInfoWrapper(::QObject * parent) : KModifierKeyInfo(parent)
{
}

void KModifierKeyInfoWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_childEvent("KModifierKeyInfo", funcName, gil, pyOverride, event);
}

void KModifierKeyInfoWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KModifierKeyInfo", funcName, gil, pyOverride, signal);
}

void KModifierKeyInfoWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_customEvent("KModifierKeyInfo", funcName, gil, pyOverride, event);
}

void KModifierKeyInfoWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KModifierKeyInfo", funcName, gil, pyOverride, signal);
}

bool KModifierKeyInfoWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSystemClipboardWrapper::sbk_o_event("KModifierKeyInfo", funcName, gil, pyOverride, event);
}

bool KModifierKeyInfoWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSystemClipboardWrapper::sbk_o_eventFilter("KModifierKeyInfo", funcName, gil, pyOverride, watched, event);
}

void KModifierKeyInfoWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KModifierKeyInfo_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_timerEvent("KModifierKeyInfo", funcName, gil, pyOverride, event);
}

const QMetaObject *KModifierKeyInfoWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KModifierKeyInfo::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KModifierKeyInfoWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KModifierKeyInfo::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KModifierKeyInfoWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KModifierKeyInfoWrapper *>(this));
    }
    return KModifierKeyInfo::qt_metacast(_clname);
}

KModifierKeyInfoWrapper::~KModifierKeyInfoWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KModifierKeyInfo_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KModifierKeyInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KModifierKeyInfo >()))
        return -1;

    KModifierKeyInfoWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KModifierKeyInfo", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KModifierKeyInfo::KModifierKeyInfo(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KModifierKeyInfo(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KModifierKeyInfo(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KModifierKeyInfo(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KModifierKeyInfoWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KModifierKeyInfoWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KModifierKeyInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KModifierKeyInfoFunc_isButtonPressed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KModifierKeyInfo::isButtonPressed(Qt::MouseButton)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_MouseButton_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // isButtonPressed(Qt::MouseButton)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isButtonPressed", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::MouseButton cppArg0{Qt::NoButton};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isButtonPressed(Qt::MouseButton)const
            bool cppResult = const_cast<const ::KModifierKeyInfo *>(cppSelf)->isButtonPressed(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_isKeyLatched(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KModifierKeyInfo::isKeyLatched(Qt::Key)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Key_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // isKeyLatched(Qt::Key)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isKeyLatched", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isKeyLatched(Qt::Key)const
            bool cppResult = const_cast<const ::KModifierKeyInfo *>(cppSelf)->isKeyLatched(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_isKeyLocked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KModifierKeyInfo::isKeyLocked(Qt::Key)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Key_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // isKeyLocked(Qt::Key)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isKeyLocked", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isKeyLocked(Qt::Key)const
            bool cppResult = const_cast<const ::KModifierKeyInfo *>(cppSelf)->isKeyLocked(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_isKeyPressed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KModifierKeyInfo::isKeyPressed(Qt::Key)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Key_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // isKeyPressed(Qt::Key)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isKeyPressed", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isKeyPressed(Qt::Key)const
            bool cppResult = const_cast<const ::KModifierKeyInfo *>(cppSelf)->isKeyPressed(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_knownKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // knownKeys()const
        const QList<Qt::Key> cppResult = const_cast<const ::KModifierKeyInfo *>(cppSelf)->knownKeys();
        pyResult = Shiboken::Conversions::copyToPython(SbkKGuiAddonsTypeConverters[SBK_KGuiAddons_QList_Qt_Key_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_knowsKey(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KModifierKeyInfo::knowsKey(Qt::Key)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Key_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // knowsKey(Qt::Key)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "knowsKey", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // knowsKey(Qt::Key)const
            bool cppResult = const_cast<const ::KModifierKeyInfo *>(cppSelf)->knowsKey(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_setKeyLatched(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setKeyLatched", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KModifierKeyInfo::setKeyLatched(Qt::Key,bool)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Key_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setKeyLatched(Qt::Key,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setKeyLatched", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKeyLatched(Qt::Key,bool)
            bool cppResult = cppSelf->setKeyLatched(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KModifierKeyInfoFunc_setKeyLocked(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setKeyLocked", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KModifierKeyInfo::setKeyLocked(Qt::Key,bool)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Key_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setKeyLocked(Qt::Key,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setKeyLocked", errInfo, SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]);

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKeyLocked(Qt::Key,bool)
            bool cppResult = cppSelf->setKeyLocked(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KModifierKeyInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KModifierKeyInfo_methods[] = {
    {"isButtonPressed", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_isButtonPressed), METH_O, nullptr},
    {"isKeyLatched", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_isKeyLatched), METH_O, nullptr},
    {"isKeyLocked", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_isKeyLocked), METH_O, nullptr},
    {"isKeyPressed", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_isKeyPressed), METH_O, nullptr},
    {"knownKeys", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_knownKeys), METH_NOARGS, nullptr},
    {"knowsKey", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_knowsKey), METH_O, nullptr},
    {"setKeyLatched", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_setKeyLatched), METH_VARARGS, nullptr},
    {"setKeyLocked", reinterpret_cast<PyCFunction>(Sbk_KModifierKeyInfoFunc_setKeyLocked), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KModifierKeyInfo_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KModifierKeyInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KModifierKeyInfoWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KModifierKeyInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KModifierKeyInfo_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KModifierKeyInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KModifierKeyInfo_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KModifierKeyInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KModifierKeyInfo_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KModifierKeyInfo_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KModifierKeyInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KModifierKeyInfo_spec = {
    "1:KGuiAddons.KModifierKeyInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KModifierKeyInfo_slots
};

} //extern "C"

static void *Sbk_KModifierKeyInfo_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KModifierKeyInfo *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KModifierKeyInfo_PythonToCpp_KModifierKeyInfo_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KModifierKeyInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KModifierKeyInfo_PythonToCpp_KModifierKeyInfo_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KModifierKeyInfo_TypeF()))
        return KModifierKeyInfo_PythonToCpp_KModifierKeyInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KModifierKeyInfo_PTR_CppToPython_KModifierKeyInfo(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KModifierKeyInfo *>(const_cast<void *>(cppIn)), Sbk_KModifierKeyInfo_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KModifierKeyInfo_SignatureStrings[] = {
    "KGuiAddons.KModifierKeyInfo(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KGuiAddons.KModifierKeyInfo.isButtonPressed(self,button:PySide6.QtCore.Qt.MouseButton)->bool",
    "KGuiAddons.KModifierKeyInfo.isKeyLatched(self,key:PySide6.QtCore.Qt.Key)->bool",
    "KGuiAddons.KModifierKeyInfo.isKeyLocked(self,key:PySide6.QtCore.Qt.Key)->bool",
    "KGuiAddons.KModifierKeyInfo.isKeyPressed(self,key:PySide6.QtCore.Qt.Key)->bool",
    "KGuiAddons.KModifierKeyInfo.knownKeys(self)->QList[PySide6.QtCore.Qt.Key]",
    "KGuiAddons.KModifierKeyInfo.knowsKey(self,key:PySide6.QtCore.Qt.Key)->bool",
    "KGuiAddons.KModifierKeyInfo.setKeyLatched(self,key:PySide6.QtCore.Qt.Key,latched:bool)->bool",
    "KGuiAddons.KModifierKeyInfo.setKeyLocked(self,key:PySide6.QtCore.Qt.Key,locked:bool)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KModifierKeyInfo_SignatureByteSize = 196;
static constexpr uint8_t KModifierKeyInfo_SignatureBytes[196] = {
    0x78, 0xda, 0xad, 0xd1, 0xc1, 0x0a, 0xc2, 0x30, 0x0c, 0x06, 0xe0, 0xbb, 0x4f, 0xe2, 0x60, 0xf6,
    0xe8, 0x41, 0x50, 0x50, 0x0f, 0x22, 0x73, 0xe8, 0xf0, 0x28, 0x1e, 0xdc, 0x9a, 0x61, 0x5d, 0x69,
    0x46, 0x93, 0x22, 0x7b, 0x7b, 0xeb, 0x86, 0x07, 0x71, 0xb2, 0x89, 0xbb, 0xa5, 0xe1, 0xcf, 0x47,
    0x4a, 0xa2, 0x8d, 0x53, 0x4b, 0x29, 0xd1, 0x90, 0x88, 0x62, 0x94, 0x2a, 0x57, 0x60, 0x23, 0xa8,
    0xb6, 0x26, 0xc7, 0x31, 0x81, 0xce, 0xc3, 0xf2, 0x62, 0xc1, 0xf0, 0xec, 0x50, 0x1d, 0x95, 0x84,
    0xa9, 0x48, 0x78, 0x8d, 0x16, 0x44, 0xb2, 0x4f, 0x6f, 0x90, 0xf1, 0xdc, 0x38, 0xad, 0x4b, 0xb6,
    0xc1, 0x28, 0xfa, 0xee, 0x08, 0x45, 0x2b, 0xc7, 0x8c, 0xe6, 0x60, 0x81, 0x08, 0x64, 0xe3, 0xa6,
    0x75, 0xeb, 0xc3, 0x65, 0x11, 0xa3, 0x23, 0x68, 0x06, 0x82, 0xc9, 0x22, 0x45, 0xd4, 0x1d, 0xb8,
    0xaf, 0x76, 0x17, 0xce, 0xae, 0x2f, 0xb9, 0x80, 0xaa, 0x85, 0xf5, 0xa9, 0xfe, 0x1c, 0x66, 0xc5,
    0x70, 0xda, 0xdb, 0xb7, 0xff, 0xe2, 0x0a, 0x83, 0x77, 0xe3, 0x1f, 0x54, 0x5b, 0x7e, 0x22, 0xd9,
    0x29, 0xe2, 0x53, 0xab, 0x77, 0xee, 0x94, 0x9e, 0xbb, 0x0d, 0xb0, 0x14, 0x01, 0xf7, 0xbe, 0x40,
    0xa8, 0x9b, 0xd8, 0xec, 0xa9, 0xfe, 0x80, 0xf7, 0xb9, 0x47, 0xa8, 0xeb, 0xd4, 0x1b, 0xfd, 0x00,
    0x65, 0xe3, 0x08, 0x2a
};
#endif

PyTypeObject *init_KModifierKeyInfo(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX].type;

    Shiboken::AutoDecRef Sbk_KModifierKeyInfo_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KModifierKeyInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KModifierKeyInfo",
        "KModifierKeyInfo*",
        &Sbk_KModifierKeyInfo_spec,
        &Shiboken::callCppDestructor< KModifierKeyInfo >,
        Sbk_KModifierKeyInfo_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KModifierKeyInfo_Type; // references _Sbk_KModifierKeyInfo_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KModifierKeyInfo_SignatureStrings);
#else
    InitSignatureBytes(pyType, KModifierKeyInfo_SignatureBytes, KModifierKeyInfo_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KModifierKeyInfo_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KModifierKeyInfo_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KModifierKeyInfo_PythonToCpp_KModifierKeyInfo_PTR,
        is_KModifierKeyInfo_PythonToCpp_KModifierKeyInfo_PTR_Convertible,
        KModifierKeyInfo_PTR_CppToPython_KModifierKeyInfo);

    Shiboken::Conversions::registerConverterName(converter, "KModifierKeyInfo");
    Shiboken::Conversions::registerConverterName(converter, "KModifierKeyInfo*");
    Shiboken::Conversions::registerConverterName(converter, "KModifierKeyInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KModifierKeyInfo).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KModifierKeyInfoWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KModifierKeyInfo_TypeF(), &Sbk_KModifierKeyInfo_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KModifierKeyInfo::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KModifierKeyInfo::staticMetaObject, sizeof(KModifierKeyInfoWrapper));

    return pyType;
}
