/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

public class Failable<O> {
    private final O data;
    private final String error;
    private final int score;

    public static <O> Failable<O> ok(O data) {
        return new Failable<O>(data, null, 0);
    }

    public static <O> Failable<O> error(String error) {
        return new Failable<Object>(null, error, 0);
    }

    public static <O> Failable<O> error(String error, int score) {
        return new Failable<Object>(null, error, score);
    }

    private Failable(O data, String error, int score) {
        if (data == null && error == null) {
            throw new IllegalArgumentException();
        }
        if (data != null && error != null) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.error = error;
        this.score = score;
    }

    public O get() {
        if (this.data == null) {
            throw new IllegalStateException();
        }
        return this.data;
    }

    public boolean isFail() {
        return this.data == null;
    }

    public String getError() {
        if (this.error == null) {
            throw new IllegalStateException();
        }
        return this.error;
    }

    public int getScore() {
        if (this.error == null) {
            throw new IllegalStateException();
        }
        return this.score;
    }
}

