/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import org.opensearch.action.search.ParsedScrollId;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.opensearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.search.TransportSearchHelper;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.wlm.WorkloadGroupTask;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;
    private final ThreadPool threadPool;

    @Inject
    public TransportSearchScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ThreadPool threadPool) {
        super("indices:data/read/scroll", transportService, actionFilters, SearchScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.searchPhaseController = searchPhaseController;
        this.threadPool = threadPool;
    }

    @Override
    protected void doExecute(Task task, SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            if (task instanceof WorkloadGroupTask) {
                ((WorkloadGroupTask)task).setWorkloadGroupId(this.threadPool.getThreadContext());
            }
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            (switch (scrollId.getType()) {
                case "queryThenFetch" -> new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                case "queryAndFetch" -> new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                default -> throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
            }).run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

