/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.jcajce.provider.ProvIOException;

abstract class BaseAlgorithmParameters
extends AlgorithmParametersSpi {
    BaseAlgorithmParameters() {
    }

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    @Override
    protected final <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz == null) {
            throw new NullPointerException("Argument to getParameterSpec must not be null");
        }
        return (T)this.localEngineGetParameterSpec(clazz);
    }

    @Override
    protected final void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, "ASN.1");
    }

    @Override
    protected final byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            return this.localGetEncoded();
        }
        throw new IOException("Unknown parameter format: " + string);
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Encoded parameters cannot be null");
        }
        if (this.isASN1FormatString(string)) {
            try {
                this.localInit(byArray);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("Parameter parsing failed: " + exception.getMessage(), exception);
            }
        } else {
            throw new IOException("Unknown parameter format: " + string);
        }
    }

    protected abstract byte[] localGetEncoded() throws IOException;

    protected abstract void localInit(byte[] var1) throws IOException;

    protected abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1) throws InvalidParameterSpecException;
}

