/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.KeyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public abstract class AbstractEddsaKeyProviderFactory
implements KeyProviderFactory {
    protected static final String EDDSA_PRIVATE_KEY_KEY = "eddsaPrivateKey";
    protected static final String EDDSA_PUBLIC_KEY_KEY = "eddsaPublicKey";
    protected static final String EDDSA_ELLIPTIC_CURVE_KEY = "eddsaEllipticCurveKey";
    public static final String DEFAULT_EDDSA_ELLIPTIC_CURVE = "Ed25519";
    protected static ProviderConfigProperty EDDSA_ELLIPTIC_CURVE_PROPERTY = new ProviderConfigProperty("eddsaEllipticCurveKey", "Elliptic Curve", "Elliptic Curve used in EdDSA", "List", (Object)String.valueOf("Ed25519"), new String[]{"Ed25519", "Ed448"});

    public static final ProviderConfigurationBuilder configurationBuilder() {
        return ProviderConfigurationBuilder.create().property(Attributes.PRIORITY_PROPERTY).property(Attributes.ENABLED_PROPERTY).property(Attributes.ACTIVE_PROPERTY);
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkLong(Attributes.PRIORITY_PROPERTY, false).checkBoolean(Attributes.ENABLED_PROPERTY, false).checkBoolean(Attributes.ACTIVE_PROPERTY, false);
    }

    public static KeyPair generateEddsaKeyPair(String curveName) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(curveName);
            return keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

