/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class FlatClassLoaderService
implements ClassLoaderService {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(FlatClassLoaderService.class);
    public static final ClassLoaderService INSTANCE = new FlatClassLoaderService();

    private FlatClassLoaderService() {
    }

    public <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className, false, this.getClassLoader());
        }
        catch (Exception | LinkageError e) {
            throw new ClassLoadingException("Unable to load class [" + className + "]", e);
        }
    }

    public URL locateResource(String name) {
        URL resource = this.getClassLoader().getResource(name);
        if (resource == null) {
            log.debugf("Loading of resource '%s' failed. Maybe that's ok, maybe you forgot to include this resource in the binary image? -H:IncludeResources=", (Object)name);
        } else {
            log.tracef("Successfully loaded resource '%s'", (Object)name);
        }
        return resource;
    }

    public InputStream locateResourceStream(String name) {
        InputStream resourceAsStream = this.getClassLoader().getResourceAsStream(name);
        if (resourceAsStream == null) {
            log.debugf("Loading of resource '%s' failed. Maybe that's ok, maybe you forgot to include this resource in the binary image? -H:IncludeResources=", (Object)name);
        } else {
            log.tracef("Successfully loaded resource '%s'", (Object)name);
        }
        return resourceAsStream;
    }

    public List<URL> locateResources(String name) {
        log.debugf("locateResources (plural form) was invoked for resource '%s'. Is there a real need for this plural form?", (Object)name);
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources(name);
            ArrayList<URL> resource = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                resource.add(resources.nextElement());
            }
            return resource;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <S> Collection<S> loadJavaServices(Class<S> serviceContract) {
        ServiceLoader<S> serviceLoader = ServiceLoader.load(serviceContract, this.getClassLoader());
        LinkedHashSet<S> services = new LinkedHashSet<S>();
        for (S service : serviceLoader) {
            services.add(service);
        }
        return services;
    }

    public <T> T generateProxy(InvocationHandler handler, Class<?> ... interfaces) {
        throw new AssertionFailure("Not implemented! generateProxy(InvocationHandler handler, Class... interfaces)");
    }

    public Package packageForNameOrNull(String packageName) {
        try {
            Class<?> aClass = Class.forName(packageName + ".package-info", false, this.getClassLoader());
            return aClass == null ? null : aClass.getPackage();
        }
        catch (ClassNotFoundException e) {
            log.packageNotFound(packageName);
            return null;
        }
        catch (LinkageError e) {
            log.warn((Object)("LinkageError while attempting to load Package named " + packageName), (Throwable)e);
            return null;
        }
    }

    public <T> T workWithClassLoader(ClassLoaderService.Work<T> work) {
        ClassLoader systemClassLoader = this.getClassLoader();
        return (T)work.doWork(systemClassLoader);
    }

    public void stop() {
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return FlatClassLoaderService.class.getClassLoader();
        }
        return cl;
    }
}

