/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.implicit;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.FetchBuilderBasicValued;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderBasic
implements ImplicitFetchBuilder,
FetchBuilderBasicValued {
    private final NavigablePath fetchPath;
    private final BasicValuedModelPart fetchable;
    private final FetchBuilder fetchBuilder;

    public ImplicitFetchBuilderBasic(NavigablePath fetchPath, BasicValuedModelPart fetchable) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
        this.fetchBuilder = null;
    }

    public ImplicitFetchBuilderBasic(NavigablePath fetchPath, BasicValuedModelPart fetchable, DomainResultCreationState creationState) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
        this.fetchBuilder = ResultsHelper.impl(creationState).getCurrentExplicitFetchMementoResolver().apply(fetchable);
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicFetch<?> buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        if (this.fetchBuilder != null) {
            return (BasicFetch)this.fetchBuilder.buildFetch(parent, fetchPath, jdbcResultsMetadata, domainResultCreationState);
        }
        SqlSelection sqlSelection = this.sqlSelection(parent, fetchPath, jdbcResultsMetadata, domainResultCreationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), parent, fetchPath, this.fetchable, FetchTiming.IMMEDIATE, domainResultCreationState, !sqlSelection.isVirtual());
    }

    private SqlSelection sqlSelection(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        return creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, parentTableGroup.resolveTableReference(fetchPath, this.fetchable, this.fetchable.getContainingTableExpression()), this.fetchable, this.fetchable.isFormula() ? this.fetchable.getFetchableName() : this.fetchable.getSelectionExpression()), this.fetchable.getJdbcMapping().getJdbcJavaType(), parent, domainResultCreationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
    }

    public String toString() {
        return "ImplicitFetchBuilderBasic(" + String.valueOf(this.fetchPath) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderBasic that = (ImplicitFetchBuilderBasic)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        return result;
    }

    @Override
    public void visitFetchBuilders(BiConsumer<Fetchable, FetchBuilder> consumer) {
        if (this.fetchBuilder != null) {
            consumer.accept(this.fetchable, this.fetchBuilder);
        }
    }
}

