/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Dense implementation of the Chan and Vese multiphase level set image
filter.


This code was adapted from the paper: "An active contour model
without edges" T. Chan and L. Vese. In Scale-Space Theories in
Computer Vision, pages 141-151, 1999.
Mosaliganti K., Smith B., Gelas A., Gouaillard A., Megason S.
 This code was taken from the Insight Journal paper: "Cell Tracking
using Coupled Active Surfaces for Nuclei and Membranes" https://doi.org/10.54294/wvwmf8 That is based on the papers: "Level Set Segmentation: Active
Contours without edge" https://doi.org/10.54294/8jk6oy

and

"Level set segmentation using coupled active surfaces" https://doi.org/10.54294/23ugmy
See:
 itk::simple::ScalarChanAndVeseDenseLevelSet for the procedural interface

 itk::ScalarChanAndVeseDenseLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkScalarChanAndVeseDenseLevelSetImageFilter.h
*/
public class ScalarChanAndVeseDenseLevelSetImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ScalarChanAndVeseDenseLevelSetImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ScalarChanAndVeseDenseLevelSetImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ScalarChanAndVeseDenseLevelSetImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::~ScalarChanAndVeseDenseLevelSetImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ScalarChanAndVeseDenseLevelSetImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::ScalarChanAndVeseDenseLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ScalarChanAndVeseDenseLevelSetImageFilter() {
    this(SimpleITKJNI.new_ScalarChanAndVeseDenseLevelSetImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetLambda1(double Lambda1)
*/
public  void setLambda1(double Lambda1) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setLambda1(swigCPtr, this, Lambda1);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetLambda1() const
*/
public  double getLambda1() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getLambda1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetLambda2(double Lambda2)
*/
public  void setLambda2(double Lambda2) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setLambda2(swigCPtr, this, Lambda2);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetLambda2() const
*/
public  double getLambda2() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getLambda2(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetEpsilon(double Epsilon)
*/
public  void setEpsilon(double Epsilon) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setEpsilon(swigCPtr, this, Epsilon);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetEpsilon() const
*/
public  double getEpsilon() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getEpsilon(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetCurvatureWeight(double CurvatureWeight)
*/
public  void setCurvatureWeight(double CurvatureWeight) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setCurvatureWeight(swigCPtr, this, CurvatureWeight);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetCurvatureWeight() const
*/
public  double getCurvatureWeight() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getCurvatureWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetAreaWeight(double AreaWeight)
*/
public  void setAreaWeight(double AreaWeight) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setAreaWeight(swigCPtr, this, AreaWeight);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetAreaWeight() const
*/
public  double getAreaWeight() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getAreaWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetReinitializationSmoothingWeight(double ReinitializationSmoothingWeight)
*/
public  void setReinitializationSmoothingWeight(double ReinitializationSmoothingWeight) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setReinitializationSmoothingWeight(swigCPtr, this, ReinitializationSmoothingWeight);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetReinitializationSmoothingWeight() const
*/
public  double getReinitializationSmoothingWeight() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getReinitializationSmoothingWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetVolume(double Volume)
*/
public  void setVolume(double Volume) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setVolume(swigCPtr, this, Volume);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetVolume() const
*/
public  double getVolume() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getVolume(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetVolumeMatchingWeight(double VolumeMatchingWeight)
*/
public  void setVolumeMatchingWeight(double VolumeMatchingWeight) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setVolumeMatchingWeight(swigCPtr, this, VolumeMatchingWeight);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetVolumeMatchingWeight() const
*/
public  double getVolumeMatchingWeight() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getVolumeMatchingWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetHeavisideStepFunction(HeavisideStepFunctionType HeavisideStepFunction)
*/
public  void setHeavisideStepFunction(ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType HeavisideStepFunction) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setHeavisideStepFunction(swigCPtr, this, HeavisideStepFunction.swigValue());
  }

  /**
HeavisideStepFunctionType itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetHeavisideStepFunction() const
*/
public  ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType getHeavisideStepFunction() {
    return ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType.swigToEnum(SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getHeavisideStepFunction(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Use the image spacing information in calculations. Use this option if
you want derivatives in physical space. Default is UseImageSpacingOn.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetUseImageSpacing() const

Use the image spacing information in calculations. Use this option if
you want derivatives in physical space. Default is UseImageSpacingOn.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
uint32_t itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
std::string itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter::Execute(const Image &amp;initialImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.ScalarChanAndVeseDenseLevelSetImageFilter_execute(swigCPtr, this, Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public final static class HeavisideStepFunctionType {
    public final static ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType AtanRegularizedHeaviside = new ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType("AtanRegularizedHeaviside");
    public final static ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType SinRegularizedHeaviside = new ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType("SinRegularizedHeaviside");
    public final static ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType Heaviside = new ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType("Heaviside");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static HeavisideStepFunctionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + HeavisideStepFunctionType.class + " with value " + swigValue);
    }

    private HeavisideStepFunctionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private HeavisideStepFunctionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private HeavisideStepFunctionType(String swigName, HeavisideStepFunctionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static HeavisideStepFunctionType[] swigValues = { AtanRegularizedHeaviside, SinRegularizedHeaviside, Heaviside };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
