/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.coverage.gnu.trove.TIntHash;
import org.jetbrains.coverage.gnu.trove.TIntHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TIntIterator;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;

public class TIntHashSet
extends TIntHash
implements Serializable {
    public TIntHashSet() {
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int[] array) {
        this(array.length);
        void var1_1;
        this.addAll((int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(TIntHashingStrategy strategy) {
        super((TIntHashingStrategy)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initialCapacity, TIntHashingStrategy strategy) {
        super((int)var1_1, (TIntHashingStrategy)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super((int)var1_1, (float)var2_2, (TIntHashingStrategy)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int[] array, TIntHashingStrategy strategy) {
        this(array.length, (TIntHashingStrategy)var2_2);
        void var1_1;
        void var2_2;
        this.addAll((int[])var1_1);
    }

    public TIntIterator iterator() {
        return new TIntIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(int val) {
        void var3_3;
        void var1_1;
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = var1_1;
        this._states[var2_2] = 1;
        this.postInsertHook(var3_3 == false);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            void var2_2;
            if (oldStates[i] != 1) continue;
            int o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = var2_2;
            this._states[index] = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int[] toArray() {
        void var1_1;
        int[] result = new int[this.size()];
        int[] set = this._set;
        byte[] states = this._states;
        int i = this._states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result[j++] = set[i];
        }
        return var1_1;
    }

    public void clear() {
        super.clear();
        int[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0;
            states[i] = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (!(other instanceof TIntHashSet)) {
            return false;
        }
        TIntHashSet that = (TIntHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntProcedure((TIntHashSet)var1_1){
            final /* synthetic */ TIntHashSet val$that;
            {
                this.val$that = tIntHashSet2;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean execute(int value) {
                void var1_1;
                return this.val$that.contains((int)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return var1_1.getHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(int val) {
        int index = this.index(val);
        if (index >= 0) {
            void var1_1;
            this.removeAt((int)var1_1);
            return true;
        }
        return false;
    }

    public boolean containsAll(int[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAll(int[] array) {
        void var2_2;
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAll(int[] array) {
        void var2_2;
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean retainAll(int[] array) {
        void var2_2;
        boolean changed = false;
        Arrays.sort(array);
        int[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return (boolean)var2_2;
    }

    private final class HashProcedure
    implements TIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public final int getHashCode() {
            return this.h;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(int key) {
            void var1_1;
            this.h += TIntHashSet.this._hashingStrategy.computeHashCode((int)var1_1);
            return true;
        }
    }
}

