/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrReferenceListImpl
extends GrStubElementBase<GrReferenceListStub>
implements StubBasedPsiElement<GrReferenceListStub>,
GrReferenceList,
PsiListLikeElement {
    private static final Logger LOG = Logger.getInstance(GrReferenceListImpl.class);
    private PsiClassType[] myCachedTypes;

    public GrReferenceListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrReferenceListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            GrReferenceListImpl.$$$reportNull$$$0(1);
        }
        if ((psi = child.getPsi()) instanceof GrCodeReferenceElement) {
            GrCodeReferenceElement[] refs = this.getReferenceElementsGroovy();
            if (refs.length == 1) {
                PsiElement keyword = this.getKeyword();
                LOG.assertTrue(keyword != null);
                keyword.delete();
            } else {
                PsiElement comma;
                boolean forward = refs[0] == psi;
                PsiElement psiElement = comma = forward ? PsiUtil.skipWhitespacesAndComments(psi.getNextSibling(), true, true) : PsiUtil.skipWhitespacesAndComments(psi.getPrevSibling(), false, true);
                if (comma != null && comma.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                    comma.delete();
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public PsiElement getKeyword() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null && firstChild.getNode().getElementType() == this.getKeywordType()) {
            return firstChild;
        }
        return null;
    }

    public GrReferenceListImpl(GrReferenceListStub stub, IStubElementType elementType) {
        super(stub, elementType);
    }

    @Override
    public GrCodeReferenceElement @NotNull [] getReferenceElementsGroovy() {
        GrReferenceListStub stub = (GrReferenceListStub)this.getStub();
        if (stub != null) {
            String[] baseClasses = stub.getBaseClasses();
            GrCodeReferenceElement[] result2 = new GrCodeReferenceElement[baseClasses.length];
            for (int i2 = 0; i2 < baseClasses.length; ++i2) {
                result2[i2] = GroovyPsiElementFactory.getInstance(this.getProject()).createCodeReference(baseClasses[i2], this);
            }
            if (result2 == null) {
                GrReferenceListImpl.$$$reportNull$$$0(2);
            }
            return result2;
        }
        GrCodeReferenceElement[] grCodeReferenceElementArray = (GrCodeReferenceElement[])this.findChildrenByClass(GrCodeReferenceElement.class);
        if (grCodeReferenceElementArray == null) {
            GrReferenceListImpl.$$$reportNull$$$0(3);
        }
        return grCodeReferenceElementArray;
    }

    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] cachedTypes = this.myCachedTypes;
        if (cachedTypes == null || !this.isValid()) {
            GrCodeReferenceElement[] elementsGroovy = this.getReferenceElementsGroovy();
            cachedTypes = elementsGroovy.length == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[elementsGroovy.length];
            for (int i2 = 0; i2 < elementsGroovy.length; ++i2) {
                GrCodeReferenceElement ref2 = elementsGroovy[i2];
                cachedTypes[i2] = new GrClassReferenceType(ref2);
            }
            this.myCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            GrReferenceListImpl.$$$reportNull$$$0(4);
        }
        return cachedTypes;
    }

    public void subtreeChanged() {
        this.myCachedTypes = null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrReferenceListImpl.$$$reportNull$$$0(5);
        }
        if (element instanceof GrCodeReferenceElement || element instanceof PsiJavaCodeReferenceElement) {
            IElementType keywordType = this.getKeywordType();
            if (keywordType == null) {
                return super.add(element);
            }
            if (this.findChildByType(keywordType) == null) {
                this.getNode().getTreeParent().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", this.getNode());
                this.getNode().addLeaf(keywordType, (CharSequence)keywordType.toString(), null);
            } else if (this.findChildByClass(GrCodeReferenceElement.class) != null) {
                PsiElement lastChild = this.getLastChild();
                if (!(lastChild = PsiUtil.skipWhitespacesAndComments(lastChild, false)).getNode().getElementType().equals(GroovyTokenTypes.mCOMMA)) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
                }
            }
        }
        return super.add(element);
    }

    @Nullable
    protected abstract IElementType getKeywordType();

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<GrCodeReferenceElement> list = Arrays.asList(this.getReferenceElementsGroovy());
        if (list == null) {
            GrReferenceListImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrReferenceListImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrReferenceListImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementsGroovy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

