/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.internal.component.resolution.failure.SelectionReasonAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ConflictingConstraintsException;
import org.gradle.internal.component.resolution.failure.type.ModuleRejectedFailure;
import org.gradle.util.internal.VersionNumber;

public abstract class ModuleRejectedIncompatibleConstraintsFailureDescriber
extends AbstractResolutionFailureDescriber<ModuleRejectedFailure> {
    private static final String DEPENDENCY_INSIGHT_TASK_NAME = "dependencyInsight";
    private static final String DEBUGGING_WITH_DEPENDENCY_INSIGHT_PREFIX = "Debugging using the dependencyInsight report is described in more detail at: ";
    private static final String DEBUGGING_WITH_DEPENDENCY_INSIGHT_ID = "viewing_debugging_dependencies";
    private static final String DEBUGGING_WITH_DEPENDENCY_INSIGHT_SECTION = "sec:identifying-reason-dependency-selection";

    @Override
    public boolean canDescribeFailure(ModuleRejectedFailure failure) {
        List<SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason> versionsByReason = this.findConflictingConstraints(failure);
        int uniqueVersions = versionsByReason.stream().map(SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason::getRequiredVersion).collect(Collectors.toSet()).size();
        return uniqueVersions > 1;
    }

    private List<SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason> findConflictingConstraints(ModuleRejectedFailure failure) {
        Map<String, List<SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason>> versionsByReasons = failure.getAssessedSelection().getReasons().stream().filter(reason -> reason.getCause() == ComponentSelectionCause.CONSTRAINT).collect(Collectors.groupingBy(SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason::getRequiredVersion));
        return versionsByReasons.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public ConflictingConstraintsException describeFailure(ModuleRejectedFailure failure) {
        return new ConflictingConstraintsException(this.summarizeFailure(failure), failure, this.buildResolutions(failure));
    }

    private List<String> buildResolutions(ModuleRejectedFailure failure) {
        ArrayList<String> resolutions = new ArrayList<String>(failure.getResolutions().size() + 1);
        resolutions.addAll(failure.getResolutions());
        resolutions.add(DEBUGGING_WITH_DEPENDENCY_INSIGHT_PREFIX + this.getDocumentationRegistry().getDocumentationFor(DEBUGGING_WITH_DEPENDENCY_INSIGHT_ID, DEBUGGING_WITH_DEPENDENCY_INSIGHT_SECTION) + ".");
        return resolutions;
    }

    private String summarizeFailure(ModuleRejectedFailure failure) {
        HashMultimap conflictingVersionsWithExplanations = HashMultimap.create();
        this.findConflictingConstraints(failure).forEach(arg_0 -> this.lambda$summarizeFailure$1((Multimap)conflictingVersionsWithExplanations, arg_0));
        StringBuilder sb = new StringBuilder("Component is the target of multiple version constraints with conflicting requirements:\n");
        conflictingVersionsWithExplanations.keySet().stream().sorted().forEach(arg_0 -> ModuleRejectedIncompatibleConstraintsFailureDescriber.lambda$summarizeFailure$2((Multimap)conflictingVersionsWithExplanations, sb, arg_0));
        return sb.toString();
    }

    private String explainReason(SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason reason) {
        StringBuilder sb = new StringBuilder(reason.getRequiredVersion());
        if (reason.isFromLock()) {
            sb.append(" - from lock file");
        } else {
            int pathLength = reason.getSegmentedSelectionPath().size();
            if (pathLength == 2) {
                sb.append(" - directly in ").append(reason.getSegmentedSelectionPath().get(1));
            } else if (pathLength > 2) {
                sb.append(" - transitively via ").append(reason.getSegmentedSelectionPath().get(1));
            }
        }
        return sb.toString();
    }

    private static /* synthetic */ void lambda$summarizeFailure$2(Multimap conflictingVersionsWithExplanations, StringBuilder sb, VersionNumber version) {
        List explanations = conflictingVersionsWithExplanations.get((Object)version).stream().sorted().collect(Collectors.toList());
        sb.append((String)explanations.get(0));
        int numOtherPaths = explanations.size() - 1;
        if (numOtherPaths > 0) {
            sb.append(" (").append(numOtherPaths).append(" other path");
            if (numOtherPaths > 1) {
                sb.append("s");
            }
            sb.append(" to this version)");
        }
        sb.append("\n");
    }

    private /* synthetic */ void lambda$summarizeFailure$1(Multimap conflictingVersionsWithExplanations, SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason v) {
        VersionNumber version = VersionNumber.parse((String)v.getRequiredVersion());
        String explanation = this.explainReason(v);
        conflictingVersionsWithExplanations.put((Object)version, (Object)explanation);
    }
}

