# frozen_string_literal: true

class AddUniqueIndexVulnerabilityReadsOnOccurrenceId < Gitlab::Database::Migration[2.3]
  milestone '18.9'

  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_reads_on_vulnerability_occurrence_id_unique'

  def up
    # rubocop:disable Migration/PreventIndexCreation -- Required for unique constraint on vulnerability_occurrence_id will replace existing vulnerability_id index
    prepare_async_index :vulnerability_reads, :vulnerability_occurrence_id,
      unique: true,
      nulls_not_distinct: false,
      name: INDEX_NAME
    # rubocop:enable Migration/PreventIndexCreation
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
