/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class NewTradeRouteMessage
extends ObjectMessage {
    public static final String TAG = "newTradeRoute";

    public NewTradeRouteMessage(TradeRoute tradeRoute) {
        super(TAG);
        this.appendChild(tradeRoute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewTradeRouteMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this((TradeRoute)null);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        TradeRoute tradeRoute = null;
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("tradeRoute".equals(tag)) {
                    if (tradeRoute == null) {
                        tradeRoute = xr.readFreeColObject(game, TradeRoute.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected("tradeRoute", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(tradeRoute);
    }

    private TradeRoute getTradeRoute() {
        return this.getChild(0, TradeRoute.class);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        TradeRoute tr = this.getTradeRoute();
        if (tr == null) {
            return;
        }
        tr.intern();
        this.igc(freeColClient).newTradeRouteHandler(tr);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return this.igc(freeColServer).newTradeRoute(serverPlayer);
    }
}

