﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/kinesis/Kinesis_EXPORTS.h>
#include <aws/kinesis/model/Consumer.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Kinesis
{
namespace Model
{
  class RegisterStreamConsumerResult
  {
  public:
    AWS_KINESIS_API RegisterStreamConsumerResult() = default;
    AWS_KINESIS_API RegisterStreamConsumerResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_KINESIS_API RegisterStreamConsumerResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An object that represents the details of the consumer you registered. When
     * you register a consumer, it gets an ARN that is generated by Kinesis Data
     * Streams.</p>
     */
    inline const Consumer& GetConsumer() const { return m_consumer; }
    template<typename ConsumerT = Consumer>
    void SetConsumer(ConsumerT&& value) { m_consumerHasBeenSet = true; m_consumer = std::forward<ConsumerT>(value); }
    template<typename ConsumerT = Consumer>
    RegisterStreamConsumerResult& WithConsumer(ConsumerT&& value) { SetConsumer(std::forward<ConsumerT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    RegisterStreamConsumerResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Consumer m_consumer;
    bool m_consumerHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace Kinesis
} // namespace Aws
