﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm-guiconnect/SSMGuiConnect_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SSMGuiConnect {
namespace Model {

/**
 * <p>The S3 bucket where RDP connection recordings are stored.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/S3Bucket">AWS
 * API Reference</a></p>
 */
class S3Bucket {
 public:
  AWS_SSMGUICONNECT_API S3Bucket() = default;
  AWS_SSMGUICONNECT_API S3Bucket(Aws::Utils::Json::JsonView jsonValue);
  AWS_SSMGUICONNECT_API S3Bucket& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SSMGUICONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the S3 bucket where RDP connection recordings are stored.</p>
   */
  inline const Aws::String& GetBucketName() const { return m_bucketName; }
  inline bool BucketNameHasBeenSet() const { return m_bucketNameHasBeenSet; }
  template <typename BucketNameT = Aws::String>
  void SetBucketName(BucketNameT&& value) {
    m_bucketNameHasBeenSet = true;
    m_bucketName = std::forward<BucketNameT>(value);
  }
  template <typename BucketNameT = Aws::String>
  S3Bucket& WithBucketName(BucketNameT&& value) {
    SetBucketName(std::forward<BucketNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services account number that owns the S3 bucket.</p>
   */
  inline const Aws::String& GetBucketOwner() const { return m_bucketOwner; }
  inline bool BucketOwnerHasBeenSet() const { return m_bucketOwnerHasBeenSet; }
  template <typename BucketOwnerT = Aws::String>
  void SetBucketOwner(BucketOwnerT&& value) {
    m_bucketOwnerHasBeenSet = true;
    m_bucketOwner = std::forward<BucketOwnerT>(value);
  }
  template <typename BucketOwnerT = Aws::String>
  S3Bucket& WithBucketOwner(BucketOwnerT&& value) {
    SetBucketOwner(std::forward<BucketOwnerT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_bucketName;

  Aws::String m_bucketOwner;
  bool m_bucketNameHasBeenSet = false;
  bool m_bucketOwnerHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSMGuiConnect
}  // namespace Aws
