﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chatbot/Chatbot_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace chatbot {
namespace Model {

/**
 * <p>A Microsoft Teams team that is authorized with AWS Chatbot.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ConfiguredTeam">AWS
 * API Reference</a></p>
 */
class ConfiguredTeam {
 public:
  AWS_CHATBOT_API ConfiguredTeam() = default;
  AWS_CHATBOT_API ConfiguredTeam(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHATBOT_API ConfiguredTeam& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHATBOT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the Microsoft Teams tenant.</p>
   */
  inline const Aws::String& GetTenantId() const { return m_tenantId; }
  inline bool TenantIdHasBeenSet() const { return m_tenantIdHasBeenSet; }
  template <typename TenantIdT = Aws::String>
  void SetTenantId(TenantIdT&& value) {
    m_tenantIdHasBeenSet = true;
    m_tenantId = std::forward<TenantIdT>(value);
  }
  template <typename TenantIdT = Aws::String>
  ConfiguredTeam& WithTenantId(TenantIdT&& value) {
    SetTenantId(std::forward<TenantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the
   * team ID, you must perform the initial authorization flow with Microsoft Teams in
   * the AWS Chatbot console. Then you can copy and paste the team ID from the
   * console. For more information, see <a
   * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step
   * 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator
   * Guide</i>. </p>
   */
  inline const Aws::String& GetTeamId() const { return m_teamId; }
  inline bool TeamIdHasBeenSet() const { return m_teamIdHasBeenSet; }
  template <typename TeamIdT = Aws::String>
  void SetTeamId(TeamIdT&& value) {
    m_teamIdHasBeenSet = true;
    m_teamId = std::forward<TeamIdT>(value);
  }
  template <typename TeamIdT = Aws::String>
  ConfiguredTeam& WithTeamId(TeamIdT&& value) {
    SetTeamId(std::forward<TeamIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Microsoft Teams Team.</p>
   */
  inline const Aws::String& GetTeamName() const { return m_teamName; }
  inline bool TeamNameHasBeenSet() const { return m_teamNameHasBeenSet; }
  template <typename TeamNameT = Aws::String>
  void SetTeamName(TeamNameT&& value) {
    m_teamNameHasBeenSet = true;
    m_teamName = std::forward<TeamNameT>(value);
  }
  template <typename TeamNameT = Aws::String>
  ConfiguredTeam& WithTeamName(TeamNameT&& value) {
    SetTeamName(std::forward<TeamNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns
   * <code>DISABLED</code> if the organization's AWS Chatbot policy has explicitly
   * denied that configuration. For example, if Amazon Chime is disabled.</p>
   */
  inline const Aws::String& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = Aws::String>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = Aws::String>
  ConfiguredTeam& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Provided if State is <code>DISABLED</code>. Provides context as to why the
   * resource is disabled.</p>
   */
  inline const Aws::String& GetStateReason() const { return m_stateReason; }
  inline bool StateReasonHasBeenSet() const { return m_stateReasonHasBeenSet; }
  template <typename StateReasonT = Aws::String>
  void SetStateReason(StateReasonT&& value) {
    m_stateReasonHasBeenSet = true;
    m_stateReason = std::forward<StateReasonT>(value);
  }
  template <typename StateReasonT = Aws::String>
  ConfiguredTeam& WithStateReason(StateReasonT&& value) {
    SetStateReason(std::forward<StateReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_tenantId;

  Aws::String m_teamId;

  Aws::String m_teamName;

  Aws::String m_state;

  Aws::String m_stateReason;
  bool m_tenantIdHasBeenSet = false;
  bool m_teamIdHasBeenSet = false;
  bool m_teamNameHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_stateReasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace chatbot
}  // namespace Aws
