﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplifybackend/AmplifyBackend_EXPORTS.h>
#include <aws/amplifybackend/model/BackendAPIResourceConfig.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AmplifyBackend {
namespace Model {
class GetBackendAPIResult {
 public:
  AWS_AMPLIFYBACKEND_API GetBackendAPIResult() = default;
  AWS_AMPLIFYBACKEND_API GetBackendAPIResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_AMPLIFYBACKEND_API GetBackendAPIResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The app ID.</p>
   */
  inline const Aws::String& GetAppId() const { return m_appId; }
  template <typename AppIdT = Aws::String>
  void SetAppId(AppIdT&& value) {
    m_appIdHasBeenSet = true;
    m_appId = std::forward<AppIdT>(value);
  }
  template <typename AppIdT = Aws::String>
  GetBackendAPIResult& WithAppId(AppIdT&& value) {
    SetAppId(std::forward<AppIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the backend environment.</p>
   */
  inline const Aws::String& GetBackendEnvironmentName() const { return m_backendEnvironmentName; }
  template <typename BackendEnvironmentNameT = Aws::String>
  void SetBackendEnvironmentName(BackendEnvironmentNameT&& value) {
    m_backendEnvironmentNameHasBeenSet = true;
    m_backendEnvironmentName = std::forward<BackendEnvironmentNameT>(value);
  }
  template <typename BackendEnvironmentNameT = Aws::String>
  GetBackendAPIResult& WithBackendEnvironmentName(BackendEnvironmentNameT&& value) {
    SetBackendEnvironmentName(std::forward<BackendEnvironmentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the request fails, this error is returned.</p>
   */
  inline const Aws::String& GetError() const { return m_error; }
  template <typename ErrorT = Aws::String>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = Aws::String>
  GetBackendAPIResult& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource configuration for this response object.</p>
   */
  inline const BackendAPIResourceConfig& GetResourceConfig() const { return m_resourceConfig; }
  template <typename ResourceConfigT = BackendAPIResourceConfig>
  void SetResourceConfig(ResourceConfigT&& value) {
    m_resourceConfigHasBeenSet = true;
    m_resourceConfig = std::forward<ResourceConfigT>(value);
  }
  template <typename ResourceConfigT = BackendAPIResourceConfig>
  GetBackendAPIResult& WithResourceConfig(ResourceConfigT&& value) {
    SetResourceConfig(std::forward<ResourceConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of this resource.</p>
   */
  inline const Aws::String& GetResourceName() const { return m_resourceName; }
  template <typename ResourceNameT = Aws::String>
  void SetResourceName(ResourceNameT&& value) {
    m_resourceNameHasBeenSet = true;
    m_resourceName = std::forward<ResourceNameT>(value);
  }
  template <typename ResourceNameT = Aws::String>
  GetBackendAPIResult& WithResourceName(ResourceNameT&& value) {
    SetResourceName(std::forward<ResourceNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetBackendAPIResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appId;

  Aws::String m_backendEnvironmentName;

  Aws::String m_error;

  BackendAPIResourceConfig m_resourceConfig;

  Aws::String m_resourceName;

  Aws::String m_requestId;
  bool m_appIdHasBeenSet = false;
  bool m_backendEnvironmentNameHasBeenSet = false;
  bool m_errorHasBeenSet = false;
  bool m_resourceConfigHasBeenSet = false;
  bool m_resourceNameHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AmplifyBackend
}  // namespace Aws
