/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM SecurityPolicyViolationEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "SecurityPolicyViolationEvent.h"
#include "SecurityPolicyViolationEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/SecurityPolicyViolationEvent.h"

namespace mozilla::dom {


SecurityPolicyViolationEvent::SecurityPolicyViolationEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

SecurityPolicyViolationEvent::~SecurityPolicyViolationEvent()
{
}

SecurityPolicyViolationEvent*
SecurityPolicyViolationEvent::AsSecurityPolicyViolationEvent()
{
  return this;
}

JSObject*
SecurityPolicyViolationEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return SecurityPolicyViolationEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<SecurityPolicyViolationEvent>
SecurityPolicyViolationEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SecurityPolicyViolationEventInit& aEventInitDict)
{
  RefPtr<SecurityPolicyViolationEvent> e = new SecurityPolicyViolationEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mDocumentURI = aEventInitDict.mDocumentURI;
  e->mReferrer = aEventInitDict.mReferrer;
  e->mBlockedURI = aEventInitDict.mBlockedURI;
  e->mViolatedDirective = aEventInitDict.mViolatedDirective;
  e->mEffectiveDirective = aEventInitDict.mEffectiveDirective;
  e->mOriginalPolicy = aEventInitDict.mOriginalPolicy;
  e->mSourceFile = aEventInitDict.mSourceFile;
  e->mSample = aEventInitDict.mSample;
  e->mDisposition = aEventInitDict.mDisposition;
  e->mStatusCode = aEventInitDict.mStatusCode;
  e->mLineNumber = aEventInitDict.mLineNumber;
  e->mColumnNumber = aEventInitDict.mColumnNumber;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<SecurityPolicyViolationEvent>
SecurityPolicyViolationEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SecurityPolicyViolationEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
SecurityPolicyViolationEvent::GetDocumentURI(nsString& aRetVal) const
{
  aRetVal = mDocumentURI;
}

void
SecurityPolicyViolationEvent::GetReferrer(nsString& aRetVal) const
{
  aRetVal = mReferrer;
}

void
SecurityPolicyViolationEvent::GetBlockedURI(nsString& aRetVal) const
{
  aRetVal = mBlockedURI;
}

void
SecurityPolicyViolationEvent::GetViolatedDirective(nsString& aRetVal) const
{
  aRetVal = mViolatedDirective;
}

void
SecurityPolicyViolationEvent::GetEffectiveDirective(nsString& aRetVal) const
{
  aRetVal = mEffectiveDirective;
}

void
SecurityPolicyViolationEvent::GetOriginalPolicy(nsString& aRetVal) const
{
  aRetVal = mOriginalPolicy;
}

void
SecurityPolicyViolationEvent::GetSourceFile(nsString& aRetVal) const
{
  aRetVal = mSourceFile;
}

void
SecurityPolicyViolationEvent::GetSample(nsString& aRetVal) const
{
  aRetVal = mSample;
}

SecurityPolicyViolationEventDisposition
SecurityPolicyViolationEvent::Disposition() const
{
  return mDisposition;
}

uint16_t
SecurityPolicyViolationEvent::StatusCode() const
{
  return mStatusCode;
}

uint32_t
SecurityPolicyViolationEvent::LineNumber() const
{
  return mLineNumber;
}

uint32_t
SecurityPolicyViolationEvent::ColumnNumber() const
{
  return mColumnNumber;
}


} // namespace mozilla::dom
