// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSecuritySandboxMetrics_h
#define mozilla_GleanSecuritySandboxMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace sandbox {
  /**
   * generated from sandbox.content_win32k_lockdown_state
   * The current win32k.sys lockdown state.
   * Possible values are defined in the ContentWin32kLockdownState enum.
   * Reported even on non-Windows machines.
   */
  constexpr impl::QuantityMetric content_win32k_lockdown_state(4526);

  /**
   * generated from sandbox.effective_content_process_level
   * The current sandbox level.
   * The "security.sandbox.content.level" preference rounded up to the current minimum allowed level.
   * 0 if `MOZ_DISABLE_CONTENT_SANDBOX` is set.
   */
  constexpr impl::QuantityMetric effective_content_process_level(4527);

  /**
   * generated from sandbox.failed_launch_keyed
   * Error code when a Windows sandboxed process fails to launch, keyed by process type and Windows error code. See https://searchfox.org/mozilla-central/search?q=ResultCode++path%3Asandbox_types.h&redirect=true for definitions of the error codes.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SANDBOX_FAILED_LAUNCH_KEYED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> failed_launch_keyed(4528);

  /**
   * generated from sandbox.rejected_syscalls
   * System calls blocked by a seccomp-bpf sandbox policy; limited to syscalls where we would crash on Nightly.  The key is generally the architecture and syscall ID but in some cases we include non-personally-identifying information from the syscall arguments; see the function SubmitToTelemetry in security/sandbox/linux/reporter/SandboxReporter.cpp for details.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SANDBOX_REJECTED_SYSCALLS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> rejected_syscalls(4529);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSecuritySandboxMetrics_h
