// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanIpcMetrics_h
#define mozilla_GleanIpcMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace ipc {
  /**
   * generated from ipc.transaction_cancel
   */
  enum class TransactionCancelLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * True when an IPC transaction is canceled
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram IPC_TRANSACTION_CANCEL.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TransactionCancelLabel> transaction_cancel(4161);
}

namespace process {
  /**
   * generated from process.child_launch
   * Time spent in the generic child process launching code, which is run off-main-thread and used by all child process types
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CHILD_PROCESS_LAUNCH_MS.
   */
  constexpr impl::TimingDistributionMetric child_launch(4162);
}

namespace subprocess {
  /**
   * generated from subprocess.abnormal_abort
   * Counts of plugin/content process abnormal shutdown, whether or not a crash report was available.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SUBPROCESS_ABNORMAL_ABORT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> abnormal_abort(4163);

  /**
   * generated from subprocess.crashes_with_dump
   * Counts of plugin and content process crashes which are reported with a crash dump.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SUBPROCESS_CRASHES_WITH_DUMP.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> crashes_with_dump(4164);

  /**
   * generated from subprocess.kill_hard
   * Counts the number of times a subprocess was forcibly killed, and the reason.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SUBPROCESS_KILL_HARD.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> kill_hard(4165);

  /**
   * generated from subprocess.launch_failure
   * Counts the number of times launching a subprocess fails. Counts are by subprocess-type using the GeckoProcessType enum.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SUBPROCESS_LAUNCH_FAILURE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> launch_failure(4166);
}

} // namespace mozilla::glean

#endif // mozilla_GleanIpcMetrics_h
