/* THIS FILE IS AUTOGENERATED FROM FileReader.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_FILEREADERBINDING_H_
#define DOM_FILEREADERBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class FileReader;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

class StringOrArrayBuffer : public AllUnionBase,
                            public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<StringOrArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrArrayBuffer(const StringOrArrayBuffer&) = delete;
  StringOrArrayBuffer& operator=(const StringOrArrayBuffer&) = delete;
public:
  explicit inline StringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrArrayBuffer : public AllOwningUnionBase,
                                  public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningStringOrArrayBuffer, true, ArrayBuffer>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eArrayBuffer
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eArrayBuffer = TypeOrUninit::eArrayBuffer
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<ArrayBuffer > mArrayBuffer;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrArrayBuffer(const OwningStringOrArrayBuffer&) = delete;
  OwningStringOrArrayBuffer& operator=(const OwningStringOrArrayBuffer&) = delete;
public:
  explicit inline OwningStringOrArrayBuffer()
    : mType(eUninitialized)
  {
  }

  OwningStringOrArrayBuffer(OwningStringOrArrayBuffer&& aOther);

  inline ~OwningStringOrArrayBuffer()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrArrayBuffer&
  operator=(OwningStringOrArrayBuffer&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();
};


namespace FileReader_Binding {

  typedef mozilla::dom::FileReader NativeType;

  static const uint16_t EMPTY = 0;
  static const uint16_t LOADING = 1;
  static const uint16_t DONE = 2;
  bool
  Wrap(JSContext* aCx, mozilla::dom::FileReader* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::FileReader,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace FileReader_Binding



} // namespace mozilla::dom

#endif // DOM_FILEREADERBINDING_H_
