/* Generated by wayland-scanner 1.24.0 */

#ifndef XX_CUTOUTS_UNSTABLE_V1_SERVER_PROTOCOL_H
#define XX_CUTOUTS_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xx_cutouts_unstable_v1 The xx_cutouts_unstable_v1 protocol
 * Protocol to describe cut out surface regions
 *
 * @section page_desc_xx_cutouts_unstable_v1 Description
 *
 * This protocol describes the areas of a toplevel that are cut out
 * of the available surface area by hardware elements present in the
 * physical display. This allows clients to avoid placing user interface
 * elements in those areas.
 *
 * Typical cutout areas are notches (i.e. embedding a camera) or
 * "waterfall" display edges. In the case of a notch the compositor
 * would usually supply the bounding box of the notch or an
 * approximation by multiple rectangles. Thus a single physical
 * element in the display can correspond to multiple cutout events in
 * the protocol.
 *
 * The protocol currently supports xdg_toplevel surfaces but is meant
 * to be extended to other surfaces (like layer surfaces) in the
 * future.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible
 * changes may be added together with the corresponding interface
 * version bump. Backward incompatible changes can only be done by
 * creating a new major version of the extension.
 *
 * @section page_ifaces_xx_cutouts_unstable_v1 Interfaces
 * - @subpage page_iface_xx_cutouts_manager_v1 - Display cutouts area manager
 * - @subpage page_iface_xx_cutouts_v1 - cutout regions information
 * @section page_copyright_xx_cutouts_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2026 Phosh.mobi e.V.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Warning! The protocol described in this file is currently in the
 * experimental phase. Backwards incompatible major versions of the protocol
 * are to be expected. Exposing this protocol without an opt-in mechanism is
 * discouraged.
 * </pre>
 */
struct wl_surface;
struct xx_cutouts_manager_v1;
struct xx_cutouts_v1;

#ifndef XX_CUTOUTS_MANAGER_V1_INTERFACE
#define XX_CUTOUTS_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xx_cutouts_manager_v1 xx_cutouts_manager_v1
 * @section page_iface_xx_cutouts_manager_v1_desc Description
 *
 * This interface allows a compositor to announce support for
 * supplying cutout information to the client.
 * @section page_iface_xx_cutouts_manager_v1_api API
 * See @ref iface_xx_cutouts_manager_v1.
 */
/**
 * @defgroup iface_xx_cutouts_manager_v1 The xx_cutouts_manager_v1 interface
 *
 * This interface allows a compositor to announce support for
 * supplying cutout information to the client.
 */
extern const struct wl_interface xx_cutouts_manager_v1_interface;
#endif
#ifndef XX_CUTOUTS_V1_INTERFACE
#define XX_CUTOUTS_V1_INTERFACE
/**
 * @page page_iface_xx_cutouts_v1 xx_cutouts_v1
 * @section page_iface_xx_cutouts_v1_desc Description
 *
 * An xx_cutouts describes the areas currently "cut out" of a
 * toplevel.
 *
 * Each cutout event carries an id that identifies the
 * physical element. If the compositor describes an element by
 * multiple cutout events these should use the same element
 * id. A typical example is a curved notch that is approximated
 * by several cutout_box elements. Using the same element
 * id allows the client to identify that these belong to the
 * same physical object. Ids are only valid during one configure
 * sequence. No guarantee is given that the same id identifies
 * the same element in different configure sequences.
 *
 * Typically compositors would only send cutout information when
 * the toplevel enters fullscreen or maxmized state (as specified
 * in the xdg_shell protocol).
 *
 * The xx_cutouts_v1 object must be destroyed before its
 * underlying xdg_toplevel and wl_surface. Otherwise the
 * defunct_cutouts_object protocol error will be send.
 * @section page_iface_xx_cutouts_v1_api API
 * See @ref iface_xx_cutouts_v1.
 */
/**
 * @defgroup iface_xx_cutouts_v1 The xx_cutouts_v1 interface
 *
 * An xx_cutouts describes the areas currently "cut out" of a
 * toplevel.
 *
 * Each cutout event carries an id that identifies the
 * physical element. If the compositor describes an element by
 * multiple cutout events these should use the same element
 * id. A typical example is a curved notch that is approximated
 * by several cutout_box elements. Using the same element
 * id allows the client to identify that these belong to the
 * same physical object. Ids are only valid during one configure
 * sequence. No guarantee is given that the same id identifies
 * the same element in different configure sequences.
 *
 * Typically compositors would only send cutout information when
 * the toplevel enters fullscreen or maxmized state (as specified
 * in the xdg_shell protocol).
 *
 * The xx_cutouts_v1 object must be destroyed before its
 * underlying xdg_toplevel and wl_surface. Otherwise the
 * defunct_cutouts_object protocol error will be send.
 */
extern const struct wl_interface xx_cutouts_v1_interface;
#endif

#ifndef XX_CUTOUTS_MANAGER_V1_ERROR_ENUM
#define XX_CUTOUTS_MANAGER_V1_ERROR_ENUM
enum xx_cutouts_manager_v1_error {
	/**
	 * given wl_surface has incorrect role
	 */
	XX_CUTOUTS_MANAGER_V1_ERROR_INVALID_ROLE = 0,
	/**
	 * wl_surface or surface role was destroyed before the cutouts object
	 */
	XX_CUTOUTS_MANAGER_V1_ERROR_DEFUNCT_CUTOUTS_OBJECT = 1,
};
#endif /* XX_CUTOUTS_MANAGER_V1_ERROR_ENUM */

#ifndef XX_CUTOUTS_MANAGER_V1_ERROR_ENUM_IS_VALID
#define XX_CUTOUTS_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xx_cutouts_manager_v1
 * Validate a xx_cutouts_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xx_cutouts_manager_v1_error
 */
static inline bool
xx_cutouts_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_CUTOUTS_MANAGER_V1_ERROR_INVALID_ROLE:
		return version >= 1;
	case XX_CUTOUTS_MANAGER_V1_ERROR_DEFUNCT_CUTOUTS_OBJECT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_CUTOUTS_MANAGER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_xx_cutouts_manager_v1
 * @struct xx_cutouts_manager_v1_interface
 */
struct xx_cutouts_manager_v1_interface {
	/**
	 * destroy the xx_cutouts_manager object
	 *
	 * Using this request a client can tell the server that it is not
	 * going to use the xx_cutouts_manger object anymore.
	 *
	 * Any objects already created through this instance are not
	 * affected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a cutout notifier from a xdg toplevel
	 *
	 * This creates a new xx_cutouts object for the given surface.
	 * The role of the surface must be xdg_toplevel otherwise an
	 * invalid_role protocol error will be raised. Later versions of
	 * this protocol might allow for other surface roles.
	 */
	void (*get_cutouts)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    struct wl_resource *surface);
};


/**
 * @ingroup iface_xx_cutouts_manager_v1
 */
#define XX_CUTOUTS_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_cutouts_manager_v1
 */
#define XX_CUTOUTS_MANAGER_V1_GET_CUTOUTS_SINCE_VERSION 1

#ifndef XX_CUTOUTS_V1_TYPE_ENUM
#define XX_CUTOUTS_V1_TYPE_ENUM
/**
 * @ingroup iface_xx_cutouts_v1
 * Cutout type
 *
 * These values indicate the type of cutout. The information is
 * meant to help clients to decide whether they can possibly
 * ignore the element.
 */
enum xx_cutouts_v1_type {
	/**
	 * A generic cutout
	 *
	 * This element type can be used by the compositor if it doesn't
	 * want to provide a more specific type.
	 */
	XX_CUTOUTS_V1_TYPE_CUTOUT = 0,
	/**
	 * Small functional cutout area
	 *
	 * A functional, irregular shape on one of the device's edges. It
	 * often contains a camera.
	 */
	XX_CUTOUTS_V1_TYPE_NOTCH = 1,
	/**
	 * A curved display edge
	 *
	 * A curved display edge intended to make the device appear like
	 * not having any bezel.
	 */
	XX_CUTOUTS_V1_TYPE_WATERFALL = 2,
};
#endif /* XX_CUTOUTS_V1_TYPE_ENUM */

#ifndef XX_CUTOUTS_V1_TYPE_ENUM_IS_VALID
#define XX_CUTOUTS_V1_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_xx_cutouts_v1
 * Validate a xx_cutouts_v1 type value.
 *
 * @return true on success, false on error.
 * @ref xx_cutouts_v1_type
 */
static inline bool
xx_cutouts_v1_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_CUTOUTS_V1_TYPE_CUTOUT:
		return version >= 1;
	case XX_CUTOUTS_V1_TYPE_NOTCH:
		return version >= 1;
	case XX_CUTOUTS_V1_TYPE_WATERFALL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_CUTOUTS_V1_TYPE_ENUM_IS_VALID */

#ifndef XX_CUTOUTS_V1_CORNER_POSITION_ENUM
#define XX_CUTOUTS_V1_CORNER_POSITION_ENUM
/**
 * @ingroup iface_xx_cutouts_v1
 * Corner position
 *
 * The position of a corner on a surface
 */
enum xx_cutouts_v1_corner_position {
	XX_CUTOUTS_V1_CORNER_POSITION_TOP_LEFT = 0,
	XX_CUTOUTS_V1_CORNER_POSITION_TOP_RIGHT = 1,
	XX_CUTOUTS_V1_CORNER_POSITION_BOTTOM_RIGHT = 2,
	XX_CUTOUTS_V1_CORNER_POSITION_BOTTOM_LEFT = 3,
};
#endif /* XX_CUTOUTS_V1_CORNER_POSITION_ENUM */

#ifndef XX_CUTOUTS_V1_CORNER_POSITION_ENUM_IS_VALID
#define XX_CUTOUTS_V1_CORNER_POSITION_ENUM_IS_VALID
/**
 * @ingroup iface_xx_cutouts_v1
 * Validate a xx_cutouts_v1 corner_position value.
 *
 * @return true on success, false on error.
 * @ref xx_cutouts_v1_corner_position
 */
static inline bool
xx_cutouts_v1_corner_position_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_CUTOUTS_V1_CORNER_POSITION_TOP_LEFT:
		return version >= 1;
	case XX_CUTOUTS_V1_CORNER_POSITION_TOP_RIGHT:
		return version >= 1;
	case XX_CUTOUTS_V1_CORNER_POSITION_BOTTOM_RIGHT:
		return version >= 1;
	case XX_CUTOUTS_V1_CORNER_POSITION_BOTTOM_LEFT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_CUTOUTS_V1_CORNER_POSITION_ENUM_IS_VALID */

#ifndef XX_CUTOUTS_V1_ERROR_ENUM
#define XX_CUTOUTS_V1_ERROR_ENUM
enum xx_cutouts_v1_error {
	/**
	 * Invalid element id in a set_unhandled request
	 */
	XX_CUTOUTS_V1_ERROR_INVALID_ELEMENT_ID = 0,
};
#endif /* XX_CUTOUTS_V1_ERROR_ENUM */

#ifndef XX_CUTOUTS_V1_ERROR_ENUM_IS_VALID
#define XX_CUTOUTS_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xx_cutouts_v1
 * Validate a xx_cutouts_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xx_cutouts_v1_error
 */
static inline bool
xx_cutouts_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_CUTOUTS_V1_ERROR_INVALID_ELEMENT_ID:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_CUTOUTS_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_xx_cutouts_v1
 * @struct xx_cutouts_v1_interface
 */
struct xx_cutouts_v1_interface {
	/**
	 * destroy the xx_cutouts object
	 *
	 * Using this request a client can tell the server that it is not
	 * going to use the xx_cutouts object anymore.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * Notify about unhandled cutouts
	 *
	 * If a client doesn't handle one or more cutouts in the to be
	 * acked sequence, it can add their element's id to the unhandled
	 * array. The compositor might then try to reposition the surface
	 * in a way that avoids these elements in a future configure
	 * sequence.
	 *
	 * The request (if used) must be sent before acking the configure
	 * sequence. State set with this request is double-buffered. It
	 * will get applied on the next ack_configure and stay valid until
	 * the next configure event.
	 * @param unhandled array of unhandled element ids
	 */
	void (*set_unhandled)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_array *unhandled);
};

#define XX_CUTOUTS_V1_CUTOUT_BOX 0
#define XX_CUTOUTS_V1_CUTOUT_CORNER 1
#define XX_CUTOUTS_V1_CONFIGURE 2

/**
 * @ingroup iface_xx_cutouts_v1
 */
#define XX_CUTOUTS_V1_CUTOUT_BOX_SINCE_VERSION 1
/**
 * @ingroup iface_xx_cutouts_v1
 */
#define XX_CUTOUTS_V1_CUTOUT_CORNER_SINCE_VERSION 1
/**
 * @ingroup iface_xx_cutouts_v1
 */
#define XX_CUTOUTS_V1_CONFIGURE_SINCE_VERSION 1

/**
 * @ingroup iface_xx_cutouts_v1
 */
#define XX_CUTOUTS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_cutouts_v1
 */
#define XX_CUTOUTS_V1_SET_UNHANDLED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_cutouts_v1
 * Sends an cutout_box event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x coordinate of the box's top left corner
 * @param y y coordinate of the box's top left corner
 * @param type The type of cutout
 * @param id An identifier identifying the physical element
 */
static inline void
xx_cutouts_v1_send_cutout_box(struct wl_resource *resource_, int32_t x, int32_t y, int32_t width, int32_t height, uint32_t type, uint32_t id)
{
	wl_resource_post_event(resource_, XX_CUTOUTS_V1_CUTOUT_BOX, x, y, width, height, type, id);
}

/**
 * @ingroup iface_xx_cutouts_v1
 * Sends an cutout_corner event to the client owning the resource.
 * @param resource_ The client's resource
 * @param position The position of the described corner
 * @param radius The corner's radius
 * @param id An identifier identifying the physical element
 */
static inline void
xx_cutouts_v1_send_cutout_corner(struct wl_resource *resource_, uint32_t position, uint32_t radius, uint32_t id)
{
	wl_resource_post_event(resource_, XX_CUTOUTS_V1_CUTOUT_CORNER, position, radius, id);
}

/**
 * @ingroup iface_xx_cutouts_v1
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_cutouts_v1_send_configure(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_CUTOUTS_V1_CONFIGURE);
}

#ifdef  __cplusplus
}
#endif

#endif
