// python wrapper for vtkPVOrthographicSliceView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVOrthographicSliceView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVOrthographicSliceView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVOrthographicSliceView_ClassNew(); }

#ifndef DECLARED_PyvtkPVMultiSliceView_ClassNew
extern "C" { PyObject *PyvtkPVMultiSliceView_ClassNew(); }
#define DECLARED_PyvtkPVMultiSliceView_ClassNew
#endif

static PyObject *
PyvtkPVOrthographicSliceView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVOrthographicSliceView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVOrthographicSliceView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVOrthographicSliceView *tempr = vtkPVOrthographicSliceView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVOrthographicSliceView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVOrthographicSliceView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVOrthographicSliceView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVOrthographicSliceView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkPVOrthographicSliceView::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  int temp0 = vtkPVRenderView::DEFAULT_RENDERER;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer(temp0) :
      op->vtkPVOrthographicSliceView::GetRenderer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_ResetCamera_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetCamera();
    }
    else
    {
      op->vtkPVOrthographicSliceView::ResetCamera();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVOrthographicSliceView_ResetCamera_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->ResetCamera(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::ResetCamera(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVOrthographicSliceView_ResetCamera(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVOrthographicSliceView_ResetCamera_s1(self, args);
    case 1:
      return PyvtkPVOrthographicSliceView_ResetCamera_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ResetCamera");
  return nullptr;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetInteractionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInteractionMode(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetInteractionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetupInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetupInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->SetupInteractor(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetupInteractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetSlicePosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSlicePosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSlicePosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetSlicePosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_GetSlicePosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSlicePosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSlicePosition() :
      op->vtkPVOrthographicSliceView::GetSlicePosition());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetSliceIncrements_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSliceIncrements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSliceIncrements(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetSliceIncrements(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVOrthographicSliceView_SetSliceIncrements_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSliceIncrements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSliceIncrements(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetSliceIncrements(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVOrthographicSliceView_SetSliceIncrements(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVOrthographicSliceView_SetSliceIncrements_s1(self, args);
    case 1:
      return PyvtkPVOrthographicSliceView_SetSliceIncrements_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSliceIncrements");
  return nullptr;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetSliceAnnotationsVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSliceAnnotationsVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSliceAnnotationsVisibility(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetSliceAnnotationsVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_GetSliceAnnotationsVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSliceAnnotationsVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSliceAnnotationsVisibility() :
      op->vtkPVOrthographicSliceView::GetSliceAnnotationsVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetCenterAxesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCenterAxesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCenterAxesVisibility(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetCenterAxesVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_SetBackgroundTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundTexture(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::SetBackgroundTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVOrthographicSliceView_ScaleRendererViewports(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ScaleRendererViewports");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVOrthographicSliceView *op = static_cast<vtkPVOrthographicSliceView *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->ScaleRendererViewports(temp0);
    }
    else
    {
      op->vtkPVOrthographicSliceView::ScaleRendererViewports(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVOrthographicSliceView_Methods[] = {
  {"IsTypeOf", PyvtkPVOrthographicSliceView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVOrthographicSliceView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVOrthographicSliceView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVOrthographicSliceView\nC++: static vtkPVOrthographicSliceView *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVOrthographicSliceView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVOrthographicSliceView\nC++: vtkPVOrthographicSliceView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVOrthographicSliceView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVOrthographicSliceView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Update", PyvtkPVOrthographicSliceView_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nOverridden to ensure that the SlicePositionAxes3D doesn't get\nused when determine view bounds.\n"},
  {"GetRenderer", PyvtkPVOrthographicSliceView_GetRenderer, METH_VARARGS,
   "GetRenderer(self, rendererType:int=...) -> vtkRenderer\nC++: vtkRenderer *GetRenderer(\n    int rendererType=vtkPVRenderView::DEFAULT_RENDERER) override;\n\nOverridden to add support for new types of renderers.\n"},
  {"ResetCamera", PyvtkPVOrthographicSliceView_ResetCamera, METH_VARARGS,
   "ResetCamera(self) -> None\nC++: virtual void ResetCamera()\nResetCamera(self, bounds:[float, float, float, float, float,\n    float]) -> None\nC++: virtual void ResetCamera(double bounds[6])\n\nResets the active camera using collective prop-bounds.\n\nOffsetRatio can be used to add a zoom offset.\n\note CallOnAllProcesses\n"},
  {"SetInteractionMode", PyvtkPVOrthographicSliceView_SetInteractionMode, METH_VARARGS,
   "SetInteractionMode(self, mode:int) -> None\nC++: void SetInteractionMode(int mode) override;\n\nGet/Set the interaction mode. Default is INTERACTION_MODE_3D. If\nINTERACTION_MODE_SELECTION is selected, then whenever the user\ndrags and creates a selection region, this class will fire a\nvtkCommand::SelectionChangedEvent event with the selection region\nas the argument.\n\note CallOnAllProcesses\n\note this must be called on all processes, however it will have\nany effect only the driver processes i.e. the process with the\ninteractor.\n"},
  {"SetupInteractor", PyvtkPVOrthographicSliceView_SetupInteractor, METH_VARARGS,
   "SetupInteractor(self, __a:vtkRenderWindowInteractor) -> None\nC++: void SetupInteractor(vtkRenderWindowInteractor *) override;\n\nSet the interactor. Client applications must set the interactor\nto enable interactivity. Note this method will also change the\ninteractor styles set on the interactor.\n"},
  {"SetSlicePosition", PyvtkPVOrthographicSliceView_SetSlicePosition, METH_VARARGS,
   "SetSlicePosition(self, x:float, y:float, z:float) -> None\nC++: void SetSlicePosition(double x, double y, double z)\n\nSet the slice position.\n"},
  {"GetSlicePosition", PyvtkPVOrthographicSliceView_GetSlicePosition, METH_VARARGS,
   "GetSlicePosition(self) -> (float, float, float)\nC++: virtual double *GetSlicePosition()\n\n"},
  {"SetSliceIncrements", PyvtkPVOrthographicSliceView_SetSliceIncrements, METH_VARARGS,
   "SetSliceIncrements(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetSliceIncrements(double _arg1, double _arg2,\n    double _arg3)\nSetSliceIncrements(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSliceIncrements(const double _arg[3])\n\nSet slice increments.\n"},
  {"SetSliceAnnotationsVisibility", PyvtkPVOrthographicSliceView_SetSliceAnnotationsVisibility, METH_VARARGS,
   "SetSliceAnnotationsVisibility(self, _arg:bool) -> None\nC++: virtual void SetSliceAnnotationsVisibility(bool _arg)\n\nGet/Set whether to show slice annotations.\n"},
  {"GetSliceAnnotationsVisibility", PyvtkPVOrthographicSliceView_GetSliceAnnotationsVisibility, METH_VARARGS,
   "GetSliceAnnotationsVisibility(self) -> bool\nC++: virtual bool GetSliceAnnotationsVisibility()\n\n"},
  {"SetCenterAxesVisibility", PyvtkPVOrthographicSliceView_SetCenterAxesVisibility, METH_VARARGS,
   "SetCenterAxesVisibility(self, __a:bool) -> None\nC++: void SetCenterAxesVisibility(bool) override;\n\nTo avoid confusion, we don't show the center axes at all in this\nview.\n"},
  {"SetBackgroundTexture", PyvtkPVOrthographicSliceView_SetBackgroundTexture, METH_VARARGS,
   "SetBackgroundTexture(self, val:vtkTexture) -> None\nC++: void SetBackgroundTexture(vtkTexture *val) override;\n\n"},
  {"ScaleRendererViewports", PyvtkPVOrthographicSliceView_ScaleRendererViewports, METH_VARARGS,
   "ScaleRendererViewports(self, viewport:(float, float, float, float)\n    ) -> None\nC++: void ScaleRendererViewports(const double viewport[4])\n    override;\n\nOverridden to scale the projection viewports appropriately.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVOrthographicSliceView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("interaction_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVOrthographicSliceView_SetInteractionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVOrthographicSliceView_SetInteractionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInteractionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("slice_position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVOrthographicSliceView_GetSlicePosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVOrthographicSliceView_SetSlicePosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVOrthographicSliceView_SetSlicePosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSlicePosition/SetSlicePosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("slice_increments"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVOrthographicSliceView_SetSliceIncrements(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVOrthographicSliceView_SetSliceIncrements(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSliceIncrements\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("slice_annotations_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVOrthographicSliceView_GetSliceAnnotationsVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVOrthographicSliceView_SetSliceAnnotationsVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVOrthographicSliceView_SetSliceAnnotationsVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSliceAnnotationsVisibility/SetSliceAnnotationsVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("center_axes_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVOrthographicSliceView_SetCenterAxesVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVOrthographicSliceView_SetCenterAxesVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCenterAxesVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVOrthographicSliceView_SetBackgroundTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVOrthographicSliceView_SetBackgroundTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackgroundTexture\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVOrthographicSliceView_Doc =
  "vtkPVOrthographicSliceView - view with 3 orthographic slice views and\n1 3D view.\n\n"
  "Superclass: vtkPVMultiSliceView\n\n"
  "vtkPVOrthographicSliceView extends vtkPVMultiSliceView to support\n"
  "showing a quad-view with orthographic views along with the 3D view.\n"
  "Work with vtkPVCompositeOrthographicSliceRepresentation and\n"
  "vtkGeometrySliceRepresentation, this class create a 3 slices for any\n"
  "dataset shown in this view and shows those slices in the orthographic\n"
  "views. The orthographic views themselves are non-composited i.e. the\n"
  "data is simply cloned on all rendering processes (hence we limit\n"
  "ourselves to showing slices alone).\n\n"
  "@par Interactions: In the orthographic views, users can use the\n"
  "thumb-wheel to change the slice plane (in which case the\n"
  "SliceIncrements are used to update the slice position). Additionally,\n"
  "users can double click in any of the orthographic views to move the\n"
  "slice position to that location.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVOrthographicSliceView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVOrthographicSliceView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVOrthographicSliceView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVOrthographicSliceView_StaticNew()
{
  return vtkPVOrthographicSliceView::New();
}

PyObject *PyvtkPVOrthographicSliceView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVOrthographicSliceView_Type, PyvtkPVOrthographicSliceView_Methods,
    "vtkPVOrthographicSliceView",
 &PyvtkPVOrthographicSliceView_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVMultiSliceView_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 3; c++)
  {
    static const struct { const char *name; int value; }
      constants[3] = {
        { "SAGITTAL_VIEW_RENDERER", vtkPVOrthographicSliceView::SAGITTAL_VIEW_RENDERER },
        { "AXIAL_VIEW_RENDERER", vtkPVOrthographicSliceView::AXIAL_VIEW_RENDERER },
        { "CORONAL_VIEW_RENDERER", vtkPVOrthographicSliceView::CORONAL_VIEW_RENDERER },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVOrthographicSliceView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVOrthographicSliceView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVOrthographicSliceView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVOrthographicSliceView", o) != 0)
  {
    Py_DECREF(o);
  }

}

