#ifndef A6XX_DESCRIPTORS_XML
#define A6XX_DESCRIPTORS_XML

/* Autogenerated file, DO NOT EDIT manually! */

#ifdef __KERNEL__
#include <linux/bug.h>
#define assert(x) BUG_ON(!(x))
#else
#include <assert.h>
#endif

#ifdef __cplusplus
#define __struct_cast(X)
#define CONSTEXPR constexpr
#else
#define __struct_cast(X) (struct X)
#define CONSTEXPR
#endif

#if defined(__clang__) && !defined(FD_NO_DEPRECATED_PACK)
#define __FD_DEPRECATED _Pragma ("GCC warning \"Deprecated reg builder\"")
#else
#define __FD_DEPRECATED
#endif

#define REG_A6XX_TEX_SAMP_0					0x00000000
#define A6XX_TEX_SAMP_0_MIPFILTER_LINEAR_NEAR			0x00000001
#define A6XX_TEX_SAMP_0_XY_MAG__MASK				0x00000006ull
#define A6XX_TEX_SAMP_0_XY_MAG__SHIFT				1
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_0_XY_MAG(enum a6xx_tex_filter val)
{
	return ((val) << A6XX_TEX_SAMP_0_XY_MAG__SHIFT) & A6XX_TEX_SAMP_0_XY_MAG__MASK;
}
#define A6XX_TEX_SAMP_0_XY_MIN__MASK				0x00000018ull
#define A6XX_TEX_SAMP_0_XY_MIN__SHIFT				3
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_0_XY_MIN(enum a6xx_tex_filter val)
{
	return ((val) << A6XX_TEX_SAMP_0_XY_MIN__SHIFT) & A6XX_TEX_SAMP_0_XY_MIN__MASK;
}
#define A6XX_TEX_SAMP_0_WRAP_S__MASK				0x000000e0ull
#define A6XX_TEX_SAMP_0_WRAP_S__SHIFT				5
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_0_WRAP_S(enum a6xx_tex_clamp val)
{
	return ((val) << A6XX_TEX_SAMP_0_WRAP_S__SHIFT) & A6XX_TEX_SAMP_0_WRAP_S__MASK;
}
#define A6XX_TEX_SAMP_0_WRAP_T__MASK				0x00000700ull
#define A6XX_TEX_SAMP_0_WRAP_T__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_0_WRAP_T(enum a6xx_tex_clamp val)
{
	return ((val) << A6XX_TEX_SAMP_0_WRAP_T__SHIFT) & A6XX_TEX_SAMP_0_WRAP_T__MASK;
}
#define A6XX_TEX_SAMP_0_WRAP_R__MASK				0x00003800ull
#define A6XX_TEX_SAMP_0_WRAP_R__SHIFT				11
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_0_WRAP_R(enum a6xx_tex_clamp val)
{
	return ((val) << A6XX_TEX_SAMP_0_WRAP_R__SHIFT) & A6XX_TEX_SAMP_0_WRAP_R__MASK;
}
#define A6XX_TEX_SAMP_0_ANISO__MASK				0x0001c000ull
#define A6XX_TEX_SAMP_0_ANISO__SHIFT				14
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_0_ANISO(enum a6xx_tex_aniso val)
{
	return ((val) << A6XX_TEX_SAMP_0_ANISO__SHIFT) & A6XX_TEX_SAMP_0_ANISO__MASK;
}
#define A6XX_TEX_SAMP_0_LOD_BIAS__MASK				0xfff80000ull
#define A6XX_TEX_SAMP_0_LOD_BIAS__SHIFT				19
static inline uint32_t A6XX_TEX_SAMP_0_LOD_BIAS(float val)
{
	return ((((int32_t)(val * 256.0))) << A6XX_TEX_SAMP_0_LOD_BIAS__SHIFT) & A6XX_TEX_SAMP_0_LOD_BIAS__MASK;
}


#define REG_A6XX_TEX_SAMP_1					0x00000001
#define A6XX_TEX_SAMP_1_CLAMPENABLE				0x00000001
#define A6XX_TEX_SAMP_1_COMPARE_FUNC__MASK			0x0000000eull
#define A6XX_TEX_SAMP_1_COMPARE_FUNC__SHIFT			1
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_1_COMPARE_FUNC(enum adreno_compare_func val)
{
	return ((val) << A6XX_TEX_SAMP_1_COMPARE_FUNC__SHIFT) & A6XX_TEX_SAMP_1_COMPARE_FUNC__MASK;
}
#define A6XX_TEX_SAMP_1_CUBEMAPSEAMLESSFILTOFF			0x00000010
#define A6XX_TEX_SAMP_1_UNNORM_COORDS				0x00000020
#define A6XX_TEX_SAMP_1_MIPFILTER_LINEAR_FAR			0x00000040
#define A6XX_TEX_SAMP_1_MAX_LOD__MASK				0x000fff00ull
#define A6XX_TEX_SAMP_1_MAX_LOD__SHIFT				8
static inline uint32_t A6XX_TEX_SAMP_1_MAX_LOD(float val)
{
	return ((((uint32_t)(val * 256.0))) << A6XX_TEX_SAMP_1_MAX_LOD__SHIFT) & A6XX_TEX_SAMP_1_MAX_LOD__MASK;
}
#define A6XX_TEX_SAMP_1_MIN_LOD__MASK				0xfff00000ull
#define A6XX_TEX_SAMP_1_MIN_LOD__SHIFT				20
static inline uint32_t A6XX_TEX_SAMP_1_MIN_LOD(float val)
{
	return ((((uint32_t)(val * 256.0))) << A6XX_TEX_SAMP_1_MIN_LOD__SHIFT) & A6XX_TEX_SAMP_1_MIN_LOD__MASK;
}


#define REG_A6XX_TEX_SAMP_2					0x00000002
#define A6XX_TEX_SAMP_2_REDUCTION_MODE__MASK			0x00000003ull
#define A6XX_TEX_SAMP_2_REDUCTION_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_2_REDUCTION_MODE(enum a6xx_reduction_mode val)
{
	return ((val) << A6XX_TEX_SAMP_2_REDUCTION_MODE__SHIFT) & A6XX_TEX_SAMP_2_REDUCTION_MODE__MASK;
}
#define A6XX_TEX_SAMP_2_FASTBORDERCOLOR__MASK			0x0000000cull
#define A6XX_TEX_SAMP_2_FASTBORDERCOLOR__SHIFT			2
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_2_FASTBORDERCOLOR(enum a6xx_fast_border_color val)
{
	return ((val) << A6XX_TEX_SAMP_2_FASTBORDERCOLOR__SHIFT) & A6XX_TEX_SAMP_2_FASTBORDERCOLOR__MASK;
}
#define A6XX_TEX_SAMP_2_FASTBORDERCOLOREN			0x00000010
#define A6XX_TEX_SAMP_2_CHROMA_LINEAR				0x00000020
#define A6XX_TEX_SAMP_2_BCOLOR__MASK				0xffffff80ull
#define A6XX_TEX_SAMP_2_BCOLOR__SHIFT				7
static CONSTEXPR inline uint32_t A6XX_TEX_SAMP_2_BCOLOR(uint32_t val)
{
	return ((val) << A6XX_TEX_SAMP_2_BCOLOR__SHIFT) & A6XX_TEX_SAMP_2_BCOLOR__MASK;
}


#define REG_A6XX_TEX_SAMP_3					0x00000003


#define REG_A6XX_TEX_CONST_0					0x00000000
#define A6XX_TEX_CONST_0_TILE_MODE__MASK			0x00000003ull
#define A6XX_TEX_CONST_0_TILE_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A6XX_TEX_CONST_0_TILE_MODE__SHIFT) & A6XX_TEX_CONST_0_TILE_MODE__MASK;
}
#define A6XX_TEX_CONST_0_SRGB					0x00000004
#define A6XX_TEX_CONST_0_SWIZ_X__MASK				0x00000070ull
#define A6XX_TEX_CONST_0_SWIZ_X__SHIFT				4
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_SWIZ_X(enum a6xx_tex_swiz val)
{
	return ((val) << A6XX_TEX_CONST_0_SWIZ_X__SHIFT) & A6XX_TEX_CONST_0_SWIZ_X__MASK;
}
#define A6XX_TEX_CONST_0_SWIZ_Y__MASK				0x00000380ull
#define A6XX_TEX_CONST_0_SWIZ_Y__SHIFT				7
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_SWIZ_Y(enum a6xx_tex_swiz val)
{
	return ((val) << A6XX_TEX_CONST_0_SWIZ_Y__SHIFT) & A6XX_TEX_CONST_0_SWIZ_Y__MASK;
}
#define A6XX_TEX_CONST_0_SWIZ_Z__MASK				0x00001c00ull
#define A6XX_TEX_CONST_0_SWIZ_Z__SHIFT				10
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_SWIZ_Z(enum a6xx_tex_swiz val)
{
	return ((val) << A6XX_TEX_CONST_0_SWIZ_Z__SHIFT) & A6XX_TEX_CONST_0_SWIZ_Z__MASK;
}
#define A6XX_TEX_CONST_0_SWIZ_W__MASK				0x0000e000ull
#define A6XX_TEX_CONST_0_SWIZ_W__SHIFT				13
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_SWIZ_W(enum a6xx_tex_swiz val)
{
	return ((val) << A6XX_TEX_CONST_0_SWIZ_W__SHIFT) & A6XX_TEX_CONST_0_SWIZ_W__MASK;
}
#define A6XX_TEX_CONST_0_MIPLVLS__MASK				0x000f0000ull
#define A6XX_TEX_CONST_0_MIPLVLS__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_MIPLVLS(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_0_MIPLVLS__SHIFT) & A6XX_TEX_CONST_0_MIPLVLS__MASK;
}
#define A6XX_TEX_CONST_0_CHROMA_MIDPOINT_X			0x00010000
#define A6XX_TEX_CONST_0_CHROMA_MIDPOINT_Y			0x00040000
#define A6XX_TEX_CONST_0_SAMPLES__MASK				0x00300000ull
#define A6XX_TEX_CONST_0_SAMPLES__SHIFT				20
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_TEX_CONST_0_SAMPLES__SHIFT) & A6XX_TEX_CONST_0_SAMPLES__MASK;
}
#define A6XX_TEX_CONST_0_FMT__MASK				0x3fc00000ull
#define A6XX_TEX_CONST_0_FMT__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_FMT(enum a6xx_format val)
{
	return ((val) << A6XX_TEX_CONST_0_FMT__SHIFT) & A6XX_TEX_CONST_0_FMT__MASK;
}
#define A6XX_TEX_CONST_0_SWAP__MASK				0xc0000000ull
#define A6XX_TEX_CONST_0_SWAP__SHIFT				30
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_0_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A6XX_TEX_CONST_0_SWAP__SHIFT) & A6XX_TEX_CONST_0_SWAP__MASK;
}


#define REG_A6XX_TEX_CONST_1					0x00000001
#define A6XX_TEX_CONST_1_WIDTH__MASK				0x00007fffull
#define A6XX_TEX_CONST_1_WIDTH__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_1_WIDTH(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_1_WIDTH__SHIFT) & A6XX_TEX_CONST_1_WIDTH__MASK;
}
#define A6XX_TEX_CONST_1_HEIGHT__MASK				0x3fff8000ull
#define A6XX_TEX_CONST_1_HEIGHT__SHIFT				15
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_1_HEIGHT(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_1_HEIGHT__SHIFT) & A6XX_TEX_CONST_1_HEIGHT__MASK;
}
#define A6XX_TEX_CONST_1_MUTABLEEN				0x80000000


#define REG_A6XX_TEX_CONST_2					0x00000002
#define A6XX_TEX_CONST_2_STRUCTSIZETEXELS__MASK			0x0000fff0ull
#define A6XX_TEX_CONST_2_STRUCTSIZETEXELS__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_2_STRUCTSIZETEXELS(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_2_STRUCTSIZETEXELS__SHIFT) & A6XX_TEX_CONST_2_STRUCTSIZETEXELS__MASK;
}
#define A6XX_TEX_CONST_2_STARTOFFSETTEXELS__MASK		0x003f0000ull
#define A6XX_TEX_CONST_2_STARTOFFSETTEXELS__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_2_STARTOFFSETTEXELS(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_2_STARTOFFSETTEXELS__SHIFT) & A6XX_TEX_CONST_2_STARTOFFSETTEXELS__MASK;
}
#define A6XX_TEX_CONST_2_PITCHALIGN__MASK			0x0000000full
#define A6XX_TEX_CONST_2_PITCHALIGN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_2_PITCHALIGN(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_2_PITCHALIGN__SHIFT) & A6XX_TEX_CONST_2_PITCHALIGN__MASK;
}
#define A6XX_TEX_CONST_2_PITCH__MASK				0x1fffff80ull
#define A6XX_TEX_CONST_2_PITCH__SHIFT				7
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_2_PITCH(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_2_PITCH__SHIFT) & A6XX_TEX_CONST_2_PITCH__MASK;
}
#define A6XX_TEX_CONST_2_TYPE__MASK				0xe0000000ull
#define A6XX_TEX_CONST_2_TYPE__SHIFT				29
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_2_TYPE(enum a6xx_tex_type val)
{
	return ((val) << A6XX_TEX_CONST_2_TYPE__SHIFT) & A6XX_TEX_CONST_2_TYPE__MASK;
}


#define REG_A6XX_TEX_CONST_3					0x00000003
#define A6XX_TEX_CONST_3_ARRAY_PITCH__MASK			0x007fffffull
#define A6XX_TEX_CONST_3_ARRAY_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_3_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_TEX_CONST_3_ARRAY_PITCH__SHIFT) & A6XX_TEX_CONST_3_ARRAY_PITCH__MASK;
}
#define A6XX_TEX_CONST_3_MIN_LAYERSZ__MASK			0x07800000ull
#define A6XX_TEX_CONST_3_MIN_LAYERSZ__SHIFT			23
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_3_MIN_LAYERSZ(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_TEX_CONST_3_MIN_LAYERSZ__SHIFT) & A6XX_TEX_CONST_3_MIN_LAYERSZ__MASK;
}
#define A6XX_TEX_CONST_3_TILE_ALL				0x08000000
#define A6XX_TEX_CONST_3_FLAG					0x10000000


#define REG_A6XX_TEX_CONST_4					0x00000004
#define A6XX_TEX_CONST_4_BASE_LO__MASK				0xffffffe0ull
#define A6XX_TEX_CONST_4_BASE_LO__SHIFT				5
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_4_BASE_LO(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A6XX_TEX_CONST_4_BASE_LO__SHIFT) & A6XX_TEX_CONST_4_BASE_LO__MASK;
}


#define REG_A6XX_TEX_CONST_5					0x00000005
#define A6XX_TEX_CONST_5_BASE_HI__MASK				0x0001ffffull
#define A6XX_TEX_CONST_5_BASE_HI__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_5_BASE_HI(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_5_BASE_HI__SHIFT) & A6XX_TEX_CONST_5_BASE_HI__MASK;
}
#define A6XX_TEX_CONST_5_DEPTH__MASK				0x3ffe0000ull
#define A6XX_TEX_CONST_5_DEPTH__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_5_DEPTH(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_5_DEPTH__SHIFT) & A6XX_TEX_CONST_5_DEPTH__MASK;
}


#define REG_A6XX_TEX_CONST_6					0x00000006
#define A6XX_TEX_CONST_6_MIN_LOD_CLAMP__MASK			0x00000fffull
#define A6XX_TEX_CONST_6_MIN_LOD_CLAMP__SHIFT			0
static inline uint32_t A6XX_TEX_CONST_6_MIN_LOD_CLAMP(float val)
{
	return ((((uint32_t)(val * 256.0))) << A6XX_TEX_CONST_6_MIN_LOD_CLAMP__SHIFT) & A6XX_TEX_CONST_6_MIN_LOD_CLAMP__MASK;
}
#define A6XX_TEX_CONST_6_PLANE_PITCH__MASK			0xffffff00ull
#define A6XX_TEX_CONST_6_PLANE_PITCH__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_6_PLANE_PITCH(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_6_PLANE_PITCH__SHIFT) & A6XX_TEX_CONST_6_PLANE_PITCH__MASK;
}


#define REG_A6XX_TEX_CONST_7					0x00000007
#define A6XX_TEX_CONST_7_FLAG_LO__MASK				0xffffffe0ull
#define A6XX_TEX_CONST_7_FLAG_LO__SHIFT				5
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_7_FLAG_LO(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A6XX_TEX_CONST_7_FLAG_LO__SHIFT) & A6XX_TEX_CONST_7_FLAG_LO__MASK;
}


#define REG_A6XX_TEX_CONST_8					0x00000008
#define A6XX_TEX_CONST_8_FLAG_HI__MASK				0x0001ffffull
#define A6XX_TEX_CONST_8_FLAG_HI__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_8_FLAG_HI(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_8_FLAG_HI__SHIFT) & A6XX_TEX_CONST_8_FLAG_HI__MASK;
}


#define REG_A6XX_TEX_CONST_9					0x00000009
#define A6XX_TEX_CONST_9_FLAG_BUFFER_ARRAY_PITCH__MASK		0x0001ffffull
#define A6XX_TEX_CONST_9_FLAG_BUFFER_ARRAY_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_9_FLAG_BUFFER_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A6XX_TEX_CONST_9_FLAG_BUFFER_ARRAY_PITCH__SHIFT) & A6XX_TEX_CONST_9_FLAG_BUFFER_ARRAY_PITCH__MASK;
}


#define REG_A6XX_TEX_CONST_10					0x0000000a
#define A6XX_TEX_CONST_10_FLAG_BUFFER_PITCH__MASK		0x0000007full
#define A6XX_TEX_CONST_10_FLAG_BUFFER_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_10_FLAG_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_TEX_CONST_10_FLAG_BUFFER_PITCH__SHIFT) & A6XX_TEX_CONST_10_FLAG_BUFFER_PITCH__MASK;
}
#define A6XX_TEX_CONST_10_FLAG_BUFFER_LOGW__MASK		0x00000f00ull
#define A6XX_TEX_CONST_10_FLAG_BUFFER_LOGW__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_10_FLAG_BUFFER_LOGW(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_10_FLAG_BUFFER_LOGW__SHIFT) & A6XX_TEX_CONST_10_FLAG_BUFFER_LOGW__MASK;
}
#define A6XX_TEX_CONST_10_FLAG_BUFFER_LOGH__MASK		0x0000f000ull
#define A6XX_TEX_CONST_10_FLAG_BUFFER_LOGH__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_TEX_CONST_10_FLAG_BUFFER_LOGH(uint32_t val)
{
	return ((val) << A6XX_TEX_CONST_10_FLAG_BUFFER_LOGH__SHIFT) & A6XX_TEX_CONST_10_FLAG_BUFFER_LOGH__MASK;
}


#define REG_A6XX_TEX_CONST_11					0x0000000b


#define REG_A6XX_TEX_CONST_12					0x0000000c


#define REG_A6XX_TEX_CONST_13					0x0000000d


#define REG_A6XX_TEX_CONST_14					0x0000000e


#define REG_A6XX_TEX_CONST_15					0x0000000f


#define REG_A6XX_UBO_0						0x00000000
#define A6XX_UBO_0_BASE_LO__MASK				0xffffffffull
#define A6XX_UBO_0_BASE_LO__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_UBO_0_BASE_LO(uint32_t val)
{
	return ((val) << A6XX_UBO_0_BASE_LO__SHIFT) & A6XX_UBO_0_BASE_LO__MASK;
}


#define REG_A6XX_UBO_1						0x00000001
#define A6XX_UBO_1_BASE_HI__MASK				0x0001ffffull
#define A6XX_UBO_1_BASE_HI__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_UBO_1_BASE_HI(uint32_t val)
{
	return ((val) << A6XX_UBO_1_BASE_HI__SHIFT) & A6XX_UBO_1_BASE_HI__MASK;
}
#define A6XX_UBO_1_SIZE__MASK					0xfffe0000ull
#define A6XX_UBO_1_SIZE__SHIFT					17
static CONSTEXPR inline uint32_t A6XX_UBO_1_SIZE(uint32_t val)
{
	return ((val) << A6XX_UBO_1_SIZE__SHIFT) & A6XX_UBO_1_SIZE__MASK;
}


#ifdef __cplusplus
#endif
#endif /* A6XX_DESCRIPTORS_XML */
