// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitProfileMetrics_h
#define mozilla_GleanToolkitProfileMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace startup {
  /**
   * generated from startup.profile_count
   * This records the number of known profiles after startup completes. This includes any profiles that were created during startup. This metric was generated to correspond to the Legacy Telemetry scalar startup.profile_count.
   */
  constexpr impl::QuantityMetric profile_count(471);

  /**
   * generated from startup.profile_database_version
   * The version of the profiles.ini database loaded during startup. A value of "0" is used to indicate that no file was present during startup. This metric was generated to correspond to the Legacy Telemetry scalar startup.profile_database_version.
   */
  constexpr impl::StringMetric profile_database_version(472);

  /**
   * generated from startup.profile_selection_reason
   * How the profile was selected during startup. One of the following reasons:
   *   unknown:
   *     Generally should not happen, set as a default in case no other reason
   *     occured.
   *   profile-manager:
   *     The profile was selected by the profile manager.
   *   profile-selector:
   *     The profile was selected by the profile selector window.
   *   profile-reset:
   *     The profile was selected for reset, normally this would mean a restart.
   *   restart:
   *     The user restarted the application, the same profile as previous will
   *     be used.
   *   argument-profile:
   *     The profile was selected by the --profile command line argument.
   *   argument-p:
   *     The profile was selected by the -p command line argument.
   *   firstrun-claimed-default:
   *     A first run of a dedicated profiles build chose the old default
   *     profile to be the default for this install.
   *   firstrun-skipped-default:
   *     A first run of a dedicated profiles build skipped over the old default
   *     profile and created a new profile.
   *   restart-claimed-default:
   *     A first run of a dedicated profiles build after a restart chose the
   *     old default profile to be the default for this install.
   *   restart-skipped-default:
   *     A first run of a dedicated profiles build after a restart skipped over
   *     the old default profile and created a new profile.
   *   firstrun-created-default:
   *     A first run of the application created a new profile to use.
   *   default:
   *     The default profile was selected as normal.
   * This metric was generated to correspond to the Legacy Telemetry scalar startup.profile_selection_reason.
   */
  constexpr impl::StringMetric profile_selection_reason(473);
}

namespace profiles {
  /**
   * generated from profiles.creation_date
   * The day the profile was created,
   * as determined by checking various file metadata in the profile directory.
   * Not considered to be particularly reliable in practice.
   * Prefer `client_info.first_run_date` in most cases.
   * e.g. 16446
   */
  constexpr impl::QuantityMetric creation_date(6092);

  /**
   * generated from profiles.creation_place
   */
  enum class CreationPlaceLabel: uint16_t {
    eLegacyForced = 0,
    eLegacyExisting = 1,
    eXdgDefault = 2,
    eXdgConfig = 3,
    e__Other__,
  };
  /**
   * Tracking where profiles have been created.  The `legacy_forced` refers to
   * usage of `MOZ_LEGACY_HOME=1` while `legacy_existing` is for the case an
   * existing legacy profile was detected. The `xdg_default` accounts for lack
   * of `XDG_CONFIG_HOME` value defaulting to `$HOME/.config` when
   * `xdg_config` refers to existing `XDG_CONFIG_HOME`.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CreationPlaceLabel> creation_place(6093);

  /**
   * generated from profiles.first_use_date
   * Optional.
   * The day the profile was first used,
   * as determined by noticing that `times.json` wasn't present.
   * Prefer `client_info.first_run_date` in most cases.
   * e.g. 16446
   */
  constexpr impl::QuantityMetric first_use_date(6094);

  /**
   * generated from profiles.recovered_from_backup
   * Optional.
   * The day the profile was recovered from backup,
   * persisted in `times.json`.
   * e.g. 16446
   */
  constexpr impl::QuantityMetric recovered_from_backup(6095);

  /**
   * generated from profiles.reset_date
   * Optional.
   * The day the profile was most recently reset,
   * persisted in `times.json`.
   * e.g. 16446
   */
  constexpr impl::QuantityMetric reset_date(6096);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitProfileMetrics_h
