/* logging.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from logging.vala, do not modify */

/* logging.vala
 *
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "zeitgeist-engine.h"
#include <glib/gstdio.h>

#define ZEITGEIST_LOGGING_BLUE "\x1b[34m"
#define ZEITGEIST_LOGGING_GREEN "\x1b[32m"
#define ZEITGEIST_LOGGING_RED "\x1b[31m"
#define ZEITGEIST_LOGGING_YELLOW "\x1b[33m"
#define ZEITGEIST_LOGGING_RESET "\x1b[0m"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

VALA_EXTERN FILE* zeitgeist_logging_log_file;
FILE* zeitgeist_logging_log_file = NULL;

VALA_EXTERN gchar* zeitgeist_logging_get_log_level_string (GLogLevelFlags log_levels,
                                               gchar** color);
VALA_EXTERN void zeitgeist_logging_log_handler (const gchar* log_domain,
                                    GLogLevelFlags log_levels,
                                    const gchar* message);
static void ___lambda5_ (void);
static void ____lambda5__glog_func (const gchar* log_domain,
                             GLogLevelFlags log_levels,
                             const gchar* message,
                             gpointer self);
static void _zeitgeist_logging_log_handler_glog_func (const gchar* log_domain,
                                               GLogLevelFlags log_levels,
                                               const gchar* message,
                                               gpointer self);

gchar*
zeitgeist_logging_get_log_level_string (GLogLevelFlags log_levels,
                                        gchar** color)
{
	gchar* _vala_color = NULL;
	gchar* log_level = NULL;
	gchar* result;
	if ((log_levels & G_LOG_LEVEL_ERROR) != 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup ("ERROR");
		_g_free0 (log_level);
		log_level = _tmp0_;
		_tmp1_ = g_strdup (ZEITGEIST_LOGGING_RED);
		_g_free0 (_vala_color);
		_vala_color = _tmp1_;
	} else {
		if ((log_levels & G_LOG_LEVEL_CRITICAL) != 0) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_strdup ("CRITICAL");
			_g_free0 (log_level);
			log_level = _tmp2_;
			_tmp3_ = g_strdup (ZEITGEIST_LOGGING_RED);
			_g_free0 (_vala_color);
			_vala_color = _tmp3_;
		} else {
			if ((log_levels & G_LOG_LEVEL_WARNING) != 0) {
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = g_strdup ("WARNING");
				_g_free0 (log_level);
				log_level = _tmp4_;
				_tmp5_ = g_strdup (ZEITGEIST_LOGGING_RED);
				_g_free0 (_vala_color);
				_vala_color = _tmp5_;
			} else {
				if ((log_levels & G_LOG_LEVEL_MESSAGE) != 0) {
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = g_strdup ("MESSAGE");
					_g_free0 (log_level);
					log_level = _tmp6_;
					_tmp7_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
					_g_free0 (_vala_color);
					_vala_color = _tmp7_;
				} else {
					if ((log_levels & G_LOG_LEVEL_INFO) != 0) {
						gchar* _tmp8_;
						gchar* _tmp9_;
						_tmp8_ = g_strdup ("INFO");
						_g_free0 (log_level);
						log_level = _tmp8_;
						_tmp9_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
						_g_free0 (_vala_color);
						_vala_color = _tmp9_;
					} else {
						if ((log_levels & G_LOG_LEVEL_DEBUG) != 0) {
							gchar* _tmp10_;
							gchar* _tmp11_;
							_tmp10_ = g_strdup ("DEBUG");
							_g_free0 (log_level);
							log_level = _tmp10_;
							_tmp11_ = g_strdup (ZEITGEIST_LOGGING_GREEN);
							_g_free0 (_vala_color);
							_vala_color = _tmp11_;
						} else {
							gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp12_ = g_strdup ("UNKNOWN");
							_g_free0 (log_level);
							log_level = _tmp12_;
							_tmp13_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
							_g_free0 (_vala_color);
							_vala_color = _tmp13_;
						}
					}
				}
			}
		}
	}
	result = log_level;
	if (color) {
		*color = _vala_color;
	} else {
		_g_free0 (_vala_color);
	}
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
zeitgeist_logging_log_handler (const gchar* log_domain,
                               GLogLevelFlags log_levels,
                               const gchar* message)
{
	gchar* color = NULL;
	gchar* log_level = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* timestamp = NULL;
	GTimeVal _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FILE* output = NULL;
	FILE* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	FILE* _tmp13_;
	g_return_if_fail (message != NULL);
	_tmp1_ = zeitgeist_logging_get_log_level_string (log_levels, &_tmp0_);
	_g_free0 (color);
	color = _tmp0_;
	log_level = _tmp1_;
	g_get_current_time (&_tmp2_);
	_tmp3_ = g_time_val_to_iso8601 (&_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_substring (_tmp4_, (glong) 11, (glong) 15);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	timestamp = _tmp6_;
	if (log_levels >= G_LOG_LEVEL_MESSAGE) {
		FILE* _tmp7_;
		_tmp7_ = stdout;
		output = _tmp7_;
	} else {
		FILE* _tmp8_;
		_tmp8_ = stderr;
		output = _tmp8_;
	}
	_tmp9_ = output;
	_tmp10_ = color;
	_tmp11_ = timestamp;
	_tmp12_ = log_level;
	fprintf (_tmp9_, "%s[%s %s]%s %s\n", _tmp10_, _tmp11_, _tmp12_, ZEITGEIST_LOGGING_RESET, message);
	_tmp13_ = zeitgeist_logging_log_file;
	if (_tmp13_ != NULL) {
		GDateTime* datetime = NULL;
		GDateTime* _tmp14_;
		gchar* date_string = NULL;
		GDateTime* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GDateTime* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gint pid = 0;
		FILE* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp14_ = g_date_time_new_now_local ();
		datetime = _tmp14_;
		_tmp15_ = datetime;
		_tmp16_ = g_date_time_format (_tmp15_, "%Y-%m-%d %H:%M:%S");
		_tmp17_ = _tmp16_;
		_tmp18_ = datetime;
		_tmp19_ = g_strdup_printf ("%s,%.3d", _tmp17_, (gint) (g_date_time_get_microsecond (_tmp18_) / 1000.0));
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp17_);
		date_string = _tmp20_;
		pid = (gint) getpid ();
		_tmp21_ = zeitgeist_logging_log_file;
		_tmp22_ = date_string;
		_tmp23_ = log_level;
		fprintf (_tmp21_, "%d [%s] - %s - %s\n", pid, _tmp22_, _tmp23_, message);
		_g_free0 (date_string);
		_g_date_time_unref0 (datetime);
	}
	_g_free0 (timestamp);
	_g_free0 (log_level);
	_g_free0 (color);
}

static void
___lambda5_ (void)
{
}

static void
____lambda5__glog_func (const gchar* log_domain,
                        GLogLevelFlags log_levels,
                        const gchar* message,
                        gpointer self)
{
	___lambda5_ ();
}

static void
_zeitgeist_logging_log_handler_glog_func (const gchar* log_domain,
                                          GLogLevelFlags log_levels,
                                          const gchar* message,
                                          gpointer self)
{
	zeitgeist_logging_log_handler (log_domain, log_levels, message);
}

void
zeitgeist_logging_setup_logging (const gchar* log_level,
                                 const gchar* log_file)
{
	GLogLevelFlags discarded = 0U;
	GLogLevelFlags logged = 0U;
	discarded = G_LOG_LEVEL_DEBUG;
	if (log_level != NULL) {
		GLogLevelFlags ld = 0U;
		GLogLevelFlags li = 0U;
		GLogLevelFlags lm = 0U;
		GLogLevelFlags lw = 0U;
		GLogLevelFlags lc = 0U;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GQuark _tmp3_ = 0U;
		static GQuark _tmp2_label0 = 0;
		static GQuark _tmp2_label1 = 0;
		static GQuark _tmp2_label2 = 0;
		static GQuark _tmp2_label3 = 0;
		static GQuark _tmp2_label4 = 0;
		ld = G_LOG_LEVEL_DEBUG;
		li = G_LOG_LEVEL_INFO;
		lm = G_LOG_LEVEL_MESSAGE;
		lw = G_LOG_LEVEL_WARNING;
		lc = G_LOG_LEVEL_CRITICAL;
		_tmp0_ = g_utf8_strup (log_level, (gssize) -1);
		_tmp1_ = _tmp0_;
		_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
		g_free (_tmp1_);
		if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("DEBUG")))) {
			switch (0) {
				default:
				{
					discarded = 0;
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("INFO")))) {
			switch (0) {
				default:
				{
					discarded = ld;
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("WARNING")))) {
			switch (0) {
				default:
				{
					discarded = (ld | li) | lm;
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("CRITICAL")))) {
			switch (0) {
				default:
				{
					discarded = ((ld | li) | lm) | lw;
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("ERROR")))) {
			switch (0) {
				default:
				{
					discarded = (((ld | li) | lm) | lw) | lc;
					break;
				}
			}
		}
	}
	if (discarded != 0) {
		g_log_set_handler (NULL, discarded, ____lambda5__glog_func, NULL);
	}
	if (log_file != NULL) {
		FILE* _tmp4_;
		_tmp4_ = g_fopen (log_file, "a");
		_fclose0 (zeitgeist_logging_log_file);
		zeitgeist_logging_log_file = _tmp4_;
	}
	logged = (~discarded) & (~G_LOG_FLAG_RECURSION);
	g_log_set_handler (NULL, logged, _zeitgeist_logging_log_handler_glog_func, NULL);
}

