/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkIsolatedWatershedImageFilter.h"
#include "itkIsolatedWatershedImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
IsolatedWatershedImageFilter::IsolatedWatershedImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
IsolatedWatershedImageFilter::~IsolatedWatershedImageFilter() = default;



//
// ToString
//
std::string IsolatedWatershedImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::IsolatedWatershedImageFilter\n";
  out << "  Seed1: ";
  this->ToStringHelper(out, this->m_Seed1);
  out << std::endl;
  out << "  Seed2: ";
  this->ToStringHelper(out, this->m_Seed2);
  out << std::endl;
  out << "  Threshold: ";
  this->ToStringHelper(out, this->m_Threshold);
  out << std::endl;
  out << "  UpperValueLimit: ";
  this->ToStringHelper(out, this->m_UpperValueLimit);
  out << std::endl;
  out << "  IsolatedValueTolerance: ";
  this->ToStringHelper(out, this->m_IsolatedValueTolerance);
  out << std::endl;
  out << "  ReplaceValue1: ";
  this->ToStringHelper(out, this->m_ReplaceValue1);
  out << std::endl;
  out << "  ReplaceValue2: ";
  this->ToStringHelper(out, this->m_ReplaceValue2);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image IsolatedWatershedImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image IsolatedWatershedImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::IsolatedWatershedImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  typename FilterType::IndexType itkVecSeed1 = sitkSTLVectorToITK<typename FilterType::IndexType>( this->GetSeed1() );
  filter->SetSeed1( itkVecSeed1 );
  typename FilterType::IndexType itkVecSeed2 = sitkSTLVectorToITK<typename FilterType::IndexType>( this->GetSeed2() );
  filter->SetSeed2( itkVecSeed2 );
  filter->SetThreshold ( this->m_Threshold );
  filter->SetUpperValueLimit ( this->m_UpperValueLimit );
  filter->SetIsolatedValueTolerance ( this->m_IsolatedValueTolerance );
  filter->SetReplaceValue1 ( static_cast< typename OutputImageType::PixelType> ( this->m_ReplaceValue1 ) );
  filter->SetReplaceValue2 ( static_cast< typename OutputImageType::PixelType> ( this->m_ReplaceValue2 ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image IsolatedWatershed ( const Image& image1, std::vector<uint32_t> seed1, std::vector<uint32_t> seed2, double threshold, double upperValueLimit, double isolatedValueTolerance, uint8_t replaceValue1, uint8_t replaceValue2 )
{
  IsolatedWatershedImageFilter filter;
  filter.SetSeed1( seed1 );  filter.SetSeed2( seed2 );  filter.SetThreshold( threshold );  filter.SetUpperValueLimit( upperValueLimit );  filter.SetIsolatedValueTolerance( isolatedValueTolerance );  filter.SetReplaceValue1( replaceValue1 );  filter.SetReplaceValue2( replaceValue2 );
  return filter.Execute ( image1 );
}


}
