/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_winbind.h"
#include "bin/default/librpc/gen_ndr/ndr_winbind_c.h"

/* winbind - client functions generated by pidl */

struct dcerpc_wbint_Ping_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Ping_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Ping_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Ping *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Ping_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Ping_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Ping_r_done, req);

	return req;
}

static void dcerpc_wbint_Ping_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Ping_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Ping_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Ping_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Ping_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Ping *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PING, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Ping_state {
	struct wbint_Ping orig;
	struct wbint_Ping tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Ping_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Ping_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  uint32_t _in_data /* [in]  */,
					  uint32_t *_out_data /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Ping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Ping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.in_data = _in_data;

	/* Out parameters */
	state->orig.out.out_data = _out_data;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Ping_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Ping_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Ping_done, req);
	return req;
}

static void dcerpc_wbint_Ping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Ping_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Ping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Ping_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.out_data = *state->tmp.out.out_data;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Ping_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				NTSTATUS *result)
{
	struct dcerpc_wbint_Ping_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Ping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Ping(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   uint32_t _in_data /* [in]  */,
			   uint32_t *_out_data /* [out] [ref] */,
			   NTSTATUS *result)
{
	struct wbint_Ping r;
	NTSTATUS status;

	/* In parameters */
	r.in.in_data = _in_data;

	/* Out parameters */
	r.out.out_data = _out_data;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_Ping_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_out_data = *r.out.out_data;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupSid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupSid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPSID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSid_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupSid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupSid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupSid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupSid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPSID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupSid_state {
	struct wbint_LookupSid orig;
	struct wbint_LookupSid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSid_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct dom_sid *_sid /* [in] [ref] */,
					       enum lsa_SidType *_type /* [out] [ref] */,
					       const char **_domain /* [out] [charset(UTF8),ref] */,
					       const char **_name /* [out] [charset(UTF8),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.domain = _domain;
	state->orig.out.name = _name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupSid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupSid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSid_done, req);
	return req;
}

static void dcerpc_wbint_LookupSid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupSid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupSid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	*state->orig.out.domain = *state->tmp.out.domain;
	*state->orig.out.name = *state->tmp.out.name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSid_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_wbint_LookupSid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSid(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct dom_sid *_sid /* [in] [ref] */,
				enum lsa_SidType *_type /* [out] [ref] */,
				const char **_domain /* [out] [charset(UTF8),ref] */,
				const char **_name /* [out] [charset(UTF8),ref] */,
				NTSTATUS *result)
{
	struct wbint_LookupSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;

	/* Out parameters */
	r.out.type = _type;
	r.out.domain = _domain;
	r.out.name = _name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupSid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;
	*_domain = *r.out.domain;
	*_name = *r.out.name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupSids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupSids *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPSIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSids_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupSids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupSids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupSids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupSids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPSIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupSids_state {
	struct wbint_LookupSids orig;
	struct wbint_LookupSids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSids_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct lsa_SidArray *_sids /* [in] [ref] */,
						struct lsa_RefDomainList *_domains /* [out] [ref] */,
						struct lsa_TransNameArray *_names /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sids = _sids;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupSids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupSids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSids_done, req);
	return req;
}

static void dcerpc_wbint_LookupSids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupSids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupSids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSids_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupSids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSids(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct lsa_SidArray *_sids /* [in] [ref] */,
				 struct lsa_RefDomainList *_domains /* [out] [ref] */,
				 struct lsa_TransNameArray *_names /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_LookupSids r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = _sids;

	/* Out parameters */
	r.out.domains = _domains;
	r.out.names = _names;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupSids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_names = *r.out.names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupName *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupName_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupName_state {
	struct wbint_LookupName orig;
	struct wbint_LookupName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupName_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_domain /* [in] [charset(UTF8),ref] */,
						const char *_name /* [in] [charset(UTF8),ref] */,
						uint32_t _flags /* [in]  */,
						enum lsa_SidType *_type /* [out] [ref] */,
						struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain = _domain;
	state->orig.in.name = _name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.sid = _sid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupName_done, req);
	return req;
}

static void dcerpc_wbint_LookupName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupName_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupName(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_domain /* [in] [charset(UTF8),ref] */,
				 const char *_name /* [in] [charset(UTF8),ref] */,
				 uint32_t _flags /* [in]  */,
				 enum lsa_SidType *_type /* [out] [ref] */,
				 struct dom_sid *_sid /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_LookupName r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain = _domain;
	r.in.name = _name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.type = _type;
	r.out.sid = _sid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;
	*_sid = *r.out.sid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_Sids2UnixIDs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sids2UnixIDs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sids2UnixIDs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Sids2UnixIDs *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sids2UnixIDs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sids2UnixIDs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_SIDS2UNIXIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sids2UnixIDs_r_done, req);

	return req;
}

static void dcerpc_wbint_Sids2UnixIDs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Sids2UnixIDs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Sids2UnixIDs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Sids2UnixIDs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_SIDS2UNIXIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Sids2UnixIDs_state {
	struct wbint_Sids2UnixIDs orig;
	struct wbint_Sids2UnixIDs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sids2UnixIDs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sids2UnixIDs_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct lsa_RefDomainList *_domains /* [in] [ref] */,
						  struct wbint_TransIDArray *_ids /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sids2UnixIDs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sids2UnixIDs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domains = _domains;
	state->orig.in.ids = _ids;

	/* Out parameters */
	state->orig.out.ids = _ids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Sids2UnixIDs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Sids2UnixIDs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sids2UnixIDs_done, req);
	return req;
}

static void dcerpc_wbint_Sids2UnixIDs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Sids2UnixIDs_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sids2UnixIDs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Sids2UnixIDs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ids = *state->tmp.out.ids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_wbint_Sids2UnixIDs_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sids2UnixIDs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct lsa_RefDomainList *_domains /* [in] [ref] */,
				   struct wbint_TransIDArray *_ids /* [in,out] [ref] */,
				   NTSTATUS *result)
{
	struct wbint_Sids2UnixIDs r;
	NTSTATUS status;

	/* In parameters */
	r.in.domains = _domains;
	r.in.ids = _ids;

	/* Out parameters */
	r.out.ids = _ids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_Sids2UnixIDs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ids = *r.out.ids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_UnixIDs2Sids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_UnixIDs2Sids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_UnixIDs2Sids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_UnixIDs2Sids *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_UnixIDs2Sids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_UnixIDs2Sids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_UNIXIDS2SIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_UnixIDs2Sids_r_done, req);

	return req;
}

static void dcerpc_wbint_UnixIDs2Sids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_UnixIDs2Sids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_UnixIDs2Sids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_UnixIDs2Sids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_UnixIDs2Sids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_UnixIDs2Sids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_UNIXIDS2SIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_UnixIDs2Sids_state {
	struct wbint_UnixIDs2Sids orig;
	struct wbint_UnixIDs2Sids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_UnixIDs2Sids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_UnixIDs2Sids_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_domain_name /* [in] [charset(UTF8),ref] */,
						  struct dom_sid _domain_sid /* [in]  */,
						  uint32_t _num_ids /* [in]  */,
						  struct unixid *_xids /* [in,out]  */,
						  struct dom_sid *_sids /* [out]  */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_UnixIDs2Sids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_UnixIDs2Sids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_sid = _domain_sid;
	state->orig.in.num_ids = _num_ids;
	state->orig.in.xids = _xids;

	/* Out parameters */
	state->orig.out.xids = _xids;
	state->orig.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_UnixIDs2Sids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_UnixIDs2Sids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_UnixIDs2Sids_done, req);
	return req;
}

static void dcerpc_wbint_UnixIDs2Sids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_UnixIDs2Sids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_UnixIDs2Sids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_UnixIDs2Sids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_xids;
		_copy_len_xids = state->tmp.in.num_ids;
		if (state->orig.out.xids != state->tmp.out.xids) {
			memcpy(state->orig.out.xids, state->tmp.out.xids, _copy_len_xids * sizeof(*state->orig.out.xids));
		}
	}
	{
		size_t _copy_len_sids;
		_copy_len_sids = state->tmp.in.num_ids;
		if (state->orig.out.sids != state->tmp.out.sids) {
			memcpy(state->orig.out.sids, state->tmp.out.sids, _copy_len_sids * sizeof(*state->orig.out.sids));
		}
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_UnixIDs2Sids_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_wbint_UnixIDs2Sids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_UnixIDs2Sids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_UnixIDs2Sids(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_domain_name /* [in] [charset(UTF8),ref] */,
				   struct dom_sid _domain_sid /* [in]  */,
				   uint32_t _num_ids /* [in]  */,
				   struct unixid *_xids /* [in,out]  */,
				   struct dom_sid *_sids /* [out]  */,
				   NTSTATUS *result)
{
	struct wbint_UnixIDs2Sids r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;
	r.in.domain_sid = _domain_sid;
	r.in.num_ids = _num_ids;
	r.in.xids = _xids;

	/* Out parameters */
	r.out.xids = _xids;
	r.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_UnixIDs2Sids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_xids;
		_copy_len_xids = r.in.num_ids;
		if (_xids != r.out.xids) {
			memcpy(_xids, r.out.xids, _copy_len_xids * sizeof(*_xids));
		}
	}
	{
		size_t _copy_len_sids;
		_copy_len_sids = r.in.num_ids;
		if (_sids != r.out.sids) {
			memcpy(_sids, r.out.sids, _copy_len_sids * sizeof(*_sids));
		}
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_AllocateUid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateUid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateUid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_AllocateUid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateUid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateUid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_ALLOCATEUID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateUid_r_done, req);

	return req;
}

static void dcerpc_wbint_AllocateUid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateUid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_AllocateUid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_AllocateUid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateUid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_AllocateUid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_ALLOCATEUID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_AllocateUid_state {
	struct wbint_AllocateUid orig;
	struct wbint_AllocateUid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateUid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateUid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 uint64_t *_uid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateUid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateUid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.uid = _uid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_AllocateUid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_AllocateUid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateUid_done, req);
	return req;
}

static void dcerpc_wbint_AllocateUid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_AllocateUid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateUid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_AllocateUid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.uid = *state->tmp.out.uid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateUid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_AllocateUid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateUid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateUid(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  uint64_t *_uid /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_AllocateUid r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.uid = _uid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_AllocateUid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_uid = *r.out.uid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_AllocateGid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateGid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateGid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_AllocateGid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateGid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateGid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_ALLOCATEGID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateGid_r_done, req);

	return req;
}

static void dcerpc_wbint_AllocateGid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateGid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_AllocateGid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_AllocateGid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateGid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_AllocateGid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_ALLOCATEGID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_AllocateGid_state {
	struct wbint_AllocateGid orig;
	struct wbint_AllocateGid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateGid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateGid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 uint64_t *_gid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateGid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateGid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.gid = _gid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_AllocateGid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_AllocateGid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateGid_done, req);
	return req;
}

static void dcerpc_wbint_AllocateGid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_AllocateGid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateGid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_AllocateGid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gid = *state->tmp.out.gid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateGid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_AllocateGid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateGid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateGid(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  uint64_t *_gid /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_AllocateGid r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.gid = _gid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_AllocateGid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_gid = *r.out.gid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_GetNssInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_GetNssInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_GetNssInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_GetNssInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_GetNssInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_GetNssInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_GETNSSINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_GetNssInfo_r_done, req);

	return req;
}

static void dcerpc_wbint_GetNssInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_GetNssInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_GetNssInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_GetNssInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_GetNssInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_GetNssInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_GETNSSINFO, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_GetNssInfo_state {
	struct wbint_GetNssInfo orig;
	struct wbint_GetNssInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_GetNssInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_GetNssInfo_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct wbint_userinfo *_info /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_GetNssInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_GetNssInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.info = _info;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_GetNssInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_GetNssInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_GetNssInfo_done, req);
	return req;
}

static void dcerpc_wbint_GetNssInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_GetNssInfo_state *state = tevent_req_data(
		req, struct dcerpc_wbint_GetNssInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_GetNssInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_GetNssInfo_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_GetNssInfo_state *state = tevent_req_data(
		req, struct dcerpc_wbint_GetNssInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_GetNssInfo(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct wbint_userinfo *_info /* [in,out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_GetNssInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.info = _info;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_GetNssInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupUserAliases_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserAliases_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserAliases_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupUserAliases *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserAliases_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserAliases_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPUSERALIASES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserAliases_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupUserAliases_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserAliases_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupUserAliases_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupUserAliases_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserAliases_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupUserAliases *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPUSERALIASES, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupUserAliases_state {
	struct wbint_LookupUserAliases orig;
	struct wbint_LookupUserAliases tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserAliases_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserAliases_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct wbint_SidArray *_sids /* [in] [ref] */,
						       struct wbint_RidArray *_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserAliases_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserAliases_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sids = _sids;

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupUserAliases_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupUserAliases_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserAliases_done, req);
	return req;
}

static void dcerpc_wbint_LookupUserAliases_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupUserAliases_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserAliases_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupUserAliases_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserAliases_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_wbint_LookupUserAliases_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserAliases_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserAliases(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct wbint_SidArray *_sids /* [in] [ref] */,
					struct wbint_RidArray *_rids /* [out] [ref] */,
					NTSTATUS *result)
{
	struct wbint_LookupUserAliases r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = _sids;

	/* Out parameters */
	r.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupUserAliases_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupUserGroups_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserGroups_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserGroups_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupUserGroups *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserGroups_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserGroups_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPUSERGROUPS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserGroups_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupUserGroups_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserGroups_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupUserGroups_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupUserGroups_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserGroups_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupUserGroups *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPUSERGROUPS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupUserGroups_state {
	struct wbint_LookupUserGroups orig;
	struct wbint_LookupUserGroups tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserGroups_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserGroups_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct dom_sid *_sid /* [in] [ref] */,
						      struct wbint_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupUserGroups_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupUserGroups_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserGroups_done, req);
	return req;
}

static void dcerpc_wbint_LookupUserGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupUserGroups_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupUserGroups_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserGroups_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_wbint_LookupUserGroups_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserGroups(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct dom_sid *_sid /* [in] [ref] */,
				       struct wbint_SidArray *_sids /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct wbint_LookupUserGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;

	/* Out parameters */
	r.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupUserGroups_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sids = *r.out.sids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QuerySequenceNumber_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QuerySequenceNumber_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QuerySequenceNumber_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QuerySequenceNumber *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QuerySequenceNumber_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QuerySequenceNumber_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_QUERYSEQUENCENUMBER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QuerySequenceNumber_r_done, req);

	return req;
}

static void dcerpc_wbint_QuerySequenceNumber_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QuerySequenceNumber_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QuerySequenceNumber_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QuerySequenceNumber *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_QUERYSEQUENCENUMBER, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QuerySequenceNumber_state {
	struct wbint_QuerySequenceNumber orig;
	struct wbint_QuerySequenceNumber tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QuerySequenceNumber_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QuerySequenceNumber_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 uint32_t *_sequence /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QuerySequenceNumber_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QuerySequenceNumber_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.sequence = _sequence;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QuerySequenceNumber_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QuerySequenceNumber_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QuerySequenceNumber_done, req);
	return req;
}

static void dcerpc_wbint_QuerySequenceNumber_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QuerySequenceNumber_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QuerySequenceNumber_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QuerySequenceNumber_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sequence = *state->tmp.out.sequence;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_wbint_QuerySequenceNumber_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QuerySequenceNumber_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  uint32_t *_sequence /* [out] [ref] */,
					  NTSTATUS *result)
{
	struct wbint_QuerySequenceNumber r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.sequence = _sequence;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_QuerySequenceNumber_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sequence = *r.out.sequence;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupGroupMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupGroupMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupGroupMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupGroupMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupGroupMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupGroupMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPGROUPMEMBERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupGroupMembers_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupGroupMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupGroupMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupGroupMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupGroupMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupGroupMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupGroupMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPGROUPMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupGroupMembers_state {
	struct wbint_LookupGroupMembers orig;
	struct wbint_LookupGroupMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupGroupMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupGroupMembers_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct dom_sid *_sid /* [in] [ref] */,
							enum lsa_SidType _type /* [in]  */,
							struct wbint_Principals *_members /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupGroupMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupGroupMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;
	state->orig.in.type = _type;

	/* Out parameters */
	state->orig.out.members = _members;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupGroupMembers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupGroupMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupGroupMembers_done, req);
	return req;
}

static void dcerpc_wbint_LookupGroupMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupGroupMembers_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupGroupMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupGroupMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.members = *state->tmp.out.members;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupGroupMembers_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupGroupMembers_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupGroupMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupGroupMembers(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct dom_sid *_sid /* [in] [ref] */,
					 enum lsa_SidType _type /* [in]  */,
					 struct wbint_Principals *_members /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct wbint_LookupGroupMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;
	r.in.type = _type;

	/* Out parameters */
	r.out.members = _members;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupGroupMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_members = *r.out.members;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupAliasMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupAliasMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupAliasMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupAliasMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupAliasMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupAliasMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPALIASMEMBERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupAliasMembers_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupAliasMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupAliasMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupAliasMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupAliasMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupAliasMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupAliasMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPALIASMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupAliasMembers_state {
	struct wbint_LookupAliasMembers orig;
	struct wbint_LookupAliasMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupAliasMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupAliasMembers_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct dom_sid *_sid /* [in] [ref] */,
							enum lsa_SidType _type /* [in]  */,
							struct wbint_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupAliasMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupAliasMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;
	state->orig.in.type = _type;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupAliasMembers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupAliasMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupAliasMembers_done, req);
	return req;
}

static void dcerpc_wbint_LookupAliasMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupAliasMembers_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupAliasMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupAliasMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupAliasMembers_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupAliasMembers_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupAliasMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupAliasMembers(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct dom_sid *_sid /* [in] [ref] */,
					 enum lsa_SidType _type /* [in]  */,
					 struct wbint_SidArray *_sids /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct wbint_LookupAliasMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;
	r.in.type = _type;

	/* Out parameters */
	r.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupAliasMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sids = *r.out.sids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QueryGroupList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryGroupList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryGroupList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QueryGroupList *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryGroupList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryGroupList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_QUERYGROUPLIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryGroupList_r_done, req);

	return req;
}

static void dcerpc_wbint_QueryGroupList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryGroupList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QueryGroupList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QueryGroupList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryGroupList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QueryGroupList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_QUERYGROUPLIST, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QueryGroupList_state {
	struct wbint_QueryGroupList orig;
	struct wbint_QueryGroupList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryGroupList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryGroupList_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct wbint_Principals *_groups /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryGroupList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryGroupList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.groups = _groups;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QueryGroupList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QueryGroupList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryGroupList_done, req);
	return req;
}

static void dcerpc_wbint_QueryGroupList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QueryGroupList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryGroupList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QueryGroupList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.groups = *state->tmp.out.groups;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryGroupList_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_wbint_QueryGroupList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryGroupList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryGroupList(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct wbint_Principals *_groups /* [out] [ref] */,
				     NTSTATUS *result)
{
	struct wbint_QueryGroupList r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.groups = _groups;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_QueryGroupList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_groups = *r.out.groups;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QueryUserRidList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryUserRidList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryUserRidList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QueryUserRidList *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryUserRidList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryUserRidList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_QUERYUSERRIDLIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryUserRidList_r_done, req);

	return req;
}

static void dcerpc_wbint_QueryUserRidList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryUserRidList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QueryUserRidList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QueryUserRidList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryUserRidList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QueryUserRidList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_QUERYUSERRIDLIST, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QueryUserRidList_state {
	struct wbint_QueryUserRidList orig;
	struct wbint_QueryUserRidList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryUserRidList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryUserRidList_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct wbint_RidArray *_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryUserRidList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryUserRidList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QueryUserRidList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QueryUserRidList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryUserRidList_done, req);
	return req;
}

static void dcerpc_wbint_QueryUserRidList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QueryUserRidList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryUserRidList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QueryUserRidList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryUserRidList_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_wbint_QueryUserRidList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryUserRidList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryUserRidList(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct wbint_RidArray *_rids /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct wbint_QueryUserRidList r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_QueryUserRidList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_DsGetDcName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_DsGetDcName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_DsGetDcName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_DsGetDcName *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_DsGetDcName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_DsGetDcName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_DSGETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_DsGetDcName_r_done, req);

	return req;
}

static void dcerpc_wbint_DsGetDcName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_DsGetDcName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_DsGetDcName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_DsGetDcName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_DsGetDcName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_DsGetDcName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_DSGETDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_DsGetDcName_state {
	struct wbint_DsGetDcName orig;
	struct wbint_DsGetDcName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_DsGetDcName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_DsGetDcName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_domain_name /* [in] [charset(UTF8),ref] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 const char *_site_name /* [in] [charset(UTF8),unique] */,
						 uint32_t _flags /* [in]  */,
						 struct netr_DsRGetDCNameInfo **_dc_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_DsGetDcName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_DsGetDcName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.dc_info = _dc_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_DsGetDcName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_DsGetDcName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_DsGetDcName_done, req);
	return req;
}

static void dcerpc_wbint_DsGetDcName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_DsGetDcName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_DsGetDcName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_DsGetDcName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dc_info = *state->tmp.out.dc_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_DsGetDcName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_DsGetDcName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_DsGetDcName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_DsGetDcName(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_domain_name /* [in] [charset(UTF8),ref] */,
				  struct GUID *_domain_guid /* [in] [unique] */,
				  const char *_site_name /* [in] [charset(UTF8),unique] */,
				  uint32_t _flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **_dc_info /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_DsGetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;
	r.in.domain_guid = _domain_guid;
	r.in.site_name = _site_name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.dc_info = _dc_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_DsGetDcName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dc_info = *r.out.dc_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupRids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupRids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupRids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupRids *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupRids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupRids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPRIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupRids_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupRids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupRids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupRids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupRids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupRids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupRids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LOOKUPRIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupRids_state {
	struct wbint_LookupRids orig;
	struct wbint_LookupRids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupRids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupRids_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct dom_sid *_domain_sid /* [in] [ref] */,
						struct wbint_RidArray *_rids /* [in] [ref] */,
						const char **_domain_name /* [out] [charset(UTF8),ref] */,
						struct wbint_Principals *_names /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupRids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupRids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_sid = _domain_sid;
	state->orig.in.rids = _rids;

	/* Out parameters */
	state->orig.out.domain_name = _domain_name;
	state->orig.out.names = _names;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupRids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupRids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupRids_done, req);
	return req;
}

static void dcerpc_wbint_LookupRids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupRids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupRids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupRids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domain_name = *state->tmp.out.domain_name;
	*state->orig.out.names = *state->tmp.out.names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupRids_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupRids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupRids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupRids(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct dom_sid *_domain_sid /* [in] [ref] */,
				 struct wbint_RidArray *_rids /* [in] [ref] */,
				 const char **_domain_name /* [out] [charset(UTF8),ref] */,
				 struct wbint_Principals *_names /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_LookupRids r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_sid = _domain_sid;
	r.in.rids = _rids;

	/* Out parameters */
	r.out.domain_name = _domain_name;
	r.out.names = _names;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_LookupRids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domain_name = *r.out.domain_name;
	*_names = *r.out.names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_CheckMachineAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_CheckMachineAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_CheckMachineAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_CheckMachineAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_CheckMachineAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_CheckMachineAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_CHECKMACHINEACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_CheckMachineAccount_r_done, req);

	return req;
}

static void dcerpc_wbint_CheckMachineAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_CheckMachineAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_CheckMachineAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_CheckMachineAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_CheckMachineAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_CheckMachineAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_CHECKMACHINEACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_CheckMachineAccount_state {
	struct wbint_CheckMachineAccount orig;
	struct wbint_CheckMachineAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_CheckMachineAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_CheckMachineAccount_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_wbint_CheckMachineAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_CheckMachineAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_CheckMachineAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_CheckMachineAccount_done, req);
	return req;
}

static void dcerpc_wbint_CheckMachineAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_CheckMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_CheckMachineAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_CheckMachineAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_CheckMachineAccount_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_wbint_CheckMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_CheckMachineAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_CheckMachineAccount(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct wbint_CheckMachineAccount r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_CheckMachineAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_ChangeMachineAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_ChangeMachineAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_ChangeMachineAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_ChangeMachineAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_ChangeMachineAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_ChangeMachineAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_CHANGEMACHINEACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_ChangeMachineAccount_r_done, req);

	return req;
}

static void dcerpc_wbint_ChangeMachineAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_ChangeMachineAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_ChangeMachineAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_ChangeMachineAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_CHANGEMACHINEACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_ChangeMachineAccount_state {
	struct wbint_ChangeMachineAccount orig;
	struct wbint_ChangeMachineAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_ChangeMachineAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_ChangeMachineAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_dcname /* [in] [charset(UTF8),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_ChangeMachineAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_ChangeMachineAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dcname = _dcname;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_ChangeMachineAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_ChangeMachineAccount_done, req);
	return req;
}

static void dcerpc_wbint_ChangeMachineAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_ChangeMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_ChangeMachineAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_ChangeMachineAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_wbint_ChangeMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_ChangeMachineAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_dcname /* [in] [charset(UTF8),unique] */,
					   NTSTATUS *result)
{
	struct wbint_ChangeMachineAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.dcname = _dcname;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_ChangeMachineAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PingDc_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PingDc_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PingDc_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PingDc *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PingDc_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PingDc_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PINGDC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PingDc_r_done, req);

	return req;
}

static void dcerpc_wbint_PingDc_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PingDc_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PingDc_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PingDc_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PingDc_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PingDc *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PINGDC, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PingDc_state {
	struct wbint_PingDc orig;
	struct wbint_PingDc tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PingDc_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PingDc_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    const char **_dcname /* [out] [charset(UTF8),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PingDc_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PingDc_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.dcname = _dcname;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_PingDc_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PingDc_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PingDc_done, req);
	return req;
}

static void dcerpc_wbint_PingDc_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PingDc_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PingDc_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PingDc_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dcname = *state->tmp.out.dcname;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PingDc_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct dcerpc_wbint_PingDc_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PingDc_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PingDc(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     const char **_dcname /* [out] [charset(UTF8),ref] */,
			     NTSTATUS *result)
{
	struct wbint_PingDc r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.dcname = _dcname;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_PingDc_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dcname = *r.out.dcname;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_ListTrustedDomains_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_ListTrustedDomains_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_ListTrustedDomains_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_ListTrustedDomains *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_ListTrustedDomains_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_ListTrustedDomains_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LISTTRUSTEDDOMAINS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_ListTrustedDomains_r_done, req);

	return req;
}

static void dcerpc_wbint_ListTrustedDomains_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_ListTrustedDomains_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_ListTrustedDomains_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_ListTrustedDomains_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_ListTrustedDomains_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_ListTrustedDomains *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_LISTTRUSTEDDOMAINS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_ListTrustedDomains_state {
	struct wbint_ListTrustedDomains orig;
	struct wbint_ListTrustedDomains tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_ListTrustedDomains_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_ListTrustedDomains_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_client_name /* [in] [charset(UTF8),ref] */,
							uint64_t _client_pid /* [in]  */,
							struct netr_DomainTrustList *_domains /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_ListTrustedDomains_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_ListTrustedDomains_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.client_name = _client_name;
	state->orig.in.client_pid = _client_pid;

	/* Out parameters */
	state->orig.out.domains = _domains;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_ListTrustedDomains_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_ListTrustedDomains_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_ListTrustedDomains_done, req);
	return req;
}

static void dcerpc_wbint_ListTrustedDomains_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_ListTrustedDomains_state *state = tevent_req_data(
		req, struct dcerpc_wbint_ListTrustedDomains_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_ListTrustedDomains_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_ListTrustedDomains_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_wbint_ListTrustedDomains_state *state = tevent_req_data(
		req, struct dcerpc_wbint_ListTrustedDomains_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_ListTrustedDomains(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_client_name /* [in] [charset(UTF8),ref] */,
					 uint64_t _client_pid /* [in]  */,
					 struct netr_DomainTrustList *_domains /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct wbint_ListTrustedDomains r;
	NTSTATUS status;

	/* In parameters */
	r.in.client_name = _client_name;
	r.in.client_pid = _client_pid;

	/* Out parameters */
	r.out.domains = _domains;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_ListTrustedDomains_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PamAuth_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuth_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuth_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PamAuth *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuth_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuth_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTH, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuth_r_done, req);

	return req;
}

static void dcerpc_wbint_PamAuth_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuth_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PamAuth_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PamAuth_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuth_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PamAuth *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTH, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PamAuth_state {
	struct wbint_PamAuth orig;
	struct wbint_PamAuth tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuth_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuth_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_client_name /* [in] [charset(UTF8),ref] */,
					     uint64_t _client_pid /* [in]  */,
					     uint32_t _flags /* [in]  */,
					     struct wbint_AuthUserInfo *_info /* [in] [ref] */,
					     struct wbint_SidArray *_require_membership_of_sid /* [in] [ref] */,
					     struct wbint_Validation *_validation /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuth_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuth_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.client_name = _client_name;
	state->orig.in.client_pid = _client_pid;
	state->orig.in.flags = _flags;
	state->orig.in.info = _info;
	state->orig.in.require_membership_of_sid = _require_membership_of_sid;

	/* Out parameters */
	state->orig.out.validation = _validation;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_PamAuth_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PamAuth_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuth_done, req);
	return req;
}

static void dcerpc_wbint_PamAuth_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PamAuth_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuth_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PamAuth_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.validation = *state->tmp.out.validation;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuth_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_wbint_PamAuth_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuth_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuth(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_client_name /* [in] [charset(UTF8),ref] */,
			      uint64_t _client_pid /* [in]  */,
			      uint32_t _flags /* [in]  */,
			      struct wbint_AuthUserInfo *_info /* [in] [ref] */,
			      struct wbint_SidArray *_require_membership_of_sid /* [in] [ref] */,
			      struct wbint_Validation *_validation /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct wbint_PamAuth r;
	NTSTATUS status;

	/* In parameters */
	r.in.client_name = _client_name;
	r.in.client_pid = _client_pid;
	r.in.flags = _flags;
	r.in.info = _info;
	r.in.require_membership_of_sid = _require_membership_of_sid;

	/* Out parameters */
	r.out.validation = _validation;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_PamAuth_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_validation = *r.out.validation;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PamAuthCrap_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuthCrap_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuthCrap_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PamAuthCrap *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuthCrap_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuthCrap_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTHCRAP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuthCrap_r_done, req);

	return req;
}

static void dcerpc_wbint_PamAuthCrap_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuthCrap_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PamAuthCrap_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PamAuthCrap_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuthCrap_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PamAuthCrap *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTHCRAP, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PamAuthCrap_state {
	struct wbint_PamAuthCrap orig;
	struct wbint_PamAuthCrap tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuthCrap_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuthCrap_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_client_name /* [in] [charset(UTF8),ref] */,
						 uint64_t _client_pid /* [in]  */,
						 uint32_t _flags /* [in]  */,
						 const char *_user /* [in] [charset(UTF8),ref] */,
						 const char *_domain /* [in] [charset(UTF8),ref] */,
						 const char *_workstation /* [in] [charset(UTF8),ref] */,
						 DATA_BLOB _lm_resp /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						 DATA_BLOB _nt_resp /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						 DATA_BLOB _chal /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						 uint32_t _logon_parameters /* [in]  */,
						 struct wbint_SidArray *_require_membership_of_sid /* [in] [ref] */,
						 uint8_t *_authoritative /* [out] [ref] */,
						 struct wbint_PamAuthCrapValidation *_validation /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuthCrap_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuthCrap_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.client_name = _client_name;
	state->orig.in.client_pid = _client_pid;
	state->orig.in.flags = _flags;
	state->orig.in.user = _user;
	state->orig.in.domain = _domain;
	state->orig.in.workstation = _workstation;
	state->orig.in.lm_resp = _lm_resp;
	state->orig.in.nt_resp = _nt_resp;
	state->orig.in.chal = _chal;
	state->orig.in.logon_parameters = _logon_parameters;
	state->orig.in.require_membership_of_sid = _require_membership_of_sid;

	/* Out parameters */
	state->orig.out.authoritative = _authoritative;
	state->orig.out.validation = _validation;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_PamAuthCrap_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PamAuthCrap_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuthCrap_done, req);
	return req;
}

static void dcerpc_wbint_PamAuthCrap_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PamAuthCrap_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuthCrap_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PamAuthCrap_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.authoritative = *state->tmp.out.authoritative;
	*state->orig.out.validation = *state->tmp.out.validation;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuthCrap_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_PamAuthCrap_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuthCrap_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuthCrap(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_client_name /* [in] [charset(UTF8),ref] */,
				  uint64_t _client_pid /* [in]  */,
				  uint32_t _flags /* [in]  */,
				  const char *_user /* [in] [charset(UTF8),ref] */,
				  const char *_domain /* [in] [charset(UTF8),ref] */,
				  const char *_workstation /* [in] [charset(UTF8),ref] */,
				  DATA_BLOB _lm_resp /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
				  DATA_BLOB _nt_resp /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
				  DATA_BLOB _chal /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
				  uint32_t _logon_parameters /* [in]  */,
				  struct wbint_SidArray *_require_membership_of_sid /* [in] [ref] */,
				  uint8_t *_authoritative /* [out] [ref] */,
				  struct wbint_PamAuthCrapValidation *_validation /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_PamAuthCrap r;
	NTSTATUS status;

	/* In parameters */
	r.in.client_name = _client_name;
	r.in.client_pid = _client_pid;
	r.in.flags = _flags;
	r.in.user = _user;
	r.in.domain = _domain;
	r.in.workstation = _workstation;
	r.in.lm_resp = _lm_resp;
	r.in.nt_resp = _nt_resp;
	r.in.chal = _chal;
	r.in.logon_parameters = _logon_parameters;
	r.in.require_membership_of_sid = _require_membership_of_sid;

	/* Out parameters */
	r.out.authoritative = _authoritative;
	r.out.validation = _validation;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_PamAuthCrap_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_authoritative = *r.out.authoritative;
	*_validation = *r.out.validation;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PamLogOff_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamLogOff_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamLogOff_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PamLogOff *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamLogOff_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamLogOff_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMLOGOFF, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamLogOff_r_done, req);

	return req;
}

static void dcerpc_wbint_PamLogOff_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamLogOff_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PamLogOff_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PamLogOff_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamLogOff_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PamLogOff *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMLOGOFF, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PamLogOff_state {
	struct wbint_PamLogOff orig;
	struct wbint_PamLogOff tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamLogOff_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamLogOff_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_client_name /* [in] [charset(UTF8),ref] */,
					       uint64_t _client_pid /* [in]  */,
					       uint32_t _flags /* [in]  */,
					       const char *_user /* [in] [charset(UTF8),ref] */,
					       const char *_krb5ccname /* [in] [charset(UTF8),ref] */,
					       uint64_t _uid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamLogOff_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamLogOff_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.client_name = _client_name;
	state->orig.in.client_pid = _client_pid;
	state->orig.in.flags = _flags;
	state->orig.in.user = _user;
	state->orig.in.krb5ccname = _krb5ccname;
	state->orig.in.uid = _uid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PamLogOff_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamLogOff_done, req);
	return req;
}

static void dcerpc_wbint_PamLogOff_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PamLogOff_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamLogOff_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PamLogOff_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamLogOff_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_wbint_PamLogOff_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamLogOff_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamLogOff(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_client_name /* [in] [charset(UTF8),ref] */,
				uint64_t _client_pid /* [in]  */,
				uint32_t _flags /* [in]  */,
				const char *_user /* [in] [charset(UTF8),ref] */,
				const char *_krb5ccname /* [in] [charset(UTF8),ref] */,
				uint64_t _uid /* [in]  */,
				NTSTATUS *result)
{
	struct wbint_PamLogOff r;
	NTSTATUS status;

	/* In parameters */
	r.in.client_name = _client_name;
	r.in.client_pid = _client_pid;
	r.in.flags = _flags;
	r.in.user = _user;
	r.in.krb5ccname = _krb5ccname;
	r.in.uid = _uid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_PamLogOff_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PamAuthCrapChangePassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuthCrapChangePassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuthCrapChangePassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PamAuthCrapChangePassword *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuthCrapChangePassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuthCrapChangePassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTHCRAPCHANGEPASSWORD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuthCrapChangePassword_r_done, req);

	return req;
}

static void dcerpc_wbint_PamAuthCrapChangePassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuthCrapChangePassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PamAuthCrapChangePassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PamAuthCrapChangePassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuthCrapChangePassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PamAuthCrapChangePassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTHCRAPCHANGEPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PamAuthCrapChangePassword_state {
	struct wbint_PamAuthCrapChangePassword orig;
	struct wbint_PamAuthCrapChangePassword tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuthCrapChangePassword_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuthCrapChangePassword_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       const char *_client_name /* [in] [charset(UTF8),ref] */,
							       uint64_t _client_pid /* [in]  */,
							       const char *_user /* [in] [charset(UTF8),ref] */,
							       const char *_domain /* [in] [charset(UTF8),ref] */,
							       DATA_BLOB _new_nt_pswd /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
							       DATA_BLOB _old_nt_hash_enc /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
							       DATA_BLOB _new_lm_pswd /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
							       DATA_BLOB _old_lm_hash_enc /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuthCrapChangePassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuthCrapChangePassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.client_name = _client_name;
	state->orig.in.client_pid = _client_pid;
	state->orig.in.user = _user;
	state->orig.in.domain = _domain;
	state->orig.in.new_nt_pswd = _new_nt_pswd;
	state->orig.in.old_nt_hash_enc = _old_nt_hash_enc;
	state->orig.in.new_lm_pswd = _new_lm_pswd;
	state->orig.in.old_lm_hash_enc = _old_lm_hash_enc;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PamAuthCrapChangePassword_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuthCrapChangePassword_done, req);
	return req;
}

static void dcerpc_wbint_PamAuthCrapChangePassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PamAuthCrapChangePassword_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuthCrapChangePassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PamAuthCrapChangePassword_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuthCrapChangePassword_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_wbint_PamAuthCrapChangePassword_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuthCrapChangePassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuthCrapChangePassword(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						const char *_client_name /* [in] [charset(UTF8),ref] */,
						uint64_t _client_pid /* [in]  */,
						const char *_user /* [in] [charset(UTF8),ref] */,
						const char *_domain /* [in] [charset(UTF8),ref] */,
						DATA_BLOB _new_nt_pswd /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						DATA_BLOB _old_nt_hash_enc /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						DATA_BLOB _new_lm_pswd /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						DATA_BLOB _old_lm_hash_enc /* [in] [flag(LIBNDR_FLAG_IS_SECRET)] */,
						NTSTATUS *result)
{
	struct wbint_PamAuthCrapChangePassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.client_name = _client_name;
	r.in.client_pid = _client_pid;
	r.in.user = _user;
	r.in.domain = _domain;
	r.in.new_nt_pswd = _new_nt_pswd;
	r.in.old_nt_hash_enc = _old_nt_hash_enc;
	r.in.new_lm_pswd = _new_lm_pswd;
	r.in.old_lm_hash_enc = _old_lm_hash_enc;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_PamAuthCrapChangePassword_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PamAuthChangePassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuthChangePassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuthChangePassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PamAuthChangePassword *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuthChangePassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuthChangePassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTHCHANGEPASSWORD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuthChangePassword_r_done, req);

	return req;
}

static void dcerpc_wbint_PamAuthChangePassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuthChangePassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PamAuthChangePassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PamAuthChangePassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuthChangePassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PamAuthChangePassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_PAMAUTHCHANGEPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PamAuthChangePassword_state {
	struct wbint_PamAuthChangePassword orig;
	struct wbint_PamAuthChangePassword tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PamAuthChangePassword_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PamAuthChangePassword_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_client_name /* [in] [charset(UTF8),ref] */,
							   uint64_t _client_pid /* [in]  */,
							   uint32_t _flags /* [in]  */,
							   const char *_user /* [in] [charset(UTF8),ref] */,
							   const char *_old_password /* [in] [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),ref] */,
							   const char *_new_password /* [in] [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),ref] */,
							   struct samr_DomInfo1 **_dominfo /* [out] [ref] */,
							   enum samPwdChangeReason *_reject_reason /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PamAuthChangePassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PamAuthChangePassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.client_name = _client_name;
	state->orig.in.client_pid = _client_pid;
	state->orig.in.flags = _flags;
	state->orig.in.user = _user;
	state->orig.in.old_password = _old_password;
	state->orig.in.new_password = _new_password;

	/* Out parameters */
	state->orig.out.dominfo = _dominfo;
	state->orig.out.reject_reason = _reject_reason;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_PamAuthChangePassword_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PamAuthChangePassword_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PamAuthChangePassword_done, req);
	return req;
}

static void dcerpc_wbint_PamAuthChangePassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PamAuthChangePassword_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuthChangePassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PamAuthChangePassword_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dominfo = *state->tmp.out.dominfo;
	*state->orig.out.reject_reason = *state->tmp.out.reject_reason;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PamAuthChangePassword_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct dcerpc_wbint_PamAuthChangePassword_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PamAuthChangePassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PamAuthChangePassword(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_client_name /* [in] [charset(UTF8),ref] */,
					    uint64_t _client_pid /* [in]  */,
					    uint32_t _flags /* [in]  */,
					    const char *_user /* [in] [charset(UTF8),ref] */,
					    const char *_old_password /* [in] [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),ref] */,
					    const char *_new_password /* [in] [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),ref] */,
					    struct samr_DomInfo1 **_dominfo /* [out] [ref] */,
					    enum samPwdChangeReason *_reject_reason /* [out] [ref] */,
					    NTSTATUS *result)
{
	struct wbint_PamAuthChangePassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.client_name = _client_name;
	r.in.client_pid = _client_pid;
	r.in.flags = _flags;
	r.in.user = _user;
	r.in.old_password = _old_password;
	r.in.new_password = _new_password;

	/* Out parameters */
	r.out.dominfo = _dominfo;
	r.out.reject_reason = _reject_reason;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_PamAuthChangePassword_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dominfo = *r.out.dominfo;
	*_reject_reason = *r.out.reject_reason;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_InitConnection_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_InitConnection_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_InitConnection_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_InitConnection *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_InitConnection_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_InitConnection_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_INITCONNECTION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_InitConnection_r_done, req);

	return req;
}

static void dcerpc_wbint_InitConnection_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_InitConnection_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_InitConnection_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_InitConnection_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_InitConnection_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_InitConnection *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_INITCONNECTION, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_InitConnection_state {
	struct wbint_InitConnection orig;
	struct wbint_InitConnection tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_InitConnection_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_InitConnection_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_dcname /* [in] [charset(UTF8),ref] */,
						    const char **_name /* [out] [charset(UTF8),ref] */,
						    const char **_alt_name /* [out] [charset(UTF8),ref] */,
						    struct dom_sid *_sid /* [out] [ref] */,
						    enum DomainInfoFlags *_flags /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_InitConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_InitConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dcname = _dcname;

	/* Out parameters */
	state->orig.out.name = _name;
	state->orig.out.alt_name = _alt_name;
	state->orig.out.sid = _sid;
	state->orig.out.flags = _flags;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_InitConnection_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_InitConnection_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_InitConnection_done, req);
	return req;
}

static void dcerpc_wbint_InitConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_InitConnection_state *state = tevent_req_data(
		req, struct dcerpc_wbint_InitConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_InitConnection_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name = *state->tmp.out.name;
	*state->orig.out.alt_name = *state->tmp.out.alt_name;
	*state->orig.out.sid = *state->tmp.out.sid;
	*state->orig.out.flags = *state->tmp.out.flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_InitConnection_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_wbint_InitConnection_state *state = tevent_req_data(
		req, struct dcerpc_wbint_InitConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_InitConnection(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_dcname /* [in] [charset(UTF8),ref] */,
				     const char **_name /* [out] [charset(UTF8),ref] */,
				     const char **_alt_name /* [out] [charset(UTF8),ref] */,
				     struct dom_sid *_sid /* [out] [ref] */,
				     enum DomainInfoFlags *_flags /* [out] [ref] */,
				     NTSTATUS *result)
{
	struct wbint_InitConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.dcname = _dcname;

	/* Out parameters */
	r.out.name = _name;
	r.out.alt_name = _alt_name;
	r.out.sid = _sid;
	r.out.flags = _flags;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_InitConnection_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_name = *r.out.name;
	*_alt_name = *r.out.alt_name;
	*_sid = *r.out.sid;
	*_flags = *r.out.flags;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_NormalizeNameMap_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_NormalizeNameMap_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_NormalizeNameMap_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_NormalizeNameMap *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_NormalizeNameMap_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_NormalizeNameMap_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_NORMALIZENAMEMAP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_NormalizeNameMap_r_done, req);

	return req;
}

static void dcerpc_wbint_NormalizeNameMap_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_NormalizeNameMap_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_NormalizeNameMap_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_NormalizeNameMap_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_NormalizeNameMap_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_NormalizeNameMap *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_NORMALIZENAMEMAP, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_NormalizeNameMap_state {
	struct wbint_NormalizeNameMap orig;
	struct wbint_NormalizeNameMap tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_NormalizeNameMap_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_NormalizeNameMap_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_domain_name /* [in] [charset(UTF8),ref] */,
						      const char *_name /* [in] [charset(UTF8),ref] */,
						      const char **_mapped_name /* [out] [charset(UTF8),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_NormalizeNameMap_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_NormalizeNameMap_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.mapped_name = _mapped_name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_NormalizeNameMap_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_NormalizeNameMap_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_NormalizeNameMap_done, req);
	return req;
}

static void dcerpc_wbint_NormalizeNameMap_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_NormalizeNameMap_state *state = tevent_req_data(
		req, struct dcerpc_wbint_NormalizeNameMap_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_NormalizeNameMap_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.mapped_name = *state->tmp.out.mapped_name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_NormalizeNameMap_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_wbint_NormalizeNameMap_state *state = tevent_req_data(
		req, struct dcerpc_wbint_NormalizeNameMap_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_NormalizeNameMap(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_domain_name /* [in] [charset(UTF8),ref] */,
				       const char *_name /* [in] [charset(UTF8),ref] */,
				       const char **_mapped_name /* [out] [charset(UTF8),ref] */,
				       NTSTATUS *result)
{
	struct wbint_NormalizeNameMap r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;
	r.in.name = _name;

	/* Out parameters */
	r.out.mapped_name = _mapped_name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_NormalizeNameMap_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_mapped_name = *r.out.mapped_name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_NormalizeNameUnmap_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_NormalizeNameUnmap_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_NormalizeNameUnmap_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_NormalizeNameUnmap *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_NormalizeNameUnmap_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_NormalizeNameUnmap_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_NORMALIZENAMEUNMAP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_NormalizeNameUnmap_r_done, req);

	return req;
}

static void dcerpc_wbint_NormalizeNameUnmap_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_NormalizeNameUnmap_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_NormalizeNameUnmap_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_NormalizeNameUnmap_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_NormalizeNameUnmap_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_NormalizeNameUnmap *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WBINT_NORMALIZENAMEUNMAP, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_NormalizeNameUnmap_state {
	struct wbint_NormalizeNameUnmap orig;
	struct wbint_NormalizeNameUnmap tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_NormalizeNameUnmap_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_NormalizeNameUnmap_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_name /* [in] [charset(UTF8),ref] */,
							const char **_unmapped_name /* [out] [charset(UTF8),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_NormalizeNameUnmap_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_NormalizeNameUnmap_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.unmapped_name = _unmapped_name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_NormalizeNameUnmap_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_NormalizeNameUnmap_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_NormalizeNameUnmap_done, req);
	return req;
}

static void dcerpc_wbint_NormalizeNameUnmap_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_NormalizeNameUnmap_state *state = tevent_req_data(
		req, struct dcerpc_wbint_NormalizeNameUnmap_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_NormalizeNameUnmap_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.unmapped_name = *state->tmp.out.unmapped_name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_NormalizeNameUnmap_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_wbint_NormalizeNameUnmap_state *state = tevent_req_data(
		req, struct dcerpc_wbint_NormalizeNameUnmap_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_NormalizeNameUnmap(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_name /* [in] [charset(UTF8),ref] */,
					 const char **_unmapped_name /* [out] [charset(UTF8),ref] */,
					 NTSTATUS *result)
{
	struct wbint_NormalizeNameUnmap r;
	NTSTATUS status;

	/* In parameters */
	r.in.name = _name;

	/* Out parameters */
	r.out.unmapped_name = _unmapped_name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_wbint_NormalizeNameUnmap_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_unmapped_name = *r.out.unmapped_name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winbind_SamLogon_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_SamLogon_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_SamLogon_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winbind_SamLogon *r)
{
	struct tevent_req *req;
	struct dcerpc_winbind_SamLogon_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_SamLogon_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_SAMLOGON, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_SamLogon_r_done, req);

	return req;
}

static void dcerpc_winbind_SamLogon_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_SamLogon_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winbind_SamLogon_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winbind_SamLogon_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_SamLogon_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winbind_SamLogon *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_SAMLOGON, mem_ctx, r);

	return status;
}

/*
 * The following functions are skipped because
 * an [out] argument validation is not a pointer or array:
 *
 * dcerpc_winbind_SamLogon_send()
 * dcerpc_winbind_SamLogon_recv()
 * dcerpc_winbind_SamLogon()
 */

struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winbind_DsrUpdateReadOnlyServerDnsRecords *r)
{
	struct tevent_req *req;
	struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_DSRUPDATEREADONLYSERVERDNSRECORDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_done, req);

	return req;
}

static void dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winbind_DsrUpdateReadOnlyServerDnsRecords *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_DSRUPDATEREADONLYSERVERDNSRECORDS, mem_ctx, r);

	return status;
}

struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state {
	struct winbind_DsrUpdateReadOnlyServerDnsRecords orig;
	struct winbind_DsrUpdateReadOnlyServerDnsRecords tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_send(TALLOC_CTX *mem_ctx,
									 struct tevent_context *ev,
									 struct dcerpc_binding_handle *h,
									 const char *_site_name /* [in] [charset(UTF16),unique] */,
									 uint32_t _dns_ttl /* [in]  */,
									 struct NL_DNS_NAME_INFO_ARRAY *_dns_names /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.site_name = _site_name;
	state->orig.in.dns_ttl = _dns_ttl;
	state->orig.in.dns_names = _dns_names;

	/* Out parameters */
	state->orig.out.dns_names = _dns_names;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_done, req);
	return req;
}

static void dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state *state = tevent_req_data(
		req, struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dns_names = *state->tmp.out.dns_names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_recv(struct tevent_req *req,
							       TALLOC_CTX *mem_ctx,
							       NTSTATUS *result)
{
	struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state *state = tevent_req_data(
		req, struct dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords(struct dcerpc_binding_handle *h,
							  TALLOC_CTX *mem_ctx,
							  const char *_site_name /* [in] [charset(UTF16),unique] */,
							  uint32_t _dns_ttl /* [in]  */,
							  struct NL_DNS_NAME_INFO_ARRAY *_dns_names /* [in,out] [ref] */,
							  NTSTATUS *result)
{
	struct winbind_DsrUpdateReadOnlyServerDnsRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.site_name = _site_name;
	r.in.dns_ttl = _dns_ttl;
	r.in.dns_names = _dns_names;

	/* Out parameters */
	r.out.dns_names = _dns_names;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winbind_DsrUpdateReadOnlyServerDnsRecords_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dns_names = *r.out.dns_names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winbind_LogonControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_LogonControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_LogonControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winbind_LogonControl *r)
{
	struct tevent_req *req;
	struct dcerpc_winbind_LogonControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_LogonControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_LOGONCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_LogonControl_r_done, req);

	return req;
}

static void dcerpc_winbind_LogonControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_LogonControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winbind_LogonControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winbind_LogonControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_LogonControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winbind_LogonControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_LOGONCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_winbind_LogonControl_state {
	struct winbind_LogonControl orig;
	struct winbind_LogonControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_LogonControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_LogonControl_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    enum netr_LogonControlCode _function_code /* [in]  */,
						    uint32_t _level /* [in]  */,
						    union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
						    union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_winbind_LogonControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_LogonControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.function_code = _function_code;
	state->orig.in.level = _level;
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winbind_LogonControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winbind_LogonControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_LogonControl_done, req);
	return req;
}

static void dcerpc_winbind_LogonControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winbind_LogonControl_state *state = tevent_req_data(
		req, struct dcerpc_winbind_LogonControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winbind_LogonControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_LogonControl_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_winbind_LogonControl_state *state = tevent_req_data(
		req, struct dcerpc_winbind_LogonControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_LogonControl(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     enum netr_LogonControlCode _function_code /* [in]  */,
				     uint32_t _level /* [in]  */,
				     union netr_CONTROL_DATA_INFORMATION *_data /* [in] [ref,switch_is(function_code)] */,
				     union netr_CONTROL_QUERY_INFORMATION *_query /* [out] [ref,switch_is(level)] */,
				     WERROR *result)
{
	struct winbind_LogonControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.function_code = _function_code;
	r.in.level = _level;
	r.in.data = _data;

	/* Out parameters */
	r.out.query = _query;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winbind_LogonControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_query = *r.out.query;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winbind_GetForestTrustInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_GetForestTrustInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_GetForestTrustInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winbind_GetForestTrustInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_winbind_GetForestTrustInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_GetForestTrustInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_GETFORESTTRUSTINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_GetForestTrustInformation_r_done, req);

	return req;
}

static void dcerpc_winbind_GetForestTrustInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_GetForestTrustInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winbind_GetForestTrustInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winbind_GetForestTrustInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_GetForestTrustInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winbind_GetForestTrustInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_GETFORESTTRUSTINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_winbind_GetForestTrustInformation_state {
	struct winbind_GetForestTrustInformation orig;
	struct winbind_GetForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_GetForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_GetForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_trusted_domain_name /* [in] [charset(UTF16),unique] */,
								 uint32_t _flags /* [in]  */,
								 struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winbind_GetForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_GetForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winbind_GetForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winbind_GetForestTrustInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_GetForestTrustInformation_done, req);
	return req;
}

static void dcerpc_winbind_GetForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winbind_GetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_winbind_GetForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winbind_GetForestTrustInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_GetForestTrustInformation_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_winbind_GetForestTrustInformation_state *state = tevent_req_data(
		req, struct dcerpc_winbind_GetForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_GetForestTrustInformation(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_trusted_domain_name /* [in] [charset(UTF16),unique] */,
						  uint32_t _flags /* [in]  */,
						  struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */,
						  WERROR *result)
{
	struct winbind_GetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.trusted_domain_name = _trusted_domain_name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.forest_trust_info = _forest_trust_info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winbind_GetForestTrustInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winbind_SendToSam_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_SendToSam_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_SendToSam_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winbind_SendToSam *r)
{
	struct tevent_req *req;
	struct dcerpc_winbind_SendToSam_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_SendToSam_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_SENDTOSAM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_SendToSam_r_done, req);

	return req;
}

static void dcerpc_winbind_SendToSam_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_SendToSam_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winbind_SendToSam_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winbind_SendToSam_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_SendToSam_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winbind_SendToSam *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winbind,
			NDR_WINBIND_SENDTOSAM, mem_ctx, r);

	return status;
}

struct dcerpc_winbind_SendToSam_state {
	struct winbind_SendToSam orig;
	struct winbind_SendToSam tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winbind_SendToSam_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winbind_SendToSam_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct netr_SendToSamBase _message /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winbind_SendToSam_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winbind_SendToSam_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.message = _message;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winbind_SendToSam_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winbind_SendToSam_done, req);
	return req;
}

static void dcerpc_winbind_SendToSam_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winbind_SendToSam_state *state = tevent_req_data(
		req, struct dcerpc_winbind_SendToSam_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winbind_SendToSam_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winbind_SendToSam_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_winbind_SendToSam_state *state = tevent_req_data(
		req, struct dcerpc_winbind_SendToSam_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winbind_SendToSam(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct netr_SendToSamBase _message /* [in]  */,
				  NTSTATUS *result)
{
	struct winbind_SendToSam r;
	NTSTATUS status;

	/* In parameters */
	r.in.message = _message;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winbind_SendToSam_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

