#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#include <wlr/backend.h>
#include <wlr/backend/headless.h>
#include <wlr/backend/libinput.h>
#include <wlr/backend/multi.h>
#include <wlr/interfaces/wlr_keyboard.h>
#include <wlr/render/allocator.h>
#include <wlr/render/drm_format_set.h>
#include <wlr/render/wlr_renderer.h>
#include <wlr/types/wlr_buffer.h>
#include <wlr/types/wlr_compositor.h>
#include <wlr/types/wlr_cursor.h>
#include <wlr/types/wlr_damage_ring.h>
#include <wlr/types/wlr_data_control_v1.h>
#include <wlr/types/wlr_data_device.h>
#include <wlr/types/wlr_export_dmabuf_v1.h>
#include <wlr/types/wlr_viewporter.h>
#include <wlr/types/wlr_foreign_toplevel_management_v1.h>
#include <wlr/types/wlr_fractional_scale_v1.h>
#include <wlr/types/wlr_gamma_control_v1.h>
#include <wlr/types/wlr_idle_inhibit_v1.h>
#include <wlr/types/wlr_idle_notify_v1.h>
#include <wlr/types/wlr_input_inhibitor.h>
#include <wlr/types/wlr_keyboard.h>
#include <wlr/types/wlr_layer_shell_v1.h>
#include <wlr/types/wlr_linux_dmabuf_v1.h>
#include <wlr/types/wlr_matrix.h>
#include <wlr/types/wlr_output.h>
#include <wlr/types/wlr_output_layout.h>
#include <wlr/types/wlr_output_management_v1.h>
#include <wlr/types/wlr_output_power_management_v1.h>
#include <wlr/types/wlr_pointer.h>
#include <wlr/types/wlr_pointer_constraints_v1.h>
#include <wlr/types/wlr_pointer_gestures_v1.h>
#include <wlr/types/wlr_presentation_time.h>
#include <wlr/types/wlr_primary_selection.h>
#include <wlr/types/wlr_primary_selection_v1.h>
#include <wlr/types/wlr_relative_pointer_v1.h>
#include <wlr/types/wlr_scene.h>
#include <wlr/types/wlr_screencopy_v1.h>
#include <wlr/types/wlr_seat.h>
#include <wlr/types/wlr_subcompositor.h>
#include <wlr/types/wlr_server_decoration.h>
#include <wlr/types/wlr_session_lock_v1.h>
#include <wlr/types/wlr_single_pixel_buffer_v1.h>
#include <wlr/types/wlr_switch.h>
#include <wlr/types/wlr_touch.h>
#include <wlr/types/wlr_virtual_keyboard_v1.h>
#include <wlr/types/wlr_virtual_pointer_v1.h>
#include <wlr/types/wlr_xcursor_manager.h>
#include <wlr/types/wlr_xdg_activation_v1.h>
#include <wlr/types/wlr_xdg_decoration_v1.h>
#include <wlr/types/wlr_xdg_output_v1.h>
#include <wlr/types/wlr_xdg_shell.h>
#include <wlr/util/addon.h>
#include <wlr/util/box.h>
#include <wlr/util/log.h>
#include <wlr/util/region.h>
#include <wlr/version.h>

#include <xkbcommon/xkbcommon.h>
#include <xkbcommon/xkbcommon-keysyms.h>
#include <xkbcommon/xkbcommon-compose.h>

struct wl_listener_container {
    void *handle;
    struct wl_listener destroy_listener;
};

typedef void (*wrapped_log_func_t)(enum wlr_log_importance importance, const char *log_str);

wrapped_log_func_t py_callback = NULL;

void wrapped_log_callback(enum wlr_log_importance importance, const char *fmt, va_list args)
{
    char formatted_str[4096];
    vsnprintf(formatted_str, 4096, fmt, args);
    py_callback(importance, formatted_str);
}

void wrapped_log_init(enum wlr_log_importance verbosity, wrapped_log_func_t callback)
{
    if (callback == NULL)
    {
        wlr_log_init(verbosity, NULL);
    }
    else
    {
        py_callback = callback;
        wlr_log_init(verbosity, wrapped_log_callback);
    }
}

    #include <wlr/xwayland.h>
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct pixman_region32 *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 1393), // struct pixman_region32 *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_backend *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 1421), // struct wlr_backend *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_box *, struct wlr_box const *, struct wlr_box const *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 1424), // struct wlr_box *
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 1424), // struct wlr_box const *
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_box const *)
/* 12 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_box const *, double, double)
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_buffer *, uint32_t, void * *, uint32_t *, size_t *)
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 1425), // struct wlr_buffer *
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 22 */ _CFFI_OP(_CFFI_OP_POINTER, 139), // void * *
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 21), // uint32_t *
/* 24 */ _CFFI_OP(_CFFI_OP_POINTER, 1073), // size_t *
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_cursor *, struct wlr_input_device *, double, double)
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 1429), // struct wlr_cursor *
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 1465), // struct wlr_input_device *
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_input_device *)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_output *)
/* 36 */ _CFFI_OP(_CFFI_OP_POINTER, 1484), // struct wlr_output *
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_output *, int *)
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 40 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // int *
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_output *, struct wlr_allocator *, struct wlr_renderer *)
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 44 */ _CFFI_OP(_CFFI_OP_POINTER, 1420), // struct wlr_allocator *
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 1533), // struct wlr_renderer *
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_output *, struct wlr_output_state const *)
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 49 */ _CFFI_OP(_CFFI_OP_POINTER, 1502), // struct wlr_output_state const *
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_renderer *, int, int)
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_renderer *, struct wl_display *)
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 58 */ _CFFI_OP(_CFFI_OP_POINTER, 1397), // struct wl_display *
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_renderer *, struct wlr_texture *, float const *, float)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 62 */ _CFFI_OP(_CFFI_OP_POINTER, 1587), // struct wlr_texture *
/* 63 */ _CFFI_OP(_CFFI_OP_POINTER, 64), // float const *
/* 64 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13), // float
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_renderer *, struct wlr_texture *, float const *, int, int, float)
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 71 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 72 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_scene_buffer *, double *, double *)
/* 75 */ _CFFI_OP(_CFFI_OP_POINTER, 1535), // struct wlr_scene_buffer *
/* 76 */ _CFFI_OP(_CFFI_OP_POINTER, 16), // double *
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_scene_node *, int *, int *)
/* 80 */ _CFFI_OP(_CFFI_OP_POINTER, 1537), // struct wlr_scene_node *
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_scene_output *, struct wlr_scene_output_state_options const *)
/* 85 */ _CFFI_OP(_CFFI_OP_POINTER, 1538), // struct wlr_scene_output *
/* 86 */ _CFFI_OP(_CFFI_OP_POINTER, 1540), // struct wlr_scene_output_state_options const *
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_seat *)
/* 89 */ _CFFI_OP(_CFFI_OP_POINTER, 1549), // struct wlr_seat *
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_seat *, struct wlr_surface *)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 93 */ _CFFI_OP(_CFFI_OP_POINTER, 1578), // struct wlr_surface *
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_seat *, struct wlr_surface *, uint32_t)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 98 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_session *, unsigned int)
/* 101 */ _CFFI_OP(_CFFI_OP_POINTER, 1565), // struct wlr_session *
/* 102 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_surface *)
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_surface *, double, double)
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 110 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_surface *, struct wlr_surface_role const *, struct wl_resource *, uint32_t)
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 114 */ _CFFI_OP(_CFFI_OP_POINTER, 1580), // struct wlr_surface_role const *
/* 115 */ _CFFI_OP(_CFFI_OP_POINTER, 1414), // struct wl_resource *
/* 116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_texture *, struct wlr_buffer *, struct pixman_region32 *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 495), // _Bool()(struct wlr_xwayland_surface const *)
/* 124 */ _CFFI_OP(_CFFI_OP_POINTER, 1657), // struct wlr_xwayland_surface const *
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 127), // enum wl_output_transform()(enum wl_output_transform)
/* 127 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum wl_output_transform
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION, 127), // enum wl_output_transform()(enum wl_output_transform, enum wl_output_transform)
/* 130 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1288), // enum wlr_xwayland_icccm_input_model()(struct wlr_xwayland_surface const *)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 124),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(int, uint32_t, void *)
/* 137 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 138 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 1685), // void *
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(int, void *)
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(int32_t, struct timespec *)
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 147 */ _CFFI_OP(_CFFI_OP_POINTER, 1394), // struct timespec *
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(struct wlr_seat *)
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(struct wlr_xcursor_manager *, float)
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 1616), // struct wlr_xcursor_manager *
/* 154 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(struct wlr_xwm *, xcb_generic_event_t *)
/* 157 */ _CFFI_OP(_CFFI_OP_POINTER, 1659), // struct wlr_xwm *
/* 158 */ _CFFI_OP(_CFFI_OP_POINTER, 1691), // xcb_generic_event_t *
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(void *)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 164 */ _CFFI_OP(_CFFI_OP_POINTER, 1685), // void const *
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 167 */ _CFFI_OP(_CFFI_OP_POINTER, 1411), // struct wl_message const *
/* 168 */ _CFFI_OP(_CFFI_OP_POINTER, 1677), // union wl_argument *
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION, 53), // int()(xcb_connection_t *)
/* 171 */ _CFFI_OP(_CFFI_OP_POINTER, 1686), // xcb_connection_t *
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1389), // struct libinput_device *()(struct wlr_input_device *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1391), // struct pixman_box32 *()(struct pixman_region32 *, int *)
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 44), // struct wlr_allocator *()(struct wlr_backend *, struct wlr_renderer *)
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // struct wlr_backend *()(struct wl_display *)
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // struct wlr_backend *()(struct wl_display *, struct wlr_session * *)
/* 188 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 189 */ _CFFI_OP(_CFFI_OP_POINTER, 101), // struct wlr_session * *
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 20), // struct wlr_buffer *()(struct wlr_allocator *, int, int, struct wlr_drm_format const *)
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 44),
/* 193 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 194 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 195 */ _CFFI_OP(_CFFI_OP_POINTER, 1444), // struct wlr_drm_format const *
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 20), // struct wlr_buffer *()(struct wlr_buffer *)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 494), // struct wlr_compositor *()(struct wl_display *, uint32_t, struct wlr_renderer *)
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 202 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // struct wlr_cursor *()(void)
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1433), // struct wlr_data_control_manager_v1 *()(struct wl_display *)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1435), // struct wlr_data_device_manager *()(struct wl_display *)
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION, 195), // struct wlr_drm_format const *()(struct wlr_drm_format_set const *, uint32_t)
/* 214 */ _CFFI_OP(_CFFI_OP_POINTER, 1445), // struct wlr_drm_format_set const *
/* 215 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1447), // struct wlr_export_dmabuf_manager_v1 *()(struct wl_display *)
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 692), // struct wlr_foreign_toplevel_handle_v1 *()(struct wlr_foreign_toplevel_manager_v1 *)
/* 221 */ _CFFI_OP(_CFFI_OP_POINTER, 1456), // struct wlr_foreign_toplevel_manager_v1 *
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION, 221), // struct wlr_foreign_toplevel_manager_v1 *()(struct wl_display *)
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1457), // struct wlr_fractional_scale_manager_v1 *()(struct wl_display *, uint32_t)
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1459), // struct wlr_gamma_control_manager_v1 *()(struct wl_display *)
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1461), // struct wlr_idle_inhibit_manager_v1 *()(struct wl_display *)
/* 234 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION, 711), // struct wlr_idle_notifier_v1 *()(struct wl_display *)
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1466), // struct wlr_input_inhibit_manager *()(struct wl_display *)
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION, 509), // struct wlr_keyboard *()(struct wlr_input_device *)
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 509), // struct wlr_keyboard *()(struct wlr_seat *)
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1477), // struct wlr_layer_shell_v1 *()(struct wl_display *, uint32_t)
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 250 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // struct wlr_layer_surface_v1 *()(struct wlr_surface *)
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1482), // struct wlr_linux_dmabuf_v1 *()(struct wl_display *, uint32_t, struct wlr_linux_dmabuf_feedback_v1 const *)
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 258 */ _CFFI_OP(_CFFI_OP_POINTER, 1481), // struct wlr_linux_dmabuf_feedback_v1 const *
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION, 36), // struct wlr_output *()(struct wlr_backend *, unsigned int, unsigned int)
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 262 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 36), // struct wlr_output *()(struct wlr_output_layout *, double, double)
/* 266 */ _CFFI_OP(_CFFI_OP_POINTER, 1494), // struct wlr_output_layout *
/* 267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 268 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1485), // struct wlr_output_configuration_head_v1 *()(struct wlr_output_configuration_v1 *, struct wlr_output *)
/* 271 */ _CFFI_OP(_CFFI_OP_POINTER, 1487), // struct wlr_output_configuration_v1 *
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 274 */ _CFFI_OP(_CFFI_OP_FUNCTION, 271), // struct wlr_output_configuration_v1 *()(void)
/* 275 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION, 266), // struct wlr_output_layout *()(void)
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1005), // struct wlr_output_layout_output *()(struct wlr_output_layout *, struct wlr_output *)
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 280 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 282 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1005), // struct wlr_output_layout_output *()(struct wlr_output_layout *, struct wlr_output *, int, int)
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 284 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 285 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 286 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 815), // struct wlr_output_manager_v1 *()(struct wl_display *)
/* 289 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 290 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION, 779), // struct wlr_output_mode *()(struct wlr_output *)
/* 292 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 294 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1498), // struct wlr_output_power_manager_v1 *()(struct wl_display *)
/* 295 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1503), // struct wlr_pointer *()(struct wlr_input_device *)
/* 298 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 852), // struct wlr_pointer_constraint_v1 *()(struct wlr_pointer_constraints_v1 *, struct wlr_surface *, struct wlr_seat *)
/* 301 */ _CFFI_OP(_CFFI_OP_POINTER, 1511), // struct wlr_pointer_constraints_v1 *
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION, 301), // struct wlr_pointer_constraints_v1 *()(struct wl_display *)
/* 306 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION, 855), // struct wlr_pointer_gestures_v1 *()(struct wl_display *)
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION, 910), // struct wlr_presentation *()(struct wl_display *, struct wlr_backend *)
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 313 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1529), // struct wlr_primary_selection_v1_device_manager *()(struct wl_display *)
/* 316 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 318 */ _CFFI_OP(_CFFI_OP_FUNCTION, 883), // struct wlr_relative_pointer_manager_v1 *()(struct wl_display *)
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 320 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION, 45), // struct wlr_renderer *()(struct wlr_backend *)
/* 322 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 323 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 324 */ _CFFI_OP(_CFFI_OP_FUNCTION, 345), // struct wlr_scene *()(void)
/* 325 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_scene_buffer *()(struct wlr_scene_node *)
/* 327 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 328 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 329 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_scene_buffer *()(struct wlr_scene_tree *, struct wlr_buffer *)
/* 330 */ _CFFI_OP(_CFFI_OP_POINTER, 1546), // struct wlr_scene_tree *
/* 331 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 333 */ _CFFI_OP(_CFFI_OP_FUNCTION, 953), // struct wlr_scene_layer_surface_v1 *()(struct wlr_scene_tree *, struct wlr_layer_surface_v1 *)
/* 334 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 335 */ _CFFI_OP(_CFFI_OP_POINTER, 1479), // struct wlr_layer_surface_v1 *
/* 336 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 337 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // struct wlr_scene_node *()(struct wlr_scene_node *, double, double, double *, double *)
/* 338 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 339 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 340 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 341 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 342 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 343 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 344 */ _CFFI_OP(_CFFI_OP_FUNCTION, 85), // struct wlr_scene_output *()(struct wlr_scene *, struct wlr_output *)
/* 345 */ _CFFI_OP(_CFFI_OP_POINTER, 1534), // struct wlr_scene *
/* 346 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 347 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1004), // struct wlr_scene_output_layout *()(struct wlr_scene *, struct wlr_output_layout *)
/* 349 */ _CFFI_OP(_CFFI_OP_NOOP, 345),
/* 350 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 352 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1009), // struct wlr_scene_rect *()(struct wlr_scene_tree *, int, int, float const *)
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 354 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 355 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 356 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1542), // struct wlr_scene_surface *()(struct wlr_scene_buffer *)
/* 359 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 360 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1542), // struct wlr_scene_surface *()(struct wlr_scene_tree *, struct wlr_surface *)
/* 362 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION, 330), // struct wlr_scene_tree *()(struct wlr_scene_tree *)
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 367 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 368 */ _CFFI_OP(_CFFI_OP_FUNCTION, 330), // struct wlr_scene_tree *()(struct wlr_scene_tree *, struct wlr_drag_icon *)
/* 369 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 370 */ _CFFI_OP(_CFFI_OP_POINTER, 1442), // struct wlr_drag_icon *
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION, 330), // struct wlr_scene_tree *()(struct wlr_scene_tree *, struct wlr_surface *)
/* 373 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 374 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 375 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 376 */ _CFFI_OP(_CFFI_OP_FUNCTION, 330), // struct wlr_scene_tree *()(struct wlr_scene_tree *, struct wlr_xdg_surface *)
/* 377 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 378 */ _CFFI_OP(_CFFI_OP_POINTER, 1634), // struct wlr_xdg_surface *
/* 379 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1547), // struct wlr_screencopy_manager_v1 *()(struct wl_display *)
/* 381 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 382 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 383 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // struct wlr_seat *()(struct wl_display *, char const *)
/* 384 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 385 */ _CFFI_OP(_CFFI_OP_POINTER, 1266), // char const *
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 387 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1121), // struct wlr_server_decoration_manager *()(struct wl_display *)
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 389 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 390 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1566), // struct wlr_session_lock_manager_v1 *()(struct wl_display *)
/* 391 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 392 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 393 */ _CFFI_OP(_CFFI_OP_FUNCTION, 526), // struct wlr_session_lock_surface_v1 *()(struct wlr_surface *)
/* 394 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 395 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 396 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1572), // struct wlr_single_pixel_buffer_manager_v1 *()(struct wl_display *)
/* 397 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 398 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 399 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1574), // struct wlr_subcompositor *()(struct wl_display *)
/* 400 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 401 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 402 */ _CFFI_OP(_CFFI_OP_FUNCTION, 93), // struct wlr_surface *()(struct wl_resource *)
/* 403 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 405 */ _CFFI_OP(_CFFI_OP_FUNCTION, 93), // struct wlr_surface *()(struct wlr_layer_surface_v1 *, double, double, double *, double *)
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 335),
/* 407 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 408 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 409 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 410 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 411 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 412 */ _CFFI_OP(_CFFI_OP_FUNCTION, 93), // struct wlr_surface *()(struct wlr_surface *)
/* 413 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 414 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 415 */ _CFFI_OP(_CFFI_OP_FUNCTION, 93), // struct wlr_surface *()(struct wlr_surface *, double, double, double *, double *)
/* 416 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 417 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 418 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 419 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 420 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 421 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 422 */ _CFFI_OP(_CFFI_OP_FUNCTION, 93), // struct wlr_surface *()(struct wlr_xdg_surface *, double, double, double *, double *)
/* 423 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 424 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 425 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 426 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 427 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 429 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1584), // struct wlr_switch *()(struct wlr_input_device *)
/* 430 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 431 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 432 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // struct wlr_texture *()(struct wlr_renderer *, struct wlr_buffer *)
/* 433 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 434 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 435 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 436 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // struct wlr_texture *()(struct wlr_renderer *, uint32_t, uint32_t, uint32_t, uint32_t, void const *)
/* 437 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 438 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 439 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 440 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 441 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 442 */ _CFFI_OP(_CFFI_OP_NOOP, 164),
/* 443 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 444 */ _CFFI_OP(_CFFI_OP_FUNCTION, 62), // struct wlr_texture *()(struct wlr_surface *)
/* 445 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 446 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 447 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1588), // struct wlr_touch *()(struct wlr_input_device *)
/* 448 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 449 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 450 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1597), // struct wlr_touch_point *()(struct wlr_seat *, int32_t)
/* 451 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 452 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 453 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 454 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1600), // struct wlr_viewporter *()(struct wl_display *)
/* 455 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 456 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 457 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1602), // struct wlr_virtual_keyboard_manager_v1 *()(struct wl_display *)
/* 458 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 460 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1604), // struct wlr_virtual_keyboard_v1 *()(struct wlr_input_device *)
/* 461 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1606), // struct wlr_virtual_pointer_manager_v1 *()(struct wl_display *)
/* 464 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 465 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 466 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1611), // struct wlr_xcursor *()(struct wlr_xcursor_manager *, char const *, float)
/* 467 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 468 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 469 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 470 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 471 */ _CFFI_OP(_CFFI_OP_FUNCTION, 153), // struct wlr_xcursor_manager *()(char const *, uint32_t)
/* 472 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 473 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 475 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1619), // struct wlr_xdg_activation_v1 *()(struct wl_display *)
/* 476 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 477 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 478 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1624), // struct wlr_xdg_decoration_manager_v1 *()(struct wl_display *)
/* 479 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 480 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 481 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1626), // struct wlr_xdg_output_manager_v1 *()(struct wl_display *, struct wlr_output_layout *)
/* 482 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 483 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 484 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 485 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1632), // struct wlr_xdg_shell *()(struct wl_display *, uint32_t)
/* 486 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 487 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 488 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 489 */ _CFFI_OP(_CFFI_OP_FUNCTION, 378), // struct wlr_xdg_surface *()(struct wlr_surface *)
/* 490 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 491 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 492 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1198), // struct wlr_xwayland *()(struct wl_display *, struct wlr_compositor *, _Bool)
/* 493 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 494 */ _CFFI_OP(_CFFI_OP_POINTER, 1428), // struct wlr_compositor *
/* 495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 496 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 497 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1214), // struct wlr_xwayland_server *()(struct wl_display *, struct wlr_xwayland_server_options *)
/* 498 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 499 */ _CFFI_OP(_CFFI_OP_POINTER, 1656), // struct wlr_xwayland_server_options *
/* 500 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 501 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1217), // struct wlr_xwayland_surface *()(struct wlr_surface *)
/* 502 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 503 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 504 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1668), // uint32_t const *()(struct wlr_renderer *, size_t *)
/* 505 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 506 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 507 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 508 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_keyboard *)
/* 509 */ _CFFI_OP(_CFFI_OP_POINTER, 1468), // struct wlr_keyboard *
/* 510 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 511 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_seat *, struct wlr_surface *, uint32_t, int32_t, double, double)
/* 512 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 513 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 514 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 515 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 516 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 517 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 518 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 519 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_seat *, uint32_t, uint32_t, enum wlr_button_state)
/* 520 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 522 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 523 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // enum wlr_button_state
/* 524 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_session_lock_surface_v1 *, uint32_t, uint32_t)
/* 526 */ _CFFI_OP(_CFFI_OP_POINTER, 1568), // struct wlr_session_lock_surface_v1 *
/* 527 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 528 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 529 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 530 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_surface *)
/* 531 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 532 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 533 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_xdg_surface *)
/* 534 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_xdg_toplevel *, _Bool)
/* 537 */ _CFFI_OP(_CFFI_OP_POINTER, 1638), // struct wlr_xdg_toplevel *
/* 538 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 539 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 540 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_xdg_toplevel *, int32_t, int32_t)
/* 541 */ _CFFI_OP(_CFFI_OP_NOOP, 537),
/* 542 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 543 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 544 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 545 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_xdg_toplevel *, uint32_t)
/* 546 */ _CFFI_OP(_CFFI_OP_NOOP, 537),
/* 547 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 548 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 549 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // uint32_t()(struct wlr_xdg_toplevel_decoration_v1 *, enum wlr_xdg_toplevel_decoration_v1_mode)
/* 550 */ _CFFI_OP(_CFFI_OP_POINTER, 1641), // struct wlr_xdg_toplevel_decoration_v1 *
/* 551 */ _CFFI_OP(_CFFI_OP_ENUM, 24), // enum wlr_xdg_toplevel_decoration_v1_mode
/* 552 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 553 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(enum wlr_log_importance, char const *)
/* 554 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // enum wlr_log_importance
/* 555 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 556 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 557 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(enum wlr_log_importance, void(*)(enum wlr_log_importance, char const *))
/* 558 */ _CFFI_OP(_CFFI_OP_NOOP, 554),
/* 559 */ _CFFI_OP(_CFFI_OP_POINTER, 553), // void(*)(enum wlr_log_importance, char const *)
/* 560 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 561 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *)
/* 562 */ _CFFI_OP(_CFFI_OP_POINTER, 64), // float *
/* 563 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 564 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *, enum wl_output_transform)
/* 565 */ _CFFI_OP(_CFFI_OP_NOOP, 562),
/* 566 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 567 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 568 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *, float const *)
/* 569 */ _CFFI_OP(_CFFI_OP_NOOP, 562),
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 571 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 572 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *, float const *, float const *)
/* 573 */ _CFFI_OP(_CFFI_OP_NOOP, 562),
/* 574 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 576 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 577 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *, float)
/* 578 */ _CFFI_OP(_CFFI_OP_NOOP, 562),
/* 579 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 580 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 581 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *, float, float)
/* 582 */ _CFFI_OP(_CFFI_OP_NOOP, 562),
/* 583 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 584 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 585 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 586 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(float *, struct wlr_box const *, enum wl_output_transform, float, float const *)
/* 587 */ _CFFI_OP(_CFFI_OP_NOOP, 562),
/* 588 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 589 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 590 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 591 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 592 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 593 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct pixman_region32 *)
/* 594 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 595 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 596 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct pixman_region32 *, int, int, unsigned int, unsigned int)
/* 597 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 598 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 599 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 600 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 601 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 602 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 603 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct pixman_region32 *, struct pixman_region32 *, enum wl_output_transform, int, int)
/* 604 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 605 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 606 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 607 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 608 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 609 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 610 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wl_client *, void *, uint32_t, uint32_t)
/* 611 */ _CFFI_OP(_CFFI_OP_POINTER, 1396), // struct wl_client *
/* 612 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 613 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 614 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 615 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 616 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wl_listener *, void *)
/* 617 */ _CFFI_OP(_CFFI_OP_POINTER, 1409), // struct wl_listener *
/* 618 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 619 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 620 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wl_resource *)
/* 621 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 622 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 623 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_backend *)
/* 624 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 625 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 626 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_box *, struct wlr_box const *, enum wl_output_transform, int, int)
/* 627 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 628 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 629 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 630 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 631 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 632 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 633 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_box const *, double, double, double *, double *)
/* 634 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 635 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 636 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 637 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 638 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 639 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 640 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_buffer *)
/* 641 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 642 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 643 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *)
/* 644 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 645 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 646 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_input_device *)
/* 647 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 648 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 649 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 650 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_input_device *, double, double)
/* 651 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 652 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 653 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 654 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 655 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 656 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_input_device *, double, double, double *, double *)
/* 657 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 658 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 659 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 660 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 661 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 662 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 663 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 664 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_input_device *, struct wlr_output *)
/* 665 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 666 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 667 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 668 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 669 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_output *)
/* 670 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 671 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 672 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 673 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_output_layout *)
/* 674 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 675 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 676 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 677 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_surface *, int32_t, int32_t)
/* 678 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 679 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 680 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 681 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 682 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 683 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_cursor *, struct wlr_xcursor_manager *, char const *)
/* 684 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 685 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 686 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 687 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 688 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_data_source *)
/* 689 */ _CFFI_OP(_CFFI_OP_POINTER, 1437), // struct wlr_data_source *
/* 690 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 691 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_foreign_toplevel_handle_v1 *)
/* 692 */ _CFFI_OP(_CFFI_OP_POINTER, 1450), // struct wlr_foreign_toplevel_handle_v1 *
/* 693 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 694 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_foreign_toplevel_handle_v1 *, _Bool)
/* 695 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 696 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 697 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 698 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_foreign_toplevel_handle_v1 *, char const *)
/* 699 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 700 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 701 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 702 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_foreign_toplevel_handle_v1 *, struct wlr_foreign_toplevel_handle_v1 *)
/* 703 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 704 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 705 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 706 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_foreign_toplevel_handle_v1 *, struct wlr_output *)
/* 707 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 708 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 709 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 710 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_idle_notifier_v1 *, _Bool)
/* 711 */ _CFFI_OP(_CFFI_OP_POINTER, 1464), // struct wlr_idle_notifier_v1 *
/* 712 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 713 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 714 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_idle_notifier_v1 *, struct wlr_seat *)
/* 715 */ _CFFI_OP(_CFFI_OP_NOOP, 711),
/* 716 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 717 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 718 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_keyboard *, int32_t, int32_t)
/* 719 */ _CFFI_OP(_CFFI_OP_NOOP, 509),
/* 720 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 721 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 722 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 723 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_keyboard *, struct xkb_keymap *)
/* 724 */ _CFFI_OP(_CFFI_OP_NOOP, 509),
/* 725 */ _CFFI_OP(_CFFI_OP_POINTER, 1663), // struct xkb_keymap *
/* 726 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 727 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_keyboard *, uint32_t, uint32_t, uint32_t, uint32_t)
/* 728 */ _CFFI_OP(_CFFI_OP_NOOP, 509),
/* 729 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 730 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 731 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 732 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 733 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 734 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_layer_surface_v1 *)
/* 735 */ _CFFI_OP(_CFFI_OP_NOOP, 335),
/* 736 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 737 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_layer_surface_v1 *, uint32_t, uint32_t)
/* 738 */ _CFFI_OP(_CFFI_OP_NOOP, 335),
/* 739 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 740 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 741 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 742 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_layer_surface_v1 *, void(*)(struct wlr_surface *, int, int, void *), void *)
/* 743 */ _CFFI_OP(_CFFI_OP_NOOP, 335),
/* 744 */ _CFFI_OP(_CFFI_OP_POINTER, 1134), // void(*)(struct wlr_surface *, int, int, void *)
/* 745 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 746 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 747 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *)
/* 748 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 749 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 750 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, _Bool)
/* 751 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 752 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 753 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 754 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, enum wl_output_transform)
/* 755 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 756 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 757 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 758 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, float)
/* 759 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 760 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 761 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 762 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, int *, int *)
/* 763 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 764 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 765 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 766 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 767 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, int32_t, int32_t, int32_t)
/* 768 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 769 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 770 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 771 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 772 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 773 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, struct pixman_region32 *)
/* 774 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 775 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 776 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 777 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output *, struct wlr_output_mode *)
/* 778 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 779 */ _CFFI_OP(_CFFI_OP_POINTER, 1497), // struct wlr_output_mode *
/* 780 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 781 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_configuration_v1 *)
/* 782 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 783 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 784 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_head_v1_state const *, struct wlr_output_state *)
/* 785 */ _CFFI_OP(_CFFI_OP_POINTER, 1491), // struct wlr_output_head_v1_state const *
/* 786 */ _CFFI_OP(_CFFI_OP_POINTER, 1502), // struct wlr_output_state *
/* 787 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 788 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_layout *)
/* 789 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 790 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 791 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_layout *, struct wlr_output *)
/* 792 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 793 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 794 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 795 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_layout *, struct wlr_output *, double *, double *)
/* 796 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 797 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 798 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 799 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 800 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 801 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_layout *, struct wlr_output *, double, double, double *, double *)
/* 802 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 803 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 804 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 805 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 806 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 807 */ _CFFI_OP(_CFFI_OP_NOOP, 76),
/* 808 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 809 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_layout *, struct wlr_output *, struct wlr_box *)
/* 810 */ _CFFI_OP(_CFFI_OP_NOOP, 266),
/* 811 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 812 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 813 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 814 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_manager_v1 *, struct wlr_output_configuration_v1 *)
/* 815 */ _CFFI_OP(_CFFI_OP_POINTER, 1496), // struct wlr_output_manager_v1 *
/* 816 */ _CFFI_OP(_CFFI_OP_NOOP, 271),
/* 817 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 818 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *)
/* 819 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 820 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 821 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, _Bool)
/* 822 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 823 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 824 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 825 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, enum wl_output_subpixel)
/* 826 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 827 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum wl_output_subpixel
/* 828 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 829 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, enum wl_output_transform)
/* 830 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 831 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 832 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 833 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, float)
/* 834 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 835 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 836 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 837 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, int32_t, int32_t, int32_t)
/* 838 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 839 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 840 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 841 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 842 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 843 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, struct wlr_output_mode *)
/* 844 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 845 */ _CFFI_OP(_CFFI_OP_NOOP, 779),
/* 846 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 847 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_output_state *, uint32_t)
/* 848 */ _CFFI_OP(_CFFI_OP_NOOP, 786),
/* 849 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 850 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 851 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_pointer_constraint_v1 *)
/* 852 */ _CFFI_OP(_CFFI_OP_POINTER, 1509), // struct wlr_pointer_constraint_v1 *
/* 853 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 854 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_pointer_gestures_v1 *, struct wlr_seat *, uint32_t, _Bool)
/* 855 */ _CFFI_OP(_CFFI_OP_POINTER, 1512), // struct wlr_pointer_gestures_v1 *
/* 856 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 857 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 858 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 859 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 860 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_pointer_gestures_v1 *, struct wlr_seat *, uint32_t, double, double)
/* 861 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 862 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 863 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 864 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 865 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 866 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 867 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_pointer_gestures_v1 *, struct wlr_seat *, uint32_t, double, double, double, double)
/* 868 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 869 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 870 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 871 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 872 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 873 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 874 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 875 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 876 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_pointer_gestures_v1 *, struct wlr_seat *, uint32_t, uint32_t)
/* 877 */ _CFFI_OP(_CFFI_OP_NOOP, 855),
/* 878 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 879 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 880 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 881 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 882 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_relative_pointer_manager_v1 *, struct wlr_seat *, uint64_t, double, double, double, double)
/* 883 */ _CFFI_OP(_CFFI_OP_POINTER, 1531), // struct wlr_relative_pointer_manager_v1 *
/* 884 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 885 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 886 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 887 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 888 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 889 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 890 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 891 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_renderer *)
/* 892 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 893 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 894 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_renderer *, float const *)
/* 895 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 896 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 897 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 898 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_renderer *, struct wlr_box *)
/* 899 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 900 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 901 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 902 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_renderer *, struct wlr_box const *, float const *, float const *)
/* 903 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 904 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 905 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 906 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 907 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 908 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene *, struct wlr_presentation *)
/* 909 */ _CFFI_OP(_CFFI_OP_NOOP, 345),
/* 910 */ _CFFI_OP(_CFFI_OP_POINTER, 1527), // struct wlr_presentation *
/* 911 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 912 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, enum wl_output_transform)
/* 913 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 914 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 915 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 916 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, float)
/* 917 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 918 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 919 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 920 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, int, int)
/* 921 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 922 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 923 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 924 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 925 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, int, int, void *)
/* 926 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 927 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 928 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 929 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 930 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 931 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, struct pixman_region32 *)
/* 932 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 933 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 934 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 935 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, struct timespec *)
/* 936 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 937 */ _CFFI_OP(_CFFI_OP_NOOP, 147),
/* 938 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 939 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, struct wlr_buffer *)
/* 940 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 941 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 942 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 943 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, struct wlr_buffer *, struct pixman_region32 *)
/* 944 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 945 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 946 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 947 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 948 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_buffer *, struct wlr_fbox const *)
/* 949 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 950 */ _CFFI_OP(_CFFI_OP_POINTER, 1449), // struct wlr_fbox const *
/* 951 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 952 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_layer_surface_v1 *, struct wlr_box const *, struct wlr_box *)
/* 953 */ _CFFI_OP(_CFFI_OP_POINTER, 1536), // struct wlr_scene_layer_surface_v1 *
/* 954 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 955 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 956 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 957 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *)
/* 958 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 959 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 960 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *, _Bool)
/* 961 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 962 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 963 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 964 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *, int, int)
/* 965 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 966 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 967 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 968 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 969 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *, struct wlr_box *)
/* 970 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 971 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 972 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 973 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *, struct wlr_scene_node *)
/* 974 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 975 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 976 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 977 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *, struct wlr_scene_tree *)
/* 978 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 979 */ _CFFI_OP(_CFFI_OP_NOOP, 330),
/* 980 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 981 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_node *, void(*)(struct wlr_scene_buffer *, int, int, void *), void *)
/* 982 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 983 */ _CFFI_OP(_CFFI_OP_POINTER, 925), // void(*)(struct wlr_scene_buffer *, int, int, void *)
/* 984 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 985 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 986 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_output *)
/* 987 */ _CFFI_OP(_CFFI_OP_NOOP, 85),
/* 988 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 989 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_output *, int, int)
/* 990 */ _CFFI_OP(_CFFI_OP_NOOP, 85),
/* 991 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 992 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 993 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 994 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_output *, struct timespec *)
/* 995 */ _CFFI_OP(_CFFI_OP_NOOP, 85),
/* 996 */ _CFFI_OP(_CFFI_OP_NOOP, 147),
/* 997 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 998 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_output *, void(*)(struct wlr_scene_buffer *, int, int, void *), void *)
/* 999 */ _CFFI_OP(_CFFI_OP_NOOP, 85),
/* 1000 */ _CFFI_OP(_CFFI_OP_NOOP, 983),
/* 1001 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 1002 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1003 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_output_layout *, struct wlr_output_layout_output *, struct wlr_scene_output *)
/* 1004 */ _CFFI_OP(_CFFI_OP_POINTER, 1539), // struct wlr_scene_output_layout *
/* 1005 */ _CFFI_OP(_CFFI_OP_POINTER, 1495), // struct wlr_output_layout_output *
/* 1006 */ _CFFI_OP(_CFFI_OP_NOOP, 85),
/* 1007 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1008 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_rect *, float const *)
/* 1009 */ _CFFI_OP(_CFFI_OP_POINTER, 1541), // struct wlr_scene_rect *
/* 1010 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 1011 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1012 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_scene_rect *, int, int)
/* 1013 */ _CFFI_OP(_CFFI_OP_NOOP, 1009),
/* 1014 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1015 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1016 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1017 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *)
/* 1018 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1019 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1020 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, char const *)
/* 1021 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1022 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 1023 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1024 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_data_source *, uint32_t)
/* 1025 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1026 */ _CFFI_OP(_CFFI_OP_NOOP, 689),
/* 1027 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1028 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1029 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_drag *, uint32_t)
/* 1030 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1031 */ _CFFI_OP(_CFFI_OP_POINTER, 1440), // struct wlr_drag *
/* 1032 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1033 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1034 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_keyboard *)
/* 1035 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1036 */ _CFFI_OP(_CFFI_OP_NOOP, 509),
/* 1037 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1038 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_keyboard_modifiers *)
/* 1039 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1040 */ _CFFI_OP(_CFFI_OP_POINTER, 1476), // struct wlr_keyboard_modifiers *
/* 1041 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1042 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_primary_selection_source *, uint32_t)
/* 1043 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1044 */ _CFFI_OP(_CFFI_OP_POINTER, 1528), // struct wlr_primary_selection_source *
/* 1045 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1046 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1047 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_seat_keyboard_grab *)
/* 1048 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1049 */ _CFFI_OP(_CFFI_OP_POINTER, 1553), // struct wlr_seat_keyboard_grab *
/* 1050 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1051 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_seat_pointer_grab *)
/* 1052 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1053 */ _CFFI_OP(_CFFI_OP_POINTER, 1556), // struct wlr_seat_pointer_grab *
/* 1054 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1055 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_seat_touch_grab *)
/* 1056 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1057 */ _CFFI_OP(_CFFI_OP_POINTER, 1562), // struct wlr_seat_touch_grab *
/* 1058 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1059 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_surface *)
/* 1060 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1061 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1062 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1063 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_surface *, double, double)
/* 1064 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1065 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1066 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1067 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1068 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1069 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_surface *, uint32_t *, size_t, struct wlr_keyboard_modifiers *)
/* 1070 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1071 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1072 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 1073 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 1074 */ _CFFI_OP(_CFFI_OP_NOOP, 1040),
/* 1075 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1076 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, struct wlr_surface *, uint32_t, int32_t, double, double)
/* 1077 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1078 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1079 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1080 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1081 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1082 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1083 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1084 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, uint32_t)
/* 1085 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1086 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1087 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1088 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, uint32_t, double, double)
/* 1089 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1090 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1091 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1092 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1093 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1094 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, uint32_t, enum wlr_axis_orientation, double, int32_t, enum wlr_axis_source)
/* 1095 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1096 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1097 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // enum wlr_axis_orientation
/* 1098 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1099 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1100 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // enum wlr_axis_source
/* 1101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, uint32_t, int32_t)
/* 1103 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, uint32_t, int32_t, double, double)
/* 1108 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1110 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1111 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_seat *, uint32_t, uint32_t, uint32_t)
/* 1115 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1117 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1118 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_server_decoration_manager *, uint32_t)
/* 1121 */ _CFFI_OP(_CFFI_OP_POINTER, 1564), // struct wlr_server_decoration_manager *
/* 1122 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1123 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1124 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_session_lock_v1 *)
/* 1125 */ _CFFI_OP(_CFFI_OP_POINTER, 1571), // struct wlr_session_lock_v1 *
/* 1126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *)
/* 1128 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, double)
/* 1131 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1132 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 1133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, int, int, void *)
/* 1135 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1136 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1137 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1138 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 1139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, struct pixman_region32 *)
/* 1141 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1142 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 1143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, struct timespec const *)
/* 1145 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1146 */ _CFFI_OP(_CFFI_OP_POINTER, 1394), // struct timespec const *
/* 1147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, struct wlr_box *)
/* 1149 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1150 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 1151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, struct wlr_fbox *)
/* 1153 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1154 */ _CFFI_OP(_CFFI_OP_POINTER, 1449), // struct wlr_fbox *
/* 1155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, struct wlr_output *)
/* 1157 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1158 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 1159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, uint32_t)
/* 1161 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1162 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_surface *, void(*)(struct wlr_surface *, int, int, void *), void *)
/* 1165 */ _CFFI_OP(_CFFI_OP_NOOP, 93),
/* 1166 */ _CFFI_OP(_CFFI_OP_NOOP, 744),
/* 1167 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 1168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_texture *)
/* 1170 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xcursor_manager *)
/* 1173 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 1174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xdg_popup *)
/* 1176 */ _CFFI_OP(_CFFI_OP_POINTER, 1628), // struct wlr_xdg_popup *
/* 1177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1178 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xdg_popup *, struct wlr_box const *)
/* 1179 */ _CFFI_OP(_CFFI_OP_NOOP, 1176),
/* 1180 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 1181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xdg_surface *)
/* 1183 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 1184 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1185 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xdg_surface *, struct wlr_box *)
/* 1186 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 1187 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 1188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xdg_surface *, void(*)(struct wlr_surface *, int, int, void *), void *)
/* 1190 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 1191 */ _CFFI_OP(_CFFI_OP_NOOP, 744),
/* 1192 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 1193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xdg_toplevel *)
/* 1195 */ _CFFI_OP(_CFFI_OP_NOOP, 537),
/* 1196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland *)
/* 1198 */ _CFFI_OP(_CFFI_OP_POINTER, 1649), // struct wlr_xwayland *
/* 1199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland *, struct wlr_seat *)
/* 1201 */ _CFFI_OP(_CFFI_OP_NOOP, 1198),
/* 1202 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 1203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland *, uint8_t *, uint32_t, uint32_t, uint32_t, int32_t, int32_t)
/* 1205 */ _CFFI_OP(_CFFI_OP_NOOP, 1198),
/* 1206 */ _CFFI_OP(_CFFI_OP_POINTER, 1252), // uint8_t *
/* 1207 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1208 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1209 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1210 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1211 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 1212 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1213 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland_server *)
/* 1214 */ _CFFI_OP(_CFFI_OP_POINTER, 1655), // struct wlr_xwayland_server *
/* 1215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland_surface *)
/* 1217 */ _CFFI_OP(_CFFI_OP_POINTER, 1657), // struct wlr_xwayland_surface *
/* 1218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland_surface *, _Bool)
/* 1220 */ _CFFI_OP(_CFFI_OP_NOOP, 1217),
/* 1221 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 1222 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1223 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland_surface *, int16_t, int16_t, uint16_t, uint16_t)
/* 1224 */ _CFFI_OP(_CFFI_OP_NOOP, 1217),
/* 1225 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19), // int16_t
/* 1226 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19),
/* 1227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 1228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct wlr_xwayland_surface *, struct wlr_xwayland_surface *, enum xcb_stack_mode_t)
/* 1231 */ _CFFI_OP(_CFFI_OP_NOOP, 1217),
/* 1232 */ _CFFI_OP(_CFFI_OP_NOOP, 1217),
/* 1233 */ _CFFI_OP(_CFFI_OP_ENUM, 28), // enum xcb_stack_mode_t
/* 1234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(struct xkb_keymap *, uint32_t, void *)
/* 1236 */ _CFFI_OP(_CFFI_OP_NOOP, 725),
/* 1237 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 1238 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 1239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(void *)
/* 1241 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 1242 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1243 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1685), // void()(xcb_connection_t *)
/* 1244 */ _CFFI_OP(_CFFI_OP_NOOP, 171),
/* 1245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 171), // xcb_connection_t *()(char const *, int *)
/* 1247 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 1248 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 1249 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1250 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1258), // xcb_intern_atom_cookie_t()(xcb_connection_t *, uint8_t, uint16_t, char const *)
/* 1251 */ _CFFI_OP(_CFFI_OP_NOOP, 171),
/* 1252 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 1253 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 1254 */ _CFFI_OP(_CFFI_OP_NOOP, 385),
/* 1255 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1256 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1694), // xcb_intern_atom_reply_t *()(xcb_connection_t *, xcb_intern_atom_cookie_t, xcb_generic_error_t * *)
/* 1257 */ _CFFI_OP(_CFFI_OP_NOOP, 171),
/* 1258 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 282), // xcb_intern_atom_cookie_t
/* 1259 */ _CFFI_OP(_CFFI_OP_POINTER, 1689), // xcb_generic_error_t * *
/* 1260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 66), // FILE
/* 1262 */ _CFFI_OP(_CFFI_OP_POINTER, 74), // _Bool(*)(struct wlr_scene_buffer *, double *, double *)
/* 1263 */ _CFFI_OP(_CFFI_OP_ARRAY, 495), // _Bool[2]
/* 1264 */ (_cffi_opcode_t)(2),
/* 1265 */ _CFFI_OP(_CFFI_OP_POINTER, 1266), // char *
/* 1266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 1267 */ _CFFI_OP(_CFFI_OP_ARRAY, 1266), // char[16]
/* 1268 */ (_cffi_opcode_t)(16),
/* 1269 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum wl_data_device_manager_dnd_action
/* 1270 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum wl_keyboard_key_state
/* 1271 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum wl_pointer_axis
/* 1272 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // enum wlr_buffer_data_ptr_access_flag
/* 1273 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // enum wlr_drag_grab_type
/* 1274 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // enum wlr_edges
/* 1275 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // enum wlr_input_device_type
/* 1276 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // enum wlr_keyboard_led
/* 1277 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // enum wlr_keyboard_modifier
/* 1278 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // enum wlr_output_adaptive_sync_status
/* 1279 */ _CFFI_OP(_CFFI_OP_ENUM, 16), // enum wlr_pointer_constraint_v1_state_field
/* 1280 */ _CFFI_OP(_CFFI_OP_ENUM, 17), // enum wlr_pointer_constraint_v1_type
/* 1281 */ _CFFI_OP(_CFFI_OP_ENUM, 18), // enum wlr_scene_node_type
/* 1282 */ _CFFI_OP(_CFFI_OP_ENUM, 19), // enum wlr_server_decoration_manager_mode
/* 1283 */ _CFFI_OP(_CFFI_OP_ENUM, 20), // enum wlr_switch_state
/* 1284 */ _CFFI_OP(_CFFI_OP_ENUM, 21), // enum wlr_switch_type
/* 1285 */ _CFFI_OP(_CFFI_OP_ENUM, 22), // enum wlr_xdg_popup_configure_field
/* 1286 */ _CFFI_OP(_CFFI_OP_ENUM, 23), // enum wlr_xdg_surface_role
/* 1287 */ _CFFI_OP(_CFFI_OP_ENUM, 25), // enum wlr_xdg_toplevel_wm_capabilities
/* 1288 */ _CFFI_OP(_CFFI_OP_ENUM, 26), // enum wlr_xwayland_icccm_input_model
/* 1289 */ _CFFI_OP(_CFFI_OP_ENUM, 27), // enum wlr_xwayland_surface_decorations
/* 1290 */ _CFFI_OP(_CFFI_OP_ENUM, 29), // enum xdg_positioner_anchor
/* 1291 */ _CFFI_OP(_CFFI_OP_ENUM, 30), // enum xdg_positioner_constraint_adjustment
/* 1292 */ _CFFI_OP(_CFFI_OP_ENUM, 31), // enum xdg_positioner_gravity
/* 1293 */ _CFFI_OP(_CFFI_OP_ENUM, 32), // enum xkb_compose_compile_flags
/* 1294 */ _CFFI_OP(_CFFI_OP_ENUM, 33), // enum xkb_compose_feed_result
/* 1295 */ _CFFI_OP(_CFFI_OP_ENUM, 34), // enum xkb_compose_format
/* 1296 */ _CFFI_OP(_CFFI_OP_ENUM, 35), // enum xkb_compose_state_flags
/* 1297 */ _CFFI_OP(_CFFI_OP_ENUM, 36), // enum xkb_compose_status
/* 1298 */ _CFFI_OP(_CFFI_OP_ENUM, 37), // enum xkb_consumed_mode
/* 1299 */ _CFFI_OP(_CFFI_OP_ENUM, 38), // enum xkb_context_flags
/* 1300 */ _CFFI_OP(_CFFI_OP_ENUM, 39), // enum xkb_key_direction
/* 1301 */ _CFFI_OP(_CFFI_OP_ENUM, 40), // enum xkb_keymap_compile_flags
/* 1302 */ _CFFI_OP(_CFFI_OP_ENUM, 41), // enum xkb_keymap_format
/* 1303 */ _CFFI_OP(_CFFI_OP_ENUM, 42), // enum xkb_keysym_flags
/* 1304 */ _CFFI_OP(_CFFI_OP_ENUM, 43), // enum xkb_log_level
/* 1305 */ _CFFI_OP(_CFFI_OP_ENUM, 44), // enum xkb_state_component
/* 1306 */ _CFFI_OP(_CFFI_OP_ENUM, 45), // enum xkb_state_match
/* 1307 */ _CFFI_OP(_CFFI_OP_ENUM, 46), // enum zwlr_layer_shell_v1_layer
/* 1308 */ _CFFI_OP(_CFFI_OP_ENUM, 47), // enum zwlr_layer_surface_v1_keyboard_interactivity
/* 1309 */ _CFFI_OP(_CFFI_OP_ENUM, 48), // enum zwlr_output_power_v1_mode
/* 1310 */ _CFFI_OP(_CFFI_OP_ENUM, 49), // enum zwp_pointer_constraints_v1_lifetime
/* 1311 */ _CFFI_OP(_CFFI_OP_ARRAY, 64), // float[4]
/* 1312 */ (_cffi_opcode_t)(4),
/* 1313 */ _CFFI_OP(_CFFI_OP_ARRAY, 64), // float[9]
/* 1314 */ (_cffi_opcode_t)(9),
/* 1315 */ _CFFI_OP(_CFFI_OP_POINTER, 136), // int(*)(int, uint32_t, void *)
/* 1316 */ _CFFI_OP(_CFFI_OP_POINTER, 141), // int(*)(int, void *)
/* 1317 */ _CFFI_OP(_CFFI_OP_POINTER, 156), // int(*)(struct wlr_xwm *, xcb_generic_event_t *)
/* 1318 */ _CFFI_OP(_CFFI_OP_POINTER, 160), // int(*)(void *)
/* 1319 */ _CFFI_OP(_CFFI_OP_POINTER, 163), // int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 1320 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 1321 */ _CFFI_OP(_CFFI_OP_ARRAY, 53), // int[2]
/* 1322 */ (_cffi_opcode_t)(2),
/* 1323 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct $10
/* 1324 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct $11
/* 1325 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct $12
/* 1326 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct $13
/* 1327 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct $14
/* 1328 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct $15
/* 1329 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct $16
/* 1330 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct $17
/* 1331 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct $18
/* 1332 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct $19
/* 1333 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct $1
/* 1334 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct $20
/* 1335 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct $21
/* 1336 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct $22
/* 1337 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct $23
/* 1338 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct $24
/* 1339 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct $25
/* 1340 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct $26
/* 1341 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct $27
/* 1342 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // struct $28
/* 1343 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // struct $29
/* 1344 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct $2
/* 1345 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // struct $30
/* 1346 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct $31
/* 1347 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // struct $32
/* 1348 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct $33
/* 1349 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // struct $34
/* 1350 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // struct $35
/* 1351 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // struct $36
/* 1352 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // struct $37
/* 1353 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // struct $38
/* 1354 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // struct $39
/* 1355 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct $3
/* 1356 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // struct $40
/* 1357 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // struct $41
/* 1358 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // struct $42
/* 1359 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // struct $43
/* 1360 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // struct $44
/* 1361 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // struct $45
/* 1362 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // struct $46
/* 1363 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // struct $47
/* 1364 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // struct $48
/* 1365 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // struct $49
/* 1366 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // struct $4
/* 1367 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // struct $50
/* 1368 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // struct $51
/* 1369 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // struct $52
/* 1370 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 48), // struct $53
/* 1371 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 49), // struct $54
/* 1372 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 50), // struct $55
/* 1373 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 51), // struct $56
/* 1374 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 52), // struct $57
/* 1375 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 53), // struct $58
/* 1376 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 54), // struct $59
/* 1377 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // struct $5
/* 1378 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 56), // struct $61
/* 1379 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 57), // struct $62
/* 1380 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 58), // struct $63
/* 1381 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 59), // struct $64
/* 1382 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 60), // struct $65
/* 1383 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 61), // struct $66
/* 1384 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 62), // struct $67
/* 1385 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 55), // struct $6
/* 1386 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 63), // struct $7
/* 1387 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 64), // struct $8
/* 1388 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 65), // struct $9
/* 1389 */ _CFFI_OP(_CFFI_OP_POINTER, 1390), // struct libinput_device *
/* 1390 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 74), // struct libinput_device
/* 1391 */ _CFFI_OP(_CFFI_OP_POINTER, 1392), // struct pixman_box32 *
/* 1392 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 75), // struct pixman_box32
/* 1393 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 76), // struct pixman_region32
/* 1394 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 77), // struct timespec
/* 1395 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 79), // struct wl_array
/* 1396 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 80), // struct wl_client
/* 1397 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 81), // struct wl_display
/* 1398 */ _CFFI_OP(_CFFI_OP_POINTER, 1399), // struct wl_event_loop *
/* 1399 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 82), // struct wl_event_loop
/* 1400 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 83), // struct wl_event_queue
/* 1401 */ _CFFI_OP(_CFFI_OP_POINTER, 1404), // struct wl_event_source *
/* 1402 */ _CFFI_OP(_CFFI_OP_ARRAY, 1401), // struct wl_event_source *[2]
/* 1403 */ (_cffi_opcode_t)(2),
/* 1404 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 84), // struct wl_event_source
/* 1405 */ _CFFI_OP(_CFFI_OP_POINTER, 1406), // struct wl_global *
/* 1406 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 85), // struct wl_global
/* 1407 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 86), // struct wl_interface
/* 1408 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 87), // struct wl_list
/* 1409 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 88), // struct wl_listener
/* 1410 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 89), // struct wl_listener_container
/* 1411 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 90), // struct wl_message
/* 1412 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 91), // struct wl_object
/* 1413 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 92), // struct wl_proxy
/* 1414 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 93), // struct wl_resource
/* 1415 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 94), // struct wl_signal
/* 1416 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 95), // struct wlr_addon
/* 1417 */ _CFFI_OP(_CFFI_OP_POINTER, 1418), // struct wlr_addon_interface const *
/* 1418 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 96), // struct wlr_addon_interface
/* 1419 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 97), // struct wlr_addon_set
/* 1420 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 98), // struct wlr_allocator
/* 1421 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 99), // struct wlr_backend
/* 1422 */ _CFFI_OP(_CFFI_OP_POINTER, 1423), // struct wlr_backend_impl const *
/* 1423 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 100), // struct wlr_backend_impl
/* 1424 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 101), // struct wlr_box
/* 1425 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 102), // struct wlr_buffer
/* 1426 */ _CFFI_OP(_CFFI_OP_POINTER, 1427), // struct wlr_client_buffer *
/* 1427 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 103), // struct wlr_client_buffer
/* 1428 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 104), // struct wlr_compositor
/* 1429 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 105), // struct wlr_cursor
/* 1430 */ _CFFI_OP(_CFFI_OP_POINTER, 1431), // struct wlr_cursor_state *
/* 1431 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 106), // struct wlr_cursor_state
/* 1432 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 107), // struct wlr_damage_ring
/* 1433 */ _CFFI_OP(_CFFI_OP_POINTER, 1434), // struct wlr_data_control_manager_v1 *
/* 1434 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 108), // struct wlr_data_control_manager_v1
/* 1435 */ _CFFI_OP(_CFFI_OP_POINTER, 1436), // struct wlr_data_device_manager *
/* 1436 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 109), // struct wlr_data_device_manager
/* 1437 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 110), // struct wlr_data_source
/* 1438 */ _CFFI_OP(_CFFI_OP_POINTER, 1439), // struct wlr_data_source_impl const *
/* 1439 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 111), // struct wlr_data_source_impl
/* 1440 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 112), // struct wlr_drag
/* 1441 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 113), // struct wlr_drag_drop_event
/* 1442 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 114), // struct wlr_drag_icon
/* 1443 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 115), // struct wlr_drag_motion_event
/* 1444 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 116), // struct wlr_drm_format
/* 1445 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 117), // struct wlr_drm_format_set
/* 1446 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 118), // struct wlr_export_dmabuf_frame_v1
/* 1447 */ _CFFI_OP(_CFFI_OP_POINTER, 1448), // struct wlr_export_dmabuf_manager_v1 *
/* 1448 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 119), // struct wlr_export_dmabuf_manager_v1
/* 1449 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 120), // struct wlr_fbox
/* 1450 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 121), // struct wlr_foreign_toplevel_handle_v1
/* 1451 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 122), // struct wlr_foreign_toplevel_handle_v1_activated_event
/* 1452 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 123), // struct wlr_foreign_toplevel_handle_v1_fullscreen_event
/* 1453 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 124), // struct wlr_foreign_toplevel_handle_v1_maximized_event
/* 1454 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 125), // struct wlr_foreign_toplevel_handle_v1_minimized_event
/* 1455 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 126), // struct wlr_foreign_toplevel_handle_v1_set_rectangle_event
/* 1456 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 127), // struct wlr_foreign_toplevel_manager_v1
/* 1457 */ _CFFI_OP(_CFFI_OP_POINTER, 1458), // struct wlr_fractional_scale_manager_v1 *
/* 1458 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 128), // struct wlr_fractional_scale_manager_v1
/* 1459 */ _CFFI_OP(_CFFI_OP_POINTER, 1460), // struct wlr_gamma_control_manager_v1 *
/* 1460 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 129), // struct wlr_gamma_control_manager_v1
/* 1461 */ _CFFI_OP(_CFFI_OP_POINTER, 1462), // struct wlr_idle_inhibit_manager_v1 *
/* 1462 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 130), // struct wlr_idle_inhibit_manager_v1
/* 1463 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 131), // struct wlr_idle_inhibitor_v1
/* 1464 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 132), // struct wlr_idle_notifier_v1
/* 1465 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 133), // struct wlr_input_device
/* 1466 */ _CFFI_OP(_CFFI_OP_POINTER, 1467), // struct wlr_input_inhibit_manager *
/* 1467 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 134), // struct wlr_input_inhibit_manager
/* 1468 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 135), // struct wlr_keyboard
/* 1469 */ _CFFI_OP(_CFFI_OP_POINTER, 1470), // struct wlr_keyboard_grab_interface const *
/* 1470 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 136), // struct wlr_keyboard_grab_interface
/* 1471 */ _CFFI_OP(_CFFI_OP_POINTER, 1472), // struct wlr_keyboard_group *
/* 1472 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 137), // struct wlr_keyboard_group
/* 1473 */ _CFFI_OP(_CFFI_OP_POINTER, 1474), // struct wlr_keyboard_impl const *
/* 1474 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 138), // struct wlr_keyboard_impl
/* 1475 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 139), // struct wlr_keyboard_key_event
/* 1476 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 140), // struct wlr_keyboard_modifiers
/* 1477 */ _CFFI_OP(_CFFI_OP_POINTER, 1478), // struct wlr_layer_shell_v1 *
/* 1478 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 141), // struct wlr_layer_shell_v1
/* 1479 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 142), // struct wlr_layer_surface_v1
/* 1480 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 143), // struct wlr_layer_surface_v1_state
/* 1481 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 144), // struct wlr_linux_dmabuf_feedback_v1
/* 1482 */ _CFFI_OP(_CFFI_OP_POINTER, 1483), // struct wlr_linux_dmabuf_v1 *
/* 1483 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 145), // struct wlr_linux_dmabuf_v1
/* 1484 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 146), // struct wlr_output
/* 1485 */ _CFFI_OP(_CFFI_OP_POINTER, 1486), // struct wlr_output_configuration_head_v1 *
/* 1486 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 147), // struct wlr_output_configuration_head_v1
/* 1487 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 148), // struct wlr_output_configuration_v1
/* 1488 */ _CFFI_OP(_CFFI_OP_POINTER, 1489), // struct wlr_output_cursor *
/* 1489 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 149), // struct wlr_output_cursor
/* 1490 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 150), // struct wlr_output_event_request_state
/* 1491 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 151), // struct wlr_output_head_v1_state
/* 1492 */ _CFFI_OP(_CFFI_OP_POINTER, 1493), // struct wlr_output_impl const *
/* 1493 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 152), // struct wlr_output_impl
/* 1494 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 153), // struct wlr_output_layout
/* 1495 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 154), // struct wlr_output_layout_output
/* 1496 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 155), // struct wlr_output_manager_v1
/* 1497 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 156), // struct wlr_output_mode
/* 1498 */ _CFFI_OP(_CFFI_OP_POINTER, 1499), // struct wlr_output_power_manager_v1 *
/* 1499 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 157), // struct wlr_output_power_manager_v1
/* 1500 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 158), // struct wlr_output_power_v1
/* 1501 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 159), // struct wlr_output_power_v1_set_mode_event
/* 1502 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 160), // struct wlr_output_state
/* 1503 */ _CFFI_OP(_CFFI_OP_POINTER, 1504), // struct wlr_pointer *
/* 1504 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 161), // struct wlr_pointer
/* 1505 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 162), // struct wlr_pointer_axis_event
/* 1506 */ _CFFI_OP(_CFFI_OP_ARRAY, 1505), // struct wlr_pointer_axis_event[2]
/* 1507 */ (_cffi_opcode_t)(2),
/* 1508 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 163), // struct wlr_pointer_button_event
/* 1509 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 164), // struct wlr_pointer_constraint_v1
/* 1510 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 165), // struct wlr_pointer_constraint_v1_state
/* 1511 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 166), // struct wlr_pointer_constraints_v1
/* 1512 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 167), // struct wlr_pointer_gestures_v1
/* 1513 */ _CFFI_OP(_CFFI_OP_POINTER, 1514), // struct wlr_pointer_grab_interface const *
/* 1514 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 168), // struct wlr_pointer_grab_interface
/* 1515 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 169), // struct wlr_pointer_hold_begin_event
/* 1516 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 170), // struct wlr_pointer_hold_end_event
/* 1517 */ _CFFI_OP(_CFFI_OP_POINTER, 1518), // struct wlr_pointer_impl const *
/* 1518 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 171), // struct wlr_pointer_impl
/* 1519 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 172), // struct wlr_pointer_motion_absolute_event
/* 1520 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 173), // struct wlr_pointer_motion_event
/* 1521 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 174), // struct wlr_pointer_pinch_begin_event
/* 1522 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 175), // struct wlr_pointer_pinch_end_event
/* 1523 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 176), // struct wlr_pointer_pinch_update_event
/* 1524 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 177), // struct wlr_pointer_swipe_begin_event
/* 1525 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 178), // struct wlr_pointer_swipe_end_event
/* 1526 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 179), // struct wlr_pointer_swipe_update_event
/* 1527 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 180), // struct wlr_presentation
/* 1528 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 181), // struct wlr_primary_selection_source
/* 1529 */ _CFFI_OP(_CFFI_OP_POINTER, 1530), // struct wlr_primary_selection_v1_device_manager *
/* 1530 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 182), // struct wlr_primary_selection_v1_device_manager
/* 1531 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 183), // struct wlr_relative_pointer_manager_v1
/* 1532 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 184), // struct wlr_relative_pointer_v1
/* 1533 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 185), // struct wlr_renderer
/* 1534 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 186), // struct wlr_scene
/* 1535 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 187), // struct wlr_scene_buffer
/* 1536 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 188), // struct wlr_scene_layer_surface_v1
/* 1537 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 189), // struct wlr_scene_node
/* 1538 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 190), // struct wlr_scene_output
/* 1539 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 191), // struct wlr_scene_output_layout
/* 1540 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 192), // struct wlr_scene_output_state_options
/* 1541 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 193), // struct wlr_scene_rect
/* 1542 */ _CFFI_OP(_CFFI_OP_POINTER, 1543), // struct wlr_scene_surface *
/* 1543 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 194), // struct wlr_scene_surface
/* 1544 */ _CFFI_OP(_CFFI_OP_POINTER, 1545), // struct wlr_scene_timer *
/* 1545 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 195), // struct wlr_scene_timer
/* 1546 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 196), // struct wlr_scene_tree
/* 1547 */ _CFFI_OP(_CFFI_OP_POINTER, 1548), // struct wlr_screencopy_manager_v1 *
/* 1548 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 197), // struct wlr_screencopy_manager_v1
/* 1549 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 198), // struct wlr_seat
/* 1550 */ _CFFI_OP(_CFFI_OP_POINTER, 1551), // struct wlr_seat_client *
/* 1551 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 199), // struct wlr_seat_client
/* 1552 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 200), // struct wlr_seat_keyboard_focus_change_event
/* 1553 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 201), // struct wlr_seat_keyboard_grab
/* 1554 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 202), // struct wlr_seat_keyboard_state
/* 1555 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 203), // struct wlr_seat_pointer_focus_change_event
/* 1556 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 204), // struct wlr_seat_pointer_grab
/* 1557 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 205), // struct wlr_seat_pointer_request_set_cursor_event
/* 1558 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 206), // struct wlr_seat_pointer_state
/* 1559 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 207), // struct wlr_seat_request_set_primary_selection_event
/* 1560 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 208), // struct wlr_seat_request_set_selection_event
/* 1561 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 209), // struct wlr_seat_request_start_drag_event
/* 1562 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 210), // struct wlr_seat_touch_grab
/* 1563 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 211), // struct wlr_seat_touch_state
/* 1564 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 212), // struct wlr_server_decoration_manager
/* 1565 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 213), // struct wlr_session
/* 1566 */ _CFFI_OP(_CFFI_OP_POINTER, 1567), // struct wlr_session_lock_manager_v1 *
/* 1567 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 214), // struct wlr_session_lock_manager_v1
/* 1568 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 215), // struct wlr_session_lock_surface_v1
/* 1569 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 216), // struct wlr_session_lock_surface_v1_configure
/* 1570 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 217), // struct wlr_session_lock_surface_v1_state
/* 1571 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 218), // struct wlr_session_lock_v1
/* 1572 */ _CFFI_OP(_CFFI_OP_POINTER, 1573), // struct wlr_single_pixel_buffer_manager_v1 *
/* 1573 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 219), // struct wlr_single_pixel_buffer_manager_v1
/* 1574 */ _CFFI_OP(_CFFI_OP_POINTER, 1575), // struct wlr_subcompositor *
/* 1575 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 220), // struct wlr_subcompositor
/* 1576 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 221), // struct wlr_subsurface
/* 1577 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 222), // struct wlr_subsurface_parent_state
/* 1578 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 223), // struct wlr_surface
/* 1579 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 224), // struct wlr_surface_output
/* 1580 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 225), // struct wlr_surface_role
/* 1581 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 226), // struct wlr_surface_state
/* 1582 */ _CFFI_OP(_CFFI_OP_POINTER, 1583), // struct wlr_swapchain *
/* 1583 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 227), // struct wlr_swapchain
/* 1584 */ _CFFI_OP(_CFFI_OP_POINTER, 1585), // struct wlr_switch *
/* 1585 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 228), // struct wlr_switch
/* 1586 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 229), // struct wlr_switch_toggle_event
/* 1587 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 230), // struct wlr_texture
/* 1588 */ _CFFI_OP(_CFFI_OP_POINTER, 1589), // struct wlr_touch *
/* 1589 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 231), // struct wlr_touch
/* 1590 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 232), // struct wlr_touch_cancel_event
/* 1591 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 233), // struct wlr_touch_down_event
/* 1592 */ _CFFI_OP(_CFFI_OP_POINTER, 1593), // struct wlr_touch_grab_interface const *
/* 1593 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 234), // struct wlr_touch_grab_interface
/* 1594 */ _CFFI_OP(_CFFI_OP_POINTER, 1595), // struct wlr_touch_impl const *
/* 1595 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 235), // struct wlr_touch_impl
/* 1596 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 236), // struct wlr_touch_motion_event
/* 1597 */ _CFFI_OP(_CFFI_OP_POINTER, 1598), // struct wlr_touch_point *
/* 1598 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 237), // struct wlr_touch_point
/* 1599 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 238), // struct wlr_touch_up_event
/* 1600 */ _CFFI_OP(_CFFI_OP_POINTER, 1601), // struct wlr_viewporter *
/* 1601 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 239), // struct wlr_viewporter
/* 1602 */ _CFFI_OP(_CFFI_OP_POINTER, 1603), // struct wlr_virtual_keyboard_manager_v1 *
/* 1603 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 240), // struct wlr_virtual_keyboard_manager_v1
/* 1604 */ _CFFI_OP(_CFFI_OP_POINTER, 1605), // struct wlr_virtual_keyboard_v1 *
/* 1605 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 241), // struct wlr_virtual_keyboard_v1
/* 1606 */ _CFFI_OP(_CFFI_OP_POINTER, 1607), // struct wlr_virtual_pointer_manager_v1 *
/* 1607 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 242), // struct wlr_virtual_pointer_manager_v1
/* 1608 */ _CFFI_OP(_CFFI_OP_POINTER, 1609), // struct wlr_virtual_pointer_v1 *
/* 1609 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 243), // struct wlr_virtual_pointer_v1
/* 1610 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 244), // struct wlr_virtual_pointer_v1_new_pointer_event
/* 1611 */ _CFFI_OP(_CFFI_OP_POINTER, 1612), // struct wlr_xcursor *
/* 1612 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 245), // struct wlr_xcursor
/* 1613 */ _CFFI_OP(_CFFI_OP_POINTER, 1614), // struct wlr_xcursor_image * *
/* 1614 */ _CFFI_OP(_CFFI_OP_POINTER, 1615), // struct wlr_xcursor_image *
/* 1615 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 246), // struct wlr_xcursor_image
/* 1616 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 247), // struct wlr_xcursor_manager
/* 1617 */ _CFFI_OP(_CFFI_OP_POINTER, 1618), // struct wlr_xdg_activation_token_v1 *
/* 1618 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 248), // struct wlr_xdg_activation_token_v1
/* 1619 */ _CFFI_OP(_CFFI_OP_POINTER, 1620), // struct wlr_xdg_activation_v1 *
/* 1620 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 249), // struct wlr_xdg_activation_v1
/* 1621 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 250), // struct wlr_xdg_activation_v1_request_activate_event
/* 1622 */ _CFFI_OP(_CFFI_OP_POINTER, 1623), // struct wlr_xdg_client *
/* 1623 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 251), // struct wlr_xdg_client
/* 1624 */ _CFFI_OP(_CFFI_OP_POINTER, 1625), // struct wlr_xdg_decoration_manager_v1 *
/* 1625 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 252), // struct wlr_xdg_decoration_manager_v1
/* 1626 */ _CFFI_OP(_CFFI_OP_POINTER, 1627), // struct wlr_xdg_output_manager_v1 *
/* 1627 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 253), // struct wlr_xdg_output_manager_v1
/* 1628 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 254), // struct wlr_xdg_popup
/* 1629 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 255), // struct wlr_xdg_popup_configure
/* 1630 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 256), // struct wlr_xdg_popup_state
/* 1631 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 257), // struct wlr_xdg_positioner_rules
/* 1632 */ _CFFI_OP(_CFFI_OP_POINTER, 1633), // struct wlr_xdg_shell *
/* 1633 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 258), // struct wlr_xdg_shell
/* 1634 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 259), // struct wlr_xdg_surface
/* 1635 */ _CFFI_OP(_CFFI_OP_POINTER, 1636), // struct wlr_xdg_surface_configure *
/* 1636 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 260), // struct wlr_xdg_surface_configure
/* 1637 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 261), // struct wlr_xdg_surface_state
/* 1638 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 262), // struct wlr_xdg_toplevel
/* 1639 */ _CFFI_OP(_CFFI_OP_POINTER, 1640), // struct wlr_xdg_toplevel_configure *
/* 1640 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 263), // struct wlr_xdg_toplevel_configure
/* 1641 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 264), // struct wlr_xdg_toplevel_decoration_v1
/* 1642 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 265), // struct wlr_xdg_toplevel_decoration_v1_configure
/* 1643 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 266), // struct wlr_xdg_toplevel_decoration_v1_state
/* 1644 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 267), // struct wlr_xdg_toplevel_move_event
/* 1645 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 268), // struct wlr_xdg_toplevel_requested
/* 1646 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 269), // struct wlr_xdg_toplevel_resize_event
/* 1647 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 270), // struct wlr_xdg_toplevel_show_window_menu_event
/* 1648 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 271), // struct wlr_xdg_toplevel_state
/* 1649 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 272), // struct wlr_xwayland
/* 1650 */ _CFFI_OP(_CFFI_OP_POINTER, 1651), // struct wlr_xwayland_cursor *
/* 1651 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 273), // struct wlr_xwayland_cursor
/* 1652 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 274), // struct wlr_xwayland_minimize_event
/* 1653 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 275), // struct wlr_xwayland_remove_startup_info_event
/* 1654 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 276), // struct wlr_xwayland_resize_event
/* 1655 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 277), // struct wlr_xwayland_server
/* 1656 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 278), // struct wlr_xwayland_server_options
/* 1657 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 279), // struct wlr_xwayland_surface
/* 1658 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 280), // struct wlr_xwayland_surface_configure_event
/* 1659 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 281), // struct wlr_xwm
/* 1660 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 284), // struct xkb_compose_state
/* 1661 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 285), // struct xkb_compose_table
/* 1662 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 286), // struct xkb_context
/* 1663 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 287), // struct xkb_keymap
/* 1664 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 288), // struct xkb_rule_names
/* 1665 */ _CFFI_OP(_CFFI_OP_POINTER, 1666), // struct xkb_state *
/* 1666 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 289), // struct xkb_state
/* 1667 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 1668 */ _CFFI_OP(_CFFI_OP_POINTER, 21), // uint32_t const *
/* 1669 */ _CFFI_OP(_CFFI_OP_ARRAY, 21), // uint32_t[16]
/* 1670 */ (_cffi_opcode_t)(16),
/* 1671 */ _CFFI_OP(_CFFI_OP_ARRAY, 21), // uint32_t[32]
/* 1672 */ (_cffi_opcode_t)(32),
/* 1673 */ _CFFI_OP(_CFFI_OP_ARRAY, 21), // uint32_t[3]
/* 1674 */ (_cffi_opcode_t)(3),
/* 1675 */ _CFFI_OP(_CFFI_OP_ARRAY, 21), // uint32_t[8]
/* 1676 */ (_cffi_opcode_t)(8),
/* 1677 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 78), // union wl_argument
/* 1678 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 67), // va_list
/* 1679 */ _CFFI_OP(_CFFI_OP_POINTER, 610), // void(*)(struct wl_client *, void *, uint32_t, uint32_t)
/* 1680 */ _CFFI_OP(_CFFI_OP_POINTER, 616), // void(*)(struct wl_listener *, void *)
/* 1681 */ _CFFI_OP(_CFFI_OP_POINTER, 620), // void(*)(struct wl_resource *)
/* 1682 */ _CFFI_OP(_CFFI_OP_POINTER, 1127), // void(*)(struct wlr_surface *)
/* 1683 */ _CFFI_OP(_CFFI_OP_POINTER, 1235), // void(*)(struct xkb_keymap *, uint32_t, void *)
/* 1684 */ _CFFI_OP(_CFFI_OP_POINTER, 1240), // void(*)(void *)
/* 1685 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
/* 1686 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 68), // xcb_connection_t
/* 1687 */ _CFFI_OP(_CFFI_OP_POINTER, 1688), // xcb_ewmh_wm_strut_partial_t *
/* 1688 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 69), // xcb_ewmh_wm_strut_partial_t
/* 1689 */ _CFFI_OP(_CFFI_OP_POINTER, 1690), // xcb_generic_error_t *
/* 1690 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 70), // xcb_generic_error_t
/* 1691 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 71), // xcb_generic_event_t
/* 1692 */ _CFFI_OP(_CFFI_OP_POINTER, 1693), // xcb_icccm_wm_hints_t *
/* 1693 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 72), // xcb_icccm_wm_hints_t
/* 1694 */ _CFFI_OP(_CFFI_OP_POINTER, 1695), // xcb_intern_atom_reply_t *
/* 1695 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 283), // xcb_intern_atom_reply_t
/* 1696 */ _CFFI_OP(_CFFI_OP_POINTER, 1697), // xcb_size_hints_t *
/* 1697 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 73), // xcb_size_hints_t
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_xcb_ewmh_wm_strut_partial_t(xcb_ewmh_wm_strut_partial_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_typedef_xcb_ewmh_wm_strut_partial_t { char x; xcb_ewmh_wm_strut_partial_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_xcb_generic_event_t(xcb_generic_event_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_typedef_xcb_generic_event_t { char x; xcb_generic_event_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_xcb_icccm_wm_hints_t(xcb_icccm_wm_hints_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_typedef_xcb_icccm_wm_hints_t { char x; xcb_icccm_wm_hints_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_xcb_size_hints_t(xcb_size_hints_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'xcb_size_hints_t.flags' is an integer */
  (void)((p->x) | 0);  /* check that 'xcb_size_hints_t.x' is an integer */
  (void)((p->y) | 0);  /* check that 'xcb_size_hints_t.y' is an integer */
  (void)((p->width) | 0);  /* check that 'xcb_size_hints_t.width' is an integer */
  (void)((p->height) | 0);  /* check that 'xcb_size_hints_t.height' is an integer */
  (void)((p->min_width) | 0);  /* check that 'xcb_size_hints_t.min_width' is an integer */
  (void)((p->min_height) | 0);  /* check that 'xcb_size_hints_t.min_height' is an integer */
  (void)((p->max_width) | 0);  /* check that 'xcb_size_hints_t.max_width' is an integer */
  (void)((p->max_height) | 0);  /* check that 'xcb_size_hints_t.max_height' is an integer */
  (void)((p->width_inc) | 0);  /* check that 'xcb_size_hints_t.width_inc' is an integer */
  (void)((p->height_inc) | 0);  /* check that 'xcb_size_hints_t.height_inc' is an integer */
  (void)((p->min_aspect_num) | 0);  /* check that 'xcb_size_hints_t.min_aspect_num' is an integer */
  (void)((p->min_aspect_den) | 0);  /* check that 'xcb_size_hints_t.min_aspect_den' is an integer */
  (void)((p->max_aspect_num) | 0);  /* check that 'xcb_size_hints_t.max_aspect_num' is an integer */
  (void)((p->max_aspect_den) | 0);  /* check that 'xcb_size_hints_t.max_aspect_den' is an integer */
  (void)((p->base_width) | 0);  /* check that 'xcb_size_hints_t.base_width' is an integer */
  (void)((p->base_height) | 0);  /* check that 'xcb_size_hints_t.base_height' is an integer */
  (void)((p->win_gravity) | 0);  /* check that 'xcb_size_hints_t.win_gravity' is an integer */
}
struct _cffi_align_typedef_xcb_size_hints_t { char x; xcb_size_hints_t y; };

static int _cffi_const_WLR_AXIS_ORIENTATION_VERTICAL(unsigned long long *o)
{
  int n = (WLR_AXIS_ORIENTATION_VERTICAL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_ORIENTATION_VERTICAL) | 0);  /* check that WLR_AXIS_ORIENTATION_VERTICAL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_ORIENTATION_HORIZONTAL(unsigned long long *o)
{
  int n = (WLR_AXIS_ORIENTATION_HORIZONTAL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_ORIENTATION_HORIZONTAL) | 0);  /* check that WLR_AXIS_ORIENTATION_HORIZONTAL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_WHEEL(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_WHEEL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_WHEEL) | 0);  /* check that WLR_AXIS_SOURCE_WHEEL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_FINGER(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_FINGER) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_FINGER) | 0);  /* check that WLR_AXIS_SOURCE_FINGER is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_CONTINUOUS(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_CONTINUOUS) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_CONTINUOUS) | 0);  /* check that WLR_AXIS_SOURCE_CONTINUOUS is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_WHEEL_TILT(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_WHEEL_TILT) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_WHEEL_TILT) | 0);  /* check that WLR_AXIS_SOURCE_WHEEL_TILT is an integer */
  return n;
}

static int _cffi_const_WLR_BUFFER_DATA_PTR_ACCESS_READ(unsigned long long *o)
{
  int n = (WLR_BUFFER_DATA_PTR_ACCESS_READ) <= 0;
  *o = (unsigned long long)((WLR_BUFFER_DATA_PTR_ACCESS_READ) | 0);  /* check that WLR_BUFFER_DATA_PTR_ACCESS_READ is an integer */
  return n;
}

static int _cffi_const_WLR_BUFFER_DATA_PTR_ACCESS_WRITE(unsigned long long *o)
{
  int n = (WLR_BUFFER_DATA_PTR_ACCESS_WRITE) <= 0;
  *o = (unsigned long long)((WLR_BUFFER_DATA_PTR_ACCESS_WRITE) | 0);  /* check that WLR_BUFFER_DATA_PTR_ACCESS_WRITE is an integer */
  return n;
}

static int _cffi_const_WLR_BUTTON_RELEASED(unsigned long long *o)
{
  int n = (WLR_BUTTON_RELEASED) <= 0;
  *o = (unsigned long long)((WLR_BUTTON_RELEASED) | 0);  /* check that WLR_BUTTON_RELEASED is an integer */
  return n;
}

static int _cffi_const_WLR_BUTTON_PRESSED(unsigned long long *o)
{
  int n = (WLR_BUTTON_PRESSED) <= 0;
  *o = (unsigned long long)((WLR_BUTTON_PRESSED) | 0);  /* check that WLR_BUTTON_PRESSED is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_NONE(unsigned long long *o)
{
  int n = (WLR_EDGE_NONE) <= 0;
  *o = (unsigned long long)((WLR_EDGE_NONE) | 0);  /* check that WLR_EDGE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_TOP(unsigned long long *o)
{
  int n = (WLR_EDGE_TOP) <= 0;
  *o = (unsigned long long)((WLR_EDGE_TOP) | 0);  /* check that WLR_EDGE_TOP is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_BOTTOM(unsigned long long *o)
{
  int n = (WLR_EDGE_BOTTOM) <= 0;
  *o = (unsigned long long)((WLR_EDGE_BOTTOM) | 0);  /* check that WLR_EDGE_BOTTOM is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_LEFT(unsigned long long *o)
{
  int n = (WLR_EDGE_LEFT) <= 0;
  *o = (unsigned long long)((WLR_EDGE_LEFT) | 0);  /* check that WLR_EDGE_LEFT is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_RIGHT(unsigned long long *o)
{
  int n = (WLR_EDGE_RIGHT) <= 0;
  *o = (unsigned long long)((WLR_EDGE_RIGHT) | 0);  /* check that WLR_EDGE_RIGHT is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_KEYBOARD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_KEYBOARD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_KEYBOARD) | 0);  /* check that WLR_INPUT_DEVICE_KEYBOARD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_POINTER(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_POINTER) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_POINTER) | 0);  /* check that WLR_INPUT_DEVICE_POINTER is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TOUCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TOUCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TOUCH) | 0);  /* check that WLR_INPUT_DEVICE_TOUCH is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_TOOL(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_TOOL) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_TOOL) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_TOOL is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_PAD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_PAD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_PAD) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_PAD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_SWITCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_SWITCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_SWITCH) | 0);  /* check that WLR_INPUT_DEVICE_SWITCH is an integer */
  return n;
}

static int _cffi_const_WLR_LED_NUM_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_NUM_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_NUM_LOCK) | 0);  /* check that WLR_LED_NUM_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_LED_CAPS_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_CAPS_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_CAPS_LOCK) | 0);  /* check that WLR_LED_CAPS_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_LED_SCROLL_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_SCROLL_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_SCROLL_LOCK) | 0);  /* check that WLR_LED_SCROLL_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_SHIFT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_SHIFT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_SHIFT) | 0);  /* check that WLR_MODIFIER_SHIFT is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_CAPS(unsigned long long *o)
{
  int n = (WLR_MODIFIER_CAPS) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_CAPS) | 0);  /* check that WLR_MODIFIER_CAPS is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_CTRL(unsigned long long *o)
{
  int n = (WLR_MODIFIER_CTRL) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_CTRL) | 0);  /* check that WLR_MODIFIER_CTRL is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_ALT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_ALT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_ALT) | 0);  /* check that WLR_MODIFIER_ALT is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD2(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD2) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD2) | 0);  /* check that WLR_MODIFIER_MOD2 is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD3(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD3) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD3) | 0);  /* check that WLR_MODIFIER_MOD3 is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_LOGO(unsigned long long *o)
{
  int n = (WLR_MODIFIER_LOGO) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_LOGO) | 0);  /* check that WLR_MODIFIER_LOGO is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD5(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD5) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD5) | 0);  /* check that WLR_MODIFIER_MOD5 is an integer */
  return n;
}

static int _cffi_const_WLR_SILENT(unsigned long long *o)
{
  int n = (WLR_SILENT) <= 0;
  *o = (unsigned long long)((WLR_SILENT) | 0);  /* check that WLR_SILENT is an integer */
  return n;
}

static int _cffi_const_WLR_ERROR(unsigned long long *o)
{
  int n = (WLR_ERROR) <= 0;
  *o = (unsigned long long)((WLR_ERROR) | 0);  /* check that WLR_ERROR is an integer */
  return n;
}

static int _cffi_const_WLR_INFO(unsigned long long *o)
{
  int n = (WLR_INFO) <= 0;
  *o = (unsigned long long)((WLR_INFO) | 0);  /* check that WLR_INFO is an integer */
  return n;
}

static int _cffi_const_WLR_DEBUG(unsigned long long *o)
{
  int n = (WLR_DEBUG) <= 0;
  *o = (unsigned long long)((WLR_DEBUG) | 0);  /* check that WLR_DEBUG is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_REGION(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_STATE_REGION) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_STATE_REGION) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_STATE_REGION is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_LOCKED(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_LOCKED) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_LOCKED) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_LOCKED is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_CONFINED(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_CONFINED) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_CONFINED) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_CONFINED is an integer */
  return n;
}

static int _cffi_const_WLR_SCENE_NODE_TREE(unsigned long long *o)
{
  int n = (WLR_SCENE_NODE_TREE) <= 0;
  *o = (unsigned long long)((WLR_SCENE_NODE_TREE) | 0);  /* check that WLR_SCENE_NODE_TREE is an integer */
  return n;
}

static int _cffi_const_WLR_SCENE_NODE_RECT(unsigned long long *o)
{
  int n = (WLR_SCENE_NODE_RECT) <= 0;
  *o = (unsigned long long)((WLR_SCENE_NODE_RECT) | 0);  /* check that WLR_SCENE_NODE_RECT is an integer */
  return n;
}

static int _cffi_const_WLR_SCENE_NODE_BUFFER(unsigned long long *o)
{
  int n = (WLR_SCENE_NODE_BUFFER) <= 0;
  *o = (unsigned long long)((WLR_SCENE_NODE_BUFFER) | 0);  /* check that WLR_SCENE_NODE_BUFFER is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_NONE(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_NONE) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_NONE) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_SERVER(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_SERVER) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_SERVER) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_SERVER is an integer */
  return n;
}

static int _cffi_const_WLR_SWITCH_STATE_OFF(unsigned long long *o)
{
  int n = (WLR_SWITCH_STATE_OFF) <= 0;
  *o = (unsigned long long)((WLR_SWITCH_STATE_OFF) | 0);  /* check that WLR_SWITCH_STATE_OFF is an integer */
  return n;
}

static int _cffi_const_WLR_SWITCH_STATE_ON(unsigned long long *o)
{
  int n = (WLR_SWITCH_STATE_ON) <= 0;
  *o = (unsigned long long)((WLR_SWITCH_STATE_ON) | 0);  /* check that WLR_SWITCH_STATE_ON is an integer */
  return n;
}

static int _cffi_const_WLR_SWITCH_TYPE_LID(unsigned long long *o)
{
  int n = (WLR_SWITCH_TYPE_LID) <= 0;
  *o = (unsigned long long)((WLR_SWITCH_TYPE_LID) | 0);  /* check that WLR_SWITCH_TYPE_LID is an integer */
  return n;
}

static int _cffi_const_WLR_SWITCH_TYPE_TABLET_MODE(unsigned long long *o)
{
  int n = (WLR_SWITCH_TYPE_TABLET_MODE) <= 0;
  *o = (unsigned long long)((WLR_SWITCH_TYPE_TABLET_MODE) | 0);  /* check that WLR_SWITCH_TYPE_TABLET_MODE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_POPUP_CONFIGURE_REPOSITION_TOKEN(unsigned long long *o)
{
  int n = (WLR_XDG_POPUP_CONFIGURE_REPOSITION_TOKEN) <= 0;
  *o = (unsigned long long)((WLR_XDG_POPUP_CONFIGURE_REPOSITION_TOKEN) | 0);  /* check that WLR_XDG_POPUP_CONFIGURE_REPOSITION_TOKEN is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_NONE(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_NONE) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_NONE) | 0);  /* check that WLR_XDG_SURFACE_ROLE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_TOPLEVEL(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_TOPLEVEL) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_TOPLEVEL) | 0);  /* check that WLR_XDG_SURFACE_ROLE_TOPLEVEL is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_POPUP(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_POPUP) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_POPUP) | 0);  /* check that WLR_XDG_SURFACE_ROLE_POPUP is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU) | 0);  /* check that WLR_XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE) | 0);  /* check that WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN) | 0);  /* check that WLR_XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE) | 0);  /* check that WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_NONE(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_NONE) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_NONE) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_PASSIVE(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_PASSIVE) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_PASSIVE) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_PASSIVE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_LOCAL(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_LOCAL) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_LOCAL) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_LOCAL is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_GLOBAL(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_GLOBAL) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_GLOBAL) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_GLOBAL is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_ALL(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_ALL) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_ALL) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_ALL is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPILE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_IGNORED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_IGNORED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_IGNORED) | 0);  /* check that XKB_COMPOSE_FEED_IGNORED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_ACCEPTED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_ACCEPTED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_ACCEPTED) | 0);  /* check that XKB_COMPOSE_FEED_ACCEPTED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FORMAT_TEXT_V1) | 0);  /* check that XKB_COMPOSE_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_STATE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_STATE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_STATE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_STATE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_NOTHING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_NOTHING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_NOTHING) | 0);  /* check that XKB_COMPOSE_NOTHING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSING) | 0);  /* check that XKB_COMPOSE_COMPOSING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSED) | 0);  /* check that XKB_COMPOSE_COMPOSED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_CANCELLED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_CANCELLED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_CANCELLED) | 0);  /* check that XKB_COMPOSE_CANCELLED is an integer */
  return n;
}

static int _cffi_const_XKB_CONSUMED_MODE_XKB(unsigned long long *o)
{
  int n = (XKB_CONSUMED_MODE_XKB) <= 0;
  *o = (unsigned long long)((XKB_CONSUMED_MODE_XKB) | 0);  /* check that XKB_CONSUMED_MODE_XKB is an integer */
  return n;
}

static int _cffi_const_XKB_CONSUMED_MODE_GTK(unsigned long long *o)
{
  int n = (XKB_CONSUMED_MODE_GTK) <= 0;
  *o = (unsigned long long)((XKB_CONSUMED_MODE_GTK) | 0);  /* check that XKB_CONSUMED_MODE_GTK is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_FLAGS) | 0);  /* check that XKB_CONTEXT_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_DEFAULT_INCLUDES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_DEFAULT_INCLUDES) | 0);  /* check that XKB_CONTEXT_NO_DEFAULT_INCLUDES is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_ENVIRONMENT_NAMES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_ENVIRONMENT_NAMES) | 0);  /* check that XKB_CONTEXT_NO_ENVIRONMENT_NAMES is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_SECURE_GETENV(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_SECURE_GETENV) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_SECURE_GETENV) | 0);  /* check that XKB_CONTEXT_NO_SECURE_GETENV is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_UP(unsigned long long *o)
{
  int n = (XKB_KEY_UP) <= 0;
  *o = (unsigned long long)((XKB_KEY_UP) | 0);  /* check that XKB_KEY_UP is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_DOWN(unsigned long long *o)
{
  int n = (XKB_KEY_DOWN) <= 0;
  *o = (unsigned long long)((XKB_KEY_DOWN) | 0);  /* check that XKB_KEY_DOWN is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYMAP_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_COMPILE_NO_FLAGS) | 0);  /* check that XKB_KEYMAP_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_KEYMAP_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_FORMAT_TEXT_V1) | 0);  /* check that XKB_KEYMAP_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYSYM_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_NO_FLAGS) | 0);  /* check that XKB_KEYSYM_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_CASE_INSENSITIVE(unsigned long long *o)
{
  int n = (XKB_KEYSYM_CASE_INSENSITIVE) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_CASE_INSENSITIVE) | 0);  /* check that XKB_KEYSYM_CASE_INSENSITIVE is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_CRITICAL(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_CRITICAL) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_CRITICAL) | 0);  /* check that XKB_LOG_LEVEL_CRITICAL is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_ERROR(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_ERROR) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_ERROR) | 0);  /* check that XKB_LOG_LEVEL_ERROR is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_WARNING(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_WARNING) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_WARNING) | 0);  /* check that XKB_LOG_LEVEL_WARNING is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_INFO(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_INFO) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_INFO) | 0);  /* check that XKB_LOG_LEVEL_INFO is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_DEBUG(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_DEBUG) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_DEBUG) | 0);  /* check that XKB_LOG_LEVEL_DEBUG is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_DEPRESSED) | 0);  /* check that XKB_STATE_MODS_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LATCHED) | 0);  /* check that XKB_STATE_MODS_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LOCKED) | 0);  /* check that XKB_STATE_MODS_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_EFFECTIVE) | 0);  /* check that XKB_STATE_MODS_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_DEPRESSED) | 0);  /* check that XKB_STATE_LAYOUT_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LATCHED) | 0);  /* check that XKB_STATE_LAYOUT_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LOCKED) | 0);  /* check that XKB_STATE_LAYOUT_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_EFFECTIVE) | 0);  /* check that XKB_STATE_LAYOUT_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LEDS(unsigned long long *o)
{
  int n = (XKB_STATE_LEDS) <= 0;
  *o = (unsigned long long)((XKB_STATE_LEDS) | 0);  /* check that XKB_STATE_LEDS is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ANY(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ANY) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ANY) | 0);  /* check that XKB_STATE_MATCH_ANY is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ALL(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ALL) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ALL) | 0);  /* check that XKB_STATE_MATCH_ALL is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_NON_EXCLUSIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_NON_EXCLUSIVE) | 0);  /* check that XKB_STATE_MATCH_NON_EXCLUSIVE is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy__buffer_iterator_callback =
  { "wlroots._ffi.buffer_iterator_callback", 0, 0, 0 };

static void buffer_iterator_callback(struct wlr_scene_buffer * a0, int a1, int a2, void * a3)
{
  char a[32];
  char *p = a;
  *(struct wlr_scene_buffer * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__buffer_iterator_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__log_func_callback =
  { "wlroots._ffi.log_func_callback", 0, 0, 0 };

static void log_func_callback(enum wlr_log_importance a0, char const * a1)
{
  char a[16];
  char *p = a;
  *(enum wlr_log_importance *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__log_func_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__surface_iterator_callback =
  { "wlroots._ffi.surface_iterator_callback", 0, 0, 0 };

static void surface_iterator_callback(struct wlr_surface * a0, int a1, int a2, void * a3)
{
  char a[32];
  char *p = a;
  *(struct wlr_surface * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__surface_iterator_callback, p);
}

static int _cffi_d_clock_gettime(int32_t x0, struct timespec * x1)
{
  return clock_gettime(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clock_gettime(PyObject *self, PyObject *args)
{
  int32_t x0;
  struct timespec * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clock_gettime", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int32_t);
  if (x0 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(147), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(147), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clock_gettime(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clock_gettime _cffi_d_clock_gettime
#endif

static void _cffi_d_pixman_region32_fini(struct pixman_region32 * x0)
{
  pixman_region32_fini(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_fini(PyObject *self, PyObject *arg0)
{
  struct pixman_region32 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pixman_region32_fini(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pixman_region32_fini _cffi_d_pixman_region32_fini
#endif

static void _cffi_d_pixman_region32_init(struct pixman_region32 * x0)
{
  pixman_region32_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_init(PyObject *self, PyObject *arg0)
{
  struct pixman_region32 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pixman_region32_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pixman_region32_init _cffi_d_pixman_region32_init
#endif

static void _cffi_d_pixman_region32_init_rect(struct pixman_region32 * x0, int x1, int x2, unsigned int x3, unsigned int x4)
{
  pixman_region32_init_rect(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_init_rect(PyObject *self, PyObject *args)
{
  struct pixman_region32 * x0;
  int x1;
  int x2;
  unsigned int x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "pixman_region32_init_rect", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pixman_region32_init_rect(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pixman_region32_init_rect _cffi_d_pixman_region32_init_rect
#endif

static _Bool _cffi_d_pixman_region32_not_empty(struct pixman_region32 * x0)
{
  return pixman_region32_not_empty(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_not_empty(PyObject *self, PyObject *arg0)
{
  struct pixman_region32 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pixman_region32_not_empty(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pixman_region32_not_empty _cffi_d_pixman_region32_not_empty
#endif

static struct pixman_box32 * _cffi_d_pixman_region32_rectangles(struct pixman_region32 * x0, int * x1)
{
  return pixman_region32_rectangles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_rectangles(PyObject *self, PyObject *args)
{
  struct pixman_region32 * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct pixman_box32 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pixman_region32_rectangles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pixman_region32_rectangles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1391));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pixman_region32_rectangles _cffi_d_pixman_region32_rectangles
#endif

static struct wlr_allocator * _cffi_d_wlr_allocator_autocreate(struct wlr_backend * x0, struct wlr_renderer * x1)
{
  return wlr_allocator_autocreate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_allocator_autocreate(PyObject *self, PyObject *args)
{
  struct wlr_backend * x0;
  struct wlr_renderer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_allocator * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_allocator_autocreate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_allocator_autocreate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(44));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_allocator_autocreate _cffi_d_wlr_allocator_autocreate
#endif

static struct wlr_buffer * _cffi_d_wlr_allocator_create_buffer(struct wlr_allocator * x0, int x1, int x2, struct wlr_drm_format const * x3)
{
  return wlr_allocator_create_buffer(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_allocator_create_buffer(PyObject *self, PyObject *args)
{
  struct wlr_allocator * x0;
  int x1;
  int x2;
  struct wlr_drm_format const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_buffer * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_allocator_create_buffer", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(44), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(195), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct wlr_drm_format const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(195), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_allocator_create_buffer(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(20));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_allocator_create_buffer _cffi_d_wlr_allocator_create_buffer
#endif

static struct wlr_backend * _cffi_d_wlr_backend_autocreate(struct wl_display * x0, struct wlr_session * * x1)
{
  return wlr_backend_autocreate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_autocreate(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_session * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_backend * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_backend_autocreate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(189), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_session * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(189), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_autocreate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_autocreate _cffi_d_wlr_backend_autocreate
#endif

static void _cffi_d_wlr_backend_destroy(struct wlr_backend * x0)
{
  wlr_backend_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_backend_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_backend_destroy _cffi_d_wlr_backend_destroy
#endif

static _Bool _cffi_d_wlr_backend_is_headless(struct wlr_backend * x0)
{
  return wlr_backend_is_headless(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_is_headless(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_is_headless(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_is_headless _cffi_d_wlr_backend_is_headless
#endif

static _Bool _cffi_d_wlr_backend_is_multi(struct wlr_backend * x0)
{
  return wlr_backend_is_multi(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_is_multi(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_is_multi(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_is_multi _cffi_d_wlr_backend_is_multi
#endif

static _Bool _cffi_d_wlr_backend_start(struct wlr_backend * x0)
{
  return wlr_backend_start(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_start(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_start(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_start _cffi_d_wlr_backend_start
#endif

static void _cffi_d_wlr_box_closest_point(struct wlr_box const * x0, double x1, double x2, double * x3, double * x4)
{
  wlr_box_closest_point(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_closest_point(PyObject *self, PyObject *args)
{
  struct wlr_box const * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_box_closest_point", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_box_closest_point(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_box_closest_point _cffi_d_wlr_box_closest_point
#endif

static _Bool _cffi_d_wlr_box_contains_point(struct wlr_box const * x0, double x1, double x2)
{
  return wlr_box_contains_point(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_contains_point(PyObject *self, PyObject *args)
{
  struct wlr_box const * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_box_contains_point", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_box_contains_point(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_box_contains_point _cffi_d_wlr_box_contains_point
#endif

static _Bool _cffi_d_wlr_box_empty(struct wlr_box const * x0)
{
  return wlr_box_empty(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_empty(PyObject *self, PyObject *arg0)
{
  struct wlr_box const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_box_empty(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_box_empty _cffi_d_wlr_box_empty
#endif

static _Bool _cffi_d_wlr_box_intersection(struct wlr_box * x0, struct wlr_box const * x1, struct wlr_box const * x2)
{
  return wlr_box_intersection(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_intersection(PyObject *self, PyObject *args)
{
  struct wlr_box * x0;
  struct wlr_box const * x1;
  struct wlr_box const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_box_intersection", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_box_intersection(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_box_intersection _cffi_d_wlr_box_intersection
#endif

static void _cffi_d_wlr_box_transform(struct wlr_box * x0, struct wlr_box const * x1, enum wl_output_transform x2, int x3, int x4)
{
  wlr_box_transform(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_transform(PyObject *self, PyObject *args)
{
  struct wlr_box * x0;
  struct wlr_box const * x1;
  enum wl_output_transform x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_box_transform", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(127), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_box_transform(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_box_transform _cffi_d_wlr_box_transform
#endif

static _Bool _cffi_d_wlr_buffer_begin_data_ptr_access(struct wlr_buffer * x0, uint32_t x1, void * * x2, uint32_t * x3, size_t * x4)
{
  return wlr_buffer_begin_data_ptr_access(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_buffer_begin_data_ptr_access(PyObject *self, PyObject *args)
{
  struct wlr_buffer * x0;
  uint32_t x1;
  void * * x2;
  uint32_t * x3;
  size_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_buffer_begin_data_ptr_access", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_buffer_begin_data_ptr_access(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_buffer_begin_data_ptr_access _cffi_d_wlr_buffer_begin_data_ptr_access
#endif

static void _cffi_d_wlr_buffer_drop(struct wlr_buffer * x0)
{
  wlr_buffer_drop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_buffer_drop(PyObject *self, PyObject *arg0)
{
  struct wlr_buffer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_buffer_drop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_buffer_drop _cffi_d_wlr_buffer_drop
#endif

static void _cffi_d_wlr_buffer_end_data_ptr_access(struct wlr_buffer * x0)
{
  wlr_buffer_end_data_ptr_access(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_buffer_end_data_ptr_access(PyObject *self, PyObject *arg0)
{
  struct wlr_buffer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_buffer_end_data_ptr_access(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_buffer_end_data_ptr_access _cffi_d_wlr_buffer_end_data_ptr_access
#endif

static struct wlr_buffer * _cffi_d_wlr_buffer_lock(struct wlr_buffer * x0)
{
  return wlr_buffer_lock(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_buffer_lock(PyObject *self, PyObject *arg0)
{
  struct wlr_buffer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_buffer * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_buffer_lock(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(20));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_buffer_lock _cffi_d_wlr_buffer_lock
#endif

static void _cffi_d_wlr_buffer_unlock(struct wlr_buffer * x0)
{
  wlr_buffer_unlock(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_buffer_unlock(PyObject *self, PyObject *arg0)
{
  struct wlr_buffer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_buffer_unlock(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_buffer_unlock _cffi_d_wlr_buffer_unlock
#endif

static struct wlr_compositor * _cffi_d_wlr_compositor_create(struct wl_display * x0, uint32_t x1, struct wlr_renderer * x2)
{
  return wlr_compositor_create(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_compositor_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  uint32_t x1;
  struct wlr_renderer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_compositor * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_compositor_create", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_compositor_create(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(494));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_compositor_create _cffi_d_wlr_compositor_create
#endif

static void _cffi_d_wlr_cursor_absolute_to_layout_coords(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3, double * x4, double * x5)
{
  wlr_cursor_absolute_to_layout_coords(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_absolute_to_layout_coords(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  double * x4;
  double * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_absolute_to_layout_coords", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_absolute_to_layout_coords(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_absolute_to_layout_coords _cffi_d_wlr_cursor_absolute_to_layout_coords
#endif

static void _cffi_d_wlr_cursor_attach_input_device(struct wlr_cursor * x0, struct wlr_input_device * x1)
{
  wlr_cursor_attach_input_device(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_attach_input_device(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_attach_input_device", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_attach_input_device(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_attach_input_device _cffi_d_wlr_cursor_attach_input_device
#endif

static void _cffi_d_wlr_cursor_attach_output_layout(struct wlr_cursor * x0, struct wlr_output_layout * x1)
{
  wlr_cursor_attach_output_layout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_attach_output_layout(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_output_layout * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_attach_output_layout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_attach_output_layout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_attach_output_layout _cffi_d_wlr_cursor_attach_output_layout
#endif

static struct wlr_cursor * _cffi_d_wlr_cursor_create(void)
{
  return wlr_cursor_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_create(PyObject *self, PyObject *noarg)
{
  struct wlr_cursor * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_cursor_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(27));
  return pyresult;
}
#else
#  define _cffi_f_wlr_cursor_create _cffi_d_wlr_cursor_create
#endif

static void _cffi_d_wlr_cursor_destroy(struct wlr_cursor * x0)
{
  wlr_cursor_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_cursor * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_destroy _cffi_d_wlr_cursor_destroy
#endif

static void _cffi_d_wlr_cursor_detach_input_device(struct wlr_cursor * x0, struct wlr_input_device * x1)
{
  wlr_cursor_detach_input_device(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_detach_input_device(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_detach_input_device", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_detach_input_device(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_detach_input_device _cffi_d_wlr_cursor_detach_input_device
#endif

static void _cffi_d_wlr_cursor_map_input_to_output(struct wlr_cursor * x0, struct wlr_input_device * x1, struct wlr_output * x2)
{
  wlr_cursor_map_input_to_output(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_map_input_to_output(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  struct wlr_output * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_map_input_to_output", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_map_input_to_output(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_map_input_to_output _cffi_d_wlr_cursor_map_input_to_output
#endif

static void _cffi_d_wlr_cursor_map_to_output(struct wlr_cursor * x0, struct wlr_output * x1)
{
  wlr_cursor_map_to_output(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_map_to_output(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_map_to_output", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_map_to_output(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_map_to_output _cffi_d_wlr_cursor_map_to_output
#endif

static void _cffi_d_wlr_cursor_move(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  wlr_cursor_move(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_move(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_move", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_move(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_move _cffi_d_wlr_cursor_move
#endif

static void _cffi_d_wlr_cursor_set_surface(struct wlr_cursor * x0, struct wlr_surface * x1, int32_t x2, int32_t x3)
{
  wlr_cursor_set_surface(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_set_surface(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_surface * x1;
  int32_t x2;
  int32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_set_surface", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_set_surface(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_set_surface _cffi_d_wlr_cursor_set_surface
#endif

static void _cffi_d_wlr_cursor_set_xcursor(struct wlr_cursor * x0, struct wlr_xcursor_manager * x1, char const * x2)
{
  wlr_cursor_set_xcursor(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_set_xcursor(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_xcursor_manager * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_set_xcursor", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_set_xcursor(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_set_xcursor _cffi_d_wlr_cursor_set_xcursor
#endif

static _Bool _cffi_d_wlr_cursor_warp(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  return wlr_cursor_warp(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_warp(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_warp", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_cursor_warp(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_cursor_warp _cffi_d_wlr_cursor_warp
#endif

static void _cffi_d_wlr_cursor_warp_absolute(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  wlr_cursor_warp_absolute(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_warp_absolute(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_warp_absolute", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_warp_absolute(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_warp_absolute _cffi_d_wlr_cursor_warp_absolute
#endif

static void _cffi_d_wlr_cursor_warp_closest(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  wlr_cursor_warp_closest(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_warp_closest(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_warp_closest", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_warp_closest(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_warp_closest _cffi_d_wlr_cursor_warp_closest
#endif

static struct wlr_data_control_manager_v1 * _cffi_d_wlr_data_control_manager_v1_create(struct wl_display * x0)
{
  return wlr_data_control_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_data_control_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_data_control_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_data_control_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1433));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_data_control_manager_v1_create _cffi_d_wlr_data_control_manager_v1_create
#endif

static struct wlr_data_device_manager * _cffi_d_wlr_data_device_manager_create(struct wl_display * x0)
{
  return wlr_data_device_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_data_device_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_data_device_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_data_device_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1435));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_data_device_manager_create _cffi_d_wlr_data_device_manager_create
#endif

static void _cffi_d_wlr_data_source_destroy(struct wlr_data_source * x0)
{
  wlr_data_source_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_data_source_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_data_source * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(689), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_data_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(689), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_data_source_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_data_source_destroy _cffi_d_wlr_data_source_destroy
#endif

static struct wlr_drm_format const * _cffi_d_wlr_drm_format_set_get(struct wlr_drm_format_set const * x0, uint32_t x1)
{
  return wlr_drm_format_set_get(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_drm_format_set_get(PyObject *self, PyObject *args)
{
  struct wlr_drm_format_set const * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_drm_format const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_drm_format_set_get", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(214), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_drm_format_set const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(214), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_drm_format_set_get(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(195));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_drm_format_set_get _cffi_d_wlr_drm_format_set_get
#endif

static struct wlr_export_dmabuf_manager_v1 * _cffi_d_wlr_export_dmabuf_manager_v1_create(struct wl_display * x0)
{
  return wlr_export_dmabuf_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_export_dmabuf_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_export_dmabuf_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_export_dmabuf_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1447));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_export_dmabuf_manager_v1_create _cffi_d_wlr_export_dmabuf_manager_v1_create
#endif

static struct wlr_foreign_toplevel_handle_v1 * _cffi_d_wlr_foreign_toplevel_handle_v1_create(struct wlr_foreign_toplevel_manager_v1 * x0)
{
  return wlr_foreign_toplevel_handle_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_create(PyObject *self, PyObject *arg0)
{
  struct wlr_foreign_toplevel_manager_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_foreign_toplevel_handle_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(221), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_manager_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(221), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_foreign_toplevel_handle_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(692));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_create _cffi_d_wlr_foreign_toplevel_handle_v1_create
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_destroy(struct wlr_foreign_toplevel_handle_v1 * x0)
{
  wlr_foreign_toplevel_handle_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_destroy _cffi_d_wlr_foreign_toplevel_handle_v1_destroy
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_output_enter(struct wlr_foreign_toplevel_handle_v1 * x0, struct wlr_output * x1)
{
  wlr_foreign_toplevel_handle_v1_output_enter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_output_enter(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_output_enter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_output_enter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_output_enter _cffi_d_wlr_foreign_toplevel_handle_v1_output_enter
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_output_leave(struct wlr_foreign_toplevel_handle_v1 * x0, struct wlr_output * x1)
{
  wlr_foreign_toplevel_handle_v1_output_leave(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_output_leave(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_output_leave", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_output_leave(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_output_leave _cffi_d_wlr_foreign_toplevel_handle_v1_output_leave
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_activated(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_activated(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_activated(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_activated", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_activated(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_activated _cffi_d_wlr_foreign_toplevel_handle_v1_set_activated
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_app_id(struct wlr_foreign_toplevel_handle_v1 * x0, char const * x1)
{
  wlr_foreign_toplevel_handle_v1_set_app_id(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_app_id(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_app_id", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_app_id(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_app_id _cffi_d_wlr_foreign_toplevel_handle_v1_set_app_id
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_fullscreen(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_fullscreen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_fullscreen(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_fullscreen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_fullscreen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_fullscreen _cffi_d_wlr_foreign_toplevel_handle_v1_set_fullscreen
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_maximized(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_maximized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_maximized(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_maximized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_maximized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_maximized _cffi_d_wlr_foreign_toplevel_handle_v1_set_maximized
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_minimized(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_minimized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_minimized(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_minimized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_minimized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_minimized _cffi_d_wlr_foreign_toplevel_handle_v1_set_minimized
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_parent(struct wlr_foreign_toplevel_handle_v1 * x0, struct wlr_foreign_toplevel_handle_v1 * x1)
{
  wlr_foreign_toplevel_handle_v1_set_parent(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_parent(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  struct wlr_foreign_toplevel_handle_v1 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_parent", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_parent(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_parent _cffi_d_wlr_foreign_toplevel_handle_v1_set_parent
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_title(struct wlr_foreign_toplevel_handle_v1 * x0, char const * x1)
{
  wlr_foreign_toplevel_handle_v1_set_title(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_title(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_title", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_title(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_title _cffi_d_wlr_foreign_toplevel_handle_v1_set_title
#endif

static struct wlr_foreign_toplevel_manager_v1 * _cffi_d_wlr_foreign_toplevel_manager_v1_create(struct wl_display * x0)
{
  return wlr_foreign_toplevel_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_foreign_toplevel_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_foreign_toplevel_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(221));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_manager_v1_create _cffi_d_wlr_foreign_toplevel_manager_v1_create
#endif

static struct wlr_fractional_scale_manager_v1 * _cffi_d_wlr_fractional_scale_manager_v1_create(struct wl_display * x0, uint32_t x1)
{
  return wlr_fractional_scale_manager_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_fractional_scale_manager_v1_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_fractional_scale_manager_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_fractional_scale_manager_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_fractional_scale_manager_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1457));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_fractional_scale_manager_v1_create _cffi_d_wlr_fractional_scale_manager_v1_create
#endif

static void _cffi_d_wlr_fractional_scale_v1_notify_scale(struct wlr_surface * x0, double x1)
{
  wlr_fractional_scale_v1_notify_scale(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_fractional_scale_v1_notify_scale(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_fractional_scale_v1_notify_scale", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_fractional_scale_v1_notify_scale(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_fractional_scale_v1_notify_scale _cffi_d_wlr_fractional_scale_v1_notify_scale
#endif

static struct wlr_gamma_control_manager_v1 * _cffi_d_wlr_gamma_control_manager_v1_create(struct wl_display * x0)
{
  return wlr_gamma_control_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_gamma_control_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_gamma_control_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_gamma_control_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1459));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_gamma_control_manager_v1_create _cffi_d_wlr_gamma_control_manager_v1_create
#endif

static struct wlr_output * _cffi_d_wlr_headless_add_output(struct wlr_backend * x0, unsigned int x1, unsigned int x2)
{
  return wlr_headless_add_output(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_headless_add_output(PyObject *self, PyObject *args)
{
  struct wlr_backend * x0;
  unsigned int x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_headless_add_output", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_headless_add_output(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(36));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_headless_add_output _cffi_d_wlr_headless_add_output
#endif

static struct wlr_backend * _cffi_d_wlr_headless_backend_create(struct wl_display * x0)
{
  return wlr_headless_backend_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_headless_backend_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_backend * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_headless_backend_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_headless_backend_create _cffi_d_wlr_headless_backend_create
#endif

static struct wlr_idle_inhibit_manager_v1 * _cffi_d_wlr_idle_inhibit_v1_create(struct wl_display * x0)
{
  return wlr_idle_inhibit_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_inhibit_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_idle_inhibit_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_idle_inhibit_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1461));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_idle_inhibit_v1_create _cffi_d_wlr_idle_inhibit_v1_create
#endif

static struct wlr_idle_notifier_v1 * _cffi_d_wlr_idle_notifier_v1_create(struct wl_display * x0)
{
  return wlr_idle_notifier_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_notifier_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_idle_notifier_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_idle_notifier_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(711));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_idle_notifier_v1_create _cffi_d_wlr_idle_notifier_v1_create
#endif

static void _cffi_d_wlr_idle_notifier_v1_notify_activity(struct wlr_idle_notifier_v1 * x0, struct wlr_seat * x1)
{
  wlr_idle_notifier_v1_notify_activity(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_notifier_v1_notify_activity(PyObject *self, PyObject *args)
{
  struct wlr_idle_notifier_v1 * x0;
  struct wlr_seat * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_idle_notifier_v1_notify_activity", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(711), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_idle_notifier_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(711), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_idle_notifier_v1_notify_activity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_idle_notifier_v1_notify_activity _cffi_d_wlr_idle_notifier_v1_notify_activity
#endif

static void _cffi_d_wlr_idle_notifier_v1_set_inhibited(struct wlr_idle_notifier_v1 * x0, _Bool x1)
{
  wlr_idle_notifier_v1_set_inhibited(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_notifier_v1_set_inhibited(PyObject *self, PyObject *args)
{
  struct wlr_idle_notifier_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_idle_notifier_v1_set_inhibited", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(711), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_idle_notifier_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(711), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_idle_notifier_v1_set_inhibited(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_idle_notifier_v1_set_inhibited _cffi_d_wlr_idle_notifier_v1_set_inhibited
#endif

static struct wlr_virtual_keyboard_v1 * _cffi_d_wlr_input_device_get_virtual_keyboard(struct wlr_input_device * x0)
{
  return wlr_input_device_get_virtual_keyboard(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_input_device_get_virtual_keyboard(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_virtual_keyboard_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_input_device_get_virtual_keyboard(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1604));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_input_device_get_virtual_keyboard _cffi_d_wlr_input_device_get_virtual_keyboard
#endif

static _Bool _cffi_d_wlr_input_device_is_libinput(struct wlr_input_device * x0)
{
  return wlr_input_device_is_libinput(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_input_device_is_libinput(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_input_device_is_libinput(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_input_device_is_libinput _cffi_d_wlr_input_device_is_libinput
#endif

static struct wlr_input_inhibit_manager * _cffi_d_wlr_input_inhibit_manager_create(struct wl_display * x0)
{
  return wlr_input_inhibit_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_input_inhibit_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_input_inhibit_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_input_inhibit_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1466));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_input_inhibit_manager_create _cffi_d_wlr_input_inhibit_manager_create
#endif

static struct wlr_keyboard * _cffi_d_wlr_keyboard_from_input_device(struct wlr_input_device * x0)
{
  return wlr_keyboard_from_input_device(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_from_input_device(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_keyboard * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_keyboard_from_input_device(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(509));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_keyboard_from_input_device _cffi_d_wlr_keyboard_from_input_device
#endif

static uint32_t _cffi_d_wlr_keyboard_get_modifiers(struct wlr_keyboard * x0)
{
  return wlr_keyboard_get_modifiers(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_get_modifiers(PyObject *self, PyObject *arg0)
{
  struct wlr_keyboard * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(509), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(509), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_keyboard_get_modifiers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_keyboard_get_modifiers _cffi_d_wlr_keyboard_get_modifiers
#endif

static void _cffi_d_wlr_keyboard_notify_modifiers(struct wlr_keyboard * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4)
{
  wlr_keyboard_notify_modifiers(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_notify_modifiers(PyObject *self, PyObject *args)
{
  struct wlr_keyboard * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_keyboard_notify_modifiers", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(509), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(509), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_keyboard_notify_modifiers(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_keyboard_notify_modifiers _cffi_d_wlr_keyboard_notify_modifiers
#endif

static void _cffi_d_wlr_keyboard_set_keymap(struct wlr_keyboard * x0, struct xkb_keymap * x1)
{
  wlr_keyboard_set_keymap(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_set_keymap(PyObject *self, PyObject *args)
{
  struct wlr_keyboard * x0;
  struct xkb_keymap * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_keyboard_set_keymap", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(509), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(509), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(725), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(725), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_keyboard_set_keymap(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_keyboard_set_keymap _cffi_d_wlr_keyboard_set_keymap
#endif

static void _cffi_d_wlr_keyboard_set_repeat_info(struct wlr_keyboard * x0, int32_t x1, int32_t x2)
{
  wlr_keyboard_set_repeat_info(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_set_repeat_info(PyObject *self, PyObject *args)
{
  struct wlr_keyboard * x0;
  int32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_keyboard_set_repeat_info", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(509), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(509), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_keyboard_set_repeat_info(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_keyboard_set_repeat_info _cffi_d_wlr_keyboard_set_repeat_info
#endif

static struct wlr_layer_shell_v1 * _cffi_d_wlr_layer_shell_v1_create(struct wl_display * x0, uint32_t x1)
{
  return wlr_layer_shell_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_shell_v1_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_layer_shell_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_layer_shell_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_layer_shell_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1477));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_layer_shell_v1_create _cffi_d_wlr_layer_shell_v1_create
#endif

static void _cffi_d_wlr_layer_surface_v1_configure(struct wlr_layer_surface_v1 * x0, uint32_t x1, uint32_t x2)
{
  wlr_layer_surface_v1_configure(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_configure(PyObject *self, PyObject *args)
{
  struct wlr_layer_surface_v1 * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_layer_surface_v1_configure", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(335), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(335), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_layer_surface_v1_configure(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_configure _cffi_d_wlr_layer_surface_v1_configure
#endif

static void _cffi_d_wlr_layer_surface_v1_destroy(struct wlr_layer_surface_v1 * x0)
{
  wlr_layer_surface_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_layer_surface_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(335), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(335), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_layer_surface_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_destroy _cffi_d_wlr_layer_surface_v1_destroy
#endif

static void _cffi_d_wlr_layer_surface_v1_for_each_surface(struct wlr_layer_surface_v1 * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_layer_surface_v1_for_each_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_for_each_surface(PyObject *self, PyObject *args)
{
  struct wlr_layer_surface_v1 * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_layer_surface_v1_for_each_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(335), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(335), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(744));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_layer_surface_v1_for_each_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_for_each_surface _cffi_d_wlr_layer_surface_v1_for_each_surface
#endif

static struct wlr_surface * _cffi_d_wlr_layer_surface_v1_surface_at(struct wlr_layer_surface_v1 * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_layer_surface_v1_surface_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_surface_at(PyObject *self, PyObject *args)
{
  struct wlr_layer_surface_v1 * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_layer_surface_v1_surface_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(335), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(335), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_layer_surface_v1_surface_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(93));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_surface_at _cffi_d_wlr_layer_surface_v1_surface_at
#endif

static struct wlr_layer_surface_v1 * _cffi_d_wlr_layer_surface_v1_try_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_layer_surface_v1_try_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_try_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_layer_surface_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_layer_surface_v1_try_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(335));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_try_from_wlr_surface _cffi_d_wlr_layer_surface_v1_try_from_wlr_surface
#endif

static struct libinput_device * _cffi_d_wlr_libinput_get_device_handle(struct wlr_input_device * x0)
{
  return wlr_libinput_get_device_handle(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_libinput_get_device_handle(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct libinput_device * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_libinput_get_device_handle(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1389));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_libinput_get_device_handle _cffi_d_wlr_libinput_get_device_handle
#endif

static struct wlr_linux_dmabuf_v1 * _cffi_d_wlr_linux_dmabuf_v1_create(struct wl_display * x0, uint32_t x1, struct wlr_linux_dmabuf_feedback_v1 const * x2)
{
  return wlr_linux_dmabuf_v1_create(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_linux_dmabuf_v1_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  uint32_t x1;
  struct wlr_linux_dmabuf_feedback_v1 const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_linux_dmabuf_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_linux_dmabuf_v1_create", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(258), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_linux_dmabuf_feedback_v1 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(258), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_linux_dmabuf_v1_create(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1482));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_linux_dmabuf_v1_create _cffi_d_wlr_linux_dmabuf_v1_create
#endif

static void _cffi_d_wlr_matrix_identity(float * x0)
{
  wlr_matrix_identity(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_identity(PyObject *self, PyObject *arg0)
{
  float * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_identity(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_identity _cffi_d_wlr_matrix_identity
#endif

static void _cffi_d_wlr_matrix_multiply(float * x0, float const * x1, float const * x2)
{
  wlr_matrix_multiply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_multiply(PyObject *self, PyObject *args)
{
  float * x0;
  float const * x1;
  float const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_multiply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_multiply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_multiply _cffi_d_wlr_matrix_multiply
#endif

static void _cffi_d_wlr_matrix_project_box(float * x0, struct wlr_box const * x1, enum wl_output_transform x2, float x3, float const * x4)
{
  wlr_matrix_project_box(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_project_box(PyObject *self, PyObject *args)
{
  float * x0;
  struct wlr_box const * x1;
  enum wl_output_transform x2;
  float x3;
  float const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_project_box", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(127), arg2) < 0)
    return NULL;

  x3 = (float)_cffi_to_c_float(arg3);
  if (x3 == (float)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_project_box(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_project_box _cffi_d_wlr_matrix_project_box
#endif

static void _cffi_d_wlr_matrix_rotate(float * x0, float x1)
{
  wlr_matrix_rotate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_rotate(PyObject *self, PyObject *args)
{
  float * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_rotate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_rotate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_rotate _cffi_d_wlr_matrix_rotate
#endif

static void _cffi_d_wlr_matrix_scale(float * x0, float x1, float x2)
{
  wlr_matrix_scale(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_scale(PyObject *self, PyObject *args)
{
  float * x0;
  float x1;
  float x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_scale", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_scale(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_scale _cffi_d_wlr_matrix_scale
#endif

static void _cffi_d_wlr_matrix_transform(float * x0, enum wl_output_transform x1)
{
  wlr_matrix_transform(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_transform(PyObject *self, PyObject *args)
{
  float * x0;
  enum wl_output_transform x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_transform", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(127), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_transform(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_transform _cffi_d_wlr_matrix_transform
#endif

static void _cffi_d_wlr_matrix_translate(float * x0, float x1, float x2)
{
  wlr_matrix_translate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_translate(PyObject *self, PyObject *args)
{
  float * x0;
  float x1;
  float x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_translate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_translate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_translate _cffi_d_wlr_matrix_translate
#endif

static void _cffi_d_wlr_matrix_transpose(float * x0, float const * x1)
{
  wlr_matrix_transpose(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_transpose(PyObject *self, PyObject *args)
{
  float * x0;
  float const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_transpose", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(562), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(562), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_transpose(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_transpose _cffi_d_wlr_matrix_transpose
#endif

static _Bool _cffi_d_wlr_output_attach_render(struct wlr_output * x0, int * x1)
{
  return wlr_output_attach_render(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_attach_render(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_attach_render", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_attach_render(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_attach_render _cffi_d_wlr_output_attach_render
#endif

static _Bool _cffi_d_wlr_output_commit(struct wlr_output * x0)
{
  return wlr_output_commit(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_commit(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_commit(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_commit _cffi_d_wlr_output_commit
#endif

static _Bool _cffi_d_wlr_output_commit_state(struct wlr_output * x0, struct wlr_output_state const * x1)
{
  return wlr_output_commit_state(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_commit_state(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct wlr_output_state const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_commit_state", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_state const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_commit_state(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_commit_state _cffi_d_wlr_output_commit_state
#endif

static struct wlr_output_configuration_head_v1 * _cffi_d_wlr_output_configuration_head_v1_create(struct wlr_output_configuration_v1 * x0, struct wlr_output * x1)
{
  return wlr_output_configuration_head_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_head_v1_create(PyObject *self, PyObject *args)
{
  struct wlr_output_configuration_v1 * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_configuration_head_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_configuration_head_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_configuration_head_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1485));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_configuration_head_v1_create _cffi_d_wlr_output_configuration_head_v1_create
#endif

static struct wlr_output_configuration_v1 * _cffi_d_wlr_output_configuration_v1_create(void)
{
  return wlr_output_configuration_v1_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_create(PyObject *self, PyObject *noarg)
{
  struct wlr_output_configuration_v1 * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_configuration_v1_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(271));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_create _cffi_d_wlr_output_configuration_v1_create
#endif

static void _cffi_d_wlr_output_configuration_v1_destroy(struct wlr_output_configuration_v1 * x0)
{
  wlr_output_configuration_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_output_configuration_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_configuration_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_destroy _cffi_d_wlr_output_configuration_v1_destroy
#endif

static void _cffi_d_wlr_output_configuration_v1_send_failed(struct wlr_output_configuration_v1 * x0)
{
  wlr_output_configuration_v1_send_failed(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_send_failed(PyObject *self, PyObject *arg0)
{
  struct wlr_output_configuration_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_configuration_v1_send_failed(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_send_failed _cffi_d_wlr_output_configuration_v1_send_failed
#endif

static void _cffi_d_wlr_output_configuration_v1_send_succeeded(struct wlr_output_configuration_v1 * x0)
{
  wlr_output_configuration_v1_send_succeeded(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_send_succeeded(PyObject *self, PyObject *arg0)
{
  struct wlr_output_configuration_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_configuration_v1_send_succeeded(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_send_succeeded _cffi_d_wlr_output_configuration_v1_send_succeeded
#endif

static void _cffi_d_wlr_output_create_global(struct wlr_output * x0)
{
  wlr_output_create_global(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_create_global(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_create_global(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_create_global _cffi_d_wlr_output_create_global
#endif

static void _cffi_d_wlr_output_destroy_global(struct wlr_output * x0)
{
  wlr_output_destroy_global(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_destroy_global(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_destroy_global(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_destroy_global _cffi_d_wlr_output_destroy_global
#endif

static void _cffi_d_wlr_output_effective_resolution(struct wlr_output * x0, int * x1, int * x2)
{
  wlr_output_effective_resolution(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_effective_resolution(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_effective_resolution", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_effective_resolution(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_effective_resolution _cffi_d_wlr_output_effective_resolution
#endif

static void _cffi_d_wlr_output_enable(struct wlr_output * x0, _Bool x1)
{
  wlr_output_enable(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_enable(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_enable", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_enable(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_enable _cffi_d_wlr_output_enable
#endif

static void _cffi_d_wlr_output_enable_adaptive_sync(struct wlr_output * x0, _Bool x1)
{
  wlr_output_enable_adaptive_sync(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_enable_adaptive_sync(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_enable_adaptive_sync", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_enable_adaptive_sync(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_enable_adaptive_sync _cffi_d_wlr_output_enable_adaptive_sync
#endif

static void _cffi_d_wlr_output_head_v1_state_apply(struct wlr_output_head_v1_state const * x0, struct wlr_output_state * x1)
{
  wlr_output_head_v1_state_apply(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_head_v1_state_apply(PyObject *self, PyObject *args)
{
  struct wlr_output_head_v1_state const * x0;
  struct wlr_output_state * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_head_v1_state_apply", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(785), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_head_v1_state const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(785), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_head_v1_state_apply(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_head_v1_state_apply _cffi_d_wlr_output_head_v1_state_apply
#endif

static _Bool _cffi_d_wlr_output_init_render(struct wlr_output * x0, struct wlr_allocator * x1, struct wlr_renderer * x2)
{
  return wlr_output_init_render(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_init_render(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct wlr_allocator * x1;
  struct wlr_renderer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_init_render", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(44), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_init_render(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_init_render _cffi_d_wlr_output_init_render
#endif

static _Bool _cffi_d_wlr_output_is_headless(struct wlr_output * x0)
{
  return wlr_output_is_headless(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_is_headless(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_is_headless(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_is_headless _cffi_d_wlr_output_is_headless
#endif

static struct wlr_output_layout_output * _cffi_d_wlr_output_layout_add(struct wlr_output_layout * x0, struct wlr_output * x1, int x2, int x3)
{
  return wlr_output_layout_add(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_add(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_layout_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_add", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_add(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1005));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_add _cffi_d_wlr_output_layout_add
#endif

static struct wlr_output_layout_output * _cffi_d_wlr_output_layout_add_auto(struct wlr_output_layout * x0, struct wlr_output * x1)
{
  return wlr_output_layout_add_auto(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_add_auto(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_layout_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_add_auto", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_add_auto(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1005));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_add_auto _cffi_d_wlr_output_layout_add_auto
#endif

static void _cffi_d_wlr_output_layout_closest_point(struct wlr_output_layout * x0, struct wlr_output * x1, double x2, double x3, double * x4, double * x5)
{
  wlr_output_layout_closest_point(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_closest_point(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  double x2;
  double x3;
  double * x4;
  double * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_closest_point", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_closest_point(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_closest_point _cffi_d_wlr_output_layout_closest_point
#endif

static struct wlr_output_layout * _cffi_d_wlr_output_layout_create(void)
{
  return wlr_output_layout_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_create(PyObject *self, PyObject *noarg)
{
  struct wlr_output_layout * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(266));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_create _cffi_d_wlr_output_layout_create
#endif

static void _cffi_d_wlr_output_layout_destroy(struct wlr_output_layout * x0)
{
  wlr_output_layout_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_output_layout * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_destroy _cffi_d_wlr_output_layout_destroy
#endif

static void _cffi_d_wlr_output_layout_get_box(struct wlr_output_layout * x0, struct wlr_output * x1, struct wlr_box * x2)
{
  wlr_output_layout_get_box(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_get_box(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  struct wlr_box * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_get_box", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_get_box(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_get_box _cffi_d_wlr_output_layout_get_box
#endif

static struct wlr_output * _cffi_d_wlr_output_layout_output_at(struct wlr_output_layout * x0, double x1, double x2)
{
  return wlr_output_layout_output_at(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_output_at(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_output_at", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_output_at(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(36));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_output_at _cffi_d_wlr_output_layout_output_at
#endif

static void _cffi_d_wlr_output_layout_output_coords(struct wlr_output_layout * x0, struct wlr_output * x1, double * x2, double * x3)
{
  wlr_output_layout_output_coords(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_output_coords(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  double * x2;
  double * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_output_coords", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_output_coords(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_output_coords _cffi_d_wlr_output_layout_output_coords
#endif

static void _cffi_d_wlr_output_layout_remove(struct wlr_output_layout * x0, struct wlr_output * x1)
{
  wlr_output_layout_remove(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_remove(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_remove", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_remove(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_remove _cffi_d_wlr_output_layout_remove
#endif

static struct wlr_output_manager_v1 * _cffi_d_wlr_output_manager_v1_create(struct wl_display * x0)
{
  return wlr_output_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(815));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_manager_v1_create _cffi_d_wlr_output_manager_v1_create
#endif

static void _cffi_d_wlr_output_manager_v1_set_configuration(struct wlr_output_manager_v1 * x0, struct wlr_output_configuration_v1 * x1)
{
  wlr_output_manager_v1_set_configuration(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_manager_v1_set_configuration(PyObject *self, PyObject *args)
{
  struct wlr_output_manager_v1 * x0;
  struct wlr_output_configuration_v1 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_manager_v1_set_configuration", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(815), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_manager_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(815), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(271), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(271), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_manager_v1_set_configuration(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_manager_v1_set_configuration _cffi_d_wlr_output_manager_v1_set_configuration
#endif

static struct wlr_output_power_manager_v1 * _cffi_d_wlr_output_power_manager_v1_create(struct wl_display * x0)
{
  return wlr_output_power_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_power_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_power_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_power_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1498));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_power_manager_v1_create _cffi_d_wlr_output_power_manager_v1_create
#endif

static struct wlr_output_mode * _cffi_d_wlr_output_preferred_mode(struct wlr_output * x0)
{
  return wlr_output_preferred_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_preferred_mode(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_mode * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_preferred_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(779));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_preferred_mode _cffi_d_wlr_output_preferred_mode
#endif

static void _cffi_d_wlr_output_render_software_cursors(struct wlr_output * x0, struct pixman_region32 * x1)
{
  wlr_output_render_software_cursors(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_render_software_cursors(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_render_software_cursors", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_render_software_cursors(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_render_software_cursors _cffi_d_wlr_output_render_software_cursors
#endif

static void _cffi_d_wlr_output_rollback(struct wlr_output * x0)
{
  wlr_output_rollback(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_rollback(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_rollback(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_rollback _cffi_d_wlr_output_rollback
#endif

static void _cffi_d_wlr_output_set_custom_mode(struct wlr_output * x0, int32_t x1, int32_t x2, int32_t x3)
{
  wlr_output_set_custom_mode(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_custom_mode(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int32_t x1;
  int32_t x2;
  int32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_custom_mode", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_custom_mode(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_custom_mode _cffi_d_wlr_output_set_custom_mode
#endif

static void _cffi_d_wlr_output_set_damage(struct wlr_output * x0, struct pixman_region32 * x1)
{
  wlr_output_set_damage(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_damage(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_damage", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_damage(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_damage _cffi_d_wlr_output_set_damage
#endif

static void _cffi_d_wlr_output_set_mode(struct wlr_output * x0, struct wlr_output_mode * x1)
{
  wlr_output_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_mode(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct wlr_output_mode * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(779), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_mode *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(779), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_mode _cffi_d_wlr_output_set_mode
#endif

static void _cffi_d_wlr_output_set_scale(struct wlr_output * x0, float x1)
{
  wlr_output_set_scale(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_scale(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_scale", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_scale(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_scale _cffi_d_wlr_output_set_scale
#endif

static void _cffi_d_wlr_output_set_transform(struct wlr_output * x0, enum wl_output_transform x1)
{
  wlr_output_set_transform(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_transform(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  enum wl_output_transform x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_transform", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(127), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_transform(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_transform _cffi_d_wlr_output_set_transform
#endif

static void _cffi_d_wlr_output_state_finish(struct wlr_output_state * x0)
{
  wlr_output_state_finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_finish(PyObject *self, PyObject *arg0)
{
  struct wlr_output_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_finish _cffi_d_wlr_output_state_finish
#endif

static void _cffi_d_wlr_output_state_init(struct wlr_output_state * x0)
{
  wlr_output_state_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_init(PyObject *self, PyObject *arg0)
{
  struct wlr_output_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_init _cffi_d_wlr_output_state_init
#endif

static void _cffi_d_wlr_output_state_set_adaptive_sync_enabled(struct wlr_output_state * x0, _Bool x1)
{
  wlr_output_state_set_adaptive_sync_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_adaptive_sync_enabled(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_adaptive_sync_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_adaptive_sync_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_adaptive_sync_enabled _cffi_d_wlr_output_state_set_adaptive_sync_enabled
#endif

static void _cffi_d_wlr_output_state_set_custom_mode(struct wlr_output_state * x0, int32_t x1, int32_t x2, int32_t x3)
{
  wlr_output_state_set_custom_mode(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_custom_mode(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  int32_t x1;
  int32_t x2;
  int32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_custom_mode", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_custom_mode(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_custom_mode _cffi_d_wlr_output_state_set_custom_mode
#endif

static void _cffi_d_wlr_output_state_set_enabled(struct wlr_output_state * x0, _Bool x1)
{
  wlr_output_state_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_enabled(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_enabled _cffi_d_wlr_output_state_set_enabled
#endif

static void _cffi_d_wlr_output_state_set_mode(struct wlr_output_state * x0, struct wlr_output_mode * x1)
{
  wlr_output_state_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_mode(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  struct wlr_output_mode * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(779), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_mode *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(779), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_mode _cffi_d_wlr_output_state_set_mode
#endif

static void _cffi_d_wlr_output_state_set_render_format(struct wlr_output_state * x0, uint32_t x1)
{
  wlr_output_state_set_render_format(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_render_format(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_render_format", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_render_format(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_render_format _cffi_d_wlr_output_state_set_render_format
#endif

static void _cffi_d_wlr_output_state_set_scale(struct wlr_output_state * x0, float x1)
{
  wlr_output_state_set_scale(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_scale(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_scale", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_scale(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_scale _cffi_d_wlr_output_state_set_scale
#endif

static void _cffi_d_wlr_output_state_set_subpixel(struct wlr_output_state * x0, enum wl_output_subpixel x1)
{
  wlr_output_state_set_subpixel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_subpixel(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  enum wl_output_subpixel x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_subpixel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(827), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_subpixel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_subpixel _cffi_d_wlr_output_state_set_subpixel
#endif

static void _cffi_d_wlr_output_state_set_transform(struct wlr_output_state * x0, enum wl_output_transform x1)
{
  wlr_output_state_set_transform(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_state_set_transform(PyObject *self, PyObject *args)
{
  struct wlr_output_state * x0;
  enum wl_output_transform x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_state_set_transform", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(786), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(786), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(127), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_state_set_transform(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_state_set_transform _cffi_d_wlr_output_state_set_transform
#endif

static _Bool _cffi_d_wlr_output_test(struct wlr_output * x0)
{
  return wlr_output_test(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_test(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_test(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_test _cffi_d_wlr_output_test
#endif

static _Bool _cffi_d_wlr_output_test_state(struct wlr_output * x0, struct wlr_output_state const * x1)
{
  return wlr_output_test_state(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_test_state(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct wlr_output_state const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_test_state", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_state const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_test_state(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_test_state _cffi_d_wlr_output_test_state
#endif

static enum wl_output_transform _cffi_d_wlr_output_transform_compose(enum wl_output_transform x0, enum wl_output_transform x1)
{
  return wlr_output_transform_compose(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_transform_compose(PyObject *self, PyObject *args)
{
  enum wl_output_transform x0;
  enum wl_output_transform x1;
  enum wl_output_transform result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_transform_compose", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(127), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(127), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_transform_compose(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(127));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_transform_compose _cffi_d_wlr_output_transform_compose
#endif

static enum wl_output_transform _cffi_d_wlr_output_transform_invert(enum wl_output_transform x0)
{
  return wlr_output_transform_invert(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_transform_invert(PyObject *self, PyObject *arg0)
{
  enum wl_output_transform x0;
  enum wl_output_transform result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(127), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_transform_invert(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(127));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_transform_invert _cffi_d_wlr_output_transform_invert
#endif

static void _cffi_d_wlr_output_transformed_resolution(struct wlr_output * x0, int * x1, int * x2)
{
  wlr_output_transformed_resolution(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_transformed_resolution(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_transformed_resolution", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_transformed_resolution(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_transformed_resolution _cffi_d_wlr_output_transformed_resolution
#endif

static void _cffi_d_wlr_pointer_constraint_v1_send_activated(struct wlr_pointer_constraint_v1 * x0)
{
  wlr_pointer_constraint_v1_send_activated(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraint_v1_send_activated(PyObject *self, PyObject *arg0)
{
  struct wlr_pointer_constraint_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(852), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraint_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(852), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_constraint_v1_send_activated(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_constraint_v1_send_activated _cffi_d_wlr_pointer_constraint_v1_send_activated
#endif

static void _cffi_d_wlr_pointer_constraint_v1_send_deactivated(struct wlr_pointer_constraint_v1 * x0)
{
  wlr_pointer_constraint_v1_send_deactivated(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraint_v1_send_deactivated(PyObject *self, PyObject *arg0)
{
  struct wlr_pointer_constraint_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(852), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraint_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(852), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_constraint_v1_send_deactivated(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_constraint_v1_send_deactivated _cffi_d_wlr_pointer_constraint_v1_send_deactivated
#endif

static struct wlr_pointer_constraint_v1 * _cffi_d_wlr_pointer_constraints_v1_constraint_for_surface(struct wlr_pointer_constraints_v1 * x0, struct wlr_surface * x1, struct wlr_seat * x2)
{
  return wlr_pointer_constraints_v1_constraint_for_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraints_v1_constraint_for_surface(PyObject *self, PyObject *args)
{
  struct wlr_pointer_constraints_v1 * x0;
  struct wlr_surface * x1;
  struct wlr_seat * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_pointer_constraint_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_constraints_v1_constraint_for_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(301), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraints_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(301), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_pointer_constraints_v1_constraint_for_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(852));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_pointer_constraints_v1_constraint_for_surface _cffi_d_wlr_pointer_constraints_v1_constraint_for_surface
#endif

static struct wlr_pointer_constraints_v1 * _cffi_d_wlr_pointer_constraints_v1_create(struct wl_display * x0)
{
  return wlr_pointer_constraints_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraints_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_pointer_constraints_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_pointer_constraints_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(301));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_pointer_constraints_v1_create _cffi_d_wlr_pointer_constraints_v1_create
#endif

static struct wlr_pointer * _cffi_d_wlr_pointer_from_input_device(struct wlr_input_device * x0)
{
  return wlr_pointer_from_input_device(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_from_input_device(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_pointer * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_pointer_from_input_device(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1503));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_pointer_from_input_device _cffi_d_wlr_pointer_from_input_device
#endif

static struct wlr_pointer_gestures_v1 * _cffi_d_wlr_pointer_gestures_v1_create(struct wl_display * x0)
{
  return wlr_pointer_gestures_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_pointer_gestures_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_pointer_gestures_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(855));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_create _cffi_d_wlr_pointer_gestures_v1_create
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_hold_begin(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, uint32_t x3)
{
  wlr_pointer_gestures_v1_send_hold_begin(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_hold_begin(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_hold_begin", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_hold_begin(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_hold_begin _cffi_d_wlr_pointer_gestures_v1_send_hold_begin
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_hold_end(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, _Bool x3)
{
  wlr_pointer_gestures_v1_send_hold_end(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_hold_end(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  _Bool x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_hold_end", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_hold_end(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_hold_end _cffi_d_wlr_pointer_gestures_v1_send_hold_end
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_pinch_begin(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, uint32_t x3)
{
  wlr_pointer_gestures_v1_send_pinch_begin(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_pinch_begin(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_pinch_begin", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_pinch_begin(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_pinch_begin _cffi_d_wlr_pointer_gestures_v1_send_pinch_begin
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_pinch_end(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, _Bool x3)
{
  wlr_pointer_gestures_v1_send_pinch_end(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_pinch_end(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  _Bool x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_pinch_end", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_pinch_end(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_pinch_end _cffi_d_wlr_pointer_gestures_v1_send_pinch_end
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_pinch_update(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, double x3, double x4, double x5, double x6)
{
  wlr_pointer_gestures_v1_send_pinch_update(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_pinch_update(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  double x3;
  double x4;
  double x5;
  double x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_pinch_update", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  x6 = (double)_cffi_to_c_double(arg6);
  if (x6 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_pinch_update(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_pinch_update _cffi_d_wlr_pointer_gestures_v1_send_pinch_update
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_swipe_begin(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, uint32_t x3)
{
  wlr_pointer_gestures_v1_send_swipe_begin(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_swipe_begin(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_swipe_begin", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_swipe_begin(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_swipe_begin _cffi_d_wlr_pointer_gestures_v1_send_swipe_begin
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_swipe_end(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, _Bool x3)
{
  wlr_pointer_gestures_v1_send_swipe_end(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_swipe_end(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  _Bool x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_swipe_end", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_swipe_end(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_swipe_end _cffi_d_wlr_pointer_gestures_v1_send_swipe_end
#endif

static void _cffi_d_wlr_pointer_gestures_v1_send_swipe_update(struct wlr_pointer_gestures_v1 * x0, struct wlr_seat * x1, uint32_t x2, double x3, double x4)
{
  wlr_pointer_gestures_v1_send_swipe_update(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_gestures_v1_send_swipe_update(PyObject *self, PyObject *args)
{
  struct wlr_pointer_gestures_v1 * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  double x3;
  double x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_gestures_v1_send_swipe_update", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(855), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_gestures_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(855), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_gestures_v1_send_swipe_update(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_gestures_v1_send_swipe_update _cffi_d_wlr_pointer_gestures_v1_send_swipe_update
#endif

static struct wlr_presentation * _cffi_d_wlr_presentation_create(struct wl_display * x0, struct wlr_backend * x1)
{
  return wlr_presentation_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_presentation_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_backend * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_presentation * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_presentation_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_presentation_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(910));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_presentation_create _cffi_d_wlr_presentation_create
#endif

static struct wlr_primary_selection_v1_device_manager * _cffi_d_wlr_primary_selection_v1_device_manager_create(struct wl_display * x0)
{
  return wlr_primary_selection_v1_device_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_primary_selection_v1_device_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_primary_selection_v1_device_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_primary_selection_v1_device_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1529));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_primary_selection_v1_device_manager_create _cffi_d_wlr_primary_selection_v1_device_manager_create
#endif

static void _cffi_d_wlr_region_transform(struct pixman_region32 * x0, struct pixman_region32 * x1, enum wl_output_transform x2, int x3, int x4)
{
  wlr_region_transform(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_region_transform(PyObject *self, PyObject *args)
{
  struct pixman_region32 * x0;
  struct pixman_region32 * x1;
  enum wl_output_transform x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_region_transform", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(127), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_region_transform(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_region_transform _cffi_d_wlr_region_transform
#endif

static struct wlr_relative_pointer_manager_v1 * _cffi_d_wlr_relative_pointer_manager_v1_create(struct wl_display * x0)
{
  return wlr_relative_pointer_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_relative_pointer_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_relative_pointer_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_relative_pointer_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(883));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_relative_pointer_manager_v1_create _cffi_d_wlr_relative_pointer_manager_v1_create
#endif

static void _cffi_d_wlr_relative_pointer_manager_v1_send_relative_motion(struct wlr_relative_pointer_manager_v1 * x0, struct wlr_seat * x1, uint64_t x2, double x3, double x4, double x5, double x6)
{
  wlr_relative_pointer_manager_v1_send_relative_motion(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_relative_pointer_manager_v1_send_relative_motion(PyObject *self, PyObject *args)
{
  struct wlr_relative_pointer_manager_v1 * x0;
  struct wlr_seat * x1;
  uint64_t x2;
  double x3;
  double x4;
  double x5;
  double x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "wlr_relative_pointer_manager_v1_send_relative_motion", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(883), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_relative_pointer_manager_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(883), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  x6 = (double)_cffi_to_c_double(arg6);
  if (x6 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_relative_pointer_manager_v1_send_relative_motion(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_relative_pointer_manager_v1_send_relative_motion _cffi_d_wlr_relative_pointer_manager_v1_send_relative_motion
#endif

static void _cffi_d_wlr_render_rect(struct wlr_renderer * x0, struct wlr_box const * x1, float const * x2, float const * x3)
{
  wlr_render_rect(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_render_rect(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_box const * x1;
  float const * x2;
  float const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_render_rect", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_render_rect(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_render_rect _cffi_d_wlr_render_rect
#endif

static _Bool _cffi_d_wlr_render_texture(struct wlr_renderer * x0, struct wlr_texture * x1, float const * x2, int x3, int x4, float x5)
{
  return wlr_render_texture(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_render_texture(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_texture * x1;
  float const * x2;
  int x3;
  int x4;
  float x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_render_texture", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (float)_cffi_to_c_float(arg5);
  if (x5 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_render_texture(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_render_texture _cffi_d_wlr_render_texture
#endif

static _Bool _cffi_d_wlr_render_texture_with_matrix(struct wlr_renderer * x0, struct wlr_texture * x1, float const * x2, float x3)
{
  return wlr_render_texture_with_matrix(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_render_texture_with_matrix(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_texture * x1;
  float const * x2;
  float x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_render_texture_with_matrix", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (float)_cffi_to_c_float(arg3);
  if (x3 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_render_texture_with_matrix(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_render_texture_with_matrix _cffi_d_wlr_render_texture_with_matrix
#endif

static struct wlr_renderer * _cffi_d_wlr_renderer_autocreate(struct wlr_backend * x0)
{
  return wlr_renderer_autocreate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_autocreate(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_renderer * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_autocreate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(45));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_autocreate _cffi_d_wlr_renderer_autocreate
#endif

static _Bool _cffi_d_wlr_renderer_begin(struct wlr_renderer * x0, int x1, int x2)
{
  return wlr_renderer_begin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_begin(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_begin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_begin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_begin _cffi_d_wlr_renderer_begin
#endif

static void _cffi_d_wlr_renderer_clear(struct wlr_renderer * x0, float const * x1)
{
  wlr_renderer_clear(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_clear(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  float const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_clear", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_clear(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_clear _cffi_d_wlr_renderer_clear
#endif

static void _cffi_d_wlr_renderer_destroy(struct wlr_renderer * x0)
{
  wlr_renderer_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_renderer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_destroy _cffi_d_wlr_renderer_destroy
#endif

static void _cffi_d_wlr_renderer_end(struct wlr_renderer * x0)
{
  wlr_renderer_end(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_end(PyObject *self, PyObject *arg0)
{
  struct wlr_renderer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_end(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_end _cffi_d_wlr_renderer_end
#endif

static uint32_t const * _cffi_d_wlr_renderer_get_shm_texture_formats(struct wlr_renderer * x0, size_t * x1)
{
  return wlr_renderer_get_shm_texture_formats(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_get_shm_texture_formats(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_get_shm_texture_formats", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_get_shm_texture_formats(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1668));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_get_shm_texture_formats _cffi_d_wlr_renderer_get_shm_texture_formats
#endif

static _Bool _cffi_d_wlr_renderer_init_wl_display(struct wlr_renderer * x0, struct wl_display * x1)
{
  return wlr_renderer_init_wl_display(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_init_wl_display(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wl_display * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_init_wl_display", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_init_wl_display(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_init_wl_display _cffi_d_wlr_renderer_init_wl_display
#endif

static void _cffi_d_wlr_renderer_scissor(struct wlr_renderer * x0, struct wlr_box * x1)
{
  wlr_renderer_scissor(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_scissor(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_scissor", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_scissor(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_scissor _cffi_d_wlr_renderer_scissor
#endif

static struct wlr_scene_output_layout * _cffi_d_wlr_scene_attach_output_layout(struct wlr_scene * x0, struct wlr_output_layout * x1)
{
  return wlr_scene_attach_output_layout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_attach_output_layout(PyObject *self, PyObject *args)
{
  struct wlr_scene * x0;
  struct wlr_output_layout * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_output_layout * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_attach_output_layout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(345), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(345), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_attach_output_layout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1004));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_attach_output_layout _cffi_d_wlr_scene_attach_output_layout
#endif

static struct wlr_scene_buffer * _cffi_d_wlr_scene_buffer_create(struct wlr_scene_tree * x0, struct wlr_buffer * x1)
{
  return wlr_scene_buffer_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  struct wlr_buffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_buffer * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_buffer_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_buffer_create _cffi_d_wlr_scene_buffer_create
#endif

static struct wlr_scene_buffer * _cffi_d_wlr_scene_buffer_from_node(struct wlr_scene_node * x0)
{
  return wlr_scene_buffer_from_node(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_from_node(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_buffer * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_buffer_from_node(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_buffer_from_node _cffi_d_wlr_scene_buffer_from_node
#endif

static void _cffi_d_wlr_scene_buffer_send_frame_done(struct wlr_scene_buffer * x0, struct timespec * x1)
{
  wlr_scene_buffer_send_frame_done(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_send_frame_done(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  struct timespec * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_send_frame_done", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(147), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(147), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_send_frame_done(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_send_frame_done _cffi_d_wlr_scene_buffer_send_frame_done
#endif

static void _cffi_d_wlr_scene_buffer_set_buffer(struct wlr_scene_buffer * x0, struct wlr_buffer * x1)
{
  wlr_scene_buffer_set_buffer(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_buffer(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  struct wlr_buffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_buffer", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_buffer(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_buffer _cffi_d_wlr_scene_buffer_set_buffer
#endif

static void _cffi_d_wlr_scene_buffer_set_buffer_with_damage(struct wlr_scene_buffer * x0, struct wlr_buffer * x1, struct pixman_region32 * x2)
{
  wlr_scene_buffer_set_buffer_with_damage(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_buffer_with_damage(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  struct wlr_buffer * x1;
  struct pixman_region32 * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_buffer_with_damage", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_buffer_with_damage(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_buffer_with_damage _cffi_d_wlr_scene_buffer_set_buffer_with_damage
#endif

static void _cffi_d_wlr_scene_buffer_set_dest_size(struct wlr_scene_buffer * x0, int x1, int x2)
{
  wlr_scene_buffer_set_dest_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_dest_size(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_dest_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_dest_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_dest_size _cffi_d_wlr_scene_buffer_set_dest_size
#endif

static void _cffi_d_wlr_scene_buffer_set_opacity(struct wlr_scene_buffer * x0, float x1)
{
  wlr_scene_buffer_set_opacity(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_opacity(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_opacity", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_opacity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_opacity _cffi_d_wlr_scene_buffer_set_opacity
#endif

static void _cffi_d_wlr_scene_buffer_set_opaque_region(struct wlr_scene_buffer * x0, struct pixman_region32 * x1)
{
  wlr_scene_buffer_set_opaque_region(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_opaque_region(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_opaque_region", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_opaque_region(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_opaque_region _cffi_d_wlr_scene_buffer_set_opaque_region
#endif

static void _cffi_d_wlr_scene_buffer_set_source_box(struct wlr_scene_buffer * x0, struct wlr_fbox const * x1)
{
  wlr_scene_buffer_set_source_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_source_box(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  struct wlr_fbox const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_source_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(950), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_fbox const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(950), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_source_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_source_box _cffi_d_wlr_scene_buffer_set_source_box
#endif

static void _cffi_d_wlr_scene_buffer_set_transform(struct wlr_scene_buffer * x0, enum wl_output_transform x1)
{
  wlr_scene_buffer_set_transform(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_buffer_set_transform(PyObject *self, PyObject *args)
{
  struct wlr_scene_buffer * x0;
  enum wl_output_transform x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_buffer_set_transform", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(127), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_buffer_set_transform(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_buffer_set_transform _cffi_d_wlr_scene_buffer_set_transform
#endif

static struct wlr_scene * _cffi_d_wlr_scene_create(void)
{
  return wlr_scene_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_create(PyObject *self, PyObject *noarg)
{
  struct wlr_scene * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(345));
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_create _cffi_d_wlr_scene_create
#endif

static struct wlr_scene_tree * _cffi_d_wlr_scene_drag_icon_create(struct wlr_scene_tree * x0, struct wlr_drag_icon * x1)
{
  return wlr_scene_drag_icon_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_drag_icon_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  struct wlr_drag_icon * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_tree * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_drag_icon_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(370), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_drag_icon *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(370), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_drag_icon_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(330));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_drag_icon_create _cffi_d_wlr_scene_drag_icon_create
#endif

static struct wlr_scene_output * _cffi_d_wlr_scene_get_scene_output(struct wlr_scene * x0, struct wlr_output * x1)
{
  return wlr_scene_get_scene_output(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_get_scene_output(PyObject *self, PyObject *args)
{
  struct wlr_scene * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_get_scene_output", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(345), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(345), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_get_scene_output(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(85));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_get_scene_output _cffi_d_wlr_scene_get_scene_output
#endif

static void _cffi_d_wlr_scene_layer_surface_v1_configure(struct wlr_scene_layer_surface_v1 * x0, struct wlr_box const * x1, struct wlr_box * x2)
{
  wlr_scene_layer_surface_v1_configure(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_layer_surface_v1_configure(PyObject *self, PyObject *args)
{
  struct wlr_scene_layer_surface_v1 * x0;
  struct wlr_box const * x1;
  struct wlr_box * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_layer_surface_v1_configure", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(953), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(953), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_layer_surface_v1_configure(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_layer_surface_v1_configure _cffi_d_wlr_scene_layer_surface_v1_configure
#endif

static struct wlr_scene_layer_surface_v1 * _cffi_d_wlr_scene_layer_surface_v1_create(struct wlr_scene_tree * x0, struct wlr_layer_surface_v1 * x1)
{
  return wlr_scene_layer_surface_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_layer_surface_v1_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  struct wlr_layer_surface_v1 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_layer_surface_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_layer_surface_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(335), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(335), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_layer_surface_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(953));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_layer_surface_v1_create _cffi_d_wlr_scene_layer_surface_v1_create
#endif

static struct wlr_scene_node * _cffi_d_wlr_scene_node_at(struct wlr_scene_node * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_scene_node_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_at(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_node * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_node_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(80));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_node_at _cffi_d_wlr_scene_node_at
#endif

static _Bool _cffi_d_wlr_scene_node_coords(struct wlr_scene_node * x0, int * x1, int * x2)
{
  return wlr_scene_node_coords(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_coords(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_coords", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_node_coords(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_node_coords _cffi_d_wlr_scene_node_coords
#endif

static void _cffi_d_wlr_scene_node_destroy(struct wlr_scene_node * x0)
{
  wlr_scene_node_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_destroy _cffi_d_wlr_scene_node_destroy
#endif

static void _cffi_d_wlr_scene_node_for_each_buffer(struct wlr_scene_node * x0, void(* x1)(struct wlr_scene_buffer *, int, int, void *), void * x2)
{
  wlr_scene_node_for_each_buffer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_for_each_buffer(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  void(* x1)(struct wlr_scene_buffer *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_for_each_buffer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_scene_buffer *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(983));
  if (x1 == (void(*)(struct wlr_scene_buffer *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_for_each_buffer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_for_each_buffer _cffi_d_wlr_scene_node_for_each_buffer
#endif

static void _cffi_d_wlr_scene_node_lower_to_bottom(struct wlr_scene_node * x0)
{
  wlr_scene_node_lower_to_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_lower_to_bottom(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_lower_to_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_lower_to_bottom _cffi_d_wlr_scene_node_lower_to_bottom
#endif

static void _cffi_d_wlr_scene_node_place_above(struct wlr_scene_node * x0, struct wlr_scene_node * x1)
{
  wlr_scene_node_place_above(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_place_above(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_scene_node * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_place_above", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_place_above(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_place_above _cffi_d_wlr_scene_node_place_above
#endif

static void _cffi_d_wlr_scene_node_place_below(struct wlr_scene_node * x0, struct wlr_scene_node * x1)
{
  wlr_scene_node_place_below(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_place_below(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_scene_node * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_place_below", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_place_below(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_place_below _cffi_d_wlr_scene_node_place_below
#endif

static void _cffi_d_wlr_scene_node_raise_to_top(struct wlr_scene_node * x0)
{
  wlr_scene_node_raise_to_top(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_raise_to_top(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_raise_to_top(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_raise_to_top _cffi_d_wlr_scene_node_raise_to_top
#endif

static void _cffi_d_wlr_scene_node_reparent(struct wlr_scene_node * x0, struct wlr_scene_tree * x1)
{
  wlr_scene_node_reparent(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_reparent(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_scene_tree * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_reparent", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_reparent(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_reparent _cffi_d_wlr_scene_node_reparent
#endif

static void _cffi_d_wlr_scene_node_set_enabled(struct wlr_scene_node * x0, _Bool x1)
{
  wlr_scene_node_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_set_enabled(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_set_enabled _cffi_d_wlr_scene_node_set_enabled
#endif

static void _cffi_d_wlr_scene_node_set_position(struct wlr_scene_node * x0, int x1, int x2)
{
  wlr_scene_node_set_position(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_set_position(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_set_position", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_set_position(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_set_position _cffi_d_wlr_scene_node_set_position
#endif

static _Bool _cffi_d_wlr_scene_output_commit(struct wlr_scene_output * x0, struct wlr_scene_output_state_options const * x1)
{
  return wlr_scene_output_commit(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_commit(PyObject *self, PyObject *args)
{
  struct wlr_scene_output * x0;
  struct wlr_scene_output_state_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_commit", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output_state_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_output_commit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_output_commit _cffi_d_wlr_scene_output_commit
#endif

static struct wlr_scene_output * _cffi_d_wlr_scene_output_create(struct wlr_scene * x0, struct wlr_output * x1)
{
  return wlr_scene_output_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_create(PyObject *self, PyObject *args)
{
  struct wlr_scene * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(345), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(345), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_output_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(85));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_output_create _cffi_d_wlr_scene_output_create
#endif

static void _cffi_d_wlr_scene_output_destroy(struct wlr_scene_output * x0)
{
  wlr_scene_output_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_output_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_output_destroy _cffi_d_wlr_scene_output_destroy
#endif

static void _cffi_d_wlr_scene_output_for_each_buffer(struct wlr_scene_output * x0, void(* x1)(struct wlr_scene_buffer *, int, int, void *), void * x2)
{
  wlr_scene_output_for_each_buffer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_for_each_buffer(PyObject *self, PyObject *args)
{
  struct wlr_scene_output * x0;
  void(* x1)(struct wlr_scene_buffer *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_for_each_buffer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_scene_buffer *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(983));
  if (x1 == (void(*)(struct wlr_scene_buffer *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_output_for_each_buffer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_output_for_each_buffer _cffi_d_wlr_scene_output_for_each_buffer
#endif

static void _cffi_d_wlr_scene_output_layout_add_output(struct wlr_scene_output_layout * x0, struct wlr_output_layout_output * x1, struct wlr_scene_output * x2)
{
  wlr_scene_output_layout_add_output(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_layout_add_output(PyObject *self, PyObject *args)
{
  struct wlr_scene_output_layout * x0;
  struct wlr_output_layout_output * x1;
  struct wlr_scene_output * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_layout_add_output", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1004), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1004), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1005), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1005), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_output_layout_add_output(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_output_layout_add_output _cffi_d_wlr_scene_output_layout_add_output
#endif

static void _cffi_d_wlr_scene_output_send_frame_done(struct wlr_scene_output * x0, struct timespec * x1)
{
  wlr_scene_output_send_frame_done(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_send_frame_done(PyObject *self, PyObject *args)
{
  struct wlr_scene_output * x0;
  struct timespec * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_send_frame_done", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(147), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(147), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_output_send_frame_done(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_output_send_frame_done _cffi_d_wlr_scene_output_send_frame_done
#endif

static void _cffi_d_wlr_scene_output_set_position(struct wlr_scene_output * x0, int x1, int x2)
{
  wlr_scene_output_set_position(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_set_position(PyObject *self, PyObject *args)
{
  struct wlr_scene_output * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_set_position", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_output_set_position(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_output_set_position _cffi_d_wlr_scene_output_set_position
#endif

static struct wlr_scene_rect * _cffi_d_wlr_scene_rect_create(struct wlr_scene_tree * x0, int x1, int x2, float const * x3)
{
  return wlr_scene_rect_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_rect_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  int x1;
  int x2;
  float const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_rect * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_scene_rect_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_rect_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1009));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_rect_create _cffi_d_wlr_scene_rect_create
#endif

static void _cffi_d_wlr_scene_rect_set_color(struct wlr_scene_rect * x0, float const * x1)
{
  wlr_scene_rect_set_color(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_rect_set_color(PyObject *self, PyObject *args)
{
  struct wlr_scene_rect * x0;
  float const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_rect_set_color", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1009), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_rect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1009), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_rect_set_color(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_rect_set_color _cffi_d_wlr_scene_rect_set_color
#endif

static void _cffi_d_wlr_scene_rect_set_size(struct wlr_scene_rect * x0, int x1, int x2)
{
  wlr_scene_rect_set_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_rect_set_size(PyObject *self, PyObject *args)
{
  struct wlr_scene_rect * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_rect_set_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1009), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_rect *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1009), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_rect_set_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_rect_set_size _cffi_d_wlr_scene_rect_set_size
#endif

static void _cffi_d_wlr_scene_set_presentation(struct wlr_scene * x0, struct wlr_presentation * x1)
{
  wlr_scene_set_presentation(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_set_presentation(PyObject *self, PyObject *args)
{
  struct wlr_scene * x0;
  struct wlr_presentation * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_set_presentation", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(345), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(345), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(910), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_presentation *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(910), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_set_presentation(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_set_presentation _cffi_d_wlr_scene_set_presentation
#endif

static struct wlr_scene_tree * _cffi_d_wlr_scene_subsurface_tree_create(struct wlr_scene_tree * x0, struct wlr_surface * x1)
{
  return wlr_scene_subsurface_tree_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_subsurface_tree_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_tree * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_subsurface_tree_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_subsurface_tree_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(330));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_subsurface_tree_create _cffi_d_wlr_scene_subsurface_tree_create
#endif

static void _cffi_d_wlr_scene_subsurface_tree_set_clip(struct wlr_scene_node * x0, struct wlr_box * x1)
{
  wlr_scene_subsurface_tree_set_clip(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_subsurface_tree_set_clip(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_subsurface_tree_set_clip", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_subsurface_tree_set_clip(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_subsurface_tree_set_clip _cffi_d_wlr_scene_subsurface_tree_set_clip
#endif

static struct wlr_scene_surface * _cffi_d_wlr_scene_surface_create(struct wlr_scene_tree * x0, struct wlr_surface * x1)
{
  return wlr_scene_surface_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_surface_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_surface_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_surface_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1542));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_surface_create _cffi_d_wlr_scene_surface_create
#endif

static struct wlr_scene_surface * _cffi_d_wlr_scene_surface_try_from_buffer(struct wlr_scene_buffer * x0)
{
  return wlr_scene_surface_try_from_buffer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_surface_try_from_buffer(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_buffer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_surface_try_from_buffer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1542));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_surface_try_from_buffer _cffi_d_wlr_scene_surface_try_from_buffer
#endif

static struct wlr_scene_tree * _cffi_d_wlr_scene_tree_create(struct wlr_scene_tree * x0)
{
  return wlr_scene_tree_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_tree_create(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_tree * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_tree * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_tree_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(330));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_tree_create _cffi_d_wlr_scene_tree_create
#endif

static struct wlr_scene_tree * _cffi_d_wlr_scene_xdg_surface_create(struct wlr_scene_tree * x0, struct wlr_xdg_surface * x1)
{
  return wlr_scene_xdg_surface_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_xdg_surface_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_tree * x0;
  struct wlr_xdg_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_tree * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_xdg_surface_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(330), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(330), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_xdg_surface_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(330));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_xdg_surface_create _cffi_d_wlr_scene_xdg_surface_create
#endif

static struct wlr_screencopy_manager_v1 * _cffi_d_wlr_screencopy_manager_v1_create(struct wl_display * x0)
{
  return wlr_screencopy_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_screencopy_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_screencopy_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_screencopy_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1547));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_screencopy_manager_v1_create _cffi_d_wlr_screencopy_manager_v1_create
#endif

static struct wlr_seat * _cffi_d_wlr_seat_create(struct wl_display * x0, char const * x1)
{
  return wlr_seat_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_seat * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_create _cffi_d_wlr_seat_create
#endif

static void _cffi_d_wlr_seat_destroy(struct wlr_seat * x0)
{
  wlr_seat_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_destroy _cffi_d_wlr_seat_destroy
#endif

static struct wlr_keyboard * _cffi_d_wlr_seat_get_keyboard(struct wlr_seat * x0)
{
  return wlr_seat_get_keyboard(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_get_keyboard(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_keyboard * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_get_keyboard(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(509));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_get_keyboard _cffi_d_wlr_seat_get_keyboard
#endif

static void _cffi_d_wlr_seat_keyboard_clear_focus(struct wlr_seat * x0)
{
  wlr_seat_keyboard_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_clear_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_clear_focus _cffi_d_wlr_seat_keyboard_clear_focus
#endif

static void _cffi_d_wlr_seat_keyboard_end_grab(struct wlr_seat * x0)
{
  wlr_seat_keyboard_end_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_end_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_end_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_end_grab _cffi_d_wlr_seat_keyboard_end_grab
#endif

static _Bool _cffi_d_wlr_seat_keyboard_has_grab(struct wlr_seat * x0)
{
  return wlr_seat_keyboard_has_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_has_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_keyboard_has_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_keyboard_has_grab _cffi_d_wlr_seat_keyboard_has_grab
#endif

static void _cffi_d_wlr_seat_keyboard_notify_enter(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t * x2, size_t x3, struct wlr_keyboard_modifiers * x4)
{
  wlr_seat_keyboard_notify_enter(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_notify_enter(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t * x2;
  size_t x3;
  struct wlr_keyboard_modifiers * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_notify_enter", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1040), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard_modifiers *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1040), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_notify_enter(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_notify_enter _cffi_d_wlr_seat_keyboard_notify_enter
#endif

static void _cffi_d_wlr_seat_keyboard_notify_key(struct wlr_seat * x0, uint32_t x1, uint32_t x2, uint32_t x3)
{
  wlr_seat_keyboard_notify_key(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_notify_key(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_notify_key", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_notify_key(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_notify_key _cffi_d_wlr_seat_keyboard_notify_key
#endif

static void _cffi_d_wlr_seat_keyboard_notify_modifiers(struct wlr_seat * x0, struct wlr_keyboard_modifiers * x1)
{
  wlr_seat_keyboard_notify_modifiers(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_notify_modifiers(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_keyboard_modifiers * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_notify_modifiers", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1040), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard_modifiers *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1040), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_notify_modifiers(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_notify_modifiers _cffi_d_wlr_seat_keyboard_notify_modifiers
#endif

static void _cffi_d_wlr_seat_keyboard_start_grab(struct wlr_seat * x0, struct wlr_seat_keyboard_grab * x1)
{
  wlr_seat_keyboard_start_grab(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_start_grab(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_seat_keyboard_grab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_start_grab", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1049), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat_keyboard_grab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1049), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_start_grab(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_start_grab _cffi_d_wlr_seat_keyboard_start_grab
#endif

static void _cffi_d_wlr_seat_pointer_clear_focus(struct wlr_seat * x0)
{
  wlr_seat_pointer_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_clear_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_clear_focus _cffi_d_wlr_seat_pointer_clear_focus
#endif

static void _cffi_d_wlr_seat_pointer_end_grab(struct wlr_seat * x0)
{
  wlr_seat_pointer_end_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_end_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_end_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_end_grab _cffi_d_wlr_seat_pointer_end_grab
#endif

static _Bool _cffi_d_wlr_seat_pointer_has_grab(struct wlr_seat * x0)
{
  return wlr_seat_pointer_has_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_has_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_pointer_has_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_pointer_has_grab _cffi_d_wlr_seat_pointer_has_grab
#endif

static void _cffi_d_wlr_seat_pointer_notify_axis(struct wlr_seat * x0, uint32_t x1, enum wlr_axis_orientation x2, double x3, int32_t x4, enum wlr_axis_source x5)
{
  wlr_seat_pointer_notify_axis(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_axis(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  enum wlr_axis_orientation x2;
  double x3;
  int32_t x4;
  enum wlr_axis_source x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_axis", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(1097), arg2) < 0)
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int32_t);
  if (x4 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(1100), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_axis(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_axis _cffi_d_wlr_seat_pointer_notify_axis
#endif

static uint32_t _cffi_d_wlr_seat_pointer_notify_button(struct wlr_seat * x0, uint32_t x1, uint32_t x2, enum wlr_button_state x3)
{
  return wlr_seat_pointer_notify_button(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_button(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  uint32_t x2;
  enum wlr_button_state x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_button", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(523), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_pointer_notify_button(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_button _cffi_d_wlr_seat_pointer_notify_button
#endif

static void _cffi_d_wlr_seat_pointer_notify_clear_focus(struct wlr_seat * x0)
{
  wlr_seat_pointer_notify_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_clear_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_clear_focus _cffi_d_wlr_seat_pointer_notify_clear_focus
#endif

static void _cffi_d_wlr_seat_pointer_notify_enter(struct wlr_seat * x0, struct wlr_surface * x1, double x2, double x3)
{
  wlr_seat_pointer_notify_enter(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_enter(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_enter", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_enter(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_enter _cffi_d_wlr_seat_pointer_notify_enter
#endif

static void _cffi_d_wlr_seat_pointer_notify_frame(struct wlr_seat * x0)
{
  wlr_seat_pointer_notify_frame(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_frame(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_frame(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_frame _cffi_d_wlr_seat_pointer_notify_frame
#endif

static void _cffi_d_wlr_seat_pointer_notify_motion(struct wlr_seat * x0, uint32_t x1, double x2, double x3)
{
  wlr_seat_pointer_notify_motion(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_motion(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_motion", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_motion(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_motion _cffi_d_wlr_seat_pointer_notify_motion
#endif

static void _cffi_d_wlr_seat_pointer_start_grab(struct wlr_seat * x0, struct wlr_seat_pointer_grab * x1)
{
  wlr_seat_pointer_start_grab(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_start_grab(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_seat_pointer_grab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_start_grab", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1053), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat_pointer_grab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1053), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_start_grab(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_start_grab _cffi_d_wlr_seat_pointer_start_grab
#endif

static _Bool _cffi_d_wlr_seat_pointer_surface_has_focus(struct wlr_seat * x0, struct wlr_surface * x1)
{
  return wlr_seat_pointer_surface_has_focus(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_surface_has_focus(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_surface_has_focus", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_pointer_surface_has_focus(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_pointer_surface_has_focus _cffi_d_wlr_seat_pointer_surface_has_focus
#endif

static void _cffi_d_wlr_seat_set_capabilities(struct wlr_seat * x0, uint32_t x1)
{
  wlr_seat_set_capabilities(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_capabilities(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_capabilities", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_capabilities(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_capabilities _cffi_d_wlr_seat_set_capabilities
#endif

static void _cffi_d_wlr_seat_set_keyboard(struct wlr_seat * x0, struct wlr_keyboard * x1)
{
  wlr_seat_set_keyboard(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_keyboard(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_keyboard * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_keyboard", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(509), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(509), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_keyboard(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_keyboard _cffi_d_wlr_seat_set_keyboard
#endif

static void _cffi_d_wlr_seat_set_name(struct wlr_seat * x0, char const * x1)
{
  wlr_seat_set_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_name(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_name _cffi_d_wlr_seat_set_name
#endif

static void _cffi_d_wlr_seat_set_primary_selection(struct wlr_seat * x0, struct wlr_primary_selection_source * x1, uint32_t x2)
{
  wlr_seat_set_primary_selection(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_primary_selection(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_primary_selection_source * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_primary_selection", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1044), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_primary_selection_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1044), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_primary_selection(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_primary_selection _cffi_d_wlr_seat_set_primary_selection
#endif

static void _cffi_d_wlr_seat_set_selection(struct wlr_seat * x0, struct wlr_data_source * x1, uint32_t x2)
{
  wlr_seat_set_selection(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_selection(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_data_source * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_selection", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(689), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_data_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(689), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_selection(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_selection _cffi_d_wlr_seat_set_selection
#endif

static void _cffi_d_wlr_seat_start_pointer_drag(struct wlr_seat * x0, struct wlr_drag * x1, uint32_t x2)
{
  wlr_seat_start_pointer_drag(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_start_pointer_drag(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_drag * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_start_pointer_drag", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1031), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_drag *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1031), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_start_pointer_drag(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_start_pointer_drag _cffi_d_wlr_seat_start_pointer_drag
#endif

static void _cffi_d_wlr_seat_touch_end_grab(struct wlr_seat * x0)
{
  wlr_seat_touch_end_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_end_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_end_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_end_grab _cffi_d_wlr_seat_touch_end_grab
#endif

static struct wlr_touch_point * _cffi_d_wlr_seat_touch_get_point(struct wlr_seat * x0, int32_t x1)
{
  return wlr_seat_touch_get_point(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_get_point(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  int32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_touch_point * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_get_point", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_touch_get_point(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1597));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_touch_get_point _cffi_d_wlr_seat_touch_get_point
#endif

static _Bool _cffi_d_wlr_seat_touch_has_grab(struct wlr_seat * x0)
{
  return wlr_seat_touch_has_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_has_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_touch_has_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_touch_has_grab _cffi_d_wlr_seat_touch_has_grab
#endif

static void _cffi_d_wlr_seat_touch_notify_cancel(struct wlr_seat * x0, struct wlr_surface * x1)
{
  wlr_seat_touch_notify_cancel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_cancel(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_cancel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_notify_cancel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_cancel _cffi_d_wlr_seat_touch_notify_cancel
#endif

static uint32_t _cffi_d_wlr_seat_touch_notify_down(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t x2, int32_t x3, double x4, double x5)
{
  return wlr_seat_touch_notify_down(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_down(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t x2;
  int32_t x3;
  double x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_down", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_touch_notify_down(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_down _cffi_d_wlr_seat_touch_notify_down
#endif

static void _cffi_d_wlr_seat_touch_notify_frame(struct wlr_seat * x0)
{
  wlr_seat_touch_notify_frame(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_frame(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_notify_frame(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_frame _cffi_d_wlr_seat_touch_notify_frame
#endif

static void _cffi_d_wlr_seat_touch_notify_motion(struct wlr_seat * x0, uint32_t x1, int32_t x2, double x3, double x4)
{
  wlr_seat_touch_notify_motion(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_motion(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  double x3;
  double x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_motion", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_notify_motion(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_motion _cffi_d_wlr_seat_touch_notify_motion
#endif

static void _cffi_d_wlr_seat_touch_notify_up(struct wlr_seat * x0, uint32_t x1, int32_t x2)
{
  wlr_seat_touch_notify_up(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_up(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_up", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_notify_up(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_up _cffi_d_wlr_seat_touch_notify_up
#endif

static int _cffi_d_wlr_seat_touch_num_points(struct wlr_seat * x0)
{
  return wlr_seat_touch_num_points(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_num_points(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_touch_num_points(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_touch_num_points _cffi_d_wlr_seat_touch_num_points
#endif

static void _cffi_d_wlr_seat_touch_point_clear_focus(struct wlr_seat * x0, uint32_t x1, int32_t x2)
{
  wlr_seat_touch_point_clear_focus(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_point_clear_focus(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_point_clear_focus", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_point_clear_focus(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_point_clear_focus _cffi_d_wlr_seat_touch_point_clear_focus
#endif

static void _cffi_d_wlr_seat_touch_point_focus(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t x2, int32_t x3, double x4, double x5)
{
  wlr_seat_touch_point_focus(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_point_focus(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t x2;
  int32_t x3;
  double x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_point_focus", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_point_focus(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_point_focus _cffi_d_wlr_seat_touch_point_focus
#endif

static void _cffi_d_wlr_seat_touch_send_cancel(struct wlr_seat * x0, struct wlr_surface * x1)
{
  wlr_seat_touch_send_cancel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_send_cancel(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_send_cancel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_send_cancel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_send_cancel _cffi_d_wlr_seat_touch_send_cancel
#endif

static uint32_t _cffi_d_wlr_seat_touch_send_down(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t x2, int32_t x3, double x4, double x5)
{
  return wlr_seat_touch_send_down(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_send_down(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t x2;
  int32_t x3;
  double x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_send_down", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_touch_send_down(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_touch_send_down _cffi_d_wlr_seat_touch_send_down
#endif

static void _cffi_d_wlr_seat_touch_send_frame(struct wlr_seat * x0)
{
  wlr_seat_touch_send_frame(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_send_frame(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_send_frame(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_send_frame _cffi_d_wlr_seat_touch_send_frame
#endif

static void _cffi_d_wlr_seat_touch_send_motion(struct wlr_seat * x0, uint32_t x1, int32_t x2, double x3, double x4)
{
  wlr_seat_touch_send_motion(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_send_motion(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  double x3;
  double x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_send_motion", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_send_motion(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_send_motion _cffi_d_wlr_seat_touch_send_motion
#endif

static void _cffi_d_wlr_seat_touch_send_up(struct wlr_seat * x0, uint32_t x1, int32_t x2)
{
  wlr_seat_touch_send_up(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_send_up(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_send_up", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_send_up(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_send_up _cffi_d_wlr_seat_touch_send_up
#endif

static void _cffi_d_wlr_seat_touch_start_grab(struct wlr_seat * x0, struct wlr_seat_touch_grab * x1)
{
  wlr_seat_touch_start_grab(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_start_grab(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_seat_touch_grab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_start_grab", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1057), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat_touch_grab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1057), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_start_grab(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_start_grab _cffi_d_wlr_seat_touch_start_grab
#endif

static _Bool _cffi_d_wlr_seat_validate_pointer_grab_serial(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t x2)
{
  return wlr_seat_validate_pointer_grab_serial(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_validate_pointer_grab_serial(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_validate_pointer_grab_serial", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_validate_pointer_grab_serial(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_validate_pointer_grab_serial _cffi_d_wlr_seat_validate_pointer_grab_serial
#endif

static struct wlr_server_decoration_manager * _cffi_d_wlr_server_decoration_manager_create(struct wl_display * x0)
{
  return wlr_server_decoration_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_server_decoration_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_server_decoration_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_server_decoration_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_server_decoration_manager_create _cffi_d_wlr_server_decoration_manager_create
#endif

static void _cffi_d_wlr_server_decoration_manager_set_default_mode(struct wlr_server_decoration_manager * x0, uint32_t x1)
{
  wlr_server_decoration_manager_set_default_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_server_decoration_manager_set_default_mode(PyObject *self, PyObject *args)
{
  struct wlr_server_decoration_manager * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_server_decoration_manager_set_default_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_server_decoration_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_server_decoration_manager_set_default_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_server_decoration_manager_set_default_mode _cffi_d_wlr_server_decoration_manager_set_default_mode
#endif

static _Bool _cffi_d_wlr_session_change_vt(struct wlr_session * x0, unsigned int x1)
{
  return wlr_session_change_vt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_change_vt(PyObject *self, PyObject *args)
{
  struct wlr_session * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_session_change_vt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_session *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_session_change_vt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_session_change_vt _cffi_d_wlr_session_change_vt
#endif

static struct wlr_session_lock_manager_v1 * _cffi_d_wlr_session_lock_manager_v1_create(struct wl_display * x0)
{
  return wlr_session_lock_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_lock_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_session_lock_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_session_lock_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1566));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_session_lock_manager_v1_create _cffi_d_wlr_session_lock_manager_v1_create
#endif

static uint32_t _cffi_d_wlr_session_lock_surface_v1_configure(struct wlr_session_lock_surface_v1 * x0, uint32_t x1, uint32_t x2)
{
  return wlr_session_lock_surface_v1_configure(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_lock_surface_v1_configure(PyObject *self, PyObject *args)
{
  struct wlr_session_lock_surface_v1 * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_session_lock_surface_v1_configure", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(526), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_session_lock_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(526), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_session_lock_surface_v1_configure(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_session_lock_surface_v1_configure _cffi_d_wlr_session_lock_surface_v1_configure
#endif

static struct wlr_session_lock_surface_v1 * _cffi_d_wlr_session_lock_surface_v1_try_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_session_lock_surface_v1_try_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_lock_surface_v1_try_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_session_lock_surface_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_session_lock_surface_v1_try_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(526));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_session_lock_surface_v1_try_from_wlr_surface _cffi_d_wlr_session_lock_surface_v1_try_from_wlr_surface
#endif

static void _cffi_d_wlr_session_lock_v1_destroy(struct wlr_session_lock_v1 * x0)
{
  wlr_session_lock_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_lock_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_session_lock_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_session_lock_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_session_lock_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_session_lock_v1_destroy _cffi_d_wlr_session_lock_v1_destroy
#endif

static void _cffi_d_wlr_session_lock_v1_send_locked(struct wlr_session_lock_v1 * x0)
{
  wlr_session_lock_v1_send_locked(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_lock_v1_send_locked(PyObject *self, PyObject *arg0)
{
  struct wlr_session_lock_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_session_lock_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_session_lock_v1_send_locked(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_session_lock_v1_send_locked _cffi_d_wlr_session_lock_v1_send_locked
#endif

static struct wlr_single_pixel_buffer_manager_v1 * _cffi_d_wlr_single_pixel_buffer_manager_v1_create(struct wl_display * x0)
{
  return wlr_single_pixel_buffer_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_single_pixel_buffer_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_single_pixel_buffer_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_single_pixel_buffer_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1572));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_single_pixel_buffer_manager_v1_create _cffi_d_wlr_single_pixel_buffer_manager_v1_create
#endif

static struct wlr_subcompositor * _cffi_d_wlr_subcompositor_create(struct wl_display * x0)
{
  return wlr_subcompositor_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_subcompositor_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_subcompositor * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_subcompositor_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1574));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_subcompositor_create _cffi_d_wlr_subcompositor_create
#endif

static _Bool _cffi_d_wlr_surface_accepts_touch(struct wlr_seat * x0, struct wlr_surface * x1)
{
  return wlr_surface_accepts_touch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_accepts_touch(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_accepts_touch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_accepts_touch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_accepts_touch _cffi_d_wlr_surface_accepts_touch
#endif

static void _cffi_d_wlr_surface_for_each_surface(struct wlr_surface * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_surface_for_each_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_for_each_surface(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_surface_for_each_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(744));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_for_each_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_for_each_surface _cffi_d_wlr_surface_for_each_surface
#endif

static struct wlr_surface * _cffi_d_wlr_surface_from_resource(struct wl_resource * x0)
{
  return wlr_surface_from_resource(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_from_resource(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_from_resource(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(93));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_from_resource _cffi_d_wlr_surface_from_resource
#endif

static void _cffi_d_wlr_surface_get_buffer_source_box(struct wlr_surface * x0, struct wlr_fbox * x1)
{
  wlr_surface_get_buffer_source_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_buffer_source_box(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_fbox * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_get_buffer_source_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_fbox *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_get_buffer_source_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_get_buffer_source_box _cffi_d_wlr_surface_get_buffer_source_box
#endif

static void _cffi_d_wlr_surface_get_effective_damage(struct wlr_surface * x0, struct pixman_region32 * x1)
{
  wlr_surface_get_effective_damage(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_effective_damage(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_get_effective_damage", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_get_effective_damage(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_get_effective_damage _cffi_d_wlr_surface_get_effective_damage
#endif

static void _cffi_d_wlr_surface_get_extends(struct wlr_surface * x0, struct wlr_box * x1)
{
  wlr_surface_get_extends(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_extends(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_get_extends", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_get_extends(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_get_extends _cffi_d_wlr_surface_get_extends
#endif

static struct wlr_surface * _cffi_d_wlr_surface_get_root_surface(struct wlr_surface * x0)
{
  return wlr_surface_get_root_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_root_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_get_root_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(93));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_get_root_surface _cffi_d_wlr_surface_get_root_surface
#endif

static struct wlr_texture * _cffi_d_wlr_surface_get_texture(struct wlr_surface * x0)
{
  return wlr_surface_get_texture(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_texture(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_texture * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_get_texture(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(62));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_get_texture _cffi_d_wlr_surface_get_texture
#endif

static _Bool _cffi_d_wlr_surface_has_buffer(struct wlr_surface * x0)
{
  return wlr_surface_has_buffer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_has_buffer(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_has_buffer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_has_buffer _cffi_d_wlr_surface_has_buffer
#endif

static uint32_t _cffi_d_wlr_surface_lock_pending(struct wlr_surface * x0)
{
  return wlr_surface_lock_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_lock_pending(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_lock_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_lock_pending _cffi_d_wlr_surface_lock_pending
#endif

static _Bool _cffi_d_wlr_surface_point_accepts_input(struct wlr_surface * x0, double x1, double x2)
{
  return wlr_surface_point_accepts_input(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_point_accepts_input(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_surface_point_accepts_input", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_point_accepts_input(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_point_accepts_input _cffi_d_wlr_surface_point_accepts_input
#endif

static void _cffi_d_wlr_surface_send_enter(struct wlr_surface * x0, struct wlr_output * x1)
{
  wlr_surface_send_enter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_send_enter(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_send_enter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_send_enter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_send_enter _cffi_d_wlr_surface_send_enter
#endif

static void _cffi_d_wlr_surface_send_frame_done(struct wlr_surface * x0, struct timespec const * x1)
{
  wlr_surface_send_frame_done(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_send_frame_done(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct timespec const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_send_frame_done", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_send_frame_done(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_send_frame_done _cffi_d_wlr_surface_send_frame_done
#endif

static void _cffi_d_wlr_surface_send_leave(struct wlr_surface * x0, struct wlr_output * x1)
{
  wlr_surface_send_leave(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_send_leave(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_send_leave", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_send_leave(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_send_leave _cffi_d_wlr_surface_send_leave
#endif

static _Bool _cffi_d_wlr_surface_set_role(struct wlr_surface * x0, struct wlr_surface_role const * x1, struct wl_resource * x2, uint32_t x3)
{
  return wlr_surface_set_role(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_set_role(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_surface_role const * x1;
  struct wl_resource * x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_surface_set_role", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface_role const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_set_role(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_set_role _cffi_d_wlr_surface_set_role
#endif

static struct wlr_surface * _cffi_d_wlr_surface_surface_at(struct wlr_surface * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_surface_surface_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_surface_at(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_surface_surface_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_surface_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(93));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_surface_at _cffi_d_wlr_surface_surface_at
#endif

static void _cffi_d_wlr_surface_unlock_cached(struct wlr_surface * x0, uint32_t x1)
{
  wlr_surface_unlock_cached(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_unlock_cached(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_unlock_cached", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_unlock_cached(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_unlock_cached _cffi_d_wlr_surface_unlock_cached
#endif

static struct wlr_switch * _cffi_d_wlr_switch_from_input_device(struct wlr_input_device * x0)
{
  return wlr_switch_from_input_device(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_switch_from_input_device(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_switch * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_switch_from_input_device(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1584));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_switch_from_input_device _cffi_d_wlr_switch_from_input_device
#endif

static void _cffi_d_wlr_texture_destroy(struct wlr_texture * x0)
{
  wlr_texture_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_texture * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_texture_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_texture_destroy _cffi_d_wlr_texture_destroy
#endif

static struct wlr_texture * _cffi_d_wlr_texture_from_buffer(struct wlr_renderer * x0, struct wlr_buffer * x1)
{
  return wlr_texture_from_buffer(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_from_buffer(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_buffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_texture * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_texture_from_buffer", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_texture_from_buffer(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(62));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_texture_from_buffer _cffi_d_wlr_texture_from_buffer
#endif

static struct wlr_texture * _cffi_d_wlr_texture_from_pixels(struct wlr_renderer * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, void const * x5)
{
  return wlr_texture_from_pixels(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_from_pixels(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  void const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_texture * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_texture_from_pixels", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(164), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(164), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_texture_from_pixels(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(62));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_texture_from_pixels _cffi_d_wlr_texture_from_pixels
#endif

static _Bool _cffi_d_wlr_texture_update_from_buffer(struct wlr_texture * x0, struct wlr_buffer * x1, struct pixman_region32 * x2)
{
  return wlr_texture_update_from_buffer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_update_from_buffer(PyObject *self, PyObject *args)
{
  struct wlr_texture * x0;
  struct wlr_buffer * x1;
  struct pixman_region32 * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_texture_update_from_buffer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_buffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_texture_update_from_buffer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_texture_update_from_buffer _cffi_d_wlr_texture_update_from_buffer
#endif

static struct wlr_touch * _cffi_d_wlr_touch_from_input_device(struct wlr_input_device * x0)
{
  return wlr_touch_from_input_device(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_touch_from_input_device(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_touch * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_touch_from_input_device(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_touch_from_input_device _cffi_d_wlr_touch_from_input_device
#endif

static struct wlr_viewporter * _cffi_d_wlr_viewporter_create(struct wl_display * x0)
{
  return wlr_viewporter_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_viewporter_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_viewporter * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_viewporter_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1600));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_viewporter_create _cffi_d_wlr_viewporter_create
#endif

static struct wlr_virtual_keyboard_manager_v1 * _cffi_d_wlr_virtual_keyboard_manager_v1_create(struct wl_display * x0)
{
  return wlr_virtual_keyboard_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_virtual_keyboard_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_virtual_keyboard_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_virtual_keyboard_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1602));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_virtual_keyboard_manager_v1_create _cffi_d_wlr_virtual_keyboard_manager_v1_create
#endif

static struct wlr_virtual_pointer_manager_v1 * _cffi_d_wlr_virtual_pointer_manager_v1_create(struct wl_display * x0)
{
  return wlr_virtual_pointer_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_virtual_pointer_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_virtual_pointer_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_virtual_pointer_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1606));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_virtual_pointer_manager_v1_create _cffi_d_wlr_virtual_pointer_manager_v1_create
#endif

static struct wlr_xcursor_manager * _cffi_d_wlr_xcursor_manager_create(char const * x0, uint32_t x1)
{
  return wlr_xcursor_manager_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_create(PyObject *self, PyObject *args)
{
  char const * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xcursor_manager * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xcursor_manager_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(153));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xcursor_manager_create _cffi_d_wlr_xcursor_manager_create
#endif

static void _cffi_d_wlr_xcursor_manager_destroy(struct wlr_xcursor_manager * x0)
{
  wlr_xcursor_manager_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xcursor_manager * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xcursor_manager_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xcursor_manager_destroy _cffi_d_wlr_xcursor_manager_destroy
#endif

static struct wlr_xcursor * _cffi_d_wlr_xcursor_manager_get_xcursor(struct wlr_xcursor_manager * x0, char const * x1, float x2)
{
  return wlr_xcursor_manager_get_xcursor(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_get_xcursor(PyObject *self, PyObject *args)
{
  struct wlr_xcursor_manager * x0;
  char const * x1;
  float x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xcursor * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_get_xcursor", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xcursor_manager_get_xcursor(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1611));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xcursor_manager_get_xcursor _cffi_d_wlr_xcursor_manager_get_xcursor
#endif

static int _cffi_d_wlr_xcursor_manager_load(struct wlr_xcursor_manager * x0, float x1)
{
  return wlr_xcursor_manager_load(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_load(PyObject *self, PyObject *args)
{
  struct wlr_xcursor_manager * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_load", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xcursor_manager_load(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xcursor_manager_load _cffi_d_wlr_xcursor_manager_load
#endif

static struct wlr_xdg_activation_v1 * _cffi_d_wlr_xdg_activation_v1_create(struct wl_display * x0)
{
  return wlr_xdg_activation_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_activation_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_activation_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_activation_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1619));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_activation_v1_create _cffi_d_wlr_xdg_activation_v1_create
#endif

static struct wlr_xdg_decoration_manager_v1 * _cffi_d_wlr_xdg_decoration_manager_v1_create(struct wl_display * x0)
{
  return wlr_xdg_decoration_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_decoration_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_decoration_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_decoration_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1624));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_decoration_manager_v1_create _cffi_d_wlr_xdg_decoration_manager_v1_create
#endif

static struct wlr_xdg_output_manager_v1 * _cffi_d_wlr_xdg_output_manager_v1_create(struct wl_display * x0, struct wlr_output_layout * x1)
{
  return wlr_xdg_output_manager_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_output_manager_v1_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_output_layout * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_output_manager_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_output_manager_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(266), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(266), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_output_manager_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1626));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_output_manager_v1_create _cffi_d_wlr_xdg_output_manager_v1_create
#endif

static void _cffi_d_wlr_xdg_popup_destroy(struct wlr_xdg_popup * x0)
{
  wlr_xdg_popup_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_popup_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_popup * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1176), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_popup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1176), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_popup_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_popup_destroy _cffi_d_wlr_xdg_popup_destroy
#endif

static void _cffi_d_wlr_xdg_popup_unconstrain_from_box(struct wlr_xdg_popup * x0, struct wlr_box const * x1)
{
  wlr_xdg_popup_unconstrain_from_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_popup_unconstrain_from_box(PyObject *self, PyObject *args)
{
  struct wlr_xdg_popup * x0;
  struct wlr_box const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_popup_unconstrain_from_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1176), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_popup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1176), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_popup_unconstrain_from_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_popup_unconstrain_from_box _cffi_d_wlr_xdg_popup_unconstrain_from_box
#endif

static struct wlr_xdg_shell * _cffi_d_wlr_xdg_shell_create(struct wl_display * x0, uint32_t x1)
{
  return wlr_xdg_shell_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_shell_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_shell * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_shell_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_shell_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1632));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_shell_create _cffi_d_wlr_xdg_shell_create
#endif

static void _cffi_d_wlr_xdg_surface_for_each_popup_surface(struct wlr_xdg_surface * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_xdg_surface_for_each_popup_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_for_each_popup_surface(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_for_each_popup_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(744));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_for_each_popup_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_for_each_popup_surface _cffi_d_wlr_xdg_surface_for_each_popup_surface
#endif

static void _cffi_d_wlr_xdg_surface_for_each_surface(struct wlr_xdg_surface * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_xdg_surface_for_each_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_for_each_surface(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_for_each_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(744));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_for_each_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_for_each_surface _cffi_d_wlr_xdg_surface_for_each_surface
#endif

static void _cffi_d_wlr_xdg_surface_get_geometry(struct wlr_xdg_surface * x0, struct wlr_box * x1)
{
  wlr_xdg_surface_get_geometry(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_get_geometry(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_get_geometry", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_get_geometry(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_get_geometry _cffi_d_wlr_xdg_surface_get_geometry
#endif

static void _cffi_d_wlr_xdg_surface_ping(struct wlr_xdg_surface * x0)
{
  wlr_xdg_surface_ping(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_ping(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_ping(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_ping _cffi_d_wlr_xdg_surface_ping
#endif

static uint32_t _cffi_d_wlr_xdg_surface_schedule_configure(struct wlr_xdg_surface * x0)
{
  return wlr_xdg_surface_schedule_configure(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_schedule_configure(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_surface_schedule_configure(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_surface_schedule_configure _cffi_d_wlr_xdg_surface_schedule_configure
#endif

static struct wlr_surface * _cffi_d_wlr_xdg_surface_surface_at(struct wlr_xdg_surface * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_xdg_surface_surface_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_surface_at(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_surface_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(76), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_surface_surface_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(93));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_surface_surface_at _cffi_d_wlr_xdg_surface_surface_at
#endif

static struct wlr_xdg_surface * _cffi_d_wlr_xdg_surface_try_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_xdg_surface_try_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_try_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_surface_try_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(378));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_surface_try_from_wlr_surface _cffi_d_wlr_xdg_surface_try_from_wlr_surface
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_decoration_v1_set_mode(struct wlr_xdg_toplevel_decoration_v1 * x0, enum wlr_xdg_toplevel_decoration_v1_mode x1)
{
  return wlr_xdg_toplevel_decoration_v1_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_decoration_v1_set_mode(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel_decoration_v1 * x0;
  enum wlr_xdg_toplevel_decoration_v1_mode x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_decoration_v1_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(550), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel_decoration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(550), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(551), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_decoration_v1_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_decoration_v1_set_mode _cffi_d_wlr_xdg_toplevel_decoration_v1_set_mode
#endif

static void _cffi_d_wlr_xdg_toplevel_send_close(struct wlr_xdg_toplevel * x0)
{
  wlr_xdg_toplevel_send_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_send_close(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_toplevel * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_toplevel_send_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_send_close _cffi_d_wlr_xdg_toplevel_send_close
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_activated(struct wlr_xdg_toplevel * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_activated(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_activated(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_activated", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_activated(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_activated _cffi_d_wlr_xdg_toplevel_set_activated
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_bounds(struct wlr_xdg_toplevel * x0, int32_t x1, int32_t x2)
{
  return wlr_xdg_toplevel_set_bounds(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_bounds(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  int32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_bounds", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_bounds(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_bounds _cffi_d_wlr_xdg_toplevel_set_bounds
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_fullscreen(struct wlr_xdg_toplevel * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_fullscreen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_fullscreen(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_fullscreen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_fullscreen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_fullscreen _cffi_d_wlr_xdg_toplevel_set_fullscreen
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_maximized(struct wlr_xdg_toplevel * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_maximized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_maximized(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_maximized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_maximized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_maximized _cffi_d_wlr_xdg_toplevel_set_maximized
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_resizing(struct wlr_xdg_toplevel * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_resizing(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_resizing(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_resizing", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_resizing(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_resizing _cffi_d_wlr_xdg_toplevel_set_resizing
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_size(struct wlr_xdg_toplevel * x0, int32_t x1, int32_t x2)
{
  return wlr_xdg_toplevel_set_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_size(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  int32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_size _cffi_d_wlr_xdg_toplevel_set_size
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_tiled(struct wlr_xdg_toplevel * x0, uint32_t x1)
{
  return wlr_xdg_toplevel_set_tiled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_tiled(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_tiled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_tiled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_tiled _cffi_d_wlr_xdg_toplevel_set_tiled
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_wm_capabilities(struct wlr_xdg_toplevel * x0, uint32_t x1)
{
  return wlr_xdg_toplevel_set_wm_capabilities(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_wm_capabilities(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_wm_capabilities", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_wm_capabilities(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_wm_capabilities _cffi_d_wlr_xdg_toplevel_set_wm_capabilities
#endif

static struct wlr_xwayland * _cffi_d_wlr_xwayland_create(struct wl_display * x0, struct wlr_compositor * x1, _Bool x2)
{
  return wlr_xwayland_create(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_compositor * x1;
  _Bool x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xwayland * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_create", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(494), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_compositor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(494), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (_Bool)_cffi_to_c__Bool(arg2);
  if (x2 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_create(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1198));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_create _cffi_d_wlr_xwayland_create
#endif

static void _cffi_d_wlr_xwayland_destroy(struct wlr_xwayland * x0)
{
  wlr_xwayland_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_destroy _cffi_d_wlr_xwayland_destroy
#endif

static enum wlr_xwayland_icccm_input_model _cffi_d_wlr_xwayland_icccm_input_model(struct wlr_xwayland_surface const * x0)
{
  return wlr_xwayland_icccm_input_model(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_icccm_input_model(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum wlr_xwayland_icccm_input_model result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(124), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_icccm_input_model(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(1288));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_icccm_input_model _cffi_d_wlr_xwayland_icccm_input_model
#endif

static _Bool _cffi_d_wlr_xwayland_or_surface_wants_focus(struct wlr_xwayland_surface const * x0)
{
  return wlr_xwayland_or_surface_wants_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_or_surface_wants_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(124), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_or_surface_wants_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_or_surface_wants_focus _cffi_d_wlr_xwayland_or_surface_wants_focus
#endif

static struct wlr_xwayland_server * _cffi_d_wlr_xwayland_server_create(struct wl_display * x0, struct wlr_xwayland_server_options * x1)
{
  return wlr_xwayland_server_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_server_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_xwayland_server_options * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xwayland_server * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_server_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(499), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_server_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(499), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_server_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1214));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_server_create _cffi_d_wlr_xwayland_server_create
#endif

static void _cffi_d_wlr_xwayland_server_destroy(struct wlr_xwayland_server * x0)
{
  wlr_xwayland_server_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_server_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1214), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1214), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_server_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_server_destroy _cffi_d_wlr_xwayland_server_destroy
#endif

static void _cffi_d_wlr_xwayland_set_cursor(struct wlr_xwayland * x0, uint8_t * x1, uint32_t x2, uint32_t x3, uint32_t x4, int32_t x5, int32_t x6)
{
  wlr_xwayland_set_cursor(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_set_cursor(PyObject *self, PyObject *args)
{
  struct wlr_xwayland * x0;
  uint8_t * x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  int32_t x5;
  int32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_set_cursor", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1206), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1206), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int32_t);
  if (x5 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int32_t);
  if (x6 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_set_cursor(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_set_cursor _cffi_d_wlr_xwayland_set_cursor
#endif

static void _cffi_d_wlr_xwayland_set_seat(struct wlr_xwayland * x0, struct wlr_seat * x1)
{
  wlr_xwayland_set_seat(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_set_seat(PyObject *self, PyObject *args)
{
  struct wlr_xwayland * x0;
  struct wlr_seat * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_set_seat", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1198), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1198), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_set_seat(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_set_seat _cffi_d_wlr_xwayland_set_seat
#endif

static void _cffi_d_wlr_xwayland_surface_activate(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_activate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_activate(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_activate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_activate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_activate _cffi_d_wlr_xwayland_surface_activate
#endif

static void _cffi_d_wlr_xwayland_surface_close(struct wlr_xwayland_surface * x0)
{
  wlr_xwayland_surface_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_close(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_close _cffi_d_wlr_xwayland_surface_close
#endif

static void _cffi_d_wlr_xwayland_surface_configure(struct wlr_xwayland_surface * x0, int16_t x1, int16_t x2, uint16_t x3, uint16_t x4)
{
  wlr_xwayland_surface_configure(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_configure(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  int16_t x1;
  int16_t x2;
  uint16_t x3;
  uint16_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_configure", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int16_t);
  if (x1 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int16_t);
  if (x2 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint16_t);
  if (x3 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_configure(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_configure _cffi_d_wlr_xwayland_surface_configure
#endif

static void _cffi_d_wlr_xwayland_surface_ping(struct wlr_xwayland_surface * x0)
{
  wlr_xwayland_surface_ping(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_ping(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_ping(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_ping _cffi_d_wlr_xwayland_surface_ping
#endif

static void _cffi_d_wlr_xwayland_surface_restack(struct wlr_xwayland_surface * x0, struct wlr_xwayland_surface * x1, enum xcb_stack_mode_t x2)
{
  wlr_xwayland_surface_restack(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_restack(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  struct wlr_xwayland_surface * x1;
  enum xcb_stack_mode_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_restack", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(1233), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_restack(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_restack _cffi_d_wlr_xwayland_surface_restack
#endif

static void _cffi_d_wlr_xwayland_surface_set_fullscreen(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_set_fullscreen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_set_fullscreen(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_set_fullscreen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_set_fullscreen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_set_fullscreen _cffi_d_wlr_xwayland_surface_set_fullscreen
#endif

static void _cffi_d_wlr_xwayland_surface_set_maximized(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_set_maximized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_set_maximized(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_set_maximized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_set_maximized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_set_maximized _cffi_d_wlr_xwayland_surface_set_maximized
#endif

static void _cffi_d_wlr_xwayland_surface_set_minimized(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_set_minimized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_set_minimized(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_set_minimized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1217), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1217), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_set_minimized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_set_minimized _cffi_d_wlr_xwayland_surface_set_minimized
#endif

static struct wlr_xwayland_surface * _cffi_d_wlr_xwayland_surface_try_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_xwayland_surface_try_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_try_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xwayland_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(93), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_surface_try_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1217));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_surface_try_from_wlr_surface _cffi_d_wlr_xwayland_surface_try_from_wlr_surface
#endif

static void _cffi_d_wrapped_log_init(enum wlr_log_importance x0, void(* x1)(enum wlr_log_importance, char const *))
{
  wrapped_log_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wrapped_log_init(PyObject *self, PyObject *args)
{
  enum wlr_log_importance x0;
  void(* x1)(enum wlr_log_importance, char const *);
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wrapped_log_init", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(554), arg0) < 0)
    return NULL;

  x1 = (void(*)(enum wlr_log_importance, char const *))_cffi_to_c_pointer(arg1, _cffi_type(559));
  if (x1 == (void(*)(enum wlr_log_importance, char const *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wrapped_log_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wrapped_log_init _cffi_d_wrapped_log_init
#endif

static xcb_connection_t * _cffi_d_xcb_connect(char const * x0, int * x1)
{
  return xcb_connect(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_connect(PyObject *self, PyObject *args)
{
  char const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  xcb_connection_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xcb_connect", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_connect(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(171));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xcb_connect _cffi_d_xcb_connect
#endif

static int _cffi_d_xcb_connection_has_error(xcb_connection_t * x0)
{
  return xcb_connection_has_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_connection_has_error(PyObject *self, PyObject *arg0)
{
  xcb_connection_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_connection_has_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xcb_connection_has_error _cffi_d_xcb_connection_has_error
#endif

static void _cffi_d_xcb_disconnect(xcb_connection_t * x0)
{
  xcb_disconnect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_disconnect(PyObject *self, PyObject *arg0)
{
  xcb_connection_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xcb_disconnect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xcb_disconnect _cffi_d_xcb_disconnect
#endif

static xcb_intern_atom_cookie_t _cffi_d_xcb_intern_atom(xcb_connection_t * x0, uint8_t x1, uint16_t x2, char const * x3)
{
  return xcb_intern_atom(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_intern_atom(PyObject *self, PyObject *args)
{
  xcb_connection_t * x0;
  uint8_t x1;
  uint16_t x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  xcb_intern_atom_cookie_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "xcb_intern_atom", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint8_t);
  if (x1 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint16_t);
  if (x2 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(385), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(385), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_intern_atom(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(1258));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_xcb_intern_atom(xcb_intern_atom_cookie_t *result, xcb_connection_t * x0, uint8_t x1, uint16_t x2, char const * x3)
{
  { *result = xcb_intern_atom(x0, x1, x2, x3); }
}
#endif

static xcb_intern_atom_reply_t * _cffi_d_xcb_intern_atom_reply(xcb_connection_t * x0, xcb_intern_atom_cookie_t x1, xcb_generic_error_t * * x2)
{
  return xcb_intern_atom_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_intern_atom_reply(PyObject *self, PyObject *args)
{
  xcb_connection_t * x0;
  xcb_intern_atom_cookie_t x1;
  xcb_generic_error_t * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  xcb_intern_atom_reply_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xcb_intern_atom_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(171), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(171), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(1258), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1259), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (xcb_generic_error_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1259), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_intern_atom_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1694));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static xcb_intern_atom_reply_t * _cffi_f_xcb_intern_atom_reply(xcb_connection_t * x0, xcb_intern_atom_cookie_t *x1, xcb_generic_error_t * * x2)
{
  xcb_intern_atom_reply_t * result;
  { result = xcb_intern_atom_reply(x0, *x1, x2); }
  return result;
}
#endif

static int _cffi_const_CLOCK_MONOTONIC(unsigned long long *o)
{
  int n = (CLOCK_MONOTONIC) <= 0;
  *o = (unsigned long long)((CLOCK_MONOTONIC) | 0);  /* check that CLOCK_MONOTONIC is an integer */
  return n;
}

static int _cffi_const_WLR_KEYBOARD_KEYS_CAP(unsigned long long *o)
{
  int n = (WLR_KEYBOARD_KEYS_CAP) <= 0;
  *o = (unsigned long long)((WLR_KEYBOARD_KEYS_CAP) | 0);  /* check that WLR_KEYBOARD_KEYS_CAP is an integer */
  if (!_cffi_check_int(*o, n, 32U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_LED_COUNT(unsigned long long *o)
{
  int n = (WLR_LED_COUNT) <= 0;
  *o = (unsigned long long)((WLR_LED_COUNT) | 0);  /* check that WLR_LED_COUNT is an integer */
  if (!_cffi_check_int(*o, n, 3U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_MODIFIER_COUNT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_COUNT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_COUNT) | 0);  /* check that WLR_MODIFIER_COUNT is an integer */
  if (!_cffi_check_int(*o, n, 8U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_POINTER_BUTTONS_CAP(unsigned long long *o)
{
  int n = (WLR_POINTER_BUTTONS_CAP) <= 0;
  *o = (unsigned long long)((WLR_POINTER_BUTTONS_CAP) | 0);  /* check that WLR_POINTER_BUTTONS_CAP is an integer */
  if (!_cffi_check_int(*o, n, 16U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_VERSION_MAJOR(unsigned long long *o)
{
  int n = (WLR_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((WLR_VERSION_MAJOR) | 0);  /* check that WLR_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_WLR_VERSION_MICRO(unsigned long long *o)
{
  int n = (WLR_VERSION_MICRO) <= 0;
  *o = (unsigned long long)((WLR_VERSION_MICRO) | 0);  /* check that WLR_VERSION_MICRO is an integer */
  return n;
}

static int _cffi_const_WLR_VERSION_MINOR(unsigned long long *o)
{
  int n = (WLR_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((WLR_VERSION_MINOR) | 0);  /* check that WLR_VERSION_MINOR is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_pixman_box32(struct pixman_box32 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x1) | 0);  /* check that 'struct pixman_box32.x1' is an integer */
  (void)((p->y1) | 0);  /* check that 'struct pixman_box32.y1' is an integer */
  (void)((p->x2) | 0);  /* check that 'struct pixman_box32.x2' is an integer */
  (void)((p->y2) | 0);  /* check that 'struct pixman_box32.y2' is an integer */
}
struct _cffi_align_struct_pixman_box32 { char x; struct pixman_box32 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_pixman_region32(struct pixman_region32 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_pixman_region32 { char x; struct pixman_region32 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_timespec(struct timespec *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->tv_sec) | 0);  /* check that 'struct timespec.tv_sec' is an integer */
  (void)((p->tv_nsec) | 0);  /* check that 'struct timespec.tv_nsec' is an integer */
}
struct _cffi_align_struct_timespec { char x; struct timespec y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_array(struct wl_array *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->size) | 0);  /* check that 'struct wl_array.size' is an integer */
  (void)((p->alloc) | 0);  /* check that 'struct wl_array.alloc' is an integer */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wl_array { char x; struct wl_array y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_interface(struct wl_interface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->version) | 0);  /* check that 'struct wl_interface.version' is an integer */
  (void)((p->method_count) | 0);  /* check that 'struct wl_interface.method_count' is an integer */
  { struct wl_message const * *tmp = &p->methods; (void)tmp; }
  (void)((p->event_count) | 0);  /* check that 'struct wl_interface.event_count' is an integer */
  { struct wl_message const * *tmp = &p->events; (void)tmp; }
}
struct _cffi_align_struct_wl_interface { char x; struct wl_interface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_list(struct wl_list *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list * *tmp = &p->prev; (void)tmp; }
  { struct wl_list * *tmp = &p->next; (void)tmp; }
}
struct _cffi_align_struct_wl_list { char x; struct wl_list y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener(struct wl_listener *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { void(* *tmp)(struct wl_listener *, void *) = &p->notify; (void)tmp; }
}
struct _cffi_align_struct_wl_listener { char x; struct wl_listener y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener_container(struct wl_listener_container *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->handle; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy_listener; (void)tmp; }
}
struct _cffi_align_struct_wl_listener_container { char x; struct wl_listener_container y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_message(struct wl_message *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { char const * *tmp = &p->signature; (void)tmp; }
  { struct wl_interface const * * *tmp = &p->types; (void)tmp; }
}
struct _cffi_align_struct_wl_message { char x; struct wl_message y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_signal(struct wl_signal *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->listener_list; (void)tmp; }
}
struct _cffi_align_struct_wl_signal { char x; struct wl_signal y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_addon(struct wlr_addon *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_addon_interface const * *tmp = &p->impl; (void)tmp; }
}
struct _cffi_align_struct_wlr_addon { char x; struct wlr_addon y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_addon_set(struct wlr_addon_set *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->addons; (void)tmp; }
}
struct _cffi_align_struct_wlr_addon_set { char x; struct wlr_addon_set y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_allocator(struct wlr_allocator *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_allocator { char x; struct wlr_allocator y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_backend(struct wlr_backend *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_backend_impl const * *tmp = &p->impl; (void)tmp; }
  /* cannot generate 'struct $1' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_backend { char x; struct wlr_backend y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_box(struct wlr_box *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_box.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_box.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_box.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_box.height' is an integer */
}
struct _cffi_align_struct_wlr_box { char x; struct wlr_box y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_buffer(struct wlr_buffer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_buffer { char x; struct wlr_buffer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_compositor(struct wlr_compositor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $3' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_compositor { char x; struct wlr_compositor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_cursor(struct wlr_cursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_cursor_state * *tmp = &p->state; (void)tmp; }
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  /* cannot generate 'struct $2' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_cursor { char x; struct wlr_cursor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_damage_ring(struct wlr_damage_ring *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->width) | 0);  /* check that 'struct wlr_damage_ring.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_damage_ring.height' is an integer */
  { struct pixman_region32 *tmp = &p->current; (void)tmp; }
}
struct _cffi_align_struct_wlr_damage_ring { char x; struct wlr_damage_ring y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_data_control_manager_v1(struct wlr_data_control_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->devices; (void)tmp; }
  /* cannot generate 'struct $6' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_data_control_manager_v1 { char x; struct wlr_data_control_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_data_source(struct wlr_data_source *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_data_source_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wl_array *tmp = &p->mime_types; (void)tmp; }
  (void)((p->actions) | 0);  /* check that 'struct wlr_data_source.actions' is an integer */
  (void)((p->accepted) | 0);  /* check that 'struct wlr_data_source.accepted' is an integer */
  { enum wl_data_device_manager_dnd_action *tmp = &p->current_dnd_action; (void)tmp; }
  (void)((p->compositor_action) | 0);  /* check that 'struct wlr_data_source.compositor_action' is an integer */
  /* cannot generate 'struct $9' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_data_source { char x; struct wlr_data_source y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag(struct wlr_drag *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_drag_grab_type *tmp = &p->grab_type; (void)tmp; }
  { struct wlr_seat_keyboard_grab *tmp = &p->keyboard_grab; (void)tmp; }
  { struct wlr_seat_pointer_grab *tmp = &p->pointer_grab; (void)tmp; }
  { struct wlr_seat_touch_grab *tmp = &p->touch_grab; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat_client; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focus_client; (void)tmp; }
  { struct wlr_drag_icon * *tmp = &p->icon; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focus; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->source; (void)tmp; }
  (void)((p->started) | 0);  /* check that 'struct wlr_drag.started' is an integer */
  (void)((p->dropped) | 0);  /* check that 'struct wlr_drag.dropped' is an integer */
  (void)((p->cancelling) | 0);  /* check that 'struct wlr_drag.cancelling' is an integer */
  (void)((p->grab_touch_id) | 0);  /* check that 'struct wlr_drag.grab_touch_id' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_drag.touch_id' is an integer */
  /* cannot generate 'struct $8' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_client_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->icon_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag { char x; struct wlr_drag y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_drop_event(struct wlr_drag_drop_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  (void)((p->time) | 0);  /* check that 'struct wlr_drag_drop_event.time' is an integer */
}
struct _cffi_align_struct_wlr_drag_drop_event { char x; struct wlr_drag_drop_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_icon(struct wlr_drag_icon *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  /* cannot generate 'struct $7' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag_icon { char x; struct wlr_drag_icon y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_motion_event(struct wlr_drag_motion_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  (void)((p->time) | 0);  /* check that 'struct wlr_drag_motion_event.time' is an integer */
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag_motion_event { char x; struct wlr_drag_motion_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drm_format(struct wlr_drm_format *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_drm_format { char x; struct wlr_drm_format y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drm_format_set(struct wlr_drm_format_set *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_drm_format_set { char x; struct wlr_drm_format_set y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_export_dmabuf_frame_v1(struct wlr_export_dmabuf_frame_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_export_dmabuf_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  (void)((p->cursor_locked) | 0);  /* check that 'struct wlr_export_dmabuf_frame_v1.cursor_locked' is an integer */
  { struct wl_listener *tmp = &p->output_commit; (void)tmp; }
}
struct _cffi_align_struct_wlr_export_dmabuf_frame_v1 { char x; struct wlr_export_dmabuf_frame_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_export_dmabuf_manager_v1(struct wlr_export_dmabuf_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->frames; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $10' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_export_dmabuf_manager_v1 { char x; struct wlr_export_dmabuf_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_fbox(struct wlr_fbox *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  { double *tmp = &p->width; (void)tmp; }
  { double *tmp = &p->height; (void)tmp; }
}
struct _cffi_align_struct_wlr_fbox { char x; struct wlr_fbox y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1(struct wlr_foreign_toplevel_handle_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_source; (void)tmp; }
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  (void)((p->state) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1.state' is an integer */
  /* cannot generate 'struct $13' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1 { char x; struct wlr_foreign_toplevel_handle_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_activated_event(struct wlr_foreign_toplevel_handle_v1_activated_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_activated_event { char x; struct wlr_foreign_toplevel_handle_v1_activated_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event(struct wlr_foreign_toplevel_handle_v1_fullscreen_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_fullscreen_event.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event { char x; struct wlr_foreign_toplevel_handle_v1_fullscreen_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_maximized_event(struct wlr_foreign_toplevel_handle_v1_maximized_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->maximized) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_maximized_event.maximized' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_maximized_event { char x; struct wlr_foreign_toplevel_handle_v1_maximized_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_minimized_event(struct wlr_foreign_toplevel_handle_v1_minimized_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->minimized) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_minimized_event.minimized' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_minimized_event { char x; struct wlr_foreign_toplevel_handle_v1_minimized_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.height' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event { char x; struct wlr_foreign_toplevel_handle_v1_set_rectangle_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_manager_v1(struct wlr_foreign_toplevel_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_event_loop * *tmp = &p->event_loop; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->toplevels; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $12' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_manager_v1 { char x; struct wlr_foreign_toplevel_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_fractional_scale_manager_v1(struct wlr_fractional_scale_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  /* cannot generate 'struct $14' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_fractional_scale_manager_v1 { char x; struct wlr_fractional_scale_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_gamma_control_manager_v1(struct wlr_gamma_control_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->controls; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $15' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_gamma_control_manager_v1 { char x; struct wlr_gamma_control_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_inhibit_manager_v1(struct wlr_idle_inhibit_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->inhibitors; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $16' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_inhibit_manager_v1 { char x; struct wlr_idle_inhibit_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_inhibitor_v1(struct wlr_idle_inhibitor_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $17' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_inhibitor_v1 { char x; struct wlr_idle_inhibitor_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_input_device(struct wlr_input_device *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_input_device_type *tmp = &p->type; (void)tmp; }
  (void)((p->vendor) | 0);  /* check that 'struct wlr_input_device.vendor' is an integer */
  (void)((p->product) | 0);  /* check that 'struct wlr_input_device.product' is an integer */
  { char * *tmp = &p->name; (void)tmp; }
  /* cannot generate 'struct $18' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_input_device { char x; struct wlr_input_device y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_input_inhibit_manager(struct wlr_input_inhibit_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_client * *tmp = &p->active_client; (void)tmp; }
  { struct wl_resource * *tmp = &p->active_inhibitor; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $19' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_input_inhibit_manager { char x; struct wlr_input_inhibit_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard(struct wlr_keyboard *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device *tmp = &p->base; (void)tmp; }
  { struct wlr_keyboard_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wlr_keyboard_group * *tmp = &p->group; (void)tmp; }
  { char * *tmp = &p->keymap_string; (void)tmp; }
  (void)((p->keymap_size) | 0);  /* check that 'struct wlr_keyboard.keymap_size' is an integer */
  (void)((p->keymap_fd) | 0);  /* check that 'struct wlr_keyboard.keymap_fd' is an integer */
  { struct xkb_keymap * *tmp = &p->keymap; (void)tmp; }
  { struct xkb_state * *tmp = &p->xkb_state; (void)tmp; }
  { uint32_t(*tmp)[3] = &p->led_indexes; (void)tmp; }
  { uint32_t(*tmp)[8] = &p->mod_indexes; (void)tmp; }
  (void)((p->leds) | 0);  /* check that 'struct wlr_keyboard.leds' is an integer */
  { uint32_t(*tmp)[32] = &p->keycodes; (void)tmp; }
  (void)((p->num_keycodes) | 0);  /* check that 'struct wlr_keyboard.num_keycodes' is an integer */
  { struct wlr_keyboard_modifiers *tmp = &p->modifiers; (void)tmp; }
  /* cannot generate 'struct $20' in field 'repeat_info': unknown type name */
  /* cannot generate 'struct $21' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_keyboard { char x; struct wlr_keyboard y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard_key_event(struct wlr_keyboard_key_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_keyboard_key_event.time_msec' is an integer */
  (void)((p->keycode) | 0);  /* check that 'struct wlr_keyboard_key_event.keycode' is an integer */
  (void)((p->update_state) | 0);  /* check that 'struct wlr_keyboard_key_event.update_state' is an integer */
  { enum wl_keyboard_key_state *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_keyboard_key_event { char x; struct wlr_keyboard_key_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard_modifiers(struct wlr_keyboard_modifiers *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->depressed) | 0);  /* check that 'struct wlr_keyboard_modifiers.depressed' is an integer */
  (void)((p->latched) | 0);  /* check that 'struct wlr_keyboard_modifiers.latched' is an integer */
  (void)((p->locked) | 0);  /* check that 'struct wlr_keyboard_modifiers.locked' is an integer */
  (void)((p->group) | 0);  /* check that 'struct wlr_keyboard_modifiers.group' is an integer */
}
struct _cffi_align_struct_wlr_keyboard_modifiers { char x; struct wlr_keyboard_modifiers y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_shell_v1(struct wlr_layer_shell_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $62' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_shell_v1 { char x; struct wlr_layer_shell_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_surface_v1(struct wlr_layer_surface_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_layer_shell_v1 * *tmp = &p->shell; (void)tmp; }
  { struct wl_list *tmp = &p->popups; (void)tmp; }
  { char * *tmp = &p->namespace; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_layer_surface_v1.added' is an integer */
  (void)((p->configured) | 0);  /* check that 'struct wlr_layer_surface_v1.configured' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_layer_surface_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_layer_surface_v1_state *tmp = &p->pending; (void)tmp; }
  /* cannot generate 'struct $64' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_surface_v1 { char x; struct wlr_layer_surface_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_surface_v1_state(struct wlr_layer_surface_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->anchor) | 0);  /* check that 'struct wlr_layer_surface_v1_state.anchor' is an integer */
  (void)((p->exclusive_zone) | 0);  /* check that 'struct wlr_layer_surface_v1_state.exclusive_zone' is an integer */
  /* cannot generate 'struct $63' in field 'margin': unknown type name */
  { enum zwlr_layer_surface_v1_keyboard_interactivity *tmp = &p->keyboard_interactive; (void)tmp; }
  (void)((p->desired_width) | 0);  /* check that 'struct wlr_layer_surface_v1_state.desired_width' is an integer */
  (void)((p->desired_height) | 0);  /* check that 'struct wlr_layer_surface_v1_state.desired_height' is an integer */
  (void)((p->actual_width) | 0);  /* check that 'struct wlr_layer_surface_v1_state.actual_width' is an integer */
  (void)((p->actual_height) | 0);  /* check that 'struct wlr_layer_surface_v1_state.actual_height' is an integer */
  { enum zwlr_layer_shell_v1_layer *tmp = &p->layer; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_surface_v1_state { char x; struct wlr_layer_surface_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output(struct wlr_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wlr_backend * *tmp = &p->backend; (void)tmp; }
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  { char * *tmp = &p->description; (void)tmp; }
  { char * *tmp = &p->make; (void)tmp; }
  { char * *tmp = &p->model; (void)tmp; }
  { char * *tmp = &p->serial; (void)tmp; }
  (void)((p->phys_width) | 0);  /* check that 'struct wlr_output.phys_width' is an integer */
  (void)((p->phys_height) | 0);  /* check that 'struct wlr_output.phys_height' is an integer */
  { struct wl_list *tmp = &p->modes; (void)tmp; }
  { struct wlr_output_mode * *tmp = &p->current_mode; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_output.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_output.height' is an integer */
  (void)((p->refresh) | 0);  /* check that 'struct wlr_output.refresh' is an integer */
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output.enabled' is an integer */
  { float *tmp = &p->scale; (void)tmp; }
  { enum wl_output_subpixel *tmp = &p->subpixel; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  { enum wlr_output_adaptive_sync_status *tmp = &p->adaptive_sync_status; (void)tmp; }
  (void)((p->render_format) | 0);  /* check that 'struct wlr_output.render_format' is an integer */
  (void)((p->needs_frame) | 0);  /* check that 'struct wlr_output.needs_frame' is an integer */
  (void)((p->frame_pending) | 0);  /* check that 'struct wlr_output.frame_pending' is an integer */
  { float(*tmp)[9] = &p->transform_matrix; (void)tmp; }
  (void)((p->non_desktop) | 0);  /* check that 'struct wlr_output.non_desktop' is an integer */
  { struct wlr_output_state *tmp = &p->pending; (void)tmp; }
  (void)((p->commit_seq) | 0);  /* check that 'struct wlr_output.commit_seq' is an integer */
  /* cannot generate 'struct $23' in field 'events': unknown type name */
  { struct wl_event_source * *tmp = &p->idle_frame; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_done; (void)tmp; }
  (void)((p->attach_render_locks) | 0);  /* check that 'struct wlr_output.attach_render_locks' is an integer */
  { struct wl_list *tmp = &p->cursors; (void)tmp; }
  { struct wlr_output_cursor * *tmp = &p->hardware_cursor; (void)tmp; }
  { struct wlr_swapchain * *tmp = &p->cursor_swapchain; (void)tmp; }
  { struct wlr_buffer * *tmp = &p->cursor_front_buffer; (void)tmp; }
  (void)((p->software_cursor_locks) | 0);  /* check that 'struct wlr_output.software_cursor_locks' is an integer */
  { struct wlr_allocator * *tmp = &p->allocator; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wlr_swapchain * *tmp = &p->swapchain; (void)tmp; }
  { struct wlr_buffer * *tmp = &p->back_buffer; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wlr_addon_set *tmp = &p->addons; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output { char x; struct wlr_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_configuration_head_v1(struct wlr_output_configuration_head_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output_head_v1_state *tmp = &p->state; (void)tmp; }
  { struct wlr_output_configuration_v1 * *tmp = &p->config; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_listener *tmp = &p->output_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_configuration_head_v1 { char x; struct wlr_output_configuration_head_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_configuration_v1(struct wlr_output_configuration_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->heads; (void)tmp; }
  { struct wlr_output_manager_v1 * *tmp = &p->manager; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_output_configuration_v1.serial' is an integer */
  (void)((p->finalized) | 0);  /* check that 'struct wlr_output_configuration_v1.finalized' is an integer */
  (void)((p->finished) | 0);  /* check that 'struct wlr_output_configuration_v1.finished' is an integer */
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_configuration_v1 { char x; struct wlr_output_configuration_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_event_request_state(struct wlr_output_event_request_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wlr_output_state const * *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_event_request_state { char x; struct wlr_output_event_request_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_head_v1_state(struct wlr_output_head_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output_head_v1_state.enabled' is an integer */
  { struct wlr_output_mode * *tmp = &p->mode; (void)tmp; }
  /* cannot generate 'struct $26' in field 'custom_mode': unknown type name */
  (void)((p->x) | 0);  /* check that 'struct wlr_output_head_v1_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_output_head_v1_state.y' is an integer */
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  { float *tmp = &p->scale; (void)tmp; }
  (void)((p->adaptive_sync_enabled) | 0);  /* check that 'struct wlr_output_head_v1_state.adaptive_sync_enabled' is an integer */
}
struct _cffi_align_struct_wlr_output_head_v1_state { char x; struct wlr_output_head_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_layout(struct wlr_output_layout *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  /* cannot generate 'struct $24' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_layout { char x; struct wlr_output_layout y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_manager_v1(struct wlr_output_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->heads; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_output_manager_v1.serial' is an integer */
  (void)((p->current_configuration_dirty) | 0);  /* check that 'struct wlr_output_manager_v1.current_configuration_dirty' is an integer */
  /* cannot generate 'struct $25' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_manager_v1 { char x; struct wlr_output_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_mode(struct wlr_output_mode *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->width) | 0);  /* check that 'struct wlr_output_mode.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_output_mode.height' is an integer */
  (void)((p->refresh) | 0);  /* check that 'struct wlr_output_mode.refresh' is an integer */
  (void)((p->preferred) | 0);  /* check that 'struct wlr_output_mode.preferred' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_mode { char x; struct wlr_output_mode y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_manager_v1(struct wlr_output_power_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->output_powers; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $27' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_manager_v1 { char x; struct wlr_output_power_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_v1(struct wlr_output_power_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wlr_output_power_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_listener *tmp = &p->output_destroy_listener; (void)tmp; }
  { struct wl_listener *tmp = &p->output_commit_listener; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_v1 { char x; struct wlr_output_power_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_v1_set_mode_event(struct wlr_output_power_v1_set_mode_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { enum zwlr_output_power_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_v1_set_mode_event { char x; struct wlr_output_power_v1_set_mode_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_state(struct wlr_output_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output_state.enabled' is an integer */
  { float *tmp = &p->scale; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  (void)((p->adaptive_sync_enabled) | 0);  /* check that 'struct wlr_output_state.adaptive_sync_enabled' is an integer */
  (void)((p->render_format) | 0);  /* check that 'struct wlr_output_state.render_format' is an integer */
  { enum wl_output_subpixel *tmp = &p->subpixel; (void)tmp; }
  { struct wlr_output_mode * *tmp = &p->mode; (void)tmp; }
  /* cannot generate 'struct $22' in field 'custom_mode': unknown type name */
}
struct _cffi_align_struct_wlr_output_state { char x; struct wlr_output_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer(struct wlr_pointer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device *tmp = &p->base; (void)tmp; }
  { struct wlr_pointer_impl const * *tmp = &p->impl; (void)tmp; }
  { char * *tmp = &p->output_name; (void)tmp; }
  /* cannot generate 'struct $28' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer { char x; struct wlr_pointer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_axis_event(struct wlr_pointer_axis_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_axis_event.time_msec' is an integer */
  { enum wlr_axis_source *tmp = &p->source; (void)tmp; }
  { enum wlr_axis_orientation *tmp = &p->orientation; (void)tmp; }
  { double *tmp = &p->delta; (void)tmp; }
  (void)((p->delta_discrete) | 0);  /* check that 'struct wlr_pointer_axis_event.delta_discrete' is an integer */
}
struct _cffi_align_struct_wlr_pointer_axis_event { char x; struct wlr_pointer_axis_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_button_event(struct wlr_pointer_button_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_button_event.time_msec' is an integer */
  (void)((p->button) | 0);  /* check that 'struct wlr_pointer_button_event.button' is an integer */
  { enum wlr_button_state *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_button_event { char x; struct wlr_pointer_button_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraint_v1(struct wlr_pointer_constraint_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_constraints_v1 * *tmp = &p->pointer_constraints; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { enum zwp_pointer_constraints_v1_lifetime *tmp = &p->lifetime; (void)tmp; }
  { enum wlr_pointer_constraint_v1_type *tmp = &p->type; (void)tmp; }
  { struct pixman_region32 *tmp = &p->region; (void)tmp; }
  { struct wlr_pointer_constraint_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_pointer_constraint_v1_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $30' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_constraint_v1 { char x; struct wlr_pointer_constraint_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraint_v1_state(struct wlr_pointer_constraint_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->committed) | 0);  /* check that 'struct wlr_pointer_constraint_v1_state.committed' is an integer */
  { struct pixman_region32 *tmp = &p->region; (void)tmp; }
  /* cannot generate 'struct $29' in field 'cursor_hint': unknown type name */
}
struct _cffi_align_struct_wlr_pointer_constraint_v1_state { char x; struct wlr_pointer_constraint_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraints_v1(struct wlr_pointer_constraints_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->constraints; (void)tmp; }
  /* cannot generate 'struct $31' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_constraints_v1 { char x; struct wlr_pointer_constraints_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_gestures_v1(struct wlr_pointer_gestures_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->swipes; (void)tmp; }
  { struct wl_list *tmp = &p->pinches; (void)tmp; }
  { struct wl_list *tmp = &p->holds; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $32' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_gestures_v1 { char x; struct wlr_pointer_gestures_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_hold_begin_event(struct wlr_pointer_hold_begin_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_hold_begin_event.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_pointer_hold_begin_event.fingers' is an integer */
}
struct _cffi_align_struct_wlr_pointer_hold_begin_event { char x; struct wlr_pointer_hold_begin_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_hold_end_event(struct wlr_pointer_hold_end_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_hold_end_event.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_pointer_hold_end_event.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_pointer_hold_end_event { char x; struct wlr_pointer_hold_end_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_motion_absolute_event(struct wlr_pointer_motion_absolute_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_motion_absolute_event.time_msec' is an integer */
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_motion_absolute_event { char x; struct wlr_pointer_motion_absolute_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_motion_event(struct wlr_pointer_motion_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_motion_event.time_msec' is an integer */
  { double *tmp = &p->delta_x; (void)tmp; }
  { double *tmp = &p->delta_y; (void)tmp; }
  { double *tmp = &p->unaccel_dx; (void)tmp; }
  { double *tmp = &p->unaccel_dy; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_motion_event { char x; struct wlr_pointer_motion_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_pinch_begin_event(struct wlr_pointer_pinch_begin_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_pinch_begin_event.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_pointer_pinch_begin_event.fingers' is an integer */
}
struct _cffi_align_struct_wlr_pointer_pinch_begin_event { char x; struct wlr_pointer_pinch_begin_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_pinch_end_event(struct wlr_pointer_pinch_end_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_pinch_end_event.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_pointer_pinch_end_event.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_pointer_pinch_end_event { char x; struct wlr_pointer_pinch_end_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_pinch_update_event(struct wlr_pointer_pinch_update_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_pinch_update_event.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_pointer_pinch_update_event.fingers' is an integer */
  { double *tmp = &p->dx; (void)tmp; }
  { double *tmp = &p->dy; (void)tmp; }
  { double *tmp = &p->scale; (void)tmp; }
  { double *tmp = &p->rotation; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_pinch_update_event { char x; struct wlr_pointer_pinch_update_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_swipe_begin_event(struct wlr_pointer_swipe_begin_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_swipe_begin_event.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_pointer_swipe_begin_event.fingers' is an integer */
}
struct _cffi_align_struct_wlr_pointer_swipe_begin_event { char x; struct wlr_pointer_swipe_begin_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_swipe_end_event(struct wlr_pointer_swipe_end_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_swipe_end_event.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_pointer_swipe_end_event.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_pointer_swipe_end_event { char x; struct wlr_pointer_swipe_end_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_swipe_update_event(struct wlr_pointer_swipe_update_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_pointer_swipe_update_event.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_pointer_swipe_update_event.fingers' is an integer */
  { double *tmp = &p->dx; (void)tmp; }
  { double *tmp = &p->dy; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_swipe_update_event { char x; struct wlr_pointer_swipe_update_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_presentation(struct wlr_presentation *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_presentation { char x; struct wlr_presentation y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_primary_selection_v1_device_manager(struct wlr_primary_selection_v1_device_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->devices; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $33' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_primary_selection_v1_device_manager { char x; struct wlr_primary_selection_v1_device_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_relative_pointer_manager_v1(struct wlr_relative_pointer_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->relative_pointers; (void)tmp; }
  /* cannot generate 'struct $34' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_relative_pointer_manager_v1 { char x; struct wlr_relative_pointer_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_relative_pointer_v1(struct wlr_relative_pointer_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_resource * *tmp = &p->pointer_resource; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $35' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_relative_pointer_v1 { char x; struct wlr_relative_pointer_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene(struct wlr_scene *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_tree *tmp = &p->tree; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  { struct wlr_presentation * *tmp = &p->presentation; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene { char x; struct wlr_scene y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_buffer(struct wlr_scene_buffer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_node *tmp = &p->node; (void)tmp; }
  { struct wlr_buffer * *tmp = &p->buffer; (void)tmp; }
  /* cannot generate 'struct $37' in field 'events': unknown type name */
  { _Bool(* *tmp)(struct wlr_scene_buffer *, double *, double *) = &p->point_accepts_input; (void)tmp; }
  { struct wlr_scene_output * *tmp = &p->primary_output; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_buffer { char x; struct wlr_scene_buffer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_layer_surface_v1(struct wlr_scene_layer_surface_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_tree * *tmp = &p->tree; (void)tmp; }
  { struct wlr_layer_surface_v1 * *tmp = &p->layer_surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_layer_surface_v1 { char x; struct wlr_scene_layer_surface_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_node(struct wlr_scene_node *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_scene_node_type *tmp = &p->type; (void)tmp; }
  { struct wlr_scene_tree * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_scene_node.enabled' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_scene_node.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_scene_node.y' is an integer */
  /* cannot generate 'struct $36' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
  { struct wlr_addon_set *tmp = &p->addons; (void)tmp; }
  { struct pixman_region32 *tmp = &p->visible; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_node { char x; struct wlr_scene_node y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_output(struct wlr_scene_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_scene * *tmp = &p->scene; (void)tmp; }
  { struct wlr_addon *tmp = &p->addon; (void)tmp; }
  { struct wlr_damage_ring *tmp = &p->damage_ring; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_scene_output.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_scene_output.y' is an integer */
  /* cannot generate 'struct $38' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_scene_output { char x; struct wlr_scene_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_output_state_options(struct wlr_scene_output_state_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_timer * *tmp = &p->timer; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_output_state_options { char x; struct wlr_scene_output_state_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_rect(struct wlr_scene_rect *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_node *tmp = &p->node; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_scene_rect.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_scene_rect.height' is an integer */
  { float(*tmp)[4] = &p->color; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_rect { char x; struct wlr_scene_rect y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_surface(struct wlr_scene_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_buffer * *tmp = &p->buffer; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_surface { char x; struct wlr_scene_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_tree(struct wlr_scene_tree *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_node *tmp = &p->node; (void)tmp; }
  { struct wl_list *tmp = &p->children; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_tree { char x; struct wlr_scene_tree y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_screencopy_manager_v1(struct wlr_screencopy_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->frames; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $39' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_screencopy_manager_v1 { char x; struct wlr_screencopy_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat(struct wlr_seat *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_list *tmp = &p->clients; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  (void)((p->capabilities) | 0);  /* check that 'struct wlr_seat.capabilities' is an integer */
  { struct timespec *tmp = &p->last_event; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->selection_source; (void)tmp; }
  (void)((p->selection_serial) | 0);  /* check that 'struct wlr_seat.selection_serial' is an integer */
  { struct wl_list *tmp = &p->selection_offers; (void)tmp; }
  { struct wlr_primary_selection_source * *tmp = &p->primary_selection_source; (void)tmp; }
  (void)((p->primary_selection_serial) | 0);  /* check that 'struct wlr_seat.primary_selection_serial' is an integer */
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->drag_source; (void)tmp; }
  (void)((p->drag_serial) | 0);  /* check that 'struct wlr_seat.drag_serial' is an integer */
  { struct wl_list *tmp = &p->drag_offers; (void)tmp; }
  { struct wlr_seat_pointer_state *tmp = &p->pointer_state; (void)tmp; }
  { struct wlr_seat_keyboard_state *tmp = &p->keyboard_state; (void)tmp; }
  { struct wlr_seat_touch_state *tmp = &p->touch_state; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->selection_source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->primary_selection_source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->drag_source_destroy; (void)tmp; }
  /* cannot generate 'struct $42' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat { char x; struct wlr_seat y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_focus_change_event(struct wlr_seat_keyboard_focus_change_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_surface * *tmp = &p->old_surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->new_surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_keyboard_focus_change_event { char x; struct wlr_seat_keyboard_focus_change_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_grab(struct wlr_seat_keyboard_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_keyboard_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_keyboard_grab { char x; struct wlr_seat_keyboard_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_state(struct wlr_seat_keyboard_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_keyboard * *tmp = &p->keyboard; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focused_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focused_surface; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_keymap; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_repeat_info; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wlr_seat_keyboard_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_keyboard_grab * *tmp = &p->default_grab; (void)tmp; }
  /* cannot generate 'struct $41' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_seat_keyboard_state { char x; struct wlr_seat_keyboard_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_focus_change_event(struct wlr_seat_pointer_focus_change_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_surface * *tmp = &p->old_surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->new_surface; (void)tmp; }
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_pointer_focus_change_event { char x; struct wlr_seat_pointer_focus_change_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_grab(struct wlr_seat_pointer_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_pointer_grab { char x; struct wlr_seat_pointer_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_request_set_cursor_event(struct wlr_seat_pointer_request_set_cursor_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat_client * *tmp = &p->seat_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.serial' is an integer */
  (void)((p->hotspot_x) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.hotspot_x' is an integer */
  (void)((p->hotspot_y) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.hotspot_y' is an integer */
}
struct _cffi_align_struct_wlr_seat_pointer_request_set_cursor_event { char x; struct wlr_seat_pointer_request_set_cursor_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_state(struct wlr_seat_pointer_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focused_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focused_surface; (void)tmp; }
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
  { struct wlr_seat_pointer_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_pointer_grab * *tmp = &p->default_grab; (void)tmp; }
  { uint32_t(*tmp)[16] = &p->buttons; (void)tmp; }
  (void)((p->button_count) | 0);  /* check that 'struct wlr_seat_pointer_state.button_count' is an integer */
  (void)((p->grab_button) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_button' is an integer */
  (void)((p->grab_serial) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_serial' is an integer */
  (void)((p->grab_time) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_time' is an integer */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  /* cannot generate 'struct $40' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_seat_pointer_state { char x; struct wlr_seat_pointer_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_set_primary_selection_event(struct wlr_seat_request_set_primary_selection_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_primary_selection_source * *tmp = &p->source; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_set_primary_selection_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_set_primary_selection_event { char x; struct wlr_seat_request_set_primary_selection_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_set_selection_event(struct wlr_seat_request_set_selection_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_data_source * *tmp = &p->source; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_set_selection_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_set_selection_event { char x; struct wlr_seat_request_set_selection_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_start_drag_event(struct wlr_seat_request_start_drag_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_surface * *tmp = &p->origin; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_start_drag_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_start_drag_event { char x; struct wlr_seat_request_start_drag_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_touch_grab(struct wlr_seat_touch_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_touch_grab { char x; struct wlr_seat_touch_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_touch_state(struct wlr_seat_touch_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wl_list *tmp = &p->touch_points; (void)tmp; }
  (void)((p->grab_serial) | 0);  /* check that 'struct wlr_seat_touch_state.grab_serial' is an integer */
  (void)((p->grab_id) | 0);  /* check that 'struct wlr_seat_touch_state.grab_id' is an integer */
  { struct wlr_seat_touch_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_touch_grab * *tmp = &p->default_grab; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_touch_state { char x; struct wlr_seat_touch_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_server_decoration_manager(struct wlr_server_decoration_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->decorations; (void)tmp; }
  (void)((p->default_mode) | 0);  /* check that 'struct wlr_server_decoration_manager.default_mode' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $43' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_server_decoration_manager { char x; struct wlr_server_decoration_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_session_lock_manager_v1(struct wlr_session_lock_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  /* cannot generate 'struct $44' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_session_lock_manager_v1 { char x; struct wlr_session_lock_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_session_lock_surface_v1(struct wlr_session_lock_surface_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->configured) | 0);  /* check that 'struct wlr_session_lock_surface_v1.configured' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_session_lock_surface_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_session_lock_surface_v1_state *tmp = &p->pending; (void)tmp; }
  /* cannot generate 'struct $46' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_session_lock_surface_v1 { char x; struct wlr_session_lock_surface_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_session_lock_surface_v1_configure(struct wlr_session_lock_surface_v1_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_session_lock_surface_v1_configure.serial' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_session_lock_surface_v1_configure.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_session_lock_surface_v1_configure.height' is an integer */
}
struct _cffi_align_struct_wlr_session_lock_surface_v1_configure { char x; struct wlr_session_lock_surface_v1_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_session_lock_surface_v1_state(struct wlr_session_lock_surface_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->width) | 0);  /* check that 'struct wlr_session_lock_surface_v1_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_session_lock_surface_v1_state.height' is an integer */
  (void)((p->configure_serial) | 0);  /* check that 'struct wlr_session_lock_surface_v1_state.configure_serial' is an integer */
}
struct _cffi_align_struct_wlr_session_lock_surface_v1_state { char x; struct wlr_session_lock_surface_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_session_lock_v1(struct wlr_session_lock_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_list *tmp = &p->surfaces; (void)tmp; }
  /* cannot generate 'struct $45' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_session_lock_v1 { char x; struct wlr_session_lock_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subcompositor(struct wlr_subcompositor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
}
struct _cffi_align_struct_wlr_subcompositor { char x; struct wlr_subcompositor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subsurface(struct wlr_subsurface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->parent; (void)tmp; }
  { struct wlr_subsurface_parent_state *tmp = &p->current; (void)tmp; }
  { struct wlr_subsurface_parent_state *tmp = &p->pending; (void)tmp; }
  (void)((p->cached_seq) | 0);  /* check that 'struct wlr_subsurface.cached_seq' is an integer */
  (void)((p->has_cache) | 0);  /* check that 'struct wlr_subsurface.has_cache' is an integer */
  (void)((p->synchronized) | 0);  /* check that 'struct wlr_subsurface.synchronized' is an integer */
  (void)((p->reordered) | 0);  /* check that 'struct wlr_subsurface.reordered' is an integer */
  (void)((p->added) | 0);  /* check that 'struct wlr_subsurface.added' is an integer */
  { struct wl_listener *tmp = &p->surface_client_commit; (void)tmp; }
  { struct wl_listener *tmp = &p->parent_destroy; (void)tmp; }
  /* cannot generate 'struct $5' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_subsurface { char x; struct wlr_subsurface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subsurface_parent_state(struct wlr_subsurface_parent_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_subsurface_parent_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_subsurface_parent_state.y' is an integer */
}
struct _cffi_align_struct_wlr_subsurface_parent_state { char x; struct wlr_subsurface_parent_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface(struct wlr_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wlr_client_buffer * *tmp = &p->buffer; (void)tmp; }
  { struct pixman_region32 *tmp = &p->buffer_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->external_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->opaque_region; (void)tmp; }
  { struct pixman_region32 *tmp = &p->input_region; (void)tmp; }
  { struct wlr_surface_state *tmp = &p->current; (void)tmp; }
  { struct wlr_surface_state *tmp = &p->pending; (void)tmp; }
  { struct wl_list *tmp = &p->cached; (void)tmp; }
  (void)((p->mapped) | 0);  /* check that 'struct wlr_surface.mapped' is an integer */
  { struct wlr_surface_role const * *tmp = &p->role; (void)tmp; }
  { struct wl_resource * *tmp = &p->role_resource; (void)tmp; }
  /* cannot generate 'struct $4' in field 'events': unknown type name */
  { struct wl_list *tmp = &p->current_outputs; (void)tmp; }
  { struct wlr_addon_set *tmp = &p->addons; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface { char x; struct wlr_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_output(struct wlr_surface_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_listener *tmp = &p->bind; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_output { char x; struct wlr_surface_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_role(struct wlr_surface_role *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->no_object) | 0);  /* check that 'struct wlr_surface_role.no_object' is an integer */
  { void(* *tmp)(struct wlr_surface *) = &p->commit; (void)tmp; }
  { void(* *tmp)(struct wlr_surface *) = &p->unmap; (void)tmp; }
  { void(* *tmp)(struct wlr_surface *) = &p->destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_role { char x; struct wlr_surface_role y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_state(struct wlr_surface_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->committed) | 0);  /* check that 'struct wlr_surface_state.committed' is an integer */
  (void)((p->seq) | 0);  /* check that 'struct wlr_surface_state.seq' is an integer */
  { struct wlr_buffer * *tmp = &p->buffer; (void)tmp; }
  (void)((p->dx) | 0);  /* check that 'struct wlr_surface_state.dx' is an integer */
  (void)((p->dy) | 0);  /* check that 'struct wlr_surface_state.dy' is an integer */
  { struct pixman_region32 *tmp = &p->surface_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->buffer_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->opaque; (void)tmp; }
  { struct pixman_region32 *tmp = &p->input; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  (void)((p->scale) | 0);  /* check that 'struct wlr_surface_state.scale' is an integer */
  { struct wl_list *tmp = &p->frame_callback_list; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_surface_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_surface_state.height' is an integer */
  (void)((p->buffer_width) | 0);  /* check that 'struct wlr_surface_state.buffer_width' is an integer */
  (void)((p->buffer_height) | 0);  /* check that 'struct wlr_surface_state.buffer_height' is an integer */
  { struct wl_list *tmp = &p->subsurfaces_below; (void)tmp; }
  { struct wl_list *tmp = &p->subsurfaces_above; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_state { char x; struct wlr_surface_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_switch(struct wlr_switch *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device *tmp = &p->base; (void)tmp; }
  /* cannot generate 'struct $47' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_switch { char x; struct wlr_switch y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_switch_toggle_event(struct wlr_switch_toggle_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_switch_toggle_event.time_msec' is an integer */
  { enum wlr_switch_type *tmp = &p->switch_type; (void)tmp; }
  { enum wlr_switch_state *tmp = &p->switch_state; (void)tmp; }
}
struct _cffi_align_struct_wlr_switch_toggle_event { char x; struct wlr_switch_toggle_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_touch(struct wlr_touch *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device *tmp = &p->base; (void)tmp; }
  { struct wlr_touch_impl const * *tmp = &p->impl; (void)tmp; }
  { char * *tmp = &p->output_name; (void)tmp; }
  { double *tmp = &p->width_mm; (void)tmp; }
  { double *tmp = &p->height_mm; (void)tmp; }
  /* cannot generate 'struct $48' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_touch { char x; struct wlr_touch y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_touch_cancel_event(struct wlr_touch_cancel_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch * *tmp = &p->touch; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_touch_cancel_event.time_msec' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_touch_cancel_event.touch_id' is an integer */
}
struct _cffi_align_struct_wlr_touch_cancel_event { char x; struct wlr_touch_cancel_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_touch_down_event(struct wlr_touch_down_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch * *tmp = &p->touch; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_touch_down_event.time_msec' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_touch_down_event.touch_id' is an integer */
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
}
struct _cffi_align_struct_wlr_touch_down_event { char x; struct wlr_touch_down_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_touch_motion_event(struct wlr_touch_motion_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch * *tmp = &p->touch; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_touch_motion_event.time_msec' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_touch_motion_event.touch_id' is an integer */
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
}
struct _cffi_align_struct_wlr_touch_motion_event { char x; struct wlr_touch_motion_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_touch_up_event(struct wlr_touch_up_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch * *tmp = &p->touch; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_touch_up_event.time_msec' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_touch_up_event.touch_id' is an integer */
}
struct _cffi_align_struct_wlr_touch_up_event { char x; struct wlr_touch_up_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_viewporter(struct wlr_viewporter *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  /* cannot generate 'struct $11' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_viewporter { char x; struct wlr_viewporter y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_keyboard_manager_v1(struct wlr_virtual_keyboard_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->virtual_keyboards; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $49' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_virtual_keyboard_manager_v1 { char x; struct wlr_virtual_keyboard_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_keyboard_v1(struct wlr_virtual_keyboard_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_keyboard *tmp = &p->keyboard; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  (void)((p->has_keymap) | 0);  /* check that 'struct wlr_virtual_keyboard_v1.has_keymap' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
}
struct _cffi_align_struct_wlr_virtual_keyboard_v1 { char x; struct wlr_virtual_keyboard_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_pointer_manager_v1(struct wlr_virtual_pointer_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->virtual_pointers; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $50' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_virtual_pointer_manager_v1 { char x; struct wlr_virtual_pointer_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_pointer_v1(struct wlr_virtual_pointer_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer *tmp = &p->pointer; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_pointer_axis_event(*tmp)[2] = &p->axis_event; (void)tmp; }
  { enum wl_pointer_axis *tmp = &p->axis; (void)tmp; }
  { _Bool(*tmp)[2] = &p->axis_valid; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
}
struct _cffi_align_struct_wlr_virtual_pointer_v1 { char x; struct wlr_virtual_pointer_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_pointer_v1_new_pointer_event(struct wlr_virtual_pointer_v1_new_pointer_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_virtual_pointer_v1 * *tmp = &p->new_pointer; (void)tmp; }
  { struct wlr_seat * *tmp = &p->suggested_seat; (void)tmp; }
  { struct wlr_output * *tmp = &p->suggested_output; (void)tmp; }
}
struct _cffi_align_struct_wlr_virtual_pointer_v1_new_pointer_event { char x; struct wlr_virtual_pointer_v1_new_pointer_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xcursor(struct wlr_xcursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->image_count) | 0);  /* check that 'struct wlr_xcursor.image_count' is an integer */
  { struct wlr_xcursor_image * * *tmp = &p->images; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  (void)((p->total_delay) | 0);  /* check that 'struct wlr_xcursor.total_delay' is an integer */
}
struct _cffi_align_struct_wlr_xcursor { char x; struct wlr_xcursor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xcursor_image(struct wlr_xcursor_image *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->width) | 0);  /* check that 'struct wlr_xcursor_image.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xcursor_image.height' is an integer */
  (void)((p->hotspot_x) | 0);  /* check that 'struct wlr_xcursor_image.hotspot_x' is an integer */
  (void)((p->hotspot_y) | 0);  /* check that 'struct wlr_xcursor_image.hotspot_y' is an integer */
  (void)((p->delay) | 0);  /* check that 'struct wlr_xcursor_image.delay' is an integer */
  { uint8_t * *tmp = &p->buffer; (void)tmp; }
}
struct _cffi_align_struct_wlr_xcursor_image { char x; struct wlr_xcursor_image y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_activation_v1(struct wlr_xdg_activation_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->token_timeout_msec) | 0);  /* check that 'struct wlr_xdg_activation_v1.token_timeout_msec' is an integer */
  { struct wl_list *tmp = &p->tokens; (void)tmp; }
  /* cannot generate 'struct $51' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_activation_v1 { char x; struct wlr_xdg_activation_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_activation_v1_request_activate_event(struct wlr_xdg_activation_v1_request_activate_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_activation_v1 * *tmp = &p->activation; (void)tmp; }
  { struct wlr_xdg_activation_token_v1 * *tmp = &p->token; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_activation_v1_request_activate_event { char x; struct wlr_xdg_activation_v1_request_activate_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_client(struct wlr_xdg_client *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_shell * *tmp = &p->shell; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_client * *tmp = &p->client; (void)tmp; }
  { struct wl_list *tmp = &p->surfaces; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->ping_serial) | 0);  /* check that 'struct wlr_xdg_client.ping_serial' is an integer */
  { struct wl_event_source * *tmp = &p->ping_timer; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_client { char x; struct wlr_xdg_client y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_decoration_manager_v1(struct wlr_xdg_decoration_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->decorations; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $52' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_decoration_manager_v1 { char x; struct wlr_xdg_decoration_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_output_manager_v1(struct wlr_xdg_output_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wlr_output_layout * *tmp = &p->layout; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  /* cannot generate 'struct $54' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_add; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_change; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_output_manager_v1 { char x; struct wlr_xdg_output_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_popup(struct wlr_xdg_popup *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->base; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  (void)((p->sent_initial_configure) | 0);  /* check that 'struct wlr_xdg_popup.sent_initial_configure' is an integer */
  { struct wlr_surface * *tmp = &p->parent; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_xdg_popup_configure *tmp = &p->scheduled; (void)tmp; }
  { struct wlr_xdg_popup_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_popup_state *tmp = &p->pending; (void)tmp; }
  /* cannot generate 'struct $58' in field 'events': unknown type name */
  { struct wl_list *tmp = &p->grab_link; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_popup { char x; struct wlr_xdg_popup y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_popup_configure(struct wlr_xdg_popup_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->fields) | 0);  /* check that 'struct wlr_xdg_popup_configure.fields' is an integer */
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
  { struct wlr_xdg_positioner_rules *tmp = &p->rules; (void)tmp; }
  (void)((p->reposition_token) | 0);  /* check that 'struct wlr_xdg_popup_configure.reposition_token' is an integer */
}
struct _cffi_align_struct_wlr_xdg_popup_configure { char x; struct wlr_xdg_popup_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_popup_state(struct wlr_xdg_popup_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
  (void)((p->reactive) | 0);  /* check that 'struct wlr_xdg_popup_state.reactive' is an integer */
}
struct _cffi_align_struct_wlr_xdg_popup_state { char x; struct wlr_xdg_popup_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_positioner_rules(struct wlr_xdg_positioner_rules *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_box *tmp = &p->anchor_rect; (void)tmp; }
  { enum xdg_positioner_anchor *tmp = &p->anchor; (void)tmp; }
  { enum xdg_positioner_gravity *tmp = &p->gravity; (void)tmp; }
  { enum xdg_positioner_constraint_adjustment *tmp = &p->constraint_adjustment; (void)tmp; }
  (void)((p->reactive) | 0);  /* check that 'struct wlr_xdg_positioner_rules.reactive' is an integer */
  (void)((p->has_parent_configure_serial) | 0);  /* check that 'struct wlr_xdg_positioner_rules.has_parent_configure_serial' is an integer */
  (void)((p->parent_configure_serial) | 0);  /* check that 'struct wlr_xdg_positioner_rules.parent_configure_serial' is an integer */
  /* cannot generate 'struct $56' in field 'size': unknown type name */
  /* cannot generate 'struct $56' in field 'parent_size': unknown type name */
  /* cannot generate 'struct $57' in field 'offset': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_positioner_rules { char x; struct wlr_xdg_positioner_rules y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_shell(struct wlr_xdg_shell *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->clients; (void)tmp; }
  { struct wl_list *tmp = &p->popup_grabs; (void)tmp; }
  (void)((p->ping_timeout) | 0);  /* check that 'struct wlr_xdg_shell.ping_timeout' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $55' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_shell { char x; struct wlr_xdg_shell y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface(struct wlr_xdg_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_client * *tmp = &p->client; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { enum wlr_xdg_surface_role *tmp = &p->role; (void)tmp; }
  { struct wl_resource * *tmp = &p->role_resource; (void)tmp; }
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_xdg_popup * *tmp = &p->popup; (void)tmp; }
  { struct wl_list *tmp = &p->popups; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_surface.added' is an integer */
  (void)((p->configured) | 0);  /* check that 'struct wlr_xdg_surface.configured' is an integer */
  { struct wl_event_source * *tmp = &p->configure_idle; (void)tmp; }
  (void)((p->scheduled_serial) | 0);  /* check that 'struct wlr_xdg_surface.scheduled_serial' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_xdg_surface_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_surface_state *tmp = &p->pending; (void)tmp; }
  (void)((p->initialized) | 0);  /* check that 'struct wlr_xdg_surface.initialized' is an integer */
  (void)((p->initial_commit) | 0);  /* check that 'struct wlr_xdg_surface.initial_commit' is an integer */
  /* cannot generate 'struct $61' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface { char x; struct wlr_xdg_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface_configure(struct wlr_xdg_surface_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_surface_configure.serial' is an integer */
  { struct wlr_xdg_toplevel_configure * *tmp = &p->toplevel_configure; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface_configure { char x; struct wlr_xdg_surface_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface_state(struct wlr_xdg_surface_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->configure_serial) | 0);  /* check that 'struct wlr_xdg_surface_state.configure_serial' is an integer */
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface_state { char x; struct wlr_xdg_surface_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel(struct wlr_xdg_toplevel *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_xdg_surface * *tmp = &p->base; (void)tmp; }
  { struct wlr_xdg_toplevel * *tmp = &p->parent; (void)tmp; }
  { struct wl_listener *tmp = &p->parent_unmap; (void)tmp; }
  { struct wlr_xdg_toplevel_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_toplevel_state *tmp = &p->pending; (void)tmp; }
  { struct wlr_xdg_toplevel_configure *tmp = &p->scheduled; (void)tmp; }
  { struct wlr_xdg_toplevel_requested *tmp = &p->requested; (void)tmp; }
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  /* cannot generate 'struct $59' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_toplevel { char x; struct wlr_xdg_toplevel y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_configure(struct wlr_xdg_toplevel_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.maximized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.fullscreen' is an integer */
  (void)((p->resizing) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.resizing' is an integer */
  (void)((p->activated) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.activated' is an integer */
  (void)((p->tiled) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.tiled' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.height' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_configure { char x; struct wlr_xdg_toplevel_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1(struct wlr_xdg_toplevel_decoration_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_xdg_decoration_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_xdg_toplevel_decoration_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_toplevel_decoration_v1_state *tmp = &p->pending; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->scheduled_mode; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->requested_mode; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_toplevel_decoration_v1.added' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  /* cannot generate 'struct $53' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_configure; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_ack_configure; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1 { char x; struct wlr_xdg_toplevel_decoration_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1_configure(struct wlr_xdg_toplevel_decoration_v1_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_xdg_surface_configure * *tmp = &p->surface_configure; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_configure { char x; struct wlr_xdg_toplevel_decoration_v1_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1_state(struct wlr_xdg_toplevel_decoration_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_state { char x; struct wlr_xdg_toplevel_decoration_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_move_event(struct wlr_xdg_toplevel_move_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_move_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_move_event { char x; struct wlr_xdg_toplevel_move_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_requested(struct wlr_xdg_toplevel_requested *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.maximized' is an integer */
  (void)((p->minimized) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.minimized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->fullscreen_output; (void)tmp; }
  { struct wl_listener *tmp = &p->fullscreen_output_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_requested { char x; struct wlr_xdg_toplevel_requested y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_resize_event(struct wlr_xdg_toplevel_resize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_resize_event.serial' is an integer */
  (void)((p->edges) | 0);  /* check that 'struct wlr_xdg_toplevel_resize_event.edges' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_resize_event { char x; struct wlr_xdg_toplevel_resize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_show_window_menu_event(struct wlr_xdg_toplevel_show_window_menu_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.serial' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.y' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_show_window_menu_event { char x; struct wlr_xdg_toplevel_show_window_menu_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_state(struct wlr_xdg_toplevel_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_state.maximized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_state.fullscreen' is an integer */
  (void)((p->resizing) | 0);  /* check that 'struct wlr_xdg_toplevel_state.resizing' is an integer */
  (void)((p->activated) | 0);  /* check that 'struct wlr_xdg_toplevel_state.activated' is an integer */
  (void)((p->tiled) | 0);  /* check that 'struct wlr_xdg_toplevel_state.tiled' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.height' is an integer */
  (void)((p->max_width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.max_width' is an integer */
  (void)((p->max_height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.max_height' is an integer */
  (void)((p->min_width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.min_width' is an integer */
  (void)((p->min_height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.min_height' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_state { char x; struct wlr_xdg_toplevel_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland(struct wlr_xwayland *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_server * *tmp = &p->server; (void)tmp; }
  { struct wlr_xwm * *tmp = &p->xwm; (void)tmp; }
  { struct wlr_xwayland_cursor * *tmp = &p->cursor; (void)tmp; }
  { char const * *tmp = &p->display_name; (void)tmp; }
  { struct wl_display * *tmp = &p->wl_display; (void)tmp; }
  { struct wlr_compositor * *tmp = &p->compositor; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  /* cannot generate 'struct $66' in field 'events': unknown type name */
  { int(* *tmp)(struct wlr_xwm *, xcb_generic_event_t *) = &p->user_event_handler; (void)tmp; }
  { struct wl_listener *tmp = &p->server_ready; (void)tmp; }
  { struct wl_listener *tmp = &p->server_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland { char x; struct wlr_xwayland y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_minimize_event(struct wlr_xwayland_minimize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->minimize) | 0);  /* check that 'struct wlr_xwayland_minimize_event.minimize' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_minimize_event { char x; struct wlr_xwayland_minimize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_remove_startup_info_event(struct wlr_xwayland_remove_startup_info_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->id; (void)tmp; }
  (void)((p->window) | 0);  /* check that 'struct wlr_xwayland_remove_startup_info_event.window' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_remove_startup_info_event { char x; struct wlr_xwayland_remove_startup_info_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_resize_event(struct wlr_xwayland_resize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->edges) | 0);  /* check that 'struct wlr_xwayland_resize_event.edges' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_resize_event { char x; struct wlr_xwayland_resize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_server(struct wlr_xwayland_server *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->pid) | 0);  /* check that 'struct wlr_xwayland_server.pid' is an integer */
  { struct wl_client * *tmp = &p->client; (void)tmp; }
  { struct wl_event_source * *tmp = &p->pipe_source; (void)tmp; }
  { int(*tmp)[2] = &p->wm_fd; (void)tmp; }
  { int(*tmp)[2] = &p->wl_fd; (void)tmp; }
  (void)((p->ready) | 0);  /* check that 'struct wlr_xwayland_server.ready' is an integer */
  (void)((p->server_start) | 0);  /* check that 'struct wlr_xwayland_server.server_start' is an integer */
  (void)((p->display) | 0);  /* check that 'struct wlr_xwayland_server.display' is an integer */
  { char(*tmp)[16] = &p->display_name; (void)tmp; }
  { int(*tmp)[2] = &p->x_fd; (void)tmp; }
  { struct wl_event_source *(*tmp)[2] = &p->x_fd_read_event; (void)tmp; }
  { struct wlr_xwayland_server_options *tmp = &p->options; (void)tmp; }
  { struct wl_display * *tmp = &p->wl_display; (void)tmp; }
  /* cannot generate 'struct $65' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->client_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_server { char x; struct wlr_xwayland_server y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_server_options(struct wlr_xwayland_server_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->lazy) | 0);  /* check that 'struct wlr_xwayland_server_options.lazy' is an integer */
  (void)((p->enable_wm) | 0);  /* check that 'struct wlr_xwayland_server_options.enable_wm' is an integer */
  (void)((p->no_touch_pointer_emulation) | 0);  /* check that 'struct wlr_xwayland_server_options.no_touch_pointer_emulation' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_server_options { char x; struct wlr_xwayland_server_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface(struct wlr_xwayland_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->window_id) | 0);  /* check that 'struct wlr_xwayland_surface.window_id' is an integer */
  { struct wlr_xwm * *tmp = &p->xwm; (void)tmp; }
  (void)((p->surface_id) | 0);  /* check that 'struct wlr_xwayland_surface.surface_id' is an integer */
  (void)((p->serial) | 0);  /* check that 'struct wlr_xwayland_surface.serial' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_list *tmp = &p->stack_link; (void)tmp; }
  { struct wl_list *tmp = &p->unpaired_link; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_addon *tmp = &p->surface_addon; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_map; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_unmap; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface.height' is an integer */
  (void)((p->saved_width) | 0);  /* check that 'struct wlr_xwayland_surface.saved_width' is an integer */
  (void)((p->saved_height) | 0);  /* check that 'struct wlr_xwayland_surface.saved_height' is an integer */
  (void)((p->override_redirect) | 0);  /* check that 'struct wlr_xwayland_surface.override_redirect' is an integer */
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->class; (void)tmp; }
  { char * *tmp = &p->instance; (void)tmp; }
  { char * *tmp = &p->role; (void)tmp; }
  { char * *tmp = &p->startup_id; (void)tmp; }
  (void)((p->pid) | 0);  /* check that 'struct wlr_xwayland_surface.pid' is an integer */
  (void)((p->has_utf8_title) | 0);  /* check that 'struct wlr_xwayland_surface.has_utf8_title' is an integer */
  { struct wl_list *tmp = &p->children; (void)tmp; }
  { struct wlr_xwayland_surface * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->parent_link; (void)tmp; }
  { uint32_t * *tmp = &p->window_type; (void)tmp; }
  (void)((p->window_type_len) | 0);  /* check that 'struct wlr_xwayland_surface.window_type_len' is an integer */
  { uint32_t * *tmp = &p->protocols; (void)tmp; }
  (void)((p->protocols_len) | 0);  /* check that 'struct wlr_xwayland_surface.protocols_len' is an integer */
  (void)((p->decorations) | 0);  /* check that 'struct wlr_xwayland_surface.decorations' is an integer */
  { xcb_icccm_wm_hints_t * *tmp = &p->hints; (void)tmp; }
  { xcb_size_hints_t * *tmp = &p->size_hints; (void)tmp; }
  { xcb_ewmh_wm_strut_partial_t * *tmp = &p->strut_partial; (void)tmp; }
  (void)((p->pinging) | 0);  /* check that 'struct wlr_xwayland_surface.pinging' is an integer */
  { struct wl_event_source * *tmp = &p->ping_timer; (void)tmp; }
  (void)((p->modal) | 0);  /* check that 'struct wlr_xwayland_surface.modal' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xwayland_surface.fullscreen' is an integer */
  (void)((p->maximized_vert) | 0);  /* check that 'struct wlr_xwayland_surface.maximized_vert' is an integer */
  (void)((p->maximized_horz) | 0);  /* check that 'struct wlr_xwayland_surface.maximized_horz' is an integer */
  (void)((p->minimized) | 0);  /* check that 'struct wlr_xwayland_surface.minimized' is an integer */
  (void)((p->withdrawn) | 0);  /* check that 'struct wlr_xwayland_surface.withdrawn' is an integer */
  (void)((p->has_alpha) | 0);  /* check that 'struct wlr_xwayland_surface.has_alpha' is an integer */
  /* cannot generate 'struct $67' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_surface { char x; struct wlr_xwayland_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_configure_event(struct wlr_xwayland_surface_configure_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.height' is an integer */
  (void)((p->mask) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.mask' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_configure_event { char x; struct wlr_xwayland_surface_configure_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__xcb_intern_atom_cookie_t(xcb_intern_atom_cookie_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align__xcb_intern_atom_cookie_t { char x; xcb_intern_atom_cookie_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__xcb_intern_atom_reply_t(xcb_intern_atom_reply_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->response_type) | 0);  /* check that 'xcb_intern_atom_reply_t.response_type' is an integer */
  (void)((p->pad0) | 0);  /* check that 'xcb_intern_atom_reply_t.pad0' is an integer */
  (void)((p->sequence) | 0);  /* check that 'xcb_intern_atom_reply_t.sequence' is an integer */
  (void)((p->length) | 0);  /* check that 'xcb_intern_atom_reply_t.length' is an integer */
  (void)((p->atom) | 0);  /* check that 'xcb_intern_atom_reply_t.atom' is an integer */
}
struct _cffi_align__xcb_intern_atom_reply_t { char x; xcb_intern_atom_reply_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_xkb_rule_names(struct xkb_rule_names *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->rules; (void)tmp; }
  { char const * *tmp = &p->model; (void)tmp; }
  { char const * *tmp = &p->layout; (void)tmp; }
  { char const * *tmp = &p->variant; (void)tmp; }
  { char const * *tmp = &p->options; (void)tmp; }
}
struct _cffi_align_struct_xkb_rule_names { char x; struct xkb_rule_names y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_union_wl_argument(union wl_argument *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->i) | 0);  /* check that 'union wl_argument.i' is an integer */
  (void)((p->u) | 0);  /* check that 'union wl_argument.u' is an integer */
  (void)((p->f) | 0);  /* check that 'union wl_argument.f' is an integer */
  { char const * *tmp = &p->s; (void)tmp; }
  { struct wl_object * *tmp = &p->o; (void)tmp; }
  (void)((p->n) | 0);  /* check that 'union wl_argument.n' is an integer */
  { struct wl_array * *tmp = &p->a; (void)tmp; }
  (void)((p->h) | 0);  /* check that 'union wl_argument.h' is an integer */
}
struct _cffi_align_union_wl_argument { char x; union wl_argument y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "CLOCK_MONOTONIC", (void *)_cffi_const_CLOCK_MONOTONIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_AXIS_ORIENTATION_HORIZONTAL", (void *)_cffi_const_WLR_AXIS_ORIENTATION_HORIZONTAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_ORIENTATION_VERTICAL", (void *)_cffi_const_WLR_AXIS_ORIENTATION_VERTICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_CONTINUOUS", (void *)_cffi_const_WLR_AXIS_SOURCE_CONTINUOUS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_FINGER", (void *)_cffi_const_WLR_AXIS_SOURCE_FINGER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_WHEEL", (void *)_cffi_const_WLR_AXIS_SOURCE_WHEEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_WHEEL_TILT", (void *)_cffi_const_WLR_AXIS_SOURCE_WHEEL_TILT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUFFER_DATA_PTR_ACCESS_READ", (void *)_cffi_const_WLR_BUFFER_DATA_PTR_ACCESS_READ, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUFFER_DATA_PTR_ACCESS_WRITE", (void *)_cffi_const_WLR_BUFFER_DATA_PTR_ACCESS_WRITE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUTTON_PRESSED", (void *)_cffi_const_WLR_BUTTON_PRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUTTON_RELEASED", (void *)_cffi_const_WLR_BUTTON_RELEASED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_DEBUG", (void *)_cffi_const_WLR_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_BOTTOM", (void *)_cffi_const_WLR_EDGE_BOTTOM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_LEFT", (void *)_cffi_const_WLR_EDGE_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_NONE", (void *)_cffi_const_WLR_EDGE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_RIGHT", (void *)_cffi_const_WLR_EDGE_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_TOP", (void *)_cffi_const_WLR_EDGE_TOP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ERROR", (void *)_cffi_const_WLR_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_GLOBAL", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_GLOBAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_LOCAL", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_LOCAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_NONE", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_PASSIVE", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_PASSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INFO", (void *)_cffi_const_WLR_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_KEYBOARD", (void *)_cffi_const_WLR_INPUT_DEVICE_KEYBOARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_POINTER", (void *)_cffi_const_WLR_INPUT_DEVICE_POINTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_SWITCH", (void *)_cffi_const_WLR_INPUT_DEVICE_SWITCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_PAD", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_PAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_TOOL", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_TOOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TOUCH", (void *)_cffi_const_WLR_INPUT_DEVICE_TOUCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_KEYBOARD_KEYS_CAP", (void *)_cffi_const_WLR_KEYBOARD_KEYS_CAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_LED_CAPS_LOCK", (void *)_cffi_const_WLR_LED_CAPS_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_COUNT", (void *)_cffi_const_WLR_LED_COUNT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_LED_NUM_LOCK", (void *)_cffi_const_WLR_LED_NUM_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_SCROLL_LOCK", (void *)_cffi_const_WLR_LED_SCROLL_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_ALT", (void *)_cffi_const_WLR_MODIFIER_ALT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_CAPS", (void *)_cffi_const_WLR_MODIFIER_CAPS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_COUNT", (void *)_cffi_const_WLR_MODIFIER_COUNT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_MODIFIER_CTRL", (void *)_cffi_const_WLR_MODIFIER_CTRL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_LOGO", (void *)_cffi_const_WLR_MODIFIER_LOGO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD2", (void *)_cffi_const_WLR_MODIFIER_MOD2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD3", (void *)_cffi_const_WLR_MODIFIER_MOD3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD5", (void *)_cffi_const_WLR_MODIFIER_MOD5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_SHIFT", (void *)_cffi_const_WLR_MODIFIER_SHIFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_BUTTONS_CAP", (void *)_cffi_const_WLR_POINTER_BUTTONS_CAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_CONFINED", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_CONFINED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_LOCKED", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_STATE_REGION", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_REGION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SCENE_NODE_BUFFER", (void *)_cffi_const_WLR_SCENE_NODE_BUFFER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SCENE_NODE_RECT", (void *)_cffi_const_WLR_SCENE_NODE_RECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SCENE_NODE_TREE", (void *)_cffi_const_WLR_SCENE_NODE_TREE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_NONE", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_SERVER", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_SERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SILENT", (void *)_cffi_const_WLR_SILENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SWITCH_STATE_OFF", (void *)_cffi_const_WLR_SWITCH_STATE_OFF, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SWITCH_STATE_ON", (void *)_cffi_const_WLR_SWITCH_STATE_ON, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SWITCH_TYPE_LID", (void *)_cffi_const_WLR_SWITCH_TYPE_LID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SWITCH_TYPE_TABLET_MODE", (void *)_cffi_const_WLR_SWITCH_TYPE_TABLET_MODE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_VERSION_MAJOR", (void *)_cffi_const_WLR_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_VERSION_MICRO", (void *)_cffi_const_WLR_VERSION_MICRO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_VERSION_MINOR", (void *)_cffi_const_WLR_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_XDG_POPUP_CONFIGURE_REPOSITION_TOKEN", (void *)_cffi_const_WLR_XDG_POPUP_CONFIGURE_REPOSITION_TOKEN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_NONE", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_POPUP", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_POPUP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_TOPLEVEL", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_TOPLEVEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN", (void *)_cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU", (void *)_cffi_const_WLR_XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_ALL", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_CANCELLED", (void *)_cffi_const_XKB_COMPOSE_CANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSED", (void *)_cffi_const_XKB_COMPOSE_COMPOSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSING", (void *)_cffi_const_XKB_COMPOSE_COMPOSING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_ACCEPTED", (void *)_cffi_const_XKB_COMPOSE_FEED_ACCEPTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_IGNORED", (void *)_cffi_const_XKB_COMPOSE_FEED_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_NOTHING", (void *)_cffi_const_XKB_COMPOSE_NOTHING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_STATE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_STATE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONSUMED_MODE_GTK", (void *)_cffi_const_XKB_CONSUMED_MODE_GTK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONSUMED_MODE_XKB", (void *)_cffi_const_XKB_CONSUMED_MODE_XKB, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_DEFAULT_INCLUDES", (void *)_cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_ENVIRONMENT_NAMES", (void *)_cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_FLAGS", (void *)_cffi_const_XKB_CONTEXT_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_SECURE_GETENV", (void *)_cffi_const_XKB_CONTEXT_NO_SECURE_GETENV, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_CASE_INSENSITIVE", (void *)_cffi_const_XKB_KEYSYM_CASE_INSENSITIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_NO_FLAGS", (void *)_cffi_const_XKB_KEYSYM_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_DOWN", (void *)_cffi_const_XKB_KEY_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_UP", (void *)_cffi_const_XKB_KEY_UP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_CRITICAL", (void *)_cffi_const_XKB_LOG_LEVEL_CRITICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_DEBUG", (void *)_cffi_const_XKB_LOG_LEVEL_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_ERROR", (void *)_cffi_const_XKB_LOG_LEVEL_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_INFO", (void *)_cffi_const_XKB_LOG_LEVEL_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_WARNING", (void *)_cffi_const_XKB_LOG_LEVEL_WARNING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_DEPRESSED", (void *)_cffi_const_XKB_STATE_LAYOUT_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_EFFECTIVE", (void *)_cffi_const_XKB_STATE_LAYOUT_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LATCHED", (void *)_cffi_const_XKB_STATE_LAYOUT_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LOCKED", (void *)_cffi_const_XKB_STATE_LAYOUT_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LEDS", (void *)_cffi_const_XKB_STATE_LEDS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ALL", (void *)_cffi_const_XKB_STATE_MATCH_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ANY", (void *)_cffi_const_XKB_STATE_MATCH_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_NON_EXCLUSIVE", (void *)_cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_DEPRESSED", (void *)_cffi_const_XKB_STATE_MODS_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_EFFECTIVE", (void *)_cffi_const_XKB_STATE_MODS_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LATCHED", (void *)_cffi_const_XKB_STATE_MODS_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LOCKED", (void *)_cffi_const_XKB_STATE_MODS_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "buffer_iterator_callback", (void *)&_cffi_externpy__buffer_iterator_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 983), (void *)buffer_iterator_callback },
  { "clock_gettime", (void *)_cffi_f_clock_gettime, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_clock_gettime },
  { "log_func_callback", (void *)&_cffi_externpy__log_func_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 559), (void *)log_func_callback },
  { "pixman_region32_fini", (void *)_cffi_f_pixman_region32_fini, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 593), (void *)_cffi_d_pixman_region32_fini },
  { "pixman_region32_init", (void *)_cffi_f_pixman_region32_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 593), (void *)_cffi_d_pixman_region32_init },
  { "pixman_region32_init_rect", (void *)_cffi_f_pixman_region32_init_rect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 596), (void *)_cffi_d_pixman_region32_init_rect },
  { "pixman_region32_not_empty", (void *)_cffi_f_pixman_region32_not_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_pixman_region32_not_empty },
  { "pixman_region32_rectangles", (void *)_cffi_f_pixman_region32_rectangles, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 176), (void *)_cffi_d_pixman_region32_rectangles },
  { "surface_iterator_callback", (void *)&_cffi_externpy__surface_iterator_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 744), (void *)surface_iterator_callback },
  { "wlr_allocator_autocreate", (void *)_cffi_f_wlr_allocator_autocreate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 180), (void *)_cffi_d_wlr_allocator_autocreate },
  { "wlr_allocator_create_buffer", (void *)_cffi_f_wlr_allocator_create_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 191), (void *)_cffi_d_wlr_allocator_create_buffer },
  { "wlr_backend_autocreate", (void *)_cffi_f_wlr_backend_autocreate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 187), (void *)_cffi_d_wlr_backend_autocreate },
  { "wlr_backend_destroy", (void *)_cffi_f_wlr_backend_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 623), (void *)_cffi_d_wlr_backend_destroy },
  { "wlr_backend_is_headless", (void *)_cffi_f_wlr_backend_is_headless, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_wlr_backend_is_headless },
  { "wlr_backend_is_multi", (void *)_cffi_f_wlr_backend_is_multi, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_wlr_backend_is_multi },
  { "wlr_backend_start", (void *)_cffi_f_wlr_backend_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_wlr_backend_start },
  { "wlr_box_closest_point", (void *)_cffi_f_wlr_box_closest_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 633), (void *)_cffi_d_wlr_box_closest_point },
  { "wlr_box_contains_point", (void *)_cffi_f_wlr_box_contains_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 14), (void *)_cffi_d_wlr_box_contains_point },
  { "wlr_box_empty", (void *)_cffi_f_wlr_box_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 11), (void *)_cffi_d_wlr_box_empty },
  { "wlr_box_intersection", (void *)_cffi_f_wlr_box_intersection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 6), (void *)_cffi_d_wlr_box_intersection },
  { "wlr_box_transform", (void *)_cffi_f_wlr_box_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 626), (void *)_cffi_d_wlr_box_transform },
  { "wlr_buffer_begin_data_ptr_access", (void *)_cffi_f_wlr_buffer_begin_data_ptr_access, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_wlr_buffer_begin_data_ptr_access },
  { "wlr_buffer_drop", (void *)_cffi_f_wlr_buffer_drop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 640), (void *)_cffi_d_wlr_buffer_drop },
  { "wlr_buffer_end_data_ptr_access", (void *)_cffi_f_wlr_buffer_end_data_ptr_access, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 640), (void *)_cffi_d_wlr_buffer_end_data_ptr_access },
  { "wlr_buffer_lock", (void *)_cffi_f_wlr_buffer_lock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 197), (void *)_cffi_d_wlr_buffer_lock },
  { "wlr_buffer_unlock", (void *)_cffi_f_wlr_buffer_unlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 640), (void *)_cffi_d_wlr_buffer_unlock },
  { "wlr_compositor_create", (void *)_cffi_f_wlr_compositor_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_wlr_compositor_create },
  { "wlr_cursor_absolute_to_layout_coords", (void *)_cffi_f_wlr_cursor_absolute_to_layout_coords, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 656), (void *)_cffi_d_wlr_cursor_absolute_to_layout_coords },
  { "wlr_cursor_attach_input_device", (void *)_cffi_f_wlr_cursor_attach_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 646), (void *)_cffi_d_wlr_cursor_attach_input_device },
  { "wlr_cursor_attach_output_layout", (void *)_cffi_f_wlr_cursor_attach_output_layout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 673), (void *)_cffi_d_wlr_cursor_attach_output_layout },
  { "wlr_cursor_create", (void *)_cffi_f_wlr_cursor_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 205), (void *)_cffi_d_wlr_cursor_create },
  { "wlr_cursor_destroy", (void *)_cffi_f_wlr_cursor_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 643), (void *)_cffi_d_wlr_cursor_destroy },
  { "wlr_cursor_detach_input_device", (void *)_cffi_f_wlr_cursor_detach_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 646), (void *)_cffi_d_wlr_cursor_detach_input_device },
  { "wlr_cursor_map_input_to_output", (void *)_cffi_f_wlr_cursor_map_input_to_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 664), (void *)_cffi_d_wlr_cursor_map_input_to_output },
  { "wlr_cursor_map_to_output", (void *)_cffi_f_wlr_cursor_map_to_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 669), (void *)_cffi_d_wlr_cursor_map_to_output },
  { "wlr_cursor_move", (void *)_cffi_f_wlr_cursor_move, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 650), (void *)_cffi_d_wlr_cursor_move },
  { "wlr_cursor_set_surface", (void *)_cffi_f_wlr_cursor_set_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 677), (void *)_cffi_d_wlr_cursor_set_surface },
  { "wlr_cursor_set_xcursor", (void *)_cffi_f_wlr_cursor_set_xcursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 683), (void *)_cffi_d_wlr_cursor_set_xcursor },
  { "wlr_cursor_warp", (void *)_cffi_f_wlr_cursor_warp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 26), (void *)_cffi_d_wlr_cursor_warp },
  { "wlr_cursor_warp_absolute", (void *)_cffi_f_wlr_cursor_warp_absolute, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 650), (void *)_cffi_d_wlr_cursor_warp_absolute },
  { "wlr_cursor_warp_closest", (void *)_cffi_f_wlr_cursor_warp_closest, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 650), (void *)_cffi_d_wlr_cursor_warp_closest },
  { "wlr_data_control_manager_v1_create", (void *)_cffi_f_wlr_data_control_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 207), (void *)_cffi_d_wlr_data_control_manager_v1_create },
  { "wlr_data_device_manager_create", (void *)_cffi_f_wlr_data_device_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 210), (void *)_cffi_d_wlr_data_device_manager_create },
  { "wlr_data_source_destroy", (void *)_cffi_f_wlr_data_source_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 688), (void *)_cffi_d_wlr_data_source_destroy },
  { "wlr_drm_format_set_get", (void *)_cffi_f_wlr_drm_format_set_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 213), (void *)_cffi_d_wlr_drm_format_set_get },
  { "wlr_export_dmabuf_manager_v1_create", (void *)_cffi_f_wlr_export_dmabuf_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 217), (void *)_cffi_d_wlr_export_dmabuf_manager_v1_create },
  { "wlr_foreign_toplevel_handle_v1_create", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 220), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_create },
  { "wlr_foreign_toplevel_handle_v1_destroy", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 691), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_destroy },
  { "wlr_foreign_toplevel_handle_v1_output_enter", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_output_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 706), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_output_enter },
  { "wlr_foreign_toplevel_handle_v1_output_leave", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_output_leave, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 706), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_output_leave },
  { "wlr_foreign_toplevel_handle_v1_set_activated", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_activated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 694), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_activated },
  { "wlr_foreign_toplevel_handle_v1_set_app_id", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_app_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 698), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_app_id },
  { "wlr_foreign_toplevel_handle_v1_set_fullscreen", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_fullscreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 694), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_fullscreen },
  { "wlr_foreign_toplevel_handle_v1_set_maximized", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_maximized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 694), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_maximized },
  { "wlr_foreign_toplevel_handle_v1_set_minimized", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_minimized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 694), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_minimized },
  { "wlr_foreign_toplevel_handle_v1_set_parent", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_parent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 702), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_parent },
  { "wlr_foreign_toplevel_handle_v1_set_title", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_title, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 698), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_title },
  { "wlr_foreign_toplevel_manager_v1_create", (void *)_cffi_f_wlr_foreign_toplevel_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 223), (void *)_cffi_d_wlr_foreign_toplevel_manager_v1_create },
  { "wlr_fractional_scale_manager_v1_create", (void *)_cffi_f_wlr_fractional_scale_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 226), (void *)_cffi_d_wlr_fractional_scale_manager_v1_create },
  { "wlr_fractional_scale_v1_notify_scale", (void *)_cffi_f_wlr_fractional_scale_v1_notify_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1130), (void *)_cffi_d_wlr_fractional_scale_v1_notify_scale },
  { "wlr_gamma_control_manager_v1_create", (void *)_cffi_f_wlr_gamma_control_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 230), (void *)_cffi_d_wlr_gamma_control_manager_v1_create },
  { "wlr_headless_add_output", (void *)_cffi_f_wlr_headless_add_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 260), (void *)_cffi_d_wlr_headless_add_output },
  { "wlr_headless_backend_create", (void *)_cffi_f_wlr_headless_backend_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 184), (void *)_cffi_d_wlr_headless_backend_create },
  { "wlr_idle_inhibit_v1_create", (void *)_cffi_f_wlr_idle_inhibit_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 233), (void *)_cffi_d_wlr_idle_inhibit_v1_create },
  { "wlr_idle_notifier_v1_create", (void *)_cffi_f_wlr_idle_notifier_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 236), (void *)_cffi_d_wlr_idle_notifier_v1_create },
  { "wlr_idle_notifier_v1_notify_activity", (void *)_cffi_f_wlr_idle_notifier_v1_notify_activity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 714), (void *)_cffi_d_wlr_idle_notifier_v1_notify_activity },
  { "wlr_idle_notifier_v1_set_inhibited", (void *)_cffi_f_wlr_idle_notifier_v1_set_inhibited, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 710), (void *)_cffi_d_wlr_idle_notifier_v1_set_inhibited },
  { "wlr_input_device_get_virtual_keyboard", (void *)_cffi_f_wlr_input_device_get_virtual_keyboard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 460), (void *)_cffi_d_wlr_input_device_get_virtual_keyboard },
  { "wlr_input_device_is_libinput", (void *)_cffi_f_wlr_input_device_is_libinput, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_wlr_input_device_is_libinput },
  { "wlr_input_inhibit_manager_create", (void *)_cffi_f_wlr_input_inhibit_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 239), (void *)_cffi_d_wlr_input_inhibit_manager_create },
  { "wlr_keyboard_from_input_device", (void *)_cffi_f_wlr_keyboard_from_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 242), (void *)_cffi_d_wlr_keyboard_from_input_device },
  { "wlr_keyboard_get_modifiers", (void *)_cffi_f_wlr_keyboard_get_modifiers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 508), (void *)_cffi_d_wlr_keyboard_get_modifiers },
  { "wlr_keyboard_notify_modifiers", (void *)_cffi_f_wlr_keyboard_notify_modifiers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 727), (void *)_cffi_d_wlr_keyboard_notify_modifiers },
  { "wlr_keyboard_set_keymap", (void *)_cffi_f_wlr_keyboard_set_keymap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 723), (void *)_cffi_d_wlr_keyboard_set_keymap },
  { "wlr_keyboard_set_repeat_info", (void *)_cffi_f_wlr_keyboard_set_repeat_info, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 718), (void *)_cffi_d_wlr_keyboard_set_repeat_info },
  { "wlr_layer_shell_v1_create", (void *)_cffi_f_wlr_layer_shell_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 248), (void *)_cffi_d_wlr_layer_shell_v1_create },
  { "wlr_layer_surface_v1_configure", (void *)_cffi_f_wlr_layer_surface_v1_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 737), (void *)_cffi_d_wlr_layer_surface_v1_configure },
  { "wlr_layer_surface_v1_destroy", (void *)_cffi_f_wlr_layer_surface_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 734), (void *)_cffi_d_wlr_layer_surface_v1_destroy },
  { "wlr_layer_surface_v1_for_each_surface", (void *)_cffi_f_wlr_layer_surface_v1_for_each_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 742), (void *)_cffi_d_wlr_layer_surface_v1_for_each_surface },
  { "wlr_layer_surface_v1_surface_at", (void *)_cffi_f_wlr_layer_surface_v1_surface_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 405), (void *)_cffi_d_wlr_layer_surface_v1_surface_at },
  { "wlr_layer_surface_v1_try_from_wlr_surface", (void *)_cffi_f_wlr_layer_surface_v1_try_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 252), (void *)_cffi_d_wlr_layer_surface_v1_try_from_wlr_surface },
  { "wlr_libinput_get_device_handle", (void *)_cffi_f_wlr_libinput_get_device_handle, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 173), (void *)_cffi_d_wlr_libinput_get_device_handle },
  { "wlr_linux_dmabuf_v1_create", (void *)_cffi_f_wlr_linux_dmabuf_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 255), (void *)_cffi_d_wlr_linux_dmabuf_v1_create },
  { "wlr_matrix_identity", (void *)_cffi_f_wlr_matrix_identity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 561), (void *)_cffi_d_wlr_matrix_identity },
  { "wlr_matrix_multiply", (void *)_cffi_f_wlr_matrix_multiply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 572), (void *)_cffi_d_wlr_matrix_multiply },
  { "wlr_matrix_project_box", (void *)_cffi_f_wlr_matrix_project_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 586), (void *)_cffi_d_wlr_matrix_project_box },
  { "wlr_matrix_rotate", (void *)_cffi_f_wlr_matrix_rotate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 577), (void *)_cffi_d_wlr_matrix_rotate },
  { "wlr_matrix_scale", (void *)_cffi_f_wlr_matrix_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_wlr_matrix_scale },
  { "wlr_matrix_transform", (void *)_cffi_f_wlr_matrix_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 564), (void *)_cffi_d_wlr_matrix_transform },
  { "wlr_matrix_translate", (void *)_cffi_f_wlr_matrix_translate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_wlr_matrix_translate },
  { "wlr_matrix_transpose", (void *)_cffi_f_wlr_matrix_transpose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 568), (void *)_cffi_d_wlr_matrix_transpose },
  { "wlr_output_attach_render", (void *)_cffi_f_wlr_output_attach_render, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 38), (void *)_cffi_d_wlr_output_attach_render },
  { "wlr_output_commit", (void *)_cffi_f_wlr_output_commit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 35), (void *)_cffi_d_wlr_output_commit },
  { "wlr_output_commit_state", (void *)_cffi_f_wlr_output_commit_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_wlr_output_commit_state },
  { "wlr_output_configuration_head_v1_create", (void *)_cffi_f_wlr_output_configuration_head_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 270), (void *)_cffi_d_wlr_output_configuration_head_v1_create },
  { "wlr_output_configuration_v1_create", (void *)_cffi_f_wlr_output_configuration_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 274), (void *)_cffi_d_wlr_output_configuration_v1_create },
  { "wlr_output_configuration_v1_destroy", (void *)_cffi_f_wlr_output_configuration_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 781), (void *)_cffi_d_wlr_output_configuration_v1_destroy },
  { "wlr_output_configuration_v1_send_failed", (void *)_cffi_f_wlr_output_configuration_v1_send_failed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 781), (void *)_cffi_d_wlr_output_configuration_v1_send_failed },
  { "wlr_output_configuration_v1_send_succeeded", (void *)_cffi_f_wlr_output_configuration_v1_send_succeeded, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 781), (void *)_cffi_d_wlr_output_configuration_v1_send_succeeded },
  { "wlr_output_create_global", (void *)_cffi_f_wlr_output_create_global, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 747), (void *)_cffi_d_wlr_output_create_global },
  { "wlr_output_destroy_global", (void *)_cffi_f_wlr_output_destroy_global, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 747), (void *)_cffi_d_wlr_output_destroy_global },
  { "wlr_output_effective_resolution", (void *)_cffi_f_wlr_output_effective_resolution, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 762), (void *)_cffi_d_wlr_output_effective_resolution },
  { "wlr_output_enable", (void *)_cffi_f_wlr_output_enable, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 750), (void *)_cffi_d_wlr_output_enable },
  { "wlr_output_enable_adaptive_sync", (void *)_cffi_f_wlr_output_enable_adaptive_sync, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 750), (void *)_cffi_d_wlr_output_enable_adaptive_sync },
  { "wlr_output_head_v1_state_apply", (void *)_cffi_f_wlr_output_head_v1_state_apply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 784), (void *)_cffi_d_wlr_output_head_v1_state_apply },
  { "wlr_output_init_render", (void *)_cffi_f_wlr_output_init_render, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 42), (void *)_cffi_d_wlr_output_init_render },
  { "wlr_output_is_headless", (void *)_cffi_f_wlr_output_is_headless, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 35), (void *)_cffi_d_wlr_output_is_headless },
  { "wlr_output_layout_add", (void *)_cffi_f_wlr_output_layout_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 282), (void *)_cffi_d_wlr_output_layout_add },
  { "wlr_output_layout_add_auto", (void *)_cffi_f_wlr_output_layout_add_auto, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 278), (void *)_cffi_d_wlr_output_layout_add_auto },
  { "wlr_output_layout_closest_point", (void *)_cffi_f_wlr_output_layout_closest_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 801), (void *)_cffi_d_wlr_output_layout_closest_point },
  { "wlr_output_layout_create", (void *)_cffi_f_wlr_output_layout_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 276), (void *)_cffi_d_wlr_output_layout_create },
  { "wlr_output_layout_destroy", (void *)_cffi_f_wlr_output_layout_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 788), (void *)_cffi_d_wlr_output_layout_destroy },
  { "wlr_output_layout_get_box", (void *)_cffi_f_wlr_output_layout_get_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 809), (void *)_cffi_d_wlr_output_layout_get_box },
  { "wlr_output_layout_output_at", (void *)_cffi_f_wlr_output_layout_output_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 265), (void *)_cffi_d_wlr_output_layout_output_at },
  { "wlr_output_layout_output_coords", (void *)_cffi_f_wlr_output_layout_output_coords, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 795), (void *)_cffi_d_wlr_output_layout_output_coords },
  { "wlr_output_layout_remove", (void *)_cffi_f_wlr_output_layout_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 791), (void *)_cffi_d_wlr_output_layout_remove },
  { "wlr_output_manager_v1_create", (void *)_cffi_f_wlr_output_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 288), (void *)_cffi_d_wlr_output_manager_v1_create },
  { "wlr_output_manager_v1_set_configuration", (void *)_cffi_f_wlr_output_manager_v1_set_configuration, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 814), (void *)_cffi_d_wlr_output_manager_v1_set_configuration },
  { "wlr_output_power_manager_v1_create", (void *)_cffi_f_wlr_output_power_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 294), (void *)_cffi_d_wlr_output_power_manager_v1_create },
  { "wlr_output_preferred_mode", (void *)_cffi_f_wlr_output_preferred_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 291), (void *)_cffi_d_wlr_output_preferred_mode },
  { "wlr_output_render_software_cursors", (void *)_cffi_f_wlr_output_render_software_cursors, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 773), (void *)_cffi_d_wlr_output_render_software_cursors },
  { "wlr_output_rollback", (void *)_cffi_f_wlr_output_rollback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 747), (void *)_cffi_d_wlr_output_rollback },
  { "wlr_output_set_custom_mode", (void *)_cffi_f_wlr_output_set_custom_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 767), (void *)_cffi_d_wlr_output_set_custom_mode },
  { "wlr_output_set_damage", (void *)_cffi_f_wlr_output_set_damage, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 773), (void *)_cffi_d_wlr_output_set_damage },
  { "wlr_output_set_mode", (void *)_cffi_f_wlr_output_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 777), (void *)_cffi_d_wlr_output_set_mode },
  { "wlr_output_set_scale", (void *)_cffi_f_wlr_output_set_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 758), (void *)_cffi_d_wlr_output_set_scale },
  { "wlr_output_set_transform", (void *)_cffi_f_wlr_output_set_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 754), (void *)_cffi_d_wlr_output_set_transform },
  { "wlr_output_state_finish", (void *)_cffi_f_wlr_output_state_finish, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 818), (void *)_cffi_d_wlr_output_state_finish },
  { "wlr_output_state_init", (void *)_cffi_f_wlr_output_state_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 818), (void *)_cffi_d_wlr_output_state_init },
  { "wlr_output_state_set_adaptive_sync_enabled", (void *)_cffi_f_wlr_output_state_set_adaptive_sync_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 821), (void *)_cffi_d_wlr_output_state_set_adaptive_sync_enabled },
  { "wlr_output_state_set_custom_mode", (void *)_cffi_f_wlr_output_state_set_custom_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 837), (void *)_cffi_d_wlr_output_state_set_custom_mode },
  { "wlr_output_state_set_enabled", (void *)_cffi_f_wlr_output_state_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 821), (void *)_cffi_d_wlr_output_state_set_enabled },
  { "wlr_output_state_set_mode", (void *)_cffi_f_wlr_output_state_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 843), (void *)_cffi_d_wlr_output_state_set_mode },
  { "wlr_output_state_set_render_format", (void *)_cffi_f_wlr_output_state_set_render_format, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 847), (void *)_cffi_d_wlr_output_state_set_render_format },
  { "wlr_output_state_set_scale", (void *)_cffi_f_wlr_output_state_set_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 833), (void *)_cffi_d_wlr_output_state_set_scale },
  { "wlr_output_state_set_subpixel", (void *)_cffi_f_wlr_output_state_set_subpixel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 825), (void *)_cffi_d_wlr_output_state_set_subpixel },
  { "wlr_output_state_set_transform", (void *)_cffi_f_wlr_output_state_set_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 829), (void *)_cffi_d_wlr_output_state_set_transform },
  { "wlr_output_test", (void *)_cffi_f_wlr_output_test, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 35), (void *)_cffi_d_wlr_output_test },
  { "wlr_output_test_state", (void *)_cffi_f_wlr_output_test_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_wlr_output_test_state },
  { "wlr_output_transform_compose", (void *)_cffi_f_wlr_output_transform_compose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 129), (void *)_cffi_d_wlr_output_transform_compose },
  { "wlr_output_transform_invert", (void *)_cffi_f_wlr_output_transform_invert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 126), (void *)_cffi_d_wlr_output_transform_invert },
  { "wlr_output_transformed_resolution", (void *)_cffi_f_wlr_output_transformed_resolution, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 762), (void *)_cffi_d_wlr_output_transformed_resolution },
  { "wlr_pointer_constraint_v1_send_activated", (void *)_cffi_f_wlr_pointer_constraint_v1_send_activated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 851), (void *)_cffi_d_wlr_pointer_constraint_v1_send_activated },
  { "wlr_pointer_constraint_v1_send_deactivated", (void *)_cffi_f_wlr_pointer_constraint_v1_send_deactivated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 851), (void *)_cffi_d_wlr_pointer_constraint_v1_send_deactivated },
  { "wlr_pointer_constraints_v1_constraint_for_surface", (void *)_cffi_f_wlr_pointer_constraints_v1_constraint_for_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 300), (void *)_cffi_d_wlr_pointer_constraints_v1_constraint_for_surface },
  { "wlr_pointer_constraints_v1_create", (void *)_cffi_f_wlr_pointer_constraints_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 305), (void *)_cffi_d_wlr_pointer_constraints_v1_create },
  { "wlr_pointer_from_input_device", (void *)_cffi_f_wlr_pointer_from_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 297), (void *)_cffi_d_wlr_pointer_from_input_device },
  { "wlr_pointer_gestures_v1_create", (void *)_cffi_f_wlr_pointer_gestures_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 308), (void *)_cffi_d_wlr_pointer_gestures_v1_create },
  { "wlr_pointer_gestures_v1_send_hold_begin", (void *)_cffi_f_wlr_pointer_gestures_v1_send_hold_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 876), (void *)_cffi_d_wlr_pointer_gestures_v1_send_hold_begin },
  { "wlr_pointer_gestures_v1_send_hold_end", (void *)_cffi_f_wlr_pointer_gestures_v1_send_hold_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 854), (void *)_cffi_d_wlr_pointer_gestures_v1_send_hold_end },
  { "wlr_pointer_gestures_v1_send_pinch_begin", (void *)_cffi_f_wlr_pointer_gestures_v1_send_pinch_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 876), (void *)_cffi_d_wlr_pointer_gestures_v1_send_pinch_begin },
  { "wlr_pointer_gestures_v1_send_pinch_end", (void *)_cffi_f_wlr_pointer_gestures_v1_send_pinch_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 854), (void *)_cffi_d_wlr_pointer_gestures_v1_send_pinch_end },
  { "wlr_pointer_gestures_v1_send_pinch_update", (void *)_cffi_f_wlr_pointer_gestures_v1_send_pinch_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 867), (void *)_cffi_d_wlr_pointer_gestures_v1_send_pinch_update },
  { "wlr_pointer_gestures_v1_send_swipe_begin", (void *)_cffi_f_wlr_pointer_gestures_v1_send_swipe_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 876), (void *)_cffi_d_wlr_pointer_gestures_v1_send_swipe_begin },
  { "wlr_pointer_gestures_v1_send_swipe_end", (void *)_cffi_f_wlr_pointer_gestures_v1_send_swipe_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 854), (void *)_cffi_d_wlr_pointer_gestures_v1_send_swipe_end },
  { "wlr_pointer_gestures_v1_send_swipe_update", (void *)_cffi_f_wlr_pointer_gestures_v1_send_swipe_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 860), (void *)_cffi_d_wlr_pointer_gestures_v1_send_swipe_update },
  { "wlr_presentation_create", (void *)_cffi_f_wlr_presentation_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 311), (void *)_cffi_d_wlr_presentation_create },
  { "wlr_primary_selection_v1_device_manager_create", (void *)_cffi_f_wlr_primary_selection_v1_device_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 315), (void *)_cffi_d_wlr_primary_selection_v1_device_manager_create },
  { "wlr_region_transform", (void *)_cffi_f_wlr_region_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 603), (void *)_cffi_d_wlr_region_transform },
  { "wlr_relative_pointer_manager_v1_create", (void *)_cffi_f_wlr_relative_pointer_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 318), (void *)_cffi_d_wlr_relative_pointer_manager_v1_create },
  { "wlr_relative_pointer_manager_v1_send_relative_motion", (void *)_cffi_f_wlr_relative_pointer_manager_v1_send_relative_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 882), (void *)_cffi_d_wlr_relative_pointer_manager_v1_send_relative_motion },
  { "wlr_render_rect", (void *)_cffi_f_wlr_render_rect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 902), (void *)_cffi_d_wlr_render_rect },
  { "wlr_render_texture", (void *)_cffi_f_wlr_render_texture, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 66), (void *)_cffi_d_wlr_render_texture },
  { "wlr_render_texture_with_matrix", (void *)_cffi_f_wlr_render_texture_with_matrix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 60), (void *)_cffi_d_wlr_render_texture_with_matrix },
  { "wlr_renderer_autocreate", (void *)_cffi_f_wlr_renderer_autocreate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 321), (void *)_cffi_d_wlr_renderer_autocreate },
  { "wlr_renderer_begin", (void *)_cffi_f_wlr_renderer_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 51), (void *)_cffi_d_wlr_renderer_begin },
  { "wlr_renderer_clear", (void *)_cffi_f_wlr_renderer_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 894), (void *)_cffi_d_wlr_renderer_clear },
  { "wlr_renderer_destroy", (void *)_cffi_f_wlr_renderer_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 891), (void *)_cffi_d_wlr_renderer_destroy },
  { "wlr_renderer_end", (void *)_cffi_f_wlr_renderer_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 891), (void *)_cffi_d_wlr_renderer_end },
  { "wlr_renderer_get_shm_texture_formats", (void *)_cffi_f_wlr_renderer_get_shm_texture_formats, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 504), (void *)_cffi_d_wlr_renderer_get_shm_texture_formats },
  { "wlr_renderer_init_wl_display", (void *)_cffi_f_wlr_renderer_init_wl_display, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 56), (void *)_cffi_d_wlr_renderer_init_wl_display },
  { "wlr_renderer_scissor", (void *)_cffi_f_wlr_renderer_scissor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 898), (void *)_cffi_d_wlr_renderer_scissor },
  { "wlr_scene_attach_output_layout", (void *)_cffi_f_wlr_scene_attach_output_layout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 348), (void *)_cffi_d_wlr_scene_attach_output_layout },
  { "wlr_scene_buffer_create", (void *)_cffi_f_wlr_scene_buffer_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 329), (void *)_cffi_d_wlr_scene_buffer_create },
  { "wlr_scene_buffer_from_node", (void *)_cffi_f_wlr_scene_buffer_from_node, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 326), (void *)_cffi_d_wlr_scene_buffer_from_node },
  { "wlr_scene_buffer_send_frame_done", (void *)_cffi_f_wlr_scene_buffer_send_frame_done, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 935), (void *)_cffi_d_wlr_scene_buffer_send_frame_done },
  { "wlr_scene_buffer_set_buffer", (void *)_cffi_f_wlr_scene_buffer_set_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 939), (void *)_cffi_d_wlr_scene_buffer_set_buffer },
  { "wlr_scene_buffer_set_buffer_with_damage", (void *)_cffi_f_wlr_scene_buffer_set_buffer_with_damage, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 943), (void *)_cffi_d_wlr_scene_buffer_set_buffer_with_damage },
  { "wlr_scene_buffer_set_dest_size", (void *)_cffi_f_wlr_scene_buffer_set_dest_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 920), (void *)_cffi_d_wlr_scene_buffer_set_dest_size },
  { "wlr_scene_buffer_set_opacity", (void *)_cffi_f_wlr_scene_buffer_set_opacity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 916), (void *)_cffi_d_wlr_scene_buffer_set_opacity },
  { "wlr_scene_buffer_set_opaque_region", (void *)_cffi_f_wlr_scene_buffer_set_opaque_region, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 931), (void *)_cffi_d_wlr_scene_buffer_set_opaque_region },
  { "wlr_scene_buffer_set_source_box", (void *)_cffi_f_wlr_scene_buffer_set_source_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 948), (void *)_cffi_d_wlr_scene_buffer_set_source_box },
  { "wlr_scene_buffer_set_transform", (void *)_cffi_f_wlr_scene_buffer_set_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 912), (void *)_cffi_d_wlr_scene_buffer_set_transform },
  { "wlr_scene_create", (void *)_cffi_f_wlr_scene_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 324), (void *)_cffi_d_wlr_scene_create },
  { "wlr_scene_drag_icon_create", (void *)_cffi_f_wlr_scene_drag_icon_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 368), (void *)_cffi_d_wlr_scene_drag_icon_create },
  { "wlr_scene_get_scene_output", (void *)_cffi_f_wlr_scene_get_scene_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 344), (void *)_cffi_d_wlr_scene_get_scene_output },
  { "wlr_scene_layer_surface_v1_configure", (void *)_cffi_f_wlr_scene_layer_surface_v1_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 952), (void *)_cffi_d_wlr_scene_layer_surface_v1_configure },
  { "wlr_scene_layer_surface_v1_create", (void *)_cffi_f_wlr_scene_layer_surface_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_wlr_scene_layer_surface_v1_create },
  { "wlr_scene_node_at", (void *)_cffi_f_wlr_scene_node_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 337), (void *)_cffi_d_wlr_scene_node_at },
  { "wlr_scene_node_coords", (void *)_cffi_f_wlr_scene_node_coords, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 79), (void *)_cffi_d_wlr_scene_node_coords },
  { "wlr_scene_node_destroy", (void *)_cffi_f_wlr_scene_node_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 957), (void *)_cffi_d_wlr_scene_node_destroy },
  { "wlr_scene_node_for_each_buffer", (void *)_cffi_f_wlr_scene_node_for_each_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 981), (void *)_cffi_d_wlr_scene_node_for_each_buffer },
  { "wlr_scene_node_lower_to_bottom", (void *)_cffi_f_wlr_scene_node_lower_to_bottom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 957), (void *)_cffi_d_wlr_scene_node_lower_to_bottom },
  { "wlr_scene_node_place_above", (void *)_cffi_f_wlr_scene_node_place_above, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 973), (void *)_cffi_d_wlr_scene_node_place_above },
  { "wlr_scene_node_place_below", (void *)_cffi_f_wlr_scene_node_place_below, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 973), (void *)_cffi_d_wlr_scene_node_place_below },
  { "wlr_scene_node_raise_to_top", (void *)_cffi_f_wlr_scene_node_raise_to_top, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 957), (void *)_cffi_d_wlr_scene_node_raise_to_top },
  { "wlr_scene_node_reparent", (void *)_cffi_f_wlr_scene_node_reparent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 977), (void *)_cffi_d_wlr_scene_node_reparent },
  { "wlr_scene_node_set_enabled", (void *)_cffi_f_wlr_scene_node_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 960), (void *)_cffi_d_wlr_scene_node_set_enabled },
  { "wlr_scene_node_set_position", (void *)_cffi_f_wlr_scene_node_set_position, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 964), (void *)_cffi_d_wlr_scene_node_set_position },
  { "wlr_scene_output_commit", (void *)_cffi_f_wlr_scene_output_commit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_wlr_scene_output_commit },
  { "wlr_scene_output_create", (void *)_cffi_f_wlr_scene_output_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 344), (void *)_cffi_d_wlr_scene_output_create },
  { "wlr_scene_output_destroy", (void *)_cffi_f_wlr_scene_output_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 986), (void *)_cffi_d_wlr_scene_output_destroy },
  { "wlr_scene_output_for_each_buffer", (void *)_cffi_f_wlr_scene_output_for_each_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 998), (void *)_cffi_d_wlr_scene_output_for_each_buffer },
  { "wlr_scene_output_layout_add_output", (void *)_cffi_f_wlr_scene_output_layout_add_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1003), (void *)_cffi_d_wlr_scene_output_layout_add_output },
  { "wlr_scene_output_send_frame_done", (void *)_cffi_f_wlr_scene_output_send_frame_done, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 994), (void *)_cffi_d_wlr_scene_output_send_frame_done },
  { "wlr_scene_output_set_position", (void *)_cffi_f_wlr_scene_output_set_position, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 989), (void *)_cffi_d_wlr_scene_output_set_position },
  { "wlr_scene_rect_create", (void *)_cffi_f_wlr_scene_rect_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 352), (void *)_cffi_d_wlr_scene_rect_create },
  { "wlr_scene_rect_set_color", (void *)_cffi_f_wlr_scene_rect_set_color, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1008), (void *)_cffi_d_wlr_scene_rect_set_color },
  { "wlr_scene_rect_set_size", (void *)_cffi_f_wlr_scene_rect_set_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1012), (void *)_cffi_d_wlr_scene_rect_set_size },
  { "wlr_scene_set_presentation", (void *)_cffi_f_wlr_scene_set_presentation, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 908), (void *)_cffi_d_wlr_scene_set_presentation },
  { "wlr_scene_subsurface_tree_create", (void *)_cffi_f_wlr_scene_subsurface_tree_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 372), (void *)_cffi_d_wlr_scene_subsurface_tree_create },
  { "wlr_scene_subsurface_tree_set_clip", (void *)_cffi_f_wlr_scene_subsurface_tree_set_clip, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 969), (void *)_cffi_d_wlr_scene_subsurface_tree_set_clip },
  { "wlr_scene_surface_create", (void *)_cffi_f_wlr_scene_surface_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 361), (void *)_cffi_d_wlr_scene_surface_create },
  { "wlr_scene_surface_try_from_buffer", (void *)_cffi_f_wlr_scene_surface_try_from_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 358), (void *)_cffi_d_wlr_scene_surface_try_from_buffer },
  { "wlr_scene_tree_create", (void *)_cffi_f_wlr_scene_tree_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 365), (void *)_cffi_d_wlr_scene_tree_create },
  { "wlr_scene_xdg_surface_create", (void *)_cffi_f_wlr_scene_xdg_surface_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 376), (void *)_cffi_d_wlr_scene_xdg_surface_create },
  { "wlr_screencopy_manager_v1_create", (void *)_cffi_f_wlr_screencopy_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 380), (void *)_cffi_d_wlr_screencopy_manager_v1_create },
  { "wlr_seat_create", (void *)_cffi_f_wlr_seat_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_wlr_seat_create },
  { "wlr_seat_destroy", (void *)_cffi_f_wlr_seat_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_destroy },
  { "wlr_seat_get_keyboard", (void *)_cffi_f_wlr_seat_get_keyboard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 245), (void *)_cffi_d_wlr_seat_get_keyboard },
  { "wlr_seat_keyboard_clear_focus", (void *)_cffi_f_wlr_seat_keyboard_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_keyboard_clear_focus },
  { "wlr_seat_keyboard_end_grab", (void *)_cffi_f_wlr_seat_keyboard_end_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_keyboard_end_grab },
  { "wlr_seat_keyboard_has_grab", (void *)_cffi_f_wlr_seat_keyboard_has_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_wlr_seat_keyboard_has_grab },
  { "wlr_seat_keyboard_notify_enter", (void *)_cffi_f_wlr_seat_keyboard_notify_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1069), (void *)_cffi_d_wlr_seat_keyboard_notify_enter },
  { "wlr_seat_keyboard_notify_key", (void *)_cffi_f_wlr_seat_keyboard_notify_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1114), (void *)_cffi_d_wlr_seat_keyboard_notify_key },
  { "wlr_seat_keyboard_notify_modifiers", (void *)_cffi_f_wlr_seat_keyboard_notify_modifiers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1038), (void *)_cffi_d_wlr_seat_keyboard_notify_modifiers },
  { "wlr_seat_keyboard_start_grab", (void *)_cffi_f_wlr_seat_keyboard_start_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1047), (void *)_cffi_d_wlr_seat_keyboard_start_grab },
  { "wlr_seat_pointer_clear_focus", (void *)_cffi_f_wlr_seat_pointer_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_pointer_clear_focus },
  { "wlr_seat_pointer_end_grab", (void *)_cffi_f_wlr_seat_pointer_end_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_pointer_end_grab },
  { "wlr_seat_pointer_has_grab", (void *)_cffi_f_wlr_seat_pointer_has_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_wlr_seat_pointer_has_grab },
  { "wlr_seat_pointer_notify_axis", (void *)_cffi_f_wlr_seat_pointer_notify_axis, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1094), (void *)_cffi_d_wlr_seat_pointer_notify_axis },
  { "wlr_seat_pointer_notify_button", (void *)_cffi_f_wlr_seat_pointer_notify_button, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 519), (void *)_cffi_d_wlr_seat_pointer_notify_button },
  { "wlr_seat_pointer_notify_clear_focus", (void *)_cffi_f_wlr_seat_pointer_notify_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_pointer_notify_clear_focus },
  { "wlr_seat_pointer_notify_enter", (void *)_cffi_f_wlr_seat_pointer_notify_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1063), (void *)_cffi_d_wlr_seat_pointer_notify_enter },
  { "wlr_seat_pointer_notify_frame", (void *)_cffi_f_wlr_seat_pointer_notify_frame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_pointer_notify_frame },
  { "wlr_seat_pointer_notify_motion", (void *)_cffi_f_wlr_seat_pointer_notify_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1088), (void *)_cffi_d_wlr_seat_pointer_notify_motion },
  { "wlr_seat_pointer_start_grab", (void *)_cffi_f_wlr_seat_pointer_start_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1051), (void *)_cffi_d_wlr_seat_pointer_start_grab },
  { "wlr_seat_pointer_surface_has_focus", (void *)_cffi_f_wlr_seat_pointer_surface_has_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_wlr_seat_pointer_surface_has_focus },
  { "wlr_seat_set_capabilities", (void *)_cffi_f_wlr_seat_set_capabilities, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1084), (void *)_cffi_d_wlr_seat_set_capabilities },
  { "wlr_seat_set_keyboard", (void *)_cffi_f_wlr_seat_set_keyboard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1034), (void *)_cffi_d_wlr_seat_set_keyboard },
  { "wlr_seat_set_name", (void *)_cffi_f_wlr_seat_set_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1020), (void *)_cffi_d_wlr_seat_set_name },
  { "wlr_seat_set_primary_selection", (void *)_cffi_f_wlr_seat_set_primary_selection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1042), (void *)_cffi_d_wlr_seat_set_primary_selection },
  { "wlr_seat_set_selection", (void *)_cffi_f_wlr_seat_set_selection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1024), (void *)_cffi_d_wlr_seat_set_selection },
  { "wlr_seat_start_pointer_drag", (void *)_cffi_f_wlr_seat_start_pointer_drag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1029), (void *)_cffi_d_wlr_seat_start_pointer_drag },
  { "wlr_seat_touch_end_grab", (void *)_cffi_f_wlr_seat_touch_end_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_touch_end_grab },
  { "wlr_seat_touch_get_point", (void *)_cffi_f_wlr_seat_touch_get_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 450), (void *)_cffi_d_wlr_seat_touch_get_point },
  { "wlr_seat_touch_has_grab", (void *)_cffi_f_wlr_seat_touch_has_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_wlr_seat_touch_has_grab },
  { "wlr_seat_touch_notify_cancel", (void *)_cffi_f_wlr_seat_touch_notify_cancel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1059), (void *)_cffi_d_wlr_seat_touch_notify_cancel },
  { "wlr_seat_touch_notify_down", (void *)_cffi_f_wlr_seat_touch_notify_down, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 511), (void *)_cffi_d_wlr_seat_touch_notify_down },
  { "wlr_seat_touch_notify_frame", (void *)_cffi_f_wlr_seat_touch_notify_frame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_touch_notify_frame },
  { "wlr_seat_touch_notify_motion", (void *)_cffi_f_wlr_seat_touch_notify_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1107), (void *)_cffi_d_wlr_seat_touch_notify_motion },
  { "wlr_seat_touch_notify_up", (void *)_cffi_f_wlr_seat_touch_notify_up, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1102), (void *)_cffi_d_wlr_seat_touch_notify_up },
  { "wlr_seat_touch_num_points", (void *)_cffi_f_wlr_seat_touch_num_points, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_wlr_seat_touch_num_points },
  { "wlr_seat_touch_point_clear_focus", (void *)_cffi_f_wlr_seat_touch_point_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1102), (void *)_cffi_d_wlr_seat_touch_point_clear_focus },
  { "wlr_seat_touch_point_focus", (void *)_cffi_f_wlr_seat_touch_point_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1076), (void *)_cffi_d_wlr_seat_touch_point_focus },
  { "wlr_seat_touch_send_cancel", (void *)_cffi_f_wlr_seat_touch_send_cancel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1059), (void *)_cffi_d_wlr_seat_touch_send_cancel },
  { "wlr_seat_touch_send_down", (void *)_cffi_f_wlr_seat_touch_send_down, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 511), (void *)_cffi_d_wlr_seat_touch_send_down },
  { "wlr_seat_touch_send_frame", (void *)_cffi_f_wlr_seat_touch_send_frame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1017), (void *)_cffi_d_wlr_seat_touch_send_frame },
  { "wlr_seat_touch_send_motion", (void *)_cffi_f_wlr_seat_touch_send_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1107), (void *)_cffi_d_wlr_seat_touch_send_motion },
  { "wlr_seat_touch_send_up", (void *)_cffi_f_wlr_seat_touch_send_up, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1102), (void *)_cffi_d_wlr_seat_touch_send_up },
  { "wlr_seat_touch_start_grab", (void *)_cffi_f_wlr_seat_touch_start_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1055), (void *)_cffi_d_wlr_seat_touch_start_grab },
  { "wlr_seat_validate_pointer_grab_serial", (void *)_cffi_f_wlr_seat_validate_pointer_grab_serial, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_wlr_seat_validate_pointer_grab_serial },
  { "wlr_server_decoration_manager_create", (void *)_cffi_f_wlr_server_decoration_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 387), (void *)_cffi_d_wlr_server_decoration_manager_create },
  { "wlr_server_decoration_manager_set_default_mode", (void *)_cffi_f_wlr_server_decoration_manager_set_default_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1120), (void *)_cffi_d_wlr_server_decoration_manager_set_default_mode },
  { "wlr_session_change_vt", (void *)_cffi_f_wlr_session_change_vt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_wlr_session_change_vt },
  { "wlr_session_lock_manager_v1_create", (void *)_cffi_f_wlr_session_lock_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 390), (void *)_cffi_d_wlr_session_lock_manager_v1_create },
  { "wlr_session_lock_surface_v1_configure", (void *)_cffi_f_wlr_session_lock_surface_v1_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 525), (void *)_cffi_d_wlr_session_lock_surface_v1_configure },
  { "wlr_session_lock_surface_v1_try_from_wlr_surface", (void *)_cffi_f_wlr_session_lock_surface_v1_try_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 393), (void *)_cffi_d_wlr_session_lock_surface_v1_try_from_wlr_surface },
  { "wlr_session_lock_v1_destroy", (void *)_cffi_f_wlr_session_lock_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1124), (void *)_cffi_d_wlr_session_lock_v1_destroy },
  { "wlr_session_lock_v1_send_locked", (void *)_cffi_f_wlr_session_lock_v1_send_locked, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1124), (void *)_cffi_d_wlr_session_lock_v1_send_locked },
  { "wlr_single_pixel_buffer_manager_v1_create", (void *)_cffi_f_wlr_single_pixel_buffer_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 396), (void *)_cffi_d_wlr_single_pixel_buffer_manager_v1_create },
  { "wlr_subcompositor_create", (void *)_cffi_f_wlr_subcompositor_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 399), (void *)_cffi_d_wlr_subcompositor_create },
  { "wlr_surface_accepts_touch", (void *)_cffi_f_wlr_surface_accepts_touch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_wlr_surface_accepts_touch },
  { "wlr_surface_for_each_surface", (void *)_cffi_f_wlr_surface_for_each_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1164), (void *)_cffi_d_wlr_surface_for_each_surface },
  { "wlr_surface_from_resource", (void *)_cffi_f_wlr_surface_from_resource, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 402), (void *)_cffi_d_wlr_surface_from_resource },
  { "wlr_surface_get_buffer_source_box", (void *)_cffi_f_wlr_surface_get_buffer_source_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1152), (void *)_cffi_d_wlr_surface_get_buffer_source_box },
  { "wlr_surface_get_effective_damage", (void *)_cffi_f_wlr_surface_get_effective_damage, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1140), (void *)_cffi_d_wlr_surface_get_effective_damage },
  { "wlr_surface_get_extends", (void *)_cffi_f_wlr_surface_get_extends, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1148), (void *)_cffi_d_wlr_surface_get_extends },
  { "wlr_surface_get_root_surface", (void *)_cffi_f_wlr_surface_get_root_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 412), (void *)_cffi_d_wlr_surface_get_root_surface },
  { "wlr_surface_get_texture", (void *)_cffi_f_wlr_surface_get_texture, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 444), (void *)_cffi_d_wlr_surface_get_texture },
  { "wlr_surface_has_buffer", (void *)_cffi_f_wlr_surface_has_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 104), (void *)_cffi_d_wlr_surface_has_buffer },
  { "wlr_surface_lock_pending", (void *)_cffi_f_wlr_surface_lock_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 530), (void *)_cffi_d_wlr_surface_lock_pending },
  { "wlr_surface_point_accepts_input", (void *)_cffi_f_wlr_surface_point_accepts_input, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 107), (void *)_cffi_d_wlr_surface_point_accepts_input },
  { "wlr_surface_send_enter", (void *)_cffi_f_wlr_surface_send_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1156), (void *)_cffi_d_wlr_surface_send_enter },
  { "wlr_surface_send_frame_done", (void *)_cffi_f_wlr_surface_send_frame_done, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1144), (void *)_cffi_d_wlr_surface_send_frame_done },
  { "wlr_surface_send_leave", (void *)_cffi_f_wlr_surface_send_leave, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1156), (void *)_cffi_d_wlr_surface_send_leave },
  { "wlr_surface_set_role", (void *)_cffi_f_wlr_surface_set_role, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 112), (void *)_cffi_d_wlr_surface_set_role },
  { "wlr_surface_surface_at", (void *)_cffi_f_wlr_surface_surface_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 415), (void *)_cffi_d_wlr_surface_surface_at },
  { "wlr_surface_unlock_cached", (void *)_cffi_f_wlr_surface_unlock_cached, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1160), (void *)_cffi_d_wlr_surface_unlock_cached },
  { "wlr_switch_from_input_device", (void *)_cffi_f_wlr_switch_from_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 429), (void *)_cffi_d_wlr_switch_from_input_device },
  { "wlr_texture_destroy", (void *)_cffi_f_wlr_texture_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1169), (void *)_cffi_d_wlr_texture_destroy },
  { "wlr_texture_from_buffer", (void *)_cffi_f_wlr_texture_from_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 432), (void *)_cffi_d_wlr_texture_from_buffer },
  { "wlr_texture_from_pixels", (void *)_cffi_f_wlr_texture_from_pixels, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 436), (void *)_cffi_d_wlr_texture_from_pixels },
  { "wlr_texture_update_from_buffer", (void *)_cffi_f_wlr_texture_update_from_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_wlr_texture_update_from_buffer },
  { "wlr_touch_from_input_device", (void *)_cffi_f_wlr_touch_from_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 447), (void *)_cffi_d_wlr_touch_from_input_device },
  { "wlr_viewporter_create", (void *)_cffi_f_wlr_viewporter_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 454), (void *)_cffi_d_wlr_viewporter_create },
  { "wlr_virtual_keyboard_manager_v1_create", (void *)_cffi_f_wlr_virtual_keyboard_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 457), (void *)_cffi_d_wlr_virtual_keyboard_manager_v1_create },
  { "wlr_virtual_pointer_manager_v1_create", (void *)_cffi_f_wlr_virtual_pointer_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 463), (void *)_cffi_d_wlr_virtual_pointer_manager_v1_create },
  { "wlr_xcursor_manager_create", (void *)_cffi_f_wlr_xcursor_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 471), (void *)_cffi_d_wlr_xcursor_manager_create },
  { "wlr_xcursor_manager_destroy", (void *)_cffi_f_wlr_xcursor_manager_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1172), (void *)_cffi_d_wlr_xcursor_manager_destroy },
  { "wlr_xcursor_manager_get_xcursor", (void *)_cffi_f_wlr_xcursor_manager_get_xcursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 466), (void *)_cffi_d_wlr_xcursor_manager_get_xcursor },
  { "wlr_xcursor_manager_load", (void *)_cffi_f_wlr_xcursor_manager_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 152), (void *)_cffi_d_wlr_xcursor_manager_load },
  { "wlr_xdg_activation_v1_create", (void *)_cffi_f_wlr_xdg_activation_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 475), (void *)_cffi_d_wlr_xdg_activation_v1_create },
  { "wlr_xdg_decoration_manager_v1_create", (void *)_cffi_f_wlr_xdg_decoration_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 478), (void *)_cffi_d_wlr_xdg_decoration_manager_v1_create },
  { "wlr_xdg_output_manager_v1_create", (void *)_cffi_f_wlr_xdg_output_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 481), (void *)_cffi_d_wlr_xdg_output_manager_v1_create },
  { "wlr_xdg_popup_destroy", (void *)_cffi_f_wlr_xdg_popup_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1175), (void *)_cffi_d_wlr_xdg_popup_destroy },
  { "wlr_xdg_popup_unconstrain_from_box", (void *)_cffi_f_wlr_xdg_popup_unconstrain_from_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1178), (void *)_cffi_d_wlr_xdg_popup_unconstrain_from_box },
  { "wlr_xdg_shell_create", (void *)_cffi_f_wlr_xdg_shell_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 485), (void *)_cffi_d_wlr_xdg_shell_create },
  { "wlr_xdg_surface_for_each_popup_surface", (void *)_cffi_f_wlr_xdg_surface_for_each_popup_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1189), (void *)_cffi_d_wlr_xdg_surface_for_each_popup_surface },
  { "wlr_xdg_surface_for_each_surface", (void *)_cffi_f_wlr_xdg_surface_for_each_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1189), (void *)_cffi_d_wlr_xdg_surface_for_each_surface },
  { "wlr_xdg_surface_get_geometry", (void *)_cffi_f_wlr_xdg_surface_get_geometry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1185), (void *)_cffi_d_wlr_xdg_surface_get_geometry },
  { "wlr_xdg_surface_ping", (void *)_cffi_f_wlr_xdg_surface_ping, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1182), (void *)_cffi_d_wlr_xdg_surface_ping },
  { "wlr_xdg_surface_schedule_configure", (void *)_cffi_f_wlr_xdg_surface_schedule_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 533), (void *)_cffi_d_wlr_xdg_surface_schedule_configure },
  { "wlr_xdg_surface_surface_at", (void *)_cffi_f_wlr_xdg_surface_surface_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 422), (void *)_cffi_d_wlr_xdg_surface_surface_at },
  { "wlr_xdg_surface_try_from_wlr_surface", (void *)_cffi_f_wlr_xdg_surface_try_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 489), (void *)_cffi_d_wlr_xdg_surface_try_from_wlr_surface },
  { "wlr_xdg_toplevel_decoration_v1_set_mode", (void *)_cffi_f_wlr_xdg_toplevel_decoration_v1_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 549), (void *)_cffi_d_wlr_xdg_toplevel_decoration_v1_set_mode },
  { "wlr_xdg_toplevel_send_close", (void *)_cffi_f_wlr_xdg_toplevel_send_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1194), (void *)_cffi_d_wlr_xdg_toplevel_send_close },
  { "wlr_xdg_toplevel_set_activated", (void *)_cffi_f_wlr_xdg_toplevel_set_activated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_wlr_xdg_toplevel_set_activated },
  { "wlr_xdg_toplevel_set_bounds", (void *)_cffi_f_wlr_xdg_toplevel_set_bounds, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 540), (void *)_cffi_d_wlr_xdg_toplevel_set_bounds },
  { "wlr_xdg_toplevel_set_fullscreen", (void *)_cffi_f_wlr_xdg_toplevel_set_fullscreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_wlr_xdg_toplevel_set_fullscreen },
  { "wlr_xdg_toplevel_set_maximized", (void *)_cffi_f_wlr_xdg_toplevel_set_maximized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_wlr_xdg_toplevel_set_maximized },
  { "wlr_xdg_toplevel_set_resizing", (void *)_cffi_f_wlr_xdg_toplevel_set_resizing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_wlr_xdg_toplevel_set_resizing },
  { "wlr_xdg_toplevel_set_size", (void *)_cffi_f_wlr_xdg_toplevel_set_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 540), (void *)_cffi_d_wlr_xdg_toplevel_set_size },
  { "wlr_xdg_toplevel_set_tiled", (void *)_cffi_f_wlr_xdg_toplevel_set_tiled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 545), (void *)_cffi_d_wlr_xdg_toplevel_set_tiled },
  { "wlr_xdg_toplevel_set_wm_capabilities", (void *)_cffi_f_wlr_xdg_toplevel_set_wm_capabilities, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 545), (void *)_cffi_d_wlr_xdg_toplevel_set_wm_capabilities },
  { "wlr_xwayland_create", (void *)_cffi_f_wlr_xwayland_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 492), (void *)_cffi_d_wlr_xwayland_create },
  { "wlr_xwayland_destroy", (void *)_cffi_f_wlr_xwayland_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1197), (void *)_cffi_d_wlr_xwayland_destroy },
  { "wlr_xwayland_icccm_input_model", (void *)_cffi_f_wlr_xwayland_icccm_input_model, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 133), (void *)_cffi_d_wlr_xwayland_icccm_input_model },
  { "wlr_xwayland_or_surface_wants_focus", (void *)_cffi_f_wlr_xwayland_or_surface_wants_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 123), (void *)_cffi_d_wlr_xwayland_or_surface_wants_focus },
  { "wlr_xwayland_server_create", (void *)_cffi_f_wlr_xwayland_server_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 497), (void *)_cffi_d_wlr_xwayland_server_create },
  { "wlr_xwayland_server_destroy", (void *)_cffi_f_wlr_xwayland_server_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1213), (void *)_cffi_d_wlr_xwayland_server_destroy },
  { "wlr_xwayland_set_cursor", (void *)_cffi_f_wlr_xwayland_set_cursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1204), (void *)_cffi_d_wlr_xwayland_set_cursor },
  { "wlr_xwayland_set_seat", (void *)_cffi_f_wlr_xwayland_set_seat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1200), (void *)_cffi_d_wlr_xwayland_set_seat },
  { "wlr_xwayland_surface_activate", (void *)_cffi_f_wlr_xwayland_surface_activate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1219), (void *)_cffi_d_wlr_xwayland_surface_activate },
  { "wlr_xwayland_surface_close", (void *)_cffi_f_wlr_xwayland_surface_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1216), (void *)_cffi_d_wlr_xwayland_surface_close },
  { "wlr_xwayland_surface_configure", (void *)_cffi_f_wlr_xwayland_surface_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1223), (void *)_cffi_d_wlr_xwayland_surface_configure },
  { "wlr_xwayland_surface_ping", (void *)_cffi_f_wlr_xwayland_surface_ping, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1216), (void *)_cffi_d_wlr_xwayland_surface_ping },
  { "wlr_xwayland_surface_restack", (void *)_cffi_f_wlr_xwayland_surface_restack, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1230), (void *)_cffi_d_wlr_xwayland_surface_restack },
  { "wlr_xwayland_surface_set_fullscreen", (void *)_cffi_f_wlr_xwayland_surface_set_fullscreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1219), (void *)_cffi_d_wlr_xwayland_surface_set_fullscreen },
  { "wlr_xwayland_surface_set_maximized", (void *)_cffi_f_wlr_xwayland_surface_set_maximized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1219), (void *)_cffi_d_wlr_xwayland_surface_set_maximized },
  { "wlr_xwayland_surface_set_minimized", (void *)_cffi_f_wlr_xwayland_surface_set_minimized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1219), (void *)_cffi_d_wlr_xwayland_surface_set_minimized },
  { "wlr_xwayland_surface_try_from_wlr_surface", (void *)_cffi_f_wlr_xwayland_surface_try_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 501), (void *)_cffi_d_wlr_xwayland_surface_try_from_wlr_surface },
  { "wrapped_log_init", (void *)_cffi_f_wrapped_log_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 557), (void *)_cffi_d_wrapped_log_init },
  { "xcb_connect", (void *)_cffi_f_xcb_connect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1246), (void *)_cffi_d_xcb_connect },
  { "xcb_connection_has_error", (void *)_cffi_f_xcb_connection_has_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 170), (void *)_cffi_d_xcb_connection_has_error },
  { "xcb_disconnect", (void *)_cffi_f_xcb_disconnect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1243), (void *)_cffi_d_xcb_disconnect },
  { "xcb_intern_atom", (void *)_cffi_f_xcb_intern_atom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1250), (void *)_cffi_d_xcb_intern_atom },
  { "xcb_intern_atom_reply", (void *)_cffi_f_xcb_intern_atom_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1256), (void *)_cffi_d_xcb_intern_atom_reply },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "flags", offsetof(xcb_size_hints_t, flags),
             sizeof(((xcb_size_hints_t *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "x", offsetof(xcb_size_hints_t, x),
         sizeof(((xcb_size_hints_t *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "y", offsetof(xcb_size_hints_t, y),
         sizeof(((xcb_size_hints_t *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "width", offsetof(xcb_size_hints_t, width),
             sizeof(((xcb_size_hints_t *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "height", offsetof(xcb_size_hints_t, height),
              sizeof(((xcb_size_hints_t *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "min_width", offsetof(xcb_size_hints_t, min_width),
                 sizeof(((xcb_size_hints_t *)0)->min_width),
                 _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "min_height", offsetof(xcb_size_hints_t, min_height),
                  sizeof(((xcb_size_hints_t *)0)->min_height),
                  _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "max_width", offsetof(xcb_size_hints_t, max_width),
                 sizeof(((xcb_size_hints_t *)0)->max_width),
                 _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "max_height", offsetof(xcb_size_hints_t, max_height),
                  sizeof(((xcb_size_hints_t *)0)->max_height),
                  _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "width_inc", offsetof(xcb_size_hints_t, width_inc),
                 sizeof(((xcb_size_hints_t *)0)->width_inc),
                 _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "height_inc", offsetof(xcb_size_hints_t, height_inc),
                  sizeof(((xcb_size_hints_t *)0)->height_inc),
                  _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "min_aspect_num", offsetof(xcb_size_hints_t, min_aspect_num),
                      sizeof(((xcb_size_hints_t *)0)->min_aspect_num),
                      _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "min_aspect_den", offsetof(xcb_size_hints_t, min_aspect_den),
                      sizeof(((xcb_size_hints_t *)0)->min_aspect_den),
                      _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "max_aspect_num", offsetof(xcb_size_hints_t, max_aspect_num),
                      sizeof(((xcb_size_hints_t *)0)->max_aspect_num),
                      _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "max_aspect_den", offsetof(xcb_size_hints_t, max_aspect_den),
                      sizeof(((xcb_size_hints_t *)0)->max_aspect_den),
                      _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "base_width", offsetof(xcb_size_hints_t, base_width),
                  sizeof(((xcb_size_hints_t *)0)->base_width),
                  _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "base_height", offsetof(xcb_size_hints_t, base_height),
                   sizeof(((xcb_size_hints_t *)0)->base_height),
                   _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "win_gravity", offsetof(xcb_size_hints_t, win_gravity),
                   sizeof(((xcb_size_hints_t *)0)->win_gravity),
                   _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "x1", offsetof(struct pixman_box32, x1),
          sizeof(((struct pixman_box32 *)0)->x1),
          _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "y1", offsetof(struct pixman_box32, y1),
          sizeof(((struct pixman_box32 *)0)->y1),
          _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "x2", offsetof(struct pixman_box32, x2),
          sizeof(((struct pixman_box32 *)0)->x2),
          _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "y2", offsetof(struct pixman_box32, y2),
          sizeof(((struct pixman_box32 *)0)->y2),
          _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "tv_sec", offsetof(struct timespec, tv_sec),
              sizeof(((struct timespec *)0)->tv_sec),
              _CFFI_OP(_CFFI_OP_NOOP, 1320) },
  { "tv_nsec", offsetof(struct timespec, tv_nsec),
               sizeof(((struct timespec *)0)->tv_nsec),
               _CFFI_OP(_CFFI_OP_NOOP, 1320) },
  { "impl", offsetof(struct wlr_addon, impl),
            sizeof(((struct wlr_addon *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1417) },
  { "addons", offsetof(struct wlr_addon_set, addons),
              sizeof(((struct wlr_addon_set *)0)->addons),
              _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "impl", offsetof(struct wlr_backend, impl),
            sizeof(((struct wlr_backend *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1422) },
  { "events", offsetof(struct wlr_backend, events),
              sizeof(((struct wlr_backend *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1333) },
  { "x", offsetof(struct wlr_box, x),
         sizeof(((struct wlr_box *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "y", offsetof(struct wlr_box, y),
         sizeof(((struct wlr_box *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "width", offsetof(struct wlr_box, width),
             sizeof(((struct wlr_box *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "height", offsetof(struct wlr_box, height),
              sizeof(((struct wlr_box *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "global", offsetof(struct wlr_compositor, global),
              sizeof(((struct wlr_compositor *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "renderer", offsetof(struct wlr_compositor, renderer),
                sizeof(((struct wlr_compositor *)0)->renderer),
                _CFFI_OP(_CFFI_OP_NOOP, 45) },
  { "display_destroy", offsetof(struct wlr_compositor, display_destroy),
                       sizeof(((struct wlr_compositor *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_compositor, events),
              sizeof(((struct wlr_compositor *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1355) },
  { "state", offsetof(struct wlr_cursor, state),
             sizeof(((struct wlr_cursor *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1430) },
  { "x", offsetof(struct wlr_cursor, x),
         sizeof(((struct wlr_cursor *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_cursor, y),
         sizeof(((struct wlr_cursor *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "events", offsetof(struct wlr_cursor, events),
              sizeof(((struct wlr_cursor *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1344) },
  { "data", offsetof(struct wlr_cursor, data),
            sizeof(((struct wlr_cursor *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "width", offsetof(struct wlr_damage_ring, width),
             sizeof(((struct wlr_damage_ring *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "height", offsetof(struct wlr_damage_ring, height),
              sizeof(((struct wlr_damage_ring *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "current", offsetof(struct wlr_damage_ring, current),
               sizeof(((struct wlr_damage_ring *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "global", offsetof(struct wlr_data_control_manager_v1, global),
              sizeof(((struct wlr_data_control_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "devices", offsetof(struct wlr_data_control_manager_v1, devices),
               sizeof(((struct wlr_data_control_manager_v1 *)0)->devices),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_data_control_manager_v1, events),
              sizeof(((struct wlr_data_control_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1385) },
  { "display_destroy", offsetof(struct wlr_data_control_manager_v1, display_destroy),
                       sizeof(((struct wlr_data_control_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "impl", offsetof(struct wlr_data_source, impl),
            sizeof(((struct wlr_data_source *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1438) },
  { "mime_types", offsetof(struct wlr_data_source, mime_types),
                  sizeof(((struct wlr_data_source *)0)->mime_types),
                  _CFFI_OP(_CFFI_OP_NOOP, 1395) },
  { "actions", offsetof(struct wlr_data_source, actions),
               sizeof(((struct wlr_data_source *)0)->actions),
               _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "accepted", offsetof(struct wlr_data_source, accepted),
                sizeof(((struct wlr_data_source *)0)->accepted),
                _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "current_dnd_action", offsetof(struct wlr_data_source, current_dnd_action),
                          sizeof(((struct wlr_data_source *)0)->current_dnd_action),
                          _CFFI_OP(_CFFI_OP_NOOP, 1269) },
  { "compositor_action", offsetof(struct wlr_data_source, compositor_action),
                         sizeof(((struct wlr_data_source *)0)->compositor_action),
                         _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "events", offsetof(struct wlr_data_source, events),
              sizeof(((struct wlr_data_source *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1388) },
  { "grab_type", offsetof(struct wlr_drag, grab_type),
                 sizeof(((struct wlr_drag *)0)->grab_type),
                 _CFFI_OP(_CFFI_OP_NOOP, 1273) },
  { "keyboard_grab", offsetof(struct wlr_drag, keyboard_grab),
                     sizeof(((struct wlr_drag *)0)->keyboard_grab),
                     _CFFI_OP(_CFFI_OP_NOOP, 1553) },
  { "pointer_grab", offsetof(struct wlr_drag, pointer_grab),
                    sizeof(((struct wlr_drag *)0)->pointer_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 1556) },
  { "touch_grab", offsetof(struct wlr_drag, touch_grab),
                  sizeof(((struct wlr_drag *)0)->touch_grab),
                  _CFFI_OP(_CFFI_OP_NOOP, 1562) },
  { "seat", offsetof(struct wlr_drag, seat),
            sizeof(((struct wlr_drag *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "seat_client", offsetof(struct wlr_drag, seat_client),
                   sizeof(((struct wlr_drag *)0)->seat_client),
                   _CFFI_OP(_CFFI_OP_NOOP, 1550) },
  { "focus_client", offsetof(struct wlr_drag, focus_client),
                    sizeof(((struct wlr_drag *)0)->focus_client),
                    _CFFI_OP(_CFFI_OP_NOOP, 1550) },
  { "icon", offsetof(struct wlr_drag, icon),
            sizeof(((struct wlr_drag *)0)->icon),
            _CFFI_OP(_CFFI_OP_NOOP, 370) },
  { "focus", offsetof(struct wlr_drag, focus),
             sizeof(((struct wlr_drag *)0)->focus),
             _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "source", offsetof(struct wlr_drag, source),
              sizeof(((struct wlr_drag *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 689) },
  { "started", offsetof(struct wlr_drag, started),
               sizeof(((struct wlr_drag *)0)->started),
               _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "dropped", offsetof(struct wlr_drag, dropped),
               sizeof(((struct wlr_drag *)0)->dropped),
               _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "cancelling", offsetof(struct wlr_drag, cancelling),
                  sizeof(((struct wlr_drag *)0)->cancelling),
                  _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "grab_touch_id", offsetof(struct wlr_drag, grab_touch_id),
                     sizeof(((struct wlr_drag *)0)->grab_touch_id),
                     _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "touch_id", offsetof(struct wlr_drag, touch_id),
                sizeof(((struct wlr_drag *)0)->touch_id),
                _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "events", offsetof(struct wlr_drag, events),
              sizeof(((struct wlr_drag *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1387) },
  { "source_destroy", offsetof(struct wlr_drag, source_destroy),
                      sizeof(((struct wlr_drag *)0)->source_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "seat_client_destroy", offsetof(struct wlr_drag, seat_client_destroy),
                           sizeof(((struct wlr_drag *)0)->seat_client_destroy),
                           _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "icon_destroy", offsetof(struct wlr_drag, icon_destroy),
                    sizeof(((struct wlr_drag *)0)->icon_destroy),
                    _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "data", offsetof(struct wlr_drag, data),
            sizeof(((struct wlr_drag *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "drag", offsetof(struct wlr_drag_drop_event, drag),
            sizeof(((struct wlr_drag_drop_event *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 1031) },
  { "time", offsetof(struct wlr_drag_drop_event, time),
            sizeof(((struct wlr_drag_drop_event *)0)->time),
            _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "drag", offsetof(struct wlr_drag_icon, drag),
            sizeof(((struct wlr_drag_icon *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 1031) },
  { "surface", offsetof(struct wlr_drag_icon, surface),
               sizeof(((struct wlr_drag_icon *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "events", offsetof(struct wlr_drag_icon, events),
              sizeof(((struct wlr_drag_icon *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1386) },
  { "surface_destroy", offsetof(struct wlr_drag_icon, surface_destroy),
                       sizeof(((struct wlr_drag_icon *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "data", offsetof(struct wlr_drag_icon, data),
            sizeof(((struct wlr_drag_icon *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "drag", offsetof(struct wlr_drag_motion_event, drag),
            sizeof(((struct wlr_drag_motion_event *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 1031) },
  { "time", offsetof(struct wlr_drag_motion_event, time),
            sizeof(((struct wlr_drag_motion_event *)0)->time),
            _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "sx", offsetof(struct wlr_drag_motion_event, sx),
          sizeof(((struct wlr_drag_motion_event *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "sy", offsetof(struct wlr_drag_motion_event, sy),
          sizeof(((struct wlr_drag_motion_event *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "resource", offsetof(struct wlr_export_dmabuf_frame_v1, resource),
                sizeof(((struct wlr_export_dmabuf_frame_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "manager", offsetof(struct wlr_export_dmabuf_frame_v1, manager),
               sizeof(((struct wlr_export_dmabuf_frame_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 1447) },
  { "link", offsetof(struct wlr_export_dmabuf_frame_v1, link),
            sizeof(((struct wlr_export_dmabuf_frame_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "output", offsetof(struct wlr_export_dmabuf_frame_v1, output),
              sizeof(((struct wlr_export_dmabuf_frame_v1 *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "cursor_locked", offsetof(struct wlr_export_dmabuf_frame_v1, cursor_locked),
                     sizeof(((struct wlr_export_dmabuf_frame_v1 *)0)->cursor_locked),
                     _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "output_commit", offsetof(struct wlr_export_dmabuf_frame_v1, output_commit),
                     sizeof(((struct wlr_export_dmabuf_frame_v1 *)0)->output_commit),
                     _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "global", offsetof(struct wlr_export_dmabuf_manager_v1, global),
              sizeof(((struct wlr_export_dmabuf_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "frames", offsetof(struct wlr_export_dmabuf_manager_v1, frames),
              sizeof(((struct wlr_export_dmabuf_manager_v1 *)0)->frames),
              _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_export_dmabuf_manager_v1, display_destroy),
                       sizeof(((struct wlr_export_dmabuf_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_export_dmabuf_manager_v1, events),
              sizeof(((struct wlr_export_dmabuf_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1323) },
  { "x", offsetof(struct wlr_fbox, x),
         sizeof(((struct wlr_fbox *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_fbox, y),
         sizeof(((struct wlr_fbox *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "width", offsetof(struct wlr_fbox, width),
             sizeof(((struct wlr_fbox *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "height", offsetof(struct wlr_fbox, height),
              sizeof(((struct wlr_fbox *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "manager", offsetof(struct wlr_foreign_toplevel_handle_v1, manager),
               sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 221) },
  { "resources", offsetof(struct wlr_foreign_toplevel_handle_v1, resources),
                 sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "link", offsetof(struct wlr_foreign_toplevel_handle_v1, link),
            sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "idle_source", offsetof(struct wlr_foreign_toplevel_handle_v1, idle_source),
                   sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->idle_source),
                   _CFFI_OP(_CFFI_OP_NOOP, 1401) },
  { "title", offsetof(struct wlr_foreign_toplevel_handle_v1, title),
             sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->title),
             _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "app_id", offsetof(struct wlr_foreign_toplevel_handle_v1, app_id),
              sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->app_id),
              _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "parent", offsetof(struct wlr_foreign_toplevel_handle_v1, parent),
              sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 692) },
  { "outputs", offsetof(struct wlr_foreign_toplevel_handle_v1, outputs),
               sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "state", offsetof(struct wlr_foreign_toplevel_handle_v1, state),
             sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "events", offsetof(struct wlr_foreign_toplevel_handle_v1, events),
              sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1326) },
  { "data", offsetof(struct wlr_foreign_toplevel_handle_v1, data),
            sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_activated_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_activated_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 692) },
  { "seat", offsetof(struct wlr_foreign_toplevel_handle_v1_activated_event, seat),
            sizeof(((struct wlr_foreign_toplevel_handle_v1_activated_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_fullscreen_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 692) },
  { "fullscreen", offsetof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event, fullscreen),
                  sizeof(((struct wlr_foreign_toplevel_handle_v1_fullscreen_event *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "output", offsetof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event, output),
              sizeof(((struct wlr_foreign_toplevel_handle_v1_fullscreen_event *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_maximized_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_maximized_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 692) },
  { "maximized", offsetof(struct wlr_foreign_toplevel_handle_v1_maximized_event, maximized),
                 sizeof(((struct wlr_foreign_toplevel_handle_v1_maximized_event *)0)->maximized),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_minimized_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_minimized_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 692) },
  { "minimized", offsetof(struct wlr_foreign_toplevel_handle_v1_minimized_event, minimized),
                 sizeof(((struct wlr_foreign_toplevel_handle_v1_minimized_event *)0)->minimized),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 692) },
  { "surface", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, surface),
               sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "x", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, x),
         sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "y", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, y),
         sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "width", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, width),
             sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "height", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, height),
              sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "event_loop", offsetof(struct wlr_foreign_toplevel_manager_v1, event_loop),
                  sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->event_loop),
                  _CFFI_OP(_CFFI_OP_NOOP, 1398) },
  { "global", offsetof(struct wlr_foreign_toplevel_manager_v1, global),
              sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "resources", offsetof(struct wlr_foreign_toplevel_manager_v1, resources),
                 sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "toplevels", offsetof(struct wlr_foreign_toplevel_manager_v1, toplevels),
                 sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->toplevels),
                 _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_foreign_toplevel_manager_v1, display_destroy),
                       sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_foreign_toplevel_manager_v1, events),
              sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1325) },
  { "data", offsetof(struct wlr_foreign_toplevel_manager_v1, data),
            sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_fractional_scale_manager_v1, global),
              sizeof(((struct wlr_fractional_scale_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "events", offsetof(struct wlr_fractional_scale_manager_v1, events),
              sizeof(((struct wlr_fractional_scale_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1327) },
  { "global", offsetof(struct wlr_gamma_control_manager_v1, global),
              sizeof(((struct wlr_gamma_control_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "controls", offsetof(struct wlr_gamma_control_manager_v1, controls),
                sizeof(((struct wlr_gamma_control_manager_v1 *)0)->controls),
                _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_gamma_control_manager_v1, display_destroy),
                       sizeof(((struct wlr_gamma_control_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_gamma_control_manager_v1, events),
              sizeof(((struct wlr_gamma_control_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1328) },
  { "data", offsetof(struct wlr_gamma_control_manager_v1, data),
            sizeof(((struct wlr_gamma_control_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "inhibitors", offsetof(struct wlr_idle_inhibit_manager_v1, inhibitors),
                  sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->inhibitors),
                  _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "global", offsetof(struct wlr_idle_inhibit_manager_v1, global),
              sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "display_destroy", offsetof(struct wlr_idle_inhibit_manager_v1, display_destroy),
                       sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_idle_inhibit_manager_v1, events),
              sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1329) },
  { "data", offsetof(struct wlr_idle_inhibit_manager_v1, data),
            sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "surface", offsetof(struct wlr_idle_inhibitor_v1, surface),
               sizeof(((struct wlr_idle_inhibitor_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "resource", offsetof(struct wlr_idle_inhibitor_v1, resource),
                sizeof(((struct wlr_idle_inhibitor_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "surface_destroy", offsetof(struct wlr_idle_inhibitor_v1, surface_destroy),
                       sizeof(((struct wlr_idle_inhibitor_v1 *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "link", offsetof(struct wlr_idle_inhibitor_v1, link),
            sizeof(((struct wlr_idle_inhibitor_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_idle_inhibitor_v1, events),
              sizeof(((struct wlr_idle_inhibitor_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1330) },
  { "data", offsetof(struct wlr_idle_inhibitor_v1, data),
            sizeof(((struct wlr_idle_inhibitor_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "type", offsetof(struct wlr_input_device, type),
            sizeof(((struct wlr_input_device *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 1275) },
  { "vendor", offsetof(struct wlr_input_device, vendor),
              sizeof(((struct wlr_input_device *)0)->vendor),
              _CFFI_OP(_CFFI_OP_NOOP, 102) },
  { "product", offsetof(struct wlr_input_device, product),
               sizeof(((struct wlr_input_device *)0)->product),
               _CFFI_OP(_CFFI_OP_NOOP, 102) },
  { "name", offsetof(struct wlr_input_device, name),
            sizeof(((struct wlr_input_device *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "events", offsetof(struct wlr_input_device, events),
              sizeof(((struct wlr_input_device *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1331) },
  { "data", offsetof(struct wlr_input_device, data),
            sizeof(((struct wlr_input_device *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_input_inhibit_manager, global),
              sizeof(((struct wlr_input_inhibit_manager *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "active_client", offsetof(struct wlr_input_inhibit_manager, active_client),
                     sizeof(((struct wlr_input_inhibit_manager *)0)->active_client),
                     _CFFI_OP(_CFFI_OP_NOOP, 611) },
  { "active_inhibitor", offsetof(struct wlr_input_inhibit_manager, active_inhibitor),
                        sizeof(((struct wlr_input_inhibit_manager *)0)->active_inhibitor),
                        _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "display_destroy", offsetof(struct wlr_input_inhibit_manager, display_destroy),
                       sizeof(((struct wlr_input_inhibit_manager *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_input_inhibit_manager, events),
              sizeof(((struct wlr_input_inhibit_manager *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1332) },
  { "data", offsetof(struct wlr_input_inhibit_manager, data),
            sizeof(((struct wlr_input_inhibit_manager *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "base", offsetof(struct wlr_keyboard, base),
            sizeof(((struct wlr_keyboard *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 1465) },
  { "impl", offsetof(struct wlr_keyboard, impl),
            sizeof(((struct wlr_keyboard *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1473) },
  { "group", offsetof(struct wlr_keyboard, group),
             sizeof(((struct wlr_keyboard *)0)->group),
             _CFFI_OP(_CFFI_OP_NOOP, 1471) },
  { "keymap_string", offsetof(struct wlr_keyboard, keymap_string),
                     sizeof(((struct wlr_keyboard *)0)->keymap_string),
                     _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "keymap_size", offsetof(struct wlr_keyboard, keymap_size),
                   sizeof(((struct wlr_keyboard *)0)->keymap_size),
                   _CFFI_OP(_CFFI_OP_NOOP, 1073) },
  { "keymap_fd", offsetof(struct wlr_keyboard, keymap_fd),
                 sizeof(((struct wlr_keyboard *)0)->keymap_fd),
                 _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "keymap", offsetof(struct wlr_keyboard, keymap),
              sizeof(((struct wlr_keyboard *)0)->keymap),
              _CFFI_OP(_CFFI_OP_NOOP, 725) },
  { "xkb_state", offsetof(struct wlr_keyboard, xkb_state),
                 sizeof(((struct wlr_keyboard *)0)->xkb_state),
                 _CFFI_OP(_CFFI_OP_NOOP, 1665) },
  { "led_indexes", offsetof(struct wlr_keyboard, led_indexes),
                   sizeof(((struct wlr_keyboard *)0)->led_indexes),
                   _CFFI_OP(_CFFI_OP_NOOP, 1673) },
  { "mod_indexes", offsetof(struct wlr_keyboard, mod_indexes),
                   sizeof(((struct wlr_keyboard *)0)->mod_indexes),
                   _CFFI_OP(_CFFI_OP_NOOP, 1675) },
  { "leds", offsetof(struct wlr_keyboard, leds),
            sizeof(((struct wlr_keyboard *)0)->leds),
            _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "keycodes", offsetof(struct wlr_keyboard, keycodes),
                sizeof(((struct wlr_keyboard *)0)->keycodes),
                _CFFI_OP(_CFFI_OP_NOOP, 1671) },
  { "num_keycodes", offsetof(struct wlr_keyboard, num_keycodes),
                    sizeof(((struct wlr_keyboard *)0)->num_keycodes),
                    _CFFI_OP(_CFFI_OP_NOOP, 1073) },
  { "modifiers", offsetof(struct wlr_keyboard, modifiers),
                 sizeof(((struct wlr_keyboard *)0)->modifiers),
                 _CFFI_OP(_CFFI_OP_NOOP, 1476) },
  { "repeat_info", offsetof(struct wlr_keyboard, repeat_info),
                   sizeof(((struct wlr_keyboard *)0)->repeat_info),
                   _CFFI_OP(_CFFI_OP_NOOP, 1334) },
  { "events", offsetof(struct wlr_keyboard, events),
              sizeof(((struct wlr_keyboard *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1335) },
  { "data", offsetof(struct wlr_keyboard, data),
            sizeof(((struct wlr_keyboard *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "time_msec", offsetof(struct wlr_keyboard_key_event, time_msec),
                 sizeof(((struct wlr_keyboard_key_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "keycode", offsetof(struct wlr_keyboard_key_event, keycode),
               sizeof(((struct wlr_keyboard_key_event *)0)->keycode),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "update_state", offsetof(struct wlr_keyboard_key_event, update_state),
                    sizeof(((struct wlr_keyboard_key_event *)0)->update_state),
                    _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "state", offsetof(struct wlr_keyboard_key_event, state),
             sizeof(((struct wlr_keyboard_key_event *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1270) },
  { "depressed", offsetof(struct wlr_keyboard_modifiers, depressed),
                 sizeof(((struct wlr_keyboard_modifiers *)0)->depressed),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "latched", offsetof(struct wlr_keyboard_modifiers, latched),
               sizeof(((struct wlr_keyboard_modifiers *)0)->latched),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "locked", offsetof(struct wlr_keyboard_modifiers, locked),
              sizeof(((struct wlr_keyboard_modifiers *)0)->locked),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "group", offsetof(struct wlr_keyboard_modifiers, group),
             sizeof(((struct wlr_keyboard_modifiers *)0)->group),
             _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "global", offsetof(struct wlr_layer_shell_v1, global),
              sizeof(((struct wlr_layer_shell_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "display_destroy", offsetof(struct wlr_layer_shell_v1, display_destroy),
                       sizeof(((struct wlr_layer_shell_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_layer_shell_v1, events),
              sizeof(((struct wlr_layer_shell_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1379) },
  { "data", offsetof(struct wlr_layer_shell_v1, data),
            sizeof(((struct wlr_layer_shell_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "surface", offsetof(struct wlr_layer_surface_v1, surface),
               sizeof(((struct wlr_layer_surface_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "output", offsetof(struct wlr_layer_surface_v1, output),
              sizeof(((struct wlr_layer_surface_v1 *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "resource", offsetof(struct wlr_layer_surface_v1, resource),
                sizeof(((struct wlr_layer_surface_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "shell", offsetof(struct wlr_layer_surface_v1, shell),
             sizeof(((struct wlr_layer_surface_v1 *)0)->shell),
             _CFFI_OP(_CFFI_OP_NOOP, 1477) },
  { "popups", offsetof(struct wlr_layer_surface_v1, popups),
              sizeof(((struct wlr_layer_surface_v1 *)0)->popups),
              _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "namespace", offsetof(struct wlr_layer_surface_v1, namespace),
                 sizeof(((struct wlr_layer_surface_v1 *)0)->namespace),
                 _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "added", offsetof(struct wlr_layer_surface_v1, added),
             sizeof(((struct wlr_layer_surface_v1 *)0)->added),
             _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "configured", offsetof(struct wlr_layer_surface_v1, configured),
                  sizeof(((struct wlr_layer_surface_v1 *)0)->configured),
                  _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "configure_list", offsetof(struct wlr_layer_surface_v1, configure_list),
                      sizeof(((struct wlr_layer_surface_v1 *)0)->configure_list),
                      _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "current", offsetof(struct wlr_layer_surface_v1, current),
               sizeof(((struct wlr_layer_surface_v1 *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1480) },
  { "pending", offsetof(struct wlr_layer_surface_v1, pending),
               sizeof(((struct wlr_layer_surface_v1 *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1480) },
  { "events", offsetof(struct wlr_layer_surface_v1, events),
              sizeof(((struct wlr_layer_surface_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1381) },
  { "data", offsetof(struct wlr_layer_surface_v1, data),
            sizeof(((struct wlr_layer_surface_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "anchor", offsetof(struct wlr_layer_surface_v1_state, anchor),
              sizeof(((struct wlr_layer_surface_v1_state *)0)->anchor),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "exclusive_zone", offsetof(struct wlr_layer_surface_v1_state, exclusive_zone),
                      sizeof(((struct wlr_layer_surface_v1_state *)0)->exclusive_zone),
                      _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "margin", offsetof(struct wlr_layer_surface_v1_state, margin),
              sizeof(((struct wlr_layer_surface_v1_state *)0)->margin),
              _CFFI_OP(_CFFI_OP_NOOP, 1380) },
  { "keyboard_interactive", offsetof(struct wlr_layer_surface_v1_state, keyboard_interactive),
                            sizeof(((struct wlr_layer_surface_v1_state *)0)->keyboard_interactive),
                            _CFFI_OP(_CFFI_OP_NOOP, 1308) },
  { "desired_width", offsetof(struct wlr_layer_surface_v1_state, desired_width),
                     sizeof(((struct wlr_layer_surface_v1_state *)0)->desired_width),
                     _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "desired_height", offsetof(struct wlr_layer_surface_v1_state, desired_height),
                      sizeof(((struct wlr_layer_surface_v1_state *)0)->desired_height),
                      _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "actual_width", offsetof(struct wlr_layer_surface_v1_state, actual_width),
                    sizeof(((struct wlr_layer_surface_v1_state *)0)->actual_width),
                    _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "actual_height", offsetof(struct wlr_layer_surface_v1_state, actual_height),
                     sizeof(((struct wlr_layer_surface_v1_state *)0)->actual_height),
                     _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "layer", offsetof(struct wlr_layer_surface_v1_state, layer),
             sizeof(((struct wlr_layer_surface_v1_state *)0)->layer),
             _CFFI_OP(_CFFI_OP_NOOP, 1307) },
  { "impl", offsetof(struct wlr_output, impl),
            sizeof(((struct wlr_output *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1492) },
  { "backend", offsetof(struct wlr_output, backend),
               sizeof(((struct wlr_output *)0)->backend),
               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "display", offsetof(struct wlr_output, display),
               sizeof(((struct wlr_output *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 58) },
  { "global", offsetof(struct wlr_output, global),
              sizeof(((struct wlr_output *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "resources", offsetof(struct wlr_output, resources),
                 sizeof(((struct wlr_output *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "name", offsetof(struct wlr_output, name),
            sizeof(((struct wlr_output *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "description", offsetof(struct wlr_output, description),
                   sizeof(((struct wlr_output *)0)->description),
                   _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "make", offsetof(struct wlr_output, make),
            sizeof(((struct wlr_output *)0)->make),
            _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "model", offsetof(struct wlr_output, model),
             sizeof(((struct wlr_output *)0)->model),
             _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "serial", offsetof(struct wlr_output, serial),
              sizeof(((struct wlr_output *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "phys_width", offsetof(struct wlr_output, phys_width),
                  sizeof(((struct wlr_output *)0)->phys_width),
                  _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "phys_height", offsetof(struct wlr_output, phys_height),
                   sizeof(((struct wlr_output *)0)->phys_height),
                   _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "modes", offsetof(struct wlr_output, modes),
             sizeof(((struct wlr_output *)0)->modes),
             _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "current_mode", offsetof(struct wlr_output, current_mode),
                    sizeof(((struct wlr_output *)0)->current_mode),
                    _CFFI_OP(_CFFI_OP_NOOP, 779) },
  { "width", offsetof(struct wlr_output, width),
             sizeof(((struct wlr_output *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "height", offsetof(struct wlr_output, height),
              sizeof(((struct wlr_output *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "refresh", offsetof(struct wlr_output, refresh),
               sizeof(((struct wlr_output *)0)->refresh),
               _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "enabled", offsetof(struct wlr_output, enabled),
               sizeof(((struct wlr_output *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "scale", offsetof(struct wlr_output, scale),
             sizeof(((struct wlr_output *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "subpixel", offsetof(struct wlr_output, subpixel),
                sizeof(((struct wlr_output *)0)->subpixel),
                _CFFI_OP(_CFFI_OP_NOOP, 827) },
  { "transform", offsetof(struct wlr_output, transform),
                 sizeof(((struct wlr_output *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 127) },
  { "adaptive_sync_status", offsetof(struct wlr_output, adaptive_sync_status),
                            sizeof(((struct wlr_output *)0)->adaptive_sync_status),
                            _CFFI_OP(_CFFI_OP_NOOP, 1278) },
  { "render_format", offsetof(struct wlr_output, render_format),
                     sizeof(((struct wlr_output *)0)->render_format),
                     _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "needs_frame", offsetof(struct wlr_output, needs_frame),
                   sizeof(((struct wlr_output *)0)->needs_frame),
                   _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "frame_pending", offsetof(struct wlr_output, frame_pending),
                     sizeof(((struct wlr_output *)0)->frame_pending),
                     _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "transform_matrix", offsetof(struct wlr_output, transform_matrix),
                        sizeof(((struct wlr_output *)0)->transform_matrix),
                        _CFFI_OP(_CFFI_OP_NOOP, 1313) },
  { "non_desktop", offsetof(struct wlr_output, non_desktop),
                   sizeof(((struct wlr_output *)0)->non_desktop),
                   _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "pending", offsetof(struct wlr_output, pending),
               sizeof(((struct wlr_output *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1502) },
  { "commit_seq", offsetof(struct wlr_output, commit_seq),
                  sizeof(((struct wlr_output *)0)->commit_seq),
                  _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "events", offsetof(struct wlr_output, events),
              sizeof(((struct wlr_output *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1337) },
  { "idle_frame", offsetof(struct wlr_output, idle_frame),
                  sizeof(((struct wlr_output *)0)->idle_frame),
                  _CFFI_OP(_CFFI_OP_NOOP, 1401) },
  { "idle_done", offsetof(struct wlr_output, idle_done),
                 sizeof(((struct wlr_output *)0)->idle_done),
                 _CFFI_OP(_CFFI_OP_NOOP, 1401) },
  { "attach_render_locks", offsetof(struct wlr_output, attach_render_locks),
                           sizeof(((struct wlr_output *)0)->attach_render_locks),
                           _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "cursors", offsetof(struct wlr_output, cursors),
               sizeof(((struct wlr_output *)0)->cursors),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "hardware_cursor", offsetof(struct wlr_output, hardware_cursor),
                       sizeof(((struct wlr_output *)0)->hardware_cursor),
                       _CFFI_OP(_CFFI_OP_NOOP, 1488) },
  { "cursor_swapchain", offsetof(struct wlr_output, cursor_swapchain),
                        sizeof(((struct wlr_output *)0)->cursor_swapchain),
                        _CFFI_OP(_CFFI_OP_NOOP, 1582) },
  { "cursor_front_buffer", offsetof(struct wlr_output, cursor_front_buffer),
                           sizeof(((struct wlr_output *)0)->cursor_front_buffer),
                           _CFFI_OP(_CFFI_OP_NOOP, 20) },
  { "software_cursor_locks", offsetof(struct wlr_output, software_cursor_locks),
                             sizeof(((struct wlr_output *)0)->software_cursor_locks),
                             _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "allocator", offsetof(struct wlr_output, allocator),
                 sizeof(((struct wlr_output *)0)->allocator),
                 _CFFI_OP(_CFFI_OP_NOOP, 44) },
  { "renderer", offsetof(struct wlr_output, renderer),
                sizeof(((struct wlr_output *)0)->renderer),
                _CFFI_OP(_CFFI_OP_NOOP, 45) },
  { "swapchain", offsetof(struct wlr_output, swapchain),
                 sizeof(((struct wlr_output *)0)->swapchain),
                 _CFFI_OP(_CFFI_OP_NOOP, 1582) },
  { "back_buffer", offsetof(struct wlr_output, back_buffer),
                   sizeof(((struct wlr_output *)0)->back_buffer),
                   _CFFI_OP(_CFFI_OP_NOOP, 20) },
  { "display_destroy", offsetof(struct wlr_output, display_destroy),
                       sizeof(((struct wlr_output *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "addons", offsetof(struct wlr_output, addons),
              sizeof(((struct wlr_output *)0)->addons),
              _CFFI_OP(_CFFI_OP_NOOP, 1419) },
  { "data", offsetof(struct wlr_output, data),
            sizeof(((struct wlr_output *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "state", offsetof(struct wlr_output_configuration_head_v1, state),
             sizeof(((struct wlr_output_configuration_head_v1 *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1491) },
  { "config", offsetof(struct wlr_output_configuration_head_v1, config),
              sizeof(((struct wlr_output_configuration_head_v1 *)0)->config),
              _CFFI_OP(_CFFI_OP_NOOP, 271) },
  { "link", offsetof(struct wlr_output_configuration_head_v1, link),
            sizeof(((struct wlr_output_configuration_head_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "resource", offsetof(struct wlr_output_configuration_head_v1, resource),
                sizeof(((struct wlr_output_configuration_head_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "output_destroy", offsetof(struct wlr_output_configuration_head_v1, output_destroy),
                      sizeof(((struct wlr_output_configuration_head_v1 *)0)->output_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "heads", offsetof(struct wlr_output_configuration_v1, heads),
             sizeof(((struct wlr_output_configuration_v1 *)0)->heads),
             _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "manager", offsetof(struct wlr_output_configuration_v1, manager),
               sizeof(((struct wlr_output_configuration_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 815) },
  { "serial", offsetof(struct wlr_output_configuration_v1, serial),
              sizeof(((struct wlr_output_configuration_v1 *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "finalized", offsetof(struct wlr_output_configuration_v1, finalized),
                 sizeof(((struct wlr_output_configuration_v1 *)0)->finalized),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "finished", offsetof(struct wlr_output_configuration_v1, finished),
                sizeof(((struct wlr_output_configuration_v1 *)0)->finished),
                _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "resource", offsetof(struct wlr_output_configuration_v1, resource),
                sizeof(((struct wlr_output_configuration_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "output", offsetof(struct wlr_output_event_request_state, output),
              sizeof(((struct wlr_output_event_request_state *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "state", offsetof(struct wlr_output_event_request_state, state),
             sizeof(((struct wlr_output_event_request_state *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "output", offsetof(struct wlr_output_head_v1_state, output),
              sizeof(((struct wlr_output_head_v1_state *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "enabled", offsetof(struct wlr_output_head_v1_state, enabled),
               sizeof(((struct wlr_output_head_v1_state *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "mode", offsetof(struct wlr_output_head_v1_state, mode),
            sizeof(((struct wlr_output_head_v1_state *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 779) },
  { "custom_mode", offsetof(struct wlr_output_head_v1_state, custom_mode),
                   sizeof(((struct wlr_output_head_v1_state *)0)->custom_mode),
                   _CFFI_OP(_CFFI_OP_NOOP, 1340) },
  { "x", offsetof(struct wlr_output_head_v1_state, x),
         sizeof(((struct wlr_output_head_v1_state *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "y", offsetof(struct wlr_output_head_v1_state, y),
         sizeof(((struct wlr_output_head_v1_state *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "transform", offsetof(struct wlr_output_head_v1_state, transform),
                 sizeof(((struct wlr_output_head_v1_state *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 127) },
  { "scale", offsetof(struct wlr_output_head_v1_state, scale),
             sizeof(((struct wlr_output_head_v1_state *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "adaptive_sync_enabled", offsetof(struct wlr_output_head_v1_state, adaptive_sync_enabled),
                             sizeof(((struct wlr_output_head_v1_state *)0)->adaptive_sync_enabled),
                             _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "outputs", offsetof(struct wlr_output_layout, outputs),
               sizeof(((struct wlr_output_layout *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_output_layout, events),
              sizeof(((struct wlr_output_layout *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1338) },
  { "data", offsetof(struct wlr_output_layout, data),
            sizeof(((struct wlr_output_layout *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "display", offsetof(struct wlr_output_manager_v1, display),
               sizeof(((struct wlr_output_manager_v1 *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 58) },
  { "global", offsetof(struct wlr_output_manager_v1, global),
              sizeof(((struct wlr_output_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "resources", offsetof(struct wlr_output_manager_v1, resources),
                 sizeof(((struct wlr_output_manager_v1 *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "heads", offsetof(struct wlr_output_manager_v1, heads),
             sizeof(((struct wlr_output_manager_v1 *)0)->heads),
             _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "serial", offsetof(struct wlr_output_manager_v1, serial),
              sizeof(((struct wlr_output_manager_v1 *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "current_configuration_dirty", offsetof(struct wlr_output_manager_v1, current_configuration_dirty),
                                   sizeof(((struct wlr_output_manager_v1 *)0)->current_configuration_dirty),
                                   _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "events", offsetof(struct wlr_output_manager_v1, events),
              sizeof(((struct wlr_output_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1339) },
  { "display_destroy", offsetof(struct wlr_output_manager_v1, display_destroy),
                       sizeof(((struct wlr_output_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "data", offsetof(struct wlr_output_manager_v1, data),
            sizeof(((struct wlr_output_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "width", offsetof(struct wlr_output_mode, width),
             sizeof(((struct wlr_output_mode *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "height", offsetof(struct wlr_output_mode, height),
              sizeof(((struct wlr_output_mode *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "refresh", offsetof(struct wlr_output_mode, refresh),
               sizeof(((struct wlr_output_mode *)0)->refresh),
               _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "preferred", offsetof(struct wlr_output_mode, preferred),
                 sizeof(((struct wlr_output_mode *)0)->preferred),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "link", offsetof(struct wlr_output_mode, link),
            sizeof(((struct wlr_output_mode *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "global", offsetof(struct wlr_output_power_manager_v1, global),
              sizeof(((struct wlr_output_power_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "output_powers", offsetof(struct wlr_output_power_manager_v1, output_powers),
                     sizeof(((struct wlr_output_power_manager_v1 *)0)->output_powers),
                     _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_output_power_manager_v1, display_destroy),
                       sizeof(((struct wlr_output_power_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_output_power_manager_v1, events),
              sizeof(((struct wlr_output_power_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1341) },
  { "data", offsetof(struct wlr_output_power_manager_v1, data),
            sizeof(((struct wlr_output_power_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "resource", offsetof(struct wlr_output_power_v1, resource),
                sizeof(((struct wlr_output_power_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "output", offsetof(struct wlr_output_power_v1, output),
              sizeof(((struct wlr_output_power_v1 *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "manager", offsetof(struct wlr_output_power_v1, manager),
               sizeof(((struct wlr_output_power_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 1498) },
  { "link", offsetof(struct wlr_output_power_v1, link),
            sizeof(((struct wlr_output_power_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "output_destroy_listener", offsetof(struct wlr_output_power_v1, output_destroy_listener),
                               sizeof(((struct wlr_output_power_v1 *)0)->output_destroy_listener),
                               _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "output_commit_listener", offsetof(struct wlr_output_power_v1, output_commit_listener),
                              sizeof(((struct wlr_output_power_v1 *)0)->output_commit_listener),
                              _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "data", offsetof(struct wlr_output_power_v1, data),
            sizeof(((struct wlr_output_power_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "output", offsetof(struct wlr_output_power_v1_set_mode_event, output),
              sizeof(((struct wlr_output_power_v1_set_mode_event *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "mode", offsetof(struct wlr_output_power_v1_set_mode_event, mode),
            sizeof(((struct wlr_output_power_v1_set_mode_event *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 1309) },
  { "enabled", offsetof(struct wlr_output_state, enabled),
               sizeof(((struct wlr_output_state *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "scale", offsetof(struct wlr_output_state, scale),
             sizeof(((struct wlr_output_state *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "transform", offsetof(struct wlr_output_state, transform),
                 sizeof(((struct wlr_output_state *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 127) },
  { "adaptive_sync_enabled", offsetof(struct wlr_output_state, adaptive_sync_enabled),
                             sizeof(((struct wlr_output_state *)0)->adaptive_sync_enabled),
                             _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "render_format", offsetof(struct wlr_output_state, render_format),
                     sizeof(((struct wlr_output_state *)0)->render_format),
                     _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "subpixel", offsetof(struct wlr_output_state, subpixel),
                sizeof(((struct wlr_output_state *)0)->subpixel),
                _CFFI_OP(_CFFI_OP_NOOP, 827) },
  { "mode", offsetof(struct wlr_output_state, mode),
            sizeof(((struct wlr_output_state *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 779) },
  { "custom_mode", offsetof(struct wlr_output_state, custom_mode),
                   sizeof(((struct wlr_output_state *)0)->custom_mode),
                   _CFFI_OP(_CFFI_OP_NOOP, 1336) },
  { "base", offsetof(struct wlr_pointer, base),
            sizeof(((struct wlr_pointer *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 1465) },
  { "impl", offsetof(struct wlr_pointer, impl),
            sizeof(((struct wlr_pointer *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1517) },
  { "output_name", offsetof(struct wlr_pointer, output_name),
                   sizeof(((struct wlr_pointer *)0)->output_name),
                   _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "events", offsetof(struct wlr_pointer, events),
              sizeof(((struct wlr_pointer *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1342) },
  { "data", offsetof(struct wlr_pointer, data),
            sizeof(((struct wlr_pointer *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "pointer", offsetof(struct wlr_pointer_axis_event, pointer),
               sizeof(((struct wlr_pointer_axis_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_axis_event, time_msec),
                 sizeof(((struct wlr_pointer_axis_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "source", offsetof(struct wlr_pointer_axis_event, source),
              sizeof(((struct wlr_pointer_axis_event *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 1100) },
  { "orientation", offsetof(struct wlr_pointer_axis_event, orientation),
                   sizeof(((struct wlr_pointer_axis_event *)0)->orientation),
                   _CFFI_OP(_CFFI_OP_NOOP, 1097) },
  { "delta", offsetof(struct wlr_pointer_axis_event, delta),
             sizeof(((struct wlr_pointer_axis_event *)0)->delta),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "delta_discrete", offsetof(struct wlr_pointer_axis_event, delta_discrete),
                      sizeof(((struct wlr_pointer_axis_event *)0)->delta_discrete),
                      _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "pointer", offsetof(struct wlr_pointer_button_event, pointer),
               sizeof(((struct wlr_pointer_button_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_button_event, time_msec),
                 sizeof(((struct wlr_pointer_button_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "button", offsetof(struct wlr_pointer_button_event, button),
              sizeof(((struct wlr_pointer_button_event *)0)->button),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "state", offsetof(struct wlr_pointer_button_event, state),
             sizeof(((struct wlr_pointer_button_event *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 523) },
  { "pointer_constraints", offsetof(struct wlr_pointer_constraint_v1, pointer_constraints),
                           sizeof(((struct wlr_pointer_constraint_v1 *)0)->pointer_constraints),
                           _CFFI_OP(_CFFI_OP_NOOP, 301) },
  { "resource", offsetof(struct wlr_pointer_constraint_v1, resource),
                sizeof(((struct wlr_pointer_constraint_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "surface", offsetof(struct wlr_pointer_constraint_v1, surface),
               sizeof(((struct wlr_pointer_constraint_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "seat", offsetof(struct wlr_pointer_constraint_v1, seat),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "lifetime", offsetof(struct wlr_pointer_constraint_v1, lifetime),
                sizeof(((struct wlr_pointer_constraint_v1 *)0)->lifetime),
                _CFFI_OP(_CFFI_OP_NOOP, 1310) },
  { "type", offsetof(struct wlr_pointer_constraint_v1, type),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 1280) },
  { "region", offsetof(struct wlr_pointer_constraint_v1, region),
              sizeof(((struct wlr_pointer_constraint_v1 *)0)->region),
              _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "current", offsetof(struct wlr_pointer_constraint_v1, current),
               sizeof(((struct wlr_pointer_constraint_v1 *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1510) },
  { "pending", offsetof(struct wlr_pointer_constraint_v1, pending),
               sizeof(((struct wlr_pointer_constraint_v1 *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1510) },
  { "surface_commit", offsetof(struct wlr_pointer_constraint_v1, surface_commit),
                      sizeof(((struct wlr_pointer_constraint_v1 *)0)->surface_commit),
                      _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "surface_destroy", offsetof(struct wlr_pointer_constraint_v1, surface_destroy),
                       sizeof(((struct wlr_pointer_constraint_v1 *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "seat_destroy", offsetof(struct wlr_pointer_constraint_v1, seat_destroy),
                    sizeof(((struct wlr_pointer_constraint_v1 *)0)->seat_destroy),
                    _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "link", offsetof(struct wlr_pointer_constraint_v1, link),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_pointer_constraint_v1, events),
              sizeof(((struct wlr_pointer_constraint_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1345) },
  { "data", offsetof(struct wlr_pointer_constraint_v1, data),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "committed", offsetof(struct wlr_pointer_constraint_v1_state, committed),
                 sizeof(((struct wlr_pointer_constraint_v1_state *)0)->committed),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "region", offsetof(struct wlr_pointer_constraint_v1_state, region),
              sizeof(((struct wlr_pointer_constraint_v1_state *)0)->region),
              _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "cursor_hint", offsetof(struct wlr_pointer_constraint_v1_state, cursor_hint),
                   sizeof(((struct wlr_pointer_constraint_v1_state *)0)->cursor_hint),
                   _CFFI_OP(_CFFI_OP_NOOP, 1343) },
  { "global", offsetof(struct wlr_pointer_constraints_v1, global),
              sizeof(((struct wlr_pointer_constraints_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "constraints", offsetof(struct wlr_pointer_constraints_v1, constraints),
                   sizeof(((struct wlr_pointer_constraints_v1 *)0)->constraints),
                   _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_pointer_constraints_v1, events),
              sizeof(((struct wlr_pointer_constraints_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1346) },
  { "display_destroy", offsetof(struct wlr_pointer_constraints_v1, display_destroy),
                       sizeof(((struct wlr_pointer_constraints_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "data", offsetof(struct wlr_pointer_constraints_v1, data),
            sizeof(((struct wlr_pointer_constraints_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_pointer_gestures_v1, global),
              sizeof(((struct wlr_pointer_gestures_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "swipes", offsetof(struct wlr_pointer_gestures_v1, swipes),
              sizeof(((struct wlr_pointer_gestures_v1 *)0)->swipes),
              _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "pinches", offsetof(struct wlr_pointer_gestures_v1, pinches),
               sizeof(((struct wlr_pointer_gestures_v1 *)0)->pinches),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "holds", offsetof(struct wlr_pointer_gestures_v1, holds),
             sizeof(((struct wlr_pointer_gestures_v1 *)0)->holds),
             _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_pointer_gestures_v1, display_destroy),
                       sizeof(((struct wlr_pointer_gestures_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_pointer_gestures_v1, events),
              sizeof(((struct wlr_pointer_gestures_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1347) },
  { "data", offsetof(struct wlr_pointer_gestures_v1, data),
            sizeof(((struct wlr_pointer_gestures_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "pointer", offsetof(struct wlr_pointer_hold_begin_event, pointer),
               sizeof(((struct wlr_pointer_hold_begin_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_hold_begin_event, time_msec),
                 sizeof(((struct wlr_pointer_hold_begin_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "fingers", offsetof(struct wlr_pointer_hold_begin_event, fingers),
               sizeof(((struct wlr_pointer_hold_begin_event *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "pointer", offsetof(struct wlr_pointer_hold_end_event, pointer),
               sizeof(((struct wlr_pointer_hold_end_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_hold_end_event, time_msec),
                 sizeof(((struct wlr_pointer_hold_end_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "cancelled", offsetof(struct wlr_pointer_hold_end_event, cancelled),
                 sizeof(((struct wlr_pointer_hold_end_event *)0)->cancelled),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "pointer", offsetof(struct wlr_pointer_motion_absolute_event, pointer),
               sizeof(((struct wlr_pointer_motion_absolute_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_motion_absolute_event, time_msec),
                 sizeof(((struct wlr_pointer_motion_absolute_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "x", offsetof(struct wlr_pointer_motion_absolute_event, x),
         sizeof(((struct wlr_pointer_motion_absolute_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_pointer_motion_absolute_event, y),
         sizeof(((struct wlr_pointer_motion_absolute_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "pointer", offsetof(struct wlr_pointer_motion_event, pointer),
               sizeof(((struct wlr_pointer_motion_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_motion_event, time_msec),
                 sizeof(((struct wlr_pointer_motion_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "delta_x", offsetof(struct wlr_pointer_motion_event, delta_x),
               sizeof(((struct wlr_pointer_motion_event *)0)->delta_x),
               _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "delta_y", offsetof(struct wlr_pointer_motion_event, delta_y),
               sizeof(((struct wlr_pointer_motion_event *)0)->delta_y),
               _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "unaccel_dx", offsetof(struct wlr_pointer_motion_event, unaccel_dx),
                  sizeof(((struct wlr_pointer_motion_event *)0)->unaccel_dx),
                  _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "unaccel_dy", offsetof(struct wlr_pointer_motion_event, unaccel_dy),
                  sizeof(((struct wlr_pointer_motion_event *)0)->unaccel_dy),
                  _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "pointer", offsetof(struct wlr_pointer_pinch_begin_event, pointer),
               sizeof(((struct wlr_pointer_pinch_begin_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_pinch_begin_event, time_msec),
                 sizeof(((struct wlr_pointer_pinch_begin_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "fingers", offsetof(struct wlr_pointer_pinch_begin_event, fingers),
               sizeof(((struct wlr_pointer_pinch_begin_event *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "pointer", offsetof(struct wlr_pointer_pinch_end_event, pointer),
               sizeof(((struct wlr_pointer_pinch_end_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_pinch_end_event, time_msec),
                 sizeof(((struct wlr_pointer_pinch_end_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "cancelled", offsetof(struct wlr_pointer_pinch_end_event, cancelled),
                 sizeof(((struct wlr_pointer_pinch_end_event *)0)->cancelled),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "pointer", offsetof(struct wlr_pointer_pinch_update_event, pointer),
               sizeof(((struct wlr_pointer_pinch_update_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_pinch_update_event, time_msec),
                 sizeof(((struct wlr_pointer_pinch_update_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "fingers", offsetof(struct wlr_pointer_pinch_update_event, fingers),
               sizeof(((struct wlr_pointer_pinch_update_event *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "dx", offsetof(struct wlr_pointer_pinch_update_event, dx),
          sizeof(((struct wlr_pointer_pinch_update_event *)0)->dx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "dy", offsetof(struct wlr_pointer_pinch_update_event, dy),
          sizeof(((struct wlr_pointer_pinch_update_event *)0)->dy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "scale", offsetof(struct wlr_pointer_pinch_update_event, scale),
             sizeof(((struct wlr_pointer_pinch_update_event *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "rotation", offsetof(struct wlr_pointer_pinch_update_event, rotation),
                sizeof(((struct wlr_pointer_pinch_update_event *)0)->rotation),
                _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "pointer", offsetof(struct wlr_pointer_swipe_begin_event, pointer),
               sizeof(((struct wlr_pointer_swipe_begin_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_swipe_begin_event, time_msec),
                 sizeof(((struct wlr_pointer_swipe_begin_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "fingers", offsetof(struct wlr_pointer_swipe_begin_event, fingers),
               sizeof(((struct wlr_pointer_swipe_begin_event *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "pointer", offsetof(struct wlr_pointer_swipe_end_event, pointer),
               sizeof(((struct wlr_pointer_swipe_end_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_swipe_end_event, time_msec),
                 sizeof(((struct wlr_pointer_swipe_end_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "cancelled", offsetof(struct wlr_pointer_swipe_end_event, cancelled),
                 sizeof(((struct wlr_pointer_swipe_end_event *)0)->cancelled),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "pointer", offsetof(struct wlr_pointer_swipe_update_event, pointer),
               sizeof(((struct wlr_pointer_swipe_update_event *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1503) },
  { "time_msec", offsetof(struct wlr_pointer_swipe_update_event, time_msec),
                 sizeof(((struct wlr_pointer_swipe_update_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "fingers", offsetof(struct wlr_pointer_swipe_update_event, fingers),
               sizeof(((struct wlr_pointer_swipe_update_event *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "dx", offsetof(struct wlr_pointer_swipe_update_event, dx),
          sizeof(((struct wlr_pointer_swipe_update_event *)0)->dx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "dy", offsetof(struct wlr_pointer_swipe_update_event, dy),
          sizeof(((struct wlr_pointer_swipe_update_event *)0)->dy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "global", offsetof(struct wlr_primary_selection_v1_device_manager, global),
              sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "devices", offsetof(struct wlr_primary_selection_v1_device_manager, devices),
               sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->devices),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_primary_selection_v1_device_manager, display_destroy),
                       sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_primary_selection_v1_device_manager, events),
              sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1348) },
  { "data", offsetof(struct wlr_primary_selection_v1_device_manager, data),
            sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_relative_pointer_manager_v1, global),
              sizeof(((struct wlr_relative_pointer_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "relative_pointers", offsetof(struct wlr_relative_pointer_manager_v1, relative_pointers),
                         sizeof(((struct wlr_relative_pointer_manager_v1 *)0)->relative_pointers),
                         _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_relative_pointer_manager_v1, events),
              sizeof(((struct wlr_relative_pointer_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1349) },
  { "resource", offsetof(struct wlr_relative_pointer_v1, resource),
                sizeof(((struct wlr_relative_pointer_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "pointer_resource", offsetof(struct wlr_relative_pointer_v1, pointer_resource),
                        sizeof(((struct wlr_relative_pointer_v1 *)0)->pointer_resource),
                        _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "seat", offsetof(struct wlr_relative_pointer_v1, seat),
            sizeof(((struct wlr_relative_pointer_v1 *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "link", offsetof(struct wlr_relative_pointer_v1, link),
            sizeof(((struct wlr_relative_pointer_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_relative_pointer_v1, events),
              sizeof(((struct wlr_relative_pointer_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1350) },
  { "tree", offsetof(struct wlr_scene, tree),
            sizeof(((struct wlr_scene *)0)->tree),
            _CFFI_OP(_CFFI_OP_NOOP, 1546) },
  { "outputs", offsetof(struct wlr_scene, outputs),
               sizeof(((struct wlr_scene *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "presentation", offsetof(struct wlr_scene, presentation),
                    sizeof(((struct wlr_scene *)0)->presentation),
                    _CFFI_OP(_CFFI_OP_NOOP, 910) },
  { "node", offsetof(struct wlr_scene_buffer, node),
            sizeof(((struct wlr_scene_buffer *)0)->node),
            _CFFI_OP(_CFFI_OP_NOOP, 1537) },
  { "buffer", offsetof(struct wlr_scene_buffer, buffer),
              sizeof(((struct wlr_scene_buffer *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 20) },
  { "events", offsetof(struct wlr_scene_buffer, events),
              sizeof(((struct wlr_scene_buffer *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1352) },
  { "point_accepts_input", offsetof(struct wlr_scene_buffer, point_accepts_input),
                           sizeof(((struct wlr_scene_buffer *)0)->point_accepts_input),
                           _CFFI_OP(_CFFI_OP_NOOP, 1262) },
  { "primary_output", offsetof(struct wlr_scene_buffer, primary_output),
                      sizeof(((struct wlr_scene_buffer *)0)->primary_output),
                      _CFFI_OP(_CFFI_OP_NOOP, 85) },
  { "tree", offsetof(struct wlr_scene_layer_surface_v1, tree),
            sizeof(((struct wlr_scene_layer_surface_v1 *)0)->tree),
            _CFFI_OP(_CFFI_OP_NOOP, 330) },
  { "layer_surface", offsetof(struct wlr_scene_layer_surface_v1, layer_surface),
                     sizeof(((struct wlr_scene_layer_surface_v1 *)0)->layer_surface),
                     _CFFI_OP(_CFFI_OP_NOOP, 335) },
  { "type", offsetof(struct wlr_scene_node, type),
            sizeof(((struct wlr_scene_node *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 1281) },
  { "parent", offsetof(struct wlr_scene_node, parent),
              sizeof(((struct wlr_scene_node *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 330) },
  { "link", offsetof(struct wlr_scene_node, link),
            sizeof(((struct wlr_scene_node *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "enabled", offsetof(struct wlr_scene_node, enabled),
               sizeof(((struct wlr_scene_node *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "x", offsetof(struct wlr_scene_node, x),
         sizeof(((struct wlr_scene_node *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "y", offsetof(struct wlr_scene_node, y),
         sizeof(((struct wlr_scene_node *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "events", offsetof(struct wlr_scene_node, events),
              sizeof(((struct wlr_scene_node *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1351) },
  { "data", offsetof(struct wlr_scene_node, data),
            sizeof(((struct wlr_scene_node *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "addons", offsetof(struct wlr_scene_node, addons),
              sizeof(((struct wlr_scene_node *)0)->addons),
              _CFFI_OP(_CFFI_OP_NOOP, 1419) },
  { "visible", offsetof(struct wlr_scene_node, visible),
               sizeof(((struct wlr_scene_node *)0)->visible),
               _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "output", offsetof(struct wlr_scene_output, output),
              sizeof(((struct wlr_scene_output *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "link", offsetof(struct wlr_scene_output, link),
            sizeof(((struct wlr_scene_output *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "scene", offsetof(struct wlr_scene_output, scene),
             sizeof(((struct wlr_scene_output *)0)->scene),
             _CFFI_OP(_CFFI_OP_NOOP, 345) },
  { "addon", offsetof(struct wlr_scene_output, addon),
             sizeof(((struct wlr_scene_output *)0)->addon),
             _CFFI_OP(_CFFI_OP_NOOP, 1416) },
  { "damage_ring", offsetof(struct wlr_scene_output, damage_ring),
                   sizeof(((struct wlr_scene_output *)0)->damage_ring),
                   _CFFI_OP(_CFFI_OP_NOOP, 1432) },
  { "x", offsetof(struct wlr_scene_output, x),
         sizeof(((struct wlr_scene_output *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "y", offsetof(struct wlr_scene_output, y),
         sizeof(((struct wlr_scene_output *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "events", offsetof(struct wlr_scene_output, events),
              sizeof(((struct wlr_scene_output *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1353) },
  { "timer", offsetof(struct wlr_scene_output_state_options, timer),
             sizeof(((struct wlr_scene_output_state_options *)0)->timer),
             _CFFI_OP(_CFFI_OP_NOOP, 1544) },
  { "node", offsetof(struct wlr_scene_rect, node),
            sizeof(((struct wlr_scene_rect *)0)->node),
            _CFFI_OP(_CFFI_OP_NOOP, 1537) },
  { "width", offsetof(struct wlr_scene_rect, width),
             sizeof(((struct wlr_scene_rect *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "height", offsetof(struct wlr_scene_rect, height),
              sizeof(((struct wlr_scene_rect *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "color", offsetof(struct wlr_scene_rect, color),
             sizeof(((struct wlr_scene_rect *)0)->color),
             _CFFI_OP(_CFFI_OP_NOOP, 1311) },
  { "buffer", offsetof(struct wlr_scene_surface, buffer),
              sizeof(((struct wlr_scene_surface *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "surface", offsetof(struct wlr_scene_surface, surface),
               sizeof(((struct wlr_scene_surface *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "node", offsetof(struct wlr_scene_tree, node),
            sizeof(((struct wlr_scene_tree *)0)->node),
            _CFFI_OP(_CFFI_OP_NOOP, 1537) },
  { "children", offsetof(struct wlr_scene_tree, children),
                sizeof(((struct wlr_scene_tree *)0)->children),
                _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "global", offsetof(struct wlr_screencopy_manager_v1, global),
              sizeof(((struct wlr_screencopy_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "frames", offsetof(struct wlr_screencopy_manager_v1, frames),
              sizeof(((struct wlr_screencopy_manager_v1 *)0)->frames),
              _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy", offsetof(struct wlr_screencopy_manager_v1, display_destroy),
                       sizeof(((struct wlr_screencopy_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_screencopy_manager_v1, events),
              sizeof(((struct wlr_screencopy_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1354) },
  { "data", offsetof(struct wlr_screencopy_manager_v1, data),
            sizeof(((struct wlr_screencopy_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_seat, global),
              sizeof(((struct wlr_seat *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "display", offsetof(struct wlr_seat, display),
               sizeof(((struct wlr_seat *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 58) },
  { "clients", offsetof(struct wlr_seat, clients),
               sizeof(((struct wlr_seat *)0)->clients),
               _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "name", offsetof(struct wlr_seat, name),
            sizeof(((struct wlr_seat *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "capabilities", offsetof(struct wlr_seat, capabilities),
                    sizeof(((struct wlr_seat *)0)->capabilities),
                    _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "last_event", offsetof(struct wlr_seat, last_event),
                  sizeof(((struct wlr_seat *)0)->last_event),
                  _CFFI_OP(_CFFI_OP_NOOP, 1394) },
  { "selection_source", offsetof(struct wlr_seat, selection_source),
                        sizeof(((struct wlr_seat *)0)->selection_source),
                        _CFFI_OP(_CFFI_OP_NOOP, 689) },
  { "selection_serial", offsetof(struct wlr_seat, selection_serial),
                        sizeof(((struct wlr_seat *)0)->selection_serial),
                        _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "selection_offers", offsetof(struct wlr_seat, selection_offers),
                        sizeof(((struct wlr_seat *)0)->selection_offers),
                        _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "primary_selection_source", offsetof(struct wlr_seat, primary_selection_source),
                                sizeof(((struct wlr_seat *)0)->primary_selection_source),
                                _CFFI_OP(_CFFI_OP_NOOP, 1044) },
  { "primary_selection_serial", offsetof(struct wlr_seat, primary_selection_serial),
                                sizeof(((struct wlr_seat *)0)->primary_selection_serial),
                                _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "drag", offsetof(struct wlr_seat, drag),
            sizeof(((struct wlr_seat *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 1031) },
  { "drag_source", offsetof(struct wlr_seat, drag_source),
                   sizeof(((struct wlr_seat *)0)->drag_source),
                   _CFFI_OP(_CFFI_OP_NOOP, 689) },
  { "drag_serial", offsetof(struct wlr_seat, drag_serial),
                   sizeof(((struct wlr_seat *)0)->drag_serial),
                   _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "drag_offers", offsetof(struct wlr_seat, drag_offers),
                   sizeof(((struct wlr_seat *)0)->drag_offers),
                   _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "pointer_state", offsetof(struct wlr_seat, pointer_state),
                     sizeof(((struct wlr_seat *)0)->pointer_state),
                     _CFFI_OP(_CFFI_OP_NOOP, 1558) },
  { "keyboard_state", offsetof(struct wlr_seat, keyboard_state),
                      sizeof(((struct wlr_seat *)0)->keyboard_state),
                      _CFFI_OP(_CFFI_OP_NOOP, 1554) },
  { "touch_state", offsetof(struct wlr_seat, touch_state),
                   sizeof(((struct wlr_seat *)0)->touch_state),
                   _CFFI_OP(_CFFI_OP_NOOP, 1563) },
  { "display_destroy", offsetof(struct wlr_seat, display_destroy),
                       sizeof(((struct wlr_seat *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "selection_source_destroy", offsetof(struct wlr_seat, selection_source_destroy),
                                sizeof(((struct wlr_seat *)0)->selection_source_destroy),
                                _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "primary_selection_source_destroy", offsetof(struct wlr_seat, primary_selection_source_destroy),
                                        sizeof(((struct wlr_seat *)0)->primary_selection_source_destroy),
                                        _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "drag_source_destroy", offsetof(struct wlr_seat, drag_source_destroy),
                           sizeof(((struct wlr_seat *)0)->drag_source_destroy),
                           _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_seat, events),
              sizeof(((struct wlr_seat *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1358) },
  { "data", offsetof(struct wlr_seat, data),
            sizeof(((struct wlr_seat *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "seat", offsetof(struct wlr_seat_keyboard_focus_change_event, seat),
            sizeof(((struct wlr_seat_keyboard_focus_change_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "old_surface", offsetof(struct wlr_seat_keyboard_focus_change_event, old_surface),
                   sizeof(((struct wlr_seat_keyboard_focus_change_event *)0)->old_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "new_surface", offsetof(struct wlr_seat_keyboard_focus_change_event, new_surface),
                   sizeof(((struct wlr_seat_keyboard_focus_change_event *)0)->new_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "interface", offsetof(struct wlr_seat_keyboard_grab, interface),
                 sizeof(((struct wlr_seat_keyboard_grab *)0)->interface),
                 _CFFI_OP(_CFFI_OP_NOOP, 1469) },
  { "seat", offsetof(struct wlr_seat_keyboard_grab, seat),
            sizeof(((struct wlr_seat_keyboard_grab *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "data", offsetof(struct wlr_seat_keyboard_grab, data),
            sizeof(((struct wlr_seat_keyboard_grab *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "seat", offsetof(struct wlr_seat_keyboard_state, seat),
            sizeof(((struct wlr_seat_keyboard_state *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "keyboard", offsetof(struct wlr_seat_keyboard_state, keyboard),
                sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard),
                _CFFI_OP(_CFFI_OP_NOOP, 509) },
  { "focused_client", offsetof(struct wlr_seat_keyboard_state, focused_client),
                      sizeof(((struct wlr_seat_keyboard_state *)0)->focused_client),
                      _CFFI_OP(_CFFI_OP_NOOP, 1550) },
  { "focused_surface", offsetof(struct wlr_seat_keyboard_state, focused_surface),
                       sizeof(((struct wlr_seat_keyboard_state *)0)->focused_surface),
                       _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "keyboard_destroy", offsetof(struct wlr_seat_keyboard_state, keyboard_destroy),
                        sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard_destroy),
                        _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "keyboard_keymap", offsetof(struct wlr_seat_keyboard_state, keyboard_keymap),
                       sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard_keymap),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "keyboard_repeat_info", offsetof(struct wlr_seat_keyboard_state, keyboard_repeat_info),
                            sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard_repeat_info),
                            _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "surface_destroy", offsetof(struct wlr_seat_keyboard_state, surface_destroy),
                       sizeof(((struct wlr_seat_keyboard_state *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "grab", offsetof(struct wlr_seat_keyboard_state, grab),
            sizeof(((struct wlr_seat_keyboard_state *)0)->grab),
            _CFFI_OP(_CFFI_OP_NOOP, 1049) },
  { "default_grab", offsetof(struct wlr_seat_keyboard_state, default_grab),
                    sizeof(((struct wlr_seat_keyboard_state *)0)->default_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 1049) },
  { "events", offsetof(struct wlr_seat_keyboard_state, events),
              sizeof(((struct wlr_seat_keyboard_state *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1357) },
  { "seat", offsetof(struct wlr_seat_pointer_focus_change_event, seat),
            sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "old_surface", offsetof(struct wlr_seat_pointer_focus_change_event, old_surface),
                   sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->old_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "new_surface", offsetof(struct wlr_seat_pointer_focus_change_event, new_surface),
                   sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->new_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "sx", offsetof(struct wlr_seat_pointer_focus_change_event, sx),
          sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "sy", offsetof(struct wlr_seat_pointer_focus_change_event, sy),
          sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "interface", offsetof(struct wlr_seat_pointer_grab, interface),
                 sizeof(((struct wlr_seat_pointer_grab *)0)->interface),
                 _CFFI_OP(_CFFI_OP_NOOP, 1513) },
  { "seat", offsetof(struct wlr_seat_pointer_grab, seat),
            sizeof(((struct wlr_seat_pointer_grab *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "data", offsetof(struct wlr_seat_pointer_grab, data),
            sizeof(((struct wlr_seat_pointer_grab *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "seat_client", offsetof(struct wlr_seat_pointer_request_set_cursor_event, seat_client),
                   sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->seat_client),
                   _CFFI_OP(_CFFI_OP_NOOP, 1550) },
  { "surface", offsetof(struct wlr_seat_pointer_request_set_cursor_event, surface),
               sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "serial", offsetof(struct wlr_seat_pointer_request_set_cursor_event, serial),
              sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "hotspot_x", offsetof(struct wlr_seat_pointer_request_set_cursor_event, hotspot_x),
                 sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->hotspot_x),
                 _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "hotspot_y", offsetof(struct wlr_seat_pointer_request_set_cursor_event, hotspot_y),
                 sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->hotspot_y),
                 _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "seat", offsetof(struct wlr_seat_pointer_state, seat),
            sizeof(((struct wlr_seat_pointer_state *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "focused_client", offsetof(struct wlr_seat_pointer_state, focused_client),
                      sizeof(((struct wlr_seat_pointer_state *)0)->focused_client),
                      _CFFI_OP(_CFFI_OP_NOOP, 1550) },
  { "focused_surface", offsetof(struct wlr_seat_pointer_state, focused_surface),
                       sizeof(((struct wlr_seat_pointer_state *)0)->focused_surface),
                       _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "sx", offsetof(struct wlr_seat_pointer_state, sx),
          sizeof(((struct wlr_seat_pointer_state *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "sy", offsetof(struct wlr_seat_pointer_state, sy),
          sizeof(((struct wlr_seat_pointer_state *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "grab", offsetof(struct wlr_seat_pointer_state, grab),
            sizeof(((struct wlr_seat_pointer_state *)0)->grab),
            _CFFI_OP(_CFFI_OP_NOOP, 1053) },
  { "default_grab", offsetof(struct wlr_seat_pointer_state, default_grab),
                    sizeof(((struct wlr_seat_pointer_state *)0)->default_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 1053) },
  { "buttons", offsetof(struct wlr_seat_pointer_state, buttons),
               sizeof(((struct wlr_seat_pointer_state *)0)->buttons),
               _CFFI_OP(_CFFI_OP_NOOP, 1669) },
  { "button_count", offsetof(struct wlr_seat_pointer_state, button_count),
                    sizeof(((struct wlr_seat_pointer_state *)0)->button_count),
                    _CFFI_OP(_CFFI_OP_NOOP, 1073) },
  { "grab_button", offsetof(struct wlr_seat_pointer_state, grab_button),
                   sizeof(((struct wlr_seat_pointer_state *)0)->grab_button),
                   _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "grab_serial", offsetof(struct wlr_seat_pointer_state, grab_serial),
                   sizeof(((struct wlr_seat_pointer_state *)0)->grab_serial),
                   _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "grab_time", offsetof(struct wlr_seat_pointer_state, grab_time),
                 sizeof(((struct wlr_seat_pointer_state *)0)->grab_time),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "surface_destroy", offsetof(struct wlr_seat_pointer_state, surface_destroy),
                       sizeof(((struct wlr_seat_pointer_state *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_seat_pointer_state, events),
              sizeof(((struct wlr_seat_pointer_state *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1356) },
  { "source", offsetof(struct wlr_seat_request_set_primary_selection_event, source),
              sizeof(((struct wlr_seat_request_set_primary_selection_event *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 1044) },
  { "serial", offsetof(struct wlr_seat_request_set_primary_selection_event, serial),
              sizeof(((struct wlr_seat_request_set_primary_selection_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "source", offsetof(struct wlr_seat_request_set_selection_event, source),
              sizeof(((struct wlr_seat_request_set_selection_event *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 689) },
  { "serial", offsetof(struct wlr_seat_request_set_selection_event, serial),
              sizeof(((struct wlr_seat_request_set_selection_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "drag", offsetof(struct wlr_seat_request_start_drag_event, drag),
            sizeof(((struct wlr_seat_request_start_drag_event *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 1031) },
  { "origin", offsetof(struct wlr_seat_request_start_drag_event, origin),
              sizeof(((struct wlr_seat_request_start_drag_event *)0)->origin),
              _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "serial", offsetof(struct wlr_seat_request_start_drag_event, serial),
              sizeof(((struct wlr_seat_request_start_drag_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "interface", offsetof(struct wlr_seat_touch_grab, interface),
                 sizeof(((struct wlr_seat_touch_grab *)0)->interface),
                 _CFFI_OP(_CFFI_OP_NOOP, 1592) },
  { "seat", offsetof(struct wlr_seat_touch_grab, seat),
            sizeof(((struct wlr_seat_touch_grab *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "data", offsetof(struct wlr_seat_touch_grab, data),
            sizeof(((struct wlr_seat_touch_grab *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "seat", offsetof(struct wlr_seat_touch_state, seat),
            sizeof(((struct wlr_seat_touch_state *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "touch_points", offsetof(struct wlr_seat_touch_state, touch_points),
                    sizeof(((struct wlr_seat_touch_state *)0)->touch_points),
                    _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "grab_serial", offsetof(struct wlr_seat_touch_state, grab_serial),
                   sizeof(((struct wlr_seat_touch_state *)0)->grab_serial),
                   _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "grab_id", offsetof(struct wlr_seat_touch_state, grab_id),
               sizeof(((struct wlr_seat_touch_state *)0)->grab_id),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "grab", offsetof(struct wlr_seat_touch_state, grab),
            sizeof(((struct wlr_seat_touch_state *)0)->grab),
            _CFFI_OP(_CFFI_OP_NOOP, 1057) },
  { "default_grab", offsetof(struct wlr_seat_touch_state, default_grab),
                    sizeof(((struct wlr_seat_touch_state *)0)->default_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 1057) },
  { "global", offsetof(struct wlr_server_decoration_manager, global),
              sizeof(((struct wlr_server_decoration_manager *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "resources", offsetof(struct wlr_server_decoration_manager, resources),
                 sizeof(((struct wlr_server_decoration_manager *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "decorations", offsetof(struct wlr_server_decoration_manager, decorations),
                   sizeof(((struct wlr_server_decoration_manager *)0)->decorations),
                   _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "default_mode", offsetof(struct wlr_server_decoration_manager, default_mode),
                    sizeof(((struct wlr_server_decoration_manager *)0)->default_mode),
                    _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "display_destroy", offsetof(struct wlr_server_decoration_manager, display_destroy),
                       sizeof(((struct wlr_server_decoration_manager *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_server_decoration_manager, events),
              sizeof(((struct wlr_server_decoration_manager *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1359) },
  { "data", offsetof(struct wlr_server_decoration_manager, data),
            sizeof(((struct wlr_server_decoration_manager *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_session_lock_manager_v1, global),
              sizeof(((struct wlr_session_lock_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "events", offsetof(struct wlr_session_lock_manager_v1, events),
              sizeof(((struct wlr_session_lock_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1360) },
  { "data", offsetof(struct wlr_session_lock_manager_v1, data),
            sizeof(((struct wlr_session_lock_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "resource", offsetof(struct wlr_session_lock_surface_v1, resource),
                sizeof(((struct wlr_session_lock_surface_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "link", offsetof(struct wlr_session_lock_surface_v1, link),
            sizeof(((struct wlr_session_lock_surface_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "output", offsetof(struct wlr_session_lock_surface_v1, output),
              sizeof(((struct wlr_session_lock_surface_v1 *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "surface", offsetof(struct wlr_session_lock_surface_v1, surface),
               sizeof(((struct wlr_session_lock_surface_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "configured", offsetof(struct wlr_session_lock_surface_v1, configured),
                  sizeof(((struct wlr_session_lock_surface_v1 *)0)->configured),
                  _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "configure_list", offsetof(struct wlr_session_lock_surface_v1, configure_list),
                      sizeof(((struct wlr_session_lock_surface_v1 *)0)->configure_list),
                      _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "current", offsetof(struct wlr_session_lock_surface_v1, current),
               sizeof(((struct wlr_session_lock_surface_v1 *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1570) },
  { "pending", offsetof(struct wlr_session_lock_surface_v1, pending),
               sizeof(((struct wlr_session_lock_surface_v1 *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1570) },
  { "events", offsetof(struct wlr_session_lock_surface_v1, events),
              sizeof(((struct wlr_session_lock_surface_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1362) },
  { "data", offsetof(struct wlr_session_lock_surface_v1, data),
            sizeof(((struct wlr_session_lock_surface_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "link", offsetof(struct wlr_session_lock_surface_v1_configure, link),
            sizeof(((struct wlr_session_lock_surface_v1_configure *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "serial", offsetof(struct wlr_session_lock_surface_v1_configure, serial),
              sizeof(((struct wlr_session_lock_surface_v1_configure *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "width", offsetof(struct wlr_session_lock_surface_v1_configure, width),
             sizeof(((struct wlr_session_lock_surface_v1_configure *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "height", offsetof(struct wlr_session_lock_surface_v1_configure, height),
              sizeof(((struct wlr_session_lock_surface_v1_configure *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "width", offsetof(struct wlr_session_lock_surface_v1_state, width),
             sizeof(((struct wlr_session_lock_surface_v1_state *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "height", offsetof(struct wlr_session_lock_surface_v1_state, height),
              sizeof(((struct wlr_session_lock_surface_v1_state *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "configure_serial", offsetof(struct wlr_session_lock_surface_v1_state, configure_serial),
                        sizeof(((struct wlr_session_lock_surface_v1_state *)0)->configure_serial),
                        _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "resource", offsetof(struct wlr_session_lock_v1, resource),
                sizeof(((struct wlr_session_lock_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "surfaces", offsetof(struct wlr_session_lock_v1, surfaces),
                sizeof(((struct wlr_session_lock_v1 *)0)->surfaces),
                _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "events", offsetof(struct wlr_session_lock_v1, events),
              sizeof(((struct wlr_session_lock_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1361) },
  { "data", offsetof(struct wlr_session_lock_v1, data),
            sizeof(((struct wlr_session_lock_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "global", offsetof(struct wlr_subcompositor, global),
              sizeof(((struct wlr_subcompositor *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "resource", offsetof(struct wlr_subsurface, resource),
                sizeof(((struct wlr_subsurface *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "surface", offsetof(struct wlr_subsurface, surface),
               sizeof(((struct wlr_subsurface *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "parent", offsetof(struct wlr_subsurface, parent),
              sizeof(((struct wlr_subsurface *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "current", offsetof(struct wlr_subsurface, current),
               sizeof(((struct wlr_subsurface *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1577) },
  { "pending", offsetof(struct wlr_subsurface, pending),
               sizeof(((struct wlr_subsurface *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1577) },
  { "cached_seq", offsetof(struct wlr_subsurface, cached_seq),
                  sizeof(((struct wlr_subsurface *)0)->cached_seq),
                  _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "has_cache", offsetof(struct wlr_subsurface, has_cache),
                 sizeof(((struct wlr_subsurface *)0)->has_cache),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "synchronized", offsetof(struct wlr_subsurface, synchronized),
                    sizeof(((struct wlr_subsurface *)0)->synchronized),
                    _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "reordered", offsetof(struct wlr_subsurface, reordered),
                 sizeof(((struct wlr_subsurface *)0)->reordered),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "added", offsetof(struct wlr_subsurface, added),
             sizeof(((struct wlr_subsurface *)0)->added),
             _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "surface_client_commit", offsetof(struct wlr_subsurface, surface_client_commit),
                             sizeof(((struct wlr_subsurface *)0)->surface_client_commit),
                             _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "parent_destroy", offsetof(struct wlr_subsurface, parent_destroy),
                      sizeof(((struct wlr_subsurface *)0)->parent_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "events", offsetof(struct wlr_subsurface, events),
              sizeof(((struct wlr_subsurface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1377) },
  { "data", offsetof(struct wlr_subsurface, data),
            sizeof(((struct wlr_subsurface *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "x", offsetof(struct wlr_subsurface_parent_state, x),
         sizeof(((struct wlr_subsurface_parent_state *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "y", offsetof(struct wlr_subsurface_parent_state, y),
         sizeof(((struct wlr_subsurface_parent_state *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "resource", offsetof(struct wlr_surface, resource),
                sizeof(((struct wlr_surface *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "renderer", offsetof(struct wlr_surface, renderer),
                sizeof(((struct wlr_surface *)0)->renderer),
                _CFFI_OP(_CFFI_OP_NOOP, 45) },
  { "buffer", offsetof(struct wlr_surface, buffer),
              sizeof(((struct wlr_surface *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 1426) },
  { "buffer_damage", offsetof(struct wlr_surface, buffer_damage),
                     sizeof(((struct wlr_surface *)0)->buffer_damage),
                     _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "external_damage", offsetof(struct wlr_surface, external_damage),
                       sizeof(((struct wlr_surface *)0)->external_damage),
                       _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "opaque_region", offsetof(struct wlr_surface, opaque_region),
                     sizeof(((struct wlr_surface *)0)->opaque_region),
                     _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "input_region", offsetof(struct wlr_surface, input_region),
                    sizeof(((struct wlr_surface *)0)->input_region),
                    _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "current", offsetof(struct wlr_surface, current),
               sizeof(((struct wlr_surface *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1581) },
  { "pending", offsetof(struct wlr_surface, pending),
               sizeof(((struct wlr_surface *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1581) },
  { "cached", offsetof(struct wlr_surface, cached),
              sizeof(((struct wlr_surface *)0)->cached),
              _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "mapped", offsetof(struct wlr_surface, mapped),
              sizeof(((struct wlr_surface *)0)->mapped),
              _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "role", offsetof(struct wlr_surface, role),
            sizeof(((struct wlr_surface *)0)->role),
            _CFFI_OP(_CFFI_OP_NOOP, 114) },
  { "role_resource", offsetof(struct wlr_surface, role_resource),
                     sizeof(((struct wlr_surface *)0)->role_resource),
                     _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "events", offsetof(struct wlr_surface, events),
              sizeof(((struct wlr_surface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1366) },
  { "current_outputs", offsetof(struct wlr_surface, current_outputs),
                       sizeof(((struct wlr_surface *)0)->current_outputs),
                       _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "addons", offsetof(struct wlr_surface, addons),
              sizeof(((struct wlr_surface *)0)->addons),
              _CFFI_OP(_CFFI_OP_NOOP, 1419) },
  { "data", offsetof(struct wlr_surface, data),
            sizeof(((struct wlr_surface *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "surface", offsetof(struct wlr_surface_output, surface),
               sizeof(((struct wlr_surface_output *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 93) },
  { "output", offsetof(struct wlr_surface_output, output),
              sizeof(((struct wlr_surface_output *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 36) },
  { "link", offsetof(struct wlr_surface_output, link),
            sizeof(((struct wlr_surface_output *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "bind", offsetof(struct wlr_surface_output, bind),
            sizeof(((struct wlr_surface_output *)0)->bind),
            _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "destroy", offsetof(struct wlr_surface_output, destroy),
               sizeof(((struct wlr_surface_output *)0)->destroy),
               _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "name", offsetof(struct wlr_surface_role, name),
            sizeof(((struct wlr_surface_role *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 385) },
  { "no_object", offsetof(struct wlr_surface_role, no_object),
                 sizeof(((struct wlr_surface_role *)0)->no_object),
                 _CFFI_OP(_CFFI_OP_NOOP, 495) },
  { "commit", offsetof(struct wlr_surface_role, commit),
              sizeof(((struct wlr_surface_role *)0)->commit),
              _CFFI_OP(_CFFI_OP_NOOP, 1682) },
  { "unmap", offsetof(struct wlr_surface_role, unmap),
             sizeof(((struct wlr_surface_role *)0)->unmap),
             _CFFI_OP(_CFFI_OP_NOOP, 1682) },
  { "destroy", offsetof(struct wlr_surface_role, destroy),
               sizeof(((struct wlr_surface_role *)0)->destroy),
               _CFFI_OP(_CFFI_OP_NOOP, 1682) },
  { "committed", offsetof(struct wlr_surface_state, committed),
                 sizeof(((struct wlr_surface_state *)0)->committed),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "seq", offsetof(struct wlr_surface_state, seq),
           sizeof(((struct wlr_surface_state *)0)->seq),
           _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "buffer", offsetof(struct wlr_surface_state, buffer),
              sizeof(((struct wlr_surface_state *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 20) },
  { "dx", offsetof(struct wlr_surface_state, dx),
          sizeof(((struct wlr_surface_state *)0)->dx),
          _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "dy", offsetof(struct wlr_surface_state, dy),
          sizeof(((struct wlr_surface_state *)0)->dy),
          _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "surface_damage", offsetof(struct wlr_surface_state, surface_damage),
                      sizeof(((struct wlr_surface_state *)0)->surface_damage),
                      _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "buffer_damage", offsetof(struct wlr_surface_state, buffer_damage),
                     sizeof(((struct wlr_surface_state *)0)->buffer_damage),
                     _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "opaque", offsetof(struct wlr_surface_state, opaque),
              sizeof(((struct wlr_surface_state *)0)->opaque),
              _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "input", offsetof(struct wlr_surface_state, input),
             sizeof(((struct wlr_surface_state *)0)->input),
             _CFFI_OP(_CFFI_OP_NOOP, 1393) },
  { "transform", offsetof(struct wlr_surface_state, transform),
                 sizeof(((struct wlr_surface_state *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 127) },
  { "scale", offsetof(struct wlr_surface_state, scale),
             sizeof(((struct wlr_surface_state *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "frame_callback_list", offsetof(struct wlr_surface_state, frame_callback_list),
                           sizeof(((struct wlr_surface_state *)0)->frame_callback_list),
                           _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "width", offsetof(struct wlr_surface_state, width),
             sizeof(((struct wlr_surface_state *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "height", offsetof(struct wlr_surface_state, height),
              sizeof(((struct wlr_surface_state *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "buffer_width", offsetof(struct wlr_surface_state, buffer_width),
                    sizeof(((struct wlr_surface_state *)0)->buffer_width),
                    _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "buffer_height", offsetof(struct wlr_surface_state, buffer_height),
                     sizeof(((struct wlr_surface_state *)0)->buffer_height),
                     _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "subsurfaces_below", offsetof(struct wlr_surface_state, subsurfaces_below),
                         sizeof(((struct wlr_surface_state *)0)->subsurfaces_below),
                         _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "subsurfaces_above", offsetof(struct wlr_surface_state, subsurfaces_above),
                         sizeof(((struct wlr_surface_state *)0)->subsurfaces_above),
                         _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "base", offsetof(struct wlr_switch, base),
            sizeof(((struct wlr_switch *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 1465) },
  { "events", offsetof(struct wlr_switch, events),
              sizeof(((struct wlr_switch *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1363) },
  { "data", offsetof(struct wlr_switch, data),
            sizeof(((struct wlr_switch *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "time_msec", offsetof(struct wlr_switch_toggle_event, time_msec),
                 sizeof(((struct wlr_switch_toggle_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "switch_type", offsetof(struct wlr_switch_toggle_event, switch_type),
                   sizeof(((struct wlr_switch_toggle_event *)0)->switch_type),
                   _CFFI_OP(_CFFI_OP_NOOP, 1284) },
  { "switch_state", offsetof(struct wlr_switch_toggle_event, switch_state),
                    sizeof(((struct wlr_switch_toggle_event *)0)->switch_state),
                    _CFFI_OP(_CFFI_OP_NOOP, 1283) },
  { "base", offsetof(struct wlr_touch, base),
            sizeof(((struct wlr_touch *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 1465) },
  { "impl", offsetof(struct wlr_touch, impl),
            sizeof(((struct wlr_touch *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1594) },
  { "output_name", offsetof(struct wlr_touch, output_name),
                   sizeof(((struct wlr_touch *)0)->output_name),
                   _CFFI_OP(_CFFI_OP_NOOP, 1265) },
  { "width_mm", offsetof(struct wlr_touch, width_mm),
                sizeof(((struct wlr_touch *)0)->width_mm),
                _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "height_mm", offsetof(struct wlr_touch, height_mm),
                 sizeof(((struct wlr_touch *)0)->height_mm),
                 _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "events", offsetof(struct wlr_touch, events),
              sizeof(((struct wlr_touch *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1364) },
  { "data", offsetof(struct wlr_touch, data),
            sizeof(((struct wlr_touch *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "touch", offsetof(struct wlr_touch_cancel_event, touch),
             sizeof(((struct wlr_touch_cancel_event *)0)->touch),
             _CFFI_OP(_CFFI_OP_NOOP, 1588) },
  { "time_msec", offsetof(struct wlr_touch_cancel_event, time_msec),
                 sizeof(((struct wlr_touch_cancel_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "touch_id", offsetof(struct wlr_touch_cancel_event, touch_id),
                sizeof(((struct wlr_touch_cancel_event *)0)->touch_id),
                _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "touch", offsetof(struct wlr_touch_down_event, touch),
             sizeof(((struct wlr_touch_down_event *)0)->touch),
             _CFFI_OP(_CFFI_OP_NOOP, 1588) },
  { "time_msec", offsetof(struct wlr_touch_down_event, time_msec),
                 sizeof(((struct wlr_touch_down_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "touch_id", offsetof(struct wlr_touch_down_event, touch_id),
                sizeof(((struct wlr_touch_down_event *)0)->touch_id),
                _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "x", offsetof(struct wlr_touch_down_event, x),
         sizeof(((struct wlr_touch_down_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_touch_down_event, y),
         sizeof(((struct wlr_touch_down_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "touch", offsetof(struct wlr_touch_motion_event, touch),
             sizeof(((struct wlr_touch_motion_event *)0)->touch),
             _CFFI_OP(_CFFI_OP_NOOP, 1588) },
  { "time_msec", offsetof(struct wlr_touch_motion_event, time_msec),
                 sizeof(((struct wlr_touch_motion_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "touch_id", offsetof(struct wlr_touch_motion_event, touch_id),
                sizeof(((struct wlr_touch_motion_event *)0)->touch_id),
                _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "x", offsetof(struct wlr_touch_motion_event, x),
         sizeof(((struct wlr_touch_motion_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_touch_motion_event, y),
         sizeof(((struct wlr_touch_motion_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "touch", offsetof(struct wlr_touch_up_event, touch),
             sizeof(((struct wlr_touch_up_event *)0)->touch),
             _CFFI_OP(_CFFI_OP_NOOP, 1588) },
  { "time_msec", offsetof(struct wlr_touch_up_event, time_msec),
                 sizeof(((struct wlr_touch_up_event *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "touch_id", offsetof(struct wlr_touch_up_event, touch_id),
                sizeof(((struct wlr_touch_up_event *)0)->touch_id),
                _CFFI_OP(_CFFI_OP_NOOP, 146) },
  { "global", offsetof(struct wlr_viewporter, global),
              sizeof(((struct wlr_viewporter *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "events", offsetof(struct wlr_viewporter, events),
              sizeof(((struct wlr_viewporter *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1324) },
  { "display_destroy", offsetof(struct wlr_viewporter, display_destroy),
                       sizeof(((struct wlr_viewporter *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1409) },
  { "global", offsetof(struct wlr_virtual_keyboard_manager_v1, global),
              sizeof(((struct wlr_virtual_keyboard_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1405) },
  { "virtual_keyboards", offsetof(struct wlr_virtual_keyboard_manager_v1, virtual_keyboards),
                         sizeof(((struct wlr_virtual_keyboard_manager_v1 *)0)->virtual_keyboards),
                         _CFFI_OP(_CFFI_OP_NOOP, 1408) },
  { "display_destroy