
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kmainwindow_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "kxmlguiclient_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMainWindow_Type = nullptr;
static PyTypeObject *Sbk_KMainWindow_TypeF(void)
{
    return _Sbk_KMainWindow_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMainWindowWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMainWindowWrapper::KMainWindowWrapper(::QWidget * parent, ::QFlags<Qt::WindowType> flags) : KMainWindow(parent, flags)
{
}

void KMainWindowWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::closeEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_closeEvent("KMainWindow", funcName, gil, pyOverride, arg__1);
}

void KMainWindowWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KMainWindow", funcName, gil, pyOverride, signal);
}

void KMainWindowWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMainWindow::contextMenuEvent(event);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KMainWindow", funcName, gil, pyOverride, event);
}

::QMenu * KMainWindowWrapper::createPopupMenu()
{
    static const char *funcName = "createPopupMenu";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMainWindow::createPopupMenu();
    }
    return sbk_o_createPopupMenu("KMainWindow", funcName, gil, pyOverride);
}

::QMenu * KMainWindowWrapper::sbk_o_createPopupMenu(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QMenu >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMenu *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KMainWindowWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KMainWindow", funcName, gil, pyOverride, event);
}

int KMainWindowWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KMainWindow", funcName, gil, pyOverride);
}

void KMainWindowWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KMainWindow", funcName, gil, pyOverride, signal);
}

void KMainWindowWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KMainWindow", funcName, gil, pyOverride, event);
}

bool KMainWindowWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KMainWindow", funcName, gil, pyOverride, event);
}

bool KMainWindowWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KMainWindow", funcName, gil, pyOverride, watched, event);
}

void KMainWindowWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KMainWindow", funcName, gil, pyOverride, event);
}

bool KMainWindowWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KMainWindow", funcName, gil, pyOverride, next);
}

void KMainWindowWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KMainWindow", funcName, gil, pyOverride, event);
}

bool KMainWindowWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KMainWindow", funcName, gil, pyOverride);
}

int KMainWindowWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KMainWindow", funcName, gil, pyOverride, arg__1);
}

void KMainWindowWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KMainWindow", funcName, gil, pyOverride, painter);
}

void KMainWindowWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KMainWindow", funcName, gil, pyOverride, event);
}

::QVariant KMainWindowWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KMainWindow", funcName, gil, pyOverride, arg__1);
}

void KMainWindowWrapper::keyPressEvent(::QKeyEvent * keyEvent)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::keyPressEvent(keyEvent);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KMainWindow", funcName, gil, pyOverride, keyEvent);
}

void KMainWindowWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KMainWindow", funcName, gil, pyOverride, event);
}

int KMainWindowWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KMainWindow", funcName, gil, pyOverride, arg__1);
}

::QSize KMainWindowWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KMainWindow", funcName, gil, pyOverride);
}

void KMainWindowWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KMainWindow", funcName, gil, pyOverride, event);
}

bool KMainWindowWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KMainWindow", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KMainWindowWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KMainWindow", funcName, gil, pyOverride);
}

void KMainWindowWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KMainWindow", funcName, gil, pyOverride, event);
}

bool KMainWindowWrapper::queryClose()
{
    static const char *funcName = "queryClose";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::queryClose();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KMainWindow", funcName, gil, pyOverride);
}

::QPaintDevice * KMainWindowWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KMainWindow", funcName, gil, pyOverride, offset);
}

void KMainWindowWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::setCaption(const ::QString & caption)
{
    static const char *funcName = "setCaption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::setCaption(caption);
    }
    KXMLGUIClientWrapper::sbk_o_setLocalXMLFile("KMainWindow", funcName, gil, pyOverride, caption);
}

void KMainWindowWrapper::setCaption(const ::QString & caption, bool modified)
{
    static const char *funcName = "setCaption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::setCaption(caption, modified);
    }
    KXMLGUIClientWrapper::sbk_o_setXML("KMainWindow", funcName, gil, pyOverride, caption, modified);
}

void KMainWindowWrapper::setPlainCaption(const ::QString & caption)
{
    static const char *funcName = "setPlainCaption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::setPlainCaption(caption);
    }
    KXMLGUIClientWrapper::sbk_o_setLocalXMLFile("KMainWindow", funcName, gil, pyOverride, caption);
}

void KMainWindowWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KMainWindow", funcName, gil, pyOverride, visible);
}

::QPainter * KMainWindowWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KMainWindow", funcName, gil, pyOverride);
}

void KMainWindowWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KToolBarWrapper::sbk_o_showEvent("KMainWindow", funcName, gil, pyOverride, event);
}

::QSize KMainWindowWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KMainWindow", funcName, gil, pyOverride);
}

void KMainWindowWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KMainWindow", funcName, gil, pyOverride, event);
}

void KMainWindowWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMainWindow_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KMainWindow", funcName, gil, pyOverride, event);
}

const QMetaObject *KMainWindowWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMainWindow::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMainWindowWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMainWindow::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMainWindowWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMainWindowWrapper *>(this));
    }
    return KMainWindow::qt_metacast(_clname);
}

KMainWindowWrapper::~KMainWindowWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMainWindow_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMainWindow_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMainWindow >()))
        return -1;

    KMainWindowWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KMainWindow", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMainWindow::KMainWindow(QWidget*=,QFlags<Qt::WindowType>=)
    if (numArgs == 0) {
        overloadId = 0; // KMainWindow(QWidget*,QFlags<Qt::WindowType>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KMainWindow(QWidget*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // KMainWindow(QWidget*,QFlags<Qt::WindowType>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 0}, {"flags", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::WindowType> cppArg1 = Qt::WindowFlags();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KMainWindow(QWidget*,QFlags<Qt::WindowType>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KMainWindowWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KMainWindowWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMainWindow >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMainWindowFunc_appHelpActivated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // appHelpActivated()
        cppSelf->appHelpActivated();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_autoSaveGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // autoSaveGroup()const
        QString cppResult = const_cast<const ::KMainWindow *>(cppSelf)->autoSaveGroup();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_autoSaveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // autoSaveSettings()const
        bool cppResult = const_cast<const ::KMainWindow *>(cppSelf)->autoSaveSettings();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_canBeRestored(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KMainWindow::canBeRestored(int)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // canBeRestored(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "canBeRestored", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // canBeRestored(int)
            bool cppResult = ::KMainWindow::canBeRestored(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_classNameOfToplevel(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KMainWindow::classNameOfToplevel(int)->const QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // classNameOfToplevel(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "classNameOfToplevel", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // classNameOfToplevel(int)
            const QString cppResult = ::KMainWindow::classNameOfToplevel(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_closeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::closeEvent(QCloseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QCloseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // closeEvent(QCloseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "closeEvent", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCloseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // closeEvent(QCloseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMainWindow::closeEvent(cppArg0)
                : cppSelf->closeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_dbusName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dbusName()const
        QString cppResult = const_cast<const ::KMainWindow *>(cppSelf)->dbusName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMainWindow::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_hasMenuBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hasMenuBar()
        bool cppResult = cppSelf->hasMenuBar();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMainWindow::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_memberList(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // memberList()
        QList<KMainWindow*> cppResult = ::KMainWindow::memberList();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KMainWindowPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_queryClose(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // queryClose()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KMainWindow::queryClose()
            : cppSelf->queryClose();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_resetAutoSaveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetAutoSaveSettings()
        cppSelf->resetAutoSaveSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_restore(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "restore", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    if (PyArg_ParseTuple(args, "|OO:restore", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMainWindow::restore(int,bool=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // restore(int,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // restore(int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "restore", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"show", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "restore", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restore(int,bool)
            bool cppResult = cppSelf->restore(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_saveAutoSaveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveAutoSaveSettings()
        cppSelf->saveAutoSaveSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_setAutoSaveSettings(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setAutoSaveSettings", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setAutoSaveSettings", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMainWindow::setAutoSaveSettings(const QString&=,bool=)
    if (numArgs == 0) {
        overloadId = 0; // setAutoSaveSettings(QString,bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setAutoSaveSettings(QString,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setAutoSaveSettings(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setAutoSaveSettings", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"groupName", 0}, {"saveWindowSize", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setAutoSaveSettings", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
            }
        }
        ::QString cppArg0 = QStringLiteral("MainWindow");
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoSaveSettings(QString,bool)
            cppSelf->setAutoSaveSettings(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_setCaption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setCaption", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMainWindow::setCaption(QString,bool)
    // 1: KMainWindow::setCaption(QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setCaption(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setCaption(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setCaption", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setCaption(const QString &caption, bool modified)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setCaption(QString,bool)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::KMainWindow::setCaption(cppArg0, cppArg1)
                    : cppSelf->setCaption(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setCaption(const QString &caption)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setCaption(QString)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::KMainWindow::setCaption(cppArg0)
                    : cppSelf->setCaption(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_setPlainCaption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMainWindow::setPlainCaption(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setPlainCaption(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPlainCaption", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPlainCaption(QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMainWindow::setPlainCaption(cppArg0)
                : cppSelf->setPlainCaption(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_setSettingsDirty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setSettingsDirty()
        cppSelf->setSettingsDirty();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_setStateConfigGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMainWindow::setStateConfigGroup(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setStateConfigGroup(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStateConfigGroup", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStateConfigGroup(QString)
            cppSelf->setStateConfigGroup(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMainWindowFunc_settingsDirty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // settingsDirty()const
        bool cppResult = const_cast<const ::KMainWindow *>(cppSelf)->settingsDirty();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_toolBar(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "toolBar", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    if (PyArg_ParseTuple(args, "|O:toolBar", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMainWindow::toolBar(const QString&=)->KToolBar*
    if (numArgs == 0) {
        overloadId = 0; // toolBar(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // toolBar(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "toolBar", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"name", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "toolBar", errInfo, SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toolBar(QString)
            KToolBar * cppResult = cppSelf->toolBar(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMainWindowFunc_toolBars(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolBars()const
        QList<KToolBar*> cppResult = const_cast<const ::KMainWindow *>(cppSelf)->toolBars();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KToolBarPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMainWindow_PropertyStrings[] = {
    "autoSaveGroup:",
    "autoSaveSettings:",
    "hasMenuBar:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMainWindow_methods[] = {
    {"appHelpActivated", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_appHelpActivated), METH_NOARGS, nullptr},
    {"autoSaveGroup", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_autoSaveGroup), METH_NOARGS, nullptr},
    {"autoSaveSettings", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_autoSaveSettings), METH_NOARGS, nullptr},
    {"canBeRestored", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_canBeRestored), METH_O|METH_STATIC, nullptr},
    {"classNameOfToplevel", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_classNameOfToplevel), METH_O|METH_STATIC, nullptr},
    {"closeEvent", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_closeEvent), METH_O, nullptr},
    {"dbusName", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_dbusName), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_event), METH_O, nullptr},
    {"hasMenuBar", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_hasMenuBar), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_keyPressEvent), METH_O, nullptr},
    {"memberList", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_memberList), METH_NOARGS|METH_STATIC, nullptr},
    {"queryClose", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_queryClose), METH_NOARGS, nullptr},
    {"resetAutoSaveSettings", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_resetAutoSaveSettings), METH_NOARGS, nullptr},
    {"restore", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_restore), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"saveAutoSaveSettings", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_saveAutoSaveSettings), METH_NOARGS, nullptr},
    {"setAutoSaveSettings", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_setAutoSaveSettings), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setCaption", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_setCaption), METH_VARARGS, nullptr},
    {"setPlainCaption", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_setPlainCaption), METH_O, nullptr},
    {"setSettingsDirty", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_setSettingsDirty), METH_NOARGS, nullptr},
    {"setStateConfigGroup", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_setStateConfigGroup), METH_O, nullptr},
    {"settingsDirty", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_settingsDirty), METH_NOARGS, nullptr},
    {"toolBar", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_toolBar), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"toolBars", reinterpret_cast<PyCFunction>(Sbk_KMainWindowFunc_toolBars), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMainWindow_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMainWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMainWindowWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMainWindow_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMainWindow_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMainWindowSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMainWindow *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX]))
        return static_cast< ::QMainWindow *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMainWindow_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMainWindow_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMainWindow_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMainWindow_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMainWindow_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMainWindow_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMainWindow_spec = {
    "1:KXmlGui.KMainWindow",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMainWindow_slots
};

} //extern "C"

static void *Sbk_KMainWindow_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMainWindow *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMainWindow *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMainWindow *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMainWindow_PythonToCpp_KMainWindow_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMainWindow_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMainWindow_PythonToCpp_KMainWindow_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMainWindow_TypeF()))
        return KMainWindow_PythonToCpp_KMainWindow_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMainWindow_PTR_CppToPython_KMainWindow(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMainWindow *>(const_cast<void *>(cppIn)), Sbk_KMainWindow_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMainWindow_SignatureStrings[] = {
    "KXmlGui.KMainWindow(self,parent:PySide6.QtWidgets.QWidget=nullptr,flags:PySide6.QtCore.Qt.WindowType=Qt.WindowFlags(),*:KeywordOnly=None,hasMenuBar:bool=None,autoSaveSettings:bool=None,autoSaveGroup:QString=None)",
    "KXmlGui.KMainWindow.appHelpActivated(self)",
    "KXmlGui.KMainWindow.autoSaveGroup(self)->QString",
    "KXmlGui.KMainWindow.autoSaveSettings(self)->bool",
    "KXmlGui.KMainWindow.canBeRestored(numberOfInstances:int)->bool",
    "KXmlGui.KMainWindow.classNameOfToplevel(instanceNumber:int)->QString",
    "KXmlGui.KMainWindow.closeEvent(self,arg__1:PySide6.QtGui.QCloseEvent)",
    "KXmlGui.KMainWindow.dbusName(self)->QString",
    "KXmlGui.KMainWindow.event(self,event:PySide6.QtCore.QEvent)->bool",
    "KXmlGui.KMainWindow.hasMenuBar(self)->bool",
    "KXmlGui.KMainWindow.keyPressEvent(self,keyEvent:PySide6.QtGui.QKeyEvent)",
    "KXmlGui.KMainWindow.memberList()->QList[KXmlGui.KMainWindow]",
    "KXmlGui.KMainWindow.queryClose(self)->bool",
    "KXmlGui.KMainWindow.resetAutoSaveSettings(self)",
    "KXmlGui.KMainWindow.restore(self,numberOfInstances:int,show:bool=true)->bool",
    "KXmlGui.KMainWindow.saveAutoSaveSettings(self)",
    R"CPP(KXmlGui.KMainWindow.setAutoSaveSettings(self,groupName:QString=QStringLiteral("MainWindow"),saveWindowSize:bool=true))CPP",
    "1:KXmlGui.KMainWindow.setCaption(self,caption:QString,modified:bool)",
    "0:KXmlGui.KMainWindow.setCaption(self,caption:QString)",
    "KXmlGui.KMainWindow.setPlainCaption(self,caption:QString)",
    "KXmlGui.KMainWindow.setSettingsDirty(self)",
    "KXmlGui.KMainWindow.setStateConfigGroup(self,configGroup:QString)",
    "KXmlGui.KMainWindow.settingsDirty(self)->bool",
    "KXmlGui.KMainWindow.toolBar(self,name:QString=QString())->KXmlGui.KToolBar",
    "KXmlGui.KMainWindow.toolBars(self)->QList[KXmlGui.KToolBar]",
    nullptr}; // Sentinel
#else
static constexpr size_t KMainWindow_SignatureByteSize = 505;
static constexpr uint8_t KMainWindow_SignatureBytes[505] = {
    0x78, 0xda, 0x9d, 0x54, 0xc9, 0x6e, 0xdb, 0x30, 0x10, 0xbd, 0xfb, 0x33, 0x72, 0x92, 0x0a, 0x56,
    0x68, 0x2e, 0x3d, 0x08, 0x70, 0x81, 0xc4, 0x4d, 0xd3, 0x42, 0x89, 0x97, 0xca, 0x40, 0x0a, 0x14,
    0x41, 0x40, 0x4b, 0x23, 0x85, 0x28, 0x45, 0xaa, 0xe4, 0xc8, 0x86, 0xfa, 0xf5, 0xa5, 0x44, 0x2d,
    0x86, 0x2d, 0xc9, 0x6d, 0x4e, 0xdc, 0xe6, 0xcd, 0x9b, 0x37, 0x0b, 0x83, 0x1f, 0x19, 0xbf, 0x2f,
    0x98, 0x17, 0x3c, 0x52, 0x26, 0x9e, 0x98, 0x88, 0xe5, 0xc1, 0xd1, 0xc0, 0x13, 0x92, 0x53, 0x05,
    0x02, 0xfd, 0x75, 0x19, 0xb2, 0x18, 0x3e, 0x7a, 0x1b, 0x7c, 0x62, 0x71, 0x0a, 0xa8, 0xbd, 0x8d,
    0xdd, 0xcc, 0x45, 0xc1, 0x79, 0x8e, 0x8a, 0x24, 0x9c, 0xa6, 0xfa, 0xc8, 0x6e, 0x21, 0x15, 0x98,
    0xc5, 0xb3, 0xce, 0xb6, 0x65, 0x0e, 0xf3, 0xee, 0xf4, 0xa5, 0xb2, 0x75, 0x5c, 0xf2, 0xce, 0x0f,
    0xa0, 0x3c, 0x48, 0x15, 0xaf, 0x04, 0x2f, 0xe7, 0x4b, 0x29, 0x80, 0xbc, 0x52, 0xfd, 0x08, 0xa2,
    0xb8, 0xa5, 0xca, 0xdf, 0x49, 0xc9, 0xed, 0x25, 0x2d, 0x50, 0x86, 0x74, 0x0f, 0x21, 0x20, 0x32,
    0x61, 0x68, 0xce, 0x9f, 0xee, 0x95, 0x2c, 0x72, 0x7f, 0x13, 0xa2, 0x32, 0x06, 0xf5, 0x93, 0x3b,
    0x0b, 0xce, 0x45, 0x79, 0x34, 0xcf, 0xbf, 0x02, 0xcf, 0x6f, 0x22, 0x64, 0x7b, 0x8a, 0x10, 0xd7,
    0x2a, 0x47, 0x4c, 0x8f, 0x5d, 0x5b, 0xbb, 0xf7, 0x9f, 0x1a, 0x86, 0x49, 0x40, 0x1b, 0x66, 0x8b,
    0xa9, 0xa2, 0x1d, 0x04, 0x44, 0x54, 0xdc, 0xc2, 0x77, 0xd0, 0x68, 0x72, 0x15, 0x3b, 0xa2, 0xc8,
    0x76, 0xa0, 0x56, 0xc9, 0x37, 0xa1, 0x91, 0x8a, 0x08, 0xb4, 0xcf, 0x04, 0x4e, 0xc2, 0x39, 0xd5,
    0x7a, 0x49, 0x33, 0x58, 0x25, 0x5b, 0x99, 0x73, 0xd8, 0x03, 0x77, 0x58, 0x03, 0x5e, 0xd6, 0xce,
    0x1a, 0x0f, 0x53, 0x41, 0x47, 0x5c, 0x6a, 0xb8, 0xdb, 0x9b, 0x22, 0xdb, 0x82, 0x53, 0x95, 0xbe,
    0xbc, 0x5c, 0x1f, 0x15, 0xb2, 0x02, 0x6c, 0x16, 0x9d, 0xd5, 0x70, 0xae, 0xe2, 0x5d, 0x51, 0x47,
    0xf2, 0x2f, 0x69, 0x82, 0x9e, 0xac, 0xde, 0x9e, 0x35, 0x8d, 0xe5, 0x99, 0x10, 0xde, 0x37, 0xc9,
    0xc5, 0x14, 0xff, 0x82, 0x72, 0xad, 0x40, 0xeb, 0x23, 0x85, 0xe6, 0xea, 0xee, 0x84, 0xb7, 0xd6,
    0x18, 0x34, 0xf7, 0xc3, 0x0a, 0x33, 0xa8, 0x12, 0xfa, 0xc0, 0x34, 0x3a, 0x95, 0xbe, 0x6a, 0xf3,
    0x73, 0xc0, 0xee, 0x79, 0x10, 0xfc, 0xbb, 0x00, 0x55, 0xd6, 0x39, 0xbc, 0x18, 0xb0, 0x09, 0x16,
    0xf0, 0x66, 0xb0, 0x93, 0xc6, 0xec, 0xab, 0xf6, 0xb1, 0xd2, 0x06, 0x5b, 0x88, 0xe8, 0x57, 0x79,
    0xb0, 0x23, 0x83, 0xaa, 0x80, 0x29, 0x72, 0x6d, 0x38, 0xff, 0x83, 0x7b, 0x2c, 0x52, 0x92, 0x56,
    0x23, 0x53, 0xf5, 0x43, 0x37, 0x91, 0xcd, 0xfa, 0xc0, 0x10, 0x14, 0xe5, 0xce, 0x55, 0xef, 0xe5,
    0xca, 0x25, 0x15, 0xad, 0x3d, 0x84, 0xec, 0x0f, 0x1c, 0x85, 0x3a, 0xbb, 0xf6, 0x47, 0x78, 0x17,
    0x34, 0x47, 0x26, 0x85, 0xa5, 0x8b, 0xec, 0xa1, 0x25, 0x23, 0x99, 0x8c, 0x59, 0xc2, 0x20, 0xae,
    0x3d, 0xb9, 0xb3, 0x0f, 0x6f, 0x71, 0x32, 0xaa, 0x78, 0xcd, 0xcd, 0xf1, 0x4d, 0xc8, 0x36, 0x47,
    0x9f, 0x99, 0xc2, 0x72, 0x3a, 0xad, 0x21, 0x9a, 0xcf, 0x69, 0x21, 0x45, 0xc2, 0xd2, 0xfe, 0xfb,
    0x21, 0x51, 0x7f, 0x71, 0x91, 0xec, 0x94, 0x69, 0xa2, 0xea, 0x68, 0x1e, 0xda, 0x59, 0x22, 0x62,
    0xa0, 0x6a, 0x8e, 0x6b, 0xe0, 0x1d, 0x72, 0x6b, 0xcd, 0xa7, 0x5c, 0x75, 0x5f, 0xdf, 0xc9, 0x9c,
    0x34, 0xd0, 0xe7, 0xd9, 0x5f, 0xdb, 0xf0, 0x5a, 0xdb
};
#endif

PyTypeObject *init_KMainWindow(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX].type;

    Shiboken::AutoDecRef Sbk_KMainWindow_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX]))));

    _Sbk_KMainWindow_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMainWindow",
        "KMainWindow*",
        &Sbk_KMainWindow_spec,
        &Shiboken::callCppDestructor< KMainWindow >,
        Sbk_KMainWindow_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KMainWindow_Type; // references _Sbk_KMainWindow_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMainWindow_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMainWindow_SignatureBytes, KMainWindow_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMainWindow_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMainWindow_PythonToCpp_KMainWindow_PTR,
        is_KMainWindow_PythonToCpp_KMainWindow_PTR_Convertible,
        KMainWindow_PTR_CppToPython_KMainWindow);

    Shiboken::Conversions::registerConverterName(converter, "KMainWindow");
    Shiboken::Conversions::registerConverterName(converter, "KMainWindow*");
    Shiboken::Conversions::registerConverterName(converter, "KMainWindow&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMainWindow).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMainWindowWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMainWindow_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMainWindow_TypeF(), &Sbk_KMainWindowSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMainWindow_TypeF(), &Sbk_KMainWindow_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMainWindow::staticMetaObject, sizeof(KMainWindowWrapper));

    return pyType;
}
