/* gitg-stage-status-enumerator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-stage-status-enumerator.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_STAGE_STATUS_FILE_0_PROPERTY,
	GITG_STAGE_STATUS_FILE_PATH_PROPERTY,
	GITG_STAGE_STATUS_FILE_IS_STAGED_PROPERTY,
	GITG_STAGE_STATUS_FILE_IS_UNSTAGED_PROPERTY,
	GITG_STAGE_STATUS_FILE_IS_UNTRACKED_PROPERTY,
	GITG_STAGE_STATUS_FILE_FLAGS_PROPERTY,
	GITG_STAGE_STATUS_FILE_ICON_NAME_PROPERTY,
	GITG_STAGE_STATUS_FILE_NUM_PROPERTIES
};
static GParamSpec* gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GITG_STAGE_STATUS_SUBMODULE_0_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_SUBMODULE_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_PATH_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_IS_STAGED_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_IS_UNSTAGED_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_IS_UNTRACKED_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_IS_DIRTY_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_FLAGS_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_ICON_NAME_PROPERTY,
	GITG_STAGE_STATUS_SUBMODULE_NUM_PROPERTIES
};
static GParamSpec* gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_NUM_PROPERTIES];
#define _ggit_submodule_unref0(var) ((var == NULL) ? NULL : (var = (ggit_submodule_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GITG_STAGE_STATUS_ENUMERATOR_0_PROPERTY,
	GITG_STAGE_STATUS_ENUMERATOR_NUM_PROPERTIES
};
static GParamSpec* gitg_stage_status_enumerator_properties[GITG_STAGE_STATUS_ENUMERATOR_NUM_PROPERTIES];
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
typedef void (*GitgStageStatusEnumeratorAddItem) (GitgStageStatusItem* item, gpointer user_data);
typedef struct _Block31Data Block31Data;
typedef struct _GitgStageStatusEnumeratorNextItemsData GitgStageStatusEnumeratorNextItemsData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgStageStatusFilePrivate {
	gchar* d_path;
	GgitStatusFlags d_flags;
};

struct _GitgStageStatusSubmodulePrivate {
	GgitSubmodule* d_submodule;
	gchar* d_path;
	GgitSubmoduleStatus d_flags;
};

struct _GitgStageStatusEnumeratorPrivate {
	GitgRepository* d_repository;
	GThread* d_thread;
	GitgStageStatusItem** d_items;
	gint d_items_length1;
	gint _d_items_size_;
	GRecMutex __lock_d_items;
	gint d_offset;
	gint d_callback_num;
	GCancellable* d_cancellable;
	GSourceFunc d_callback;
	gpointer d_callback_target;
	GDestroyNotify d_callback_target_destroy_notify;
	GgitStatusOptions* d_options;
	GeeHashSet* d_ignored_submodules;
};

struct _Block31Data {
	int _ref_count_;
	GitgStageStatusEnumerator* self;
	GitgStageStatusEnumeratorAddItem add;
	gpointer add_target;
	GDestroyNotify add_target_destroy_notify;
	GeeHashSet* submodule_paths;
};

struct _GitgStageStatusEnumeratorNextItemsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStageStatusEnumerator* self;
	gint num;
	GitgStageStatusItem** result;
	gint result_length1;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GitgStageStatusItem** ret;
	gint ret_length1;
	gint _ret_size_;
	GitgStageStatusItem** _tmp0_;
	gint _tmp0__length1;
	GCancellable* _tmp1_;
	gint _tmp2_;
	GitgStageStatusItem** _tmp3_;
	GitgStageStatusItem** _tmp4_;
	gint _tmp4__length1;
	GitgStageStatusItem** _tmp5_;
	gint _tmp5__length1;
	GSourceFunc _tmp6_;
	gpointer _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	GitgStageStatusItem** _tmp7_;
	gint _tmp7__length1;
	GitgStageStatusItem** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GitgStageStatusItem** _tmp10_;
	GitgStageStatusItem** _tmp11_;
	gint _tmp11__length1;
	GitgStageStatusItem** _tmp12_;
	gint _tmp12__length1;
	GitgStageStatusItem** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_;
};

static gint GitgStageStatusFile_private_offset;
static gpointer gitg_stage_status_file_parent_class = NULL;
static GgitStatusFlags gitg_stage_status_file_s_index_flags;
static GgitStatusFlags gitg_stage_status_file_s_index_flags = (((GGIT_STATUS_INDEX_NEW | GGIT_STATUS_INDEX_MODIFIED) | GGIT_STATUS_INDEX_DELETED) | GGIT_STATUS_INDEX_RENAMED) | GGIT_STATUS_INDEX_TYPECHANGE;
static GgitStatusFlags gitg_stage_status_file_s_work_flags;
static GgitStatusFlags gitg_stage_status_file_s_work_flags = ((GGIT_STATUS_WORKING_TREE_MODIFIED | GGIT_STATUS_WORKING_TREE_DELETED) | GGIT_STATUS_WORKING_TREE_TYPECHANGE) | GGIT_STATUS_CONFLICTED;
static GgitStatusFlags gitg_stage_status_file_s_untracked_flags;
static GgitStatusFlags gitg_stage_status_file_s_untracked_flags = GGIT_STATUS_WORKING_TREE_NEW;
static GgitStatusFlags gitg_stage_status_file_s_ignored_flags;
static GgitStatusFlags gitg_stage_status_file_s_ignored_flags = GGIT_STATUS_IGNORED;
static GitgStageStatusItemIface * gitg_stage_status_file_gitg_stage_status_item_parent_iface = NULL;
static gint GitgStageStatusSubmodule_private_offset;
static gpointer gitg_stage_status_submodule_parent_class = NULL;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_index_flags;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_index_flags = (GGIT_SUBMODULE_STATUS_INDEX_ADDED | GGIT_SUBMODULE_STATUS_INDEX_DELETED) | GGIT_SUBMODULE_STATUS_INDEX_MODIFIED;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_work_flags;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_work_flags = (GGIT_SUBMODULE_STATUS_WD_ADDED | GGIT_SUBMODULE_STATUS_WD_DELETED) | GGIT_SUBMODULE_STATUS_WD_MODIFIED;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_untracked_flags;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_untracked_flags = GGIT_SUBMODULE_STATUS_IN_WD;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_tracked_flags;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_tracked_flags = GGIT_SUBMODULE_STATUS_IN_HEAD | GGIT_SUBMODULE_STATUS_IN_INDEX;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_dirty_flags;
static GgitSubmoduleStatus gitg_stage_status_submodule_s_dirty_flags = GGIT_SUBMODULE_STATUS_WD_INDEX_MODIFIED | GGIT_SUBMODULE_STATUS_WD_WD_MODIFIED;
static GitgStageStatusItemIface * gitg_stage_status_submodule_gitg_stage_status_item_parent_iface = NULL;
static gint GitgStageStatusEnumerator_private_offset;
static gpointer gitg_stage_status_enumerator_parent_class = NULL;
static GRegex* gitg_stage_status_enumerator_s_ignore_regex;
static GRegex* gitg_stage_status_enumerator_s_ignore_regex = NULL;

static GType gitg_stage_status_item_get_type_once (void);
static gchar* gitg_stage_status_file_icon_for_status (GitgStageStatusFile* self,
                                               GgitStatusFlags status);
static void gitg_stage_status_file_finalize (GObject * obj);
static GType gitg_stage_status_file_get_type_once (void);
static void _vala_gitg_stage_status_file_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void gitg_stage_status_submodule_finalize (GObject * obj);
static GType gitg_stage_status_submodule_get_type_once (void);
static void _vala_gitg_stage_status_submodule_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
VALA_EXTERN GitgStageStatusEnumerator* gitg_stage_status_enumerator_new (GitgRepository* repository,
                                                             GgitStatusOptions* options);
VALA_EXTERN GitgStageStatusEnumerator* gitg_stage_status_enumerator_construct (GType object_type,
                                                                   GitgRepository* repository,
                                                                   GgitStatusOptions* options);
static GgitStatusOptions* _vala_GgitStatusOptions_copy (GgitStatusOptions* self);
static gint ___lambda8_ (GitgStageStatusEnumerator* self,
                  GMatchInfo* match,
                  const gchar* val);
static gint ____lambda8__ggit_config_match_callback (GMatchInfo* match_info,
                                              const gchar* value,
                                              gpointer self);
static void* gitg_stage_status_enumerator_run_status (GitgStageStatusEnumerator* self);
static gpointer _gitg_stage_status_enumerator_run_status_gthread_func (gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda9_ (GitgStageStatusEnumerator* self,
                 GitgStageStatusItem* item);
static void _vala_array_add16 (GitgStageStatusItem** * array,
                        gint* length,
                        gint* size,
                        GitgStageStatusItem* value);
static void ___lambda9__gitg_stage_status_enumerator_add_item (GitgStageStatusItem* item,
                                                        gpointer self);
static gint ____lambda10_ (Block31Data* _data31_,
                    GgitSubmodule* submodule,
                    const gchar* name);
static gint _____lambda10__ggit_submodule_callback (GgitSubmodule* submodule,
                                             const gchar* name,
                                             gpointer self);
static gint ___lambda11_ (Block31Data* _data31_,
                   const gchar* path,
                   GgitStatusFlags flags);
static gint ____lambda11__ggit_status_callback (const gchar* path,
                                         GgitStatusFlags status_flags,
                                         gpointer self);
static GitgStageStatusItem** gitg_stage_status_enumerator_fill_items (GitgStageStatusEnumerator* self,
                                                               gint num,
                                                               gint* result_length1);
static void _vala_array_add17 (GitgStageStatusItem** * array,
                        gint* length,
                        gint* size,
                        GitgStageStatusItem* value);
static void gitg_stage_status_enumerator_next_items_data_free (gpointer _data);
static gboolean gitg_stage_status_enumerator_next_items_co (GitgStageStatusEnumeratorNextItemsData* _data_);
static gboolean _gitg_stage_status_enumerator_next_items_co_gsource_func (gpointer self);
static void gitg_stage_status_enumerator_finalize (GObject * obj);
static GType gitg_stage_status_enumerator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
gitg_stage_status_item_get_path (GitgStageStatusItem* self)
{
	GitgStageStatusItemIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_STAGE_STATUS_ITEM_GET_INTERFACE (self);
	if (_iface_->get_path) {
		return _iface_->get_path (self);
	}
	return NULL;
}

gboolean
gitg_stage_status_item_get_is_staged (GitgStageStatusItem* self)
{
	GitgStageStatusItemIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_STAGE_STATUS_ITEM_GET_INTERFACE (self);
	if (_iface_->get_is_staged) {
		return _iface_->get_is_staged (self);
	}
	return FALSE;
}

gboolean
gitg_stage_status_item_get_is_unstaged (GitgStageStatusItem* self)
{
	GitgStageStatusItemIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_STAGE_STATUS_ITEM_GET_INTERFACE (self);
	if (_iface_->get_is_unstaged) {
		return _iface_->get_is_unstaged (self);
	}
	return FALSE;
}

gboolean
gitg_stage_status_item_get_is_untracked (GitgStageStatusItem* self)
{
	GitgStageStatusItemIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_STAGE_STATUS_ITEM_GET_INTERFACE (self);
	if (_iface_->get_is_untracked) {
		return _iface_->get_is_untracked (self);
	}
	return FALSE;
}

gchar*
gitg_stage_status_item_get_icon_name (GitgStageStatusItem* self)
{
	GitgStageStatusItemIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_STAGE_STATUS_ITEM_GET_INTERFACE (self);
	if (_iface_->get_icon_name) {
		return _iface_->get_icon_name (self);
	}
	return NULL;
}

static void
gitg_stage_status_item_default_init (GitgStageStatusItemIface * iface,
                                     gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-staged", "is-staged", "is-staged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-unstaged", "is-unstaged", "is-unstaged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-untracked", "is-untracked", "is-untracked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

 G_GNUC_NO_INLINE static GType
gitg_stage_status_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgStageStatusItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_stage_status_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gitg_stage_status_item_type_id;
	gitg_stage_status_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgStageStatusItem", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gitg_stage_status_item_type_id, G_TYPE_OBJECT);
	return gitg_stage_status_item_type_id;
}

GType
gitg_stage_status_item_get_type (void)
{
	static gsize gitg_stage_status_item_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_status_item_type_id__once)) {
		GType gitg_stage_status_item_type_id;
		gitg_stage_status_item_type_id = gitg_stage_status_item_get_type_once ();
		g_once_init_leave (&gitg_stage_status_item_type_id__once, gitg_stage_status_item_type_id);
	}
	return gitg_stage_status_item_type_id__once;
}

static inline gpointer
gitg_stage_status_file_get_instance_private (GitgStageStatusFile* self)
{
	return G_STRUCT_MEMBER_P (self, GitgStageStatusFile_private_offset);
}

GitgStageStatusFile*
gitg_stage_status_file_construct (GType object_type,
                                  const gchar* path,
                                  GgitStatusFlags flags)
{
	GitgStageStatusFile * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (path != NULL, NULL);
	self = (GitgStageStatusFile*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (self->priv->d_path);
	self->priv->d_path = _tmp0_;
	self->priv->d_flags = flags;
	return self;
}

GitgStageStatusFile*
gitg_stage_status_file_new (const gchar* path,
                            GgitStatusFlags flags)
{
	return gitg_stage_status_file_construct (GITG_TYPE_STAGE_STATUS_FILE, path, flags);
}

static gchar*
gitg_stage_status_file_icon_for_status (GitgStageStatusFile* self,
                                        GgitStatusFlags status)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if ((status & (GGIT_STATUS_INDEX_NEW | GGIT_STATUS_WORKING_TREE_NEW)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("list-add-symbolic");
		result = _tmp0_;
		return result;
	} else {
		if ((status & ((((GGIT_STATUS_INDEX_MODIFIED | GGIT_STATUS_INDEX_RENAMED) | GGIT_STATUS_INDEX_TYPECHANGE) | GGIT_STATUS_WORKING_TREE_MODIFIED) | GGIT_STATUS_WORKING_TREE_TYPECHANGE)) != 0) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("text-editor-symbolic");
			result = _tmp1_;
			return result;
		} else {
			if ((status & (GGIT_STATUS_INDEX_DELETED | GGIT_STATUS_WORKING_TREE_DELETED)) != 0) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("edit-delete-symbolic");
				result = _tmp2_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
gitg_stage_status_file_real_get_path (GitgStageStatusItem* base)
{
	gchar* result;
	GitgStageStatusFile* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GitgStageStatusFile*) base;
	_tmp0_ = self->priv->d_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
gitg_stage_status_file_real_get_is_staged (GitgStageStatusItem* base)
{
	gboolean result;
	GitgStageStatusFile* self;
	self = (GitgStageStatusFile*) base;
	result = (self->priv->d_flags & gitg_stage_status_file_s_index_flags) != 0;
	return result;
}

static gboolean
gitg_stage_status_file_real_get_is_unstaged (GitgStageStatusItem* base)
{
	gboolean result;
	GitgStageStatusFile* self;
	self = (GitgStageStatusFile*) base;
	result = (self->priv->d_flags & gitg_stage_status_file_s_work_flags) != 0;
	return result;
}

static gboolean
gitg_stage_status_file_real_get_is_untracked (GitgStageStatusItem* base)
{
	gboolean result;
	GitgStageStatusFile* self;
	self = (GitgStageStatusFile*) base;
	result = (self->priv->d_flags & gitg_stage_status_file_s_untracked_flags) != 0;
	return result;
}

GgitStatusFlags
gitg_stage_status_file_get_flags (GitgStageStatusFile* self)
{
	GgitStatusFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_flags;
	return result;
}

static gchar*
gitg_stage_status_file_real_get_icon_name (GitgStageStatusItem* base)
{
	gchar* result;
	GitgStageStatusFile* self;
	gchar* _tmp0_;
	self = (GitgStageStatusFile*) base;
	_tmp0_ = gitg_stage_status_file_icon_for_status (self, self->priv->d_flags);
	result = _tmp0_;
	return result;
}

static void
gitg_stage_status_file_class_init (GitgStageStatusFileClass * klass,
                                   gpointer klass_data)
{
	gitg_stage_status_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgStageStatusFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_stage_status_file_get_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_stage_status_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_FILE_PATH_PROPERTY, gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_FILE_IS_STAGED_PROPERTY, gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_IS_STAGED_PROPERTY] = g_param_spec_boolean ("is-staged", "is-staged", "is-staged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_FILE_IS_UNSTAGED_PROPERTY, gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_IS_UNSTAGED_PROPERTY] = g_param_spec_boolean ("is-unstaged", "is-unstaged", "is-unstaged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_FILE_IS_UNTRACKED_PROPERTY, gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_IS_UNTRACKED_PROPERTY] = g_param_spec_boolean ("is-untracked", "is-untracked", "is-untracked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_FILE_FLAGS_PROPERTY, gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_FLAGS_PROPERTY] = g_param_spec_flags ("flags", "flags", "flags", ggit_status_flags_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_FILE_ICON_NAME_PROPERTY, gitg_stage_status_file_properties[GITG_STAGE_STATUS_FILE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_stage_status_file_gitg_stage_status_item_interface_init (GitgStageStatusItemIface * iface,
                                                              gpointer iface_data)
{
	gitg_stage_status_file_gitg_stage_status_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_path = gitg_stage_status_file_real_get_path;
	iface->get_is_staged = gitg_stage_status_file_real_get_is_staged;
	iface->get_is_unstaged = gitg_stage_status_file_real_get_is_unstaged;
	iface->get_is_untracked = gitg_stage_status_file_real_get_is_untracked;
	iface->get_icon_name = gitg_stage_status_file_real_get_icon_name;
}

static void
gitg_stage_status_file_instance_init (GitgStageStatusFile * self,
                                      gpointer klass)
{
	self->priv = gitg_stage_status_file_get_instance_private (self);
}

static void
gitg_stage_status_file_finalize (GObject * obj)
{
	GitgStageStatusFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_STAGE_STATUS_FILE, GitgStageStatusFile);
	_g_free0 (self->priv->d_path);
	G_OBJECT_CLASS (gitg_stage_status_file_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_stage_status_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgStageStatusFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_stage_status_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgStageStatusFile), 0, (GInstanceInitFunc) gitg_stage_status_file_instance_init, NULL };
	static const GInterfaceInfo gitg_stage_status_item_info = { (GInterfaceInitFunc) gitg_stage_status_file_gitg_stage_status_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_stage_status_file_type_id;
	gitg_stage_status_file_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgStageStatusFile", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_stage_status_file_type_id, GITG_TYPE_STAGE_STATUS_ITEM, &gitg_stage_status_item_info);
	GitgStageStatusFile_private_offset = g_type_add_instance_private (gitg_stage_status_file_type_id, sizeof (GitgStageStatusFilePrivate));
	return gitg_stage_status_file_type_id;
}

GType
gitg_stage_status_file_get_type (void)
{
	static gsize gitg_stage_status_file_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_status_file_type_id__once)) {
		GType gitg_stage_status_file_type_id;
		gitg_stage_status_file_type_id = gitg_stage_status_file_get_type_once ();
		g_once_init_leave (&gitg_stage_status_file_type_id__once, gitg_stage_status_file_type_id);
	}
	return gitg_stage_status_file_type_id__once;
}

static void
_vala_gitg_stage_status_file_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GitgStageStatusFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_STAGE_STATUS_FILE, GitgStageStatusFile);
	switch (property_id) {
		case GITG_STAGE_STATUS_FILE_PATH_PROPERTY:
		g_value_take_string (value, gitg_stage_status_item_get_path ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_FILE_IS_STAGED_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_item_get_is_staged ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_FILE_IS_UNSTAGED_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_item_get_is_unstaged ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_FILE_IS_UNTRACKED_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_item_get_is_untracked ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_FILE_FLAGS_PROPERTY:
		g_value_set_flags (value, gitg_stage_status_file_get_flags (self));
		break;
		case GITG_STAGE_STATUS_FILE_ICON_NAME_PROPERTY:
		g_value_take_string (value, gitg_stage_status_item_get_icon_name ((GitgStageStatusItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gitg_stage_status_submodule_get_instance_private (GitgStageStatusSubmodule* self)
{
	return G_STRUCT_MEMBER_P (self, GitgStageStatusSubmodule_private_offset);
}

static gpointer
_ggit_submodule_ref0 (gpointer self)
{
	return self ? ggit_submodule_ref (self) : NULL;
}

GitgStageStatusSubmodule*
gitg_stage_status_submodule_construct (GType object_type,
                                       GgitSubmodule* submodule)
{
	GitgStageStatusSubmodule * self = NULL;
	GgitSubmodule* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GgitRepository* repository = NULL;
	GgitRepository* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (submodule != NULL, NULL);
	self = (GitgStageStatusSubmodule*) g_object_new (object_type, NULL);
	_tmp0_ = _ggit_submodule_ref0 (submodule);
	_ggit_submodule_unref0 (self->priv->d_submodule);
	self->priv->d_submodule = _tmp0_;
	_tmp1_ = ggit_submodule_get_path (submodule);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->d_path);
	self->priv->d_path = _tmp2_;
	_tmp3_ = ggit_submodule_get_owner (submodule);
	repository = _tmp3_;
	{
		GgitSubmoduleStatus _tmp4_ = 0U;
		const gchar* _tmp5_;
		_tmp5_ = ggit_submodule_get_name (submodule);
		_tmp4_ = ggit_repository_get_submodule_status (repository, _tmp5_, GGIT_SUBMODULE_IGNORE_UNTRACKED, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->d_flags = _tmp4_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repository);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_object_unref0 (repository);
	return self;
}

GitgStageStatusSubmodule*
gitg_stage_status_submodule_new (GgitSubmodule* submodule)
{
	return gitg_stage_status_submodule_construct (GITG_TYPE_STAGE_STATUS_SUBMODULE, submodule);
}

GgitSubmodule*
gitg_stage_status_submodule_get_submodule (GitgStageStatusSubmodule* self)
{
	GgitSubmodule* result;
	GgitSubmodule* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_submodule;
	result = _tmp0_;
	return result;
}

static gchar*
gitg_stage_status_submodule_real_get_path (GitgStageStatusItem* base)
{
	gchar* result;
	GitgStageStatusSubmodule* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GitgStageStatusSubmodule*) base;
	_tmp0_ = self->priv->d_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
gitg_stage_status_submodule_real_get_is_staged (GitgStageStatusItem* base)
{
	gboolean result;
	GitgStageStatusSubmodule* self;
	self = (GitgStageStatusSubmodule*) base;
	result = (self->priv->d_flags & gitg_stage_status_submodule_s_index_flags) != 0;
	return result;
}

static gboolean
gitg_stage_status_submodule_real_get_is_unstaged (GitgStageStatusItem* base)
{
	gboolean result;
	GitgStageStatusSubmodule* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (GitgStageStatusSubmodule*) base;
	_tmp1_ = gitg_stage_status_item_get_is_untracked ((GitgStageStatusItem*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = (self->priv->d_flags & gitg_stage_status_submodule_s_work_flags) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
gitg_stage_status_submodule_real_get_is_untracked (GitgStageStatusItem* base)
{
	gboolean result;
	GitgStageStatusSubmodule* self;
	gboolean _tmp0_ = FALSE;
	self = (GitgStageStatusSubmodule*) base;
	if ((self->priv->d_flags & gitg_stage_status_submodule_s_untracked_flags) != 0) {
		_tmp0_ = (self->priv->d_flags & gitg_stage_status_submodule_s_tracked_flags) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
gitg_stage_status_submodule_get_is_dirty (GitgStageStatusSubmodule* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->priv->d_flags & gitg_stage_status_submodule_s_dirty_flags) != 0;
	return result;
}

GgitSubmoduleStatus
gitg_stage_status_submodule_get_flags (GitgStageStatusSubmodule* self)
{
	GgitSubmoduleStatus result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_flags;
	return result;
}

static gchar*
gitg_stage_status_submodule_real_get_icon_name (GitgStageStatusItem* base)
{
	gchar* result;
	GitgStageStatusSubmodule* self;
	gchar* _tmp0_;
	self = (GitgStageStatusSubmodule*) base;
	_tmp0_ = g_strdup ("folder-remote-symbolic");
	result = _tmp0_;
	return result;
}

static void
gitg_stage_status_submodule_class_init (GitgStageStatusSubmoduleClass * klass,
                                        gpointer klass_data)
{
	gitg_stage_status_submodule_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgStageStatusSubmodule_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_stage_status_submodule_get_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_stage_status_submodule_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_SUBMODULE_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_SUBMODULE_PROPERTY] = g_param_spec_boxed ("submodule", "submodule", "submodule", ggit_submodule_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_PATH_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_IS_STAGED_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_IS_STAGED_PROPERTY] = g_param_spec_boolean ("is-staged", "is-staged", "is-staged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_IS_UNSTAGED_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_IS_UNSTAGED_PROPERTY] = g_param_spec_boolean ("is-unstaged", "is-unstaged", "is-unstaged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_IS_UNTRACKED_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_IS_UNTRACKED_PROPERTY] = g_param_spec_boolean ("is-untracked", "is-untracked", "is-untracked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_IS_DIRTY_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_IS_DIRTY_PROPERTY] = g_param_spec_boolean ("is-dirty", "is-dirty", "is-dirty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_FLAGS_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_FLAGS_PROPERTY] = g_param_spec_flags ("flags", "flags", "flags", ggit_submodule_status_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_STAGE_STATUS_SUBMODULE_ICON_NAME_PROPERTY, gitg_stage_status_submodule_properties[GITG_STAGE_STATUS_SUBMODULE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_stage_status_submodule_gitg_stage_status_item_interface_init (GitgStageStatusItemIface * iface,
                                                                   gpointer iface_data)
{
	gitg_stage_status_submodule_gitg_stage_status_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_path = gitg_stage_status_submodule_real_get_path;
	iface->get_is_staged = gitg_stage_status_submodule_real_get_is_staged;
	iface->get_is_unstaged = gitg_stage_status_submodule_real_get_is_unstaged;
	iface->get_is_untracked = gitg_stage_status_submodule_real_get_is_untracked;
	iface->get_icon_name = gitg_stage_status_submodule_real_get_icon_name;
}

static void
gitg_stage_status_submodule_instance_init (GitgStageStatusSubmodule * self,
                                           gpointer klass)
{
	self->priv = gitg_stage_status_submodule_get_instance_private (self);
}

static void
gitg_stage_status_submodule_finalize (GObject * obj)
{
	GitgStageStatusSubmodule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_STAGE_STATUS_SUBMODULE, GitgStageStatusSubmodule);
	_ggit_submodule_unref0 (self->priv->d_submodule);
	_g_free0 (self->priv->d_path);
	G_OBJECT_CLASS (gitg_stage_status_submodule_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_stage_status_submodule_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgStageStatusSubmoduleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_stage_status_submodule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgStageStatusSubmodule), 0, (GInstanceInitFunc) gitg_stage_status_submodule_instance_init, NULL };
	static const GInterfaceInfo gitg_stage_status_item_info = { (GInterfaceInitFunc) gitg_stage_status_submodule_gitg_stage_status_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_stage_status_submodule_type_id;
	gitg_stage_status_submodule_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgStageStatusSubmodule", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_stage_status_submodule_type_id, GITG_TYPE_STAGE_STATUS_ITEM, &gitg_stage_status_item_info);
	GitgStageStatusSubmodule_private_offset = g_type_add_instance_private (gitg_stage_status_submodule_type_id, sizeof (GitgStageStatusSubmodulePrivate));
	return gitg_stage_status_submodule_type_id;
}

GType
gitg_stage_status_submodule_get_type (void)
{
	static gsize gitg_stage_status_submodule_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_status_submodule_type_id__once)) {
		GType gitg_stage_status_submodule_type_id;
		gitg_stage_status_submodule_type_id = gitg_stage_status_submodule_get_type_once ();
		g_once_init_leave (&gitg_stage_status_submodule_type_id__once, gitg_stage_status_submodule_type_id);
	}
	return gitg_stage_status_submodule_type_id__once;
}

static void
_vala_gitg_stage_status_submodule_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GitgStageStatusSubmodule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_STAGE_STATUS_SUBMODULE, GitgStageStatusSubmodule);
	switch (property_id) {
		case GITG_STAGE_STATUS_SUBMODULE_SUBMODULE_PROPERTY:
		g_value_set_boxed (value, gitg_stage_status_submodule_get_submodule (self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_PATH_PROPERTY:
		g_value_take_string (value, gitg_stage_status_item_get_path ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_IS_STAGED_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_item_get_is_staged ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_IS_UNSTAGED_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_item_get_is_unstaged ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_IS_UNTRACKED_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_item_get_is_untracked ((GitgStageStatusItem*) self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_IS_DIRTY_PROPERTY:
		g_value_set_boolean (value, gitg_stage_status_submodule_get_is_dirty (self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_FLAGS_PROPERTY:
		g_value_set_flags (value, gitg_stage_status_submodule_get_flags (self));
		break;
		case GITG_STAGE_STATUS_SUBMODULE_ICON_NAME_PROPERTY:
		g_value_take_string (value, gitg_stage_status_item_get_icon_name ((GitgStageStatusItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gitg_stage_status_enumerator_get_instance_private (GitgStageStatusEnumerator* self)
{
	return G_STRUCT_MEMBER_P (self, GitgStageStatusEnumerator_private_offset);
}

static void
_vala_GgitStatusOptions_free (GgitStatusOptions* self)
{
	g_boxed_free (ggit_status_options_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GgitStatusOptions*
_vala_GgitStatusOptions_copy (GgitStatusOptions* self)
{
	return g_boxed_copy (ggit_status_options_get_type (), self);
}

static gpointer
__vala_GgitStatusOptions_copy0 (gpointer self)
{
	return self ? _vala_GgitStatusOptions_copy (self) : NULL;
}

static gint
___lambda8_ (GitgStageStatusEnumerator* self,
             GMatchInfo* match,
             const gchar* val)
{
	GeeHashSet* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (match != NULL, 0);
	g_return_val_if_fail (val != NULL, 0);
	if (g_strcmp0 (val, "true") != 0) {
		result = 0;
		return result;
	}
	_tmp0_ = self->priv->d_ignored_submodules;
	_tmp1_ = g_match_info_fetch (match, 1);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	result = 0;
	return result;
}

static gint
____lambda8__ggit_config_match_callback (GMatchInfo* match_info,
                                         const gchar* value,
                                         gpointer self)
{
	gint result;
	result = ___lambda8_ ((GitgStageStatusEnumerator*) self, match_info, value);
	return result;
}

static gpointer
_gitg_stage_status_enumerator_run_status_gthread_func (gpointer self)
{
	gpointer result;
	result = gitg_stage_status_enumerator_run_status ((GitgStageStatusEnumerator*) self);
	g_object_unref (self);
	return result;
}

GitgStageStatusEnumerator*
gitg_stage_status_enumerator_construct (GType object_type,
                                        GitgRepository* repository,
                                        GgitStatusOptions* options)
{
	GitgStageStatusEnumerator * self = NULL;
	GitgRepository* _tmp0_;
	GgitStatusOptions* _tmp1_;
	GitgStageStatusItem** _tmp2_;
	GCancellable* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (repository != NULL, NULL);
	self = (GitgStageStatusEnumerator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (repository);
	_g_object_unref0 (self->priv->d_repository);
	self->priv->d_repository = _tmp0_;
	_tmp1_ = __vala_GgitStatusOptions_copy0 (options);
	__vala_GgitStatusOptions_free0 (self->priv->d_options);
	self->priv->d_options = _tmp1_;
	_tmp2_ = g_new0 (GitgStageStatusItem*, 100 + 1);
	self->priv->d_items = (_vala_array_free (self->priv->d_items, self->priv->d_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_items = _tmp2_;
	self->priv->d_items_length1 = 100;
	self->priv->_d_items_size_ = self->priv->d_items_length1;
	self->priv->d_items_length1 = 0;
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->d_cancellable);
	self->priv->d_cancellable = _tmp3_;
	{
		GeeHashSet* _tmp4_;
		GgitConfig* _tmp5_ = NULL;
		GgitConfig* _tmp6_;
		GgitConfig* _tmp7_ = NULL;
		GgitConfig* _tmp8_;
		GRegex* _tmp9_;
		_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->d_ignored_submodules);
		self->priv->d_ignored_submodules = _tmp4_;
		_tmp6_ = ggit_repository_get_config ((GgitRepository*) repository, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = ggit_config_snapshot (_tmp5_, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp9_ = gitg_stage_status_enumerator_s_ignore_regex;
		ggit_config_match_foreach (_tmp7_, _tmp9_, ____lambda8__ggit_config_match_callback, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GThread* _tmp10_ = NULL;
		GThread* _tmp11_;
		GThread* _tmp12_;
		_tmp11_ = g_thread_try_new ("gitg-status-enumerator", _gitg_stage_status_enumerator_run_status_gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_thread_unref0 (self->priv->d_thread);
		self->priv->d_thread = _tmp12_;
		_g_thread_unref0 (_tmp10_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

GitgStageStatusEnumerator*
gitg_stage_status_enumerator_new (GitgRepository* repository,
                                  GgitStatusOptions* options)
{
	return gitg_stage_status_enumerator_construct (GITG_TYPE_STAGE_STATUS_ENUMERATOR, repository, options);
}

void
gitg_stage_status_enumerator_cancel (GitgStageStatusEnumerator* self)
{
	GThread* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GitgStageStatusItem** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->d_items;
		_tmp0__length1 = self->priv->d_items_length1;
		g_rec_mutex_lock (&self->priv->__lock_d_items);
		{
			GCancellable* _tmp1_;
			_tmp1_ = self->priv->d_cancellable;
			if (_tmp1_ != NULL) {
				GCancellable* _tmp2_;
				_tmp2_ = self->priv->d_cancellable;
				g_cancellable_cancel (_tmp2_);
			}
		}
		__finally0:
		{
			GitgStageStatusItem** _tmp3_;
			gint _tmp3__length1;
			_tmp3_ = self->priv->d_items;
			_tmp3__length1 = self->priv->d_items_length1;
			g_rec_mutex_unlock (&self->priv->__lock_d_items);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = self->priv->d_thread;
	if (_tmp4_ != NULL) {
		GThread* _tmp5_;
		_tmp5_ = self->priv->d_thread;
		self->priv->d_thread = NULL;
		g_thread_join (_tmp5_);
		_g_thread_unref0 (self->priv->d_thread);
		self->priv->d_thread = NULL;
	}
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		GitgStageStatusEnumerator* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->submodule_paths);
		(_data31_->add_target_destroy_notify == NULL) ? NULL : (_data31_->add_target_destroy_notify (_data31_->add_target), NULL);
		_data31_->add = NULL;
		_data31_->add_target = NULL;
		_data31_->add_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
_vala_array_add16 (GitgStageStatusItem** * array,
                   gint* length,
                   gint* size,
                   GitgStageStatusItem* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgStageStatusItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda9_ (GitgStageStatusEnumerator* self,
            GitgStageStatusItem* item)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (item != NULL);
	{
		GitgStageStatusItem** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->d_items;
		_tmp0__length1 = self->priv->d_items_length1;
		g_rec_mutex_lock (&self->priv->__lock_d_items);
		{
			GitgStageStatusItem* _tmp1_;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			GSourceFunc _tmp4_;
			gpointer _tmp4__target;
			_tmp1_ = _g_object_ref0 (item);
			_vala_array_add16 (&self->priv->d_items, &self->priv->d_items_length1, &self->priv->_d_items_size_, _tmp1_);
			_tmp4_ = self->priv->d_callback;
			_tmp4__target = self->priv->d_callback_target;
			if (_tmp4_ != NULL) {
				_tmp3_ = self->priv->d_callback_num != -1;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				GitgStageStatusItem** _tmp5_;
				gint _tmp5__length1;
				_tmp5_ = self->priv->d_items;
				_tmp5__length1 = self->priv->d_items_length1;
				_tmp2_ = _tmp5__length1 >= self->priv->d_callback_num;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				GSourceFunc cb = NULL;
				GSourceFunc _tmp6_;
				gpointer _tmp6__target;
				GDestroyNotify _tmp6__target_destroy_notify;
				gpointer cb_target;
				GDestroyNotify cb_target_destroy_notify;
				GSourceFunc _tmp7_;
				gpointer _tmp7__target;
				GDestroyNotify _tmp7__target_destroy_notify;
				_tmp6_ = self->priv->d_callback;
				_tmp6__target = self->priv->d_callback_target;
				_tmp6__target_destroy_notify = self->priv->d_callback_target_destroy_notify;
				self->priv->d_callback = NULL;
				self->priv->d_callback_target = NULL;
				self->priv->d_callback_target_destroy_notify = NULL;
				cb = _tmp6_;
				cb_target = _tmp6__target;
				cb_target_destroy_notify = _tmp6__target_destroy_notify;
				(self->priv->d_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_callback_target_destroy_notify (self->priv->d_callback_target), NULL);
				self->priv->d_callback = NULL;
				self->priv->d_callback_target = NULL;
				self->priv->d_callback_target_destroy_notify = NULL;
				self->priv->d_callback = NULL;
				self->priv->d_callback_target = NULL;
				self->priv->d_callback_target_destroy_notify = NULL;
				_tmp7_ = cb;
				_tmp7__target = cb_target;
				_tmp7__target_destroy_notify = cb_target_destroy_notify;
				cb = NULL;
				cb_target = NULL;
				cb_target_destroy_notify = NULL;
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp7_, _tmp7__target, _tmp7__target_destroy_notify);
				(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
				cb = NULL;
				cb_target = NULL;
				cb_target_destroy_notify = NULL;
			}
		}
		__finally0:
		{
			GitgStageStatusItem** _tmp8_;
			gint _tmp8__length1;
			_tmp8_ = self->priv->d_items;
			_tmp8__length1 = self->priv->d_items_length1;
			g_rec_mutex_unlock (&self->priv->__lock_d_items);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda9__gitg_stage_status_enumerator_add_item (GitgStageStatusItem* item,
                                                   gpointer self)
{
	__lambda9_ ((GitgStageStatusEnumerator*) self, item);
}

static gint
____lambda10_ (Block31Data* _data31_,
               GgitSubmodule* submodule,
               const gchar* name)
{
	GitgStageStatusEnumerator* self;
	GeeHashSet* _tmp0_;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	gint _tmp10_ = 0;
	GCancellable* _tmp11_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = _data31_->self;
	g_return_val_if_fail (submodule != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = _data31_->submodule_paths;
	_tmp1_ = ggit_submodule_get_path (submodule);
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = self->priv->d_ignored_submodules;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, name)) {
		{
			GgitSubmodule* _tmp3_ = NULL;
			GitgRepository* _tmp4_;
			GgitSubmodule* _tmp5_;
			GitgStageStatusEnumeratorAddItem _tmp6_;
			gpointer _tmp6__target;
			GitgStageStatusSubmodule* _tmp7_;
			GitgStageStatusSubmodule* _tmp8_;
			_tmp4_ = self->priv->d_repository;
			_tmp5_ = ggit_repository_lookup_submodule ((GgitRepository*) _tmp4_, name, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = _data31_->add;
			_tmp6__target = _data31_->add_target;
			_tmp7_ = gitg_stage_status_submodule_new (_tmp3_);
			_tmp8_ = _tmp7_;
			_tmp6_ ((GitgStageStatusItem*) _tmp8_, _tmp6__target);
			_g_object_unref0 (_tmp8_);
			_ggit_submodule_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp9_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
	}
	_tmp11_ = self->priv->d_cancellable;
	if (g_cancellable_is_cancelled (_tmp11_)) {
		_tmp10_ = 1;
	} else {
		_tmp10_ = 0;
	}
	result = _tmp10_;
	return result;
}

static gint
_____lambda10__ggit_submodule_callback (GgitSubmodule* submodule,
                                        const gchar* name,
                                        gpointer self)
{
	gint result;
	result = ____lambda10_ (self, submodule, name);
	return result;
}

static gint
___lambda11_ (Block31Data* _data31_,
              const gchar* path,
              GgitStatusFlags flags)
{
	GitgStageStatusEnumerator* self;
	GeeHashSet* _tmp0_;
	gint _tmp4_ = 0;
	GCancellable* _tmp5_;
	gint result;
	self = _data31_->self;
	g_return_val_if_fail (path != NULL, 0);
	_tmp0_ = _data31_->submodule_paths;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, path)) {
		GitgStageStatusEnumeratorAddItem _tmp1_;
		gpointer _tmp1__target;
		GitgStageStatusFile* _tmp2_;
		GitgStageStatusFile* _tmp3_;
		_tmp1_ = _data31_->add;
		_tmp1__target = _data31_->add_target;
		_tmp2_ = gitg_stage_status_file_new (path, flags);
		_tmp3_ = _tmp2_;
		_tmp1_ ((GitgStageStatusItem*) _tmp3_, _tmp1__target);
		_g_object_unref0 (_tmp3_);
	}
	_tmp5_ = self->priv->d_cancellable;
	if (g_cancellable_is_cancelled (_tmp5_)) {
		_tmp4_ = 1;
	} else {
		_tmp4_ = 0;
	}
	result = _tmp4_;
	return result;
}

static gint
____lambda11__ggit_status_callback (const gchar* path,
                                    GgitStatusFlags status_flags,
                                    gpointer self)
{
	gint result;
	result = ___lambda11_ (self, path, status_flags);
	return result;
}

static void*
gitg_stage_status_enumerator_run_status (GitgStageStatusEnumerator* self)
{
	Block31Data* _data31_;
	GeeHashSet* _tmp0_;
	GitgRepository* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_data31_->add = ___lambda9__gitg_stage_status_enumerator_add_item;
	_data31_->add_target = g_object_ref (self);
	_data31_->add_target_destroy_notify = g_object_unref;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data31_->submodule_paths = _tmp0_;
	_tmp1_ = self->priv->d_repository;
	g_object_get ((GgitRepository*) _tmp1_, "is-bare", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		{
			GitgRepository* _tmp4_;
			_tmp4_ = self->priv->d_repository;
			ggit_repository_submodule_foreach ((GgitRepository*) _tmp4_, _____lambda10__ggit_submodule_callback, _data31_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block31_data_unref (_data31_);
			_data31_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GitgRepository* _tmp5_;
		GgitStatusOptions* _tmp6_;
		_tmp5_ = self->priv->d_repository;
		_tmp6_ = self->priv->d_options;
		ggit_repository_file_status_foreach ((GgitRepository*) _tmp5_, _tmp6_, ____lambda11__ggit_status_callback, _data31_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block31_data_unref (_data31_);
		_data31_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GitgStageStatusItem** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = self->priv->d_items;
		_tmp7__length1 = self->priv->d_items_length1;
		g_rec_mutex_lock (&self->priv->__lock_d_items);
		{
			gboolean _tmp8_ = FALSE;
			GSourceFunc _tmp9_;
			gpointer _tmp9__target;
			_g_object_unref0 (self->priv->d_cancellable);
			self->priv->d_cancellable = NULL;
			_tmp9_ = self->priv->d_callback;
			_tmp9__target = self->priv->d_callback_target;
			if (_tmp9_ != NULL) {
				_tmp8_ = self->priv->d_callback_num == -1;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GSourceFunc cb = NULL;
				GSourceFunc _tmp10_;
				gpointer _tmp10__target;
				GDestroyNotify _tmp10__target_destroy_notify;
				gpointer cb_target;
				GDestroyNotify cb_target_destroy_notify;
				GSourceFunc _tmp11_;
				gpointer _tmp11__target;
				GDestroyNotify _tmp11__target_destroy_notify;
				_tmp10_ = self->priv->d_callback;
				_tmp10__target = self->priv->d_callback_target;
				_tmp10__target_destroy_notify = self->priv->d_callback_target_destroy_notify;
				self->priv->d_callback = NULL;
				self->priv->d_callback_target = NULL;
				self->priv->d_callback_target_destroy_notify = NULL;
				cb = _tmp10_;
				cb_target = _tmp10__target;
				cb_target_destroy_notify = _tmp10__target_destroy_notify;
				(self->priv->d_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_callback_target_destroy_notify (self->priv->d_callback_target), NULL);
				self->priv->d_callback = NULL;
				self->priv->d_callback_target = NULL;
				self->priv->d_callback_target_destroy_notify = NULL;
				self->priv->d_callback = NULL;
				self->priv->d_callback_target = NULL;
				self->priv->d_callback_target_destroy_notify = NULL;
				_tmp11_ = cb;
				_tmp11__target = cb_target;
				_tmp11__target_destroy_notify = cb_target_destroy_notify;
				cb = NULL;
				cb_target = NULL;
				cb_target_destroy_notify = NULL;
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp11_, _tmp11__target, _tmp11__target_destroy_notify);
				(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
				cb = NULL;
				cb_target = NULL;
				cb_target_destroy_notify = NULL;
			}
		}
		__finally2:
		{
			GitgStageStatusItem** _tmp12_;
			gint _tmp12__length1;
			_tmp12_ = self->priv->d_items;
			_tmp12__length1 = self->priv->d_items_length1;
			g_rec_mutex_unlock (&self->priv->__lock_d_items);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block31_data_unref (_data31_);
			_data31_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	block31_data_unref (_data31_);
	_data31_ = NULL;
	return result;
}

static void
_vala_array_add17 (GitgStageStatusItem** * array,
                   gint* length,
                   gint* size,
                   GitgStageStatusItem* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgStageStatusItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GitgStageStatusItem**
gitg_stage_status_enumerator_fill_items (GitgStageStatusEnumerator* self,
                                         gint num,
                                         gint* result_length1)
{
	gint n = 0;
	GitgStageStatusItem** ret = NULL;
	GitgStageStatusItem** _tmp1_;
	gint _tmp1__length1;
	GitgStageStatusItem** _tmp2_;
	gint ret_length1;
	gint _ret_size_;
	GitgStageStatusItem** _tmp9_;
	gint _tmp9__length1;
	GitgStageStatusItem** result;
	g_return_val_if_fail (self != NULL, NULL);
	n = 0;
	if (num == -1) {
		GitgStageStatusItem** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->d_items;
		_tmp0__length1 = self->priv->d_items_length1;
		num = _tmp0__length1 - self->priv->d_offset;
	}
	_tmp1_ = self->priv->d_items;
	_tmp1__length1 = self->priv->d_items_length1;
	_tmp2_ = g_new0 (GitgStageStatusItem*, MIN (num, _tmp1__length1 - self->priv->d_offset) + 1);
	ret = _tmp2_;
	ret_length1 = MIN (num, _tmp1__length1 - self->priv->d_offset);
	_ret_size_ = ret_length1;
	ret_length1 = 0;
	while (TRUE) {
		GitgStageStatusItem** _tmp3_;
		gint _tmp3__length1;
		GitgStageStatusItem** _tmp4_;
		gint _tmp4__length1;
		GitgStageStatusItem* _tmp5_;
		GitgStageStatusItem* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->d_items;
		_tmp3__length1 = self->priv->d_items_length1;
		if (!(self->priv->d_offset < _tmp3__length1)) {
			break;
		}
		if (n == num) {
			break;
		}
		_tmp4_ = self->priv->d_items;
		_tmp4__length1 = self->priv->d_items_length1;
		_tmp5_ = _tmp4_[self->priv->d_offset];
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_vala_array_add17 (&ret, &ret_length1, &_ret_size_, _tmp6_);
		_tmp7_ = self->priv->d_offset;
		self->priv->d_offset = _tmp7_ + 1;
		n = n + 1;
		_tmp8_ = n;
	}
	_tmp9_ = ret;
	_tmp9__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

static void
gitg_stage_status_enumerator_next_items_data_free (gpointer _data)
{
	GitgStageStatusEnumeratorNextItemsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageStatusEnumeratorNextItemsData, _data_);
}

void
gitg_stage_status_enumerator_next_items (GitgStageStatusEnumerator* self,
                                         gint num,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GitgStageStatusEnumeratorNextItemsData* _data_;
	GitgStageStatusEnumerator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgStageStatusEnumeratorNextItemsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_status_enumerator_next_items_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->num = num;
	gitg_stage_status_enumerator_next_items_co (_data_);
}

GitgStageStatusItem**
gitg_stage_status_enumerator_next_items_finish (GitgStageStatusEnumerator* self,
                                                GAsyncResult* _res_,
                                                gint* result_length1)
{
	GitgStageStatusItem** result;
	GitgStageStatusEnumeratorNextItemsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
_gitg_stage_status_enumerator_next_items_co_gsource_func (gpointer self)
{
	gboolean result;
	result = gitg_stage_status_enumerator_next_items_co (self);
	return result;
}

static gboolean
gitg_stage_status_enumerator_next_items_co (GitgStageStatusEnumeratorNextItemsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->callback = _gitg_stage_status_enumerator_next_items_co_gsource_func;
	_data_->callback_target = _data_;
	_data_->callback_target_destroy_notify = NULL;
	_data_->ret_length1 = 0;
	_data_->_ret_size_ = 0;
	{
		_data_->_tmp0_ = _data_->self->priv->d_items;
		_data_->_tmp0__length1 = _data_->self->priv->d_items_length1;
		g_rec_mutex_lock (&_data_->self->priv->__lock_d_items);
		{
			_data_->_tmp1_ = _data_->self->priv->d_cancellable;
			if (_data_->_tmp1_ == NULL) {
				_data_->_tmp2_ = 0;
				_data_->_tmp3_ = gitg_stage_status_enumerator_fill_items (_data_->self, _data_->num, &_data_->_tmp2_);
				_data_->_tmp4_ = _data_->_tmp3_;
				_data_->_tmp4__length1 = _data_->_tmp2_;
				_data_->result_length1 = _data_->_tmp4__length1;
				_data_->result = _data_->_tmp4_;
				{
					_data_->_tmp5_ = _data_->self->priv->d_items;
					_data_->_tmp5__length1 = _data_->self->priv->d_items_length1;
					g_rec_mutex_unlock (&_data_->self->priv->__lock_d_items);
				}
				_data_->ret = (_vala_array_free (_data_->ret, _data_->ret_length1, (GDestroyNotify) g_object_unref), NULL);
				(_data_->callback_target_destroy_notify == NULL) ? NULL : (_data_->callback_target_destroy_notify (_data_->callback_target), NULL);
				_data_->callback = NULL;
				_data_->callback_target = NULL;
				_data_->callback_target_destroy_notify = NULL;
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp6_ = _data_->callback;
				_data_->_tmp6__target = _data_->callback_target;
				_data_->_tmp6__target_destroy_notify = _data_->callback_target_destroy_notify;
				_data_->callback = NULL;
				_data_->callback_target = NULL;
				_data_->callback_target_destroy_notify = NULL;
				(_data_->self->priv->d_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->d_callback_target_destroy_notify (_data_->self->priv->d_callback_target), NULL);
				_data_->self->priv->d_callback = NULL;
				_data_->self->priv->d_callback_target = NULL;
				_data_->self->priv->d_callback_target_destroy_notify = NULL;
				_data_->self->priv->d_callback = _data_->_tmp6_;
				_data_->self->priv->d_callback_target = _data_->_tmp6__target;
				_data_->self->priv->d_callback_target_destroy_notify = _data_->_tmp6__target_destroy_notify;
				_data_->self->priv->d_callback_num = _data_->num;
			}
		}
		__finally0:
		{
			_data_->_tmp7_ = _data_->self->priv->d_items;
			_data_->_tmp7__length1 = _data_->self->priv->d_items_length1;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_d_items);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->ret = (_vala_array_free (_data_->ret, _data_->ret_length1, (GDestroyNotify) g_object_unref), NULL);
			(_data_->callback_target_destroy_notify == NULL) ? NULL : (_data_->callback_target_destroy_notify (_data_->callback_target), NULL);
			_data_->callback = NULL;
			_data_->callback_target = NULL;
			_data_->callback_target_destroy_notify = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	{
		_data_->_tmp8_ = _data_->self->priv->d_items;
		_data_->_tmp8__length1 = _data_->self->priv->d_items_length1;
		g_rec_mutex_lock (&_data_->self->priv->__lock_d_items);
		{
			_data_->_tmp9_ = 0;
			_data_->_tmp10_ = gitg_stage_status_enumerator_fill_items (_data_->self, _data_->num, &_data_->_tmp9_);
			_data_->ret = (_vala_array_free (_data_->ret, _data_->ret_length1, (GDestroyNotify) g_object_unref), NULL);
			_data_->ret = _data_->_tmp10_;
			_data_->ret_length1 = _data_->_tmp9_;
			_data_->_ret_size_ = _data_->ret_length1;
		}
		__finally1:
		{
			_data_->_tmp11_ = _data_->self->priv->d_items;
			_data_->_tmp11__length1 = _data_->self->priv->d_items_length1;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_d_items);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->ret = (_vala_array_free (_data_->ret, _data_->ret_length1, (GDestroyNotify) g_object_unref), NULL);
			(_data_->callback_target_destroy_notify == NULL) ? NULL : (_data_->callback_target_destroy_notify (_data_->callback_target), NULL);
			_data_->callback = NULL;
			_data_->callback_target = NULL;
			_data_->callback_target_destroy_notify = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp12_ = _data_->ret;
	_data_->_tmp12__length1 = _data_->ret_length1;
	if (_data_->_tmp12__length1 != _data_->num) {
		gitg_stage_status_enumerator_cancel (_data_->self);
	}
	_data_->_tmp13_ = _data_->ret;
	_data_->_tmp13__length1 = _data_->ret_length1;
	_data_->result_length1 = _data_->_tmp13__length1;
	_data_->result = _data_->_tmp13_;
	(_data_->callback_target_destroy_notify == NULL) ? NULL : (_data_->callback_target_destroy_notify (_data_->callback_target), NULL);
	_data_->callback = NULL;
	_data_->callback_target = NULL;
	_data_->callback_target_destroy_notify = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_stage_status_enumerator_class_init (GitgStageStatusEnumeratorClass * klass,
                                         gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	gitg_stage_status_enumerator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgStageStatusEnumerator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gitg_stage_status_enumerator_finalize;
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("submodule\\.(.*)\\.gitgignore", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (gitg_stage_status_enumerator_s_ignore_regex);
		gitg_stage_status_enumerator_s_ignore_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("Failed to compile stage status enumerator regex: ", _tmp6_, "\n", NULL);
		_tmp8_ = _tmp7_;
		fprintf (_tmp3_, "%s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
gitg_stage_status_enumerator_instance_init (GitgStageStatusEnumerator * self,
                                            gpointer klass)
{
	self->priv = gitg_stage_status_enumerator_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_d_items);
}

static void
gitg_stage_status_enumerator_finalize (GObject * obj)
{
	GitgStageStatusEnumerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_STAGE_STATUS_ENUMERATOR, GitgStageStatusEnumerator);
	_g_object_unref0 (self->priv->d_repository);
	_g_thread_unref0 (self->priv->d_thread);
	g_rec_mutex_clear (&self->priv->__lock_d_items);
	self->priv->d_items = (_vala_array_free (self->priv->d_items, self->priv->d_items_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_cancellable);
	(self->priv->d_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_callback_target_destroy_notify (self->priv->d_callback_target), NULL);
	self->priv->d_callback = NULL;
	self->priv->d_callback_target = NULL;
	self->priv->d_callback_target_destroy_notify = NULL;
	__vala_GgitStatusOptions_free0 (self->priv->d_options);
	_g_object_unref0 (self->priv->d_ignored_submodules);
	G_OBJECT_CLASS (gitg_stage_status_enumerator_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_stage_status_enumerator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgStageStatusEnumeratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_stage_status_enumerator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgStageStatusEnumerator), 0, (GInstanceInitFunc) gitg_stage_status_enumerator_instance_init, NULL };
	GType gitg_stage_status_enumerator_type_id;
	gitg_stage_status_enumerator_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgStageStatusEnumerator", &g_define_type_info, 0);
	GitgStageStatusEnumerator_private_offset = g_type_add_instance_private (gitg_stage_status_enumerator_type_id, sizeof (GitgStageStatusEnumeratorPrivate));
	return gitg_stage_status_enumerator_type_id;
}

GType
gitg_stage_status_enumerator_get_type (void)
{
	static gsize gitg_stage_status_enumerator_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_status_enumerator_type_id__once)) {
		GType gitg_stage_status_enumerator_type_id;
		gitg_stage_status_enumerator_type_id = gitg_stage_status_enumerator_get_type_once ();
		g_once_init_leave (&gitg_stage_status_enumerator_type_id__once, gitg_stage_status_enumerator_type_id);
	}
	return gitg_stage_status_enumerator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

