/* gitg-commit-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-commit-dialog.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <gspell/gspell.h>
#include <json-glib/json-glib.h>
#include "config.h"
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>

#define GITG_COMMIT_DIALOG_version VERSION
#define GITG_COMMIT_DIALOG_VERSION_PROP "version"
#define GITG_COMMIT_DIALOG_DESCRIPTION_PROP "version"
#define GITG_COMMIT_DIALOG_MESSAGES_PROP "messages"
#define GITG_COMMIT_DIALOG_DATETIME_PROP "datetime"
#define GITG_COMMIT_DIALOG_TEXT_PROP "text"
#define GITG_COMMIT_DIALOG_COMMIT_MESSAGE_FILENAME "commit-messages.json"
#define GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_FILENAME "prepare-commit-msg"
#define GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_COMMIT "commit"
#define GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_MERGE "merge"
#define GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_TEMPLATE "template"
#define GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_SQUASH "squash"
#define GITG_COMMIT_DIALOG_COMMIT_MSG_FILENAME "COMMIT_EDITMSG"
#define GITG_COMMIT_DIALOG_SQUASH_MSG_FILENAME "SQUASH_MSG"
#define GITG_COMMIT_DIALOG_MERGE_MSG_FILENAME "MERGE_MSG"
#define GITG_COMMIT_DIALOG_CONFIG_COMMIT_TEMPLATE "commit.template"
#define GITG_COMMIT_DIALOG_CONFIG_HOOKS_PATH "core.hooksPath"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_COMMIT_TYPE_DIALOG (gitg_commit_dialog_get_type ())
#define GITG_COMMIT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_COMMIT_TYPE_DIALOG, GitgCommitDialog))
#define GITG_COMMIT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_COMMIT_TYPE_DIALOG, GitgCommitDialogClass))
#define GITG_COMMIT_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_COMMIT_TYPE_DIALOG))
#define GITG_COMMIT_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_COMMIT_TYPE_DIALOG))
#define GITG_COMMIT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_COMMIT_TYPE_DIALOG, GitgCommitDialogClass))

typedef struct _GitgCommitDialog GitgCommitDialog;
typedef struct _GitgCommitDialogClass GitgCommitDialogClass;
typedef struct _GitgCommitDialogPrivate GitgCommitDialogPrivate;
enum  {
	GITG_COMMIT_DIALOG_0_PROPERTY,
	GITG_COMMIT_DIALOG_DIFF_PROPERTY,
	GITG_COMMIT_DIALOG_REPOSITORY_PROPERTY,
	GITG_COMMIT_DIALOG_MAX_VISIBLE_STAT_ITEMS_PROPERTY,
	GITG_COMMIT_DIALOG_SOURCE_VIEW_MESSAGE_PROPERTY,
	GITG_COMMIT_DIALOG_PRETTY_MESSAGE_PROPERTY,
	GITG_COMMIT_DIALOG_DEFAULT_MESSAGE_PROPERTY,
	GITG_COMMIT_DIALOG_MESSAGE_PROPERTY,
	GITG_COMMIT_DIALOG_AMEND_PROPERTY,
	GITG_COMMIT_DIALOG_SIGN_OFF_PROPERTY,
	GITG_COMMIT_DIALOG_SIGN_COMMIT_PROPERTY,
	GITG_COMMIT_DIALOG_MAX_NUMBER_COMMIT_MESSAGES_PROPERTY,
	GITG_COMMIT_DIALOG_MAX_NUMBER_DAYS_COMMIT_MESSAGES_PROPERTY,
	GITG_COMMIT_DIALOG_SHOW_MARKUP_PROPERTY,
	GITG_COMMIT_DIALOG_SHOW_RIGHT_MARGIN_PROPERTY,
	GITG_COMMIT_DIALOG_SHOW_SUBJECT_MARGIN_PROPERTY,
	GITG_COMMIT_DIALOG_RIGHT_MARGIN_POSITION_PROPERTY,
	GITG_COMMIT_DIALOG_SUBJECT_MARGIN_POSITION_PROPERTY,
	GITG_COMMIT_DIALOG_AUTHOR_PROPERTY,
	GITG_COMMIT_DIALOG_SPELL_CHECKING_LANGUAGE_PROPERTY,
	GITG_COMMIT_DIALOG_ENABLE_SPELL_CHECKING_PROPERTY,
	GITG_COMMIT_DIALOG_USE_GRAVATAR_PROPERTY,
	GITG_COMMIT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block12Data Block12Data;
#define _ggit_patch_unref0(var) ((var == NULL) ? NULL : (var = (ggit_patch_unref (var), NULL)))
#define _ggit_diff_file_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_file_unref (var), NULL)))
#define _ggit_diff_delta_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_delta_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
typedef struct _GitgCommitDialogGetHeadCommitData GitgCommitDialogGetHeadCommitData;
typedef struct _Block15Data Block15Data;

struct _GitgCommitDialog {
	GtkDialog parent_instance;
	GitgCommitDialogPrivate * priv;
};

struct _GitgCommitDialogClass {
	GtkDialogClass parent_class;
};

struct _GitgCommitDialogPrivate {
	GtkSourceView* d_source_view_message;
	GtkButton* d_button_ok;
	GtkCheckButton* d_check_button_amend;
	GtkCheckButton* d_check_button_sign_off;
	GtkCheckButton* d_check_button_sign_commit;
	GtkImage* d_image_avatar;
	GtkLabel* d_label_user;
	GtkLabel* d_label_date;
	GtkInfoBar* d_infobar;
	GtkRevealer* d_infobar_revealer;
	GtkLabel* d_infobar_primary_label;
	GtkLabel* d_infobar_secondary_label;
	GtkListBox* d_list_box_stats;
	GtkScrolledWindow* d_scrolled_window_stats;
	GtkButton* d_prev_commit_message_button;
	GtkButton* d_next_commit_message_button;
	gboolean d_show_markup;
	gboolean d_show_right_margin;
	gboolean d_show_subject_margin;
	gint d_right_margin_position;
	gint d_subject_margin_position;
	GgitSignature* d_author;
	GCancellable* d_cancel_avatar;
	gboolean d_constructed;
	GSettings* d_message_settings;
	GitgFontManager* d_font_manager;
	GSettings* d_commit_settings;
	gboolean d_enable_spell_checking;
	gchar* d_spell_checking_language;
	GspellChecker* d_spell_checker;
	GgitDiff* d_diff;
	gboolean d_infobar_shown;
	JsonArray* d_message_array;
	gint reverse_pos_messages;
	gchar* saved_commit_message;
	GtkTextTag* d_subject_tag;
	GtkTextTag* d_too_long_tag;
	GitgRepository* _repository;
	gint _max_visible_stat_items;
	GgitSignature* default_author;
	gchar* _default_message;
	gboolean d_amend;
	gboolean _sign_off;
	gboolean _sign_commit;
	gint _max_number_commit_messages;
	gint _max_number_days_commit_messages;
	gboolean d_use_gravatar;
};

struct _Block11Data {
	int _ref_count_;
	GitgCommitDialog* self;
	GitgAvatarCache* ac;
};

struct _Block12Data {
	int _ref_count_;
	GitgCommitDialog* self;
	gint num;
};

struct _Block13Data {
	int _ref_count_;
	GitgCommitDialog* self;
	gchar* source;
};

struct _Block14Data {
	int _ref_count_;
	GitgCommitDialog* self;
	GitgCommit* retval;
	gpointer _async_data_;
};

struct _GitgCommitDialogGetHeadCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgCommitDialog* self;
	GitgCommit* result;
	Block14Data* _data14_;
	GitgCommit* _tmp0_;
	GError* _inner_error0_;
};

struct _Block15Data {
	int _ref_count_;
	GitgCommitDialog* self;
	GFile* file;
};

static gint GitgCommitDialog_private_offset;
static gpointer gitg_commit_dialog_parent_class = NULL;

VALA_EXTERN GType gitg_commit_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgCommitDialog, g_object_unref)
VALA_EXTERN void gitg_commit_dialog_reset_message (GitgCommitDialog* self);
VALA_EXTERN const gchar* gitg_commit_dialog_get_default_message (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_message (GitgCommitDialog* self,
                                     const gchar* value);
VALA_EXTERN void gitg_commit_dialog_update_default_message (GitgCommitDialog* self);
VALA_EXTERN gchar* gitg_commit_dialog_get_message (GitgCommitDialog* self);
static void gitg_commit_dialog_set_default_message (GitgCommitDialog* self,
                                             const gchar* value);
static void gitg_commit_dialog_update_sensitivity (GitgCommitDialog* self);
VALA_EXTERN gchar* gitg_commit_dialog_get_pretty_message (GitgCommitDialog* self);
static GspellLanguage* gitg_commit_dialog_get_spell_language (GitgCommitDialog* self);
static void gitg_commit_dialog_load_author_info (GitgCommitDialog* self);
VALA_EXTERN gboolean gitg_commit_dialog_get_use_gravatar (GitgCommitDialog* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void ___lambda26_ (Block11Data* _data11_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda26__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void gitg_commit_dialog_real_destroy (GtkWidget* base);
static void gitg_commit_dialog_save_commit_message (GitgCommitDialog* self);
VALA_EXTERN gint gitg_commit_dialog_get_max_number_days_commit_messages (GitgCommitDialog* self);
VALA_EXTERN gint gitg_commit_dialog_get_max_number_commit_messages (GitgCommitDialog* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void gitg_commit_dialog_iterate_diff (GitgCommitDialog* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN GgitDiff* gitg_commit_dialog_get_diff (GitgCommitDialog* self);
static void __lambda27_ (Block12Data* _data12_);
static void gitg_commit_dialog_update_min_stat_size (GitgCommitDialog* self,
                                              gint num);
static void ___lambda27__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
VALA_EXTERN gint gitg_commit_dialog_get_max_visible_stat_items (GitgCommitDialog* self);
static gboolean gitg_commit_dialog_on_commit_message_key_press_event (GitgCommitDialog* self,
                                                               GtkWidget* widget,
                                                               GdkEventKey* event);
static void gitg_commit_dialog_on_prev_commit_message_button_clicked (GitgCommitDialog* self);
static void gitg_commit_dialog_on_next_commit_message_button_clicked (GitgCommitDialog* self);
static void gitg_commit_dialog_init_message_area (GitgCommitDialog* self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean _gitg_commit_dialog_on_commit_message_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                           GdkEventKey* event,
                                                                                           gpointer self);
static void __lambda28_ (GitgCommitDialog* self);
static void gitg_commit_dialog_do_highlight (GitgCommitDialog* self);
static void ___lambda28__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static void gitg_commit_dialog_update_highlight (GitgCommitDialog* self);
VALA_EXTERN GitgRepository* gitg_commit_dialog_get_repository (GitgCommitDialog* self);
VALA_EXTERN gchar* gitg_convert_utf8 (const gchar* str,
                          gssize size,
                          const gchar* from_charset);
static void gitg_commit_dialog_get_head_commit (GitgCommitDialog* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static GitgCommit* gitg_commit_dialog_get_head_commit_finish (GitgCommitDialog* self,
                                                       GAsyncResult* _res_);
static void __lambda30_ (Block13Data* _data13_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda30__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar* gitg_commit_dialog_prepare_commit_msg_hook (GitgCommitDialog* self,
                                                   const gchar* commit_msg,
                                                   const gchar* commit_src,
                                                   const gchar* commit_sha);
static void gitg_commit_dialog_get_head_commit_data_free (gpointer _data);
static gboolean gitg_commit_dialog_get_head_commit_co (GitgCommitDialogGetHeadCommitData* _data_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda29_ (Block14Data* _data14_,
                   GError** error);
static void _vala_GgitOId_free (GgitOId* self);
static void ____lambda29__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_commit_dialog_get_head_commit_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void ______lambda31_ (Block15Data* _data15_,
                      GObject* obj,
                      GAsyncResult* res);
static void _______lambda31__gasync_ready_callback (GObject* source_object,
                                             GAsyncResult* res,
                                             gpointer self);
VALA_EXTERN GitgCommitDialog* gitg_commit_dialog_new (GitgRepository* repository,
                                          GgitSignature* author,
                                          GgitDiff* diff);
VALA_EXTERN GitgCommitDialog* gitg_commit_dialog_construct (GType object_type,
                                                GitgRepository* repository,
                                                GgitSignature* author,
                                                GgitDiff* diff);
VALA_EXTERN void gitg_commit_dialog_show_infobar (GitgCommitDialog* self,
                                      const gchar* primary_msg,
                                      const gchar* secondary_msg,
                                      GtkMessageType type);
static JsonArray* gitg_commit_dialog_load_commit_messages (GitgCommitDialog* self);
static void gitg_commit_dialog_load_selected_commit_message (GitgCommitDialog* self);
static void _gitg_commit_dialog_on_next_commit_message_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self);
static void _gitg_commit_dialog_on_prev_commit_message_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self);
VALA_EXTERN void gitg_commit_dialog_set_diff (GitgCommitDialog* self,
                                  GgitDiff* value);
VALA_EXTERN void gitg_commit_dialog_set_repository (GitgCommitDialog* self,
                                        GitgRepository* value);
VALA_EXTERN void gitg_commit_dialog_set_max_visible_stat_items (GitgCommitDialog* self,
                                                    gint value);
VALA_EXTERN GtkSourceView* gitg_commit_dialog_get_source_view_message (GitgCommitDialog* self);
VALA_EXTERN gboolean gitg_commit_dialog_get_amend (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_amend (GitgCommitDialog* self,
                                   gboolean value);
VALA_EXTERN gboolean gitg_commit_dialog_get_sign_off (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_sign_off (GitgCommitDialog* self,
                                      gboolean value);
VALA_EXTERN gboolean gitg_commit_dialog_get_sign_commit (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_sign_commit (GitgCommitDialog* self,
                                         gboolean value);
VALA_EXTERN void gitg_commit_dialog_set_max_number_commit_messages (GitgCommitDialog* self,
                                                        gint value);
VALA_EXTERN void gitg_commit_dialog_set_max_number_days_commit_messages (GitgCommitDialog* self,
                                                             gint value);
VALA_EXTERN gboolean gitg_commit_dialog_get_show_markup (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_show_markup (GitgCommitDialog* self,
                                         gboolean value);
VALA_EXTERN gboolean gitg_commit_dialog_get_show_right_margin (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_show_right_margin (GitgCommitDialog* self,
                                               gboolean value);
VALA_EXTERN gboolean gitg_commit_dialog_get_show_subject_margin (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_show_subject_margin (GitgCommitDialog* self,
                                                 gboolean value);
VALA_EXTERN gint gitg_commit_dialog_get_right_margin_position (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_right_margin_position (GitgCommitDialog* self,
                                                   gint value);
VALA_EXTERN gint gitg_commit_dialog_get_subject_margin_position (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_subject_margin_position (GitgCommitDialog* self,
                                                     gint value);
VALA_EXTERN GgitSignature* gitg_commit_dialog_get_author (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_author (GitgCommitDialog* self,
                                    GgitSignature* value);
VALA_EXTERN const gchar* gitg_commit_dialog_get_spell_checking_language (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_spell_checking_language (GitgCommitDialog* self,
                                                     const gchar* value);
VALA_EXTERN gboolean gitg_commit_dialog_get_enable_spell_checking (GitgCommitDialog* self);
VALA_EXTERN void gitg_commit_dialog_set_enable_spell_checking (GitgCommitDialog* self,
                                                   gboolean value);
VALA_EXTERN void gitg_commit_dialog_set_use_gravatar (GitgCommitDialog* self,
                                          gboolean value);
static GObject * gitg_commit_dialog_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _gitg_commit_dialog___lambda32_ (GitgCommitDialog* self);
static void __gitg_commit_dialog___lambda32__gtk_dialog_response (GtkDialog* _sender,
                                                           gint response_id,
                                                           gpointer self);
static void _gitg_commit_dialog___lambda33_ (GitgCommitDialog* self);
static void __gitg_commit_dialog___lambda33__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                               gpointer self);
static void _gitg_commit_dialog___lambda34_ (GitgCommitDialog* self,
                                      GObject* obj,
                                      GParamSpec* pspec);
static void ___lambda35_ (GitgCommitDialog* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda35__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __gitg_commit_dialog___lambda34__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void gitg_commit_dialog_finalize (GObject * obj);
static GType gitg_commit_dialog_get_type_once (void);
static void _vala_gitg_commit_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gitg_commit_dialog_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
gitg_commit_dialog_get_instance_private (GitgCommitDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCommitDialog_private_offset);
}

void
gitg_commit_dialog_reset_message (GitgCommitDialog* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_default_message;
	gitg_commit_dialog_set_message (self, _tmp0_);
}

void
gitg_commit_dialog_update_default_message (GitgCommitDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_commit_dialog_get_message (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	gitg_commit_dialog_set_default_message (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
gitg_commit_dialog_update_sensitivity (GitgCommitDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->d_infobar_revealer;
	if (!gtk_revealer_get_reveal_child (_tmp1_)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = gitg_commit_dialog_get_pretty_message (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "") != 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, _tmp0_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static GspellLanguage*
gitg_commit_dialog_get_spell_language (GitgCommitDialog* self)
{
	gchar* lang_code = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GspellLanguage* _tmp4_;
	GspellLanguage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_spell_checking_language;
	_tmp1_ = g_strdup (_tmp0_);
	lang_code = _tmp1_;
	_tmp2_ = lang_code;
	if (string_get (_tmp2_, (glong) 0) == '\0') {
		result = NULL;
		_g_free0 (lang_code);
		return result;
	}
	_tmp3_ = lang_code;
	_tmp4_ = gspell_language_lookup (_tmp3_);
	result = _tmp4_;
	_g_free0 (lang_code);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		GitgCommitDialog* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->ac);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
___lambda26_ (Block11Data* _data11_,
              GObject* obj,
              GAsyncResult* res)
{
	GitgCommitDialog* self;
	GdkPixbuf* pixbuf = NULL;
	GitgAvatarCache* _tmp0_;
	GdkPixbuf* _tmp1_;
	GCancellable* _tmp2_;
	GdkPixbuf* _tmp3_;
	self = _data11_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data11_->ac;
	_tmp1_ = gitg_avatar_cache_load_finish (_tmp0_, res);
	pixbuf = _tmp1_;
	_tmp2_ = self->priv->d_cancel_avatar;
	if (g_cancellable_is_cancelled (_tmp2_)) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp3_ = pixbuf;
	if (_tmp3_ != NULL) {
		GtkImage* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = self->priv->d_image_avatar;
		_tmp5_ = pixbuf;
		gtk_image_set_from_pixbuf (_tmp4_, _tmp5_);
	} else {
		GtkImage* _tmp6_;
		_tmp6_ = self->priv->d_image_avatar;
		gtk_image_set_from_icon_name (_tmp6_, "avatar-default-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	}
	_g_object_unref0 (pixbuf);
}

static void
____lambda26__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda26_ (self, source_object, res);
	block11_data_unref (self);
}

static void
gitg_commit_dialog_load_author_info (GitgCommitDialog* self)
{
	GCancellable* _tmp0_;
	gchar* name = NULL;
	GgitSignature* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* email = NULL;
	GgitSignature* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* s = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GtkLabel* _tmp14_;
	const gchar* _tmp15_;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp16_;
	const gchar* _tmp17_;
	GDateTime* t = NULL;
	GgitSignature* _tmp20_;
	GDateTime* _tmp21_;
	GDateTime* now = NULL;
	GDateTime* _tmp22_;
	gchar* date_string = NULL;
	GDateTime* _tmp23_;
	GDateTime* _tmp24_;
	GtkLabel* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_cancel_avatar;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->d_cancel_avatar;
		g_cancellable_cancel (_tmp1_);
		_tmp2_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->d_cancel_avatar);
		self->priv->d_cancel_avatar = _tmp2_;
	}
	_tmp3_ = self->priv->d_author;
	_tmp4_ = ggit_signature_get_name (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	name = _tmp5_;
	_tmp6_ = self->priv->d_author;
	_tmp7_ = ggit_signature_get_email (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	email = _tmp8_;
	_tmp9_ = name;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = email;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = g_strconcat (_tmp10_, " <", _tmp12_, ">", NULL);
	s = _tmp13_;
	_tmp14_ = self->priv->d_label_user;
	_tmp15_ = s;
	gtk_label_set_label (_tmp14_, _tmp15_);
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) self);
	rtl = (gtk_style_context_get_state (_tmp16_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	_tmp17_ = s;
	if (rtl == (pango_find_base_dir (_tmp17_, -1) != PANGO_DIRECTION_RTL)) {
		GtkLabel* _tmp18_;
		_tmp18_ = self->priv->d_label_user;
		gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_END);
	} else {
		GtkLabel* _tmp19_;
		_tmp19_ = self->priv->d_label_user;
		gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
	}
	_tmp20_ = self->priv->d_author;
	_tmp21_ = ggit_signature_get_time (_tmp20_);
	t = _tmp21_;
	_tmp22_ = g_date_time_new_now_local ();
	now = _tmp22_;
	_tmp23_ = now;
	_tmp24_ = t;
	if (g_date_time_difference (_tmp23_, _tmp24_) < (G_TIME_SPAN_SECOND * 5)) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("");
		_g_free0 (date_string);
		date_string = _tmp25_;
	} else {
		GDateTime* _tmp26_;
		GitgDate* _tmp27_;
		GitgDate* _tmp28_;
		gchar* _tmp29_;
		_tmp26_ = t;
		_tmp27_ = gitg_date_new_for_date_time (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = gitg_date_for_display (_tmp28_);
		_g_free0 (date_string);
		date_string = _tmp29_;
		_g_object_unref0 (_tmp28_);
	}
	_tmp30_ = self->priv->d_label_date;
	_tmp31_ = date_string;
	gtk_label_set_label (_tmp30_, _tmp31_);
	_tmp32_ = date_string;
	if (rtl == (pango_find_base_dir (_tmp32_, -1) != PANGO_DIRECTION_RTL)) {
		GtkLabel* _tmp33_;
		_tmp33_ = self->priv->d_label_date;
		gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_END);
	} else {
		GtkLabel* _tmp34_;
		_tmp34_ = self->priv->d_label_date;
		gtk_widget_set_halign ((GtkWidget*) _tmp34_, GTK_ALIGN_START);
	}
	_tmp35_ = gitg_commit_dialog_get_use_gravatar (self);
	_tmp36_ = _tmp35_;
	if (_tmp36_) {
		Block11Data* _data11_;
		GitgAvatarCache* _tmp37_;
		GCancellable* _tmp38_;
		GitgAvatarCache* _tmp39_;
		GgitSignature* _tmp40_;
		const gchar* _tmp41_;
		GCancellable* _tmp42_;
		_data11_ = g_slice_new0 (Block11Data);
		_data11_->_ref_count_ = 1;
		_data11_->self = g_object_ref (self);
		_tmp37_ = gitg_avatar_cache_default ();
		_data11_->ac = _tmp37_;
		_tmp38_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->d_cancel_avatar);
		self->priv->d_cancel_avatar = _tmp38_;
		_tmp39_ = _data11_->ac;
		_tmp40_ = self->priv->d_author;
		_tmp41_ = ggit_signature_get_email (_tmp40_);
		_tmp42_ = self->priv->d_cancel_avatar;
		gitg_avatar_cache_load (_tmp39_, _tmp41_, 50, _tmp42_, ____lambda26__gasync_ready_callback, block11_data_ref (_data11_));
		block11_data_unref (_data11_);
		_data11_ = NULL;
	} else {
		GtkImage* _tmp43_;
		_tmp43_ = self->priv->d_image_avatar;
		gtk_image_set_from_icon_name (_tmp43_, "avatar-default-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	}
	_g_free0 (date_string);
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (t);
	_g_free0 (s);
	_g_free0 (email);
	_g_free0 (name);
}

static void
gitg_commit_dialog_real_destroy (GtkWidget* base)
{
	GitgCommitDialog * self;
	GCancellable* _tmp0_;
	self = (GitgCommitDialog*) base;
	_tmp0_ = self->priv->d_cancel_avatar;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->d_cancel_avatar;
		g_cancellable_cancel (_tmp1_);
	}
	_g_object_unref0 (self->priv->d_message_settings);
	self->priv->d_message_settings = NULL;
	_g_object_unref0 (self->priv->d_font_manager);
	self->priv->d_font_manager = NULL;
	_g_object_unref0 (self->priv->d_commit_settings);
	self->priv->d_commit_settings = NULL;
	GTK_WIDGET_CLASS (gitg_commit_dialog_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
gitg_commit_dialog_save_commit_message (GitgCommitDialog* self)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp3_;
	JsonBuilder* _tmp4_;
	JsonBuilder* _tmp5_;
	JsonBuilder* _tmp6_;
	JsonBuilder* _tmp7_;
	JsonBuilder* _tmp8_;
	JsonBuilder* _tmp9_;
	JsonBuilder* _tmp10_;
	JsonBuilder* _tmp11_;
	JsonBuilder* _tmp12_;
	JsonBuilder* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	JsonBuilder* _tmp18_;
	JsonBuilder* _tmp19_;
	const gchar* _tmp20_;
	JsonBuilder* _tmp21_;
	GDateTime* max_datetime = NULL;
	GDateTime* _tmp22_;
	GDateTime* _tmp23_;
	gint _tmp24_;
	GDateTime* _tmp25_;
	GDateTime* _tmp26_;
	gint message_counter = 0;
	JsonArray* _tmp27_;
	GList* _tmp28_;
	JsonBuilder* _tmp51_;
	JsonBuilder* _tmp52_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp53_;
	JsonGenerator* _tmp54_;
	JsonNode* root = NULL;
	JsonBuilder* _tmp55_;
	JsonNode* _tmp56_;
	JsonGenerator* _tmp57_;
	JsonNode* _tmp58_;
	gchar* current_contents = NULL;
	JsonGenerator* _tmp59_;
	gchar* _tmp60_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_commit_dialog_get_pretty_message (self);
	_tmp1_ = _tmp0_;
	message = _tmp1_;
	_tmp2_ = message;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		_g_free0 (message);
		return;
	}
	_tmp3_ = json_builder_new ();
	builder = _tmp3_;
	_tmp4_ = builder;
	json_builder_begin_object (_tmp4_);
	_tmp5_ = builder;
	json_builder_set_member_name (_tmp5_, GITG_COMMIT_DIALOG_VERSION_PROP);
	_tmp6_ = builder;
	json_builder_add_string_value (_tmp6_, "1.0");
	_tmp7_ = builder;
	json_builder_set_member_name (_tmp7_, GITG_COMMIT_DIALOG_DESCRIPTION_PROP);
	_tmp8_ = builder;
	json_builder_add_string_value (_tmp8_, "recent commit messages");
	_tmp9_ = builder;
	json_builder_set_member_name (_tmp9_, GITG_COMMIT_DIALOG_MESSAGES_PROP);
	_tmp10_ = builder;
	json_builder_begin_array (_tmp10_);
	_tmp11_ = builder;
	json_builder_begin_object (_tmp11_);
	_tmp12_ = builder;
	json_builder_set_member_name (_tmp12_, GITG_COMMIT_DIALOG_DATETIME_PROP);
	_tmp13_ = builder;
	_tmp14_ = g_date_time_new_now_utc ();
	_tmp15_ = _tmp14_;
	_tmp16_ = g_date_time_to_string (_tmp15_);
	_tmp17_ = _tmp16_;
	json_builder_add_string_value (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_date_time_unref0 (_tmp15_);
	_tmp18_ = builder;
	json_builder_set_member_name (_tmp18_, GITG_COMMIT_DIALOG_TEXT_PROP);
	_tmp19_ = builder;
	_tmp20_ = message;
	json_builder_add_string_value (_tmp19_, _tmp20_);
	_tmp21_ = builder;
	json_builder_end_object (_tmp21_);
	_tmp22_ = g_date_time_new_now_utc ();
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->_max_number_days_commit_messages;
	_tmp25_ = g_date_time_add_days (_tmp23_, -_tmp24_);
	_tmp26_ = _tmp25_;
	_g_date_time_unref0 (_tmp23_);
	max_datetime = _tmp26_;
	message_counter = 1;
	_tmp27_ = self->priv->d_message_array;
	_tmp28_ = json_array_get_elements (_tmp27_);
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp28_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			JsonNode* node = NULL;
			node = (JsonNode*) node_it->data;
			{
				JsonObject* object_node = NULL;
				JsonNode* _tmp29_;
				JsonObject* _tmp30_;
				JsonObject* _tmp31_;
				gint _tmp32_;
				gint _tmp40_;
				gchar* node_message = NULL;
				JsonObject* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				JsonBuilder* _tmp48_;
				JsonNode* _tmp49_;
				JsonNode* _tmp50_;
				_tmp29_ = node;
				_tmp30_ = json_node_get_object (_tmp29_);
				_tmp31_ = _json_object_ref0 (_tmp30_);
				object_node = _tmp31_;
				_tmp32_ = self->priv->_max_number_commit_messages;
				if (_tmp32_ > 0) {
					gchar* datetime_str = NULL;
					JsonObject* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					GDateTime* datetime = NULL;
					const gchar* _tmp36_;
					GDateTime* _tmp37_;
					GDateTime* _tmp38_;
					GDateTime* _tmp39_;
					_tmp33_ = object_node;
					_tmp34_ = json_object_get_string_member (_tmp33_, GITG_COMMIT_DIALOG_DATETIME_PROP);
					_tmp35_ = g_strdup (_tmp34_);
					datetime_str = _tmp35_;
					_tmp36_ = datetime_str;
					_tmp37_ = g_date_time_new_from_iso8601 (_tmp36_, NULL);
					datetime = _tmp37_;
					_tmp38_ = datetime;
					_tmp39_ = max_datetime;
					if (g_date_time_compare (_tmp38_, _tmp39_) < 0) {
						_g_date_time_unref0 (datetime);
						_g_free0 (datetime_str);
						_json_object_unref0 (object_node);
						break;
					}
					_g_date_time_unref0 (datetime);
					_g_free0 (datetime_str);
				}
				_tmp40_ = self->priv->_max_number_commit_messages;
				if (_tmp40_ > 0) {
					gint _tmp41_;
					gint _tmp42_;
					_tmp41_ = self->priv->_max_number_commit_messages;
					if (message_counter == _tmp41_) {
						_json_object_unref0 (object_node);
						break;
					}
					_tmp42_ = message_counter;
					message_counter = _tmp42_ + 1;
				}
				_tmp43_ = object_node;
				_tmp44_ = json_object_get_string_member (_tmp43_, GITG_COMMIT_DIALOG_TEXT_PROP);
				_tmp45_ = g_strdup (_tmp44_);
				node_message = _tmp45_;
				_tmp46_ = message;
				_tmp47_ = node_message;
				if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
					_g_free0 (node_message);
					_json_object_unref0 (object_node);
					continue;
				}
				_tmp48_ = builder;
				_tmp49_ = node;
				_tmp50_ = __vala_JsonNode_copy0 (_tmp49_);
				json_builder_add_value (_tmp48_, _tmp50_);
				_g_free0 (node_message);
				_json_object_unref0 (object_node);
			}
		}
		(node_collection == NULL) ? NULL : (node_collection = (g_list_free (node_collection), NULL));
	}
	_tmp51_ = builder;
	json_builder_end_array (_tmp51_);
	_tmp52_ = builder;
	json_builder_end_object (_tmp52_);
	_tmp53_ = json_generator_new ();
	generator = _tmp53_;
	_tmp54_ = generator;
	json_generator_set_pretty (_tmp54_, TRUE);
	_tmp55_ = builder;
	_tmp56_ = json_builder_get_root (_tmp55_);
	root = _tmp56_;
	_tmp57_ = generator;
	_tmp58_ = root;
	json_generator_set_root (_tmp57_, _tmp58_);
	_tmp59_ = generator;
	_tmp60_ = json_generator_to_data (_tmp59_, NULL);
	current_contents = _tmp60_;
	{
		gchar* dirname = NULL;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		GFile* dir = NULL;
		const gchar* _tmp66_;
		GFile* _tmp67_;
		GFile* _tmp68_;
		GFile* file = NULL;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		GFile* _tmp75_;
		GFile* _tmp76_;
		GFile* _tmp77_;
		const gchar* _tmp78_;
		guint8* _tmp79_;
		gint _tmp79__length1;
		gint _tmp80_ = 0;
		guint8* _tmp81_;
		gint _tmp81__length1;
		_tmp61_ = g_get_user_data_dir ();
		_tmp62_ = g_strconcat (_tmp61_, "/", NULL);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (_tmp63_, APPLICATION_ID, NULL);
		_tmp65_ = _tmp64_;
		_g_free0 (_tmp63_);
		dirname = _tmp65_;
		_tmp66_ = dirname;
		_tmp67_ = g_file_new_for_path (_tmp66_);
		dir = _tmp67_;
		_tmp68_ = dir;
		if (!g_file_query_exists (_tmp68_, NULL)) {
			GFile* _tmp69_;
			_tmp69_ = dir;
			g_file_make_directory_with_parents (_tmp69_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dir);
				_g_free0 (dirname);
				goto __catch0_g_error;
			}
		}
		_tmp70_ = dirname;
		_tmp71_ = g_strconcat (_tmp70_, "/", NULL);
		_tmp72_ = _tmp71_;
		_tmp73_ = g_strconcat (_tmp72_, GITG_COMMIT_DIALOG_COMMIT_MESSAGE_FILENAME, NULL);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_file_new_for_path (_tmp74_);
		_tmp76_ = _tmp75_;
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		file = _tmp76_;
		_tmp77_ = file;
		_tmp78_ = current_contents;
		_tmp79_ = string_get_data (_tmp78_, &_tmp80_);
		_tmp79__length1 = _tmp80_;
		_tmp81_ = _tmp79_;
		_tmp81__length1 = _tmp79__length1;
		g_file_replace_contents (_tmp77_, (const char*) _tmp81_, (gsize) _tmp81__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (dir);
			_g_free0 (dirname);
			goto __catch0_g_error;
		}
		_g_object_unref0 (file);
		_g_object_unref0 (dir);
		_g_free0 (dirname);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp82_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp82_ = err->message;
		g_error ("gitg-commit-dialog.vala:672: %s\n", _tmp82_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (current_contents);
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (generator);
		_g_date_time_unref0 (max_datetime);
		_g_object_unref0 (builder);
		_g_free0 (message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (current_contents);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_date_time_unref0 (max_datetime);
	_g_object_unref0 (builder);
	_g_free0 (message);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		GitgCommitDialog* self;
		self = _data12_->self;
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gpointer
_ggit_diff_file_ref0 (gpointer self)
{
	return self ? ggit_diff_file_ref (self) : NULL;
}

static void
__lambda27_ (Block12Data* _data12_)
{
	GitgCommitDialog* self;
	self = _data12_->self;
	gitg_commit_dialog_update_min_stat_size (self, _data12_->num);
}

static void
___lambda27__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda27_ (self);
}

static void
gitg_commit_dialog_iterate_diff (GitgCommitDialog* self)
{
	Block12Data* _data12_;
	gsize n = 0UL;
	GgitDiff* _tmp0_;
	GgitDiff* _tmp1_;
	GgitDiff* _tmp2_;
	gsize _tmp3_;
	GtkListBox* _tmp45_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = gitg_commit_dialog_get_diff (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = ggit_diff_get_num_deltas (_tmp2_);
	_g_object_unref0 (_tmp2_);
	n = _tmp3_;
	_data12_->num = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GgitPatch* patch = NULL;
				gsize add = 0UL;
				gsize remove = 0UL;
				GgitDiffDelta* delta = NULL;
				GgitPatch* _tmp16_;
				GgitDiffDelta* _tmp17_;
				GgitDiffFile* nf = NULL;
				GgitDiffDelta* _tmp18_;
				GgitDiffFile* _tmp19_;
				GgitDiffFile* _tmp20_;
				gchar* path = NULL;
				GgitDiffFile* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				GtkListBoxRow* row = NULL;
				GtkListBoxRow* _tmp24_;
				GtkGrid* grid = NULL;
				GtkGrid* _tmp25_;
				GtkListBoxRow* _tmp26_;
				GtkGrid* _tmp27_;
				GtkGrid* _tmp28_;
				GitgDiffStat* ds = NULL;
				GitgDiffStat* _tmp29_;
				GitgDiffStat* _tmp30_;
				GtkStyleContext* _tmp31_;
				GitgDiffStat* _tmp32_;
				GitgDiffStat* _tmp33_;
				GtkGrid* _tmp34_;
				GitgDiffStat* _tmp35_;
				GtkLabel* lbl = NULL;
				const gchar* _tmp36_;
				GtkLabel* _tmp37_;
				GtkLabel* _tmp38_;
				GtkGrid* _tmp39_;
				GtkLabel* _tmp40_;
				GtkListBoxRow* _tmp41_;
				GtkListBox* _tmp42_;
				GtkListBoxRow* _tmp43_;
				gint _tmp44_;
				if (!_tmp4_) {
					gint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				if (!(((gsize) i) < n)) {
					break;
				}
				{
					GgitPatch* _tmp6_ = NULL;
					GgitDiff* _tmp7_;
					GgitDiff* _tmp8_;
					GgitDiff* _tmp9_;
					GgitPatch* _tmp10_;
					GgitPatch* _tmp11_;
					GgitPatch* _tmp12_;
					_tmp7_ = gitg_commit_dialog_get_diff (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = _tmp8_;
					_tmp10_ = ggit_patch_new_from_diff (_tmp9_, (gsize) i, &_inner_error0_);
					_tmp11_ = _tmp10_;
					_g_object_unref0 (_tmp9_);
					_tmp6_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp12_ = _tmp6_;
					_tmp6_ = NULL;
					_ggit_patch_unref0 (patch);
					patch = _tmp12_;
					_ggit_patch_unref0 (_tmp6_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
					_ggit_patch_unref0 (patch);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_ggit_patch_unref0 (patch);
					block12_data_unref (_data12_);
					_data12_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				{
					GgitPatch* _tmp13_;
					gsize _tmp14_ = 0UL;
					gsize _tmp15_ = 0UL;
					_tmp13_ = patch;
					ggit_patch_get_line_stats (_tmp13_, NULL, &_tmp14_, &_tmp15_, &_inner_error0_);
					add = _tmp14_;
					remove = _tmp15_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
					_ggit_patch_unref0 (patch);
					continue;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_ggit_patch_unref0 (patch);
					block12_data_unref (_data12_);
					_data12_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp16_ = patch;
				_tmp17_ = ggit_patch_get_delta (_tmp16_);
				delta = _tmp17_;
				_tmp18_ = delta;
				_tmp19_ = ggit_diff_delta_get_new_file (_tmp18_);
				_tmp20_ = _ggit_diff_file_ref0 (_tmp19_);
				nf = _tmp20_;
				_tmp21_ = nf;
				_tmp22_ = ggit_diff_file_get_path (_tmp21_);
				_tmp23_ = g_strdup (_tmp22_);
				path = _tmp23_;
				_tmp24_ = (GtkListBoxRow*) gtk_list_box_row_new ();
				g_object_ref_sink (_tmp24_);
				row = _tmp24_;
				_tmp25_ = (GtkGrid*) gtk_grid_new ();
				g_object_ref_sink (_tmp25_);
				grid = _tmp25_;
				_tmp26_ = row;
				_tmp27_ = grid;
				gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
				_tmp28_ = grid;
				gtk_grid_set_column_spacing (_tmp28_, 6);
				_tmp29_ = gitg_diff_stat_new ();
				g_object_ref_sink (_tmp29_);
				ds = _tmp29_;
				_tmp30_ = ds;
				_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
				gtk_style_context_add_class (_tmp31_, "no-frame");
				_tmp32_ = ds;
				gitg_diff_stat_set_added (_tmp32_, (guint) add);
				_tmp33_ = ds;
				gitg_diff_stat_set_removed (_tmp33_, (guint) remove);
				_tmp34_ = grid;
				_tmp35_ = ds;
				gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 0, 1, 1);
				_tmp36_ = path;
				_tmp37_ = (GtkLabel*) gtk_label_new (_tmp36_);
				g_object_ref_sink (_tmp37_);
				lbl = _tmp37_;
				_tmp38_ = lbl;
				gtk_label_set_selectable (_tmp38_, TRUE);
				_tmp39_ = grid;
				_tmp40_ = lbl;
				gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 1, 0, 1, 1);
				_tmp41_ = row;
				gtk_widget_show_all ((GtkWidget*) _tmp41_);
				_tmp42_ = self->priv->d_list_box_stats;
				_tmp43_ = row;
				gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
				_data12_->num = _data12_->num + 1;
				_tmp44_ = _data12_->num;
				_g_object_unref0 (lbl);
				_g_object_unref0 (ds);
				_g_object_unref0 (grid);
				_g_object_unref0 (row);
				_g_free0 (path);
				_ggit_diff_file_unref0 (nf);
				_ggit_diff_delta_unref0 (delta);
				_ggit_patch_unref0 (patch);
			}
		}
	}
	_tmp45_ = self->priv->d_list_box_stats;
	g_signal_connect_data ((GtkWidget*) _tmp45_, "size-allocate", (GCallback) ___lambda27__gtk_widget_size_allocate, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_commit_dialog_update_min_stat_size (GitgCommitDialog* self,
                                         gint num)
{
	gint n = 0;
	gint _tmp1_;
	GtkListBoxRow* lastrow = NULL;
	GtkListBox* _tmp2_;
	GtkListBoxRow* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkAllocation allocation = {0};
	GtkListBoxRow* _tmp5_;
	GtkAllocation _tmp6_ = {0};
	GtkScrolledWindow* _tmp8_;
	GtkAllocation _tmp9_;
	GtkAllocation _tmp10_;
	g_return_if_fail (self != NULL);
	if (num == 0) {
		GtkScrolledWindow* _tmp0_;
		_tmp0_ = self->priv->d_scrolled_window_stats;
		gtk_widget_hide ((GtkWidget*) _tmp0_);
		return;
	}
	_tmp1_ = self->priv->_max_visible_stat_items;
	n = MIN (num, _tmp1_);
	_tmp2_ = self->priv->d_list_box_stats;
	_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, n - 1);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	lastrow = _tmp4_;
	_tmp5_ = lastrow;
	gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
	allocation = _tmp6_;
	if (n == num) {
		GtkScrolledWindow* _tmp7_;
		_tmp7_ = self->priv->d_scrolled_window_stats;
		gtk_scrolled_window_set_policy (_tmp7_, GTK_POLICY_NEVER, GTK_POLICY_NEVER);
	}
	_tmp8_ = self->priv->d_scrolled_window_stats;
	_tmp9_ = allocation;
	_tmp10_ = allocation;
	gtk_scrolled_window_set_min_content_height (_tmp8_, _tmp9_.y + _tmp10_.height);
	_g_object_unref0 (lastrow);
}

static gboolean
gitg_commit_dialog_on_commit_message_key_press_event (GitgCommitDialog* self,
                                                      GtkWidget* widget,
                                                      GdkEventKey* event)
{
	GdkModifierType mmask = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	mmask = gtk_accelerator_get_default_mod_mask ();
	if ((mmask & event->state) == GDK_CONTROL_MASK) {
		gboolean _tmp0_ = FALSE;
		if (event->keyval == GDK_KEY_Return) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = event->keyval == GDK_KEY_KP_Enter;
		}
		if (_tmp0_) {
			GtkButton* _tmp1_;
			_tmp1_ = self->priv->d_button_ok;
			g_signal_emit_by_name (_tmp1_, "activate");
			result = TRUE;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (event->keyval == GDK_KEY_Left) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = event->keyval == GDK_KEY_KP_Left;
			}
			if (_tmp2_) {
				gitg_commit_dialog_on_prev_commit_message_button_clicked (self);
			} else {
				gboolean _tmp3_ = FALSE;
				if (event->keyval == GDK_KEY_Right) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = event->keyval == GDK_KEY_KP_Right;
				}
				if (_tmp3_) {
					gitg_commit_dialog_on_next_commit_message_button_clicked (self);
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		GitgCommitDialog* self;
		self = _data13_->self;
		_g_free0 (_data13_->source);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
_gitg_commit_dialog_on_commit_message_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                  GdkEventKey* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = gitg_commit_dialog_on_commit_message_key_press_event ((GitgCommitDialog*) self, _sender, event);
	return result;
}

static void
__lambda28_ (GitgCommitDialog* self)
{
	gitg_commit_dialog_do_highlight (self);
}

static void
___lambda28__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
	__lambda28_ ((GitgCommitDialog*) self);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda30_ (Block13Data* _data13_,
             GObject* obj,
             GAsyncResult* res)
{
	GitgCommitDialog* self;
	GitgCommit* commit = NULL;
	GitgCommit* _tmp0_;
	gboolean exists_merge_msg = FALSE;
	GitgRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GitgRepository* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	self = _data13_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = gitg_commit_dialog_get_head_commit_finish (self, res);
	commit = _tmp0_;
	_tmp1_ = gitg_commit_dialog_get_repository (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = ggit_repository_get_location ((GgitRepository*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (_tmp5_, GITG_COMMIT_DIALOG_MERGE_MSG_FILENAME);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_query_exists (_tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	exists_merge_msg = _tmp8_;
	if (exists_merge_msg) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		GitgCommit* _tmp11_;
		_tmp11_ = commit;
		if (_tmp11_ != NULL) {
			GitgCommit* _tmp12_;
			GgitCommitParents* _tmp13_;
			GgitCommitParents* _tmp14_;
			_tmp12_ = commit;
			_tmp13_ = ggit_commit_get_parents ((GgitCommit*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = ggit_commit_parents_get_size (_tmp14_) > ((guint) 1);
			_g_object_unref0 (_tmp14_);
		} else {
			_tmp10_ = FALSE;
		}
		_tmp9_ = _tmp10_;
	}
	if (_tmp9_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_MERGE);
		_g_free0 (_data13_->source);
		_data13_->source = _tmp15_;
	}
	_g_object_unref0 (commit);
}

static void
___lambda30__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda30_ (self, source_object, res);
	block13_data_unref (self);
}

static void
gitg_commit_dialog_init_message_area (GitgCommitDialog* self)
{
	Block13Data* _data13_;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* b = NULL;
	GtkSourceView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextTag* _tmp6_;
	GtkTextTag* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextTag* _tmp9_;
	GtkTextTag* _tmp10_;
	GtkTextBuffer* _tmp11_;
	gchar* _tmp12_;
	gboolean exists_squash_msg = FALSE;
	GitgRepository* _tmp49_;
	GitgRepository* _tmp50_;
	GitgRepository* _tmp51_;
	GFile* _tmp52_;
	GFile* _tmp53_;
	GFile* _tmp54_;
	GFile* _tmp55_;
	gboolean _tmp56_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = self->priv->d_source_view_message;
	g_signal_connect_object ((GtkWidget*) _tmp0_, "key-press-event", (GCallback) _gitg_commit_dialog_on_commit_message_key_press_event_gtk_widget_key_press_event, self, 0);
	_tmp1_ = self->priv->d_source_view_message;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	b = _tmp4_;
	_tmp5_ = b;
	_tmp6_ = gtk_text_buffer_create_tag (_tmp5_, "subject", "weight", PANGO_WEIGHT_BOLD, NULL);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->d_subject_tag);
	self->priv->d_subject_tag = _tmp7_;
	_tmp8_ = b;
	_tmp9_ = gtk_text_buffer_create_tag (_tmp8_, "too-long", "background", "#f57900", NULL);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->d_too_long_tag);
	self->priv->d_too_long_tag = _tmp10_;
	_tmp11_ = b;
	g_signal_connect_object (_tmp11_, "changed", (GCallback) ___lambda28__gtk_text_buffer_changed, self, 0);
	gitg_commit_dialog_update_highlight (self);
	gitg_commit_dialog_set_default_message (self, "");
	_tmp12_ = g_strdup ("");
	_data13_->source = _tmp12_;
	{
		GgitConfig* config = NULL;
		GgitConfig* _tmp13_ = NULL;
		GitgRepository* _tmp14_;
		GitgRepository* _tmp15_;
		GitgRepository* _tmp16_;
		GgitConfig* _tmp17_;
		GgitConfig* _tmp18_;
		GgitConfig* _tmp19_ = NULL;
		GgitConfig* _tmp20_;
		GgitConfig* _tmp21_;
		gchar* template_path = NULL;
		GgitConfig* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp14_ = gitg_commit_dialog_get_repository (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = ggit_repository_get_config ((GgitRepository*) _tmp16_, &_inner_error0_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_tmp13_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp20_ = ggit_config_snapshot (_tmp13_, &_inner_error0_);
		_tmp19_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp21_ = _tmp19_;
		_tmp19_ = NULL;
		_g_object_unref0 (config);
		config = _tmp21_;
		_tmp22_ = config;
		_tmp23_ = ggit_config_get_string (_tmp22_, GITG_COMMIT_DIALOG_CONFIG_COMMIT_TEMPLATE, &_inner_error0_);
		_tmp24_ = g_strdup (_tmp23_);
		template_path = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp25_ = template_path;
		if (_tmp25_ != NULL) {
			gchar* path = NULL;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* contents = NULL;
			gsize len = 0UL;
			const gchar* _tmp38_;
			gchar* _tmp39_ = NULL;
			gsize _tmp40_ = 0UL;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp26_ = template_path;
			_tmp27_ = gitg_utils_expand_home_dir (_tmp26_);
			path = _tmp27_;
			_tmp28_ = path;
			if (!g_path_is_absolute (_tmp28_)) {
				GitgRepository* _tmp29_;
				GitgRepository* _tmp30_;
				GitgRepository* _tmp31_;
				GFile* _tmp32_;
				GFile* _tmp33_;
				const gchar* _tmp34_;
				GFile* _tmp35_;
				GFile* _tmp36_;
				gchar* _tmp37_;
				_tmp29_ = gitg_commit_dialog_get_repository (self);
				_tmp30_ = _tmp29_;
				_tmp31_ = _tmp30_;
				_tmp32_ = ggit_repository_get_workdir ((GgitRepository*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = path;
				_tmp35_ = g_file_get_child (_tmp33_, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_file_get_path (_tmp36_);
				_g_free0 (path);
				path = _tmp37_;
				_g_object_unref0 (_tmp36_);
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (_tmp31_);
			}
			_tmp38_ = path;
			g_file_get_contents (_tmp38_, &_tmp39_, &_tmp40_, &_inner_error0_);
			_g_free0 (contents);
			contents = _tmp39_;
			len = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (contents);
				_g_free0 (path);
				_g_free0 (template_path);
				_g_object_unref0 (_tmp19_);
				_g_object_unref0 (_tmp13_);
				_g_object_unref0 (config);
				goto __catch0_g_error;
			}
			_tmp41_ = contents;
			_tmp42_ = gitg_convert_utf8 (_tmp41_, (gssize) len, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = string_strip (_tmp43_);
			_tmp45_ = _tmp44_;
			gitg_commit_dialog_set_default_message (self, _tmp45_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_tmp46_ = g_strdup (GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_TEMPLATE);
			_g_free0 (_data13_->source);
			_data13_->source = _tmp46_;
			_g_free0 (contents);
			_g_free0 (path);
		}
		_g_free0 (template_path);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_warning ("gitg-commit-dialog.vala:828: %s\n", _tmp48_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (b);
		block13_data_unref (_data13_);
		_data13_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp49_ = gitg_commit_dialog_get_repository (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = _tmp50_;
	_tmp52_ = ggit_repository_get_location ((GgitRepository*) _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_file_get_child (_tmp53_, GITG_COMMIT_DIALOG_SQUASH_MSG_FILENAME);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_file_query_exists (_tmp55_, NULL);
	_g_object_unref0 (_tmp55_);
	_g_object_unref0 (_tmp53_);
	_g_object_unref0 (_tmp51_);
	exists_squash_msg = _tmp56_;
	if (exists_squash_msg) {
		gchar* _tmp57_;
		_tmp57_ = g_strdup (GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_SQUASH);
		_g_free0 (_data13_->source);
		_data13_->source = _tmp57_;
	}
	gitg_commit_dialog_get_head_commit (self, ___lambda30__gasync_ready_callback, block13_data_ref (_data13_));
	_tmp58_ = self->priv->_default_message;
	_tmp59_ = _data13_->source;
	_tmp60_ = gitg_commit_dialog_prepare_commit_msg_hook (self, _tmp58_, _tmp59_, "");
	_tmp61_ = _tmp60_;
	gitg_commit_dialog_set_message (self, _tmp61_);
	_g_free0 (_tmp61_);
	_g_object_unref0 (b);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
gitg_commit_dialog_get_head_commit_data_free (gpointer _data)
{
	GitgCommitDialogGetHeadCommitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgCommitDialogGetHeadCommitData, _data_);
}

static void
gitg_commit_dialog_get_head_commit (GitgCommitDialog* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GitgCommitDialogGetHeadCommitData* _data_;
	GitgCommitDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgCommitDialogGetHeadCommitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_commit_dialog_get_head_commit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_commit_dialog_get_head_commit_co (_data_);
}

static GitgCommit*
gitg_commit_dialog_get_head_commit_finish (GitgCommitDialog* self,
                                           GAsyncResult* _res_)
{
	GitgCommit* result;
	GitgCommitDialogGetHeadCommitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		GitgCommitDialog* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->retval);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
___lambda29_ (Block14Data* _data14_,
              GError** error)
{
	GitgCommitDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data14_->self;
	{
		GitgRef* head = NULL;
		GitgRepository* _tmp0_;
		GitgRepository* _tmp1_;
		GitgRepository* _tmp2_;
		GitgRef* _tmp3_;
		GitgRef* _tmp4_;
		GitgCommit* _tmp5_ = NULL;
		GitgRepository* _tmp6_;
		GitgRepository* _tmp7_;
		GitgRepository* _tmp8_;
		GitgRef* _tmp9_;
		GgitOId* _tmp10_;
		GgitOId* _tmp11_;
		gpointer _tmp12_;
		GitgCommit* _tmp13_;
		GitgCommit* _tmp14_;
		_tmp0_ = gitg_commit_dialog_get_repository (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gitg_repository_get_head (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		head = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = gitg_commit_dialog_get_repository (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = head;
		_tmp10_ = ggit_ref_get_target ((GgitRef*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gitg_repository_lookup (_tmp8_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp11_, &_inner_error0_);
		_tmp13_ = (GitgCommit*) _tmp12_;
		__vala_GgitOId_free0 (_tmp11_);
		_g_object_unref0 (_tmp8_);
		_tmp5_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (head);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (_data14_->retval);
		_data14_->retval = _tmp14_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (head);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
____lambda29__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda29_ (self, error);
}

static void
gitg_commit_dialog_get_head_commit_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GitgCommitDialogGetHeadCommitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_commit_dialog_get_head_commit_co (_data_);
}

static gboolean
gitg_commit_dialog_get_head_commit_co (GitgCommitDialogGetHeadCommitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data14_ = g_slice_new0 (Block14Data);
	_data_->_data14_->_ref_count_ = 1;
	_data_->_data14_->self = g_object_ref (_data_->self);
	_data_->_data14_->_async_data_ = _data_;
	_data_->_data14_->retval = NULL;
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda29__gitg_async_thread_func, _data_->_data14_, gitg_commit_dialog_get_head_commit_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block14_data_unref (_data_->_data14_);
		_data_->_data14_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _g_object_ref0 (_data_->_data14_->retval);
	_data_->result = _data_->_tmp0_;
	block14_data_unref (_data_->_data14_);
	_data_->_data14_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		GitgCommitDialog* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->file);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
______lambda31_ (Block15Data* _data15_,
                 GObject* obj,
                 GAsyncResult* res)
{
	GitgCommitDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data15_->self;
	g_return_if_fail (res != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = _data15_->file;
		g_file_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gitg-commit-dialog.vala:942: Error deleting %S file: %s", GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_FILENAME, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_______lambda31__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self)
{
	______lambda31_ (self, source_object, res);
	block15_data_unref (self);
}

static gchar*
gitg_commit_dialog_prepare_commit_msg_hook (GitgCommitDialog* self,
                                            const gchar* commit_msg,
                                            const gchar* commit_src,
                                            const gchar* commit_sha)
{
	Block15Data* _data15_;
	gchar* output = NULL;
	GgitConfig* _tmp0_ = NULL;
	GitgRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GitgRepository* _tmp3_;
	GgitConfig* _tmp4_;
	GgitConfig* _tmp5_;
	GgitConfig* config = NULL;
	GgitConfig* _tmp6_;
	gchar* hooks_path = NULL;
	gchar* hook_name = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GFile* hook_file = NULL;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gchar* filename = NULL;
	gchar* _tmp25_;
	gboolean delete_filename = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (commit_msg != NULL, NULL);
	g_return_val_if_fail (commit_src != NULL, NULL);
	g_return_val_if_fail (commit_sha != NULL, NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	output = NULL;
	_tmp1_ = gitg_commit_dialog_get_repository (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = ggit_repository_get_config ((GgitRepository*) _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp0_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (output);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = ggit_config_snapshot (_tmp0_, &_inner_error0_);
	config = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_tmp0_);
		_g_free0 (output);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	hooks_path = NULL;
	{
		const gchar* _tmp7_ = NULL;
		GgitConfig* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = config;
		_tmp9_ = ggit_config_get_string (_tmp8_, GITG_COMMIT_DIALOG_CONFIG_HOOKS_PATH, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = g_strdup (_tmp7_);
		_g_free0 (hooks_path);
		hooks_path = _tmp10_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GitgRepository* _tmp11_;
		GitgRepository* _tmp12_;
		GitgRepository* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		g_clear_error (&_inner_error0_);
		_tmp11_ = gitg_commit_dialog_get_repository (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = ggit_repository_get_location ((GgitRepository*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s/hooks", _tmp17_);
		_g_free0 (hooks_path);
		hooks_path = _tmp18_;
		_g_free0 (_tmp17_);
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (_tmp13_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (hooks_path);
		_g_object_unref0 (config);
		_g_object_unref0 (_tmp0_);
		_g_free0 (output);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp19_ = hooks_path;
	_tmp20_ = g_strdup_printf ("%s/%s", _tmp19_, GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_FILENAME);
	hook_name = _tmp20_;
	_tmp21_ = hook_name;
	_tmp22_ = g_file_new_for_path (_tmp21_);
	hook_file = _tmp22_;
	_tmp23_ = hook_file;
	if (!g_file_query_exists (_tmp23_, NULL)) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup (commit_msg);
		result = _tmp24_;
		_g_object_unref0 (hook_file);
		_g_free0 (hook_name);
		_g_free0 (hooks_path);
		_g_object_unref0 (config);
		_g_object_unref0 (_tmp0_);
		_g_free0 (output);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return result;
	}
	_data15_->file = NULL;
	_tmp25_ = g_strdup (GITG_COMMIT_DIALOG_COMMIT_MSG_FILENAME);
	filename = _tmp25_;
	delete_filename = FALSE;
	if (g_strcmp0 (commit_src, GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_MERGE) == 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup (GITG_COMMIT_DIALOG_MERGE_MSG_FILENAME);
		_g_free0 (filename);
		filename = _tmp26_;
		delete_filename = TRUE;
	} else {
		if (g_strcmp0 (commit_src, GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_SQUASH) == 0) {
			gchar* _tmp27_;
			_tmp27_ = g_strdup (GITG_COMMIT_DIALOG_SQUASH_MSG_FILENAME);
			_g_free0 (filename);
			filename = _tmp27_;
			delete_filename = TRUE;
		}
	}
	{
		GFileInfo* hook_file_info = NULL;
		GFile* _tmp28_;
		GFileInfo* _tmp29_;
		GFileInfo* _tmp30_;
		_tmp28_ = hook_file;
		_tmp29_ = g_file_query_info (_tmp28_, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		hook_file_info = _tmp29_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp30_ = hook_file_info;
		if (g_file_info_get_attribute_boolean (_tmp30_, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE)) {
			{
				GitgRepository* _tmp31_;
				GitgRepository* _tmp32_;
				GitgRepository* _tmp33_;
				GFile* _tmp34_;
				GFile* _tmp35_;
				const gchar* _tmp36_;
				GFile* _tmp37_;
				GFileIOStream* stream = NULL;
				gchar* command = NULL;
				gchar* _tmp46_;
				gchar* _tmp47_;
				GFile* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* commit_sha_hook_param = NULL;
				gchar* _tmp56_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				GFile* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				const gchar* _tmp68_;
				gchar* _tmp69_;
				const gchar* _tmp70_;
				GFileInputStream* is = NULL;
				GFileIOStream* _tmp71_;
				GInputStream* _tmp72_;
				GInputStream* _tmp73_;
				GFileInputStream* _tmp74_;
				GDataInputStream* dis = NULL;
				GFileInputStream* _tmp75_;
				GDataInputStream* _tmp76_;
				gchar* str = NULL;
				_tmp31_ = gitg_commit_dialog_get_repository (self);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_;
				_tmp34_ = ggit_repository_get_location ((GgitRepository*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = filename;
				_tmp37_ = g_file_get_child (_tmp35_, _tmp36_);
				_g_object_unref0 (_data15_->file);
				_data15_->file = _tmp37_;
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (_tmp33_);
				if (delete_filename) {
					GFileIOStream* _tmp38_ = NULL;
					GFile* _tmp39_;
					GFileIOStream* _tmp40_;
					GFileIOStream* _tmp41_;
					_tmp39_ = _data15_->file;
					_tmp40_ = g_file_create_readwrite (_tmp39_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
					_tmp38_ = _tmp40_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (stream);
						goto __catch2_g_error;
					}
					_tmp41_ = _tmp38_;
					_tmp38_ = NULL;
					_g_object_unref0 (stream);
					stream = _tmp41_;
					_g_object_unref0 (_tmp38_);
				} else {
					GFileIOStream* _tmp42_ = NULL;
					GFile* _tmp43_;
					GFileIOStream* _tmp44_;
					GFileIOStream* _tmp45_;
					_tmp43_ = _data15_->file;
					_tmp44_ = g_file_open_readwrite (_tmp43_, NULL, &_inner_error0_);
					_tmp42_ = _tmp44_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (stream);
						goto __catch2_g_error;
					}
					_tmp45_ = _tmp42_;
					_tmp42_ = NULL;
					_g_object_unref0 (stream);
					stream = _tmp45_;
					_g_object_unref0 (_tmp42_);
				}
				_tmp46_ = g_shell_quote (commit_msg);
				_tmp47_ = _tmp46_;
				_tmp48_ = _data15_->file;
				_tmp49_ = g_file_get_path (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = g_shell_quote (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strdup_printf ("echo %s > %s", _tmp47_, _tmp52_);
				_tmp54_ = _tmp53_;
				_g_free0 (_tmp52_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp47_);
				command = _tmp54_;
				_tmp55_ = command;
				system (_tmp55_);
				_tmp56_ = g_strdup ("");
				commit_sha_hook_param = _tmp56_;
				if (g_strcmp0 (commit_sha, "") == 0) {
					gchar* _tmp57_;
					_tmp57_ = g_shell_quote (commit_sha);
					_g_free0 (commit_sha_hook_param);
					commit_sha_hook_param = _tmp57_;
				}
				_tmp58_ = hook_name;
				_tmp59_ = g_shell_quote (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = _data15_->file;
				_tmp62_ = g_file_get_path (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_shell_quote (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_shell_quote (commit_src);
				_tmp67_ = _tmp66_;
				_tmp68_ = commit_sha_hook_param;
				_tmp69_ = g_strdup_printf ("%s %s %s %s", _tmp60_, _tmp65_, _tmp67_, _tmp68_);
				_g_free0 (command);
				command = _tmp69_;
				_g_free0 (_tmp67_);
				_g_free0 (_tmp65_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp60_);
				_tmp70_ = command;
				system (_tmp70_);
				_tmp71_ = stream;
				_tmp72_ = g_io_stream_get_input_stream ((GIOStream*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, g_file_input_stream_get_type ()) ? ((GFileInputStream*) _tmp73_) : NULL);
				is = _tmp74_;
				_tmp75_ = is;
				_tmp76_ = g_data_input_stream_new ((GInputStream*) _tmp75_);
				dis = _tmp76_;
				{
					while (TRUE) {
						gchar* _tmp77_ = NULL;
						GDataInputStream* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						const gchar* _tmp81_;
						const gchar* _tmp82_;
						_tmp78_ = dis;
						_tmp79_ = g_data_input_stream_read_line (_tmp78_, NULL, NULL, &_inner_error0_);
						_tmp77_ = _tmp79_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch3_g_error;
						}
						_tmp80_ = _tmp77_;
						_tmp77_ = NULL;
						_g_free0 (str);
						str = _tmp80_;
						_tmp81_ = str;
						if (!(_tmp81_ != NULL)) {
							_g_free0 (_tmp77_);
							break;
						}
						_tmp82_ = output;
						if (_tmp82_ != NULL) {
							const gchar* _tmp83_;
							const gchar* _tmp84_;
							gchar* _tmp85_;
							gchar* _tmp86_;
							gchar* _tmp87_;
							_tmp83_ = output;
							_tmp84_ = str;
							_tmp85_ = g_strdup_printf ("\n%s", _tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = g_strconcat (_tmp83_, _tmp86_, NULL);
							_g_free0 (output);
							output = _tmp87_;
							_g_free0 (_tmp86_);
						} else {
							const gchar* _tmp88_;
							gchar* _tmp89_;
							_tmp88_ = str;
							_tmp89_ = g_strdup_printf ("%s", _tmp88_);
							_g_free0 (output);
							output = _tmp89_;
						}
						_g_free0 (_tmp77_);
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* e = NULL;
					GError* _tmp90_;
					const gchar* _tmp91_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp90_ = e;
					_tmp91_ = _tmp90_->message;
					g_warning ("gitg-commit-dialog.vala:932: Error reading %s hook result: %s", GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_FILENAME, _tmp91_);
					_g_error_free0 (e);
				}
				__finally3:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (str);
					_g_object_unref0 (dis);
					_g_object_unref0 (is);
					_g_free0 (commit_sha_hook_param);
					_g_free0 (command);
					_g_object_unref0 (stream);
					goto __catch2_g_error;
				}
				_g_free0 (str);
				_g_object_unref0 (dis);
				_g_object_unref0 (is);
				_g_free0 (commit_sha_hook_param);
				_g_free0 (command);
				_g_object_unref0 (stream);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp92_;
				const gchar* _tmp93_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp92_ = e;
				_tmp93_ = _tmp92_->message;
				g_warning ("gitg-commit-dialog.vala:935: Error executing pre-commit-msg: %s", _tmp93_);
				_g_error_free0 (e);
			}
			__finally2:
			{
				GError* _inner_error1_ = NULL;
				gboolean _tmp94_ = FALSE;
				if (delete_filename) {
					GFile* _tmp95_;
					_tmp95_ = _data15_->file;
					_tmp94_ = _tmp95_ != NULL;
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					GFile* _tmp96_;
					_tmp96_ = _data15_->file;
					g_file_delete_async (_tmp96_, G_PRIORITY_DEFAULT, NULL, _______lambda31__gasync_ready_callback, block15_data_ref (_data15_));
				}
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (hook_file_info);
				goto __catch1_g_error;
			}
		}
		_g_object_unref0 (hook_file_info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp97_;
		const gchar* _tmp98_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp97_ = e;
		_tmp98_ = _tmp97_->message;
		g_warning ("gitg-commit-dialog.vala:949: Error checking %s hook : %s", GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_FILENAME, _tmp98_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (filename);
		_g_object_unref0 (hook_file);
		_g_free0 (hook_name);
		_g_free0 (hooks_path);
		_g_object_unref0 (config);
		_g_object_unref0 (_tmp0_);
		_g_free0 (output);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = output;
	_g_free0 (filename);
	_g_object_unref0 (hook_file);
	_g_free0 (hook_name);
	_g_free0 (hooks_path);
	_g_object_unref0 (config);
	_g_object_unref0 (_tmp0_);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return result;
}

static void
gitg_commit_dialog_update_highlight (GitgCommitDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSourceView* _tmp1_;
	GtkSourceView* _tmp2_;
	g_return_if_fail (self != NULL);
	if (!self->priv->d_constructed) {
		return;
	}
	if (self->priv->d_show_markup) {
		_tmp0_ = self->priv->d_show_right_margin;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp1_ = self->priv->d_source_view_message;
	gtk_source_view_set_show_right_margin (_tmp1_, _tmp0_);
	_tmp2_ = self->priv->d_source_view_message;
	gtk_source_view_set_right_margin_position (_tmp2_, (guint) self->priv->d_right_margin_position);
	gitg_commit_dialog_do_highlight (self);
}

static void
gitg_commit_dialog_do_highlight (GitgCommitDialog* self)
{
	GtkTextBuffer* b = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_;
	GtkTextTag* _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextTag* _tmp12_;
	GtkTextIter _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextIter sstart = {0};
	GtkTextIter send = {0};
	GtkTextIter _tmp15_ = {0};
	GtkTextIter _tmp16_ = {0};
	gboolean _tmp17_;
	GtkTextBuffer* _tmp20_;
	GtkTextTag* _tmp21_;
	GtkTextIter _tmp22_;
	GtkTextIter _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_source_view_message;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	b = _tmp3_;
	_tmp4_ = b;
	gtk_text_buffer_get_bounds (_tmp4_, &_tmp5_, &_tmp6_);
	start = _tmp5_;
	end = _tmp6_;
	_tmp7_ = b;
	_tmp8_ = self->priv->d_subject_tag;
	_tmp9_ = start;
	_tmp10_ = end;
	gtk_text_buffer_remove_tag (_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
	_tmp11_ = b;
	_tmp12_ = self->priv->d_too_long_tag;
	_tmp13_ = start;
	_tmp14_ = end;
	gtk_text_buffer_remove_tag (_tmp11_, _tmp12_, &_tmp13_, &_tmp14_);
	if (!self->priv->d_show_markup) {
		_g_object_unref0 (b);
		return;
	}
	_tmp17_ = gtk_text_iter_forward_search (&start, "\n\n", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp15_, &_tmp16_, NULL);
	sstart = _tmp15_;
	send = _tmp16_;
	if (!_tmp17_) {
		GtkTextIter _tmp18_;
		GtkTextIter _tmp19_;
		_tmp18_ = end;
		sstart = _tmp18_;
		_tmp19_ = end;
		send = _tmp19_;
	}
	_tmp20_ = b;
	_tmp21_ = self->priv->d_subject_tag;
	_tmp22_ = start;
	_tmp23_ = sstart;
	gtk_text_buffer_apply_tag (_tmp20_, _tmp21_, &_tmp22_, &_tmp23_);
	if (self->priv->d_show_subject_margin) {
		GtkTextIter toolong = {0};
		GtkTextIter _tmp24_;
		_tmp24_ = sstart;
		toolong = _tmp24_;
		while (TRUE) {
			gint off = 0;
			off = gtk_text_iter_get_line_offset (&toolong);
			if (off > self->priv->d_subject_margin_position) {
				GtkTextIter border = {0};
				GtkTextIter _tmp25_;
				GtkTextBuffer* _tmp26_;
				GtkTextTag* _tmp27_;
				GtkTextIter _tmp28_;
				GtkTextIter _tmp29_;
				_tmp25_ = toolong;
				border = _tmp25_;
				gtk_text_iter_set_line_offset (&border, self->priv->d_subject_margin_position);
				_tmp26_ = b;
				_tmp27_ = self->priv->d_too_long_tag;
				_tmp28_ = border;
				_tmp29_ = toolong;
				gtk_text_buffer_apply_tag (_tmp26_, _tmp27_, &_tmp28_, &_tmp29_);
			}
			if (gtk_text_iter_get_line (&toolong) == 0) {
				break;
			}
			if (!gtk_text_iter_backward_line (&toolong)) {
				break;
			}
			if (!gtk_text_iter_forward_to_line_end (&toolong)) {
				break;
			}
		}
	}
	if (self->priv->d_show_right_margin) {
		while (TRUE) {
			GtkTextIter _tmp30_;
			_tmp30_ = end;
			if (!(!gtk_text_iter_equal (&send, &_tmp30_))) {
				break;
			}
			if (!gtk_text_iter_ends_line (&send)) {
				gtk_text_iter_forward_to_line_end (&send);
			}
			if (gtk_text_iter_get_line_offset (&send) > self->priv->d_right_margin_position) {
				GtkTextIter lstart = {0};
				GtkTextIter _tmp31_;
				GtkTextBuffer* _tmp32_;
				GtkTextTag* _tmp33_;
				GtkTextIter _tmp34_;
				GtkTextIter _tmp35_;
				_tmp31_ = send;
				lstart = _tmp31_;
				gtk_text_iter_set_line_offset (&lstart, self->priv->d_right_margin_position);
				_tmp32_ = b;
				_tmp33_ = self->priv->d_too_long_tag;
				_tmp34_ = lstart;
				_tmp35_ = send;
				gtk_text_buffer_apply_tag (_tmp32_, _tmp33_, &_tmp34_, &_tmp35_);
			}
			if (!gtk_text_iter_forward_line (&send)) {
				break;
			}
		}
	}
	_g_object_unref0 (b);
}

GitgCommitDialog*
gitg_commit_dialog_construct (GType object_type,
                              GitgRepository* repository,
                              GgitSignature* author,
                              GgitDiff* diff)
{
	GitgCommitDialog * self = NULL;
	g_return_val_if_fail (repository != NULL, NULL);
	g_return_val_if_fail (author != NULL, NULL);
	self = (GitgCommitDialog*) g_object_new (object_type, "repository", repository, "author", author, "diff", diff, "use-header-bar", 1, NULL);
	return self;
}

GitgCommitDialog*
gitg_commit_dialog_new (GitgRepository* repository,
                        GgitSignature* author,
                        GgitDiff* diff)
{
	return gitg_commit_dialog_construct (GITG_COMMIT_TYPE_DIALOG, repository, author, diff);
}

void
gitg_commit_dialog_show_infobar (GitgCommitDialog* self,
                                 const gchar* primary_msg,
                                 const gchar* secondary_msg,
                                 GtkMessageType type)
{
	GtkInfoBar* _tmp0_;
	gchar* primary = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* secondary = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkRevealer* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_msg != NULL);
	g_return_if_fail (secondary_msg != NULL);
	self->priv->d_infobar_shown = TRUE;
	_tmp0_ = self->priv->d_infobar;
	gtk_info_bar_set_message_type (_tmp0_, type);
	_tmp1_ = g_markup_escape_text (primary_msg, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("<b>%s</b>", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	primary = _tmp4_;
	_tmp5_ = g_markup_escape_text (secondary_msg, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("<small>%s</small>", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	secondary = _tmp8_;
	_tmp9_ = self->priv->d_infobar_primary_label;
	gtk_label_set_label (_tmp9_, primary);
	_tmp10_ = self->priv->d_infobar_secondary_label;
	gtk_label_set_label (_tmp10_, secondary);
	_tmp11_ = self->priv->d_infobar_revealer;
	gtk_revealer_set_reveal_child (_tmp11_, TRUE);
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, FALSE);
	_g_free0 (secondary);
	_g_free0 (primary);
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static JsonArray*
gitg_commit_dialog_load_commit_messages (GitgCommitDialog* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	guint8* file_contents = NULL;
	gint file_contents_length1 = 0;
	gint _file_contents_size_ = 0;
	JsonArray* message_array = NULL;
	GError* _inner_error0_ = NULL;
	JsonArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strconcat (_tmp0_, "/", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, APPLICATION_ID, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, GITG_COMMIT_DIALOG_COMMIT_MESSAGE_FILENAME, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	file = _tmp10_;
	{
		GFile* _tmp11_;
		guint8* _tmp12_ = NULL;
		gsize _tmp13_ = 0;
		JsonParser* parser = NULL;
		JsonParser* _tmp14_;
		JsonParser* _tmp15_;
		guint8* _tmp16_;
		gint _tmp16__length1;
		JsonNode* node = NULL;
		JsonParser* _tmp17_;
		JsonNode* _tmp18_;
		JsonNode* _tmp19_;
		JsonObject* root_object_node = NULL;
		JsonNode* _tmp20_;
		JsonObject* _tmp21_;
		JsonObject* _tmp22_;
		JsonObject* _tmp23_;
		JsonNode* _tmp24_;
		JsonArray* _tmp25_;
		JsonArray* _tmp26_;
		_tmp11_ = file;
		g_file_load_contents (_tmp11_, NULL, &_tmp12_, &_tmp13_, NULL, &_inner_error0_);
		file_contents = (g_free (file_contents), NULL);
		file_contents = _tmp12_;
		file_contents_length1 = _tmp13_;
		_file_contents_size_ = file_contents_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = json_parser_new ();
		parser = _tmp14_;
		_tmp15_ = parser;
		_tmp16_ = file_contents;
		_tmp16__length1 = file_contents_length1;
		json_parser_load_from_data (_tmp15_, (const gchar*) _tmp16_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			goto __catch0_g_error;
		}
		_tmp17_ = parser;
		_tmp18_ = json_parser_get_root (_tmp17_);
		_tmp19_ = __vala_JsonNode_copy0 (_tmp18_);
		node = _tmp19_;
		_tmp20_ = node;
		_tmp21_ = json_node_get_object (_tmp20_);
		_tmp22_ = _json_object_ref0 (_tmp21_);
		root_object_node = _tmp22_;
		_tmp23_ = root_object_node;
		_tmp24_ = json_object_get_member (_tmp23_, GITG_COMMIT_DIALOG_MESSAGES_PROP);
		_tmp25_ = json_node_get_array (_tmp24_);
		_tmp26_ = _json_array_ref0 (_tmp25_);
		_json_array_unref0 (message_array);
		message_array = _tmp26_;
		_json_object_unref0 (root_object_node);
		__vala_JsonNode_free0 (node);
		_g_object_unref0 (parser);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		JsonArray* _tmp29_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = err;
		_tmp28_ = _tmp27_->message;
		g_warning ("gitg-commit-dialog.vala:1098: %s\n", _tmp28_);
		_tmp29_ = json_array_new ();
		_json_array_unref0 (message_array);
		message_array = _tmp29_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_json_array_unref0 (message_array);
		file_contents = (g_free (file_contents), NULL);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = message_array;
	file_contents = (g_free (file_contents), NULL);
	_g_object_unref0 (file);
	return result;
}

static void
gitg_commit_dialog_on_next_commit_message_button_clicked (GitgCommitDialog* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->reverse_pos_messages > 0) {
		GtkButton* _tmp0_;
		gint _tmp1_;
		_tmp0_ = self->priv->d_prev_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
		_tmp1_ = self->priv->reverse_pos_messages;
		self->priv->reverse_pos_messages = _tmp1_ - 1;
		if (self->priv->reverse_pos_messages == 0) {
			const gchar* _tmp2_;
			GtkButton* _tmp3_;
			_tmp2_ = self->priv->saved_commit_message;
			gitg_commit_dialog_set_message (self, _tmp2_);
			_tmp3_ = self->priv->d_next_commit_message_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
			return;
		}
	} else {
		GtkButton* _tmp4_;
		GtkButton* _tmp5_;
		_tmp4_ = self->priv->d_next_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		_tmp5_ = self->priv->d_prev_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
		return;
	}
	gitg_commit_dialog_load_selected_commit_message (self);
}

static void
_gitg_commit_dialog_on_next_commit_message_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self)
{
	gitg_commit_dialog_on_next_commit_message_button_clicked ((GitgCommitDialog*) self);
}

static void
gitg_commit_dialog_on_prev_commit_message_button_clicked (GitgCommitDialog* self)
{
	JsonArray* _tmp0_;
	JsonArray* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_message_array;
	if (((guint) self->priv->reverse_pos_messages) < json_array_get_length (_tmp0_)) {
		GtkButton* _tmp3_;
		gint _tmp4_;
		if (self->priv->reverse_pos_messages == 0) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = gitg_commit_dialog_get_message (self);
			_tmp2_ = _tmp1_;
			_g_free0 (self->priv->saved_commit_message);
			self->priv->saved_commit_message = _tmp2_;
		}
		_tmp3_ = self->priv->d_next_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->reverse_pos_messages;
		self->priv->reverse_pos_messages = _tmp4_ + 1;
	} else {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->d_prev_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
		if (self->priv->reverse_pos_messages <= 0) {
			GtkButton* _tmp6_;
			self->priv->reverse_pos_messages = 0;
			_tmp6_ = self->priv->d_next_commit_message_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, TRUE);
		}
		return;
	}
	_tmp7_ = self->priv->d_message_array;
	if (json_array_get_length (_tmp7_) == ((guint) self->priv->reverse_pos_messages)) {
		GtkButton* _tmp8_;
		_tmp8_ = self->priv->d_prev_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	}
	gitg_commit_dialog_load_selected_commit_message (self);
}

static void
_gitg_commit_dialog_on_prev_commit_message_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self)
{
	gitg_commit_dialog_on_prev_commit_message_button_clicked ((GitgCommitDialog*) self);
}

static void
gitg_commit_dialog_load_selected_commit_message (GitgCommitDialog* self)
{
	gint counter = 0;
	JsonArray* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	counter = 0;
	_tmp0_ = self->priv->d_message_array;
	_tmp1_ = json_array_get_elements (_tmp0_);
	{
		GList* node_item_collection = NULL;
		GList* node_item_it = NULL;
		node_item_collection = _tmp1_;
		for (node_item_it = node_item_collection; node_item_it != NULL; node_item_it = node_item_it->next) {
			JsonNode* node_item = NULL;
			node_item = (JsonNode*) node_item_it->data;
			{
				gint _tmp2_;
				JsonObject* object_node = NULL;
				JsonNode* _tmp3_;
				JsonObject* _tmp4_;
				JsonObject* _tmp5_;
				gchar* commit_message = NULL;
				JsonObject* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp2_ = counter;
				counter = _tmp2_ + 1;
				if (counter < self->priv->reverse_pos_messages) {
					continue;
				}
				_tmp3_ = node_item;
				_tmp4_ = json_node_get_object (_tmp3_);
				_tmp5_ = _json_object_ref0 (_tmp4_);
				object_node = _tmp5_;
				_tmp6_ = object_node;
				_tmp7_ = json_object_get_string_member (_tmp6_, GITG_COMMIT_DIALOG_TEXT_PROP);
				_tmp8_ = g_strdup (_tmp7_);
				commit_message = _tmp8_;
				_tmp9_ = commit_message;
				gitg_commit_dialog_set_message (self, _tmp9_);
				_g_free0 (commit_message);
				_json_object_unref0 (object_node);
				break;
			}
		}
		(node_item_collection == NULL) ? NULL : (node_item_collection = (g_list_free (node_item_collection), NULL));
	}
}

GgitDiff*
gitg_commit_dialog_get_diff (GitgCommitDialog* self)
{
	GgitDiff* result;
	GgitDiff* _tmp0_;
	GgitDiff* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_diff;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gitg_commit_dialog_set_diff (GitgCommitDialog* self,
                             GgitDiff* value)
{
	GgitDiff* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_diff);
	self->priv->d_diff = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_DIFF_PROPERTY]);
}

GitgRepository*
gitg_commit_dialog_get_repository (GitgCommitDialog* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	GitgRepository* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_repository;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gitg_commit_dialog_set_repository (GitgCommitDialog* self,
                                   GitgRepository* value)
{
	GitgRepository* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_repository (self);
	if (old_value != value) {
		GitgRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_repository);
		self->priv->_repository = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_REPOSITORY_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

gint
gitg_commit_dialog_get_max_visible_stat_items (GitgCommitDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_visible_stat_items;
	return result;
}

void
gitg_commit_dialog_set_max_visible_stat_items (GitgCommitDialog* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_max_visible_stat_items (self);
	if (old_value != value) {
		self->priv->_max_visible_stat_items = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MAX_VISIBLE_STAT_ITEMS_PROPERTY]);
	}
}

GtkSourceView*
gitg_commit_dialog_get_source_view_message (GitgCommitDialog* self)
{
	GtkSourceView* result;
	GtkSourceView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_source_view_message;
	result = _tmp0_;
	return result;
}

gchar*
gitg_commit_dialog_get_pretty_message (GitgCommitDialog* self)
{
	gchar* result;
	gchar* pretty = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_commit_dialog_get_message (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = ggit_message_prettify (_tmp2_, FALSE, '#');
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	pretty = _tmp4_;
	_tmp5_ = pretty;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		_g_free0 (pretty);
		return result;
	} else {
		result = pretty;
		return result;
	}
}

const gchar*
gitg_commit_dialog_get_default_message (GitgCommitDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_message;
	result = _tmp0_;
	return result;
}

static void
gitg_commit_dialog_set_default_message (GitgCommitDialog* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_default_message (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_default_message);
		self->priv->_default_message = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_DEFAULT_MESSAGE_PROPERTY]);
	}
}

gchar*
gitg_commit_dialog_get_message (GitgCommitDialog* self)
{
	gchar* result;
	GtkTextBuffer* b = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_source_view_message;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	b = _tmp3_;
	gtk_text_buffer_get_bounds (b, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	_tmp6_ = start;
	_tmp7_ = end;
	_tmp8_ = gtk_text_buffer_get_text (b, &_tmp6_, &_tmp7_, FALSE);
	result = _tmp8_;
	_g_object_unref0 (b);
	return result;
}

void
gitg_commit_dialog_set_message (GitgCommitDialog* self,
                                const gchar* value)
{
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_source_view_message;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_set_text (_tmp2_, value, -1);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MESSAGE_PROPERTY]);
}

gboolean
gitg_commit_dialog_get_amend (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_amend;
	return result;
}

void
gitg_commit_dialog_set_amend (GitgCommitDialog* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_amend = value;
	if (value) {
		GtkRevealer* _tmp0_;
		_tmp0_ = self->priv->d_infobar_revealer;
		gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	} else {
		if (self->priv->d_infobar_shown) {
			GtkRevealer* _tmp1_;
			_tmp1_ = self->priv->d_infobar_revealer;
			gtk_revealer_set_reveal_child (_tmp1_, TRUE);
		}
	}
	gitg_commit_dialog_update_sensitivity (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_AMEND_PROPERTY]);
}

gboolean
gitg_commit_dialog_get_sign_off (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sign_off;
	return result;
}

void
gitg_commit_dialog_set_sign_off (GitgCommitDialog* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_sign_off (self);
	if (old_value != value) {
		self->priv->_sign_off = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SIGN_OFF_PROPERTY]);
	}
}

gboolean
gitg_commit_dialog_get_sign_commit (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sign_commit;
	return result;
}

void
gitg_commit_dialog_set_sign_commit (GitgCommitDialog* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_sign_commit (self);
	if (old_value != value) {
		self->priv->_sign_commit = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SIGN_COMMIT_PROPERTY]);
	}
}

gint
gitg_commit_dialog_get_max_number_commit_messages (GitgCommitDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_number_commit_messages;
	return result;
}

void
gitg_commit_dialog_set_max_number_commit_messages (GitgCommitDialog* self,
                                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_max_number_commit_messages (self);
	if (old_value != value) {
		self->priv->_max_number_commit_messages = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MAX_NUMBER_COMMIT_MESSAGES_PROPERTY]);
	}
}

gint
gitg_commit_dialog_get_max_number_days_commit_messages (GitgCommitDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_number_days_commit_messages;
	return result;
}

void
gitg_commit_dialog_set_max_number_days_commit_messages (GitgCommitDialog* self,
                                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_dialog_get_max_number_days_commit_messages (self);
	if (old_value != value) {
		self->priv->_max_number_days_commit_messages = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MAX_NUMBER_DAYS_COMMIT_MESSAGES_PROPERTY]);
	}
}

gboolean
gitg_commit_dialog_get_show_markup (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_show_markup;
	return result;
}

void
gitg_commit_dialog_set_show_markup (GitgCommitDialog* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_show_markup = value;
	gitg_commit_dialog_update_highlight (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SHOW_MARKUP_PROPERTY]);
}

gboolean
gitg_commit_dialog_get_show_right_margin (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_show_right_margin;
	return result;
}

void
gitg_commit_dialog_set_show_right_margin (GitgCommitDialog* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_show_right_margin = value;
	gitg_commit_dialog_update_highlight (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SHOW_RIGHT_MARGIN_PROPERTY]);
}

gboolean
gitg_commit_dialog_get_show_subject_margin (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_show_subject_margin;
	return result;
}

void
gitg_commit_dialog_set_show_subject_margin (GitgCommitDialog* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_show_subject_margin = value;
	gitg_commit_dialog_update_highlight (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SHOW_SUBJECT_MARGIN_PROPERTY]);
}

gint
gitg_commit_dialog_get_right_margin_position (GitgCommitDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_right_margin_position;
	return result;
}

void
gitg_commit_dialog_set_right_margin_position (GitgCommitDialog* self,
                                              gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_right_margin_position = value;
	gitg_commit_dialog_update_highlight (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_RIGHT_MARGIN_POSITION_PROPERTY]);
}

gint
gitg_commit_dialog_get_subject_margin_position (GitgCommitDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_subject_margin_position;
	return result;
}

void
gitg_commit_dialog_set_subject_margin_position (GitgCommitDialog* self,
                                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_subject_margin_position = value;
	gitg_commit_dialog_update_highlight (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SUBJECT_MARGIN_POSITION_PROPERTY]);
}

GgitSignature*
gitg_commit_dialog_get_author (GitgCommitDialog* self)
{
	GgitSignature* result;
	GgitSignature* _tmp0_;
	GgitSignature* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_author;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gitg_commit_dialog_set_author (GitgCommitDialog* self,
                               GgitSignature* value)
{
	GgitSignature* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_author);
	self->priv->d_author = _tmp0_;
	gitg_commit_dialog_load_author_info (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_AUTHOR_PROPERTY]);
}

const gchar*
gitg_commit_dialog_get_spell_checking_language (GitgCommitDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_spell_checking_language;
	result = _tmp0_;
	return result;
}

void
gitg_commit_dialog_set_spell_checking_language (GitgCommitDialog* self,
                                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->d_spell_checking_language);
	self->priv->d_spell_checking_language = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SPELL_CHECKING_LANGUAGE_PROPERTY]);
}

gboolean
gitg_commit_dialog_get_enable_spell_checking (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_enable_spell_checking;
	return result;
}

void
gitg_commit_dialog_set_enable_spell_checking (GitgCommitDialog* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_enable_spell_checking = value;
	if (self->priv->d_enable_spell_checking) {
		GspellChecker* _tmp0_;
		_tmp0_ = self->priv->d_spell_checker;
		if (_tmp0_ == NULL) {
			GspellLanguage* _tmp1_;
			GspellChecker* _tmp2_;
			GspellTextBuffer* gspell_buffer = NULL;
			GtkSourceView* _tmp3_;
			GtkTextBuffer* _tmp4_;
			GtkTextBuffer* _tmp5_;
			GspellTextBuffer* _tmp6_;
			GspellTextBuffer* _tmp7_;
			GspellChecker* _tmp8_;
			GspellTextView* gspell_view = NULL;
			GtkSourceView* _tmp9_;
			GspellTextView* _tmp10_;
			GspellTextView* _tmp11_;
			GspellTextView* _tmp12_;
			GspellTextView* _tmp13_;
			_tmp1_ = gitg_commit_dialog_get_spell_language (self);
			_tmp2_ = gspell_checker_new (_tmp1_);
			_g_object_unref0 (self->priv->d_spell_checker);
			self->priv->d_spell_checker = _tmp2_;
			_tmp3_ = self->priv->d_source_view_message;
			_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp5_);
			gspell_buffer = _tmp6_;
			_tmp7_ = gspell_buffer;
			_tmp8_ = self->priv->d_spell_checker;
			gspell_text_buffer_set_spell_checker (_tmp7_, _tmp8_);
			_tmp9_ = self->priv->d_source_view_message;
			_tmp10_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp9_) : NULL);
			_tmp11_ = _g_object_ref0 (_tmp10_);
			gspell_view = _tmp11_;
			_tmp12_ = gspell_view;
			gspell_text_view_set_inline_spell_checking (_tmp12_, TRUE);
			_tmp13_ = gspell_view;
			gspell_text_view_set_enable_language_menu (_tmp13_, TRUE);
			_g_object_unref0 (gspell_view);
		}
	} else {
		GspellChecker* _tmp14_;
		_tmp14_ = self->priv->d_spell_checker;
		if (_tmp14_ != NULL) {
			_g_object_unref0 (self->priv->d_spell_checker);
			self->priv->d_spell_checker = NULL;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_ENABLE_SPELL_CHECKING_PROPERTY]);
}

gboolean
gitg_commit_dialog_get_use_gravatar (GitgCommitDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_use_gravatar;
	return result;
}

void
gitg_commit_dialog_set_use_gravatar (GitgCommitDialog* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_use_gravatar != value) {
		self->priv->d_use_gravatar = value;
		gitg_commit_dialog_load_author_info (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_USE_GRAVATAR_PROPERTY]);
}

static void
_gitg_commit_dialog___lambda32_ (GitgCommitDialog* self)
{
	gitg_commit_dialog_save_commit_message (self);
}

static void
__gitg_commit_dialog___lambda32__gtk_dialog_response (GtkDialog* _sender,
                                                      gint response_id,
                                                      gpointer self)
{
	_gitg_commit_dialog___lambda32_ ((GitgCommitDialog*) self);
}

static void
_gitg_commit_dialog___lambda33_ (GitgCommitDialog* self)
{
	gitg_commit_dialog_update_sensitivity (self);
}

static void
__gitg_commit_dialog___lambda33__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                          gpointer self)
{
	_gitg_commit_dialog___lambda33_ ((GitgCommitDialog*) self);
}

static void
___lambda35_ (GitgCommitDialog* self,
              GObject* obj,
              GAsyncResult* res)
{
	GitgCommit* commit = NULL;
	GitgCommit* _tmp0_;
	GitgCommit* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = gitg_commit_dialog_get_head_commit_finish (self, res);
	commit = _tmp0_;
	_tmp1_ = commit;
	if (_tmp1_ != NULL) {
		GitgCommit* _tmp2_;
		const gchar* _tmp3_;
		GitgCommit* _tmp4_;
		GgitOId* _tmp5_;
		GgitOId* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GitgCommit* _tmp11_;
		GgitSignature* _tmp12_;
		GgitSignature* _tmp13_;
		gitg_commit_dialog_update_default_message (self);
		_tmp2_ = commit;
		_tmp3_ = ggit_commit_get_message ((GgitCommit*) _tmp2_);
		_tmp4_ = commit;
		_tmp5_ = ggit_object_get_id ((GgitObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = ggit_oid_to_string (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gitg_commit_dialog_prepare_commit_msg_hook (self, _tmp3_, GITG_COMMIT_DIALOG_PREPARE_COMMIT_MSG_SOURCE_COMMIT, _tmp8_);
		_tmp10_ = _tmp9_;
		gitg_commit_dialog_set_message (self, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		__vala_GgitOId_free0 (_tmp6_);
		_tmp11_ = commit;
		_tmp12_ = ggit_commit_get_author ((GgitCommit*) _tmp11_);
		_tmp13_ = _tmp12_;
		gitg_commit_dialog_set_author (self, _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	_g_object_unref0 (commit);
}

static void
____lambda35__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda35_ ((GitgCommitDialog*) self, source_object, res);
	g_object_unref (self);
}

static void
_gitg_commit_dialog___lambda34_ (GitgCommitDialog* self,
                                 GObject* obj,
                                 GParamSpec* pspec)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = gitg_commit_dialog_get_amend (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GgitSignature* _tmp2_;
		_tmp2_ = self->priv->default_author;
		gitg_commit_dialog_set_author (self, _tmp2_);
		gitg_commit_dialog_reset_message (self);
	} else {
		gitg_commit_dialog_get_head_commit (self, ____lambda35__gasync_ready_callback, g_object_ref (self));
	}
}

static void
__gitg_commit_dialog___lambda34__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_gitg_commit_dialog___lambda34_ ((GitgCommitDialog*) self, _sender, pspec);
}

static GObject *
gitg_commit_dialog_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgCommitDialog * self;
	GgitSignature* _tmp0_;
	GgitSignature* _tmp1_;
	JsonArray* _tmp2_;
	JsonArray* _tmp3_;
	GtkSourceView* _tmp5_;
	GitgFontManager* _tmp6_;
	GtkTextBuffer* b = NULL;
	GtkSourceView* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkSourceView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkCheckButton* _tmp14_;
	GtkCheckButton* _tmp15_;
	GtkCheckButton* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	GSettings* _tmp24_;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	GSettings* _tmp29_;
	GSettings* interface_settings = NULL;
	GSettings* _tmp30_;
	GSettings* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GgitDiff* _tmp33_;
	GgitDiff* _tmp34_;
	GgitDiff* _tmp35_;
	gboolean _tmp36_;
	parent_class = G_OBJECT_CLASS (gitg_commit_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_COMMIT_TYPE_DIALOG, GitgCommitDialog);
	self->priv->reverse_pos_messages = 0;
	_tmp0_ = gitg_commit_dialog_get_author (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->default_author);
	self->priv->default_author = _tmp1_;
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __gitg_commit_dialog___lambda32__gtk_dialog_response, self, 0);
	_tmp2_ = gitg_commit_dialog_load_commit_messages (self);
	_json_array_unref0 (self->priv->d_message_array);
	self->priv->d_message_array = _tmp2_;
	_tmp3_ = self->priv->d_message_array;
	if (json_array_get_length (_tmp3_) == ((guint) 0)) {
		GtkButton* _tmp4_;
		self->priv->reverse_pos_messages = 0;
		_tmp4_ = self->priv->d_prev_commit_message_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	}
	_tmp5_ = self->priv->d_source_view_message;
	_tmp6_ = gitg_font_manager_new ((GtkTextView*) _tmp5_, FALSE);
	_g_object_unref0 (self->priv->d_font_manager);
	self->priv->d_font_manager = _tmp6_;
	_tmp7_ = self->priv->d_source_view_message;
	_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	b = _tmp10_;
	_tmp11_ = self->priv->d_source_view_message;
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp11_);
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) __gitg_commit_dialog___lambda33__gtk_text_buffer_changed, self, 0);
	_tmp14_ = self->priv->d_check_button_amend;
	g_object_bind_property_with_closures ((GObject*) _tmp14_, "active", (GObject*) self, "amend", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp15_ = self->priv->d_check_button_sign_off;
	g_object_bind_property_with_closures ((GObject*) _tmp15_, "active", (GObject*) self, "sign-off", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = self->priv->d_check_button_sign_commit;
	g_object_bind_property_with_closures ((GObject*) _tmp16_, "active", (GObject*) self, "sign-commit", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp17_ = g_settings_new (APPLICATION_ID ".state.commit");
	_g_object_unref0 (self->priv->d_commit_settings);
	self->priv->d_commit_settings = _tmp17_;
	_tmp18_ = self->priv->d_commit_settings;
	g_settings_bind (_tmp18_, "sign-off", (GObject*) self, "sign-off", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp19_ = self->priv->d_commit_settings;
	g_settings_bind (_tmp19_, "sign-commit", (GObject*) self, "sign-commit", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp20_ = g_settings_new (APPLICATION_ID ".preferences.commit.message");
	_g_object_unref0 (self->priv->d_message_settings);
	self->priv->d_message_settings = _tmp20_;
	_tmp21_ = self->priv->d_message_settings;
	g_settings_bind (_tmp21_, "max-number-days-commit-messages", (GObject*) self, "max-number-days-commit-messages", G_SETTINGS_BIND_GET);
	_tmp22_ = self->priv->d_message_settings;
	g_settings_bind (_tmp22_, "max-number-commit-messages", (GObject*) self, "max-number-commit-messages", G_SETTINGS_BIND_GET);
	_tmp23_ = self->priv->d_message_settings;
	g_settings_bind (_tmp23_, "show-markup", (GObject*) self, "show-markup", G_SETTINGS_BIND_GET);
	_tmp24_ = self->priv->d_message_settings;
	g_settings_bind (_tmp24_, "show-right-margin", (GObject*) self, "show-right-margin", G_SETTINGS_BIND_GET);
	_tmp25_ = self->priv->d_message_settings;
	g_settings_bind (_tmp25_, "right-margin-position", (GObject*) self, "right-margin-position", G_SETTINGS_BIND_GET);
	_tmp26_ = self->priv->d_message_settings;
	g_settings_bind (_tmp26_, "show-subject-margin", (GObject*) self, "show-subject-margin", G_SETTINGS_BIND_GET);
	_tmp27_ = self->priv->d_message_settings;
	g_settings_bind (_tmp27_, "subject-margin-position", (GObject*) self, "subject-margin-position", G_SETTINGS_BIND_GET);
	_tmp28_ = self->priv->d_message_settings;
	g_settings_bind (_tmp28_, "spell-checking-language", (GObject*) self, "spell-checking-language", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp29_ = self->priv->d_message_settings;
	g_settings_bind (_tmp29_, "enable-spell-checking", (GObject*) self, "enable-spell-checking", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp30_ = g_settings_new (APPLICATION_ID ".preferences.interface");
	interface_settings = _tmp30_;
	_tmp31_ = interface_settings;
	g_settings_bind (_tmp31_, "use-gravatar", (GObject*) self, "use-gravatar", G_SETTINGS_BIND_GET);
	self->priv->d_constructed = TRUE;
	gitg_commit_dialog_init_message_area (self);
	_tmp33_ = gitg_commit_dialog_get_diff (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_ != NULL;
	_g_object_unref0 (_tmp35_);
	if (_tmp36_) {
		GgitDiff* _tmp37_;
		GgitDiff* _tmp38_;
		GgitDiff* _tmp39_;
		_tmp37_ = gitg_commit_dialog_get_diff (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_;
		_tmp32_ = ggit_diff_get_num_deltas (_tmp39_) != ((gsize) 0);
		_g_object_unref0 (_tmp39_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gitg_commit_dialog_iterate_diff (self);
	} else {
		gitg_commit_dialog_show_infobar (self, _ ("There are no changes to be committed"), _ ("Use amend to change the commit message of the previous commit"), GTK_MESSAGE_WARNING);
	}
	g_signal_connect_object ((GObject*) self, "notify::amend", (GCallback) __gitg_commit_dialog___lambda34__g_object_notify, self, 0);
	_g_object_unref0 (interface_settings);
	_g_object_unref0 (b);
	return obj;
}

static void
gitg_commit_dialog_class_init (GitgCommitDialogClass * klass,
                               gpointer klass_data)
{
	gitg_commit_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCommitDialog_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) gitg_commit_dialog_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_commit_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_DIFF_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_DIFF_PROPERTY] = g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_REPOSITORY_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_MAX_VISIBLE_STAT_ITEMS_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MAX_VISIBLE_STAT_ITEMS_PROPERTY] = g_param_spec_int ("max-visible-stat-items", "max-visible-stat-items", "max-visible-stat-items", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SOURCE_VIEW_MESSAGE_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SOURCE_VIEW_MESSAGE_PROPERTY] = g_param_spec_object ("source-view-message", "source-view-message", "source-view-message", gtk_source_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_PRETTY_MESSAGE_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_PRETTY_MESSAGE_PROPERTY] = g_param_spec_string ("pretty-message", "pretty-message", "pretty-message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_DEFAULT_MESSAGE_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_DEFAULT_MESSAGE_PROPERTY] = g_param_spec_string ("default-message", "default-message", "default-message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_MESSAGE_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MESSAGE_PROPERTY] = g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_AMEND_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_AMEND_PROPERTY] = g_param_spec_boolean ("amend", "amend", "amend", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SIGN_OFF_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SIGN_OFF_PROPERTY] = g_param_spec_boolean ("sign-off", "sign-off", "sign-off", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SIGN_COMMIT_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SIGN_COMMIT_PROPERTY] = g_param_spec_boolean ("sign-commit", "sign-commit", "sign-commit", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_MAX_NUMBER_COMMIT_MESSAGES_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MAX_NUMBER_COMMIT_MESSAGES_PROPERTY] = g_param_spec_int ("max-number-commit-messages", "max-number-commit-messages", "max-number-commit-messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_MAX_NUMBER_DAYS_COMMIT_MESSAGES_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_MAX_NUMBER_DAYS_COMMIT_MESSAGES_PROPERTY] = g_param_spec_int ("max-number-days-commit-messages", "max-number-days-commit-messages", "max-number-days-commit-messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SHOW_MARKUP_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SHOW_MARKUP_PROPERTY] = g_param_spec_boolean ("show-markup", "show-markup", "show-markup", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SHOW_RIGHT_MARGIN_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SHOW_RIGHT_MARGIN_PROPERTY] = g_param_spec_boolean ("show-right-margin", "show-right-margin", "show-right-margin", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SHOW_SUBJECT_MARGIN_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SHOW_SUBJECT_MARGIN_PROPERTY] = g_param_spec_boolean ("show-subject-margin", "show-subject-margin", "show-subject-margin", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_RIGHT_MARGIN_POSITION_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_RIGHT_MARGIN_POSITION_PROPERTY] = g_param_spec_int ("right-margin-position", "right-margin-position", "right-margin-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SUBJECT_MARGIN_POSITION_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SUBJECT_MARGIN_POSITION_PROPERTY] = g_param_spec_int ("subject-margin-position", "subject-margin-position", "subject-margin-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_AUTHOR_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_AUTHOR_PROPERTY] = g_param_spec_object ("author", "author", "author", ggit_signature_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_SPELL_CHECKING_LANGUAGE_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_SPELL_CHECKING_LANGUAGE_PROPERTY] = g_param_spec_string ("spell-checking-language", "spell-checking-language", "spell-checking-language", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_ENABLE_SPELL_CHECKING_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_ENABLE_SPELL_CHECKING_PROPERTY] = g_param_spec_boolean ("enable-spell-checking", "enable-spell-checking", "enable-spell-checking", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_DIALOG_USE_GRAVATAR_PROPERTY, gitg_commit_dialog_properties[GITG_COMMIT_DIALOG_USE_GRAVATAR_PROPERTY] = g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-commit-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_view_message", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_source_view_message));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ok-button", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_button_ok));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_button_amend", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_check_button_amend));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_button_sign_off", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_check_button_sign_off));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_button_sign_commit", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_check_button_sign_commit));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_avatar", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_image_avatar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_user", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_label_user));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_date", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_label_date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_infobar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_revealer", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_infobar_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_primary_label", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_infobar_primary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_secondary_label", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_infobar_secondary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_box_stats", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_list_box_stats));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolled_window_stats", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_scrolled_window_stats));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "prev_commit_message_button", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_prev_commit_message_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "next_commit_message_button", FALSE, GitgCommitDialog_private_offset + G_STRUCT_OFFSET (GitgCommitDialogPrivate, d_next_commit_message_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_next_commit_message_button_clicked", G_CALLBACK(_gitg_commit_dialog_on_next_commit_message_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_prev_commit_message_button_clicked", G_CALLBACK(_gitg_commit_dialog_on_prev_commit_message_button_clicked_gtk_button_clicked));
}

static void
gitg_commit_dialog_instance_init (GitgCommitDialog * self,
                                  gpointer klass)
{
	self->priv = gitg_commit_dialog_get_instance_private (self);
	self->priv->_max_visible_stat_items = 3;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_commit_dialog_finalize (GObject * obj)
{
	GitgCommitDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_COMMIT_TYPE_DIALOG, GitgCommitDialog);
	_g_object_unref0 (self->priv->d_author);
	_g_object_unref0 (self->priv->d_cancel_avatar);
	_g_object_unref0 (self->priv->d_message_settings);
	_g_object_unref0 (self->priv->d_font_manager);
	_g_object_unref0 (self->priv->d_commit_settings);
	_g_free0 (self->priv->d_spell_checking_language);
	_g_object_unref0 (self->priv->d_spell_checker);
	_g_object_unref0 (self->priv->d_diff);
	_json_array_unref0 (self->priv->d_message_array);
	_g_free0 (self->priv->saved_commit_message);
	_g_object_unref0 (self->priv->d_subject_tag);
	_g_object_unref0 (self->priv->d_too_long_tag);
	_g_object_unref0 (self->priv->_repository);
	_g_object_unref0 (self->priv->default_author);
	_g_free0 (self->priv->_default_message);
	G_OBJECT_CLASS (gitg_commit_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_commit_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCommitDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommitDialog), 0, (GInstanceInitFunc) gitg_commit_dialog_instance_init, NULL };
	GType gitg_commit_dialog_type_id;
	gitg_commit_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GitgCommitDialog", &g_define_type_info, 0);
	GitgCommitDialog_private_offset = g_type_add_instance_private (gitg_commit_dialog_type_id, sizeof (GitgCommitDialogPrivate));
	return gitg_commit_dialog_type_id;
}

GType
gitg_commit_dialog_get_type (void)
{
	static gsize gitg_commit_dialog_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_dialog_type_id__once)) {
		GType gitg_commit_dialog_type_id;
		gitg_commit_dialog_type_id = gitg_commit_dialog_get_type_once ();
		g_once_init_leave (&gitg_commit_dialog_type_id__once, gitg_commit_dialog_type_id);
	}
	return gitg_commit_dialog_type_id__once;
}

static void
_vala_gitg_commit_dialog_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GitgCommitDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_COMMIT_TYPE_DIALOG, GitgCommitDialog);
	switch (property_id) {
		case GITG_COMMIT_DIALOG_DIFF_PROPERTY:
		g_value_take_object (value, gitg_commit_dialog_get_diff (self));
		break;
		case GITG_COMMIT_DIALOG_REPOSITORY_PROPERTY:
		g_value_take_object (value, gitg_commit_dialog_get_repository (self));
		break;
		case GITG_COMMIT_DIALOG_MAX_VISIBLE_STAT_ITEMS_PROPERTY:
		g_value_set_int (value, gitg_commit_dialog_get_max_visible_stat_items (self));
		break;
		case GITG_COMMIT_DIALOG_SOURCE_VIEW_MESSAGE_PROPERTY:
		g_value_set_object (value, gitg_commit_dialog_get_source_view_message (self));
		break;
		case GITG_COMMIT_DIALOG_PRETTY_MESSAGE_PROPERTY:
		g_value_take_string (value, gitg_commit_dialog_get_pretty_message (self));
		break;
		case GITG_COMMIT_DIALOG_DEFAULT_MESSAGE_PROPERTY:
		g_value_set_string (value, gitg_commit_dialog_get_default_message (self));
		break;
		case GITG_COMMIT_DIALOG_MESSAGE_PROPERTY:
		g_value_take_string (value, gitg_commit_dialog_get_message (self));
		break;
		case GITG_COMMIT_DIALOG_AMEND_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_amend (self));
		break;
		case GITG_COMMIT_DIALOG_SIGN_OFF_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_sign_off (self));
		break;
		case GITG_COMMIT_DIALOG_SIGN_COMMIT_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_sign_commit (self));
		break;
		case GITG_COMMIT_DIALOG_MAX_NUMBER_COMMIT_MESSAGES_PROPERTY:
		g_value_set_int (value, gitg_commit_dialog_get_max_number_commit_messages (self));
		break;
		case GITG_COMMIT_DIALOG_MAX_NUMBER_DAYS_COMMIT_MESSAGES_PROPERTY:
		g_value_set_int (value, gitg_commit_dialog_get_max_number_days_commit_messages (self));
		break;
		case GITG_COMMIT_DIALOG_SHOW_MARKUP_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_show_markup (self));
		break;
		case GITG_COMMIT_DIALOG_SHOW_RIGHT_MARGIN_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_show_right_margin (self));
		break;
		case GITG_COMMIT_DIALOG_SHOW_SUBJECT_MARGIN_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_show_subject_margin (self));
		break;
		case GITG_COMMIT_DIALOG_RIGHT_MARGIN_POSITION_PROPERTY:
		g_value_set_int (value, gitg_commit_dialog_get_right_margin_position (self));
		break;
		case GITG_COMMIT_DIALOG_SUBJECT_MARGIN_POSITION_PROPERTY:
		g_value_set_int (value, gitg_commit_dialog_get_subject_margin_position (self));
		break;
		case GITG_COMMIT_DIALOG_AUTHOR_PROPERTY:
		g_value_take_object (value, gitg_commit_dialog_get_author (self));
		break;
		case GITG_COMMIT_DIALOG_SPELL_CHECKING_LANGUAGE_PROPERTY:
		g_value_set_string (value, gitg_commit_dialog_get_spell_checking_language (self));
		break;
		case GITG_COMMIT_DIALOG_ENABLE_SPELL_CHECKING_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_enable_spell_checking (self));
		break;
		case GITG_COMMIT_DIALOG_USE_GRAVATAR_PROPERTY:
		g_value_set_boolean (value, gitg_commit_dialog_get_use_gravatar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_commit_dialog_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GitgCommitDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_COMMIT_TYPE_DIALOG, GitgCommitDialog);
	switch (property_id) {
		case GITG_COMMIT_DIALOG_DIFF_PROPERTY:
		gitg_commit_dialog_set_diff (self, g_value_get_object (value));
		break;
		case GITG_COMMIT_DIALOG_REPOSITORY_PROPERTY:
		gitg_commit_dialog_set_repository (self, g_value_get_object (value));
		break;
		case GITG_COMMIT_DIALOG_MAX_VISIBLE_STAT_ITEMS_PROPERTY:
		gitg_commit_dialog_set_max_visible_stat_items (self, g_value_get_int (value));
		break;
		case GITG_COMMIT_DIALOG_DEFAULT_MESSAGE_PROPERTY:
		gitg_commit_dialog_set_default_message (self, g_value_get_string (value));
		break;
		case GITG_COMMIT_DIALOG_MESSAGE_PROPERTY:
		gitg_commit_dialog_set_message (self, g_value_get_string (value));
		break;
		case GITG_COMMIT_DIALOG_AMEND_PROPERTY:
		gitg_commit_dialog_set_amend (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_SIGN_OFF_PROPERTY:
		gitg_commit_dialog_set_sign_off (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_SIGN_COMMIT_PROPERTY:
		gitg_commit_dialog_set_sign_commit (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_MAX_NUMBER_COMMIT_MESSAGES_PROPERTY:
		gitg_commit_dialog_set_max_number_commit_messages (self, g_value_get_int (value));
		break;
		case GITG_COMMIT_DIALOG_MAX_NUMBER_DAYS_COMMIT_MESSAGES_PROPERTY:
		gitg_commit_dialog_set_max_number_days_commit_messages (self, g_value_get_int (value));
		break;
		case GITG_COMMIT_DIALOG_SHOW_MARKUP_PROPERTY:
		gitg_commit_dialog_set_show_markup (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_SHOW_RIGHT_MARGIN_PROPERTY:
		gitg_commit_dialog_set_show_right_margin (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_SHOW_SUBJECT_MARGIN_PROPERTY:
		gitg_commit_dialog_set_show_subject_margin (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_RIGHT_MARGIN_POSITION_PROPERTY:
		gitg_commit_dialog_set_right_margin_position (self, g_value_get_int (value));
		break;
		case GITG_COMMIT_DIALOG_SUBJECT_MARGIN_POSITION_PROPERTY:
		gitg_commit_dialog_set_subject_margin_position (self, g_value_get_int (value));
		break;
		case GITG_COMMIT_DIALOG_AUTHOR_PROPERTY:
		gitg_commit_dialog_set_author (self, g_value_get_object (value));
		break;
		case GITG_COMMIT_DIALOG_SPELL_CHECKING_LANGUAGE_PROPERTY:
		gitg_commit_dialog_set_spell_checking_language (self, g_value_get_string (value));
		break;
		case GITG_COMMIT_DIALOG_ENABLE_SPELL_CHECKING_PROPERTY:
		gitg_commit_dialog_set_enable_spell_checking (self, g_value_get_boolean (value));
		break;
		case GITG_COMMIT_DIALOG_USE_GRAVATAR_PROPERTY:
		gitg_commit_dialog_set_use_gravatar (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

