/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-pixart-tp-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"





















/**
 * fu_pixart_tp_tf_frame_const_to_string:
 * @val: value, e.g. %FU_PIXART_TP_TF_FRAME_CONST_TAIL
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_pixart_tp_tf_frame_const_to_string(FuPixartTpTfFrameConst val)
{
    if (val == FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE)
        return "preamble";
    if (val == FU_PIXART_TP_TF_FRAME_CONST_TAIL)
        return "tail";
    if (val == FU_PIXART_TP_TF_FRAME_CONST_EXCEPTION_FLAG)
        return "exception-flag";
    return NULL;
}

/**
 * fu_pixart_tp_tf_report_id_to_string:
 * @val: value
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_pixart_tp_tf_report_id_to_string(FuPixartTpTfReportId val)
{
    if (val == FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH)
        return "pass-through";
    return NULL;
}

/**
 * fu_pixart_tp_tf_target_addr_to_string:
 * @val: value
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_pixart_tp_tf_target_addr_to_string(FuPixartTpTfTargetAddr val)
{
    if (val == FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME)
        return "rmi-frame";
    return NULL;
}

/**
 * fu_pixart_tp_tf_rmi_func_to_string:
 * @val: value, e.g. %FU_PIXART_TP_TF_RMI_FUNC_WRITE_PACKET
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_pixart_tp_tf_rmi_func_to_string(FuPixartTpTfRmiFunc val)
{
    if (val == FU_PIXART_TP_TF_RMI_FUNC_WRITE_SIMPLE)
        return "write-simple";
    if (val == FU_PIXART_TP_TF_RMI_FUNC_WRITE_PACKET)
        return "write-packet";
    if (val == FU_PIXART_TP_TF_RMI_FUNC_READ)
        return "read";
    return NULL;
}





/**
 * fu_pixart_tp_update_type_to_string:
 * @val: value, e.g. %FU_PIXART_TP_UPDATE_TYPE_FW_SECTION
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_pixart_tp_update_type_to_string(FuPixartTpUpdateType val)
{
    if (val == FU_PIXART_TP_UPDATE_TYPE_GENERAL)
        return "general";
    if (val == FU_PIXART_TP_UPDATE_TYPE_FW_SECTION)
        return "fw-section";
    if (val == FU_PIXART_TP_UPDATE_TYPE_BOOTLOADER)
        return "bootloader";
    if (val == FU_PIXART_TP_UPDATE_TYPE_PARAM)
        return "param";
    if (val == FU_PIXART_TP_UPDATE_TYPE_TF_FORCE)
        return "tf-force";
    return NULL;
}
/**
 * fu_pixart_tp_update_type_from_string:
 * @val: (nullable): a string, e.g. `fw-section`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuPixartTpUpdateType
fu_pixart_tp_update_type_from_string(const gchar *val)
{
    if (g_strcmp0(val, "general") == 0)
        return FU_PIXART_TP_UPDATE_TYPE_GENERAL;
    if (g_strcmp0(val, "fw-section") == 0)
        return FU_PIXART_TP_UPDATE_TYPE_FW_SECTION;
    if (g_strcmp0(val, "bootloader") == 0)
        return FU_PIXART_TP_UPDATE_TYPE_BOOTLOADER;
    if (g_strcmp0(val, "param") == 0)
        return FU_PIXART_TP_UPDATE_TYPE_PARAM;
    if (g_strcmp0(val, "tf-force") == 0)
        return FU_PIXART_TP_UPDATE_TYPE_TF_FORCE;
    return FU_PIXART_TP_UPDATE_TYPE_GENERAL;
}

/**
 * fu_pixart_tp_firmware_flags_to_string:
 * @val: value, e.g. %FU_PIXART_TP_FIRMWARE_FLAG_VALID
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
gchar *
fu_pixart_tp_firmware_flags_to_string(FuPixartTpFirmwareFlags val)
{
    const gchar *data[3] = {0};
    guint idx = 0;
    if (val == FU_PIXART_TP_FIRMWARE_FLAG_NONE)
        return g_strdup("none");
    if (val & FU_PIXART_TP_FIRMWARE_FLAG_VALID)
        data[idx++] = "valid";
    if (val & FU_PIXART_TP_FIRMWARE_FLAG_IS_EXTERNAL)
        data[idx++] = "is-external";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_pixart_tp_firmware_flags_from_string:
 * @val: (nullable): a string, e.g. `valid`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuPixartTpFirmwareFlags
fu_pixart_tp_firmware_flags_from_string(const gchar *val)
{
    FuPixartTpFirmwareFlags value = 0;
    g_auto(GStrv) split = NULL;
    g_return_val_if_fail(val != NULL, 0);
    split = g_strsplit(val, ",", -1);
    for (guint i = 0; split[i] != NULL; i++) {
        if (g_strcmp0(split[i], "none") == 0) {
            value |= FU_PIXART_TP_FIRMWARE_FLAG_NONE;
            continue;
        }
        if (g_strcmp0(split[i], "valid") == 0) {
            value |= FU_PIXART_TP_FIRMWARE_FLAG_VALID;
            continue;
        }
        if (g_strcmp0(split[i], "is-external") == 0) {
            value |= FU_PIXART_TP_FIRMWARE_FLAG_IS_EXTERNAL;
            continue;
        }
    }
    return value;
}
/**
 * fu_struct_pixart_tp_tf_version_payload_ref: (skip):
 **/
FuStructPixartTpTfVersionPayload *
fu_struct_pixart_tp_tf_version_payload_ref(FuStructPixartTpTfVersionPayload *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_tf_version_payload_unref: (skip):
 **/
void
fu_struct_pixart_tp_tf_version_payload_unref(FuStructPixartTpTfVersionPayload *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpTfVersionPayload refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_tf_version_payload_new_internal: (skip):
 **/
static FuStructPixartTpTfVersionPayload *
fu_struct_pixart_tp_tf_version_payload_new_internal(void)
{
    FuStructPixartTpTfVersionPayload *st = g_new0(FuStructPixartTpTfVersionPayload, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pixart_tp_tf_version_payload_get_major: (skip):
 **/
guint8
fu_struct_pixart_tp_tf_version_payload_get_major(const FuStructPixartTpTfVersionPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_pixart_tp_tf_version_payload_get_minor: (skip):
 **/
guint8
fu_struct_pixart_tp_tf_version_payload_get_minor(const FuStructPixartTpTfVersionPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_pixart_tp_tf_version_payload_get_patch: (skip):
 **/
guint8
fu_struct_pixart_tp_tf_version_payload_get_patch(const FuStructPixartTpTfVersionPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_pixart_tp_tf_version_payload_to_string: (skip):
 **/
static gchar *
fu_struct_pixart_tp_tf_version_payload_to_string(const FuStructPixartTpTfVersionPayload *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPixartTpTfVersionPayload:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_pixart_tp_tf_version_payload_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_pixart_tp_tf_version_payload_get_minor(st));
    g_string_append_printf(str, "  patch: 0x%x\n",
                           (guint) fu_struct_pixart_tp_tf_version_payload_get_patch(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pixart_tp_tf_version_payload_validate_internal(FuStructPixartTpTfVersionPayload *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pixart_tp_tf_version_payload_parse_internal(FuStructPixartTpTfVersionPayload *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pixart_tp_tf_version_payload_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pixart_tp_tf_version_payload_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_pixart_tp_tf_version_payload_parse: (skip):
 **/
FuStructPixartTpTfVersionPayload *
fu_struct_pixart_tp_tf_version_payload_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructPixartTpTfVersionPayload) st = fu_struct_pixart_tp_tf_version_payload_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructPixartTpTfVersionPayload: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_pixart_tp_tf_version_payload_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pixart_tp_tf_download_status_payload_ref: (skip):
 **/
FuStructPixartTpTfDownloadStatusPayload *
fu_struct_pixart_tp_tf_download_status_payload_ref(FuStructPixartTpTfDownloadStatusPayload *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_tf_download_status_payload_unref: (skip):
 **/
void
fu_struct_pixart_tp_tf_download_status_payload_unref(FuStructPixartTpTfDownloadStatusPayload *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpTfDownloadStatusPayload refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_tf_download_status_payload_new_internal: (skip):
 **/
static FuStructPixartTpTfDownloadStatusPayload *
fu_struct_pixart_tp_tf_download_status_payload_new_internal(void)
{
    FuStructPixartTpTfDownloadStatusPayload *st = g_new0(FuStructPixartTpTfDownloadStatusPayload, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pixart_tp_tf_download_status_payload_get_status: (skip):
 **/
guint8
fu_struct_pixart_tp_tf_download_status_payload_get_status(const FuStructPixartTpTfDownloadStatusPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_pixart_tp_tf_download_status_payload_get_packet_number: (skip):
 **/
guint16
fu_struct_pixart_tp_tf_download_status_payload_get_packet_number(const FuStructPixartTpTfDownloadStatusPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pixart_tp_tf_download_status_payload_to_string: (skip):
 **/
static gchar *
fu_struct_pixart_tp_tf_download_status_payload_to_string(const FuStructPixartTpTfDownloadStatusPayload *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPixartTpTfDownloadStatusPayload:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_pixart_tp_tf_download_status_payload_get_status(st));
    g_string_append_printf(str, "  packet_number: 0x%x\n",
                           (guint) fu_struct_pixart_tp_tf_download_status_payload_get_packet_number(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pixart_tp_tf_download_status_payload_validate_internal(FuStructPixartTpTfDownloadStatusPayload *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pixart_tp_tf_download_status_payload_parse_internal(FuStructPixartTpTfDownloadStatusPayload *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pixart_tp_tf_download_status_payload_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pixart_tp_tf_download_status_payload_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_pixart_tp_tf_download_status_payload_parse: (skip):
 **/
FuStructPixartTpTfDownloadStatusPayload *
fu_struct_pixart_tp_tf_download_status_payload_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructPixartTpTfDownloadStatusPayload) st = fu_struct_pixart_tp_tf_download_status_payload_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructPixartTpTfDownloadStatusPayload: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_pixart_tp_tf_download_status_payload_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_ref: (skip):
 **/
FuStructPixartTpTfWriteSimpleCmd *
fu_struct_pixart_tp_tf_write_simple_cmd_ref(FuStructPixartTpTfWriteSimpleCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_unref: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_unref(FuStructPixartTpTfWriteSimpleCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpTfWriteSimpleCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_new_internal: (skip):
 **/
static FuStructPixartTpTfWriteSimpleCmd *
fu_struct_pixart_tp_tf_write_simple_cmd_new_internal(void)
{
    FuStructPixartTpTfWriteSimpleCmd *st = g_new0(FuStructPixartTpTfWriteSimpleCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_set_report_id: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_set_report_id(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_set_preamble: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_set_preamble(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfFrameConst value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_set_target_addr: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_set_target_addr(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfTargetAddr value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_set_func: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_set_func(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfRmiFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_set_addr: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_set_addr(FuStructPixartTpTfWriteSimpleCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_set_len: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_simple_cmd_set_len(FuStructPixartTpTfWriteSimpleCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_write_simple_cmd_new: (skip):
 **/
FuStructPixartTpTfWriteSimpleCmd *
fu_struct_pixart_tp_tf_write_simple_cmd_new(void)
{
    FuStructPixartTpTfWriteSimpleCmd *st = fu_struct_pixart_tp_tf_write_simple_cmd_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_pixart_tp_tf_write_simple_cmd_set_report_id(st, FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH);
    fu_struct_pixart_tp_tf_write_simple_cmd_set_preamble(st, FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE);
    fu_struct_pixart_tp_tf_write_simple_cmd_set_target_addr(st, FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME);
    fu_struct_pixart_tp_tf_write_simple_cmd_set_func(st, FU_PIXART_TP_TF_RMI_FUNC_WRITE_SIMPLE);
    return st;
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_ref: (skip):
 **/
FuStructPixartTpTfWritePacketCmd *
fu_struct_pixart_tp_tf_write_packet_cmd_ref(FuStructPixartTpTfWritePacketCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_unref: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_unref(FuStructPixartTpTfWritePacketCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpTfWritePacketCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_new_internal: (skip):
 **/
static FuStructPixartTpTfWritePacketCmd *
fu_struct_pixart_tp_tf_write_packet_cmd_new_internal(void)
{
    FuStructPixartTpTfWritePacketCmd *st = g_new0(FuStructPixartTpTfWritePacketCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_report_id: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_report_id(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_preamble: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_preamble(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfFrameConst value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_target_addr: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_target_addr(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfTargetAddr value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_func: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_func(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfRmiFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_addr: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_addr(FuStructPixartTpTfWritePacketCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_datalen: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_datalen(FuStructPixartTpTfWritePacketCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_packet_total: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_packet_total(FuStructPixartTpTfWritePacketCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_set_packet_index: (skip):
 **/
void
fu_struct_pixart_tp_tf_write_packet_cmd_set_packet_index(FuStructPixartTpTfWritePacketCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_write_packet_cmd_new: (skip):
 **/
FuStructPixartTpTfWritePacketCmd *
fu_struct_pixart_tp_tf_write_packet_cmd_new(void)
{
    FuStructPixartTpTfWritePacketCmd *st = fu_struct_pixart_tp_tf_write_packet_cmd_new_internal();
    st->buf = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st->buf, 12, 0x0);
    fu_struct_pixart_tp_tf_write_packet_cmd_set_report_id(st, FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH);
    fu_struct_pixart_tp_tf_write_packet_cmd_set_preamble(st, FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE);
    fu_struct_pixart_tp_tf_write_packet_cmd_set_target_addr(st, FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME);
    fu_struct_pixart_tp_tf_write_packet_cmd_set_func(st, FU_PIXART_TP_TF_RMI_FUNC_WRITE_PACKET);
    return st;
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_ref: (skip):
 **/
FuStructPixartTpTfReadCmd *
fu_struct_pixart_tp_tf_read_cmd_ref(FuStructPixartTpTfReadCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_unref: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_unref(FuStructPixartTpTfReadCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpTfReadCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_new_internal: (skip):
 **/
static FuStructPixartTpTfReadCmd *
fu_struct_pixart_tp_tf_read_cmd_new_internal(void)
{
    FuStructPixartTpTfReadCmd *st = g_new0(FuStructPixartTpTfReadCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_report_id: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_report_id(FuStructPixartTpTfReadCmd *st, FuPixartTpTfReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_preamble: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_preamble(FuStructPixartTpTfReadCmd *st, FuPixartTpTfFrameConst value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_target_addr: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_target_addr(FuStructPixartTpTfReadCmd *st, FuPixartTpTfTargetAddr value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_func: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_func(FuStructPixartTpTfReadCmd *st, FuPixartTpTfRmiFunc value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_addr: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_addr(FuStructPixartTpTfReadCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_datalen: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_datalen(FuStructPixartTpTfReadCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_set_reply_len: (skip):
 **/
void
fu_struct_pixart_tp_tf_read_cmd_set_reply_len(FuStructPixartTpTfReadCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_tf_read_cmd_new: (skip):
 **/
FuStructPixartTpTfReadCmd *
fu_struct_pixart_tp_tf_read_cmd_new(void)
{
    FuStructPixartTpTfReadCmd *st = fu_struct_pixart_tp_tf_read_cmd_new_internal();
    st->buf = g_byte_array_sized_new(10);
    fu_byte_array_set_size(st->buf, 10, 0x0);
    fu_struct_pixart_tp_tf_read_cmd_set_report_id(st, FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH);
    fu_struct_pixart_tp_tf_read_cmd_set_preamble(st, FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE);
    fu_struct_pixart_tp_tf_read_cmd_set_target_addr(st, FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME);
    fu_struct_pixart_tp_tf_read_cmd_set_func(st, FU_PIXART_TP_TF_RMI_FUNC_READ);
    return st;
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_ref: (skip):
 **/
FuStructPixartTpTfReplyHdr *
fu_struct_pixart_tp_tf_reply_hdr_ref(FuStructPixartTpTfReplyHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_unref: (skip):
 **/
void
fu_struct_pixart_tp_tf_reply_hdr_unref(FuStructPixartTpTfReplyHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpTfReplyHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_new_internal: (skip):
 **/
static FuStructPixartTpTfReplyHdr *
fu_struct_pixart_tp_tf_reply_hdr_new_internal(void)
{
    FuStructPixartTpTfReplyHdr *st = g_new0(FuStructPixartTpTfReplyHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pixart_tp_tf_reply_hdr_get_report_id: (skip):
 **/
FuPixartTpTfReportId
fu_struct_pixart_tp_tf_reply_hdr_get_report_id(const FuStructPixartTpTfReplyHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_get_preamble: (skip):
 **/
FuPixartTpTfFrameConst
fu_struct_pixart_tp_tf_reply_hdr_get_preamble(const FuStructPixartTpTfReplyHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_get_target_addr: (skip):
 **/
FuPixartTpTfTargetAddr
fu_struct_pixart_tp_tf_reply_hdr_get_target_addr(const FuStructPixartTpTfReplyHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_get_func: (skip):
 **/
FuPixartTpTfRmiFunc
fu_struct_pixart_tp_tf_reply_hdr_get_func(const FuStructPixartTpTfReplyHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_pixart_tp_tf_reply_hdr_get_datalen: (skip):
 **/
guint16
fu_struct_pixart_tp_tf_reply_hdr_get_datalen(const FuStructPixartTpTfReplyHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pixart_tp_tf_reply_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_pixart_tp_tf_reply_hdr_to_string(const FuStructPixartTpTfReplyHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPixartTpTfReplyHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_pixart_tp_tf_report_id_to_string(fu_struct_pixart_tp_tf_reply_hdr_get_report_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  report_id: 0x%x [%s]\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_report_id(st), tmp);
        } else {
            g_string_append_printf(str, "  report_id: 0x%x\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_report_id(st));
        }
    }
    {
        const gchar *tmp = fu_pixart_tp_tf_frame_const_to_string(fu_struct_pixart_tp_tf_reply_hdr_get_preamble(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  preamble: 0x%x [%s]\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_preamble(st), tmp);
        } else {
            g_string_append_printf(str, "  preamble: 0x%x\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_preamble(st));
        }
    }
    {
        const gchar *tmp = fu_pixart_tp_tf_target_addr_to_string(fu_struct_pixart_tp_tf_reply_hdr_get_target_addr(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  target_addr: 0x%x [%s]\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_target_addr(st), tmp);
        } else {
            g_string_append_printf(str, "  target_addr: 0x%x\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_target_addr(st));
        }
    }
    {
        const gchar *tmp = fu_pixart_tp_tf_rmi_func_to_string(fu_struct_pixart_tp_tf_reply_hdr_get_func(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  func: 0x%x [%s]\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_func(st), tmp);
        } else {
            g_string_append_printf(str, "  func: 0x%x\n", (guint) fu_struct_pixart_tp_tf_reply_hdr_get_func(st));
        }
    }
    g_string_append_printf(str, "  datalen: 0x%x\n",
                           (guint) fu_struct_pixart_tp_tf_reply_hdr_get_datalen(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pixart_tp_tf_reply_hdr_validate_internal(FuStructPixartTpTfReplyHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pixart_tp_tf_reply_hdr_parse_internal(FuStructPixartTpTfReplyHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pixart_tp_tf_reply_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pixart_tp_tf_reply_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_pixart_tp_tf_reply_hdr_parse: (skip):
 **/
FuStructPixartTpTfReplyHdr *
fu_struct_pixart_tp_tf_reply_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructPixartTpTfReplyHdr) st = fu_struct_pixart_tp_tf_reply_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructPixartTpTfReplyHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 6);
    if (!fu_struct_pixart_tp_tf_reply_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_ref: (skip):
 **/
FuStructPixartTpFirmwareHdr *
fu_struct_pixart_tp_firmware_hdr_ref(FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_firmware_hdr_unref: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_unref(FuStructPixartTpFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_new_internal: (skip):
 **/
static FuStructPixartTpFirmwareHdr *
fu_struct_pixart_tp_firmware_hdr_new_internal(void)
{
    FuStructPixartTpFirmwareHdr *st = g_new0(FuStructPixartTpFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pixart_tp_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_pixart_tp_firmware_hdr_get_magic(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_header_len: (skip):
 **/
static guint16
fu_struct_pixart_tp_firmware_hdr_get_header_len(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_header_ver: (skip):
 **/
guint16
fu_struct_pixart_tp_firmware_hdr_get_header_ver(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_file_ver: (skip):
 **/
guint16
fu_struct_pixart_tp_firmware_hdr_get_file_ver(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_ic_part_id: (skip):
 **/
guint16
fu_struct_pixart_tp_firmware_hdr_get_ic_part_id(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_flash_sectors: (skip):
 **/
guint16
fu_struct_pixart_tp_firmware_hdr_get_flash_sectors(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_file_crc32: (skip):
 **/
guint32
fu_struct_pixart_tp_firmware_hdr_get_file_crc32(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_get_num_sections: (skip):
 **/
guint16
fu_struct_pixart_tp_firmware_hdr_get_num_sections(const FuStructPixartTpFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pixart_tp_firmware_hdr_set_magic: (skip):
 **/
static gboolean
fu_struct_pixart_tp_firmware_hdr_set_magic(FuStructPixartTpFirmwareHdr *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructPixartTpFirmwareHdr.magic (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_header_len: (skip):
 **/
static void
fu_struct_pixart_tp_firmware_hdr_set_header_len(FuStructPixartTpFirmwareHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_header_ver: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_set_header_ver(FuStructPixartTpFirmwareHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_file_ver: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_set_file_ver(FuStructPixartTpFirmwareHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_ic_part_id: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_set_ic_part_id(FuStructPixartTpFirmwareHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_flash_sectors: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_set_flash_sectors(FuStructPixartTpFirmwareHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_file_crc32: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_set_file_crc32(FuStructPixartTpFirmwareHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_set_num_sections: (skip):
 **/
void
fu_struct_pixart_tp_firmware_hdr_set_num_sections(FuStructPixartTpFirmwareHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_hdr_new: (skip):
 **/
FuStructPixartTpFirmwareHdr *
fu_struct_pixart_tp_firmware_hdr_new(void)
{
    FuStructPixartTpFirmwareHdr *st = fu_struct_pixart_tp_firmware_hdr_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    fu_struct_pixart_tp_firmware_hdr_set_magic(st, "FWHD", NULL);
    fu_struct_pixart_tp_firmware_hdr_set_header_len(st, 0x0218);
    return st;
}
/**
 * fu_struct_pixart_tp_firmware_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_pixart_tp_firmware_hdr_to_string(const FuStructPixartTpFirmwareHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPixartTpFirmwareHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  header_ver: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_hdr_get_header_ver(st));
    g_string_append_printf(str, "  file_ver: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_hdr_get_file_ver(st));
    g_string_append_printf(str, "  ic_part_id: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_hdr_get_ic_part_id(st));
    g_string_append_printf(str, "  flash_sectors: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_hdr_get_flash_sectors(st));
    g_string_append_printf(str, "  file_crc32: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_hdr_get_file_crc32(st));
    g_string_append_printf(str, "  num_sections: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_hdr_get_num_sections(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pixart_tp_firmware_hdr_validate_internal(FuStructPixartTpFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "FWHD", 4) != 0) {
        g_autofree gchar *str = fu_struct_pixart_tp_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructPixartTpFirmwareHdr.magic was not valid, "
                    "expected 'FWHD' and got '%s'",
                    str);
        return FALSE;
    }
    if (fu_struct_pixart_tp_firmware_hdr_get_header_len(st) != 0x0218) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructPixartTpFirmwareHdr.header_len was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0218,
                    (guint) fu_struct_pixart_tp_firmware_hdr_get_header_len(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_pixart_tp_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_pixart_tp_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPixartTpFirmwareHdr) st = fu_struct_pixart_tp_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPixartTpFirmwareHdr failed read of 0x%x: ", (guint) 20);
        return FALSE;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPixartTpFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_pixart_tp_firmware_hdr_validate_internal(st, error);
}
static gboolean
fu_struct_pixart_tp_firmware_hdr_parse_internal(FuStructPixartTpFirmwareHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pixart_tp_firmware_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pixart_tp_firmware_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_pixart_tp_firmware_hdr_parse_stream: (skip):
 **/
FuStructPixartTpFirmwareHdr *
fu_struct_pixart_tp_firmware_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPixartTpFirmwareHdr) st = fu_struct_pixart_tp_firmware_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 20, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPixartTpFirmwareHdr failed read of 0x%x: ", (guint) 20);
        return NULL;
    }
    if (st->buf->len != 20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPixartTpFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 20,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_pixart_tp_firmware_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_ref: (skip):
 **/
FuStructPixartTpFirmwareSectionHdr *
fu_struct_pixart_tp_firmware_section_hdr_ref(FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_unref: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_unref(FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPixartTpFirmwareSectionHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_new_internal: (skip):
 **/
static FuStructPixartTpFirmwareSectionHdr *
fu_struct_pixart_tp_firmware_section_hdr_new_internal(void)
{
    FuStructPixartTpFirmwareSectionHdr *st = g_new0(FuStructPixartTpFirmwareSectionHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_update_type: (skip):
 **/
FuPixartTpUpdateType
fu_struct_pixart_tp_firmware_section_hdr_get_update_type(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_update_info: (skip):
 **/
guint8
fu_struct_pixart_tp_firmware_section_hdr_get_update_info(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_target_flash_start: (skip):
 **/
guint32
fu_struct_pixart_tp_firmware_section_hdr_get_target_flash_start(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_internal_file_start: (skip):
 **/
guint32
fu_struct_pixart_tp_firmware_section_hdr_get_internal_file_start(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_section_length: (skip):
 **/
guint32
fu_struct_pixart_tp_firmware_section_hdr_get_section_length(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_section_crc: (skip):
 **/
guint32
fu_struct_pixart_tp_firmware_section_hdr_get_section_crc(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_shared: (skip):
 **/
const guint8 *
fu_struct_pixart_tp_firmware_section_hdr_get_shared(const FuStructPixartTpFirmwareSectionHdr *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 12;
    return st->buf->data + 18;
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_get_extname: (skip):
 **/
gchar *
fu_struct_pixart_tp_firmware_section_hdr_get_extname(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 30, 34, NULL);
}

/* setters */
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_update_type: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_set_update_type(FuStructPixartTpFirmwareSectionHdr *st, FuPixartTpUpdateType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_update_info: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_set_update_info(FuStructPixartTpFirmwareSectionHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_target_flash_start: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_set_target_flash_start(FuStructPixartTpFirmwareSectionHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_internal_file_start: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_set_internal_file_start(FuStructPixartTpFirmwareSectionHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_section_length: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_set_section_length(FuStructPixartTpFirmwareSectionHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_section_crc: (skip):
 **/
void
fu_struct_pixart_tp_firmware_section_hdr_set_section_crc(FuStructPixartTpFirmwareSectionHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_shared: (skip):
 **/
gboolean
fu_struct_pixart_tp_firmware_section_hdr_set_shared(FuStructPixartTpFirmwareSectionHdr *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 18, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_set_extname: (skip):
 **/
gboolean
fu_struct_pixart_tp_firmware_section_hdr_set_extname(FuStructPixartTpFirmwareSectionHdr *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 30, 0x0, 34);
        return TRUE;
    }
    len = strlen(value);
    if (len > 34) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructPixartTpFirmwareSectionHdr.extname (0x%x bytes)",
                    value, (guint) len, (guint) 34);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 30, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_new: (skip):
 **/
FuStructPixartTpFirmwareSectionHdr *
fu_struct_pixart_tp_firmware_section_hdr_new(void)
{
    FuStructPixartTpFirmwareSectionHdr *st = fu_struct_pixart_tp_firmware_section_hdr_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    return st;
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_pixart_tp_firmware_section_hdr_to_string(const FuStructPixartTpFirmwareSectionHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPixartTpFirmwareSectionHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_pixart_tp_update_type_to_string(fu_struct_pixart_tp_firmware_section_hdr_get_update_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  update_type: 0x%x [%s]\n", (guint) fu_struct_pixart_tp_firmware_section_hdr_get_update_type(st), tmp);
        } else {
            g_string_append_printf(str, "  update_type: 0x%x\n", (guint) fu_struct_pixart_tp_firmware_section_hdr_get_update_type(st));
        }
    }
    g_string_append_printf(str, "  update_info: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_section_hdr_get_update_info(st));
    g_string_append_printf(str, "  target_flash_start: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_section_hdr_get_target_flash_start(st));
    g_string_append_printf(str, "  internal_file_start: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_section_hdr_get_internal_file_start(st));
    g_string_append_printf(str, "  section_length: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_section_hdr_get_section_length(st));
    g_string_append_printf(str, "  section_crc: 0x%x\n",
                           (guint) fu_struct_pixart_tp_firmware_section_hdr_get_section_crc(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_pixart_tp_firmware_section_hdr_get_shared(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  shared: 0x%s\n", tmp->str);
    }
    {
        g_autofree gchar *tmp = fu_struct_pixart_tp_firmware_section_hdr_get_extname(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  extname: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_pixart_tp_firmware_section_hdr_validate_internal(FuStructPixartTpFirmwareSectionHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_pixart_tp_firmware_section_hdr_parse_internal(FuStructPixartTpFirmwareSectionHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_pixart_tp_firmware_section_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_pixart_tp_firmware_section_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_pixart_tp_firmware_section_hdr_parse_stream: (skip):
 **/
FuStructPixartTpFirmwareSectionHdr *
fu_struct_pixart_tp_firmware_section_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPixartTpFirmwareSectionHdr) st = fu_struct_pixart_tp_firmware_section_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 64, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPixartTpFirmwareSectionHdr failed read of 0x%x: ", (guint) 64);
        return NULL;
    }
    if (st->buf->len != 64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPixartTpFirmwareSectionHdr requested 0x%x and got 0x%x",
                    (guint) 64,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_pixart_tp_firmware_section_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
