//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceLocatorDiscovery.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceLocatorDiscovery_IceLocatorDiscovery_h__
#define __IceLocatorDiscovery_IceLocatorDiscovery_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Locator.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceLocatorDiscovery
{

class LookupReply;
class LookupReplyPrx;
class Lookup;
class LookupPrx;

}

namespace IceLocatorDiscovery
{

/**
 * The Ice lookup reply interface must be implemented by clients which
 * are searching for Ice locators. Ice locator implementations invoke
 * on this interface to provide their locator proxy.
 * @see Lookup
 * \headerfile IceLocatorDiscovery/IceLocatorDiscovery.h
 */
class LookupReply : public virtual ::Ice::Object
{
public:

    using ProxyType = LookupReplyPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param current The Current object for the invocation.
     */
    virtual void foundLocator(::std::shared_ptr<::Ice::LocatorPrx> prx, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_foundLocator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The Ice lookup interface is implemented by Ice locator
 * implementations and can be used by clients to find available Ice
 * locators on the network.
 *
 * Ice locator implementations provide a well-known `Ice/LocatorLookup'
 * object accessible through UDP multicast. Clients typically make a
 * multicast findLocator request to find the locator proxy.
 * @see LookupReply
 * \headerfile IceLocatorDiscovery/IceLocatorDiscovery.h
 */
class Lookup : public virtual ::Ice::Object
{
public:

    using ProxyType = LookupPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param current The Current object for the invocation.
     */
    virtual void findLocator(::std::string instanceName, ::std::shared_ptr<LookupReplyPrx> reply, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_findLocator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceLocatorDiscovery
{

/**
 * The Ice lookup reply interface must be implemented by clients which
 * are searching for Ice locators. Ice locator implementations invoke
 * on this interface to provide their locator proxy.
 * @see Lookup
 * \headerfile IceLocatorDiscovery/IceLocatorDiscovery.h
 */
class LookupReplyPrx : public virtual ::Ice::Proxy<LookupReplyPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param context The Context map to send with the invocation.
     */
    void foundLocator(const ::std::shared_ptr<::Ice::LocatorPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LookupReplyPrx::_iceI_foundLocator, prx, context).get();
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto foundLocatorAsync(const ::std::shared_ptr<::Ice::LocatorPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LookupReplyPrx::_iceI_foundLocator, prx, context);
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    foundLocatorAsync(const ::std::shared_ptr<::Ice::LocatorPrx>& prx,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceLocatorDiscovery::LookupReplyPrx::_iceI_foundLocator, prx, context);
    }

    /// \cond INTERNAL
    void _iceI_foundLocator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::LocatorPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LookupReplyPrx() = default;
    friend ::std::shared_ptr<LookupReplyPrx> IceInternal::createProxy<LookupReplyPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The Ice lookup interface is implemented by Ice locator
 * implementations and can be used by clients to find available Ice
 * locators on the network.
 *
 * Ice locator implementations provide a well-known `Ice/LocatorLookup'
 * object accessible through UDP multicast. Clients typically make a
 * multicast findLocator request to find the locator proxy.
 * @see LookupReply
 * \headerfile IceLocatorDiscovery/IceLocatorDiscovery.h
 */
class LookupPrx : public virtual ::Ice::Proxy<LookupPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param context The Context map to send with the invocation.
     */
    void findLocator(const ::std::string& instanceName, const ::std::shared_ptr<LookupReplyPrx>& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LookupPrx::_iceI_findLocator, instanceName, reply, context).get();
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findLocatorAsync(const ::std::string& instanceName, const ::std::shared_ptr<LookupReplyPrx>& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LookupPrx::_iceI_findLocator, instanceName, reply, context);
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findLocatorAsync(const ::std::string& instanceName, const ::std::shared_ptr<LookupReplyPrx>& reply,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceLocatorDiscovery::LookupPrx::_iceI_findLocator, instanceName, reply, context);
    }

    /// \cond INTERNAL
    void _iceI_findLocator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::shared_ptr<LookupReplyPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LookupPrx() = default;
    friend ::std::shared_ptr<LookupPrx> IceInternal::createProxy<LookupPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace IceLocatorDiscovery
{

using LookupReplyPtr = ::std::shared_ptr<LookupReply>;
using LookupReplyPrxPtr = ::std::shared_ptr<LookupReplyPrx>;

using LookupPtr = ::std::shared_ptr<Lookup>;
using LookupPrxPtr = ::std::shared_ptr<LookupPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceLocatorDiscovery
{

class LookupReply;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< LookupReply>&);
::IceProxy::Ice::Object* upCast(LookupReply*);
/// \endcond

class Lookup;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Lookup>&);
::IceProxy::Ice::Object* upCast(Lookup*);
/// \endcond

}

}

namespace IceLocatorDiscovery
{

class LookupReply;
/// \cond INTERNAL
::Ice::Object* upCast(LookupReply*);
/// \endcond
typedef ::IceInternal::Handle< LookupReply> LookupReplyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceLocatorDiscovery::LookupReply> LookupReplyPrx;
typedef LookupReplyPrx LookupReplyPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(LookupReplyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Lookup;
/// \cond INTERNAL
::Ice::Object* upCast(Lookup*);
/// \endcond
typedef ::IceInternal::Handle< Lookup> LookupPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceLocatorDiscovery::Lookup> LookupPrx;
typedef LookupPrx LookupPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(LookupPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

/// \cond INTERNAL
namespace IceAsync
{

}
/// \endcond

namespace IceLocatorDiscovery
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 * Create a wrapper instance by calling ::IceLocatorDiscovery::newCallback_LookupReply_foundLocator.
 */
class Callback_LookupReply_foundLocator_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LookupReply_foundLocator_Base> Callback_LookupReply_foundLocatorPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 * Create a wrapper instance by calling ::IceLocatorDiscovery::newCallback_Lookup_findLocator.
 */
class Callback_Lookup_findLocator_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Lookup_findLocator_Base> Callback_Lookup_findLocatorPtr;

}

namespace IceProxy
{

namespace IceLocatorDiscovery
{

class LookupReply : public virtual ::Ice::Proxy<LookupReply, ::IceProxy::Ice::Object>
{
public:

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param context The Context map to send with the invocation.
     */
    void foundLocator(const ::Ice::LocatorPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_foundLocator(_iceI_begin_foundLocator(prx, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundLocator(const ::Ice::LocatorPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_foundLocator(prx, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundLocator(const ::Ice::LocatorPrx& prx, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundLocator(prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundLocator(const ::Ice::LocatorPrx& prx, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundLocator(prx, context, cb, cookie);
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundLocator(const ::Ice::LocatorPrx& prx, const ::IceLocatorDiscovery::Callback_LookupReply_foundLocatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundLocator(prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundLocator(const ::Ice::LocatorPrx& prx, const ::Ice::Context& context, const ::IceLocatorDiscovery::Callback_LookupReply_foundLocatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundLocator(prx, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_foundLocator.
     * @param result The asynchronous result object for the invocation.
     */
    void end_foundLocator(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_foundLocator(const ::Ice::LocatorPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Lookup : public virtual ::Ice::Proxy<Lookup, ::IceProxy::Ice::Object>
{
public:

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param context The Context map to send with the invocation.
     */
    void findLocator(const ::std::string& instanceName, const ::IceLocatorDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_findLocator(_iceI_begin_findLocator(instanceName, reply, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findLocator(const ::std::string& instanceName, const ::IceLocatorDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findLocator(instanceName, reply, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findLocator(const ::std::string& instanceName, const ::IceLocatorDiscovery::LookupReplyPrx& reply, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findLocator(instanceName, reply, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findLocator(const ::std::string& instanceName, const ::IceLocatorDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findLocator(instanceName, reply, context, cb, cookie);
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findLocator(const ::std::string& instanceName, const ::IceLocatorDiscovery::LookupReplyPrx& reply, const ::IceLocatorDiscovery::Callback_Lookup_findLocatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findLocator(instanceName, reply, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findLocator(const ::std::string& instanceName, const ::IceLocatorDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context, const ::IceLocatorDiscovery::Callback_Lookup_findLocatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findLocator(instanceName, reply, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findLocator.
     * @param result The asynchronous result object for the invocation.
     */
    void end_findLocator(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_findLocator(const ::std::string&, const ::IceLocatorDiscovery::LookupReplyPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceLocatorDiscovery
{

/**
 * The Ice lookup reply interface must be implemented by clients which
 * are searching for Ice locators. Ice locator implementations invoke
 * on this interface to provide their locator proxy.
 * @see Lookup
 * \headerfile IceLocatorDiscovery/IceLocatorDiscovery.h
 */
class LookupReply : public virtual ::Ice::Object
{
public:

    typedef LookupReplyPrx ProxyType;
    typedef LookupReplyPtr PointerType;

    virtual ~LookupReply();

#ifdef ICE_CPP11_COMPILER
    LookupReply() = default;
    LookupReply(const LookupReply&) = default;
    LookupReply& operator=(const LookupReply&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * This method is called by the implementation of the Lookup
     * interface to reply to a findLocator request.
     * @param prx The proxy of the locator.
     * @param current The Current object for the invocation.
     */
    virtual void foundLocator(const ::Ice::LocatorPrx& prx, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_foundLocator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const LookupReply& lhs, const LookupReply& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LookupReply& lhs, const LookupReply& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The Ice lookup interface is implemented by Ice locator
 * implementations and can be used by clients to find available Ice
 * locators on the network.
 *
 * Ice locator implementations provide a well-known `Ice/LocatorLookup'
 * object accessible through UDP multicast. Clients typically make a
 * multicast findLocator request to find the locator proxy.
 * @see LookupReply
 * \headerfile IceLocatorDiscovery/IceLocatorDiscovery.h
 */
class Lookup : public virtual ::Ice::Object
{
public:

    typedef LookupPrx ProxyType;
    typedef LookupPtr PointerType;

    virtual ~Lookup();

#ifdef ICE_CPP11_COMPILER
    Lookup() = default;
    Lookup(const Lookup&) = default;
    Lookup& operator=(const Lookup&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Find a locator proxy with the given instance name.
     * @param instanceName Restrict the search to Ice registries
     * configured with the given instance name. If empty, all the
     * available registries will reply.
     * @param reply The reply object to use to send the reply.
     * @param current The Current object for the invocation.
     */
    virtual void findLocator(const ::std::string& instanceName, const LookupReplyPrx& reply, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_findLocator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Lookup& lhs, const Lookup& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Lookup& lhs, const Lookup& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

namespace IceLocatorDiscovery
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 * Create a wrapper instance by calling ::IceLocatorDiscovery::newCallback_LookupReply_foundLocator.
 */
template<class T>
class CallbackNC_LookupReply_foundLocator : public Callback_LookupReply_foundLocator_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LookupReply_foundLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundLocator<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundLocator<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundLocator<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundLocator<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 * Create a wrapper instance by calling ::IceLocatorDiscovery::newCallback_LookupReply_foundLocator.
 */
template<class T, typename CT>
class Callback_LookupReply_foundLocator : public Callback_LookupReply_foundLocator_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LookupReply_foundLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T, typename CT> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundLocator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T, typename CT> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundLocator<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T, typename CT> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundLocator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::LookupReply::begin_foundLocator.
 */
template<class T, typename CT> Callback_LookupReply_foundLocatorPtr
newCallback_LookupReply_foundLocator(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundLocator<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 * Create a wrapper instance by calling ::IceLocatorDiscovery::newCallback_Lookup_findLocator.
 */
template<class T>
class CallbackNC_Lookup_findLocator : public Callback_Lookup_findLocator_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Lookup_findLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findLocator<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findLocator<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findLocator<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findLocator<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 * Create a wrapper instance by calling ::IceLocatorDiscovery::newCallback_Lookup_findLocator.
 */
template<class T, typename CT>
class Callback_Lookup_findLocator : public Callback_Lookup_findLocator_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Lookup_findLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T, typename CT> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findLocator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T, typename CT> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findLocator<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T, typename CT> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findLocator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceLocatorDiscovery::Lookup::begin_findLocator.
 */
template<class T, typename CT> Callback_Lookup_findLocatorPtr
newCallback_Lookup_findLocator(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findLocator<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
