/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportCloseInfo.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportCloseInfo>> convertDictionary<WebTransportCloseInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportCloseInfo result;
    JSValue closeCodeValue;
    if (isNullOrUndefined)
        closeCodeValue = jsUndefined();
    else {
        closeCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "closeCode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto closeCodeConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, closeCodeValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (closeCodeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.closeCode = closeCodeConversionResult.releaseReturnValue();
    JSValue reasonValue;
    if (isNullOrUndefined)
        reasonValue = jsUndefined();
    else {
        reasonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "reason"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto reasonConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, reasonValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (reasonConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.reason = reasonConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebTransportCloseInfo& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto closeCodeValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.closeCode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "closeCode"_s), closeCodeValue);
    auto reasonValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, dictionary.reason);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "reason"_s), reasonValue);
    return result;
}

} // namespace WebCore

