/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollTimeline.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSScrollAxis.h"
#include "JSScrollTimelineOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsScrollTimelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsScrollTimeline_source);
static JSC_DECLARE_CUSTOM_GETTER(jsScrollTimeline_axis);

class JSScrollTimelinePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSScrollTimelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScrollTimelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSScrollTimelinePrototype>(vm)) JSScrollTimelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScrollTimelinePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSScrollTimelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScrollTimelinePrototype, JSScrollTimelinePrototype::Base);

using JSScrollTimelineDOMConstructor = JSDOMConstructor<JSScrollTimeline>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSScrollTimelineDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSScrollTimelineDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    RefPtr context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "ScrollTimeline"_s);
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<ScrollTimelineOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = ScrollTimeline::create(document.get(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ScrollTimeline>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ScrollTimeline>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSScrollTimelineDOMConstructorConstruct, JSScrollTimelineDOMConstructor::construct);

template<> const ClassInfo JSScrollTimelineDOMConstructor::s_info = { "ScrollTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScrollTimelineDOMConstructor) };

template<> JSValue JSScrollTimelineDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAnimationTimeline::getConstructor(vm, &globalObject);
}

template<> void JSScrollTimelineDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ScrollTimeline"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSScrollTimeline::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSScrollTimelinePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsScrollTimelineConstructor, 0 } },
    HashTableValue { "source"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScrollTimeline_source, 0 } },
    HashTableValue { "axis"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScrollTimeline_axis, 0 } },
};

const ClassInfo JSScrollTimelinePrototype::s_info = { "ScrollTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScrollTimelinePrototype) };

void JSScrollTimelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSScrollTimeline::info(), JSScrollTimelinePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSScrollTimeline::s_info = { "ScrollTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScrollTimeline) };

JSScrollTimeline::JSScrollTimeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ScrollTimeline>&& impl)
    : JSAnimationTimeline(structure, globalObject, WTFMove(impl))
{
}

Ref<ScrollTimeline> JSScrollTimeline::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ScrollTimeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSScrollTimeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSScrollTimelinePrototype::createStructure(vm, &globalObject, JSAnimationTimeline::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSScrollTimelinePrototype::create(vm, &globalObject, structure);
}

JSObject* JSScrollTimeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSScrollTimeline>(vm, globalObject);
}

JSValue JSScrollTimeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSScrollTimelineDOMConstructor, DOMConstructorID::ScrollTimeline>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsScrollTimelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSScrollTimelinePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSScrollTimeline::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsScrollTimeline_sourceGetter(JSGlobalObject& lexicalGlobalObject, JSScrollTimeline& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsSource())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScrollTimeline_source, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScrollTimeline>::get<jsScrollTimeline_sourceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScrollTimeline_axisGetter(JSGlobalObject& lexicalGlobalObject, JSScrollTimeline& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ScrollAxis>>(lexicalGlobalObject, throwScope, impl.axis())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScrollTimeline_axis, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScrollTimeline>::get<jsScrollTimeline_axisGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSScrollTimeline::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSScrollTimeline, UseCustomHeapCellType::No>(vm, "JSScrollTimeline"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForScrollTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForScrollTimeline = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForScrollTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForScrollTimeline = std::forward<decltype(space)>(space); }
    );
}

void JSScrollTimeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSScrollTimeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ScrollTimeline@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14ScrollTimelineE[]; }
#endif
template<std::same_as<ScrollTimeline> T>
static inline void verifyVTable(ScrollTimeline* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ScrollTimeline@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14ScrollTimelineE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ScrollTimeline has subclasses. If ScrollTimeline has subclasses that get passed
        // to toJS() we currently require ScrollTimeline you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ScrollTimeline>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ScrollTimeline>(impl.ptr());
#endif
    return createWrapper<ScrollTimeline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ScrollTimeline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
