/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGGraphicsElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGGraphicsElementPrototypeFunction_getBBox);
static JSC_DECLARE_HOST_FUNCTION(jsSVGGraphicsElementPrototypeFunction_getCTM);
static JSC_DECLARE_HOST_FUNCTION(jsSVGGraphicsElementPrototypeFunction_getScreenCTM);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGGraphicsElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGGraphicsElement_transform);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGGraphicsElement_nearestViewportElement);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGGraphicsElement_farthestViewportElement);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGGraphicsElement_requiredExtensions);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGGraphicsElement_systemLanguage);

class JSSVGGraphicsElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGGraphicsElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGGraphicsElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGGraphicsElementPrototype>(vm)) JSSVGGraphicsElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGGraphicsElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGGraphicsElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGGraphicsElementPrototype, JSSVGGraphicsElementPrototype::Base);

using JSSVGGraphicsElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGGraphicsElement>;

template<> const ClassInfo JSSVGGraphicsElementDOMConstructor::s_info = { "SVGGraphicsElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGGraphicsElementDOMConstructor) };

template<> JSValue JSSVGGraphicsElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGGraphicsElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGGraphicsElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGGraphicsElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 9> JSSVGGraphicsElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGraphicsElementConstructor, 0 } },
    HashTableValue { "transform"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGraphicsElement_transform, 0 } },
    HashTableValue { "nearestViewportElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGraphicsElement_nearestViewportElement, 0 } },
    HashTableValue { "farthestViewportElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGraphicsElement_farthestViewportElement, 0 } },
    HashTableValue { "requiredExtensions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGraphicsElement_requiredExtensions, 0 } },
    HashTableValue { "systemLanguage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGraphicsElement_systemLanguage, 0 } },
    HashTableValue { "getBBox"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGraphicsElementPrototypeFunction_getBBox, 0 } },
    HashTableValue { "getCTM"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGraphicsElementPrototypeFunction_getCTM, 0 } },
    HashTableValue { "getScreenCTM"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGraphicsElementPrototypeFunction_getScreenCTM, 0 } },
};

const ClassInfo JSSVGGraphicsElementPrototype::s_info = { "SVGGraphicsElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGGraphicsElementPrototype) };

void JSSVGGraphicsElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGGraphicsElement::info(), JSSVGGraphicsElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGGraphicsElement::s_info = { "SVGGraphicsElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGGraphicsElement) };

JSSVGGraphicsElement::JSSVGGraphicsElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGGraphicsElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGGraphicsElement> JSSVGGraphicsElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGGraphicsElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGGraphicsElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGGraphicsElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGGraphicsElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGGraphicsElement>(vm, globalObject);
}

JSValue JSSVGGraphicsElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGraphicsElementDOMConstructor, DOMConstructorID::SVGGraphicsElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGraphicsElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGGraphicsElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGGraphicsElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGGraphicsElement_transformGetter(JSGlobalObject& lexicalGlobalObject, JSSVGGraphicsElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedTransformList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transformAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGraphicsElement_transform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGGraphicsElement>::get<jsSVGGraphicsElement_transformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGGraphicsElement_nearestViewportElementGetter(JSGlobalObject& lexicalGlobalObject, JSSVGGraphicsElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.nearestViewportElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGraphicsElement_nearestViewportElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGGraphicsElement>::get<jsSVGGraphicsElement_nearestViewportElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGGraphicsElement_farthestViewportElementGetter(JSGlobalObject& lexicalGlobalObject, JSSVGGraphicsElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.farthestViewportElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGraphicsElement_farthestViewportElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGGraphicsElement>::get<jsSVGGraphicsElement_farthestViewportElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGGraphicsElement_requiredExtensionsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGGraphicsElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.requiredExtensions())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGraphicsElement_requiredExtensions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGGraphicsElement>::get<jsSVGGraphicsElement_requiredExtensionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGGraphicsElement_systemLanguageGetter(JSGlobalObject& lexicalGlobalObject, JSSVGGraphicsElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.systemLanguage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGraphicsElement_systemLanguage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGGraphicsElement>::get<jsSVGGraphicsElement_systemLanguageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGGraphicsElementPrototypeFunction_getBBoxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGraphicsElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getBBoxForBindings())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGraphicsElementPrototypeFunction_getBBox, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGraphicsElement>::call<jsSVGGraphicsElementPrototypeFunction_getBBoxBody>(*lexicalGlobalObject, *callFrame, "getBBox");
}

static inline JSC::EncodedJSValue jsSVGGraphicsElementPrototypeFunction_getCTMBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGraphicsElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCTMForBindings())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGraphicsElementPrototypeFunction_getCTM, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGraphicsElement>::call<jsSVGGraphicsElementPrototypeFunction_getCTMBody>(*lexicalGlobalObject, *callFrame, "getCTM");
}

static inline JSC::EncodedJSValue jsSVGGraphicsElementPrototypeFunction_getScreenCTMBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGraphicsElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getScreenCTMForBindings())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGraphicsElementPrototypeFunction_getScreenCTM, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGraphicsElement>::call<jsSVGGraphicsElementPrototypeFunction_getScreenCTMBody>(*lexicalGlobalObject, *callFrame, "getScreenCTM");
}

JSC::GCClient::IsoSubspace* JSSVGGraphicsElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGGraphicsElement, UseCustomHeapCellType::No>(vm, "JSSVGGraphicsElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGGraphicsElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGGraphicsElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGGraphicsElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGGraphicsElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGGraphicsElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGGraphicsElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
