/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaTrackConstraints.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<MediaTrackConstraints>> convertDictionary<MediaTrackConstraints>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaTrackConstraints result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!aspectRatioValue.isUndefined()) {
        auto aspectRatioConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, aspectRatioValue);
        if (aspectRatioConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.aspectRatio = aspectRatioConversionResult.releaseReturnValue();
    }
    JSValue backgroundBlurValue;
    if (isNullOrUndefined)
        backgroundBlurValue = jsUndefined();
    else {
        backgroundBlurValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "backgroundBlur"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!backgroundBlurValue.isUndefined()) {
        auto backgroundBlurConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, backgroundBlurValue);
        if (backgroundBlurConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.backgroundBlur = backgroundBlurConversionResult.releaseReturnValue();
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!deviceIdValue.isUndefined()) {
        auto deviceIdConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, deviceIdValue);
        if (deviceIdConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.deviceId = deviceIdConversionResult.releaseReturnValue();
    }
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        auto displaySurfaceConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, displaySurfaceValue);
        if (displaySurfaceConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.displaySurface = displaySurfaceConversionResult.releaseReturnValue();
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!echoCancellationValue.isUndefined()) {
        auto echoCancellationConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, echoCancellationValue);
        if (echoCancellationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.echoCancellation = echoCancellationConversionResult.releaseReturnValue();
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!facingModeValue.isUndefined()) {
        auto facingModeConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, facingModeValue);
        if (facingModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.facingMode = facingModeConversionResult.releaseReturnValue();
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!frameRateValue.isUndefined()) {
        auto frameRateConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, frameRateValue);
        if (frameRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.frameRate = frameRateConversionResult.releaseReturnValue();
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!groupIdValue.isUndefined()) {
        auto groupIdConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, groupIdValue);
        if (groupIdConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.groupId = groupIdConversionResult.releaseReturnValue();
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!heightValue.isUndefined()) {
        auto heightConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, heightValue);
        if (heightConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.height = heightConversionResult.releaseReturnValue();
    }
    JSValue logicalSurfaceValue;
    if (isNullOrUndefined)
        logicalSurfaceValue = jsUndefined();
    else {
        logicalSurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "logicalSurface"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!logicalSurfaceValue.isUndefined()) {
        auto logicalSurfaceConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, logicalSurfaceValue);
        if (logicalSurfaceConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.logicalSurface = logicalSurfaceConversionResult.releaseReturnValue();
    }
    JSValue powerEfficientValue;
    if (isNullOrUndefined)
        powerEfficientValue = jsUndefined();
    else {
        powerEfficientValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerEfficient"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!powerEfficientValue.isUndefined()) {
        auto powerEfficientConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, powerEfficientValue);
        if (powerEfficientConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.powerEfficient = powerEfficientConversionResult.releaseReturnValue();
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sampleRateValue.isUndefined()) {
        auto sampleRateConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleRateValue);
        if (sampleRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sampleRate = sampleRateConversionResult.releaseReturnValue();
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sampleSizeValue.isUndefined()) {
        auto sampleSizeConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleSizeValue);
        if (sampleSizeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sampleSize = sampleSizeConversionResult.releaseReturnValue();
    }
    JSValue torchValue;
    if (isNullOrUndefined)
        torchValue = jsUndefined();
    else {
        torchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "torch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!torchValue.isUndefined()) {
        auto torchConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, torchValue);
        if (torchConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.torch = torchConversionResult.releaseReturnValue();
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!volumeValue.isUndefined()) {
        auto volumeConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, volumeValue);
        if (volumeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.volume = volumeConversionResult.releaseReturnValue();
    }
    JSValue whiteBalanceModeValue;
    if (isNullOrUndefined)
        whiteBalanceModeValue = jsUndefined();
    else {
        whiteBalanceModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "whiteBalanceMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!whiteBalanceModeValue.isUndefined()) {
        auto whiteBalanceModeConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, whiteBalanceModeValue);
        if (whiteBalanceModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.whiteBalanceMode = whiteBalanceModeConversionResult.releaseReturnValue();
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!widthValue.isUndefined()) {
        auto widthConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, widthValue);
        if (widthConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.width = widthConversionResult.releaseReturnValue();
    }
    JSValue zoomValue;
    if (isNullOrUndefined)
        zoomValue = jsUndefined();
    else {
        zoomValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "zoom"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!zoomValue.isUndefined()) {
        auto zoomConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, zoomValue);
        if (zoomConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.zoom = zoomConversionResult.releaseReturnValue();
    }
    JSValue advancedValue;
    if (isNullOrUndefined)
        advancedValue = jsUndefined();
    else {
        advancedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "advanced"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!advancedValue.isUndefined()) {
        auto advancedConversionResult = convert<IDLSequence<IDLDictionary<MediaTrackConstraintSet>>>(lexicalGlobalObject, advancedValue);
        if (advancedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.advanced = advancedConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackConstraints& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.aspectRatio));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.backgroundBlur)) {
        auto backgroundBlurValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.backgroundBlur));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "backgroundBlur"_s), backgroundBlurValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.deviceId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.displaySurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.echoCancellation));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.facingMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.frameRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.groupId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.height));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.logicalSurface)) {
        auto logicalSurfaceValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.logicalSurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "logicalSurface"_s), logicalSurfaceValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.powerEfficient)) {
        auto powerEfficientValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.powerEfficient));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "powerEfficient"_s), powerEfficientValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleSize));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.torch)) {
        auto torchValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.torch));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "torch"_s), torchValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.volume));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.whiteBalanceMode)) {
        auto whiteBalanceModeValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.whiteBalanceMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "whiteBalanceMode"_s), whiteBalanceModeValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.width));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.zoom)) {
        auto zoomValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.zoom));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    }
    if (!IDLSequence<IDLDictionary<MediaTrackConstraintSet>>::isNullValue(dictionary.advanced)) {
        auto advancedValue = toJS<IDLSequence<IDLDictionary<MediaTrackConstraintSet>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDictionary<MediaTrackConstraintSet>>::extractValueFromNullable(dictionary.advanced));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "advanced"_s), advancedValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<MediaTrackConstraintSet>> convertDictionary<MediaTrackConstraintSet>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaTrackConstraintSet result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!aspectRatioValue.isUndefined()) {
        auto aspectRatioConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, aspectRatioValue);
        if (aspectRatioConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.aspectRatio = aspectRatioConversionResult.releaseReturnValue();
    }
    JSValue backgroundBlurValue;
    if (isNullOrUndefined)
        backgroundBlurValue = jsUndefined();
    else {
        backgroundBlurValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "backgroundBlur"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!backgroundBlurValue.isUndefined()) {
        auto backgroundBlurConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, backgroundBlurValue);
        if (backgroundBlurConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.backgroundBlur = backgroundBlurConversionResult.releaseReturnValue();
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!deviceIdValue.isUndefined()) {
        auto deviceIdConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, deviceIdValue);
        if (deviceIdConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.deviceId = deviceIdConversionResult.releaseReturnValue();
    }
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        auto displaySurfaceConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, displaySurfaceValue);
        if (displaySurfaceConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.displaySurface = displaySurfaceConversionResult.releaseReturnValue();
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!echoCancellationValue.isUndefined()) {
        auto echoCancellationConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, echoCancellationValue);
        if (echoCancellationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.echoCancellation = echoCancellationConversionResult.releaseReturnValue();
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!facingModeValue.isUndefined()) {
        auto facingModeConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, facingModeValue);
        if (facingModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.facingMode = facingModeConversionResult.releaseReturnValue();
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!frameRateValue.isUndefined()) {
        auto frameRateConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, frameRateValue);
        if (frameRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.frameRate = frameRateConversionResult.releaseReturnValue();
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!groupIdValue.isUndefined()) {
        auto groupIdConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, groupIdValue);
        if (groupIdConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.groupId = groupIdConversionResult.releaseReturnValue();
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!heightValue.isUndefined()) {
        auto heightConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, heightValue);
        if (heightConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.height = heightConversionResult.releaseReturnValue();
    }
    JSValue logicalSurfaceValue;
    if (isNullOrUndefined)
        logicalSurfaceValue = jsUndefined();
    else {
        logicalSurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "logicalSurface"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!logicalSurfaceValue.isUndefined()) {
        auto logicalSurfaceConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, logicalSurfaceValue);
        if (logicalSurfaceConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.logicalSurface = logicalSurfaceConversionResult.releaseReturnValue();
    }
    JSValue powerEfficientValue;
    if (isNullOrUndefined)
        powerEfficientValue = jsUndefined();
    else {
        powerEfficientValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerEfficient"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!powerEfficientValue.isUndefined()) {
        auto powerEfficientConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, powerEfficientValue);
        if (powerEfficientConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.powerEfficient = powerEfficientConversionResult.releaseReturnValue();
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sampleRateValue.isUndefined()) {
        auto sampleRateConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleRateValue);
        if (sampleRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sampleRate = sampleRateConversionResult.releaseReturnValue();
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sampleSizeValue.isUndefined()) {
        auto sampleSizeConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleSizeValue);
        if (sampleSizeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sampleSize = sampleSizeConversionResult.releaseReturnValue();
    }
    JSValue torchValue;
    if (isNullOrUndefined)
        torchValue = jsUndefined();
    else {
        torchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "torch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!torchValue.isUndefined()) {
        auto torchConversionResult = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, torchValue);
        if (torchConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.torch = torchConversionResult.releaseReturnValue();
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!volumeValue.isUndefined()) {
        auto volumeConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, volumeValue);
        if (volumeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.volume = volumeConversionResult.releaseReturnValue();
    }
    JSValue whiteBalanceModeValue;
    if (isNullOrUndefined)
        whiteBalanceModeValue = jsUndefined();
    else {
        whiteBalanceModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "whiteBalanceMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!whiteBalanceModeValue.isUndefined()) {
        auto whiteBalanceModeConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, whiteBalanceModeValue);
        if (whiteBalanceModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.whiteBalanceMode = whiteBalanceModeConversionResult.releaseReturnValue();
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!widthValue.isUndefined()) {
        auto widthConversionResult = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, widthValue);
        if (widthConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.width = widthConversionResult.releaseReturnValue();
    }
    JSValue zoomValue;
    if (isNullOrUndefined)
        zoomValue = jsUndefined();
    else {
        zoomValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "zoom"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!zoomValue.isUndefined()) {
        auto zoomConversionResult = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, zoomValue);
        if (zoomConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.zoom = zoomConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackConstraintSet& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.aspectRatio));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.backgroundBlur)) {
        auto backgroundBlurValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.backgroundBlur));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "backgroundBlur"_s), backgroundBlurValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.deviceId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.displaySurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.echoCancellation));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.facingMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.frameRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.groupId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.height));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.logicalSurface)) {
        auto logicalSurfaceValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.logicalSurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "logicalSurface"_s), logicalSurfaceValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.powerEfficient)) {
        auto powerEfficientValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.powerEfficient));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "powerEfficient"_s), powerEfficientValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleSize));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.torch)) {
        auto torchValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.torch));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "torch"_s), torchValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.volume));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.whiteBalanceMode)) {
        auto whiteBalanceModeValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.whiteBalanceMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "whiteBalanceMode"_s), whiteBalanceModeValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.width));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.zoom)) {
        auto zoomValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.zoom));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<ConstrainBooleanParameters>> convertDictionary<ConstrainBooleanParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ConstrainBooleanParameters result;
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!exactValue.isUndefined()) {
        auto exactConversionResult = convert<IDLBoolean>(lexicalGlobalObject, exactValue);
        if (exactConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.exact = exactConversionResult.releaseReturnValue();
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!idealValue.isUndefined()) {
        auto idealConversionResult = convert<IDLBoolean>(lexicalGlobalObject, idealValue);
        if (idealConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.ideal = idealConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainBooleanParameters& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLBoolean::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.exact));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"_s), exactValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.ideal));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"_s), idealValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<ConstrainDOMStringParameters>> convertDictionary<ConstrainDOMStringParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ConstrainDOMStringParameters result;
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!exactValue.isUndefined()) {
        auto exactConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, exactValue);
        if (exactConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.exact = exactConversionResult.releaseReturnValue();
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!idealValue.isUndefined()) {
        auto idealConversionResult = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, idealValue);
        if (idealConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.ideal = idealConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainDOMStringParameters& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::extractValueFromNullable(dictionary.exact));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"_s), exactValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::extractValueFromNullable(dictionary.ideal));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"_s), idealValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<ConstrainDoubleRange>> convertDictionary<ConstrainDoubleRange>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ConstrainDoubleRange result;
    JSValue maxValue;
    if (isNullOrUndefined)
        maxValue = jsUndefined();
    else {
        maxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "max"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!maxValue.isUndefined()) {
        auto maxConversionResult = convert<IDLDouble>(lexicalGlobalObject, maxValue);
        if (maxConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.max = maxConversionResult.releaseReturnValue();
    }
    JSValue minValue;
    if (isNullOrUndefined)
        minValue = jsUndefined();
    else {
        minValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "min"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!minValue.isUndefined()) {
        auto minConversionResult = convert<IDLDouble>(lexicalGlobalObject, minValue);
        if (minConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.min = minConversionResult.releaseReturnValue();
    }
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!exactValue.isUndefined()) {
        auto exactConversionResult = convert<IDLDouble>(lexicalGlobalObject, exactValue);
        if (exactConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.exact = exactConversionResult.releaseReturnValue();
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!idealValue.isUndefined()) {
        auto idealConversionResult = convert<IDLDouble>(lexicalGlobalObject, idealValue);
        if (idealConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.ideal = idealConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainDoubleRange& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.max)) {
        auto maxValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.max));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "max"_s), maxValue);
    }
    if (!IDLDouble::isNullValue(dictionary.min)) {
        auto minValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.min));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "min"_s), minValue);
    }
    if (!IDLDouble::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.exact));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"_s), exactValue);
    }
    if (!IDLDouble::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.ideal));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"_s), idealValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<ConstrainLongRange>> convertDictionary<ConstrainLongRange>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ConstrainLongRange result;
    JSValue maxValue;
    if (isNullOrUndefined)
        maxValue = jsUndefined();
    else {
        maxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "max"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!maxValue.isUndefined()) {
        auto maxConversionResult = convert<IDLLong>(lexicalGlobalObject, maxValue);
        if (maxConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.max = maxConversionResult.releaseReturnValue();
    }
    JSValue minValue;
    if (isNullOrUndefined)
        minValue = jsUndefined();
    else {
        minValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "min"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!minValue.isUndefined()) {
        auto minConversionResult = convert<IDLLong>(lexicalGlobalObject, minValue);
        if (minConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.min = minConversionResult.releaseReturnValue();
    }
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!exactValue.isUndefined()) {
        auto exactConversionResult = convert<IDLLong>(lexicalGlobalObject, exactValue);
        if (exactConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.exact = exactConversionResult.releaseReturnValue();
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!idealValue.isUndefined()) {
        auto idealConversionResult = convert<IDLLong>(lexicalGlobalObject, idealValue);
        if (idealConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.ideal = idealConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainLongRange& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLLong::isNullValue(dictionary.max)) {
        auto maxValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.max));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "max"_s), maxValue);
    }
    if (!IDLLong::isNullValue(dictionary.min)) {
        auto minValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.min));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "min"_s), minValue);
    }
    if (!IDLLong::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.exact));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"_s), exactValue);
    }
    if (!IDLLong::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.ideal));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"_s), idealValue);
    }
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(MEDIA_STREAM)
