/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCompositeOperationOrAuto.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CompositeOperationOrAuto enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("replace"),
        MAKE_STATIC_STRING_IMPL("add"),
        MAKE_STATIC_STRING_IMPL("accumulate"),
        MAKE_STATIC_STRING_IMPL("auto"),
    };
    static_assert(static_cast<size_t>(CompositeOperationOrAuto::Replace) == 0, "CompositeOperationOrAuto::Replace is not 0 as expected");
    static_assert(static_cast<size_t>(CompositeOperationOrAuto::Add) == 1, "CompositeOperationOrAuto::Add is not 1 as expected");
    static_assert(static_cast<size_t>(CompositeOperationOrAuto::Accumulate) == 2, "CompositeOperationOrAuto::Accumulate is not 2 as expected");
    static_assert(static_cast<size_t>(CompositeOperationOrAuto::Auto) == 3, "CompositeOperationOrAuto::Auto is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CompositeOperationOrAuto enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CompositeOperationOrAuto> parseEnumerationFromString<CompositeOperationOrAuto>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, CompositeOperationOrAuto>, 4> mappings {
        std::pair<ComparableASCIILiteral, CompositeOperationOrAuto> { "accumulate"_s, CompositeOperationOrAuto::Accumulate },
        std::pair<ComparableASCIILiteral, CompositeOperationOrAuto> { "add"_s, CompositeOperationOrAuto::Add },
        std::pair<ComparableASCIILiteral, CompositeOperationOrAuto> { "auto"_s, CompositeOperationOrAuto::Auto },
        std::pair<ComparableASCIILiteral, CompositeOperationOrAuto> { "replace"_s, CompositeOperationOrAuto::Replace },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CompositeOperationOrAuto> parseEnumeration<CompositeOperationOrAuto>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CompositeOperationOrAuto>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<CompositeOperationOrAuto>()
{
    return "\"replace\", \"add\", \"accumulate\", \"auto\""_s;
}

} // namespace WebCore

